# Copyright 2015 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

import voluptuous as v

from grafana_dashboards.schema.panel.base import Base


class Dashlist(Base):

    def get_schema(self):
        dashlist = {
            v.Required('limit', default=10): v.All(int),
            v.Required('mode', default='starred'): v.Any('search', 'starred'),
            v.Required('tag', default=''): v.All(str),
            v.Required('query', default=''): v.All(str),
        }
        dashlist.update(self.base)
        return v.Schema(dashlist)
