angular.module("sb.auth",["sb.services","sb.templates","ui.router"]).config(function($stateProvider,$urlRouterProvider,AuthProviderResolver){"use strict";$urlRouterProvider.when("/auth","/auth/provider/list"),$urlRouterProvider.when("/auth/provider","/auth/provider/list"),$stateProvider.state("auth",{"abstract":!0,url:"/auth",template:"<div ui-view></div>"}).state("auth.provider",{"abstract":!0,url:"/provider",template:"<div ui-view></div>"}).state("auth.provider.list",{url:"/list",templateUrl:"app/templates/auth/provider/list.html",controller:"AuthListController",resolve:{authProviders:AuthProviderResolver.resolveAuthProviders}}).state("auth.provider.id",{url:"/:id",templateUrl:"app/templates/auth/provider/login.html",controller:"AuthLoginController",resolve:{authProvider:AuthProviderResolver.resolveAuthProvider("id")}})}),angular.module("sb.pages",["sb.services","sb.templates","sb.pages","ui.router"]).config(function($stateProvider){"use strict";$stateProvider.state("page",{"abstract":!0,url:"/page",template:"<div ui-view></div>"}).state("page.about",{url:"/about",templateUrl:"app/templates/page/about.html"})}),angular.module("sb.projects",["ui.router","sb.services","sb.util"]).config(function($stateProvider,$urlRouterProvider){"use strict";$urlRouterProvider.when("/project","/project/list"),$urlRouterProvider.when("/project/{id:[0-9]+}",function($match){return"/project/"+$match.id+"/overview"}),$stateProvider.state("project",{"abstract":!0,url:"/project",template:"<div ui-view></div>"}).state("project.list",{url:"/list",templateUrl:"app/templates/project/list.html",controller:"ProjectListController"}).state("project.detail",{"abstract":!0,url:"/{id:[0-9]+}",templateUrl:"app/templates/project/detail.html",controller:"ProjectDetailController"}).state("project.detail.overview",{url:"/overview",templateUrl:"app/templates/project/overview.html"}).state("project.detail.edit",{url:"/edit",templateUrl:"app/templates/project/edit.html"}).state("project.detail.delete",{url:"/delete",templateUrl:"app/templates/project/delete.html"}).state("project.detail.stories",{url:"/stories",templateUrl:"app/templates/project/stories.html",controller:"ProjectStoryListController"}).state("project.new",{url:"/new",templateUrl:"app/templates/project/new.html",controller:"ProjectNewController"})}),angular.module("sb.services",["ngResource","ngCookies"]),angular.module("sb.story",["ui.router","sb.services","sb.util"]).config(function($stateProvider,$urlRouterProvider){"use strict";$urlRouterProvider.when("/story","/story/list"),$urlRouterProvider.when("/story/{id:[0-9]+}",function($match){return"/story/"+$match.id+"/overview"}),$urlRouterProvider.when("/story/{storyId:[0-9]+}/task",function($match){return"/story/"+$match.storyId+"/overview"}),$urlRouterProvider.when("/story/{storyId:[0-9]+}/task/{taskId:[0-9]+}",function($match){return"/story/"+$match.storyId+"/task/"+$match.taskId}),$stateProvider.state("story",{"abstract":!0,url:"/story",template:"<div ui-view></div>"}).state("story.list",{url:"/list",templateUrl:"app/templates/story/list.html",controller:"StoryListController"}).state("story.detail",{url:"/{storyId:[0-9]+}","abstract":!0,templateUrl:"app/templates/story/detail.html",controller:"StoryDetailController"}).state("story.detail.overview",{url:"/overview",templateUrl:"app/templates/story/overview.html"}).state("story.detail.edit",{url:"/edit",templateUrl:"app/templates/story/edit.html"}).state("story.detail.delete",{url:"/delete",templateUrl:"app/templates/story/delete.html"})}),angular.module("storyboard",["sb.services","sb.templates","sb.pages","sb.projects","sb.auth","sb.story","ui.router","ui.bootstrap"]).config(function($provide,$stateProvider,$urlRouterProvider,$locationProvider,$httpProvider){"use strict";$urlRouterProvider.otherwise("/"),$locationProvider.hashPrefix("!"),$stateProvider.state("index",{url:"/",templateUrl:"app/templates/index.html",controller:"HomeController"}),$httpProvider.defaults.headers.common["X-Client"]="Storyboard"}).run(function($log,$rootScope,$location){"use strict";$rootScope.$on("$stateChangeError",function(){$location.path("/")})}),angular.module("sb.util",["ui.router"]),angular.module("sb.auth").controller("AuthListController",function($scope,authProviders,$state){"use strict";authProviders&&1===authProviders.length&&$state.go("auth.provider.id",{id:authProviders[0].id}),$scope.authProviders=authProviders}),angular.module("sb.auth").controller("AuthLoginController",function($scope,authProvider){"use strict";$scope.authProvider=authProvider}),angular.module("sb.projects").controller("ProjectDetailController",function($scope,$state,$stateParams,Project,Story){"use strict";function handleServiceError(error){$scope.error=error,$scope.isLoading=!1,$scope.isUpdating=!1}var id=$stateParams.hasOwnProperty("id")?parseInt($stateParams.id,10):null;$scope.project={},$scope.projectStoryCount=0,$scope.isLoading=!0,$scope.isUpdating=!1,$scope.error={},id||0===id?(Project.read({id:id},function(result){$scope.project=result,$scope.isLoading=!1},handleServiceError),Story.query({project:id},function(result,headers){$scope.projectStoryCount=headers("X-List-Total")||result.length},handleServiceError)):($scope.error={error:!0,error_code:404,error_message:"You did not provide a valid ID."},$scope.isLoading=!1),$scope.update=function(){$scope.isUpdating=!0,$scope.error={},$scope.project.$update(function(){$scope.isUpdating=!1,$state.go("project.detail",{id:$scope.project.id})},handleServiceError)}}),angular.module("sb.projects").controller("ProjectListController",function($scope,Project){"use strict";function resetScope(){$scope.projectCount=0,$scope.projectOffset=0,$scope.projectLimit=10,$scope.projects=[],$scope.error={}}$scope.searchQuery="",$scope.isSearching=!1,$scope.search=function(){resetScope(),$scope.isSearching=!0,Project.query({},function(result,headers){var projectCount=headers("X-List-Total")||result.length,projectOffset=headers("X-List-Offset")||0,projectLimit=headers("X-List-Limit")||result.length;$scope.projectCount=projectCount,$scope.projectOffset=projectOffset,$scope.projectLimit=projectLimit,$scope.projects=result,$scope.isSearching=!1},function(error){$scope.error=error,$scope.isSearching=!1})},resetScope(),$scope.search()}),angular.module("sb.projects").controller("ProjectNewController",function($scope,$state,Project){"use strict";$scope.newProject=new Project,$scope.isCreating=!1,$scope.error={},$scope.createProject=function(){$scope.isCreating=!0,$scope.error={},$scope.newProject.$create(function(){$state.go("project.list")},function(error){$scope.isCreating=!1,$scope.error=error})}}),angular.module("sb.projects").controller("ProjectStoryListController",function($scope,$state,$stateParams,Story,NewStoryService){"use strict";function resetScope(){$scope.storyCount=0,$scope.storyOffset=0,$scope.storyLimit=10,$scope.stories=[],$scope.error={}}var id=$stateParams.hasOwnProperty("id")?parseInt($stateParams.id,10):null;return null===id?void $state.go("index"):($scope.searchQuery="",$scope.isSearching=!1,$scope.search=function(){resetScope(),$scope.isSearching=!0,Story.query({project:id},function(result,headers){var storyCount=headers("X-List-Total")||result.length,storyOffset=headers("X-List-Offset")||0,storyLimit=headers("X-List-Limit")||result.length;$scope.storyCount=storyCount,$scope.storyOffset=storyOffset,$scope.storyLimit=storyLimit,$scope.stories=result,$scope.isSearching=!1},function(error){$scope.error=error,$scope.isSearching=!1})},$scope.newStory=function(){NewStoryService.showNewStoryModal(id)},resetScope(),void $scope.search())}),angular.module("sb.services").factory("httpErrorBroadcaster",function($q,$rootScope){"use strict";function sendEvent(status,body){status&&$rootScope.$broadcast("http_"+status,body||{})}return{response:function(response){return response&&sendEvent(response.status),response},responseError:function(response){return response&&sendEvent(response.status,response.data),$q.reject(response)}}}).config(function($httpProvider){"use strict";$httpProvider.interceptors.unshift("httpErrorBroadcaster")}),angular.module("sb.services").config(function($provide,$injector){"use strict";var propertyName="storyboardApiBase";if(!$injector.has(propertyName)){if(window.hasOwnProperty("ENV")){var ENV=window.ENV;if(null!==ENV&&ENV.hasOwnProperty(propertyName))return void $provide.constant(propertyName,ENV[propertyName])}return $("base").length>0?void $provide.constant(propertyName,""):void $provide.constant(propertyName,"/api/v1")}}),angular.module("sb.services").factory("storyboardApiSignature",function(){"use strict";return{create:{method:"POST"},read:{method:"GET",cache:!1},update:{method:"PUT"},"delete":{method:"DELETE"},query:{method:"GET",isArray:!0,responseType:"json"}}}),angular.module("sb.services").constant("AuthProviderResolver",{resolveAuthProviders:function($q,AuthProvider,$log){"use strict";$log.debug("Resolving AuthProviders");var deferred=$q.defer();return AuthProvider.query(function(result){deferred.resolve(result)},function(error){$log.warn("Route resolution rejected for AuthProviders"),deferred.reject(error)}),deferred.promise},resolveAuthProvider:function(stateParamName){"use strict";return function($q,AuthProvider,$stateParams,$log){var deferred=$q.defer();if($stateParams.hasOwnProperty(stateParamName)){var id=$stateParams[stateParamName];return $log.debug("Resolving AuthProvider: "+id),AuthProvider.get({id:id},function(result){deferred.resolve(result)},function(error){$log.warn("Route resolution rejected for AuthProvider "+id),deferred.reject(error)}),deferred.promise}$log.warn("State did not contain property of name "+stateParamName),deferred.reject({error:!0})}}}),angular.module("sb.services").factory("AuthProvider",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/auth/provider/:id",{id:"@id"},storyboardApiSignature)}),angular.module("sb.services").factory("Project",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/projects/:id",{id:"@id"},storyboardApiSignature)}),angular.module("sb.services").factory("ProjectGroup",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/project_groups/:id",{id:"@id"},storyboardApiSignature)}),angular.module("sb.services").factory("Story",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/stories/:id",{id:"@id"},storyboardApiSignature)}),angular.module("sb.services").factory("Task",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/tasks/:id",{id:"@id"},storyboardApiSignature)}),angular.module("sb.services").factory("Team",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/teams/:id",{id:"@id"},storyboardApiSignature)}),angular.module("sb.services").factory("User",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/users/:id",{id:"@id"},storyboardApiSignature)}),angular.module("sb.story").controller("StoryDetailController",function($scope,$state,$stateParams,Story,Task){"use strict";function handleServiceError(error){$scope.error=error,$scope.isLoading=!1,$scope.isUpdating=!1}function loadTasks(){$scope.tasks=[],Task.query({story:id},function(result){$scope.tasks=result},handleServiceError)}var id=$stateParams.hasOwnProperty("storyId")?parseInt($stateParams.storyId,10):null;$scope.story={},$scope.tasks=[],$scope.newTask=new Task,$scope.isLoading=!0,$scope.isUpdating=!1,$scope.error={},id||0===id?(Story.read({id:id},function(result){$scope.story=result,$scope.isLoading=!1},handleServiceError),loadTasks()):($scope.error={error:!0,error_code:404,error_message:"You did not provide a valid ID."},$scope.isLoading=!1),$scope.addTask=function(){$scope.newTask.story_id=id,$scope.newTask.$save(function(){loadTasks(),$scope.newTask=new Task})},$scope.update=function(){$scope.isUpdating=!0,$scope.error={},$scope.story.$update(function(result){$scope.isUpdating=!1,$state.go("story.detail.overview",{storyId:result.id})},handleServiceError)}}),angular.module("sb.story").controller("StoryListController",function($scope,$modal,NewStoryService,Story){"use strict";function resetScope(){$scope.storyCount=0,$scope.storyOffset=0,$scope.storyLimit=10,$scope.stories=[],$scope.error={}}$scope.newStory=function(){NewStoryService.showNewStoryModal()},$scope.searchQuery="",$scope.isSearching=!1,$scope.search=function(){resetScope(),$scope.isSearching=!0,Story.query({},function(result,headers){var storyCount=headers("X-List-Total")||result.length,storyOffset=headers("X-List-Offset")||0,storyLimit=headers("X-List-Limit")||result.length;$scope.storyCount=storyCount,$scope.storyOffset=storyOffset,$scope.storyLimit=storyLimit,$scope.stories=result,$scope.isSearching=!1},function(error){$scope.error=error,$scope.isSearching=!1})},resetScope(),$scope.search()}),angular.module("sb.story").controller("StoryModalController",function($scope,$modalInstance,params,Project,Story){"use strict";$scope.story=new Story,$scope.projects=Project.query({},function(results){if(null!==params.projectId)for(var i=0;i<results.length;i++){var project=results[i];if(project.id===params.projectId)return void($scope.project=project)}}),$scope.save=function(){$scope.story.$create(function(){$modalInstance.dismiss("success")})},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.story").factory("NewStoryService",function($modal,$log){"use strict";return{showNewStoryModal:function(projectId){var modalInstance=$modal.open({templateUrl:"app/templates/story/new.html",controller:"StoryModalController",resolve:{params:function(){return{projectId:projectId||null}}}});modalInstance.result.then(function(){},function(){$log.info("Modal dismissed at: "+new Date)})}}}),angular.module("storyboard").controller("HeaderController",function($scope,$modal,NewStoryService){"use strict";$scope.newStory=function(){NewStoryService.showNewStoryModal()}}),angular.module("storyboard").controller("HomeController",function($scope,$modal,NewStoryService){"use strict";$scope.newStory=function(){NewStoryService.showNewStoryModal()}}),angular.module("sb.util").directive("activePath",function($location,$rootScope){"use strict";return{link:function($scope,element,attrs){function setActivePath(){var path=$location.path(),isMatchedPath=null!==path.match(activePath);element.toggleClass("active",isMatchedPath)}var activePath=attrs.activePath,disconnectBinding=$rootScope.$on("$stateChangeSuccess",setActivePath);$scope.$on("$destroy",disconnectBinding),setActivePath()}}}),angular.module("sb.util").directive("ngEnter",function(){"use strict";return function(scope,element,attrs){element.bind("keydown keypress",function(event){13===event.which&&(scope.$apply(function(){scope.$eval(attrs.ngEnter)}),event.preventDefault())})}}),angular.module("sb.util").filter("debug",function(){"use strict";return function(value){return console.warn("DEBUG",value),value}});