angular.module("sb.templates",["app/templates/auth/busy.html","app/templates/auth/error.html","app/templates/auth/modal/login_required.html","app/templates/dashboard/index.html","app/templates/main_menu.html","app/templates/page/about.html","app/templates/profile/preferences.html","app/templates/project/detail.html","app/templates/project/list.html","app/templates/project/new.html","app/templates/story/comments/story_created.html","app/templates/story/comments/story_details_changed.html","app/templates/story/comments/task_assignee_changed.html","app/templates/story/comments/task_created.html","app/templates/story/comments/task_deleted.html","app/templates/story/comments/task_details_changed.html","app/templates/story/comments/task_status_changed.html","app/templates/story/comments/template_switch.html","app/templates/story/comments/user_comment.html","app/templates/story/delete.html","app/templates/story/delete_task.html","app/templates/story/detail.html","app/templates/story/list.html","app/templates/story/new.html","app/templates/story/story_list_item.html","app/templates/story/task_edit_form.html","app/templates/util/story_status_label.html","app/templates/util/tag_complete.html","app/templates/util/tag_input.html","app/templates/util/task_status_dropdown.html"]),angular.module("app/templates/auth/busy.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/auth/busy.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~         http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="container">\n    <div class="row">\n        <div class="col-xs-12">\n            <p class="text-center text-muted">\n                <br/>\n                <i class="fa fa-refresh fa-lg fa-spin"></i>\n            </p>\n        </div>\n    </div>\n</div>')}]),angular.module("app/templates/auth/error.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/auth/error.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~         http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="container">\n    <div class="row">\n        <div class="col-xs-12">\n            <h1>Oh no!</h1>\n\n            <p class="lead">We encountered an unexpected error while trying to\n                log you in. The error message below should be helpful,\n                though if it\'s not you can contact our engineers in\n                #storyboard on\n                <a href="http://freenode.net/" target="_blank">\n                    Freenode\n                </a>.\n            </p>\n\n            <dl class="dl-horizontal text-danger">\n                <dt>Error Code:</dt>\n                <dd>{{error}}</dd>\n                <dt>Error Description:</dt>\n                <dd>{{errorDescription}}</dd>\n            </dl>\n\n            <!-- TODO(krotscheck): If a user reaches this point, they should\n            be easily able to submit a bug report to storyboard -->\n        </div>\n    </div>\n</div>')}]),angular.module("app/templates/auth/modal/login_required.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/auth/modal/login_required.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~         http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n<div class="panel panel-default">\n    <div class="panel-heading">\n        <button type="button" class="close" aria-hidden="true"\n                ng-click="close()">&times;</button>\n        <h3 class="panel-title">Authentication required</h3>\n    </div>\n    <div class="panel-body">\n        <div class="row">\n            <div class="col-xs-12 text-center">\n                <a href="" class="btn btn-primary btn-lg" ng-click="login()">\n                    Please log in\n                </a>\n            </div>\n        </div>\n    </div>\n</div>')}]),angular.module("app/templates/dashboard/index.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/dashboard/index.html",'<div class="container">\n    <div class="row">\n        <div class="col-sm-12">\n            <h1>StoryBoard</h1>\n\n            <p class="lead">A task tracking system for inter-related\n                projects.</p>\n        </div>\n    </div>\n</div>')}]),angular.module("app/templates/main_menu.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/main_menu.html",'<!--\n  ~ Copyright (c) 2013 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ 	http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div ng-controller="HeaderController">\n\n    <!-- New story button for the mobile view -->\n    <div class="container-fluid">\n        <button type="button"\n                ng-click="newStory()"\n                class="new-story-button btn btn-sm btn-primary btn-block">\n            <i class="fa fa-plus"></i>\n            <span class="hidden-xs">New Story</span>\n        </button>\n    </div>\n\n    <ul class="nav nav-pilltabs nav-stacked">\n        <li active-path="^\\/$">\n            <a href="#!/">\n                <span class="hidden-xs">Overview</span>\n                <i class="fa fa-home visible-xs"></i>\n            </a>\n        </li>\n        <li active-path="^\\/project\\/*">\n            <a href="#!/project">\n                <span class="hidden-xs">Projects</span>\n                <i class="fa fa-briefcase visible-xs"></i>\n            </a>\n        </li>\n        <li active-path="^\\/story.*">\n            <a href="#!/story">\n                <span class="hidden-xs">Stories</span>\n                <i class="fa fa-file visible-xs"></i>\n            </a>\n        </li>\n    </ul>\n    <hr/>\n    <ul class="nav nav-pilltabs nav-stacked">\n        <li active-path="^\\/profile\\/preferences*">\n            <a href="#!/profile/preferences" ng-show="isLoggedIn">\n                <span class="hidden-xs"\n                      ng-show="currentUser.$resolved">\n                    {{currentUser.full_name}}\n                </span>\n                <em class="hidden-xs text-muted"\n                      ng-hide="currentUser.$resolved">\n                    Loading...\n                </em>\n                <i class="fa fa-user visible-xs"></i>\n            </a>\n        </li>\n        <li>\n            <a href="#!/auth/authorize" ng-hide="isLoggedIn">\n                <span class="hidden-xs">Log in</span>\n                <i class="fa fa-sign-in visible-xs"></i>\n            </a>\n            <a href="" ng-click="logout()" ng-show="isLoggedIn">\n                <span class="hidden-xs">Log out</span>\n                <i class="fa fa-sign-out visible-xs"></i>\n            </a>\n        </li>\n    </ul>\n\n    <ul class="nav nav-links nav-stacked navbar-bottom nav-small hidden-xs">\n        <li active-path="^\\/page\\/about.*$" class="text-right">\n            <a href="#!/page/about">\n                <span class="hidden-xs">About</span>\n                <i class="fa fa-question-circle visible-xs"></i>\n            </a>\n        </li>\n        <li class="text-right">\n            <a href="http://www.apache.org/licenses/LICENSE-2.0"\n               target="_blank">\n                <span class="hidden-xs">License</span>\n                <i class="fa fa-exclamation-circle visible-xs"></i>\n            </a>\n        </li>\n        <li class="text-center">\n            <small class="text-muted">\n                Powered&nbsp;by&nbsp;StoryBoard\n            </small>\n        </li>\n    </ul>\n</div>\n')}]),angular.module("app/templates/page/about.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/page/about.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ 	http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="container">\n    <div class="row">\n        <div class="col-xs-12">\n            <h1>StoryBoard</h1>\n\n            <p class="lead">A task tracking system for inter-related\n                projects.</p>\n\n        </div>\n    </div>\n    <div class="row">\n        <div class="col-sm-8">\n\n            <h2>Stories</h2>\n\n            <p>It all begins with a <strong>story</strong>. A story is a\n                bug report or proposed feature. Stories are then further\n                split into <strong>tasks</strong>, which affect a given\n                project and branch. You can easily track backports of\n                bugs to a specific branch, or plan cross-project\n                features.</p>\n            <a href="#!/story" class="btn btn-primary">\n                Access Stories\n                <i class="fa fa-chevron-right"></i>\n            </a>\n\n            <h2>Projects</h2>\n\n            <p>StoryBoard lets you efficiently track your work across a\n                large number of interrelated projects. Flexible\n                <strong>project groups</strong> lets you get the views\n                that makes the most sense to you.</p>\n            <a href="#!/project" class="btn btn-primary">\n                Access Projects\n                <i class="fa fa-chevron-right"></i>\n            </a>\n\n            <h2>But why?</h2>\n            <p>The OpenStack project has run into a number of limitations\n	        with existing tools; in particular, the workflow needed by\n	        a highly-distributed system that spans multiple projects\n	        is not well served.  This system uses the best concepts\n	        from existing tools and goes beyond to support the needs\n	        of the OpenStack project.</p>\n        <p><a href="http://git.openstack.org/cgit/openstack-infra/storyboard/tree/README.rst"\n               target="_blank"\n               class="btn btn-primary">\n                See project README\n                <i class="fa fa-chevron-right"></i>\n            </a>\n        </div>\n        <div class="col-sm-4">\n            <hr class="visible-xs"/>\n            <h4>Contributing</h4>\n\n            <p>StoryBoard is open source! If you would like to contribute to\n                the development of StoryBoard, you must follow the steps in the\n                "If you\'re a developer, start here" section of this page:</p>\n\n            <p><a href=" http://wiki.openstack.org/HowToContribute"\n                  target="_blank">\n                http://wiki.openstack.org/HowToContribute\n            </a></p>\n\n            <hr/>\n            <h4>Attribution</h4>\n\n            <p>StoryBoard was built with the help of the following openly\n                licensed projects.</p>\n\n            <p><strong>FontAwesome </strong></p>\n\n            <p><a href="http://fontawesome.io/" target="_blank">\n                The iconic font designed for Bootstrap\n            </a></p>\n\n            <p><strong>AngularJS</strong></p>\n\n            <p><a href="http://angularjs.org/" target="_blank">\n                Superheroic JavaScript Framework\n            </a></p>\n\n            <p><strong>Bootstrap</strong></p>\n\n            <p><a href="http://getbootstrap.com/" target="_blank">\n                Mobile first front-end framework\n            </a></p>\n\n        </div>\n    </div>\n</div>\n</div>\n')}]),angular.module("app/templates/profile/preferences.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/profile/preferences.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~         http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="container" ng-hide="isLoading">\n    <div class="row">\n        <div class="col-xs-12">\n            <h1>Preferences</h1>\n        </div>\n    </div>\n    <div class="row">\n        <div class="col-md-6">\n            <form name="preferencesForm">\n                <div class="form-group">\n                    <label>Page size</label>\n\n                    <p class="help-block">\n                        How many results would you like to see when viewing\n                        lists?\n                    </p>\n\n                    <div>\n                        <input type="radio" name="pageSize"\n                               id="pageSize10" value="10"\n                               ng-model="pageSize">\n                        <label for="pageSize10">10</label>\n                        &nbsp;\n                        <input type="radio" name="pageSize"\n                               id="pageSize25" value="25"\n                               ng-model="pageSize">\n                        <label for="pageSize25">25</label>\n                        &nbsp;\n                        <input type="radio" name="pageSize"\n                               id="pageSize50" value="50"\n                               ng-model="pageSize">\n                        <label for="pageSize50">50</label>\n                        &nbsp;\n                        <input type="radio" name="pageSize"\n                               id="pageSize100" value="100"\n                               ng-model="pageSize">\n                        <label for="pageSize100">100</label>\n                    </div>\n                </div>\n\n                <hr/>\n\n                <div class="form-group">\n                    <label>Timeline events</label>\n\n                    <p class="help-block">\n                        Which types of Timeline events would you like to be\n                        displayed?\n                    </p>\n\n                    <div>\n                        <input type="checkbox" name="enabledTypes"\n                               id="storyCreated"\n                               ng-model="enabled_event_types.story_created">\n                        <label for="storyCreated">Story created</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="storyDetailsChanged"\n                               ng-model="enabled_event_types.story_details_changed">\n                        <label for="storyDetailsChanged">Story details changed</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="taskCreated"\n                               ng-model="enabled_event_types.task_created">\n                        <label for="taskCreated">Task created</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="taskAssigneeChanged"\n                               ng-model="enabled_event_types.task_assignee_changed">\n                        <label for="taskAssigneeChanged">Task assignee changed</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="taskStatusChanged"\n                               ng-model="enabled_event_types.task_status_changed">\n                        <label for="taskStatusChanged">Task status changed</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="taskDetailsChanged"\n                               ng-model="enabled_event_types.task_details_changed">\n                        <label for="taskDetailsChanged">Task details Changed</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="taskDeleted"\n                               ng-model="enabled_event_types.task_deleted">\n                        <label for="taskDeleted">Task deleted</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="userComment"\n                               ng-model="enabled_event_types.user_comment">\n                        <label for="userComment">User comment</label>\n                    </div>\n                </div>\n\n                <hr/>\n\n                <div class="form-group">\n                    <button type="button" class="btn btn-default"\n                            ng-click="save()">\n                        Save\n                    </button>\n                    <p class="help-block text-success">{{message}}</p>\n                </div>\n            </form>\n        </div>\n    </div>\n</div>\n')}]),angular.module("app/templates/project/detail.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/project/detail.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~         http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="container">\n    <div class="row">\n        <div ng-include\n             class="col-xs-12"\n             src="\'/inline/project_detail.html\'"\n             ng-hide="showEditForm">\n        </div>\n        <div ng-include\n             src="\'/inline/project_detail_form.html\'"\n             ng-show="showEditForm">\n        </div>\n        <div ng-include src="\'/inline/story_list.html\'"></div>\n    </div>\n</div>\n\n\n<!-- Template for the header and description -->\n<script type="text/ng-template" id="/inline/project_detail.html">\n    <h1>\n        <span ng-show="project.name">\n            {{project.name}}\n        </span>\n        <em ng-hide="project.name" class="text-muted">\n            No title\n        </em>\n        <small ng-show="isLoggedIn">\n            <a href="" ng-click="toggleEditMode()" permission="is_superuser">\n                <i class="fa fa-pencil"></i>\n            </a>\n        </small>\n    </h1>\n    <p>\n        <span ng-show="project.description"\n              class="honor-carriage-return">{{project.description}}\n        </span>\n        <em ng-hide="project.description" class="text-muted">\n            No description provided\n        </em>\n    </p>\n</script>\n\n\n<!-- Template for the header and description -->\n<script type="text/ng-template" id="/inline/project_detail_form.html">\n    <br/>\n    <form name="projectForm">\n        <div class="form-group">\n            <input type="text"\n                      class="form-control"\n                      ng-model="project.name"\n                      required\n                      ng-disabled="isUpdating"\n                      placeholder="Project Name">\n            </input>\n        </div>\n        <div class="form-group">\n            <textarea placeholder="Enter a project description here"\n                      class="form-control"\n                      rows="3"\n                      msd-elastic\n                      required\n                      ng-disabled="isUpdating"\n                      ng-model="project.description">\n            </textarea>\n        </div>\n\n        <div class="clearfix">\n            <div class="pull-right">\n                <div class="btn" ng-show="isUpdating">\n                    <i class="fa fa-spinner fa-lg fa-spin"></i>\n                </div>\n                <button type="button"\n                        class="btn btn-primary"\n                        ng-click="update()"\n                        ng-disabled="!projectForm.$valid">\n                    Save\n                </button>\n                <button type="button"\n                        class="btn btn-default"\n                        ng-click="cancel()">\n                    Cancel\n                </button>\n            </div>\n        </div>\n    </form>\n    <hr/>\n</script>\n\n<!-- Template for the task list -->\n<script type="text/ng-template" id="/inline/story_list.html">\n    <div ng-controller="ProjectStoryListController">\n        <div class="col-xs-12">\n            <a href=""\n               class="btn btn-link pull-right"\n               ng-click="newStory()"\n               ng-show="isLoggedIn">\n                <i class="fa fa-plus"></i>\n                Add story\n            </a>\n            <ul class="nav nav-tabs clearfix">\n                <li ng-class="{\'active\': filter == \'active\'}">\n                    <a href=""\n                       ng-click="setFilter(\'active\')">Active</a>\n                </li>\n                <li ng-class="{\'active\': filter == \'merged\'}">\n                    <a href=""\n                       ng-click="setFilter(\'merged\')">Merged</a>\n                </li>\n                <li ng-class="{\'active\': filter == \'invalid\'}">\n                    <a href=""\n                       ng-click="setFilter(\'invalid\')">Invalid</a>\n                </li>\n            </ul>\n            <table class="table table-striped"\n                   ng-hide="isSearching || stories.length == 0">\n                <tbody>\n                <tr ng-repeat="story in stories"\n                    ng-controller="StoryListItemController"\n                    ng-include="\'app/templates/story/story_list_item.html\'">\n                </tr>\n                </tbody>\n            </table>\n\n            <div ng-show="isSearching">\n                <hr/>\n                <p class="text-center">\n                    <i class="fa fa-refresh fa-spin fa-lg"></i>\n                </p>\n            </div>\n\n            <p ng-show="!isSearching && stories.length == 0"\n               class="text-center text-warning">\n                <br/>\n                <em> We were unable to find any stories.\n                    Perhaps you would like to create one?</em>\n            </p>\n        </div>\n    </div>\n</script>\n\n')}]),angular.module("app/templates/project/list.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/project/list.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ 	http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n<div class="container">\n    <div class="row">\n        <div class="col-xs-12">\n            <h1>{{projectCount}} Projects</h1>\n        </div>\n    </div>\n    <div class="row">\n        <div class="col-sm-9 col-sm-offset-3 col-xs-2 col-xs-offset-10">\n            <a href="#!/project/new" permission="is_superuser"\n               class="pull-right btn btn-default btn-sm">\n                <i class="fa fa-plus"></i>\n                <span class="hidden-xs">New Project</span>\n            </a>\n        </div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12">\n            <div ng-show="isSearching">\n                <hr/>\n                <p class="text-center">\n                    <i class="fa fa-refresh fa-spin fa-lg"></i>\n                </p>\n            </div>\n\n            <p ng-show="!isSearching && projects.length == 0"\n               class="text-center text-warning">\n                <em> We were unable to find any projects.</em>\n            </p>\n\n            <table class="table table-striped"\n                   ng-hide="isSearching || projects.length == 0">\n                <thead>\n                <tr>\n                    <th class="col-sm-10">&nbsp;</th>\n                </tr>\n                </thead>\n                <tbody>\n                <tr ng-repeat="project in projects">\n                    <td>\n                        <p><strong>\n                            <a href="#!/project/{{project.id}}">\n                                {{project.name}}\n                            </a>\n                        </strong></p>\n                        <small class="text-muted honor-carriage-return"\n                                >{{project.description}}</small>\n                    </td>\n                </tr>\n                </tbody>\n            </table>\n        </div>\n    </div>\n</div>\n')}]),angular.module("app/templates/project/new.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/project/new.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~         http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="container">\n    <div class="row">\n        <div class="col-xs-12">\n            <h1>New Project</h1>\n        </div>\n    </div>\n    <div class="row">\n        <div class="col-xs-12">\n            <form class="form-horizontal" role="form" name="projectForm">\n                <div class="form-group">\n                    <label for="name" class="col-sm-2 control-label">\n                        Project Name:\n                    </label>\n\n                    <div class="col-sm-10">\n                        <input id="name"\n                               type="text"\n                               class="form-control"\n                               ng-model="newProject.name"\n                               required\n                               placeholder="Project Name">\n                    </div>\n                </div>\n                <div class="form-group">\n                    <label for="description"\n                           class="col-sm-2 control-label">\n                        Project Description\n                    </label>\n\n                    <div class="col-sm-10">\n                        <textarea id="description"\n                                  class="form-control"\n                                  ng-model="newProject.description"\n                                  msd-elastic\n                                  required\n                                  placeholder="A brief project description">\n                        </textarea>\n                    </div>\n                </div>\n                <div class="form-group">\n                    <div class="col-sm-offset-2 col-sm-10">\n                        <button type="button"\n                                ng-click="createProject()"\n                                class="btn btn-primary"\n                                ng-disabled="!projectForm.$valid">\n                            Create project\n                        </button>\n                        <a href="#!/project/list"\n                           class="btn btn-default">\n                            Cancel\n                        </a>\n                    </div>\n                </div>\n            </form>\n        </div>\n    </div>\n</div>\n')}]),angular.module("app/templates/story/comments/story_created.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/story/comments/story_created.html",'<div class="discussion-comment" ng-show="enabled_event_types.story_created">\n    <p class="discussion-comment-author">\n        {{ author.full_name }} has created this story.\n         <span class="pull-right">{{event.created_at | date: \'medium\'}}</span>\n    </p>\n</div>')}]),angular.module("app/templates/story/comments/story_details_changed.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/story/comments/story_details_changed.html",'<div class="discussion-comment" ng-show="enabled_event_types.story_details_changed">\n    <p class="discussion-comment-author">\n        {{ author.full_name }} has updated this story.\n         <span class="pull-right">{{event.created_at | date: \'medium\'}}</span>\n    </p>\n</div>')
}]),angular.module("app/templates/story/comments/task_assignee_changed.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/story/comments/task_assignee_changed.html",'<div class="discussion-comment" ng-show="enabled_event_types.task_assignee_changed">\n    <p class="discussion-comment-author">\n        {{author.full_name}} has updated assignee for task {{ event_info.task_title }}:\n        {{ event_info.old_assignee_fullname }} ==> {{ event_info.new_assignee_fullname }}\n         <span class="pull-right">{{event.created_at | date: \'medium\'}}</span>\n    </p>\n</div>')}]),angular.module("app/templates/story/comments/task_created.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/story/comments/task_created.html",'<div class="discussion-comment" ng-show="enabled_event_types.task_created">\n    <p class="discussion-comment-author">\n        {{ author.full_name }} has created a task {{ event_info.task_title }}\n         <span class="pull-right">{{event.created_at | date: \'medium\'}}</span>\n    </p>\n</div>')}]),angular.module("app/templates/story/comments/task_deleted.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/story/comments/task_deleted.html",'<div class="discussion-comment" ng-show="enabled_event_types.task_deleted">\n    <p class="discussion-comment-author">\n        {{ author.full_name }} has deleted a task {{ event_info.task_title }}\n         <span class="pull-right">{{event.created_at | date: \'medium\'}}</span>\n    </p>\n</div>')}]),angular.module("app/templates/story/comments/task_details_changed.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/story/comments/task_details_changed.html",'<div class="discussion-comment" ng-show="enabled_event_types.task_details_changed">\n    <p class="discussion-comment-author">\n        {{ author.full_name }} has updated {{ event_info.task_title }}\n         <span class="pull-right">{{event.created_at | date: \'medium\'}}</span>\n    </p>\n</div>')}]),angular.module("app/templates/story/comments/task_status_changed.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/story/comments/task_status_changed.html",'<div class="discussion-comment" ng-show="enabled_event_types.task_status_changed">\n    <p class="discussion-comment-author">\n        {{author.full_name}} has updated a task {{ event_info.task_title }} status:\n        {{ event_info.old_status }} ==> {{ event_info.new_status }}\n         <span class="pull-right">{{event.created_at | date: \'medium\'}}</span>\n    </p>\n</div>')}]),angular.module("app/templates/story/comments/template_switch.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/story/comments/template_switch.html",'<div ng-switch="event_type">\n    <div ng-switch-when="story_created">\n        <div ng-include src="\'app/templates/story/comments/story_created.html\'"></div>\n    </div>\n    <div ng-switch-when="story_details_changed">\n        <div ng-include src="\'app/templates/story/comments/story_details_changed.html\'"></div>\n    </div>\n    <div ng-switch-when="task_assignee_changed">\n        <div ng-include src="\'app/templates/story/comments/task_assignee_changed.html\'"></div>\n    </div>\n    <div ng-switch-when="task_created">\n        <div ng-include src="\'app/templates/story/comments/task_created.html\'"></div>\n    </div>\n    <div ng-switch-when="task_deleted">\n        <div ng-include src="\'app/templates/story/comments/task_deleted.html\'"></div>\n    </div>\n    <div ng-switch-when="task_details_changed">\n        <div ng-include src="\'app/templates/story/comments/task_details_changed.html\'"></div>\n    </div>\n    <div ng-switch-when="task_status_changed">\n        <div ng-include src="\'app/templates/story/comments/task_status_changed.html\'"></div>\n    </div>\n    <div ng-switch-when="user_comment">\n        <div ng-include src="\'app/templates/story/comments/user_comment.html\'"></div>\n    </div>\n    <div ng-switch-default>\n        <div class="discussion-comment">\n            <p class="discussion-comment-author">\n                Event of unknown type has occurred.\n                 <span class="pull-right">{{event.created_at | date: \'medium\'}}</span>\n            </p>\n        </div>\n    </div>\n\n</div>')}]),angular.module("app/templates/story/comments/user_comment.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/story/comments/user_comment.html",'<div class="discussion-comment" ng-show="enabled_event_types.user_comment">\n    <p class="discussion-comment-author">\n        {{ author.full_name }}\n        <span class="pull-right">{{event.created_at | date: \'medium\'}}</span>\n    </p>\n\n    <p ng-show="event.comment.content"\n       class="honor-carriage-return">{{event.comment.content}}\n    </p>\n\n    <p><em ng-hide="event.comment.content"\n           class="text-muted">\n        The author left a blank comment.\n    </em></p>\n</div>')}]),angular.module("app/templates/story/delete.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/story/delete.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~         http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n<div class="panel panel-default">\n    <div class="panel-heading">\n        <button type="button" class="close" aria-hidden="true"\n                ng-click="close()">&times;</button>\n        <h3 class="panel-title">{{story.title}}</h3>\n    </div>\n    <div class="panel-body">\n        <div class="row">\n            <div class="col-sm-8 col-sm-offset-2">\n                <h2 class="text-danger text-center">\n                    Are you certain that you want to delete this story?\n                </h2>\n\n                <p class="text-center lead">\n                    This action cannot be undone.\n                </p>\n\n                <div class="text-center">\n                    <a href="" class="btn btn-danger" ng-click="remove()">\n                        Remove this story\n                    </a>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>')}]),angular.module("app/templates/story/delete_task.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/story/delete_task.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~         http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n<div class="panel panel-default">\n    <div class="panel-heading">\n        <button type="button" class="close" aria-hidden="true"\n                ng-click="close()">&times;</button>\n        <h3 class="panel-title">{{task.title}}</h3>\n    </div>\n    <div class="panel-body">\n        <div class="row">\n            <div class="col-sm-8 col-sm-offset-2">\n                <h2 class="text-danger text-center">\n                    Are you certain that you want to delete this task?\n                </h2>\n\n                <p class="text-center lead">\n                    This action cannot be undone.\n                </p>\n\n                <div class="text-center">\n                    <a href="" class="btn btn-danger" ng-click="remove()">\n                        Remove this task\n                    </a>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>')}]),angular.module("app/templates/story/detail.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/story/detail.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~         http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="container" ng-controller="StoryDetailController">\n    <div class="row">\n        <div class="col-xs-12">\n            <div ng-include\n                 src="\'/inline/story_detail.html\'"\n                 ng-hide="showEditForm">\n            </div>\n            <div ng-include\n                 src="\'/inline/story_detail_form.html\'"\n                 ng-show="showEditForm">\n            </div>\n            <div ng-include src="\'/inline/task_list.html\'"></div>\n            <hr/>\n            <div ng-include src="\'/inline/discussion.html\'"></div>\n        </div>\n    </div>\n</div>\n\n\n<!-- Template for the header and description -->\n<script type="text/ng-template" id="/inline/story_detail.html">\n    <h1>\n\n        <span ng-show="story.title">\n            {{story.title}}\n        </span>\n        <em ng-hide="story.title" class="text-muted">\n            No title\n        </em>\n        <small ng-show="isLoggedIn">\n            <a href="" ng-click="toggleEditMode()" >\n                <i class="fa fa-pencil"></i>\n            </a>\n        </small>\n    </h1>\n    <p><strong>Author:</strong>\n        <em ng-show="!story.creator_id" class="text-muted">\n            None\n        </em>\n        <span ng-show="story.creator_id && !creator.$resolved">\n            <i class="fa fa-refresh fa-spin"></i>\n        </span>\n        <span ng-show="creator.full_name">\n            {{creator.full_name}}\n        </span>\n        <br/>\n        <strong>Last updated:</strong>\n        <span ng-show="story.updated_at">\n            {{story.updated_at | date: \'longDate\'}}\n        </span>\n        <span ng-show="!story.updated_at && story.created_at">\n            {{story.created_at | date: \'longDate\'}}\n        </span>\n        <em ng-hide="story.updated_at || story.created_at" class="text-muted">\n            Never\n        </em>\n    </p>\n    <p>\n        <span ng-show="story.description"\n              class="honor-carriage-return">{{story.description}}\n        </span>\n        <em ng-hide="story.description" class="text-muted">\n            No description provided\n        </em>\n    </p>\n</script>\n\n\n<!-- Template for the header and description -->\n<script type="text/ng-template" id="/inline/story_detail_form.html">\n    <form name="storyForm">\n        <div class="form-group">\n            <textarea type="text"\n                      class="form-control context-edit h1"\n                      ng-model="story.title"\n                      required\n                      ng-disabled="isUpdating"\n                      placeholder="Story Title">\n            </textarea>\n        </div>\n        <div class="form-group">\n            <textarea placeholder="Enter a story description here"\n                      class="form-control context-edit"\n                      msd-elastic\n                      rows="3"\n                      required\n                      ng-disabled="isUpdating"\n                      ng-model="story.description">\n            </textarea>\n        </div>\n\n        <div class="clearfix">\n            <div class="pull-right">\n                <div class="btn" ng-show="isUpdating">\n                    <i class="fa fa-spinner fa-lg fa-spin"></i>\n                </div>\n                <button type="button"\n                        class="btn btn-primary"\n                        ng-click="update()"\n                        ng-disabled="!storyForm.$valid">\n                    Save\n                </button>\n                <button type="button"\n                        class="btn btn-default"\n                        ng-click="cancel()">\n                    Cancel\n                </button>\n            </div>\n            <button type="button"\n                    class="btn btn-link"\n                    ng-click="remove()">\n                Remove this story\n            </button>\n        </div>\n    </form>\n</script>\n\n\n<!-- Template for the task list -->\n<script type="text/ng-template" id="/inline/task_list.html">\n    <table class="table table-striped"\n           ng-controller="StoryTaskListController">\n        <thead>\n        <tr>\n            <td colspan="3"><strong>Tasks</strong></td>\n            <td colspan="3" class="text-right">\n                <small>\n                    <a href=""\n                       ng-click="showAddTaskForm = !showAddTaskForm"\n                       ng-show="isLoggedIn">\n                        <i class="fa fa-plus"></i>\n                        Add task\n                    </a>\n                </small>\n            </td>\n        </tr>\n        </thead>\n        <tbody>\n        <tr ng-repeat="task in tasks"\n            ng-include\n            src="\'/inline/task_list_item.html\'"\n            ng-controller="StoryTaskListItemController">\n        </tr>\n        <tr ng-show="tasks.length == 0 && !showAddTaskForm">\n            <td colspan="6">\n                <p class="text-muted text-center">\n                    <em>This story has no tasks.</em>\n                </p>\n            </td>\n        </tr>\n        </tbody>\n        <tfoot ng-show="showAddTaskForm">\n        <tr>\n            <td></td>\n            <td colspan="3">\n                <task-edit-form\n                        task="newTask"\n                        button-label="Add Task"\n                        on-button-click="addTask()"\n                        />\n            </td>\n            <td colspan="2"></td>\n        </tr>\n        </tfoot>\n\n    </table>\n</script>\n\n\n<!-- Template for the task list -->\n<script type="text/ng-template" id="/inline/discussion.html">\n    <div ng-controller="StoryDiscussionController">\n        <h4>Events timeline</h4>\n\n        <div class="discussion">\n            <div class="alert alert-warning"\n                 ng-show="comments.length == 0">\n                The discussion hasn\'t started yet\n            </div>\n            <div ng-repeat="event in events"\n                 ng-controller="StoryDiscussionItemController">\n                <timeline-event tl_event={{event}}/>\n            </div>\n\n            <form class="discussion-comment-form comment"\n                  id="commentForm"\n                  name="commentForm"\n                  ng-show="isLoggedIn">\n                <div class="form-group">\n                    <textarea id="comment"\n                              placeholder="Enter your comment here"\n                              class="form-control"\n                              msd-elastic\n                              rows="3"\n                              required\n                              ng-disabled="isSavingComment"\n                              ng-shift-enter="addComment()"\n                              ng-model="newComment.content">\n                    </textarea>\n                </div>\n                <div class="form-group clearfix">\n                    <button type="button"\n                            class="btn btn-primary pull-right"\n                            ng-click="addComment()"\n                            ng-disabled="!commentForm.$valid || isSavingComment">\n                        Comment\n                    </button>\n                </div>\n            </form>\n        </div>\n    </div>\n</script>\n\n<!-- Template for an item in the task list -->\n<script type="text/ng-template" id="/inline/task_list_item.html">\n    <td ng-show="isLoggedIn">\n        <a href=""\n           ng-click="showTaskEditForm = true"\n           ng-hide="showTaskEditForm">\n            <i class="fa fa-caret-right fa-lg"></i>\n        </a>\n        <a href=""\n           ng-click="showTaskEditForm = false"\n           ng-show="showTaskEditForm">\n            <i class="fa fa-caret-down fa-lg"></i>\n        </a>\n    </td>\n    <td ng-hide="showTaskEditForm" ng-switch="task.priority">\n        <i ng-switch-when="high"\n           class="fa fa-angle-double-up fa-lg text-danger"></i>\n        <i ng-switch-when="medium"\n           class="fa fa-angle-up fa-lg text-warning"></i>\n        <i ng-switch-when="low"\n           class="fa fa-angle-down fa-lg text-success"></i>\n    </td>\n    <td ng-hide="showTaskEditForm">\n        <a href=""\n           ng-show="isLoggedIn"\n           ng-click="showTaskEditForm = true">\n            {{task.title}}\n        </a>\n        <span ng-hide="isLoggedIn">\n            {{task.title}}\n        </span>\n    </td>\n    <td ng-hide="showTaskEditForm">\n        <a href=""\n           ng-click="showTaskEditForm = true"\n           ng-show="isLoggedIn">\n            <span ng-show="project">\n                {{project.name}}\n            </span>\n            <em class="text-muted" ng-hide="project">\n                Project not found\n            </em>\n        </a>\n        <span ng-hide="isLoggedIn">\n            <span ng-show="project">\n                {{project.name}}\n            </span>\n            <em class="text-muted" ng-hide="project">\n                Project not found\n            </em>\n        </span>\n    </td>\n    <td ng-hide="showTaskEditForm">\n        <span ng-show="assignee">\n            {{assignee.full_name}}\n        </span>\n        <em class="text-muted" ng-hide="assignee">\n            Not assigned\n        </em>\n    </td>\n    <td ng-show="showTaskEditForm"\n        colspan="3">\n        <task-edit-form\n                task="task"\n                on-button-click="updateTask()"\n                button-label="Update"\n                />\n    </td>\n    <td class="text-right">\n        <task-status-dropdown\n                editable="{{isLoggedIn}}"\n                on-change="updateStatus(status)"\n                status="{{task.status}}"\n                />\n    </td>\n    <td class="text-right">\n        <a ng-show="isLoggedIn"\n           ng-click="removeTask()">\n            <i class="fa fa-times fa-lg"></i>\n        </a>\n    </td>\n</script>\n\n<!-- Template for story metadata -->\n<script type="text/ng-template" id="/inline/metadata.html">\n\n</script>\n')}]),angular.module("app/templates/story/list.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/story/list.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ 	http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n<div class="container">\n    <div class="row">\n        <div class="col-xs-12">\n            <h1>{{storyCount}} Stories</h1>\n        </div>\n    </div>\n    <div class="row">\n        <div class="col-sm-9 col-sm-offset-3 col-xs-2 col-xs-offset-10">\n            <a href=""\n               ng-click="newStory()"\n               class="pull-right btn btn-default btn-sm">\n                <i class="fa fa-plus"></i>\n                <span class="hidden-xs">New Story</span>\n            </a>\n        </div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12">\n\n            <ul class="nav nav-tabs">\n                <li ng-class="{\'active\': filter == \'active\'}">\n                    <a href=""\n                       ng-click="setFilter(\'active\')">Active</a>\n                </li>\n                <li ng-class="{\'active\': filter == \'merged\'}">\n                    <a href=""\n                       ng-click="setFilter(\'merged\')">Merged</a>\n                </li>\n                <li ng-class="{\'active\': filter == \'invalid\'}">\n                    <a href=""\n                       ng-click="setFilter(\'invalid\')">Invalid</a>\n                </li>\n            </ul>\n            <table class="table table-striped"\n                   ng-hide="isSearching || stories.length == 0">\n                <tbody>\n                <tr ng-repeat="story in stories"\n                    ng-controller="StoryListItemController"\n                    ng-include="\'app/templates/story/story_list_item.html\'">\n                </tr>\n                </tbody>\n            </table>\n\n            <div ng-show="isSearching">\n                <hr/>\n                <p class="text-center">\n                    <i class="fa fa-refresh fa-spin fa-lg"></i>\n                </p>\n            </div>\n\n            <p ng-show="!isSearching && stories.length == 0"\n               class="text-center text-warning">\n                <em> We were unable to find any stories.\n                    Perhaps you would like to create one?</em>\n            </p>\n        </div>\n\n    </div>\n</div>\n')}]),angular.module("app/templates/story/new.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/story/new.html",'<div class="panel panel-default">\n    <div class="panel-heading">\n        <button type="button" class="close" aria-hidden="true"\n                ng-click="close()">&times;</button>\n        <h3 class="panel-title">New Story</h3>\n    </div>\n    <div class="panel-body">\n        <div class="row">\n            <div class="col-xs-12">\n                <form class="form-horizontal" role="form" name="storyForm">\n                    <div class="form-group">\n                        <label for="name" class="col-sm-2 control-label">\n                            Title:\n                        </label>\n\n                        <div class="col-sm-10">\n                            <input id="name"\n                                   type="text"\n                                   class="form-control"\n                                   ng-model="story.title"\n                                   required\n                                   placeholder="Story Title">\n                        </div>\n                    </div>\n                    <div class="form-group">\n                        <label for="description"\n                               class="col-sm-2 control-label">\n                            Description\n                        </label>\n\n                        <div class="col-sm-10">\n                            <textarea id="description"\n                                      class="form-control"\n                                      ng-model="story.description"\n                                      msd-elastic\n                                      required\n                                      placeholder="A brief story description">\n                            </textarea>\n                        </div>\n                    </div>\n                </form>\n            </div>\n        </div>\n        <div class="row">\n            <div class="col-xs-12">\n                <form role="form" name="tasksForm">\n                    <table class="table table-striped table-outlined">\n                        <tbody>\n                        <tr ng-repeat="(index, task) in tasks" ng-include\n                                src="\'/inline/task_row.html\'">\n                        </tr>\n                        </tbody>\n                    </table>\n                </form>\n            </div>\n        </div>\n        <div class="row">\n            <div class="col-xs-6">\n                <button type="button"\n                        class="btn btn-default"\n                        ng-click="addTask()">\n                    &plus;\n                    Add another task\n                </button>\n            </div>\n            <div class="col-xs-6 text-right">\n                <button type="button"\n                        class="btn btn-primary"\n                        ng-click="save()"\n                        ng-disabled="!storyForm.$valid || !tasksForm.$valid">\n                    Save Changes\n                </button>\n                <button type="button"\n                        ng-click="close()"\n                        class="btn btn-default">\n                    Cancel\n                </button>\n            </div>\n        </div>\n    </div>\n</div>\n\n<!-- Template for story metadata -->\n<script type="text/ng-template" id="/inline/task_row.html">\n    <td>\n        <input type="text"\n               class="form-control input-sm"\n               ng-model="task.title"\n               required\n               placeholder="Task Title">\n    </td>\n    <td class="col-xs-4">\n        <div class="has-feedback has-feedback-no-label">\n            <input id="project"\n                   type="text"\n                   placeholder="Select a Project"\n                   required\n                   ng-model="asyncProject"\n                   typeahead-editable="false"\n                   typeahead="project as project.name for project\n                   in searchProjects($viewValue)"\n                   typeahead-loading="loadingProjects"\n                   typeahead-input-formatter="formatProjectName($model)"\n                   typeahead-on-select="selectNewProject($model, task)"\n                   class="form-control input-sm"\n                    />\n            <span class="form-control-feedback text-muted\n            form-control-feedback-sm">\n                <i class="fa fa-refresh fa-spin" ng-show="loadingProjects"></i>\n                <i class="fa fa-search" ng-hide="loadingProjects"></i>\n            </span>\n        </div>\n    </td>\n    <th class="col-xs-1"\n        ng-show="tasks.length > 1">\n        <button type="button" class="close"\n                ng-click="removeTask(task)">\n            &times;\n        </button>\n    </th>\n</script>\n')}]),angular.module("app/templates/story/story_list_item.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/story/story_list_item.html",'<td style="white-space: nowrap">\n    <a href=""\n       ng-click="expandRow = !expandRow">\n        <i class="fa fa-caret-down"\n           ng-show="expandRow"></i>\n        <i class="fa fa-caret-right"\n           ng-hide="expandRow"></i>\n    </a>&nbsp;\n    <strong>\n        <a href="#!/story/{{story.id}}">\n            {{story.id}}\n        </a>\n    </strong>\n</td>\n<td>\n    <p>\n        <strong>\n            <a href="#!/story/{{story.id}}">\n                {{story.title}}\n            </a>\n        </strong>\n        <br/>\n        <small class="text-muted honor-carriage-return"\n               ng-show="expandRow">{{story.description}}\n        </small>\n    </p>\n</td>\n<td class="text-right">\n    <p class="label {{statusLabelStyle}}"\n       ng-click="expandRow = !expandRow">\n        <i class="fa fa-caret-down"\n           ng-show="expandRow"></i>\n        <i class="fa fa-caret-right"\n           ng-hide="expandRow"></i>\n        {{story.status | capitalize}}\n    </p>\n    <table ng-show="expandRow"\n           class="table table-clean table-supercondensed">\n        <tr>\n            <th>\n                <small>Todo:</small>\n            </th>\n            <td>\n                <strong>\n                    <small>{{story.todo || 0}}</small>\n                </strong>\n            </td>\n        </tr>\n        <tr class="text-info">\n            <th>\n                <small>Progress:</small>\n            </th>\n            <td>\n                <strong>\n                    <small>{{story.inprogress || 0}}</small>\n                </strong>\n            </td>\n        </tr>\n        <tr class="text-warning">\n            <th>\n                <small>Review:</small>\n            </th>\n            <td>\n                <strong>\n                    <small>{{story.review || 0}}</small>\n                </strong>\n            </td>\n        </tr>\n        <tr class="text-success">\n            <th>\n                <small>Merged:</small>\n            </th>\n            <td>\n                <strong>\n                    <small>{{story.merged || 0}}</small>\n                </strong>\n            </td>\n        </tr>\n        <tr class="text-muted">\n            <th>\n                <small>Invalid:</small>\n            </th>\n            <td>\n                <strong>\n                    <small>{{story.invalid || 0}}</small>\n                </strong>\n            </td>\n        </tr>\n    </table>\n</td>')}]),angular.module("app/templates/story/task_edit_form.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/story/task_edit_form.html",'<form name="taskForm">\n    <div class="form-group">\n        <label for="title">Task Summary:</label>\n        <textarea\n                id="title"\n                name="title"\n                ng-model="task.title"\n                required\n                maxlength="255"\n                placeholder="Describe the specifics of your task here"\n                class="form-control input-sm">\n        </textarea>\n    </div>\n    <div class="form-group has-feedback">\n        <label for="project">Affected Project:</label>\n        <input id="project"\n               type="text"\n               ng-model="asyncProject"\n               typeahead-editable="false"\n               typeahead="project as project.name for project in searchProjects($viewValue)"\n               typeahead-loading="loadingProjects"\n               typeahead-input-formatter="formatProjectName($model)"\n               typeahead-on-select="selectNewProject($model)"\n               class="form-control input-sm"\n                />\n        <span class="form-control-feedback text-muted form-control-feedback-sm">\n            <i class="fa fa-refresh fa-spin" ng-show="loadingProjects"></i>\n            <i class="fa fa-search" ng-hide="loadingProjects"></i>\n        </span>\n    </div>\n    <div class="form-group has-feedback">\n        <label for="assignee">Assigned To:</label>\n        <input id="assignee"\n               type="text"\n               ng-model="asyncUser"\n               placeholder="Choose a user."\n               typeahead-editable="false"\n               typeahead="user as user.full_name for user in searchUsers($viewValue)"\n               typeahead-loading="loadingUsers"\n               typeahead-input-formatter="formatUserName($model)"\n               typeahead-on-select="selectNewUser($model)"\n               class="form-control input-sm"\n                />\n        <span class="form-control-feedback text-muted form-control-feedback-sm">\n            <i class="fa fa-refresh fa-spin" ng-show="loadingUsers"></i>\n            <i class="fa fa-search" ng-hide="loadingUsers"></i>\n        </span>\n    </div>\n    <div class="form-group has-feedback">\n        <label for="priority">Priority:</label>\n        <select id="priority"\n                class="form-control input-sm"\n                ng-model="task.priority">\n            <option value="high">High</option>\n            <option value="medium">Medium</option>\n            <option value="low">Low</option>\n        </select>\n    </div>\n    <div class="form-group">\n        <div class="clearfix">\n            <div class="pull-right">\n                <div class="btn" ng-show="isUpdating">\n                    <i class="fa fa-spinner fa-lg fa-spin"></i>\n                </div>\n                <button type="button"\n                        class="btn btn-primary"\n                        ng-click="onButtonClick({})"\n                        ng-disabled="!taskForm.$valid">\n                    {{buttonLabel}}\n                </button>\n            </div>\n        </div>\n    </div>\n</form>\n</form>')
}]),angular.module("app/templates/util/story_status_label.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/util/story_status_label.html",'<span class="label {{labelStyle}}" ng-show="!!story">\n    {{story.status | capitalize}}\n</span>')}]),angular.module("app/templates/util/tag_complete.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/util/tag_complete.html",'<div class="dropdown">\n    {{model}}\n    <div class="form-control tag-input"\n         ng-click="focus()"\n         data-toggle="dropdown">\n        <div class="tag"\n             ng-repeat="tag in selectedTags"\n             ng-click="noFocus($event)">\n            {{tag[tagLabelField]}}\n            <a class="tag-remove" ng-click="removeTag(tag)">\n                &times;\n            </a>\n        </div>\n        <input name="tagInputField"\n               class="tag-input dropdown-toggle"\n               type="text"\n               autoresize-width\n               ng-model="newTagName"\n               ng-keydown="onKeyDown($event)"\n               ng-keyup="onKeyUp($event)"\n               ng-delete="deletePressed()"\n               ng-enter="addTag()">\n        </input>\n    </div>\n    <ul class="dropdown-menu">\n        <li ng-repeat="tag in filteredTags"\n            ng-class="{active: $index == selectedIndex}">\n            <a ng-click="addTag(tag[tagLabelField])">\n                {{tag[tagLabelField]}}\n            </a>\n        </li>\n    </ul>\n</div>')}]),angular.module("app/templates/util/tag_input.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/util/tag_input.html",'<div class="form-control tag-input" ng-click="focus()">\n    <div class="tag" ng-repeat="tag in selectedTags"\n         ng-click="noFocus($event)">\n        {{tag}}\n        <a class="tag-remove" ng-click="removeTag(tag)">\n            &times;\n        </a>\n    </div>\n\n    <input name="tagInputField"\n           class="tag-input dropdown-toggle"\n           type="text"\n           autoresize-width\n           ng-model="newTagName"\n           ng-delete="deletePressed()"\n           ng-enter="addTag()">\n    </input>\n</div>')}]),angular.module("app/templates/util/task_status_dropdown.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/templates/util/task_status_dropdown.html",'<span class="label label-{{style}}" ng-hide="editable">\n    {{status | taskStatusLabel}}\n</span>\n<div class="dropdown" ng-show="editable">\n    <a class="btn btn-{{style}} btn-xs dropdown-toggle" data-toggle="dropdown">\n        {{status | taskStatusLabel}}\n        <i class="fa fa-caret-down"></i>\n    </a>\n    <ul class="dropdown-menu dropdown-menu-right">\n        <li ng-class="{disabled: status == \'invalid\'}">\n            <a href="" ng-click="setStatus(\'invalid\', $event)">\n                {{\'invalid\' | taskStatusLabel}}\n            </a>\n        </li>\n        <li ng-class="{disabled: status == \'todo\'}">\n            <a href="" ng-click="setStatus(\'todo\', $event)">\n                {{\'todo\' | taskStatusLabel}}\n            </a>\n        </li>\n        <li ng-class="{disabled: status == \'inprogress\'}">\n            <a href="" ng-click="setStatus(\'inprogress\', $event)">\n                {{\'inprogress\' | taskStatusLabel}}\n            </a>\n        </li>\n        <li ng-class="{disabled: status == \'review\'}">\n            <a href="" ng-click="setStatus(\'review\', $event)">\n                {{\'review\' | taskStatusLabel}}\n            </a>\n        </li>\n        <li ng-class="{disabled: status == \'merged\'}">\n            <a href="" ng-click="setStatus(\'merged\', $event)">\n                {{\'merged\' | taskStatusLabel}}\n            </a>\n        </li>\n    </ul>\n</div>\n')}]);