angular.module("sb.auth",["sb.services","sb.templates","ui.router","sb.util","LocalStorageModule"]).config(function($stateProvider,SessionResolver){"use strict";$stateProvider.state("auth",{"abstract":!0,template:"<div ui-view></div>",url:"/auth"}).state("auth.authorize",{url:"/authorize?error&error_description",templateUrl:"app/templates/auth/busy.html",controller:"AuthAuthorizeController",resolve:{isLoggedOut:SessionResolver.requireLoggedOut}}).state("auth.deauthorize",{url:"/deauthorize",templateUrl:"app/templates/auth/busy.html",controller:"AuthDeauthorizeController",resolve:{isLoggedIn:SessionResolver.requireLoggedIn}}).state("auth.token",{url:"/token?code&state&error&error_description",templateUrl:"app/templates/auth/busy.html",controller:"AuthTokenController",resolve:{isLoggedOut:SessionResolver.requireLoggedOut}}).state("auth.error",{url:"/error?error&error_description",templateUrl:"app/templates/auth/error.html",controller:"AuthErrorController"})}),angular.module("sb.pages",["sb.services","sb.templates","sb.pages","ui.router"]).config(function($stateProvider){"use strict";$stateProvider.state("page",{"abstract":!0,url:"/page",template:"<div ui-view></div>"}).state("page.about",{url:"/about",templateUrl:"app/templates/page/about.html"})}),angular.module("sb.projects",["ui.router","sb.services","sb.util"]).config(function($stateProvider,$urlRouterProvider){"use strict";$urlRouterProvider.when("/project","/project/list"),$urlRouterProvider.when("/project/{id:[0-9]+}",function($match){return"/project/"+$match.id+"/overview"}),$stateProvider.state("project",{"abstract":!0,url:"/project",template:"<div ui-view></div>"}).state("project.list",{url:"/list",templateUrl:"app/templates/project/list.html",controller:"ProjectListController"}).state("project.detail",{"abstract":!0,url:"/{id:[0-9]+}",templateUrl:"app/templates/project/detail.html",controller:"ProjectDetailController"}).state("project.detail.overview",{url:"/overview",templateUrl:"app/templates/project/overview.html"}).state("project.detail.edit",{url:"/edit",templateUrl:"app/templates/project/edit.html"}).state("project.detail.delete",{url:"/delete",templateUrl:"app/templates/project/delete.html"}).state("project.detail.stories",{url:"/stories",templateUrl:"app/templates/project/stories.html",controller:"ProjectStoryListController"}).state("project.new",{url:"/new",templateUrl:"app/templates/project/new.html",controller:"ProjectNewController"})}),angular.module("sb.services",["ngResource"]),angular.module("sb.story",["ui.router","sb.services","sb.util"]).config(function($stateProvider,$urlRouterProvider){"use strict";$urlRouterProvider.when("/story","/story/list"),$urlRouterProvider.when("/story/{id:[0-9]+}",function($match){return"/story/"+$match.id+"/overview"}),$urlRouterProvider.when("/story/{storyId:[0-9]+}/task",function($match){return"/story/"+$match.storyId+"/overview"}),$urlRouterProvider.when("/story/{storyId:[0-9]+}/task/{taskId:[0-9]+}",function($match){return"/story/"+$match.storyId+"/task/"+$match.taskId}),$stateProvider.state("story",{"abstract":!0,url:"/story",template:"<div ui-view></div>"}).state("story.list",{url:"/list",templateUrl:"app/templates/story/list.html",controller:"StoryListController"}).state("story.detail",{url:"/{storyId:[0-9]+}","abstract":!0,templateUrl:"app/templates/story/detail.html",controller:"StoryDetailController"}).state("story.detail.overview",{url:"/overview",templateUrl:"app/templates/story/overview.html"}).state("story.detail.edit",{url:"/edit",templateUrl:"app/templates/story/edit.html"}).state("story.detail.delete",{url:"/delete",templateUrl:"app/templates/story/delete.html"})}),angular.module("storyboard",["sb.services","sb.templates","sb.pages","sb.projects","sb.auth","sb.story","ui.router","ui.bootstrap"]).config(function($provide,$stateProvider,$urlRouterProvider,$locationProvider,$httpProvider){"use strict";$urlRouterProvider.otherwise("/"),$locationProvider.hashPrefix("!"),$stateProvider.state("index",{url:"/",templateUrl:"app/templates/index.html",controller:"HomeController"}),$httpProvider.defaults.headers.common["X-Client"]="Storyboard"}).run(function($log,$rootScope,$state){"use strict";$rootScope.$on("$stateChangeError",function(){$state.go("index")})}),angular.module("sb.util",["ui.router"]),angular.module("sb.auth").controller("AuthAuthorizeController",function($stateParams,$state,$log,OpenId){"use strict";return $stateParams.error?($log.debug("Error received, redirecting to auth.error."),void $state.go("auth.error",$stateParams)):void OpenId.authorize()}),angular.module("sb.auth").controller("AuthDeauthorizeController",function(Session,$state,$log){"use strict";$log.debug("Logging out"),Session.destroySession(),$state.go("index")}),angular.module("sb.auth").controller("AuthErrorController",function($scope,$stateParams){"use strict";$scope.error=$stateParams.error||"Unknown",$scope.errorDescription=$stateParams.error_description||"No description received from server."}),angular.module("sb.auth").controller("AuthTokenController",function($state,$log,OpenId,Session,$searchParams){"use strict";return $searchParams.error?($log.debug("Error received, redirecting to auth.error."),void $state.go("auth.error",$searchParams)):void OpenId.token($searchParams).then(function(token){Session.updateSession(token).then(function(){$state.go("index")})},function(error){Session.destroySession(),$state.go("auth.error",error)})}),angular.module("sb.auth").factory("httpAuthorizationHeader",function(AccessToken){"use strict";return{request:function(request){var token=AccessToken.getAccessToken(),type=AccessToken.getTokenType();return token&&!AccessToken.isExpired()&&(request.headers.Authorization=type+" "+token),request}}}).config(function($httpProvider){"use strict";$httpProvider.interceptors.push("httpAuthorizationHeader")}),angular.module("sb.auth").value("SessionState",{LOGGED_IN:"logged_in",LOGGED_OUT:"logged_out",PENDING:"pending"}),angular.module("sb.auth").constant("SessionResolver",function(){"use strict";function resolveSessionState(deferred,desiredSessionState,Session){return function(){var sessionState=Session.getSessionState();sessionState===desiredSessionState?deferred.resolve(sessionState):deferred.reject(sessionState)}}return{requireLoggedOut:function($q,$log,Session,SessionState){$log.debug("Resolving logged-out-only route...");var deferred=$q.defer(),resolveLoggedOut=resolveSessionState(deferred,SessionState.LOGGED_OUT,Session);return Session.getSessionState()===SessionState.PENDING?Session.resolveSessionState().then(resolveLoggedOut):resolveLoggedOut(),deferred.promise},requireLoggedIn:function($q,$log,Session,$rootScope,SessionState){$log.debug("Resolving logged-in-only route...");var deferred=$q.defer(),resolveLoggedIn=resolveSessionState(deferred,SessionState.LOGGED_IN,Session);return Session.getSessionState()===SessionState.PENDING?Session.resolveSessionState().then(resolveLoggedIn):resolveLoggedIn(),deferred.promise}}}()),angular.module("sb.auth").factory("AccessToken",function(localStorageService){"use strict";var TOKEN_TYPE="token_type",ACCESS_TOKEN="access_token",REFRESH_TOKEN="refresh_token",ID_TOKEN="id_token",EXPIRES_IN="expires_in",ISSUE_DATE="issue_date";return{clear:function(){localStorageService.remove(TOKEN_TYPE),localStorageService.remove(ACCESS_TOKEN),localStorageService.remove(REFRESH_TOKEN),localStorageService.remove(ID_TOKEN),localStorageService.remove(EXPIRES_IN),localStorageService.remove(ISSUE_DATE)},setToken:function(jsonToken){this.setTokenType(jsonToken.token_type),this.setAccessToken(jsonToken.access_token),this.setRefreshToken(jsonToken.refresh_token),this.setIdToken(jsonToken.id_token),this.setIssueDate(jsonToken.issue_date),this.setExpiresIn(jsonToken.expires_in)},isExpired:function(){var expiresIn=this.getExpiresIn()||0,issueDate=this.getIssueDate()||0,now=Math.round((new Date).getTime()/1e3);return now>issueDate+expiresIn},getTokenType:function(){return localStorageService.get(TOKEN_TYPE)},setTokenType:function(value){return localStorageService.set(TOKEN_TYPE,value)},getIssueDate:function(){return localStorageService.get(ISSUE_DATE)||null},setIssueDate:function(value){return localStorageService.set(ISSUE_DATE,value)},getExpiresIn:function(){return localStorageService.get(EXPIRES_IN)||0},setExpiresIn:function(value){return localStorageService.set(EXPIRES_IN,value)},getAccessToken:function(){return localStorageService.get(ACCESS_TOKEN)||null},setAccessToken:function(value){return localStorageService.set(ACCESS_TOKEN,value)},getRefreshToken:function(){return localStorageService.get(REFRESH_TOKEN)||null},setRefreshToken:function(value){return localStorageService.set(REFRESH_TOKEN,value)},getIdToken:function(){return localStorageService.get(ID_TOKEN)||null},setIdToken:function(value){return localStorageService.set(ID_TOKEN,value)}}}),angular.module("sb.auth").factory("CurrentUser",function(SessionState,Session,AccessToken,$rootScope,$log,$q,User){"use strict";function loadCurrentUser(){if(Session.getSessionState()===SessionState.LOGGED_IN){var userId=AccessToken.getIdToken();$log.debug("Loading Current User "+userId),currentUser=User.get({id:userId})}else currentUser=null}var currentUser=null;return $rootScope.$on(SessionState.LOGGED_IN,loadCurrentUser),$rootScope.$on(SessionState.LOGGED_OUT,loadCurrentUser),loadCurrentUser(),{get:function(){return currentUser}}}),angular.module("sb.auth").factory("OpenId",function($location,$window,$log,$http,$q,StringUtil,UrlUtil,storyboardApiBase,localStorageService){"use strict";var storageKey="openid_authorize_state",authorizeUrl=storyboardApiBase+"/openid/authorize",tokenUrl=storyboardApiBase+"/openid/token",redirectUri=UrlUtil.buildApplicationUrl("/auth/token"),clientId=$location.host();return{authorize:function(){var state=StringUtil.randomAlphaNumeric(20);localStorageService.set(storageKey,state);var openIdParams={response_type:"code",client_id:clientId,redirect_uri:redirectUri,scope:"user",state:state};$window.location.href=authorizeUrl+"?"+UrlUtil.serializeParameters(openIdParams)},token:function(params){var deferred=$q.defer(),authorizationCode=params.code,tokenParams={grant_type:"authorization_code",code:authorizationCode},url=tokenUrl+"?"+UrlUtil.serializeParameters(tokenParams);return $http({method:"POST",url:url}).then(function(response){$log.debug("Token creation succeeded.");var data=response.data,dateHeader=response.headers("Date");data.issue_date=Math.floor(dateHeader?new Date(dateHeader)/1e3:Date.now()/1e3),deferred.resolve(data)},function(response){$log.debug("Token creation failed.");var error=response.data;error.hasOwnProperty("error")||(error={error:response.status,error_description:response.data}),deferred.reject(error)}),deferred.promise}}}),angular.module("sb.auth").factory("Session",function(SessionState,AccessToken,$rootScope,$log,$q,User){"use strict";function initializeSession(){var deferred=$q.defer();return!AccessToken.getAccessToken()||AccessToken.isExpired()?($log.debug("No token found"),updateSessionState(SessionState.LOGGED_OUT),deferred.resolve()):validateToken().then(function(){$log.debug("Token validated"),updateSessionState(SessionState.LOGGED_IN),deferred.resolve(sessionState)},function(){$log.debug("Token not validated"),AccessToken.clear(),updateSessionState(SessionState.LOGGED_OUT),deferred.resolve(sessionState)}),deferred.promise}function validateToken(){var deferred=$q.defer(),id=AccessToken.getIdToken();return User.read({id:id},function(user){deferred.resolve(user)},function(error){deferred.reject(error)}),deferred.promise}function updateSessionState(newState){newState!==sessionState&&(sessionState=newState,$rootScope.$broadcast(sessionState))}function destroySession(){AccessToken.clear(),updateSessionState(SessionState.LOGGED_OUT)}var sessionState=SessionState.PENDING;return initializeSession(),$rootScope.$on("http_401",function(){destroySession()}),{getSessionState:function(){return sessionState},resolveSessionState:function(){var deferred=$q.defer();if(sessionState!==SessionState.PENDING)deferred.resolve(sessionState);else var unwatch=$rootScope.$watch(function(){return sessionState},function(){deferred.resolve(sessionState),unwatch()});return deferred.promise},isLoggedIn:function(){return sessionState===SessionState.LOGGED_IN},destroySession:function(){destroySession()},updateSession:function(token){var deferred=$q.defer();return token?(AccessToken.setToken(token),initializeSession().then(function(){deferred.resolve(sessionState)},function(){deferred.resolve(sessionState)})):(destroySession(),deferred.resolve(sessionState)),deferred.promise}}}),angular.module("sb.projects").controller("ProjectDetailController",function($scope,$state,$stateParams,Project,Story){"use strict";function handleServiceError(error){$scope.error=error,$scope.isLoading=!1,$scope.isUpdating=!1}var id=$stateParams.hasOwnProperty("id")?parseInt($stateParams.id,10):null;$scope.project={},$scope.projectStoryCount=0,$scope.isLoading=!0,$scope.isUpdating=!1,$scope.error={},id||0===id?(Project.read({id:id},function(result){$scope.project=result,$scope.isLoading=!1},handleServiceError),Story.query({project_id:id},function(result,headers){$scope.projectStoryCount=headers("X-List-Total")||result.length},handleServiceError)):($scope.error={error:!0,error_code:404,error_message:"You did not provide a valid ID."},$scope.isLoading=!1),$scope.update=function(){$scope.isUpdating=!0,$scope.error={},$scope.project.$update(function(){$scope.isUpdating=!1,$state.go("project.detail",{id:$scope.project.id})},handleServiceError)},$scope.remove=function(){$scope.isUpdating=!0,$scope.error={},$scope.project.$delete(function(){$state.go("project.list")},handleServiceError)}}),angular.module("sb.projects").controller("ProjectListController",function($scope,Project){"use strict";function resetScope(){$scope.projectCount=0,$scope.projectOffset=0,$scope.projectLimit=10,$scope.projects=[],$scope.error={}}$scope.searchQuery="",$scope.isSearching=!1,$scope.search=function(){resetScope(),$scope.isSearching=!0,Project.query({},function(result,headers){var projectCount=headers("X-List-Total")||result.length,projectOffset=headers("X-List-Offset")||0,projectLimit=headers("X-List-Limit")||result.length;$scope.projectCount=projectCount,$scope.projectOffset=projectOffset,$scope.projectLimit=projectLimit,$scope.projects=result,$scope.isSearching=!1},function(error){$scope.error=error,$scope.isSearching=!1})},resetScope(),$scope.search()}),angular.module("sb.projects").controller("ProjectNewController",function($scope,$state,Project){"use strict";$scope.newProject=new Project,$scope.isCreating=!1,$scope.error={},$scope.createProject=function(){$scope.isCreating=!0,$scope.error={},$scope.newProject.$create(function(){$state.go("project.list")},function(error){$scope.isCreating=!1,$scope.error=error})}}),angular.module("sb.projects").controller("ProjectStoryListController",function($scope,$state,$stateParams,Story,NewStoryService){"use strict";function resetScope(){$scope.storyCount=0,$scope.storyOffset=0,$scope.storyLimit=10,$scope.stories=[],$scope.error={}}var id=$stateParams.hasOwnProperty("id")?parseInt($stateParams.id,10):null;return null===id?void $state.go("index"):($scope.searchQuery="",$scope.isSearching=!1,$scope.search=function(){resetScope(),$scope.isSearching=!0,Story.query({project_id:id},function(result,headers){var storyCount=headers("X-List-Total")||result.length,storyOffset=headers("X-List-Offset")||0,storyLimit=headers("X-List-Limit")||result.length;$scope.storyCount=storyCount,$scope.storyOffset=storyOffset,$scope.storyLimit=storyLimit,$scope.stories=result,$scope.isSearching=!1},function(error){$scope.error=error,$scope.isSearching=!1})},$scope.newStory=function(){NewStoryService.showNewStoryModal(id)},resetScope(),void $scope.search())}),angular.module("sb.services").factory("httpErrorBroadcaster",function($q,$rootScope){"use strict";function sendEvent(status,body){status&&$rootScope.$broadcast("http_"+status,body||{})}return{response:function(response){return response&&sendEvent(response.status),response},responseError:function(response){return response&&sendEvent(response.status,response.data),$q.reject(response)}}}).config(function($httpProvider){"use strict";$httpProvider.interceptors.unshift("httpErrorBroadcaster")}),angular.module("sb.services").config(function($provide,$injector){"use strict";var propertyName="storyboardApiBase";if(!$injector.has(propertyName)){if(window.hasOwnProperty("ENV")){var ENV=window.ENV;if(null!==ENV&&ENV.hasOwnProperty(propertyName))return void $provide.constant(propertyName,ENV[propertyName])}return $("base").length>0?void $provide.constant(propertyName,""):void $provide.constant(propertyName,"/api/v1")}}),angular.module("sb.services").factory("storyboardApiSignature",function(){"use strict";return{create:{method:"POST"},read:{method:"GET",cache:!1},update:{method:"PUT"},"delete":{method:"DELETE"},query:{method:"GET",isArray:!0,responseType:"json"}}}),angular.module("sb.services").factory("Project",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/projects/:id",{id:"@id"},storyboardApiSignature)}),angular.module("sb.services").factory("ProjectGroup",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/project_groups/:id",{id:"@id"},storyboardApiSignature)}),angular.module("sb.services").factory("Story",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/stories/:id",{id:"@id"},storyboardApiSignature)}),angular.module("sb.services").factory("Task",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/tasks/:id",{id:"@id"},storyboardApiSignature)}),angular.module("sb.services").factory("Team",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/teams/:id",{id:"@id"},storyboardApiSignature)}),angular.module("sb.services").factory("User",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/users/:id",{id:"@id"},storyboardApiSignature)}),angular.module("sb.story").controller("StoryDetailController",function($scope,$state,$stateParams,Story,Task,Project){"use strict";function handleServiceError(error){$scope.error=error,$scope.isLoading=!1,$scope.isUpdating=!1}function loadTasks(){$scope.tasks=[],Task.query({story_id:id},function(result){$scope.tasks=result},handleServiceError)}var id=$stateParams.hasOwnProperty("storyId")?parseInt($stateParams.storyId,10):null;$scope.story={},$scope.tasks=[],$scope.newTask=new Task({story_id:id}),$scope.projects=Project.query({}),$scope.isLoading=!0,$scope.isUpdating=!1,$scope.error={},id||0===id?(Story.read({id:id},function(result){$scope.story=result,$scope.newTask.project_id=result.project_id,$scope.isLoading=!1},handleServiceError),loadTasks()):($scope.error={error:!0,error_code:404,error_message:"You did not provide a valid ID."},$scope.isLoading=!1),$scope.addTask=function(){$scope.newTask.$save(function(){loadTasks(),$scope.newTask=new Task})},$scope.update=function(){$scope.isUpdating=!0,$scope.error={},$scope.story.$update(function(result){$scope.isUpdating=!1,$state.go("story.detail.overview",{storyId:result.id})},handleServiceError)},$scope.remove=function(){$scope.isUpdating=!0,$scope.error={},$scope.story.$delete(function(){$state.go("project.list")},handleServiceError)}}),angular.module("sb.story").controller("StoryListController",function($scope,$modal,NewStoryService,Story){"use strict";function resetScope(){$scope.storyCount=0,$scope.storyOffset=0,$scope.storyLimit=10,$scope.stories=[],$scope.error={}}$scope.newStory=function(){NewStoryService.showNewStoryModal()},$scope.searchQuery="",$scope.isSearching=!1,$scope.search=function(){resetScope(),$scope.isSearching=!0,Story.query({},function(result,headers){var storyCount=headers("X-List-Total")||result.length,storyOffset=headers("X-List-Offset")||0,storyLimit=headers("X-List-Limit")||result.length;$scope.storyCount=storyCount,$scope.storyOffset=storyOffset,$scope.storyLimit=storyLimit,$scope.stories=result,$scope.isSearching=!1},function(error){$scope.error=error,$scope.isSearching=!1})},resetScope(),$scope.search()}),angular.module("sb.story").controller("StoryModalController",function($scope,$modalInstance,params,Project,Story,Task){"use strict";$scope.projects=Project.query({}),$scope.story=new Story({title:""}),$scope.tasks=[new Task({title:"",project_id:params.projectId||null})];var lastTitle="",trackingStoryTitle=!0;$scope.$on("$destroy",$scope.$watch(function(){return $scope.story.title},function(newTitle){if(trackingStoryTitle){var task=$scope.tasks[0];trackingStoryTitle&&task.title===lastTitle?(task.title=newTitle,lastTitle=newTitle):trackingStoryTitle=!1}})),$scope.save=function(){$scope.story.$create(function(story){var resolvingTasks=$scope.tasks.length;$scope.tasks.forEach(function(task){task.story_id=story.id,task.$create(function(){resolvingTasks--,0===resolvingTasks&&$modalInstance.dismiss("success")})})})},$scope.close=function(){$modalInstance.dismiss("cancel")},$scope.addTask=function(){var lastTask=$scope.tasks[$scope.tasks.length-1];$scope.tasks.push(new Task({project_id:lastTask.project_id}))},$scope.removeTask=function(task){if(!($scope.tasks.length<2)){var idx=$scope.tasks.indexOf(task);$scope.tasks.splice(idx,1)}}}),angular.module("sb.story").factory("NewStoryService",function($modal,$log){"use strict";return{showNewStoryModal:function(projectId){var modalInstance=$modal.open({templateUrl:"app/templates/story/new.html",controller:"StoryModalController",resolve:{params:function(){return{projectId:projectId||null}}}});modalInstance.result.then(function(){},function(){$log.info("Modal dismissed at: "+new Date)})}}}),angular.module("storyboard").controller("HeaderController",function($scope,NewStoryService,Session,SessionState,CurrentUser){"use strict";$scope.currentUser=CurrentUser.get(),$scope.newStory=function(){NewStoryService.showNewStoryModal()},$scope.isLoggedIn=Session.getSessionState()===SessionState.LOGGED_IN,$scope.$watch(function(){return Session.getSessionState()},function(sessionState){$scope.isLoggedIn=sessionState===SessionState.LOGGED_IN,$scope.currentUser=CurrentUser.get()})}),angular.module("storyboard").controller("HomeController",function($scope,$modal,NewStoryService){"use strict";$scope.newStory=function(){NewStoryService.showNewStoryModal()}}),angular.module("sb.util").directive("activePath",function($location,$rootScope){"use strict";return{link:function($scope,element,attrs){function setActivePath(){var path=$location.path(),isMatchedPath=null!==path.match(activePath);element.toggleClass("active",isMatchedPath)}var activePath=attrs.activePath,disconnectBinding=$rootScope.$on("$stateChangeSuccess",setActivePath);$scope.$on("$destroy",disconnectBinding),setActivePath()}}}),angular.module("sb.util").directive("ngEnter",function(){"use strict";return function(scope,element,attrs){element.bind("keydown keypress",function(event){13===event.which&&(scope.$apply(function(){scope.$eval(attrs.ngEnter)}),event.preventDefault())})}}),angular.module("sb.util").filter("debug",function(){"use strict";return function(value){return console.warn("DEBUG",value),value}}),angular.module("sb.util").factory("StringUtil",function(){"use strict";return{randomAlphaNumeric:function(length){var possible="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";return this.random(length,possible)},random:function(length,characters){for(var text="",i=0;length>i;i++)text+=characters.charAt(Math.floor(Math.random()*characters.length));return text}}}),angular.module("sb.util").factory("UrlUtil",function($location){"use strict";return{getFullUrlPrefix:function(){var protocol=$location.protocol(),host=$location.host(),port=$location.port();return protocol+"://"+host+":"+port},buildApplicationUrl:function(fragment){return this.getFullUrlPrefix()+"/#!"+fragment},serializeParameters:function(params){var pairs=[];for(var prop in params)params.hasOwnProperty(prop)&&pairs.push(encodeURIComponent(prop)+"="+encodeURIComponent(params[prop]));return pairs.join("&")},deserializeParameters:function(queryString){for(var params={},queryComponents=queryString.split("&"),i=0;i<queryComponents.length;i++){var parts=queryComponents[i].split("="),key=decodeURIComponent(parts[0])||null,value=decodeURIComponent(parts[1])||null;key&&value&&(params[key]=value)}return params}}}),angular.module("sb.util").factory("$searchParams",function($window,UrlUtil){"use strict";var params={},search=$window.location.search;return search?("?"===search.charAt(0)&&(search=search.substr(1)),UrlUtil.deserializeParameters(search)):params});