angular.module("sb.admin",["sb.services","sb.templates","sb.util","ui.router"]).config(function($stateProvider,$urlRouterProvider,PermissionResolver){"use strict";$urlRouterProvider.when("/admin","/admin/user"),$stateProvider.state("admin",{"abstract":!0,views:{"submenu@":{templateUrl:"app/admin/template/admin_submenu.html"},"@":{template:"<div ui-view></div>"}},url:"/admin",resolve:{isSuperuser:PermissionResolver.requirePermission("is_superuser",!0)}}).state("admin.user",{url:"/user",templateUrl:"app/admin/template/user.html",controller:"UserAdminController"}).state("admin.user_edit",{url:"/user/:id",templateUrl:"app/admin/template/user_edit.html",controller:"UserEditController",resolve:{user:function($stateParams,User){return console.warn($stateParams),User.get({id:$stateParams.id}).$promise}}}).state("admin.project_group",{url:"/project_group",templateUrl:"app/admin/template/project_group.html",controller:"ProjectGroupAdminController"}).state("admin.project_group_edit",{url:"/project_group/:id",templateUrl:"app/admin/template/project_group_edit.html",controller:"ProjectGroupEditController",resolve:{projectGroup:function($stateParams,ProjectGroup){return ProjectGroup.get({id:$stateParams.id}).$promise},projects:function($stateParams,ProjectGroupItem){return ProjectGroupItem.browse({projectGroupId:$stateParams.id}).$promise}}}).state("admin.team",{url:"/team",templateUrl:"app/admin/template/team.html"}).state("admin.team_edit",{url:"/team/:id",templateUrl:"app/admin/template/team_edit.html"})}),angular.module("sb.auth",["sb.services","sb.templates","ui.router","sb.util","LocalStorageModule"]).config(function($stateProvider,SessionResolver){"use strict";$stateProvider.state("auth",{"abstract":!0,template:"<div ui-view></div>",url:"/auth"}).state("auth.authorize",{url:"/authorize?error&error_description",templateUrl:"app/auth/template/busy.html",controller:"AuthAuthorizeController",resolve:{isLoggedOut:SessionResolver.requireLoggedOut}}).state("auth.deauthorize",{url:"/deauthorize",templateUrl:"app/auth/template/busy.html",controller:"AuthDeauthorizeController",resolve:{isLoggedIn:SessionResolver.requireLoggedIn}}).state("auth.token",{url:"/token?code&state&error&error_description",templateUrl:"app/auth/template/busy.html",controller:"AuthTokenController",resolve:{isLoggedOut:SessionResolver.requireLoggedOut}}).state("auth.error",{url:"/error?error&error_description",templateUrl:"app/auth/template/error.html",controller:"AuthErrorController"})}).run(function($rootScope,SessionState,Session,PermissionManager,RefreshManager,Notification,Priority){"use strict";PermissionManager.initialize(),Notification.intercept(function(message){switch(message.type){case SessionState.LOGGED_IN:$rootScope.isLoggedIn=!0;break;case SessionState.LOGGED_OUT:$rootScope.isLoggedIn=!1}},Priority.LAST),RefreshManager.scheduleRefresh()}),angular.module("sb.dashboard",["sb.services","sb.templates","sb.auth","ui.router","ui.bootstrap"]).config(function($stateProvider,SessionResolver){"use strict";$stateProvider.state("index",{url:"/",templateUrl:"app/dashboard/template/index.html",controller:"HomeController",resolve:{sessionState:SessionResolver.resolveSessionState}}).state("dashboard",{url:"/dashboard",templateUrl:"app/dashboard/template/dashboard.html",controller:"DashboardController",resolve:{sessionState:SessionResolver.requireLoggedIn,currentUser:SessionResolver.requireCurrentUser}})}),angular.module("sb.notification",[]),angular.module("sb.pages",["sb.services","sb.templates","sb.pages","ui.router"]).config(function($stateProvider){"use strict";$stateProvider.state("page",{"abstract":!0,url:"/page",template:"<div ui-view></div>"}).state("page.about",{url:"/about",templateUrl:"app/pages/template/about.html"})}),angular.module("sb.profile",["sb.services","sb.templates","sb.auth","ui.router","ui.bootstrap"]).config(function($stateProvider,SessionResolver,$urlRouterProvider){"use strict";$urlRouterProvider.when("/profile","/profile/preferences"),$stateProvider.state("profile",{"abstract":!0,url:"/profile",resolve:{isLoggedIn:SessionResolver.requireLoggedIn,currentUser:SessionResolver.requireCurrentUser},views:{"submenu@":{templateUrl:"app/profile/template/profile_submenu.html"},"@":{template:"<div ui-view></div>"}}}).state("profile.preferences",{url:"/preferences",templateUrl:"app/profile/template/preferences.html",controller:"ProfilePreferencesController"}).state("profile.tokens",{url:"/tokens",templateUrl:"app/profile/template/tokens.html",controller:"ProfileTokensController",resolve:{tokens:function(CurrentUser,UserToken,$q){var deferred=$q.defer();return CurrentUser.resolve().then(function(currentUser){UserToken.query({user_id:currentUser.id},function(results){deferred.resolve(results)},function(error){deferred.reject(error)})},function(error){deferred.reject(error)}),deferred.promise}}})}),angular.module("sb.project_group",["ui.router","sb.services","sb.util","sb.auth"]).config(function($stateProvider,$urlRouterProvider,PermissionResolver){"use strict";$urlRouterProvider.when("/project_group","/project_group/list"),$stateProvider.state("project_group",{"abstract":!0,url:"/project_group",template:"<div ui-view></div>",resolve:{isSuperuser:PermissionResolver.resolvePermission("is_superuser",!0)}}).state("project_group.list",{url:"/list",templateUrl:"app/project_group/template/list.html",controller:"ProjectGroupListController"}).state("project_group.detail",{url:"/{id:[0-9]+}",templateUrl:"app/project_group/template/detail.html",controller:"ProjectGroupDetailController",resolve:{projectGroup:function($stateParams,ProjectGroup,$q){var deferred=$q.defer();return ProjectGroup.get({id:$stateParams.id},function(result){deferred.resolve(result)},function(error){deferred.reject(error)}),deferred.promise},projects:function($stateParams,Project,$q){var deferred=$q.defer();return Project.query({project_group_id:$stateParams.id},function(result){deferred.resolve(result)},function(error){deferred.reject(error)}),deferred.promise},stories:function($stateParams,Story,$q){var deferred=$q.defer();return Story.query({project_group_id:$stateParams.id},function(result){deferred.resolve(result)},function(error){deferred.reject(error)}),deferred.promise}}})}),angular.module("sb.projects",["ui.router","sb.services","sb.util","sb.auth"]).config(function($stateProvider,$urlRouterProvider,SessionResolver,PermissionResolver){"use strict";$urlRouterProvider.when("/project","/project/list"),$stateProvider.state("project",{"abstract":!0,url:"/project",template:"<div ui-view></div>",resolve:{isSuperuser:PermissionResolver.resolvePermission("is_superuser",!0)}}).state("project.list",{url:"/list",templateUrl:"app/projects/template/list.html",controller:"ProjectListController"}).state("project.detail",{url:"/{id:[0-9]+}",templateUrl:"app/projects/template/detail.html",controller:"ProjectDetailController"}).state("project.new",{url:"/new",templateUrl:"app/projects/template/new.html",controller:"ProjectNewController",resolve:{isLoggedIn:SessionResolver.requireLoggedIn,isSuperuser:PermissionResolver.requirePermission("is_superuser",!0)}})}),angular.module("sb.search",["ui.router","sb.services","sb.util","sb.auth"]).config(function($stateProvider){"use strict";$stateProvider.state("search",{url:"/search?q",templateUrl:"app/search/template/index.html",controller:"SearchController"})}),angular.module("sb.services",["ngResource","sb.notification"]),angular.module("sb.story",["ui.router","sb.services","sb.util","ui.bootstrap"]).config(function($stateProvider,$urlRouterProvider,PreferenceProvider,TimelineEventTypes){"use strict";$urlRouterProvider.when("/story","/story/list"),$stateProvider.state("story",{"abstract":!0,url:"/story",template:"<div ui-view></div>"}).state("story.list",{url:"/list",templateUrl:"app/stories/template/list.html",controller:"StoryListController"}).state("story.detail",{url:"/{storyId:[0-9]+}",templateUrl:"app/stories/template/detail.html"});var events_filter_defaults={};TimelineEventTypes.forEach(function(type){events_filter_defaults[type]=!0}),PreferenceProvider.addPreference("display_events_filter",events_filter_defaults)}),angular.module("storyboard",["sb.services","sb.templates","sb.dashboard","sb.pages","sb.projects","sb.auth","sb.story","sb.profile","sb.notification","sb.search","sb.admin","sb.subscription","sb.project_group","ui.router","ui.bootstrap","monospaced.elastic","angularMoment","angular-data.DSCacheFactory"]).constant("angularMomentConfig",{preprocess:"utc",timezone:"UTC"}).config(function($provide,$urlRouterProvider,$locationProvider,$httpProvider,msdElasticConfig){"use strict";$urlRouterProvider.otherwise("/"),$locationProvider.hashPrefix("!"),$httpProvider.defaults.headers.common["X-Client"]="StoryBoard",msdElasticConfig.append="\n"}).run(function($log,$rootScope,$state){"use strict";$rootScope.$on("$stateChangeError",function(){$state.go("index")})}).run(function($http,DSCacheFactory){"use strict";DSCacheFactory.createCache("defaultCache",{maxAge:6e4,deleteOnExpire:"passive"}),$http.defaults.cache=DSCacheFactory.get("defaultCache")}),angular.module("sb.subscription",["sb.notification"]),angular.module("sb.util",["ui.router","LocalStorageModule"]).run(function(){"use strict";angular.element.prototype.hide=function(){this.addClass("ng-hide")},angular.element.prototype.show=function(){this.removeClass("ng-hide")}}),angular.module("sb.admin").controller("ProjectGroupAdminController",function($scope,$modal,ProjectGroup){"use strict";$scope.projectGroups=[],$scope.filterQuery="",$scope.addProjectGroup=function(){$modal.open({templateUrl:"app/admin/template/project_group_new.html",controller:"ProjectGroupNewController"}).result.then(function(){$scope.search()})},$scope.deleteProjectGroup=function(projectGroup){var modalInstance=$modal.open({templateUrl:"app/admin/template/project_group_delete.html",controller:"ProjectGroupDeleteController",resolve:{projectGroup:function(){return projectGroup}}});modalInstance.result.then(function(){$scope.search()})},$scope.search=function(){var searchQuery=$scope.filterQuery||"";$scope.projectGroups=ProjectGroup.browse({title:searchQuery})},$scope.search()}),angular.module("sb.admin").controller("ProjectGroupDeleteController",function($scope,projectGroup,$modalInstance){"use strict";$scope.projectGroup=projectGroup,$scope.isUpdating=!0,$scope.error={},$scope.remove=function(){$scope.projectGroup.$delete(function(){$modalInstance.close("success")})},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.admin").controller("ProjectGroupEditController",function($q,$log,$scope,$state,projectGroup,projects,Project,ProjectGroupItem,ArrayUtil){"use strict";$scope.projectGroup=projectGroup,$scope.projects=projects;var loadedIds=[];$scope.projects.forEach(function(project){loadedIds.push(project.id)}),$scope.isSaving=!1,$scope.searchProjects=function(value){var deferred=$q.defer();return Project.browse({name:value,limit:10},function(results){for(var idxList=[],i=0;i<$scope.projects.length;i++){var project=$scope.projects[i];project&&idxList.push(project.id)}for(var j=results.length-1;j>=0;j--){var resultId=results[j].id;idxList.indexOf(resultId)>-1&&results.splice(j,1)}deferred.resolve(results)},function(error){$log.error(error),deferred.resolve([])}),deferred.promise},$scope.formatProjectName=function(model){return model?model.name:""},$scope.removeProject=function(index){$scope.projects.splice(index,1)},$scope.save=function(){$scope.isSaving=!0;var promises=[],desiredIds=[];$scope.projects.forEach(function(project){desiredIds.push(project.id)});var idsToDelete=ArrayUtil.difference(loadedIds,desiredIds);idsToDelete.forEach(function(id){var deferred=$q.defer(),item=new ProjectGroupItem({id:id,projectGroupId:projectGroup.id});item.$delete(function(result){deferred.resolve(result)},function(error){deferred.reject(error)}),promises.push(deferred.promise)});var idsToAdd=ArrayUtil.difference(desiredIds,loadedIds);idsToAdd.forEach(function(id){var deferred=$q.defer(),item=new ProjectGroupItem({id:id,projectGroupId:projectGroup.id});item.$create(function(result){deferred.resolve(result)},function(error){deferred.reject(error)}),promises.push(deferred.promise)});var deferred=$q.defer();promises.push(deferred.promise),$scope.projectGroup.$update(function(success){deferred.resolve(success)},function(error){$log.error(error),deferred.reject(error)}),$q.all(promises).then(function(){$state.go("admin.project_group",{})},function(error){$log.error(error)})},$scope.addProject=function(){$scope.projects.push({})},$scope.selectNewProject=function(index,model){$scope.projects[index]=model}}),angular.module("sb.admin").controller("ProjectGroupItemController",function($scope,$log,ProjectGroupItem){"use strict";if($scope.projectGroupItems=[],$scope.loadingProjectGroupItems=!1,$scope.projectGroup){var id=$scope.projectGroup.id;$scope.loadingProjectGroupItems=!0,ProjectGroupItem.browse({projectGroupId:id},function(results){$scope.loadingProjectGroupItems=!1,$scope.projectGroupItems=results},function(error){$log.error(error),$scope.loadingProjectGroupItems=!1})}}),angular.module("sb.admin").controller("ProjectGroupNewController",function($q,$log,$scope,$modalInstance,ProjectGroup,ProjectGroupItem,Project){"use strict";$scope.isSaving=!1,$scope.projects=[{}],$scope.projectGroup=new ProjectGroup,$scope.searchProjects=function(value){var deferred=$q.defer();return Project.browse({name:value,limit:10},function(results){for(var idxList=[],i=0;i<$scope.projects.length;i++){var project=$scope.projects[i];project&&idxList.push(project.id)}for(var j=results.length-1;j>=0;j--){var resultId=results[j].id;idxList.indexOf(resultId)>-1&&results.splice(j,1)}deferred.resolve(results)},function(error){$log.error(error),deferred.resolve([])}),deferred.promise},$scope.formatProjectName=function(model){return model?model.name:""},$scope.addProject=function(){$scope.projects.push({})},$scope.selectNewProject=function(index,model){$scope.projects[index]=model},$scope.removeProject=function(index){$scope.projects.splice(index,1)},$scope.save=function(){$scope.isSaving=!0,$scope.projectGroup.$save(function(projectGroup){var promises=[];$scope.projects.forEach(function(project){var deferred=$q.defer(),item=new ProjectGroupItem({id:project.id,projectGroupId:projectGroup.id});item.$create(function(result){deferred.resolve(result)},function(error){deferred.reject(error)}),promises.push(deferred.promise)}),$q.all(promises).then(function(){$modalInstance.close(projectGroup)},function(error){$log.error(error),$modalInstance.dismiss(error)})},function(error){$scope.isSaving=!1,$log.error(error)})},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.admin").controller("UserAdminController",function($scope,$modal,User){"use strict";$scope.users=[],$scope.filterQuery="",$scope.addUser=function(){$modal.open({templateUrl:"app/admin/template/user_new.html",controller:"UserNewController"}).result.then(function(){$scope.search()})},$scope.search=function(){var searchQuery=$scope.filterQuery||"";$scope.users=User.browse({full_name:searchQuery})},$scope.search()}),angular.module("sb.admin").controller("UserEditController",function($scope,user,$state){"use strict";$scope.user=user,$scope.save=function(){$scope.user.$update(function(){$state.go("admin.user")})},$scope.cancel=function(){$state.go("admin.user")}}),angular.module("sb.admin").controller("UserNewController",function($log,$scope,$modalInstance,User){"use strict";$scope.isSaving=!1,$scope.user=new User,$scope.save=function(){$scope.isSaving=!0,$scope.user.$create(function(user){$modalInstance.close(user)},function(error){$scope.isSaving=!1,$log.error(error),$modalInstance.dismiss(error)})},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.auth").controller("AuthAuthorizeController",function($stateParams,$state,$log,OpenId,$window,LastLocation,localStorageService){"use strict";return $stateParams.error?($log.debug("Error received, redirecting to auth.error."),void $state.go("auth.error",$stateParams)):(localStorageService.set("lastPath",LastLocation.get()),void OpenId.authorize())}),angular.module("sb.auth").controller("AuthDeauthorizeController",function(Session,$state,$log){"use strict";$log.debug("Logging out"),Session.destroySession(),$state.go("index")}),angular.module("sb.auth").controller("AuthErrorController",function($scope,$stateParams){"use strict";$scope.error=$stateParams.error||"Unknown",$scope.errorDescription=$stateParams.error_description||"No description received from server."}),angular.module("sb.auth").controller("AuthTokenController",function($state,$log,OpenId,Session,$searchParams,$window,UrlUtil,LastLocation){"use strict";function buildNextPath(){var location=LastLocation.get();return location.indexOf("/auth")>-1&&(location="/"),location}return $searchParams.error?($log.debug("Error received, redirecting to auth.error."),void $state.go("auth.error",$searchParams)):void OpenId.token($searchParams).then(function(token){Session.updateSession(token).then(function(){var nextPath=buildNextPath();$window.location.href=UrlUtil.buildApplicationUrl(nextPath)})},function(error){Session.destroySession(),$state.go("auth.error",error)})}),angular.module("sb.auth").controller("LoginRequiredModalController",function($state,$scope,$modalInstance){"use strict";$scope.login=function(){$state.go("auth.authorize"),$modalInstance.dismiss("success")},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.util").directive("permission",function($log,PermissionManager){"use strict";return{restrict:"A",link:function($scope,element,attrs){element.hide();var permName=attrs.permission,permValue=attrs.permissionValue||!0;PermissionManager.listen($scope,permName,function(actualValue){actualValue&&actualValue.toString()===permValue.toString()?element.show():element.hide()})}}}),angular.module("sb.auth").factory("httpAuthorizationHeader",function(AccessToken){"use strict";return{request:function(request){var token=AccessToken.getAccessToken(),type=AccessToken.getTokenType();return token&&(request.headers.Authorization=type+" "+token),request}}}).config(function($httpProvider){"use strict";$httpProvider.interceptors.push("httpAuthorizationHeader")}),angular.module("sb.auth").run(function($log,$modal,Notification,RefreshManager,Session,Priority){"use strict";function handle_401(){RefreshManager.tryRefresh().then(function(){$log.info("Token refreshed on 401")},function(){$log.info("Could not refresh token. Destroying session"),Session.destroySession()})}function handle_403(){var modalInstance=$modal.open({templateUrl:"app/templates/auth/modal/superuser_required.html",controller:function($modalInstance,$scope){$scope.close=function(){$modalInstance.dismiss("cancel")}}});return modalInstance.result}Notification.intercept(function(message){return"http"===message.type?(401===message.message&&handle_401(),403===message.message&&handle_403(),!1):void 0},Priority.BEFORE)}),angular.module("sb.auth").run(function($log,$modal,Notification,SessionState,Priority){"use strict";Notification.intercept(function(message){switch(message.type){case SessionState.LOGGED_IN:return!0;case SessionState.LOGGED_OUT:message.message="You have been logged out."}},Priority.AFTER)}),angular.module("sb.auth").value("SessionState",{LOGGED_IN:"logged_in",LOGGED_OUT:"logged_out",PENDING:"pending"}),angular.module("sb.auth").constant("PermissionResolver",{requirePermission:function(permName,requiredValue){"use strict";return function($q,$log,PermissionManager){var deferred=$q.defer();return PermissionManager.resolve(permName).then(function(value){$log.debug("permission:",permName,requiredValue,value),value===requiredValue?deferred.resolve(value):deferred.reject(value)},function(error){$log.debug("permission:",error),deferred.reject(error)}),deferred.promise}},resolvePermission:function(permName){"use strict";return function($q,$log,PermissionManager){var deferred=$q.defer();return PermissionManager.resolve(permName).then(function(value){deferred.resolve(value)},function(){deferred.resolve(!1)}),deferred.promise}}}),angular.module("sb.auth").constant("SessionResolver",function(){"use strict";function resolveSessionState(deferred,desiredSessionState,Session){return function(){var sessionState=Session.getSessionState();sessionState===desiredSessionState?deferred.resolve(sessionState):deferred.reject(sessionState)}}return{resolveSessionState:function($q,$log,Session,SessionState){var deferred=$q.defer();return $log.debug("Resolving session state..."),Session.resolveSessionState().then(function(sessionState){deferred.resolve(sessionState)},function(error){$log.error(error),deferred.resolve(SessionState.LOGGED_OUT)}),deferred.promise},requireLoggedOut:function($q,$log,Session,SessionState){$log.debug("Resolving logged-out-only route...");var deferred=$q.defer(),resolveLoggedOut=resolveSessionState(deferred,SessionState.LOGGED_OUT,Session);return Session.getSessionState()===SessionState.PENDING?Session.resolveSessionState().then(resolveLoggedOut):resolveLoggedOut(),deferred.promise},requireLoggedIn:function($q,$log,Session,$rootScope,SessionState){$log.debug("Resolving logged-in-only route...");var deferred=$q.defer(),resolveLoggedIn=resolveSessionState(deferred,SessionState.LOGGED_IN,Session);return Session.getSessionState()===SessionState.PENDING?Session.resolveSessionState().then(resolveLoggedIn):resolveLoggedIn(),deferred.promise},requireCurrentUser:function($q,$log,CurrentUser){return $log.debug("Resolving current user..."),CurrentUser.resolve()}}}()),angular.module("sb.auth").factory("AccessToken",function(localStorageService,preExpireDelta){"use strict";var TOKEN_TYPE="token_type",ACCESS_TOKEN="access_token",REFRESH_TOKEN="refresh_token",ID_TOKEN="id_token",EXPIRES_IN="expires_in",ISSUE_DATE="issue_date";return{clear:function(){localStorageService.remove(TOKEN_TYPE),localStorageService.remove(ACCESS_TOKEN),localStorageService.remove(REFRESH_TOKEN),localStorageService.remove(ID_TOKEN),localStorageService.remove(EXPIRES_IN),localStorageService.remove(ISSUE_DATE)},setToken:function(jsonToken){this.setTokenType(jsonToken.token_type),this.setAccessToken(jsonToken.access_token),this.setRefreshToken(jsonToken.refresh_token),this.setIdToken(jsonToken.id_token),this.setIssueDate(jsonToken.issue_date),this.setExpiresIn(jsonToken.expires_in)},isExpired:function(){var expiresIn=this.getExpiresIn()||0,issueDate=this.getIssueDate()||0,now=Math.round((new Date).getTime()/1e3);return now>issueDate+expiresIn},expiresSoon:function(){var expiresIn=this.getExpiresIn()||0,issueDate=this.getIssueDate()||0,now=Math.round((new Date).getTime()/1e3);return now>issueDate+expiresIn-preExpireDelta},getTokenType:function(){return localStorageService.get(TOKEN_TYPE)},setTokenType:function(value){return localStorageService.set(TOKEN_TYPE,value)},getIssueDate:function(){return parseInt(localStorageService.get(ISSUE_DATE))||null},setIssueDate:function(value){return localStorageService.set(ISSUE_DATE,parseInt(value))},getExpiresIn:function(){return parseInt(localStorageService.get(EXPIRES_IN))||0},setExpiresIn:function(value){return localStorageService.set(EXPIRES_IN,parseInt(value))},getAccessToken:function(){return localStorageService.get(ACCESS_TOKEN)||null},setAccessToken:function(value){return localStorageService.set(ACCESS_TOKEN,value)},getRefreshToken:function(){return localStorageService.get(REFRESH_TOKEN)||null},setRefreshToken:function(value){return localStorageService.set(REFRESH_TOKEN,value)},getIdToken:function(){return localStorageService.get(ID_TOKEN)||null},setIdToken:function(value){return localStorageService.set(ID_TOKEN,value)}}}),angular.module("sb.auth").factory("CurrentUser",function(SessionState,Session,AccessToken,$rootScope,$log,$q,User,Notification,Priority){"use strict";function resolveCurrentUser(){if(currentPromise)return currentPromise;var deferred=$q.defer();return currentPromise=deferred.promise,resolveLoggedInSession().then(function(){currentUser?deferred.resolve(currentUser):User.get({id:AccessToken.getIdToken()},function(user){currentUser=user,deferred.resolve(user)},function(error){currentUser=null,deferred.reject(error)})},function(error){currentUser=null,deferred.reject(error)}),currentPromise.then(function(){currentPromise=null},function(){currentPromise=null}),currentPromise}function resolveLoggedInSession(){var deferred=$q.defer();return Session.resolveSessionState().then(function(sessionState){sessionState===SessionState.LOGGED_IN?deferred.resolve(sessionState):deferred.reject(sessionState)},function(error){deferred.reject(error)}),deferred.promise}var currentUser=null,currentPromise=null;return Notification.intercept(function(message){switch(message.type){case SessionState.LOGGED_IN:resolveCurrentUser();break;case SessionState.LOGGED_OUT:currentUser=null}},Priority.LAST),{resolve:function(){return resolveCurrentUser()}}}),angular.module("sb.auth").factory("OpenId",function($location,$window,$log,$http,$q,StringUtil,UrlUtil,storyboardApiBase,localStorageService){"use strict";var storageKey="openid_authorize_state",authorizeUrl=storyboardApiBase+"/openid/authorize",tokenUrl=storyboardApiBase+"/openid/token",redirectUri=UrlUtil.buildApplicationUrl("/auth/token"),clientId=$location.host();return{authorize:function(){var state=StringUtil.randomAlphaNumeric(20);localStorageService.set(storageKey,state);var openIdParams={response_type:"code",client_id:clientId,redirect_uri:redirectUri,scope:"user",state:state};$window.location.href=authorizeUrl+"?"+UrlUtil.serializeParameters(openIdParams)},token:function(params){var deferred=$q.defer(),grant_type=params.grant_type||"authorization_code",authorizationCode=params.code,refreshToken=params.refresh_token,tokenParams={grant_type:grant_type};"authorization_code"===grant_type?tokenParams.code=authorizationCode:tokenParams.refresh_token=refreshToken;var url=tokenUrl+"?"+UrlUtil.serializeParameters(tokenParams);return $http({method:"POST",url:url}).then(function(response){$log.debug("Token creation succeeded.");var data=response.data,dateHeader=response.headers("Date");data.issue_date=Math.floor(dateHeader?new Date(dateHeader)/1e3:Date.now()/1e3),deferred.resolve(data)},function(response){$log.debug("Token creation failed.");var error=response.data;error.hasOwnProperty("error")||(error={error:response.status,error_description:response.data}),deferred.reject(error)}),deferred.promise}}}),angular.module("sb.auth").factory("PermissionManager",function($log,$q,$rootScope,Session,SessionState,CurrentUser,Notification,Priority){"use strict";function resolvePermission(permName){var deferred=$q.defer();return permCache.hasOwnProperty(permName)?deferred.resolve(permCache[permName]):CurrentUser.resolve().then(function(user){permCache[permName]=user[permName],deferred.resolve(permCache[permName])},function(error){deferred.reject(error)}),deferred.promise}function clearPermissionCache(){$log.debug("Resetting permission cache."),permCache={},$rootScope.$broadcast(NOTIFY_PERMISSIONS)}function permissionListenHandler(permName,handler){return function(){resolvePermission(permName).then(function(value){handler(value)},function(){handler(null)})}}var permCache={},NOTIFY_PERMISSIONS="notify_permissions";return{initialize:function(){$log.debug("Initializing permissions");var removeNotifier=Notification.intercept(function(message){switch(message.type){case SessionState.LOGGED_IN:case SessionState.LOGGED_OUT:clearPermissionCache()}},Priority.LAST);$rootScope.$on("$destroy",removeNotifier),Session.getSessionState()!==SessionState.PENDING&&clearPermissionCache()},listen:function(scope,permName,handler){var messageHandler=permissionListenHandler(permName,handler);scope.$on("$destroy",$rootScope.$on(NOTIFY_PERMISSIONS,messageHandler)),messageHandler()},resolve:function(permName){return resolvePermission(permName)}}}),angular.module("sb.auth").constant("preExpireDelta",600),angular.module("sb.auth").service("RefreshManager",function($q,$log,$timeout,preExpireDelta,AccessToken,OpenId){"use strict";var currentRefresh=null,nextRefreshPromise=null,scheduledForToken=null,tryRefresh=function(){if(!currentRefresh){currentRefresh=$q.defer(),currentRefresh.promise.then(function(){currentRefresh=null},function(){currentRefresh=null});var refresh_token=AccessToken.getRefreshToken(),is_expired=AccessToken.isExpired(),expires_soon=AccessToken.expiresSoon();refresh_token?is_expired||expires_soon?($log.info("Trying to refresh token"),OpenId.token({grant_type:"refresh_token",refresh_token:refresh_token}).then(function(data){AccessToken.setToken(data),currentRefresh.resolve(!0),scheduleRefresh()},function(){AccessToken.clear(),currentRefresh.reject()})):($log.info("No refresh required for current access token."),currentRefresh.resolve(!0)):($log.info("No refresh token found. Aborting refresh."),currentRefresh.reject())}return currentRefresh.promise},scheduleRefresh=function(){if(!AccessToken.getRefreshToken()||AccessToken.isExpired())return void $log.info("Current token does not require deferred refresh.");var expiresAt=AccessToken.getIssueDate()+AccessToken.getExpiresIn();if(nextRefreshPromise&&AccessToken.getAccessToken()===scheduledForToken)return void $log.info("The refresh is already scheduled.");var now=Math.round((new Date).getTime()/1e3),delay=1e3*(expiresAt-preExpireDelta-now);nextRefreshPromise=$timeout(tryRefresh,delay,!1),scheduledForToken=AccessToken.getAccessToken(),$log.info("Refresh scheduled to happen in "+delay+" ms")};this.tryRefresh=tryRefresh,this.scheduleRefresh=scheduleRefresh}),angular.module("sb.auth").factory("Session",function(SessionState,AccessToken,$rootScope,$log,$q,$state,User,RefreshManager,Notification,Severity){"use strict";function initializeSession(){var deferred=$q.defer();return AccessToken.getAccessToken()?validateToken().then(function(){$log.debug("Token validated"),updateSessionState(SessionState.LOGGED_IN),deferred.resolve(sessionState)},function(){$log.debug("Token not validated"),AccessToken.clear(),updateSessionState(SessionState.LOGGED_OUT),deferred.resolve(sessionState)}):($log.debug("No token found"),updateSessionState(SessionState.LOGGED_OUT),deferred.resolve()),deferred.promise}function validateToken(){var deferred=$q.defer();return RefreshManager.tryRefresh().then(function(){var id=AccessToken.getIdToken();User.get({id:id},function(user){deferred.resolve(user)},function(error){deferred.reject(error)})}),deferred.promise}function updateSessionState(newState){newState!==sessionState&&(sessionState=newState,Notification.send(newState,newState,Severity.SUCCESS))}function destroySession(){AccessToken.clear(),updateSessionState(SessionState.LOGGED_OUT),$state.reload()}var sessionState=SessionState.PENDING;return initializeSession(),{getSessionState:function(){return sessionState},resolveSessionState:function(){var deferred=$q.defer();if(sessionState!==SessionState.PENDING)deferred.resolve(sessionState);else var unwatch=$rootScope.$watch(function(){return sessionState},function(){sessionState!==SessionState.PENDING&&(deferred.resolve(sessionState),unwatch())});return deferred.promise},isLoggedIn:function(){return sessionState===SessionState.LOGGED_IN},destroySession:function(){destroySession()},updateSession:function(token){var deferred=$q.defer();return token?(AccessToken.setToken(token),initializeSession().then(function(){deferred.resolve(sessionState)},function(){deferred.resolve(sessionState)})):(destroySession(),deferred.resolve(sessionState)),deferred.promise}}}),angular.module("sb.auth").factory("SessionModalService",function($modal){"use strict";return{showLoginRequiredModal:function(){var modalInstance=$modal.open({templateUrl:"app/auth/template/modal/login_required.html",controller:"LoginRequiredModalController"});return modalInstance.result}}}),angular.module("sb.dashboard").controller("DashboardController",function($scope,currentUser,Story,SubscriptionEvent,$q){"use strict";function loadEvents(){$scope.subscriptionEvents=null,SubscriptionEvent.browse({subscriber_id:currentUser.id},function(results){results.forEach(function(row){row.event_info=row.hasOwnProperty("event_info")?JSON.parse(row.event_info):{}
}),$scope.subscriptionEvents=results})}$scope.assignedStories=Story.browse({assignee_id:currentUser.id,status:"active"}),loadEvents(),$scope.removeEvent=function(event){var deferred=$q.defer();return deferred.resolve([event.$delete(function(){var idx=$scope.subscriptionEvents.indexOf(event);$scope.subscriptionEvents.splice(idx,1)})]),deferred.promise},$scope.removeAllEvents=function(){for(var promises=[],i=0;i<$scope.subscriptionEvents.length;i++){var event=$scope.subscriptionEvents[i],promise=$scope.removeEvent(event);promises.push(promise)}$q.all(promises).then(loadEvents)}}),angular.module("sb.dashboard").controller("HomeController",function($state,sessionState,SessionState){"use strict";sessionState===SessionState.LOGGED_IN&&$state.transitionTo("dashboard")}),angular.module("sb.dashboard").directive("subscriptionEvent",function($log,User){"use strict";return{restrict:"A",scope:{subscriptionEvent:"@"},link:function(scope){try{var evt=JSON.parse(scope.subscriptionEvent);scope.evt=evt,scope.author=User.get({id:evt.author_id}),scope.event_type=evt.event_type,scope.created_at=evt.created_at}catch(e){$log.error(e)}},templateUrl:"app/dashboard/template/subscription_event.html"}}),angular.module("sb.notification").controller("NotificationsController",function($scope,Notification){"use strict";var defaultDisplayCount=5;$scope.displayCount=defaultDisplayCount,$scope.notifications=[],$scope.remove=function(notification){var idx=$scope.notifications.indexOf(notification);idx>-1&&$scope.notifications.splice(idx,1),$scope.notifications.length<=defaultDisplayCount&&($scope.displayCount=defaultDisplayCount)},$scope.showMore=function(){$scope.displayCount=Math.min($scope.notifications.length,$scope.displayCount+5)},$scope.$on("$destroy",Notification.subscribe(function(notification){$scope.notifications.push(notification)}))}),angular.module("sb.notification").directive("notifications",function(){"use strict";return{restrict:"E",templateUrl:"app/notification/template/notifications.html",controller:"NotificationsController"}}),angular.module("sb.notification").constant("Priority",{BEFORE:-1,FIRST:0,LAST:999,AFTER:1e3}),angular.module("sb.notification").constant("Severity",{ERROR:"error",WARNING:"warning",INFO:"info",SUCCESS:"success"}),angular.module("sb.notification").factory("Notification",function($log,Severity,Priority){"use strict";var subscribers=[],interceptors=[];return{send:function(type,message,severity,cause,callback,callbackLabel){if(!type||!message)return void $log.warn("Invoked Notification.send() without a type or message.");for(var n={type:type,message:message,severity:severity||Severity.INFO,cause:cause||null,callback:callback||null,callbackLabel:callbackLabel||null,date:new Date},i=0;i<interceptors.length;i++)if(interceptors[i].method(n))return;for(var j=0;j<subscribers.length;j++)subscribers[j](n)},intercept:function(interceptor,priority){var i={priority:priority||Priority.LAST,method:interceptor};return interceptors.unshift(i),interceptors.sort(function(a,b){return a.priority-b.priority}),function(){var idx=interceptors.indexOf(i);interceptors.splice(idx,1)}},subscribe:function(subscriber){return subscribers.push(subscriber),function(){subscribers.remove(subscriber)}}}}),angular.module("sb.profile").controller("ProfilePreferencesController",function($scope,Preference){"use strict";$scope.pageSize=Preference.get("page_size"),$scope.enabled_event_types=Preference.get("display_events_filter"),$scope.save=function(){Preference.set("page_size",$scope.pageSize),Preference.set("display_events_filter",$scope.enabled_event_types),$scope.message="Preferences Saved!"}}),angular.module("sb.profile").controller("ProfileTokenNewController",function($q,$log,$scope,$modalInstance,UserToken,user){"use strict";$scope.isSaving=!1,$scope.token=new UserToken({user_id:user.id,expires_in:3600}),$scope.save=function(){$scope.isSaving=!0,$scope.token.$create(function(token){$modalInstance.close(token),$scope.isSaving=!1},function(){$scope.isSaving=!1})},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.profile").controller("ProfileTokensController",function($scope,UserToken,tokens,$modal){"use strict";$scope.tokens=tokens,$scope.deleteToken=function(token){token.$delete(function(){var idx=$scope.tokens.indexOf(token);idx>-1&&$scope.tokens.splice(idx,1)})},$scope.issueToken=function(){$modal.open({templateUrl:"app/profile/template/token_new.html",controller:"ProfileTokenNewController",resolve:{user:function(CurrentUser){return CurrentUser.resolve()}}}).result.then(function(token){$scope.tokens.push(token)})}}),angular.module("sb.profile").controller("ProfileTokenItemController",function($scope,AccessToken){"use strict";var now=new Date;$scope.created=new Date($scope.token.created_at),$scope.expires=new Date($scope.token.created_at),$scope.expires.setSeconds($scope.expires.getSeconds()+$scope.token.expires_in),$scope.expired=$scope.expires.getTime()<now.getTime(),$scope.current=$scope.token.access_token===AccessToken.getAccessToken()}),angular.module("sb.project_group").controller("ProjectGroupDetailController",function($scope,projectGroup,projects,stories){"use strict";$scope.projectGroup=projectGroup,$scope.projects=projects,$scope.stories=stories}),angular.module("sb.project_group").controller("ProjectGroupListController",function($scope){"use strict";$scope.resourceTypes=["ProjectGroup"],$scope.defaultCriteria=[]}),angular.module("sb.projects").controller("ProjectDetailController",function($scope,$rootScope,$state,$stateParams,Project,Story,Session,isSuperuser){"use strict";function handleServiceError(error){$scope.error=error,$scope.isLoading=!1,$scope.isUpdating=!1}function handleServiceSuccess(){$scope.isLoading=!1,$scope.isUpdating=!1}function loadProject(){Project.get({id:id},function(result){$scope.project=result,handleServiceSuccess()},handleServiceError)}var id=$stateParams.hasOwnProperty("id")?parseInt($stateParams.id,10):null;$scope.project={},$scope.isLoading=!0,$scope.isUpdating=!1,$scope.error={},$scope.cancel=function(){loadProject(),$scope.showEditForm=!1},$scope.toggleEditMode=function(){isSuperuser?($scope.showEditForm=!$scope.showEditForm,setTimeout(function(){$rootScope.$broadcast("elastic:adjust")},1)):$scope.showEditForm=!1},$scope.update=function(){$scope.isUpdating=!0,$scope.error={},$scope.project.$update(function(){$scope.isUpdating=!1,$scope.showEditForm=!1,handleServiceSuccess()},handleServiceError)},loadProject()}),angular.module("sb.projects").controller("ProjectListController",function($scope){"use strict";$scope.resourceTypes=["Project"],$scope.defaultCriteria=[]}),angular.module("sb.projects").controller("ProjectNewController",function($scope,$state,Project){"use strict";$scope.newProject=new Project,$scope.isCreating=!1,$scope.error={},$scope.createProject=function(){$scope.isCreating=!0,$scope.error={},$scope.newProject.$create(function(){$state.go("project.list")},function(error){$scope.isCreating=!1,$scope.error=error})}}),angular.module("sb.projects").controller("ProjectStoryListController",function($scope,$state,$stateParams,Story,NewStoryService){"use strict";function resetScope(){$scope.storyCount=0,$scope.stories=[],$scope.error={}}var id=$stateParams.hasOwnProperty("id")?parseInt($stateParams.id,10):null;return null===id?void $state.go("index"):($scope.searchQuery="",$scope.isSearching=!1,$scope.filter="active",$scope.setFilter=function(state){$scope.filter=state,$scope.search()},$scope.search=function(){resetScope(),$scope.isSearching=!0,Story.browse({project_id:id,status:$scope.filter||null},function(result,headers){$scope.storyCount=headers("X-Total")||result.length,$scope.stories=result,$scope.isSearching=!1},function(error){$scope.error=error,$scope.isSearching=!1})},$scope.newStory=function(){NewStoryService.showNewStoryModal(id).then(function(){$scope.search()})},resetScope(),void $scope.search())}),angular.module("sb.search").controller("SearchController",function($log,$q,$scope,Criteria,$stateParams){"use strict";$scope.defaultCriteria=[],$scope.resourceTypes=["TaskStatus","Story","Project","User","Task"],$stateParams.hasOwnProperty("q")&&$stateParams.q&&$scope.defaultCriteria.push(Criteria.create("Text",$stateParams.q))}),angular.module("sb.search").controller("SearchCriteriaController",function($log,$q,$scope,Criteria){"use strict";var resourceTypes=[];$scope.criteria=[],$scope.init=function(types,defaultCriteria){resourceTypes=types||resourceTypes,$scope.criteria=defaultCriteria||[],$scope.searchForCriteria=Criteria.buildCriteriaSearch(resourceTypes,5)},$scope.addCriteria=function(item){for(var i=$scope.criteria.length-1;i>=0;i--){var cItem=$scope.criteria[i];cItem!==item&&item.type===cItem.type&&$scope.criteria.splice(i,1)}},$scope.removeCriteria=function(item){var idx=$scope.criteria.indexOf(item);idx>-1&&$scope.criteria.splice(idx,1)},$scope.$watchCollection(function(){return $scope.criteria},function(){$scope.hasSomeValidCriteria=!1,resourceTypes.forEach(function(resourceName){var validCriteria=Criteria.filterCriteria(resourceName,$scope.criteria);validCriteria.length===$scope.criteria.length&&($scope.hasSomeValidCriteria=!0)})}),$scope.searchForCriteria=function(){var deferred=$q.defer();return deferred.resolve([]),deferred.promise}}),angular.module("sb.search").directive("searchResults",function($log,$parse,Criteria,$injector,Preference){"use strict";return{restrict:"A",scope:!0,link:function($scope,$element,args){function handleErrorResult(){$scope.isSearching=!1}function handleSearchResult(results){$scope.searchResults=results,$scope.isSearching=!1}function updateResults(){if($scope.validCriteria=Criteria.filterCriteria(resourceName,criteria),$scope.hasCriteria=criteria.length>0,$scope.hasValidCriteria=searchWithoutCriteria||$scope.validCriteria.length===criteria.length&&$scope.hasCriteria,!$scope.hasValidCriteria)return $scope.searchResults=[],void($scope.isSearching=!1);var params=Criteria.mapCriteria(resourceName,$scope.validCriteria),resource=$injector.get(resourceName);return resource?(params.limit=pageSize,void(params.hasOwnProperty("q")?resource.search(params,handleSearchResult,handleErrorResult):(params.sort_field=$scope.sortField,params.sort_dir=$scope.sortDirection,resource.browse(params,handleSearchResult,handleErrorResult)))):void $log.error("Invalid resource name: "+resourceName)}var resourceName=args.searchResource,pageSize=args.searchPageSize||Preference.get("page_size"),searchWithoutCriteria="true"===args.searchWithoutCriteria,criteria=[];$scope.isSearching=!1,$scope.searchResults=[],$scope.sortField="id",$scope.sortDirection="asc",$scope.toggleFilter=function(fieldName){$scope.sortField===fieldName?$scope.sortDirection="asc"===$scope.sortDirection?"desc":"asc":($scope.sortField=fieldName,$scope.sortDirection="desc"),updateResults()},$scope.$watchCollection($parse(args.searchCriteria),function(results){criteria=results,updateResults()})}}}),angular.module("sb.services").service("Criteria",function($q,$log,$injector,Preference){"use strict";return{filterCriteria:function(resourceName,criteria){var resource=$injector.get(resourceName);return resource&&resource.hasOwnProperty("criteriaFilter")?resource.criteriaFilter(criteria):($log.warn('Attempting to filter criteria for unknown resource "'+resourceName+'"'),[])},mapCriteria:function(resourceName,criteria){var resource=$injector.get(resourceName);return resource&&resource.hasOwnProperty("criteriaMap")?resource.criteriaMap(criteria):($log.warn('Attempting to map criteria for unknown resource "'+resourceName+'"'),{})},create:function(type,value,title){return title=title||value,{type:type,value:value,title:title}},buildCriteriaSearch:function(types,pageSize){pageSize=pageSize||Preference.get("page_size");var resolvers=[];return types.forEach(function(type){var resource=$injector.get(type);return resource.hasOwnProperty("criteriaResolvers")?void resource.criteriaResolvers().forEach(function(resolver){-1===resolvers.indexOf(resolver)&&resolvers.push(resolver)}):void $log.warn('Resource type "'+type+'" does not implement criteriaResolvers.')}),function(searchString){var deferred=$q.defer(),promises=[];return resolvers.forEach(function(resolver){promises.push(resolver(searchString,pageSize))}),$q.all(promises).then(function(results){var criteria=[];results.forEach(function(result){result.forEach(function(item){criteria.push(item)})}),deferred.resolve(criteria)}),deferred.promise}},buildCriteriaFilter:function(parameterMap){return function(criteria){var filteredCriteria=[];return criteria.forEach(function(item){parameterMap.hasOwnProperty(item.type)&&filteredCriteria.push(item)}),filteredCriteria}},buildCriteriaMap:function(parameterMap){return function(criteria){var params={};return criteria.forEach(function(item){parameterMap.hasOwnProperty(item.type)&&(params[parameterMap[item.type]]=item.value)}),params}}}}),angular.module("sb.services").factory("StoryStatus",function(Criteria,$q){"use strict";var validStatusCriteria=[Criteria.create("StoryStatus","active","Active"),Criteria.create("StoryStatus","merged","Merged"),Criteria.create("StoryStatus","invalid","Invalid")];return{criteriaResolver:function(searchString){var deferred=$q.defer();searchString=searchString||"",searchString=searchString.toLowerCase();var criteria=[];return validStatusCriteria.forEach(function(criteriaItem){var title=criteriaItem.title.toLowerCase();(title.indexOf(searchString)>-1||0==="status".indexOf(searchString))&&criteria.push(criteriaItem)}),deferred.resolve(criteria),deferred.promise}}}),angular.module("sb.services").factory("TaskPriority",function(Criteria,$q){"use strict";var validPriorityCriteria=[Criteria.create("TaskPriority","high","High"),Criteria.create("TaskPriority","medium","Medium"),Criteria.create("TaskPriority","low","Low")];return{criteriaResolver:function(searchString){var deferred=$q.defer();searchString=searchString||"",searchString=searchString.toLowerCase();var criteria=[];return validPriorityCriteria.forEach(function(criteriaItem){var title=criteriaItem.title.toLowerCase();(title.indexOf(searchString)>-1||0==="priority".indexOf(searchString))&&criteria.push(criteriaItem)}),deferred.resolve(criteria),deferred.promise}}}),angular.module("sb.services").factory("Text",function(Criteria,$q){"use strict";return{criteriaResolver:function(searchString){var deferred=$q.defer();return deferred.resolve([Criteria.create("Text",searchString)]),deferred.promise}}}),angular.module("sb.services").factory("httpCacheHandler",function($q,$cacheFactory){"use strict";var $httpDefaultCache=$cacheFactory.get("$http");return{response:function(response){var method=response.config.method,url=response.config.url,obj=response.data;switch(method){case"POST":obj.hasOwnProperty("id")&&$httpDefaultCache.put(url+"/"+obj.id,obj);break;case"PUT":$httpDefaultCache.put(url,obj);break;case"DELETE":$httpDefaultCache.remove(url)}return response}}}).config(function($httpProvider){"use strict";$httpProvider.interceptors.push("httpCacheHandler")}),angular.module("sb.services").factory("httpErrorBroadcaster",function($q,$rootScope,Notification,Severity){"use strict";function sendEvent(severity,response){response.status&&Notification.send("http",response.status,severity,response)}return{response:function(response){return response&&sendEvent(Severity.SUCCESS,response),response},responseError:function(response){return response&&sendEvent(Severity.ERROR,response),$q.reject(response)}}}).config(function($httpProvider){"use strict";$httpProvider.interceptors.unshift("httpErrorBroadcaster")}),angular.module("sb.services").run(function(Notification,Priority){"use strict";function filterTemplateRequests(message){if("http"===message.type){var request=message.cause,url=request.config.url;return".html"===url.substr(-5)?!0:void 0}}function filterSuccessful(message){var response=message.cause;if("http"===message.type&&response)return 200===response.status?!0:void 0}function rewriteHttpStatus(message){if("http"===message.type){var httpStatus=message.message,request=message.cause;if(httpStatus&&request&&request.data){var data=request.data,method=request.config.method,url=request.config.url;message.message=httpStatus+": "+method+" "+url+": ",message.message+=data.hasOwnProperty("faultstring")?data.faultstring:"No error details available."}}}Notification.intercept(filterTemplateRequests,Priority.BEFORE),Notification.intercept(filterSuccessful,Priority.LAST),Notification.intercept(rewriteHttpStatus,Priority.AFTER)}),angular.module("sb.services").constant("pageSize",500),angular.module("sb.services").constant("storyboardApiBase","/api/v1"),angular.module("sb.services").factory("Comment",function(ResourceFactory){"use strict";return ResourceFactory.build("/stories/:story_id/comments/:id","/stories/0/search",{id:"@id",story_id:"@story_id"})}),angular.module("sb.services").factory("Event",function($q,$log,TimelineEvent,User){"use strict";return{search:function(storyId){var params={};params.sort_field="id",params.sort_dir="asc",params.story_id=storyId;var deferred=$q.defer();return TimelineEvent.query(params,function(result){var eventResults=[];result.forEach(function(item){item.author=User.get({id:item.author_id}),item.event_info=JSON.parse(item.event_info),eventResults.push(item)}),deferred.resolve(eventResults)},function(){deferred.resolve([])}),deferred.promise}}}),angular.module("sb.services").provider("Preference",function(){"use strict";function preferenceName(key){return"pref_"+key}function Preference($log,localStorageService){this.get=function(key){if(!defaults.hasOwnProperty(key))return $log.warn("Attempt to get unregistered preference: "+key),null;var value=localStorageService.get(preferenceName(key));if(null===value&&defaults.hasOwnProperty(key)){var defaultValue=defaults[key];return this.set(key,defaultValue),defaultValue}return value},this.set=function(key,value){return defaults.hasOwnProperty(key)?localStorageService.set(preferenceName(key),value):($log.warn("Attempt to set unregistered preference: "+key),null)}}var defaults={};this.addPreference=function(preferenceName,preferenceDefault){defaults[preferenceName]=preferenceDefault},this.$get=function($log,localStorageService){return new Preference($log,localStorageService)}}).config(function(PreferenceProvider){"use strict";PreferenceProvider.addPreference("page_size",10)}),angular.module("sb.services").factory("Project",function(ResourceFactory){"use strict";var resource=ResourceFactory.build("/projects/:id","/projects/search",{id:"@id"});return ResourceFactory.applySearch("Project",resource,"name",{Text:"q"}),resource}),angular.module("sb.services").factory("ProjectGroup",function(ResourceFactory){"use strict";var resource=ResourceFactory.build("/project_groups/:id","/project_groups/search",{id:"@id"});return ResourceFactory.applySearch("ProjectGroup",resource,"title",{Text:"title"}),resource}),angular.module("sb.services").factory("ProjectGroupItem",function($resource,storyboardApiBase){"use strict";return $resource(storyboardApiBase+"/project_groups/:projectGroupId/projects/:id",{projectGroupId:"@projectGroupId",id:"@id"},{create:{method:"PUT",transformRequest:function(){return""}},"delete":{method:"DELETE"},query:{method:"GET",isArray:!0,responseType:"json"},browse:{method:"GET",isArray:!0,responseType:"json",cache:!1}})}),angular.module("sb.services").factory("Search",function($q,$log,Project,Story,User,Criteria){"use strict";return{project:function(searchString){var deferred=$q.defer();return Project.search({q:searchString},function(result){var projResults=[];result.forEach(function(item){projResults.push(Criteria.create("project",item.id,item.name))}),deferred.resolve(projResults)},function(){deferred.resolve([])}),deferred.promise},user:function(searchString){var deferred=$q.defer();return User.search({q:searchString},function(result){var userResults=[];result.forEach(function(item){userResults.push(Criteria.create("user",item.id,item.full_name))}),deferred.resolve(userResults)},function(){deferred.resolve([])}),deferred.promise},story:function(searchString){var deferred=$q.defer();return Story.search({q:searchString},function(result){var storyResults=[];result.forEach(function(item){storyResults.push(Criteria.create("story",item.id,item.title))}),deferred.resolve(storyResults)},function(){deferred.resolve([])}),deferred.promise},all:function(searchString){var deferred=$q.defer(),criteria=[];return $q.all({projects:this.project(searchString),stories:this.story(searchString),users:this.user(searchString)}).then(function(results){results.projects.forEach(function(item){criteria.push(item)}),results.stories.forEach(function(item){criteria.push(item)}),results.users.forEach(function(item){criteria.push(item)}),deferred.resolve(criteria)}),deferred.promise}}}),angular.module("sb.services").factory("Story",function(ResourceFactory){"use strict";var resource=ResourceFactory.build("/stories/:id","/stories/search",{id:"@id"});return ResourceFactory.applySearch("Story",resource,"title",{Text:"q",StoryStatus:"status",ProjectGroup:"project_group_id",Project:"project_id",User:"assignee_id"}),resource}),angular.module("sb.services").factory("Subscription",function(ResourceFactory){"use strict";return ResourceFactory.build("/subscriptions/:id","/subscriptions/search",{id:"@id"})}),angular.module("sb.services").factory("SubscriptionEvent",function(ResourceFactory){"use strict";return ResourceFactory.build("/subscription_events/:id","/subscription_events/search",{id:"@id"})}),angular.module("sb.services").factory("Task",function(ResourceFactory){"use strict";var resource=ResourceFactory.build("/tasks/:id","/tasks/search",{id:"@id"});return ResourceFactory.applySearch("Task",resource,null,{Text:"q",TaskStatus:"status",TaskPriority:"priority",Story:"story_id",User:"assignee_id",Project:"project_id",ProjectGroup:"project_group_id"}),resource}),angular.module("sb.services").factory("TaskStatus",function(ResourceFactory){"use strict";var resource=ResourceFactory.build("/task_statuses/:id","/task_statuses/search",{id:"@id"},!0);return ResourceFactory.applySearch("TaskStatus",resource,"name",{Text:"q"}),resource}),angular.module("sb.services").factory("Team",function(ResourceFactory){"use strict";return ResourceFactory.build("/teams/:id","/teams/search",{id:"@id"})}),angular.module("sb.services").factory("TimelineEvent",function(ResourceFactory){"use strict";return ResourceFactory.build("/stories/:story_id/events/:id","/stories/:story_id/events/search",{id:"@id",story_id:"@story_id"})}),angular.module("sb.services").factory("User",function(ResourceFactory){"use strict";var resource=ResourceFactory.build("/users/:id","/users/search",{id:"@id"});return ResourceFactory.applySearch("User",resource,"full_name",{Text:"q"}),resource}),angular.module("sb.services").factory("UserToken",function(ResourceFactory){"use strict";var resource=ResourceFactory.build("/users/:user_id/tokens/:id",null,{user_id:"@user_id",id:"@id"});return resource}),angular.module("sb.services").service("ResourceFactory",function($q,$log,$injector,Criteria,$resource,storyboardApiBase,Preference){"use strict";function getLimit(){return $injector.get("pageSize")}function buildSignature(searchUrl,cacheSearchResults){return cacheSearchResults=!!cacheSearchResults,{create:{method:"POST"},get:{method:"GET",cache:!0},update:{method:"PUT"},"delete":{method:"DELETE"},browse:{method:"GET",isArray:!0,responseType:"json",cache:cacheSearchResults,params:{limit:getLimit}},search:{method:"GET",url:searchUrl,isArray:!0,responseType:"json",cache:cacheSearchResults,params:{limit:getLimit}}}}return{build:function(restUri,searchUri,resourceParameters,cacheSearchResults){if(!restUri)return $log.error("Cannot use resource factory without a base REST uri."),null;cacheSearchResults=!!cacheSearchResults;var signature=buildSignature(storyboardApiBase+searchUri,cacheSearchResults);return $resource(storyboardApiBase+restUri,resourceParameters,signature)},applySearch:function(resourceName,resource,nameField,searchParameters){var criteriaResolvers=[];for(var type in searchParameters){var typeResource=$injector.get(type);typeResource&&typeResource.hasOwnProperty("criteriaResolver")&&criteriaResolvers.push(typeResource.criteriaResolver)}resource.criteriaResolvers=function(){return criteriaResolvers},nameField&&(resource.criteriaResolver=function(searchString,pageSize){pageSize=pageSize||Preference.get("page_size");var deferred=$q.defer(),queryParams={};return queryParams[nameField]=searchString,queryParams.limit=pageSize,resource.browse(queryParams,function(result){var criteriaResults=[];result.forEach(function(item){criteriaResults.push(Criteria.create(resourceName,item.id,item[nameField]))}),deferred.resolve(criteriaResults)},function(){deferred.resolve([])}),deferred.promise}),resource.criteriaFilter=Criteria.buildCriteriaFilter(searchParameters),resource.criteriaMap=Criteria.buildCriteriaMap(searchParameters)}}}),angular.module("sb.story").controller("StoryDeleteController",function($log,$scope,$state,story,$modalInstance){"use strict";$scope.story=story,$scope.isUpdating=!0,$scope.error={},$scope.remove=function(){$scope.story.$delete(function(){$modalInstance.dismiss("success"),$state.go("project.list")})},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.story").controller("StoryDetailController",function($log,$rootScope,$scope,$state,$stateParams,$modal,Story,Session,User,Preference,Event,Comment){"use strict";function handleServiceError(error){$scope.error=error,$scope.isLoading=!1,$scope.isUpdating=!1}function handleServiceSuccess(){$scope.isLoading=!1,$scope.isUpdating=!1}function loadStory(){Story.get({id:id},function(story){$scope.story=story,story.creator_id&&($scope.creator=User.get({id:story.creator_id})),$scope.loadEvents(),handleServiceSuccess()},handleServiceError)}var id=$stateParams.hasOwnProperty("storyId")?parseInt($stateParams.storyId,10):null;$scope.enabled_event_types=Preference.get("display_events_filter"),$scope.loadEvents=function(){Event.search(id).then(function(events){$scope.events=events})},$scope.newComment=new Comment({story_id:id}),$scope.toggleEditMode=function(){Session.isLoggedIn()?($scope.showEditForm=!$scope.showEditForm,setTimeout(function(){$rootScope.$broadcast("elastic:adjust")},1)):$scope.showEditForm=!1},$scope.showEditForm=!1,$scope.creator=null,$scope.isLoading=!0,$scope.isUpdating=!1,$scope.isSavingComment=!1,$scope.error={},$scope.update=function(){$scope.isUpdating=!0,$scope.error={},$scope.story.$update(function(){$scope.showEditForm=!1,handleServiceSuccess()},handleServiceError)},$scope.cancel=function(){loadStory(),$scope.showEditForm=!1},$scope.remove=function(){var modalInstance=$modal.open({templateUrl:"app/stories/template/delete.html",controller:"StoryDeleteController",resolve:{story:function(){return $scope.story}}});return modalInstance.result},$scope.updateFilter=function(){var modalInstance=$modal.open({templateUrl:"app/stories/template/update_filter.html",controller:"TimelineFilterController"});return modalInstance.result.then(function(enabled_event_types){$scope.enabled_event_types=enabled_event_types}),modalInstance.result},$scope.addComment=function(){function resetSavingFlag(){$scope.isSavingComment=!1}return $scope.newComment.content?($scope.isSavingComment=!0,void $scope.newComment.$create(function(){$scope.newComment=new Comment({story_id:id}),resetSavingFlag(),$scope.loadEvents()})):void $log.warn("No content in comment, discarding submission")},loadStory()}),angular.module("sb.story").controller("StoryListController",function($scope,$state,NewStoryService,Criteria){"use strict";$scope.resourceTypes=["Story"],$scope.defaultCriteria=[Criteria.create("StoryStatus","active","Active")],$scope.newStory=function(){NewStoryService.showNewStoryModal().then(function(story){$state.go("story.detail",{storyId:story.id})})}}),angular.module("sb.story").controller("StoryListItemController",function($scope,TaskStatus){"use strict";function getStatusClass(status){var className="";switch(status){case"inprogress":className="text-info";break;case"review":className="text-warning";break;case"merged":className="text-success";break;case"invalid":className="muted";break;default:className=""}return className}switch($scope.expandRow=!1,$scope.status_texts=[],$scope.status_classes=[],TaskStatus.query({},function(items){for(var i=0;i<items.length;i++)$scope.status_texts[items[i].key]=items[i].name,$scope.status_classes[items[i].key]=getStatusClass(items[i].key)}),$scope.story.status){case"active":$scope.statusLabelStyle="label-info";break;case"merged":$scope.statusLabelStyle="label-success";break;case"invalid":$scope.statusLabelStyle="label-default";break;default:$scope.statusLabelStyle="label-default"}}),angular.module("sb.story").controller("StoryModalController",function($scope,$modalInstance,params,Project,Story,Task){"use strict";$scope.projects=Project.browse({}),$scope.story=new Story({title:""}),$scope.tasks=[new Task({title:"",project_id:params.projectId||null})],params.projectId&&Project.get({id:params.projectId},function(project){$scope.asyncProject=project});var lastTitle="",trackingStoryTitle=!0;$scope.$on("$destroy",$scope.$watch(function(){return $scope.story.title},function(newTitle){if(trackingStoryTitle){var task=$scope.tasks[0];trackingStoryTitle&&task.title===lastTitle?(task.title=newTitle,lastTitle=newTitle):trackingStoryTitle=!1}})),$scope.save=function(){$scope.story.$create(function(story){var resolvingTasks=$scope.tasks.length;$scope.tasks.forEach(function(task){task.story_id=story.id,task.$create(function(){resolvingTasks--,0===resolvingTasks&&$modalInstance.close(story)})})})},$scope.close=function(){$modalInstance.dismiss("cancel")},$scope.addTask=function(){var lastTask=$scope.tasks[$scope.tasks.length-1],project_id=lastTask.project_id;project_id||(project_id=params.projectId||null);var current_task=new Task({project_id:project_id});project_id&&Project.get({id:project_id},function(project){$scope.asyncProject=project}),$scope.tasks.push(current_task)},$scope.removeTask=function(task){if(!($scope.tasks.length<2)){var idx=$scope.tasks.indexOf(task);$scope.tasks.splice(idx,1)}},$scope.searchProjects=function(value){return Project.browse({name:value,limit:10}).$promise},$scope.formatProjectName=function(model){return model?model.name:""},$scope.selectNewProject=function(model,task){task.project_id=model.id}}),angular.module("sb.story").controller("StoryTaskDeleteController",function($log,$scope,$state,task,$modalInstance,params){"use strict";$scope.task=task,$scope.params=params,$scope.isUpdating=!0,$scope.error={},$scope.remove=function(){$scope.task.$delete(function(){$modalInstance.close("success")})},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.story").controller("StoryTaskListController",function($log,$scope,$state,$stateParams,Task){"use strict";var id=$stateParams.hasOwnProperty("storyId")?parseInt($stateParams.storyId,10):null;$scope.tasks=[],$scope.showAddTaskForm=!1,$scope.newTask=new Task({story_id:id,status:"todo",priority:"medium"}),$scope.isLoading=!0,$scope.error={},$scope.loadTasks=function(){$scope.tasks=[],Task.browse({story_id:id},function(result){$scope.tasks=result},function(error){$scope.error=error,$scope.isLoading=!1,$scope.isUpdating=!1})},$scope.saveTask=function(){var savingTask=new Task(angular.copy($scope.newTask));savingTask.$save(function(savedTask){$scope.tasks.push(savedTask),$scope.$parent.loadEvents()})},$scope.loadTasks()}),angular.module("sb.story").controller("StoryTaskListItemController",function($scope,$state,$modal){"use strict";$scope.updateStatus=function(status){$scope.task.status=status,$scope.updateTaskInline()},$scope.updatePriority=function(priority){$scope.task.priority=priority,$scope.updateTaskInline()},$scope.removeTask=function(){var modalInstance=$modal.open({templateUrl:"app/stories/template/delete_task.html",controller:"StoryTaskDeleteController",resolve:{task:function(){return $scope.task
},params:function(){return{lastTask:1===$scope.tasks.length}}}});modalInstance.result.then(function(){$scope.loadTasks(),$scope.$parent.$parent.loadEvents()})},$scope.updateTask=function(){$scope.task.$update(function(){$scope.loadTasks(),$scope.showTaskEditForm=!1,$scope.$parent.$parent.loadEvents()})},$scope.updateTaskInline=function(){$scope.task.$update(function(){$scope.$parent.$parent.loadEvents()})}}),angular.module("sb.story").controller("TimelineFilterController",function($scope,$modalInstance,Preference){"use strict";function init(){$scope.enabled_event_types=Preference.get("display_events_filter")}$scope.close=function(){$modalInstance.dismiss("cancel")},$scope.save=function(){return Preference.set("display_events_filter",$scope.enabled_event_types),$modalInstance.close($scope.enabled_event_types)},init()}),angular.module("sb.story").factory("NewStoryService",function($modal,$log,Session,SessionModalService){"use strict";return{showNewStoryModal:function(projectId){if(Session.isLoggedIn()){var modalInstance=$modal.open({templateUrl:"app/stories/template/new.html",controller:"StoryModalController",resolve:{params:function(){return{projectId:projectId||null}}}});return modalInstance.result}return SessionModalService.showLoginRequiredModal()}}}),angular.element(document).ready(function(){"use strict";function initializeApplication(config){for(var key in config)$log.debug("Configuration: "+key+" -> "+config[key]),angular.module("storyboard").constant(key,config[key]);angular.bootstrap(document,["storyboard"])}var initInjector=angular.injector(["ng"]),$http=initInjector.get("$http"),$log=initInjector.get("$log");$log.info("Attempting to load parameters from ./config.json"),$http.get("./config.json").then(function(response){initializeApplication(response.data)},function(){$log.warn("Cannot load ./config.json, using defaults."),initializeApplication({})})}),angular.module("storyboard").controller("ApplicationController",function($scope,$state,$rootScope){"use strict";function hasSubmenu(state){for(var stateName in state.views)if(stateName.match(/^submenu@/))return!0;return state.parent?hasSubmenu(state.parent):!1}$rootScope.$on("$stateChangeSuccess",function(){$scope.hasSubmenu=hasSubmenu($state.$current)}),$scope.hasSubmenu=!1}),angular.module("storyboard").controller("HeaderController",function($q,$scope,$rootScope,$state,NewStoryService,Session,SessionState,CurrentUser,Criteria,Notification,Priority,Project,Story,ProjectGroup){"use strict";function resolveCurrentUser(){CurrentUser.resolve().then(function(user){$scope.currentUser=user},function(){$scope.currentUser=null})}resolveCurrentUser(),$scope.currentUser=null,$scope.newStory=function(){NewStoryService.showNewStoryModal().then(function(story){$state.go("story.detail",{storyId:story.id})})},$scope.logout=function(){Session.destroySession()},$scope.searchString="",$scope.search=function(criteria){switch(criteria.type){case"Text":$state.go("search",{q:criteria.value});break;case"ProjectGroup":$state.go("project_group.detail",{id:criteria.value});break;case"Project":$state.go("project.detail",{id:criteria.value});break;case"Story":$state.go("story.detail",{storyId:criteria.value})}$scope.searchString=""},$scope.quickSearch=function(searchString){var deferred=$q.defer();searchString=searchString||"";var searches=[];if(searchString.match(/^[0-9]+$/)){var getProjectGroupDeferred=$q.defer(),getProjectDeferred=$q.defer(),getStoryDeferred=$q.defer();ProjectGroup.get({id:searchString},function(result){getProjectGroupDeferred.resolve(Criteria.create("ProjectGroup",result.id,result.name))},function(){getProjectGroupDeferred.resolve(null)}),Project.get({id:searchString},function(result){getProjectDeferred.resolve(Criteria.create("Project",result.id,result.name))},function(){getProjectDeferred.resolve(null)}),Story.get({id:searchString},function(result){getStoryDeferred.resolve(Criteria.create("Story",result.id,result.title))},function(){getStoryDeferred.resolve(null)}),searches.push(getProjectGroupDeferred.promise),searches.push(getProjectDeferred.promise),searches.push(getStoryDeferred.promise)}else searches.push(ProjectGroup.criteriaResolver(searchString,5)),searches.push(Project.criteriaResolver(searchString,5)),searches.push(Story.criteriaResolver(searchString,5));return $q.all(searches).then(function(searchResults){for(var criteria=[Criteria.create("Text",searchString)],addResult=function(item){criteria.push(item)},i=0;i<searchResults.length;i++){var results=searchResults[i];results&&(results.forEach?results.forEach(addResult):addResult(results))}deferred.resolve(criteria)}),deferred.promise},Notification.intercept(function(message){switch(message.type){case SessionState.LOGGED_IN:resolveCurrentUser();break;case SessionState.LOGGED_OUT:$scope.currentUser=null}},Priority.LAST)}),angular.module("sb.util").directive("subscribe",function(CurrentUser,Notification,Priority,SessionState,Session,Subscription){"use strict";return{restrict:"E",scope:{resource:"@",resourceId:"="},templateUrl:"app/subscription/template/subscribe.html",link:function($scope){function setSubscription(subscription){$scope.subscription=subscription||null,$scope.subscribed=!!$scope.subscription}function resolveSubscription(){return Session.isLoggedIn()?($scope.resolving=!0,void cuPromise.then(function(user){Subscription.browse({user_id:user.id,target_type:$scope.resource,target_id:$scope.resourceId},function(results){setSubscription(results[0]),$scope.resolving=!1},function(){setSubscription(),$scope.resolving=!1})})):void setSubscription()}var cuPromise=CurrentUser.resolve();$scope.enabled=Session.isLoggedIn(),$scope.subscribed=!1,$scope.resolving=!1,$scope.subscription=null,$scope.currentUser=null,cuPromise.then(function(user){$scope.currentUser=user});var removeNotifier=Notification.intercept(function(message){switch(message.type){case SessionState.LOGGED_IN:$scope.enabled=!0,resolveSubscription();break;case SessionState.LOGGED_OUT:$scope.enabled=!1,$scope.subscribed=!1}},Priority.LAST);$scope.$on("$destroy",removeNotifier),$scope.toggleSubscribe=function(){$scope.resolving||($scope.resolving=!0,$scope.subscription?$scope.subscription.$delete(function(){setSubscription(),$scope.resolving=!1},function(){$scope.resolving=!1}):cuPromise.then(function(user){var sub=new Subscription({user_id:user.id,target_type:$scope.resource,target_id:$scope.resourceId});sub.$create(function(result){setSubscription(result),$scope.resolving=!1},function(){$scope.resolving=!1})}))},resolveSubscription()}}}),angular.module("sb.util").constant("TimelineEventTypes",["story_created","story_details_changed","task_created","task_assignee_changed","task_status_changed","task_priority_changed","task_details_changed","task_deleted","user_comment"]),angular.module("sb.util").run(function($rootScope){"use strict";var regex="^[a-zA-Z0-9]+([\\-\\./]?[a-zA-Z0-9]+)*$";$rootScope.PROJECT_NAME_REGEX=new RegExp(regex)}),angular.module("sb.util").directive("tagComplete",function($q,$parse,$rootScope,$position,typeaheadParser,$timeout){"use strict";var HOT_KEYS=[9,13,27,38,40];return{restrict:"EA",replace:!0,scope:{tagCompleteTags:"=",tagCompleteLabelField:"@",tagCompleteTagTemplateUrl:"=",tagCompleteOptionTemplateUrl:"=",tagCompleteVerify:"&",tagCompleteOnSelect:"&",tagCompleteLoading:"&"},templateUrl:"app/util/template/tag_complete.html",link:function($scope,$element,attrs){var $input=$element.find("input");$element[0].focus=function(){$input[0].focus()};var parserResult=typeaheadParser.parse(attrs.tagComplete),isLoadingSetter=function(isLoading){$scope.tagCompleteLoading&&$scope.tagCompleteLoading({isLoading:isLoading})};$scope.tagCompleteTemplateUrl=$parse(attrs.tagCompleteTemplateUrl),$scope.hasFocus=!1;var resetMatches=function(){$scope.matches=[],$scope.activeIdx=-1},getMatchesAsync=function(inputValue){if($scope.hasFocus&&inputValue){var locals={$viewValue:inputValue};isLoadingSetter(!0),$q.when(parserResult.source($scope.$parent,locals)).then(function(matches){if(inputValue===$scope.newTagName&&$scope.hasFocus){$scope.matches=[];for(var i=0;i<matches.length;i++)$scope.matches.push({label:parserResult.viewMapper($scope.$parent,locals),model:matches[i]});matches.length>0?($scope.activeIdx=0,$scope.query=inputValue):resetMatches(),isLoadingSetter(!1),$scope.position=$position.position($element),$scope.position.top=$scope.position.top+$element.prop("offsetHeight")}},function(){resetMatches(),isLoadingSetter(!1)})}};$scope.$watch(function(){return $scope.newTagName},getMatchesAsync),$input.on("focus",function(){$scope.hasFocus=!0,$rootScope.$$phase||$scope.$digest()}),$input.on("blur",function(){$timeout(function(){resetMatches(),$scope.newTagName="",$scope.hasFocus=!1,$rootScope.$$phase||$scope.$digest()},200)}),$input.on("keydown",function(evt){0!==$scope.matches.length&&-1!==HOT_KEYS.indexOf(evt.which)&&(evt.preventDefault(),40===evt.which?($scope.activeIdx=($scope.activeIdx+1)%$scope.matches.length,$scope.$digest()):38===evt.which?($scope.activeIdx=($scope.activeIdx?$scope.activeIdx:$scope.matches.length)-1,$scope.$digest()):13===evt.which||9===evt.which?$scope.$apply(function(){$scope.select($scope.activeIdx)}):27===evt.which&&(evt.stopPropagation(),resetMatches(),$scope.$digest()))}),$scope.deletePressed=function(){var selectedTags=$scope.tagCompleteTags||[];return selectedTags.length>0&&!$scope.newTagName?(selectedTags.pop(),!0):void 0},$scope.focus=function(){$input[0].focus()},$scope.noFocus=function(event){event.stopImmediatePropagation()},$scope.select=function(idx){var item=$scope.matches[idx].model;$scope.tagCompleteTags.push(item),$scope.newTagName="",resetMatches(),$scope.tagCompleteOnSelect&&$scope.tagCompleteOnSelect({tag:item})},$scope.removeTag=function(tag){if($scope.tagCompleteTags){var idx=$scope.tagCompleteTags.indexOf(tag);idx>-1&&$scope.tagCompleteTags.splice(idx,1)}},resetMatches()}}}).directive("tagCompleteTag",function($http,$templateCache,$compile,$parse){"use strict";return{restrict:"EA",scope:{index:"=",tag:"=",labelField:"=",removeTag:"&"},link:function(scope,element,attrs){var tplUrl=$parse(attrs.templateUrl)(scope.$parent)||"/tag_complete/default_tag_template.html";$http.get(tplUrl,{cache:$templateCache}).success(function(tplContent){element.replaceWith($compile(tplContent.trim())(scope))})}}}),angular.module("sb.util").directive("tagInput",function(){"use strict";return{restrict:"E",replace:!0,scope:{selectedTags:"=ngModel"},require:"ngModel",controller:"TagInputController",templateUrl:"app/util/template/tag_input.html"}}),angular.module("sb.util").controller("TagInputController",function($element,$scope){"use strict";$scope.newTagName="",$scope.deletePressed=function(){return 0===$scope.newTagName.length?($scope.selectedTags.pop(),!0):!1},$scope.addTag=function(){$scope.selectedTags||($scope.selectedTags=[]),$scope.newTagName.length>0&&-1===$scope.selectedTags.indexOf($scope.newTagName)&&($scope.selectedTags.push($scope.newTagName),$scope.newTagName="")},$scope.focus=function(){$element.find("input[name=tagInputField]").focus()},$scope.noFocus=function(event){event.stopImmediatePropagation()}}),angular.module("sb.util").directive("activePath",function($location,$rootScope){"use strict";return{link:function($scope,element,attrs){function setActivePath(){var path=$location.path(),isMatchedPath=null!==path.match(activePath);element.toggleClass("active",isMatchedPath)}var activePath=attrs.activePath,disconnectBinding=$rootScope.$on("$stateChangeSuccess",setActivePath);$scope.$on("$destroy",disconnectBinding),setActivePath()}}}),angular.module("sb.util").directive("autoresizeWidth",function($document){"use strict";return{link:function($scope,$element){function recalculateSize(event){var value=$element.val()||"M";event&&"keypress"===event.type&&(value+=String.fromCharCode(event.which)),shadow.text(value),shadow.css("display","inline-block");try{$element[0].offsetWidth=shadow[0].offsetWidth}finally{shadow.css("display","none")}}var shadow=angular.element("<span></span>");shadow.attr("class",$element.attr("class")),shadow.css({display:"none","white-space":"pre",width:"auto",visibility:"hidden"}),$document.find("body").append(shadow),$scope.$on("$destroy",function(){shadow.remove()}),$element.bind("keypress keyup",recalculateSize),recalculateSize()}}}),angular.module("sb.util").directive("ngDelete",function(){"use strict";return function(scope,element,attrs){element.bind("keydown keypress",function(event){if(8===event.which){var preventDefault=!1;scope.$apply(function(){preventDefault=scope.$eval(attrs.ngDelete)}),preventDefault&&event.preventDefault()}})}}),angular.module("sb.util").directive("ngEnter",function(){"use strict";return function(scope,element,attrs){element.bind("keydown keypress",function(event){13===event.which&&(scope.$apply(function(){scope.$eval(attrs.ngEnter)}),event.preventDefault())})}}),angular.module("sb.util").directive("focus",function($timeout){"use strict";return{link:function($scope,$element,$attrs){var focus=$scope.$eval($attrs.focus);if(void 0===focus&&(focus=!0),focus){var e=$element[0];e&&e.focus&&$timeout(function(){e.focus()},10)}}}}),angular.module("sb.util").directive("inputInline",function(){"use strict";return{require:"ngModel",restrict:"E",templateUrl:"app/util/template/input_inline.html",scope:{enabled:"=",asInline:"=",autoFocus:"=",onChange:"&",emptyPrompt:"@",emptyDisabledPrompt:"@",maxLength:"="},link:function($scope,element,attrs,ngModel){$scope.showForm=!$scope.asInline,$scope.toggleForm=function(){$scope.showForm=$scope.asInline?$scope.enabled?!$scope.showForm:!1:!0},$scope.onInputBlur=function(value){value!==ngModel.$viewValue&&(ngModel.$setViewValue(value),$scope.onChange()),$scope.toggleForm()},$scope.$watch(function(){return ngModel.$viewValue},function(value){$scope.inputText!==value&&($scope.inputText=value?value:"")})}}}),angular.module("sb.util").directive("projectTypeahead",function(Project,$timeout){"use strict";return{require:"ngModel",restrict:"E",templateUrl:"app/util/template/project_typeahead.html",scope:{enabled:"=",asInline:"=",autoFocus:"=",onChange:"&",emptyPrompt:"@",emptyDisabledPrompt:"@"},link:function($scope,element,attrs,ngModel){$scope.showForm=!$scope.asInline,$scope.toggleForm=function(){$scope.asInline&&$scope.showForm?$timeout(function(){$scope.showForm=$scope.enabled?!$scope.showForm:!1},200):$scope.showForm=!0},$scope.searchProjects=function(value){return Project.browse({name:value,limit:10}).$promise},$scope.loadProject=function(){var projectId=ngModel.$viewValue||null;projectId?$scope.project=Project.get({id:projectId},function(project){$scope.selectedProject=project},function(){$scope.project=null,$scope.selectedProject=null}):($scope.project=null,$scope.selectedProject=null)},$scope.updateViewValue=function(value){value!==ngModel.$viewValue&&(ngModel.$setViewValue(value),$scope.onChange())},$scope.formatProjectName=function(model){return model?model.name:""},$scope.$watch(function(){return ngModel.$viewValue},$scope.loadProject)}}}),angular.module("sb.util").directive("resolveStory",function($parse,Story){"use strict";return{restrict:"A",scope:!0,link:function($scope,$element,$attrs){var storyId=$parse($attrs.resolveStory)($scope.$parent);$scope.story=storyId?Story.get({id:storyId}):null}}}),angular.module("sb.util").directive("ngShiftEnter",function(){"use strict";return function(scope,element,attrs){element.bind("keydown keypress",function(event){13===event.which&&event.shiftKey&&(scope.$apply(function(){scope.$eval(attrs.ngShiftEnter)}),event.preventDefault())})}}),angular.module("sb.util").directive("storyStatusLabel",function(){"use strict";return{restrict:"E",templateUrl:"app/util/template/story_status_label.html",scope:{story:"="},controller:function($scope){function getStoryStatus(){return $scope.story?$scope.story.status:null}function updateStoryLabel(){switch(getStoryStatus()){case"invalid":$scope.labelStyle="label-default";break;case"active":$scope.labelStyle="label-info";break;case"merged":$scope.labelStyle="label-success";break;default:$scope.labelStyle="label-default"}}var unwatch=$scope.$watch(getStoryStatus,updateStoryLabel);$scope.$on("$destroy",unwatch),updateStoryLabel()}}}),angular.module("sb.util").directive("storyTaskStatus",function(TaskStatus){"use strict";return{restrict:"E",templateUrl:"app/util/template/story_task_status.html",scope:{story:"="},link:function($scope){TaskStatus.query({},function(items){for(var statuses=[],i=0;i<items.length;i++)statuses[items[i].key]=items[i].name;$scope.status_texts=statuses})}}}),angular.module("sb.util").directive("taskPriorityDropdown",function(){"use strict";return{restrict:"E",templateUrl:"app/util/template/task_priority_dropdown.html",scope:{priority:"@",onChange:"&",editable:"@"},link:function($scope){$scope.style="default",$scope.setPriority=function(newPriority){newPriority!==$scope.priority&&($scope.priority=newPriority,$scope.onChange({priority:newPriority}))}}}}),angular.module("sb.util").directive("taskStatusDropdown",function(TaskStatus){"use strict";function setStyle(status){switch(status){case"invalid":return"default";case"merged":return"success";case"inprogress":return"info";case"review":return"warning";case"todo":return"default";default:return"default"}}return{restrict:"E",templateUrl:"app/util/template/task_status_dropdown.html",scope:{status:"@",onChange:"&",editable:"@"},link:function($scope){TaskStatus.query({},function(items){$scope.taskStatuses=items,$scope.statusName=$scope.status;for(var i=0;i<items.length;i++)items[i].key===$scope.status&&($scope.statusName=items[i].name)}),$scope.style=setStyle($scope.status),$scope.setStatus=function(newStatus){if(newStatus!==$scope.status){$scope.style=setStyle(newStatus),$scope.status=newStatus;for(var i=0;i<$scope.taskStatuses.length;i++)$scope.taskStatuses[i].key===$scope.status&&($scope.statusName=$scope.taskStatuses[i].name);$scope.onChange({status:newStatus})}}}}}),angular.module("sb.util").directive("timeMoment",function(DateUtil){"use strict";return{restrict:"A",templateUrl:"app/util/template/time_moment.html",scope:{eventdate:"="},controller:function($scope){function updateTimeAgo(){$scope.needsTimeAgo=DateUtil.needsTimeAgo($scope.eventdate)}var unwatch=$scope.$watch(updateTimeAgo);$scope.$on("$destroy",unwatch),updateTimeAgo()}}}),angular.module("sb.util").directive("timelineEvent",function($log){"use strict";return{restrict:"E",replace:!0,link:function(scope,element,attrs){var tlEvent;try{tlEvent=JSON.parse(attrs.tlEvent),scope.event_type=tlEvent.event_type}catch(error){$log.warn(error),scope.event_type="unknown"}},templateUrl:"app/stories/template/comments/template_switch.html"}}),angular.module("sb.util").directive("userTypeahead",function(User,$timeout){"use strict";return{require:"ngModel",restrict:"E",templateUrl:"app/util/template/user_typeahead.html",scope:{enabled:"=",asInline:"=",autoFocus:"=",onChange:"&",emptyPrompt:"@",emptyDisabledPrompt:"@"},link:function($scope,element,attrs,ngModel){$scope.showForm=!$scope.asInline,$scope.toggleForm=function(){$scope.asInline&&$scope.showForm?$timeout(function(){$scope.showForm=$scope.enabled?!$scope.showForm:!1},200):$scope.showForm=!0},$scope.searchUsers=function(value){return User.browse({full_name:value,limit:10}).$promise},$scope.loadUser=function(){var userId=ngModel.$viewValue||null;userId?User.get({id:userId},function(user){$scope.user=user,$scope.selectedUser=user},function(){$scope.user=null,$scope.selectedUser=null}):($scope.user=null,$scope.selectedUser=null)},$scope.updateViewValue=function(value){value!==ngModel.$viewValue&&(ngModel.$setViewValue(value),$scope.onChange())},$scope.formatUserName=function(model){return model?model.full_name:""},$scope.$watch(function(){return ngModel.$viewValue},$scope.loadUser)}}}),angular.module("sb.util").filter("capitalize",function(){"use strict";return function(value){try{return value.charAt(0).toUpperCase()+value.slice(1)}catch(e){return value}}}),angular.module("sb.util").filter("debug",function(){"use strict";return function(value){return console.warn("DEBUG",value),value}}),angular.module("sb.util").filter("taskPriorityLabel",function(){"use strict";return function(value){switch(value){case"high":return"High";case"medium":return"Medium";case"low":return"Low";default:return"Unknown Priority"}}}),angular.module("sb.util").filter("truncate",function(){"use strict";return function(value,length){return value&&value.length>length&&(value=value.substr(0,length-3)+"..."),value}}),angular.module("sb.util").factory("ArrayUtil",function(){"use strict";return{intersection:function(A,B){var result=[];return A.forEach(function(item){B.indexOf(item)>-1&&result.push(item)}),result},difference:function(U,A){var result=[];return U.forEach(function(item){-1===A.indexOf(item)&&result.push(item)}),result}}}),angular.module("sb.util").factory("DateUtil",function(){"use strict";return{needsTimeAgo:function(targetDate){if(targetDate){var currentDate=(new Date).getTime(),daydiff=(currentDate-Date.parse(targetDate))/864e5;return 1>daydiff}return!0}}}),angular.module("sb.util").factory("StringUtil",function(){"use strict";var defaultLength=32,alphaNumeric="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";return{randomAlphaNumeric:function(length){return this.random(length,alphaNumeric)},random:function(length,characters){length=length||defaultLength,characters=characters||alphaNumeric;for(var text="",i=0;length>i;i++)text+=characters.charAt(Math.floor(Math.random()*characters.length));return text}}}),angular.module("sb.util").factory("UrlUtil",function($window){"use strict";return{getFullUrlPrefix:function(){var origin=$window.location.origin,path=$window.location.pathname;return origin+path},buildApplicationUrl:function(fragment){return this.getFullUrlPrefix()+"#!"+fragment},serializeParameters:function(params){var pairs=[];for(var prop in params)params.hasOwnProperty(prop)&&pairs.push(encodeURIComponent(prop)+"="+encodeURIComponent(params[prop]));return pairs.join("&")},deserializeParameters:function(queryString){for(var params={},queryComponents=queryString.split("&"),i=0;i<queryComponents.length;i++){var parts=queryComponents[i].split("="),key=decodeURIComponent(parts[0])||null,value=decodeURIComponent(parts[1])||null;key&&value&&(params[key]=value)}return params}}}),angular.module("sb.util").factory("$searchParams",function($window,UrlUtil){"use strict";var params={},search=$window.location.search;return search?("?"===search.charAt(0)&&(search=search.substr(1)),UrlUtil.deserializeParameters(search)):params}),angular.module("sb.util").factory("LastLocation",function($rootScope,localStorageService){"use strict";function onLocationChange(event,toLocation){var url=new URL(toLocation),hash=url.hash||"#!/",trimmed_hash=hash.slice(2);-1===trimmed_hash.indexOf("/auth")&&localStorageService.set("lastLocation",trimmed_hash)}return{get:function(){return localStorageService.get("lastLocation")},_initialize:function(){$rootScope.$on("$destroy",$rootScope.$on("$locationChangeStart",onLocationChange))}}}).run(function(LastLocation){"use strict";LastLocation._initialize()});