angular.module("sb.auth",["sb.services","sb.templates","ui.router","sb.util","LocalStorageModule"]).config(function($stateProvider,SessionResolver){"use strict";$stateProvider.state("auth",{"abstract":!0,template:"<div ui-view></div>",url:"/auth"}).state("auth.authorize",{url:"/authorize?error&error_description",templateUrl:"app/templates/auth/busy.html",controller:"AuthAuthorizeController",resolve:{isLoggedOut:SessionResolver.requireLoggedOut}}).state("auth.deauthorize",{url:"/deauthorize",templateUrl:"app/templates/auth/busy.html",controller:"AuthDeauthorizeController",resolve:{isLoggedIn:SessionResolver.requireLoggedIn}}).state("auth.token",{url:"/token?code&state&error&error_description",templateUrl:"app/templates/auth/busy.html",controller:"AuthTokenController",resolve:{isLoggedOut:SessionResolver.requireLoggedOut}}).state("auth.error",{url:"/error?error&error_description",templateUrl:"app/templates/auth/error.html",controller:"AuthErrorController"})}).run(function($rootScope,SessionState,Session,PermissionManager,RefreshManager){"use strict";PermissionManager.initialize(),$rootScope.$on(SessionState.LOGGED_IN,function(){$rootScope.isLoggedIn=Session.isLoggedIn()}),$rootScope.$on(SessionState.LOGGED_OUT,function(){$rootScope.isLoggedIn=Session.isLoggedIn()}),RefreshManager.scheduleRefresh()}),angular.module("sb.dashboard",["sb.services","sb.templates","sb.auth","ui.router","ui.bootstrap"]).config(function($stateProvider,SessionResolver){"use strict";$stateProvider.state("index",{url:"/",templateUrl:"app/templates/dashboard/index.html",controller:"HomeController",resolve:{sessionState:SessionResolver.resolveSessionState}}).state("dashboard",{url:"/dashboard",templateUrl:"app/templates/dashboard/dashboard.html",controller:"DashboardController",resolve:{sessionState:SessionResolver.requireLoggedIn,currentUser:SessionResolver.requireCurrentUser}})}),angular.module("sb.notification",[]),angular.module("sb.pages",["sb.services","sb.templates","sb.pages","ui.router"]).config(function($stateProvider){"use strict";$stateProvider.state("page",{"abstract":!0,url:"/page",template:"<div ui-view></div>"}).state("page.about",{url:"/about",templateUrl:"app/templates/page/about.html"})}),angular.module("sb.profile",["sb.services","sb.templates","sb.auth","ui.router","ui.bootstrap"]).config(function($stateProvider,SessionResolver,$urlRouterProvider){"use strict";$urlRouterProvider.when("/profile","/profile/preferences"),$stateProvider.state("profile",{"abstract":!0,template:"<div ui-view></div>",url:"/profile",resolve:{isLoggedIn:SessionResolver.requireLoggedIn,currentUser:SessionResolver.requireCurrentUser}}).state("profile.preferences",{url:"/preferences",templateUrl:"app/templates/profile/preferences.html",controller:"ProfilePreferencesController"})}),angular.module("sb.projects",["ui.router","sb.services","sb.util","sb.auth"]).config(function($stateProvider,$urlRouterProvider,SessionResolver,PermissionResolver){"use strict";$urlRouterProvider.when("/project","/project/list"),$stateProvider.state("project",{"abstract":!0,url:"/project",template:"<div ui-view></div>",resolve:{isSuperuser:PermissionResolver.resolvePermission("is_superuser",!0)}}).state("project.list",{url:"/list",templateUrl:"app/templates/project/list.html",controller:"ProjectListController"}).state("project.detail",{url:"/{id:[0-9]+}",templateUrl:"app/templates/project/detail.html",controller:"ProjectDetailController"}).state("project.new",{url:"/new",templateUrl:"app/templates/project/new.html",controller:"ProjectNewController",resolve:{isLoggedIn:SessionResolver.requireLoggedIn,isSuperuser:PermissionResolver.requirePermission("is_superuser",!0)}})}),angular.module("sb.services",["ngResource","sb.notification"]),angular.module("sb.story",["ui.router","sb.services","sb.util","ui.bootstrap"]).config(function($stateProvider,$urlRouterProvider,PreferenceProvider,TimelineEventTypes){"use strict";$urlRouterProvider.when("/story","/story/list"),$stateProvider.state("story",{"abstract":!0,url:"/story",template:"<div ui-view></div>"}).state("story.list",{url:"/list",templateUrl:"app/templates/story/list.html",controller:"StoryListController"}).state("story.detail",{url:"/{storyId:[0-9]+}",templateUrl:"app/templates/story/detail.html"});var events_filter_defaults={};TimelineEventTypes.forEach(function(type){events_filter_defaults[type]=!0}),PreferenceProvider.addPreference("display_events_filter",events_filter_defaults)}),angular.module("storyboard",["sb.services","sb.templates","sb.dashboard","sb.pages","sb.projects","sb.auth","sb.story","sb.profile","sb.notification","ui.router","ui.bootstrap","monospaced.elastic","angularMoment"]).constant("angularMomentConfig",{preprocess:"utc",timezone:"UTC"}).config(function($provide,$urlRouterProvider,$locationProvider,$httpProvider,msdElasticConfig){"use strict";$urlRouterProvider.otherwise("/"),$locationProvider.hashPrefix("!"),$httpProvider.defaults.headers.common["X-Client"]="StoryBoard",msdElasticConfig.append="\n"}).run(function($log,$rootScope,$state){"use strict";$rootScope.$on("$stateChangeError",function(){$state.go("index")})}),angular.module("sb.util",["ui.router","LocalStorageModule"]).run(function(){"use strict";angular.element.prototype.hide=function(){this.addClass("ng-hide")},angular.element.prototype.show=function(){this.removeClass("ng-hide")}}),angular.module("sb.auth").controller("AuthAuthorizeController",function($stateParams,$state,$log,OpenId,$window,LastLocation,localStorageService){"use strict";return $stateParams.error?($log.debug("Error received, redirecting to auth.error."),void $state.go("auth.error",$stateParams)):(localStorageService.set("lastPath",LastLocation.get()),void OpenId.authorize())}),angular.module("sb.auth").controller("AuthDeauthorizeController",function(Session,$state,$log){"use strict";$log.debug("Logging out"),Session.destroySession(),$state.go("index")}),angular.module("sb.auth").controller("AuthErrorController",function($scope,$stateParams){"use strict";$scope.error=$stateParams.error||"Unknown",$scope.errorDescription=$stateParams.error_description||"No description received from server."}),angular.module("sb.auth").controller("AuthTokenController",function($state,$log,OpenId,Session,$searchParams,$window,UrlUtil,LastLocation){"use strict";function buildNextPath(){var location=LastLocation.get();return location.indexOf("/auth")>-1&&(location="/"),location}return $searchParams.error?($log.debug("Error received, redirecting to auth.error."),void $state.go("auth.error",$searchParams)):void OpenId.token($searchParams).then(function(token){Session.updateSession(token).then(function(){var nextPath=buildNextPath();$window.location.href=UrlUtil.buildApplicationUrl(nextPath)})},function(error){Session.destroySession(),$state.go("auth.error",error)})}),angular.module("sb.auth").controller("LoginRequiredModalController",function($state,$scope,$modalInstance){"use strict";$scope.login=function(){$state.go("auth.authorize"),$modalInstance.dismiss("success")},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.util").directive("permission",function($log,PermissionManager){"use strict";return{restrict:"A",link:function($scope,element,attrs){element.hide();var permName=attrs.permission,permValue=attrs.permissionValue||!0;PermissionManager.listen($scope,permName,function(actualValue){actualValue&&actualValue.toString()===permValue.toString()?element.show():element.hide()})}}}),angular.module("sb.auth").factory("httpAuthorizationHeader",function(AccessToken){"use strict";return{request:function(request){var token=AccessToken.getAccessToken(),type=AccessToken.getTokenType();return token&&(request.headers.Authorization=type+" "+token),request}}}).config(function($httpProvider){"use strict";$httpProvider.interceptors.push("httpAuthorizationHeader")}),angular.module("sb.auth").value("SessionState",{LOGGED_IN:"logged_in",LOGGED_OUT:"logged_out",PENDING:"pending"}),angular.module("sb.auth").constant("PermissionResolver",{requirePermission:function(permName,requiredValue){"use strict";return function($q,$log,PermissionManager){var deferred=$q.defer();return PermissionManager.resolve(permName).then(function(value){$log.debug("permission:",permName,requiredValue,value),value===requiredValue?deferred.resolve(value):deferred.reject(value)},function(error){$log.debug("permission:",error),deferred.reject(error)}),deferred.promise}},resolvePermission:function(permName){"use strict";return function($q,$log,PermissionManager){var deferred=$q.defer();return PermissionManager.resolve(permName).then(function(value){deferred.resolve(value)},function(){deferred.resolve(!1)}),deferred.promise}}}),angular.module("sb.auth").constant("SessionResolver",function(){"use strict";function resolveSessionState(deferred,desiredSessionState,Session){return function(){var sessionState=Session.getSessionState();sessionState===desiredSessionState?deferred.resolve(sessionState):deferred.reject(sessionState)}}return{resolveSessionState:function($q,$log,Session,SessionState){var deferred=$q.defer();return $log.debug("Resolving session state..."),Session.resolveSessionState().then(function(sessionState){deferred.resolve(sessionState)},function(error){$log.error(error),deferred.resolve(SessionState.LOGGED_OUT)}),deferred.promise},requireLoggedOut:function($q,$log,Session,SessionState){$log.debug("Resolving logged-out-only route...");var deferred=$q.defer(),resolveLoggedOut=resolveSessionState(deferred,SessionState.LOGGED_OUT,Session);return Session.getSessionState()===SessionState.PENDING?Session.resolveSessionState().then(resolveLoggedOut):resolveLoggedOut(),deferred.promise},requireLoggedIn:function($q,$log,Session,$rootScope,SessionState){$log.debug("Resolving logged-in-only route...");var deferred=$q.defer(),resolveLoggedIn=resolveSessionState(deferred,SessionState.LOGGED_IN,Session);return Session.getSessionState()===SessionState.PENDING?Session.resolveSessionState().then(resolveLoggedIn):resolveLoggedIn(),deferred.promise},requireCurrentUser:function($q,$log,CurrentUser){return $log.debug("Resolving current user..."),CurrentUser.resolve()}}}()),angular.module("sb.auth").factory("AccessToken",function(localStorageService,preExpireDelta){"use strict";var TOKEN_TYPE="token_type",ACCESS_TOKEN="access_token",REFRESH_TOKEN="refresh_token",ID_TOKEN="id_token",EXPIRES_IN="expires_in",ISSUE_DATE="issue_date";return{clear:function(){localStorageService.remove(TOKEN_TYPE),localStorageService.remove(ACCESS_TOKEN),localStorageService.remove(REFRESH_TOKEN),localStorageService.remove(ID_TOKEN),localStorageService.remove(EXPIRES_IN),localStorageService.remove(ISSUE_DATE)},setToken:function(jsonToken){this.setTokenType(jsonToken.token_type),this.setAccessToken(jsonToken.access_token),this.setRefreshToken(jsonToken.refresh_token),this.setIdToken(jsonToken.id_token),this.setIssueDate(jsonToken.issue_date),this.setExpiresIn(jsonToken.expires_in)},isExpired:function(){var expiresIn=this.getExpiresIn()||0,issueDate=this.getIssueDate()||0,now=Math.round((new Date).getTime()/1e3);return now>issueDate+expiresIn},expiresSoon:function(){var expiresIn=this.getExpiresIn()||0,issueDate=this.getIssueDate()||0,now=Math.round((new Date).getTime()/1e3);return now>issueDate+expiresIn-preExpireDelta},getTokenType:function(){return localStorageService.get(TOKEN_TYPE)},setTokenType:function(value){return localStorageService.set(TOKEN_TYPE,value)},getIssueDate:function(){return parseInt(localStorageService.get(ISSUE_DATE))||null},setIssueDate:function(value){return localStorageService.set(ISSUE_DATE,parseInt(value))},getExpiresIn:function(){return parseInt(localStorageService.get(EXPIRES_IN))||0},setExpiresIn:function(value){return localStorageService.set(EXPIRES_IN,parseInt(value))},getAccessToken:function(){return localStorageService.get(ACCESS_TOKEN)||null},setAccessToken:function(value){return localStorageService.set(ACCESS_TOKEN,value)},getRefreshToken:function(){return localStorageService.get(REFRESH_TOKEN)||null},setRefreshToken:function(value){return localStorageService.set(REFRESH_TOKEN,value)},getIdToken:function(){return localStorageService.get(ID_TOKEN)||null},setIdToken:function(value){return localStorageService.set(ID_TOKEN,value)}}}),angular.module("sb.auth").factory("CurrentUser",function(SessionState,Session,AccessToken,$rootScope,$log,$q,User){"use strict";function resolveCurrentUser(){if(currentPromise)return currentPromise;var deferred=$q.defer();return currentPromise=deferred.promise,resolveLoggedInSession().then(function(){currentUser?deferred.resolve(currentUser):User.get({id:AccessToken.getIdToken()},function(user){currentUser=user,deferred.resolve(user)},function(error){currentUser=null,deferred.reject(error)})},function(error){currentUser=null,deferred.reject(error)}),currentPromise.then(function(){currentPromise=null},function(){currentPromise=null}),currentPromise}function resolveLoggedInSession(){var deferred=$q.defer();return Session.resolveSessionState().then(function(sessionState){sessionState===SessionState.LOGGED_IN?deferred.resolve(sessionState):deferred.reject(sessionState)},function(error){deferred.reject(error)}),deferred.promise}var currentUser=null,currentPromise=null;return $rootScope.$on(SessionState.LOGGED_IN,resolveCurrentUser),$rootScope.$on(SessionState.LOGGED_OUT,function(){currentUser=null}),{resolve:function(){return resolveCurrentUser()}}}),angular.module("sb.auth").factory("OpenId",function($location,$window,$log,$http,$q,StringUtil,UrlUtil,storyboardApiBase,localStorageService){"use strict";var storageKey="openid_authorize_state",authorizeUrl=storyboardApiBase+"/openid/authorize",tokenUrl=storyboardApiBase+"/openid/token",redirectUri=UrlUtil.buildApplicationUrl("/auth/token"),clientId=$location.host();return{authorize:function(){var state=StringUtil.randomAlphaNumeric(20);localStorageService.set(storageKey,state);var openIdParams={response_type:"code",client_id:clientId,redirect_uri:redirectUri,scope:"user",state:state};$window.location.href=authorizeUrl+"?"+UrlUtil.serializeParameters(openIdParams)},token:function(params){var deferred=$q.defer(),grant_type=params.grant_type||"authorization_code",authorizationCode=params.code,refreshToken=params.refresh_token,tokenParams={grant_type:grant_type};"authorization_code"===grant_type?tokenParams.code=authorizationCode:tokenParams.refresh_token=refreshToken;var url=tokenUrl+"?"+UrlUtil.serializeParameters(tokenParams);return $http({method:"POST",url:url}).then(function(response){$log.debug("Token creation succeeded.");var data=response.data,dateHeader=response.headers("Date");data.issue_date=Math.floor(dateHeader?new Date(dateHeader)/1e3:Date.now()/1e3),deferred.resolve(data)},function(response){$log.debug("Token creation failed.");var error=response.data;error.hasOwnProperty("error")||(error={error:response.status,error_description:response.data}),deferred.reject(error)}),deferred.promise}}}),angular.module("sb.auth").factory("PermissionManager",function($log,$q,$rootScope,Session,SessionState,CurrentUser){"use strict";function resolvePermission(permName){var deferred=$q.defer();return permCache.hasOwnProperty(permName)?deferred.resolve(permCache[permName]):CurrentUser.resolve().then(function(user){permCache[permName]=user[permName],deferred.resolve(permCache[permName])},function(error){deferred.reject(error)}),deferred.promise}function clearPermissionCache(){$log.debug("Resetting permission cache."),permCache={},$rootScope.$broadcast(NOTIFY_PERMISSIONS)}function permissionListenHandler(permName,handler){return function(){resolvePermission(permName).then(function(value){handler(value)},function(){handler(null)})}}var permCache={},NOTIFY_PERMISSIONS="notify_permissions";return{initialize:function(){$log.debug("Initializing permissions"),$rootScope.$on("$destroy",$rootScope.$on(SessionState.LOGGED_IN,clearPermissionCache)),$rootScope.$on("$destroy",$rootScope.$on(SessionState.LOGGED_OUT,clearPermissionCache)),Session.getSessionState()!==SessionState.PENDING&&clearPermissionCache()},listen:function(scope,permName,handler){var messageHandler=permissionListenHandler(permName,handler);scope.$on("$destroy",$rootScope.$on(NOTIFY_PERMISSIONS,messageHandler)),messageHandler()},resolve:function(permName){return resolvePermission(permName)}}}),angular.module("sb.auth").constant("preExpireDelta",600),angular.module("sb.auth").service("RefreshManager",function($q,$log,$timeout,preExpireDelta,AccessToken,OpenId){"use strict";var nextRefreshPromise=null,scheduledForToken=null,tryRefresh=function(){var deferred=$q.defer(),resolved=!1,refresh_token=AccessToken.getRefreshToken();if(refresh_token||($log.info("No refresh token found. Aborting refresh."),deferred.reject(),resolved=!0),resolved||AccessToken.isExpired()||AccessToken.expiresSoon()||($log.info("No refresh is required for existing access token."),deferred.resolve(!0),resolved=!0),resolved)return deferred.promise;$log.info("Trying to refresh token");var params={grant_type:"refresh_token",refresh_token:refresh_token};return OpenId.token(params).then(function(data){AccessToken.setToken(data),deferred.resolve(!0),scheduleRefresh()},function(){AccessToken.clear(),deferred.reject()}),deferred.promise},scheduleRefresh=function(){if(AccessToken.getRefreshToken()){var expiresAt=AccessToken.getIssueDate()+AccessToken.getExpiresIn();if(nextRefreshPromise&&AccessToken.getAccessToken===scheduledForToken)return void $log.info("The refresh is already scheduled.");var now=Math.round((new Date).getTime()/1e3),delay=1e3*(expiresAt-preExpireDelta-now);nextRefreshPromise=$timeout(tryRefresh,delay,!1),scheduledForToken=AccessToken.getAccessToken(),$log.info("Refresh scheduled to happen in "+delay+" ms")}};this.tryRefresh=tryRefresh,this.scheduleRefresh=scheduleRefresh}),angular.module("sb.auth").factory("Session",function(SessionState,AccessToken,$rootScope,$log,$q,$state,User,RefreshManager,Notification){"use strict";function initializeSession(){var deferred=$q.defer();return AccessToken.getAccessToken()?validateToken().then(function(){$log.debug("Token validated"),updateSessionState(SessionState.LOGGED_IN),deferred.resolve(sessionState)},function(){$log.debug("Token not validated"),AccessToken.clear(),updateSessionState(SessionState.LOGGED_OUT),deferred.resolve(sessionState)}):($log.debug("No token found"),updateSessionState(SessionState.LOGGED_OUT),deferred.resolve()),deferred.promise}function validateToken(){var deferred=$q.defer();return RefreshManager.tryRefresh().then(function(){var id=AccessToken.getIdToken();User.read({id:id},function(user){deferred.resolve(user)},function(error){deferred.reject(error)})}),deferred.promise}function updateSessionState(newState){newState!==sessionState&&(sessionState=newState,$rootScope.$broadcast(sessionState))}function destroySession(){AccessToken.clear(),updateSessionState(SessionState.LOGGED_OUT),$state.reload()}var sessionState=SessionState.PENDING;return initializeSession(),Notification.intercept(function(message){return"http"===message.type&&401===message.message?(RefreshManager.tryRefresh().then(function(){$log.info("Token refreshed on 401")},function(){$log.info("Could not refresh token. Destroying session"),destroySession()}),!0):void 0},-1),{getSessionState:function(){return sessionState},resolveSessionState:function(){var deferred=$q.defer();if(sessionState!==SessionState.PENDING)deferred.resolve(sessionState);else var unwatch=$rootScope.$watch(function(){return sessionState},function(){sessionState!==SessionState.PENDING&&(deferred.resolve(sessionState),unwatch())});return deferred.promise},isLoggedIn:function(){return sessionState===SessionState.LOGGED_IN},destroySession:function(){destroySession()},updateSession:function(token){var deferred=$q.defer();return token?(AccessToken.setToken(token),initializeSession().then(function(){deferred.resolve(sessionState)},function(){deferred.resolve(sessionState)})):(destroySession(),deferred.resolve(sessionState)),deferred.promise}}}),angular.module("sb.auth").factory("SessionModalService",function($modal){"use strict";return{showLoginRequiredModal:function(){var modalInstance=$modal.open({templateUrl:"app/templates/auth/modal/login_required.html",controller:"LoginRequiredModalController"});return modalInstance.result}}}),angular.module("sb.dashboard").controller("DashboardController",function($scope,currentUser,Story){"use strict";$scope.assignedStories=Story.query({assignee_id:currentUser.id,status:"active"})}),angular.module("sb.dashboard").controller("HomeController",function($state,sessionState,SessionState){"use strict";sessionState===SessionState.LOGGED_IN&&$state.transitionTo("dashboard")}),angular.module("sb.notification").controller("NotificationsController",function($scope,Notification){"use strict";var defaultDisplayCount=5;$scope.displayCount=defaultDisplayCount,$scope.notifications=[],$scope.remove=function(notification){var idx=$scope.notifications.indexOf(notification);idx>-1&&$scope.notifications.splice(idx,1),$scope.notifications.length<=defaultDisplayCount&&($scope.displayCount=defaultDisplayCount)},$scope.showMore=function(){$scope.displayCount=Math.min($scope.notifications.length,$scope.displayCount+5)},$scope.$on("$destroy",Notification.subscribe(function(notification){$scope.notifications.push(notification)}))}),angular.module("sb.notification").directive("notifications",function(){"use strict";return{restrict:"E",templateUrl:"app/templates/error/notifications.html",controller:"NotificationsController"}}),angular.module("sb.notification").constant("Severity",{ERROR:"error",WARNING:"warning",INFO:"info",SUCCESS:"success"}),angular.module("sb.notification").factory("Notification",function($log,Severity){"use strict";var subscribers=[],interceptors=[];return{send:function(type,message,severity,cause,callback,callbackLabel){if(!type||!message)return void $log.warn("Invoked Notification.send() without a type or message.");for(var n={type:type,message:message,severity:severity||Severity.INFO,cause:cause||null,callback:callback||null,callbackLabel:callbackLabel||null,date:new Date},i=0;i<interceptors.length;i++)if(interceptors[i].method(n))return;for(var j=0;j<subscribers.length;j++)subscribers[j](n)},intercept:function(interceptor,priority){var i={priority:priority||999,method:interceptor};return interceptors.unshift(i),interceptors.sort(function(a,b){return a.priority-b.priority}),function(){interceptors.remove(i)}},subscribe:function(subscriber){return subscribers.push(subscriber),function(){subscribers.remove(subscriber)}}}}),angular.module("sb.profile").controller("ProfilePreferencesController",function($scope,Preference){"use strict";$scope.pageSize=Preference.get("page_size"),$scope.enabled_event_types=Preference.get("display_events_filter"),$scope.save=function(){Preference.set("page_size",$scope.pageSize),Preference.set("display_events_filter",$scope.enabled_event_types),$scope.message="Preferences Saved!"}}),angular.module("sb.projects").controller("ProjectDetailController",function($scope,$rootScope,$state,$stateParams,Project,Story,Session,isSuperuser){"use strict";function handleServiceError(error){$scope.error=error,$scope.isLoading=!1,$scope.isUpdating=!1}function handleServiceSuccess(){$scope.isLoading=!1,$scope.isUpdating=!1}function loadProject(){Project.read({id:id},function(result){$scope.project=result,handleServiceSuccess()},handleServiceError)}var id=$stateParams.hasOwnProperty("id")?parseInt($stateParams.id,10):null;$scope.project={},$scope.isLoading=!0,$scope.isUpdating=!1,$scope.error={},$scope.cancel=function(){loadProject(),$scope.showEditForm=!1},$scope.toggleEditMode=function(){isSuperuser?($scope.showEditForm=!$scope.showEditForm,setTimeout(function(){$rootScope.$broadcast("elastic:adjust")},1)):$scope.showEditForm=!1},$scope.update=function(){$scope.isUpdating=!0,$scope.error={},$scope.project.$update(function(){$scope.isUpdating=!1,$scope.showEditForm=!1,handleServiceSuccess()},handleServiceError)},loadProject()}),angular.module("sb.projects").controller("ProjectListController",function($scope,Project){"use strict";function resetScope(){$scope.projectCount=0,$scope.projects=[],$scope.error={}}$scope.searchQuery="",$scope.isSearching=!1,$scope.search=function(){resetScope(),$scope.isSearching=!0,Project.query({},function(result,headers){$scope.projectCount=headers("X-Total")||result.length,$scope.projects=result,$scope.isSearching=!1},function(error){$scope.error=error,$scope.isSearching=!1})},resetScope(),$scope.search()}),angular.module("sb.projects").controller("ProjectNewController",function($scope,$state,Project){"use strict";$scope.newProject=new Project,$scope.isCreating=!1,$scope.error={},$scope.createProject=function(){$scope.isCreating=!0,$scope.error={},$scope.newProject.$create(function(){$state.go("project.list")},function(error){$scope.isCreating=!1,$scope.error=error})}}),angular.module("sb.projects").controller("ProjectStoryListController",function($scope,$state,$stateParams,Story,NewStoryService){"use strict";function resetScope(){$scope.storyCount=0,$scope.stories=[],$scope.error={}}var id=$stateParams.hasOwnProperty("id")?parseInt($stateParams.id,10):null;return null===id?void $state.go("index"):($scope.searchQuery="",$scope.isSearching=!1,$scope.filter="active",$scope.setFilter=function(state){$scope.filter=state,$scope.search()},$scope.search=function(){resetScope(),$scope.isSearching=!0,Story.query({project_id:id,status:$scope.filter||null},function(result,headers){$scope.storyCount=headers("X-Total")||result.length,$scope.stories=result,$scope.isSearching=!1},function(error){$scope.error=error,$scope.isSearching=!1})},$scope.newStory=function(){NewStoryService.showNewStoryModal(id).then(function(){$scope.search()})},resetScope(),void $scope.search())}),angular.module("sb.services").factory("httpErrorBroadcaster",function($q,$rootScope,Notification,Severity){"use strict";function sendEvent(severity,response){response.status&&Notification.send("http",response.status,severity,response)}return{response:function(response){return response&&sendEvent(Severity.SUCCESS,response),response},responseError:function(response){return response&&sendEvent(Severity.ERROR,response),$q.reject(response)}}}).config(function($httpProvider){"use strict";$httpProvider.interceptors.unshift("httpErrorBroadcaster")}),angular.module("sb.services").run(function(Notification){"use strict";function filterTemplateRequests(message){if("http"===message.type){var request=message.cause,url=request.config.url;return".html"===url.substr(-5)?!0:void 0}}function filterSuccessful(message){var response=message.cause;if("http"===message.type&&response)return 200===response.status?!0:void 0}function rewriteHttpStatus(message){if("http"===message.type){var httpStatus=message.message,request=message.cause;if(httpStatus&&request&&request.data){var data=request.data,method=request.config.method,url=request.config.url;message.message=httpStatus+": "+method+" "+url+": ",message.message+=data.hasOwnProperty("faultstring")?data.faultstring:"No error details available."}}}Notification.intercept(filterTemplateRequests,-1),Notification.intercept(filterSuccessful,999),Notification.intercept(rewriteHttpStatus,1e3)}),angular.module("sb.services").constant("pageSize",500),angular.module("sb.services").config(function($provide,$injector){"use strict";var propertyName="storyboardApiBase";if(!$injector.has(propertyName)){if(window.hasOwnProperty("ENV")){var ENV=window.ENV;if(null!==ENV&&ENV.hasOwnProperty(propertyName))return void $provide.constant(propertyName,ENV[propertyName])}return document.getElementsByTagName("base").length>0?void $provide.constant(propertyName,""):void $provide.constant(propertyName,"/api/v1")}}),angular.module("sb.services").factory("storyboardApiSignature",function(pageSize){"use strict";return{create:{method:"POST"},read:{method:"GET",cache:!1},update:{method:"PUT"},"delete":{method:"DELETE"},query:{method:"GET",isArray:!0,responseType:"json",params:{limit:pageSize}}}}),angular.module("sb.services").factory("Comment",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/stories/:story_id/comments/:id",{id:"@id",story_id:"@story_id"},storyboardApiSignature)}),angular.module("sb.services").provider("Preference",function(){"use strict";function preferenceName(key){return"pref_"+key}function Preference($log,localStorageService){this.get=function(key){if(!defaults.hasOwnProperty(key))return $log.warn("Attempt to get unregistered preference: "+key),null;var value=localStorageService.get(preferenceName(key));if(null===value&&defaults.hasOwnProperty(key)){var defaultValue=defaults[key];return this.set(key,defaultValue),defaultValue}return value},this.set=function(key,value){return defaults.hasOwnProperty(key)?localStorageService.set(preferenceName(key),value):($log.warn("Attempt to set unregistered preference: "+key),null)}}var defaults={};this.addPreference=function(preferenceName,preferenceDefault){defaults[preferenceName]=preferenceDefault},this.$get=function($log,localStorageService){return new Preference($log,localStorageService)}}).config(function(PreferenceProvider){"use strict";PreferenceProvider.addPreference("page_size",10)}),angular.module("sb.services").factory("Project",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/projects/:id",{id:"@id"},storyboardApiSignature)}),angular.module("sb.services").factory("ProjectGroup",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/project_groups/:id",{id:"@id"},storyboardApiSignature)}),angular.module("sb.services").factory("Story",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/stories/:id",{id:"@id"},storyboardApiSignature)}),angular.module("sb.services").factory("Task",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/tasks/:id",{id:"@id"},storyboardApiSignature)}),angular.module("sb.services").factory("Team",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/teams/:id",{id:"@id"},storyboardApiSignature)}),angular.module("sb.services").factory("TimelineEvent",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/stories/:story_id/events/:id",{id:"@id",story_id:"@story_id"},storyboardApiSignature)}),angular.module("sb.services").factory("User",function($resource,storyboardApiBase,storyboardApiSignature){"use strict";return $resource(storyboardApiBase+"/users/:id",{id:"@id"},storyboardApiSignature)}),angular.module("sb.story").controller("StoryDeleteController",function($log,$scope,$state,story,$modalInstance){"use strict";$scope.story=story,$scope.isUpdating=!0,$scope.error={},$scope.remove=function(){$scope.story.$delete(function(){$modalInstance.dismiss("success"),$state.go("project.list")})},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.story").controller("StoryDetailController",function($log,$rootScope,$scope,$state,$stateParams,$modal,Story,Session,User,Preference){"use strict";function handleServiceError(error){$scope.error=error,$scope.isLoading=!1,$scope.isUpdating=!1}function handleServiceSuccess(){$scope.isLoading=!1,$scope.isUpdating=!1}function loadStory(){Story.get({id:id},function(story){$scope.story=story,story.creator_id&&($scope.creator=User.get({id:story.creator_id})),handleServiceSuccess()},handleServiceError)}var id=$stateParams.hasOwnProperty("storyId")?parseInt($stateParams.storyId,10):null;$scope.enabled_event_types=Preference.get("display_events_filter"),$scope.toggleEditMode=function(){Session.isLoggedIn()?($scope.showEditForm=!$scope.showEditForm,setTimeout(function(){$rootScope.$broadcast("elastic:adjust")},1)):$scope.showEditForm=!1},$scope.showEditForm=!1,$scope.creator=null,$scope.isLoading=!0,$scope.isUpdating=!1,$scope.error={},$scope.update=function(){$scope.isUpdating=!0,$scope.error={},$scope.story.$update(function(){$scope.showEditForm=!1,handleServiceSuccess()
},handleServiceError)},$scope.cancel=function(){loadStory(),$scope.showEditForm=!1},$scope.remove=function(){var modalInstance=$modal.open({templateUrl:"app/templates/story/delete.html",controller:"StoryDeleteController",resolve:{story:function(){return $scope.story}}});return modalInstance.result},$scope.updateFilter=function(){var modalInstance=$modal.open({templateUrl:"app/templates/story/update_filter.html",controller:"TimelineFilterController"});return modalInstance.result.then(function(enabled_event_types){$scope.enabled_event_types=enabled_event_types}),modalInstance.result},loadStory()}),angular.module("sb.story").controller("StoryDiscussionController",function($log,$scope,$state,$stateParams,Project,Comment,TimelineEvent){"use strict";var id=$stateParams.hasOwnProperty("storyId")?parseInt($stateParams.storyId,10):null;$scope.events=TimelineEvent.query({story_id:id}),$scope.newComment=new Comment({story_id:id}),$scope.isLoading=!0,$scope.isSavingComment=!1,$scope.error={},$scope.addComment=function(){function resetSavingFlag(){$scope.isSavingComment=!1}return $scope.newComment.content?($scope.isSavingComment=!0,void $scope.newComment.$create(function(event){$scope.events.push(event),$scope.newComment=new Comment({story_id:id}),resetSavingFlag()},resetSavingFlag)):void $log.warn("No content in comment, discarding submission")}}),angular.module("sb.story").controller("StoryDiscussionItemController",function($scope,$log,User){"use strict";$scope.author=User.get({id:$scope.event.author_id});try{$scope.event_info=JSON.parse($scope.event.event_info)}catch(error){$log.warn(error)}}),angular.module("sb.story").controller("StoryListController",function($scope,$modal,$state,NewStoryService,Story){"use strict";function resetScope(){$scope.storyCount=0,$scope.stories=[],$scope.error={}}$scope.newStory=function(){NewStoryService.showNewStoryModal().then(function(story){$state.go("story.detail",{storyId:story.id})})},$scope.searchQuery="",$scope.isSearching=!1,$scope.filter="active",$scope.setFilter=function(state){$scope.filter=state,$scope.search()},$scope.search=function(){resetScope(),$scope.isSearching=!0,Story.query({status:$scope.filter||null},function(result,headers){$scope.storyCount=headers("X-Total")||result.length,$scope.stories=result,$scope.isSearching=!1},function(error){$scope.error=error,$scope.isSearching=!1})},resetScope(),$scope.search()}),angular.module("sb.story").controller("StoryListItemController",function($scope){"use strict";switch($scope.expandRow=!1,$scope.story.status){case"active":$scope.statusLabelStyle="label-info";break;case"merged":$scope.statusLabelStyle="label-success";break;case"invalid":$scope.statusLabelStyle="label-default";break;default:$scope.statusLabelStyle="label-default"}}),angular.module("sb.story").controller("StoryModalController",function($scope,$modalInstance,params,Project,Story,Task){"use strict";$scope.projects=Project.query({}),$scope.story=new Story({title:""}),$scope.tasks=[new Task({title:"",project_id:params.projectId||null})];var lastTitle="",trackingStoryTitle=!0;$scope.$on("$destroy",$scope.$watch(function(){return $scope.story.title},function(newTitle){if(trackingStoryTitle){var task=$scope.tasks[0];trackingStoryTitle&&task.title===lastTitle?(task.title=newTitle,lastTitle=newTitle):trackingStoryTitle=!1}})),$scope.save=function(){$scope.story.$create(function(story){var resolvingTasks=$scope.tasks.length;$scope.tasks.forEach(function(task){task.story_id=story.id,task.$create(function(){resolvingTasks--,0===resolvingTasks&&$modalInstance.close(story)})})})},$scope.close=function(){$modalInstance.dismiss("cancel")},$scope.addTask=function(){var lastTask=$scope.tasks[$scope.tasks.length-1];$scope.tasks.push(new Task({project_id:lastTask.project_id}))},$scope.removeTask=function(task){if(!($scope.tasks.length<2)){var idx=$scope.tasks.indexOf(task);$scope.tasks.splice(idx,1)}},$scope.searchProjects=function(value){return Project.query({name:value,limit:10}).$promise},$scope.formatProjectName=function(model){return model?model.name:""},$scope.selectNewProject=function(model,task){task.project_id=model.id}}),angular.module("sb.story").controller("StoryTaskDeleteController",function($log,$scope,$state,task,$modalInstance){"use strict";$scope.task=task,$scope.isUpdating=!0,$scope.error={},$scope.remove=function(){$scope.task.$delete(function(){$modalInstance.close("success")})},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.story").controller("StoryTaskListController",function($log,$scope,$state,$stateParams,Task){"use strict";var id=$stateParams.hasOwnProperty("storyId")?parseInt($stateParams.storyId,10):null;$scope.tasks=[],$scope.showAddTaskForm=!1,$scope.newTask=new Task({story_id:id}),$scope.isLoading=!0,$scope.error={},$scope.loadTasks=function(){$scope.tasks=[],Task.query({story_id:id},function(result){$scope.tasks=result},function(error){$scope.error=error,$scope.isLoading=!1,$scope.isUpdating=!1})},$scope.addTask=function(){$scope.newTask.$save(function(savedTask){$scope.tasks.push(savedTask),$scope.newTask=new Task({story_id:id})})},$scope.loadTasks()}),angular.module("sb.story").controller("StoryTaskListItemController",function($scope,$state,$modal,Project,Session,Task,User){"use strict";var projectId=$scope.task.project_id||null,assigneeId=$scope.task.assignee_id||null;projectId&&Project.get({id:projectId},function(project){$scope.project=project},function(){$scope.project=null}),assigneeId&&User.get({id:assigneeId},function(assignee){$scope.assignee=assignee},function(){$scope.assignee=null}),$scope.updateStatus=function(status){$scope.task.status=status,$scope.task.$update()},$scope.updatePriority=function(priority){$scope.task.priority=priority,$scope.task.$update()},$scope.showTaskEditForm=!1,$scope.toggleEditForm=function(){$scope.showTaskEditForm=Session.isLoggedIn()?!$scope.showTaskEditForm:!1},$scope.removeTask=function(){var modalInstance=$modal.open({templateUrl:"app/templates/story/delete_task.html",controller:"StoryTaskDeleteController",resolve:{task:function(){return $scope.task}}});modalInstance.result.then(function(){$scope.loadTasks()})},$scope.cancelTask=function(){Task.read({id:$scope.task.id},function(task){$scope.task=task}),$scope.showTaskEditForm=!1},$scope.updateTask=function(){$scope.task.$update(function(){$scope.loadTasks(),$scope.showTaskEditForm=!1})}}),angular.module("sb.story").controller("TimelineFilterController",function($scope,$modalInstance,Preference){"use strict";function init(){$scope.enabled_event_types=Preference.get("display_events_filter")}$scope.close=function(){$modalInstance.dismiss("cancel")},$scope.save=function(){return Preference.set("display_events_filter",$scope.enabled_event_types),$modalInstance.close($scope.enabled_event_types)},init()}),angular.module("sb.story").directive("taskEditForm",function(){"use strict";return{restrict:"E",templateUrl:"app/templates/story/task_edit_form.html",scope:{task:"=",onButtonClick:"&",buttonLabel:"@"},controller:function($scope,Project,User){var task=$scope.task;task.project_id&&Project.get({id:$scope.task.project_id},function(project){$scope.asyncProject=project}),task.assignee_id&&User.get({id:$scope.task.assignee_id},function(user){$scope.asyncUser=user}),$scope.selectNewProject=function(model){task.project_id=model.id},$scope.selectNewUser=function(model){task.assignee_id=model.id,"todo"===task.status&&(task.status="inprogress")},$scope.formatProjectName=function(model){return model?model.name:""},$scope.formatUserName=function(model){return model?model.full_name:""},$scope.searchUsers=function(value){return User.query({full_name:value,limit:10}).$promise},$scope.searchProjects=function(value){return Project.query({name:value,limit:10}).$promise}}}}),angular.module("sb.story").factory("NewStoryService",function($modal,$log,Session,SessionModalService){"use strict";return{showNewStoryModal:function(projectId){if(Session.isLoggedIn()){var modalInstance=$modal.open({templateUrl:"app/templates/story/new.html",controller:"StoryModalController",resolve:{params:function(){return{projectId:projectId||null}}}});return modalInstance.result}return SessionModalService.showLoginRequiredModal()}}}),angular.module("storyboard").controller("HeaderController",function($scope,$rootScope,$state,NewStoryService,Session,SessionState,CurrentUser){"use strict";function resolveCurrentUser(){CurrentUser.resolve().then(function(user){$scope.currentUser=user},function(){$scope.currentUser=null})}resolveCurrentUser(),$scope.currentUser=null,$scope.newStory=function(){NewStoryService.showNewStoryModal().then(function(story){$state.go("story.detail",{storyId:story.id})})},$scope.logout=function(){Session.destroySession()},$rootScope.$on(SessionState.LOGGED_IN,function(){resolveCurrentUser()}),$rootScope.$on(SessionState.LOGGED_OUT,function(){$scope.currentUser=null})}),angular.module("sb.util").constant("TimelineEventTypes",["story_created","story_details_changed","task_created","task_assignee_changed","task_status_changed","task_priority_changed","task_details_changed","task_deleted","user_comment"]),angular.module("sb.util").run(function($rootScope){"use strict";var regex="^[a-zA-Z0-9]+([\\-\\./]?[a-zA-Z0-9]+)*$";$rootScope.PROJECT_NAME_REGEX=new RegExp(regex)}),angular.module("sb.util").directive("tagComplete",function(){"use strict";return{restrict:"E",replace:!0,require:"ngModel",scope:{selectedTags:"=ngModel",validTags:"=",tagLabelField:"@"},controller:"TagCompleteController",templateUrl:"app/templates/util/tag_complete.html"}}),angular.module("sb.util").controller("TagCompleteController",function($element,$scope){"use strict";function applyFilter(){var newFilteredTags=[],selectedTags=$scope.selectedTags||[];$scope.validTags.forEach(function(tag){var searchIndex=(tag[$scope.tagLabelField]||"").toLowerCase().indexOf($scope.newTagName.toLowerCase());searchIndex>-1&&-1===selectedTags.indexOf(tag)&&newFilteredTags.push(tag)}),$scope.filteredTags=newFilteredTags,$scope.selectedIndex=0,updateDropdownAppearance()}function updateDropdownAppearance(){0===$scope.newTagName.length||0===$scope.filteredTags.length?$element.find(".dropdown-menu").hide():$element.find(".dropdown-menu").show()}$scope.newTagName="",$scope.filteredTags=[],$scope.selectedIndex=0,$scope.onKeyUp=function(event){38!==event.which&&40!==event.which&&applyFilter()},$scope.onKeyDown=function(event){var newIndex=$scope.selectedIndex;38===event.which?newIndex=Math.max(0,newIndex-1):40===event.which&&(newIndex=Math.min($scope.filteredTags.length,newIndex+1)),newIndex!==$scope.selectedIndex&&($scope.selectedIndex=newIndex,event.preventDefault(),event.stopImmediatePropagation())},$scope.deletePressed=function(){var selectedTags=$scope.selectedTags||[];return selectedTags.length>0&&0===$scope.newTagName.length?(selectedTags.pop(),!0):!1},$scope.addTag=function(){if(0!==$scope.newTagName.length){$scope.selectedTags||($scope.selectedTags=[]);var selectedTag=$scope.filteredTags[$scope.selectedIndex];selectedTag&&$scope.selectedTags&&-1===$scope.selectedTags.indexOf(selectedTag)&&($scope.selectedTags.push(selectedTag),$scope.newTagName="",applyFilter())}},$scope.removeTag=function(tag){if($scope.selectedTags){var idx=$scope.selectedTags.indexOf(tag);idx>-1&&$scope.selectedTags.splice(idx,1)}},$scope.focus=function(){$element.find("input[name=tagInputField]").focus()},$scope.noFocus=function(event){event.stopImmediatePropagation()}}),angular.module("sb.util").directive("tagInput",function(){"use strict";return{restrict:"E",replace:!0,scope:{selectedTags:"=ngModel"},require:"ngModel",controller:"TagInputController",templateUrl:"app/templates/util/tag_input.html"}}),angular.module("sb.util").controller("TagInputController",function($element,$scope){"use strict";$scope.newTagName="",$scope.deletePressed=function(){return 0===$scope.newTagName.length?($scope.selectedTags.pop(),!0):!1},$scope.addTag=function(){$scope.selectedTags||($scope.selectedTags=[]),$scope.newTagName.length>0&&-1===$scope.selectedTags.indexOf($scope.newTagName)&&($scope.selectedTags.push($scope.newTagName),$scope.newTagName="")},$scope.focus=function(){$element.find("input[name=tagInputField]").focus()},$scope.noFocus=function(event){event.stopImmediatePropagation()}}),angular.module("sb.util").directive("activePath",function($location,$rootScope){"use strict";return{link:function($scope,element,attrs){function setActivePath(){var path=$location.path(),isMatchedPath=null!==path.match(activePath);element.toggleClass("active",isMatchedPath)}var activePath=attrs.activePath,disconnectBinding=$rootScope.$on("$stateChangeSuccess",setActivePath);$scope.$on("$destroy",disconnectBinding),setActivePath()}}}),angular.module("sb.util").directive("autoresizeWidth",function($document){"use strict";return{link:function($scope,$element){function recalculateSize(event){var value=$element.val()||"M";event&&"keypress"===event.type&&(value+=String.fromCharCode(event.which)),shadow.text(value),shadow.css("display","inline-block");try{$element.width(shadow.width())}finally{shadow.css("display","none")}}var shadow=angular.element("<span></span>");shadow.attr("class",$element.attr("class")),shadow.css({display:"none","white-space":"pre",width:"auto",visibility:"hidden"}),$document.find("body").append(shadow),$scope.$on("$destroy",function(){$document.find("body").remove(shadow)}),$element.bind("keypress keyup",recalculateSize),recalculateSize()}}}),angular.module("sb.util").directive("ngDelete",function(){"use strict";return function(scope,element,attrs){element.bind("keydown keypress",function(event){if(8===event.which){var preventDefault=!1;scope.$apply(function(){preventDefault=scope.$eval(attrs.ngDelete)}),preventDefault&&event.preventDefault()}})}}),angular.module("sb.util").directive("ngEnter",function(){"use strict";return function(scope,element,attrs){element.bind("keydown keypress",function(event){13===event.which&&(scope.$apply(function(){scope.$eval(attrs.ngEnter)}),event.preventDefault())})}}),angular.module("sb.util").directive("ngShiftEnter",function(){"use strict";return function(scope,element,attrs){element.bind("keydown keypress",function(event){13===event.which&&event.shiftKey&&(scope.$apply(function(){scope.$eval(attrs.ngShiftEnter)}),event.preventDefault())})}}),angular.module("sb.util").directive("storyStatusLabel",function(){"use strict";return{restrict:"E",templateUrl:"app/templates/util/story_status_label.html",scope:{story:"="},controller:function($scope){function getStoryStatus(){return $scope.story?$scope.story.status:null}function updateStoryLabel(){switch(getStoryStatus()){case"invalid":$scope.labelStyle="label-default";break;case"active":$scope.labelStyle="label-info";break;case"merged":$scope.labelStyle="label-success";break;default:$scope.labelStyle="label-default"}}var unwatch=$scope.$watch(getStoryStatus,updateStoryLabel);$scope.$on("$destroy",unwatch),updateStoryLabel()}}}),angular.module("sb.util").directive("storyTaskStatus",function(){"use strict";return{restrict:"E",templateUrl:"app/templates/util/story_task_status.html",scope:{story:"="}}}),angular.module("sb.util").directive("taskPriorityDropdown",function(){"use strict";return{restrict:"E",templateUrl:"app/templates/util/task_priority_dropdown.html",scope:{priority:"@",onChange:"&",editable:"@"},link:function($scope){$scope.style="default",$scope.setPriority=function(newPriority){newPriority!==$scope.priority&&($scope.priority=newPriority,$scope.onChange({priority:newPriority}))}}}}),angular.module("sb.util").directive("taskStatusDropdown",function(){"use strict";function setStyle(status){switch(status){case"invalid":return"default";case"merged":return"success";case"inprogress":return"info";case"review":return"warning";case"todo":return"default";default:return"default"}}return{restrict:"E",templateUrl:"app/templates/util/task_status_dropdown.html",scope:{status:"@",onChange:"&",editable:"@"},link:function($scope){$scope.style=setStyle($scope.status),$scope.setStatus=function(newStatus){newStatus!==$scope.status&&($scope.style=setStyle(newStatus),$scope.status=newStatus,$scope.onChange({status:newStatus}))}}}}),angular.module("sb.util").directive("timeMoment",function(DateUtil){"use strict";return{restrict:"A",templateUrl:"app/templates/util/time_moment.html",scope:{eventdate:"="},controller:function($scope){function updateTimeAgo(){$scope.needsTimeAgo=DateUtil.needsTimeAgo($scope.eventdate)}var unwatch=$scope.$watch(updateTimeAgo);$scope.$on("$destroy",unwatch),updateTimeAgo()}}}),angular.module("sb.util").directive("timelineEvent",function($log){"use strict";return{restrict:"E",replace:!0,link:function(scope,element,attrs){var tlEvent;try{tlEvent=JSON.parse(attrs.tlEvent),scope.event_type=tlEvent.event_type}catch(error){$log.warn(error),scope.event_type="unknown"}},templateUrl:"app/templates/story/comments/template_switch.html"}}),angular.module("sb.util").filter("capitalize",function(){"use strict";return function(value){try{return value.charAt(0).toUpperCase()+value.slice(1)}catch(e){return value}}}),angular.module("sb.util").filter("debug",function(){"use strict";return function(value){return console.warn("DEBUG",value),value}}),angular.module("sb.util").filter("taskPriorityLabel",function(){"use strict";return function(value){switch(value){case"high":return"High";case"medium":return"Medium";case"low":return"Low";default:return"Unknown Priority"}}}),angular.module("sb.util").filter("taskStatusLabel",function(){"use strict";return function(value){switch(value){case"invalid":return"Invalid";case"todo":return"Todo";case"review":return"Review";case"inprogress":return"In Progress";case"merged":return"Merged";default:return"Unknown Status"}}}),angular.module("sb.util").factory("DateUtil",function(){"use strict";return{needsTimeAgo:function(targetDate){if(targetDate){var currentDate=(new Date).getTime(),daydiff=(currentDate-Date.parse(targetDate))/864e5;return 7>daydiff}return!0}}}),angular.module("sb.util").factory("StringUtil",function(){"use strict";var defaultLength=32,alphaNumeric="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";return{randomAlphaNumeric:function(length){return this.random(length,alphaNumeric)},random:function(length,characters){length=length||defaultLength,characters=characters||alphaNumeric;for(var text="",i=0;length>i;i++)text+=characters.charAt(Math.floor(Math.random()*characters.length));return text}}}),angular.module("sb.util").factory("UrlUtil",function($location){"use strict";return{getFullUrlPrefix:function(){var protocol=$location.protocol(),host=$location.host(),port=$location.port();return protocol+"://"+host+":"+port},buildApplicationUrl:function(fragment){return this.getFullUrlPrefix()+"/#!"+fragment},serializeParameters:function(params){var pairs=[];for(var prop in params)params.hasOwnProperty(prop)&&pairs.push(encodeURIComponent(prop)+"="+encodeURIComponent(params[prop]));return pairs.join("&")},deserializeParameters:function(queryString){for(var params={},queryComponents=queryString.split("&"),i=0;i<queryComponents.length;i++){var parts=queryComponents[i].split("="),key=decodeURIComponent(parts[0])||null,value=decodeURIComponent(parts[1])||null;key&&value&&(params[key]=value)}return params}}}),angular.module("sb.util").factory("$searchParams",function($window,UrlUtil){"use strict";var params={},search=$window.location.search;return search?("?"===search.charAt(0)&&(search=search.substr(1)),UrlUtil.deserializeParameters(search)):params}),angular.module("sb.util").factory("LastLocation",function($rootScope,localStorageService){"use strict";function onLocationChange(event,toLocation){var url=new URL(toLocation),hash=url.hash||"#!/",trimmed_hash=hash.slice(2);-1===trimmed_hash.indexOf("/auth")&&localStorageService.set("lastLocation",trimmed_hash)}return{get:function(){return localStorageService.get("lastLocation")},_initialize:function(){$rootScope.$on("$destroy",$rootScope.$on("$locationChangeStart",onLocationChange))}}}).run(function(LastLocation){"use strict";LastLocation._initialize()});