"use strict";angular.module('sb.admin',['sb.services','sb.templates','sb.util','ui.router']).config(function($stateProvider,$urlRouterProvider,PermissionResolver){'use strict';$urlRouterProvider.when('/admin','/admin/user');$stateProvider.state('sb.admin',{abstract:true,views:{'submenu@':{templateUrl:'app/admin/template/admin_submenu.html'},'@':{template:'<div ui-view></div>'}},url:'/admin',resolve:{isSuperuser:PermissionResolver.requirePermission('is_superuser',true)}}).state('sb.admin.user',{url:'/user',templateUrl:'app/admin/template/user.html',controller:'UserAdminController'}).state('sb.admin.user_edit',{url:'/user/:id',templateUrl:'app/admin/template/user_edit.html',controller:'UserEditController',resolve:{user:function user($stateParams,User){return User.get({id:$stateParams.id}).$promise;}}}).state('sb.admin.team',{url:'/team',templateUrl:'app/admin/template/team.html',controller:'TeamAdminController'}).state('sb.admin.team_edit',{url:'/team/:id',templateUrl:'app/admin/template/team_edit.html',controller:'TeamEditController',resolve:{team:function team($stateParams,Team){return Team.get({team_id:$stateParams.id}).$promise;},members:function members($stateParams,Team){return Team.UsersController.get({team_id:$stateParams.id}).$promise;},projects:function projects($stateParams,Team){return Team.ProjectsController.get({team_id:$stateParams.id}).$promise;}}});});angular.module('sb.auth',['sb.services','sb.templates','ui.router','sb.util','LocalStorageModule']).config(function($stateProvider,SessionResolver){'use strict';$stateProvider.state('sb.auth',{abstract:true,template:'<div ui-view></div>',url:'/auth'}).state('sb.auth.authorize',{url:'/authorize?error&error_description',templateUrl:'app/auth/template/busy.html',controller:'AuthAuthorizeController',resolve:{isLoggedOut:SessionResolver.requireLoggedOut}}).state('sb.auth.deauthorize',{url:'/deauthorize',templateUrl:'app/auth/template/busy.html',controller:'AuthDeauthorizeController',resolve:{isLoggedIn:SessionResolver.requireLoggedIn}}).state('sb.auth.token',{url:'/token?code&state&error&error_description',templateUrl:'app/auth/template/busy.html',controller:'AuthTokenController',resolve:{isLoggedOut:SessionResolver.requireLoggedOut}}).state('sb.auth.error',{url:'/error?error&error_description',templateUrl:'app/auth/template/error.html',controller:'AuthErrorController'});}).run(function($rootScope,SessionState,Session,PermissionManager,Notification,Priority){'use strict';PermissionManager.initialize();Notification.intercept(function(message){switch(message.type){case SessionState.LOGGED_IN:$rootScope.isLoggedIn=true;break;case SessionState.LOGGED_OUT:$rootScope.isLoggedIn=false;break;default:break;}},Priority.LAST);});angular.module('sb.board',['ui.router','sb.services','sb.util','ui.bootstrap']).config(function($stateProvider,$urlRouterProvider){'use strict';$urlRouterProvider.when('/board','/board/list');$stateProvider.state('sb.board',{abstract:true,url:'/board',template:'<div ui-view></div>'}).state('sb.board.detail',{url:'/{boardID:[0-9]+}',controller:'BoardDetailController',templateUrl:'app/boards/template/detail.html'}).state('sb.board.list',{url:'/list',controller:'BoardsListController',templateUrl:'app/boards/template/list.html'});});angular.module('sb.dashboard',['sb.services','sb.templates','sb.auth','ui.router','ui.bootstrap']).config(function($stateProvider,SessionResolver){'use strict';$stateProvider.state('sb.index',{url:'/',templateUrl:'app/dashboard/template/index.html',controller:'HomeController',resolve:{sessionState:SessionResolver.resolveSessionState}}).state('sb.dashboard',{abstract:true,url:'/dashboard',resolve:{sessionState:SessionResolver.resolveSessionState,currentUser:SessionResolver.requireCurrentUser},views:{'submenu@':{templateUrl:'app/dashboard/template/submenu.html'},'@':{template:'<div ui-view></div>'}}}).state('sb.dashboard.stories',{url:'/stories',controller:'DashboardController',templateUrl:'app/dashboard/template/dashboard.html'}).state('sb.dashboard.boards',{url:'/boards',controller:'BoardsWorklistsController',templateUrl:'app/dashboard/template/boards_worklists.html'}).state('sb.dashboard.subscriptions',{url:'/subscriptions',templateUrl:'app/dashboard/template/subscriptions.html',controller:'DashboardSubscriptionsController'});});angular.module('sb.due_date',['ui.router','sb.services','sb.util','ui.bootstrap']).config(function($stateProvider,$urlRouterProvider){'use strict';$urlRouterProvider.when('/due_date','/due_date/list');$stateProvider.state('sb.due_date',{abstract:true,url:'/due_date',template:'<div ui-view></div>'}).state('sb.due_date.detail',{url:'/{dueDateID:[0-9]+}',controller:'DueDateDetailController',templateUrl:'app/due_dates/template/detail.html'});});angular.module('sb.notification',[]);angular.module('sb.pages',['sb.services','sb.templates','sb.pages','ui.router']).config(function($stateProvider){'use strict';$stateProvider.state('sb.page',{abstract:true,url:'/page',template:'<div ui-view></div>'}).state('sb.page.about',{url:'/about',templateUrl:'app/pages/template/about.html'});});angular.module('sb.profile',['sb.services','sb.templates','sb.auth','ui.router','ui.bootstrap']).config(function($stateProvider,SessionResolver,$urlRouterProvider){'use strict';$urlRouterProvider.when('/profile','/profile/preferences');$stateProvider.state('sb.profile',{abstract:true,url:'/profile',resolve:{isLoggedIn:SessionResolver.requireLoggedIn,currentUser:SessionResolver.requireCurrentUser},views:{'@':{template:'<div ui-view></div>'}}}).state('sb.profile.preferences',{url:'/preferences',templateUrl:'app/profile/template/preferences.html',controller:'ProfilePreferencesController'}).state('sb.profile.tokens',{url:'/tokens',templateUrl:'app/profile/template/tokens.html',controller:'ProfileTokensController',resolve:{tokens:function tokens(CurrentUser,UserToken,$q){var deferred=$q.defer();CurrentUser.resolve().then(function(currentUser){UserToken.query({user_id:currentUser.id},function(results){deferred.resolve(results);},function(error){deferred.reject(error);});},function(error){deferred.reject(error);});return deferred.promise;}}});});angular.module('sb.project_group',['ui.router','sb.services','sb.util','sb.auth']).config(function($stateProvider,$urlRouterProvider,PermissionResolver){'use strict';$urlRouterProvider.when('/project_group','/project_group/list');$stateProvider.state('sb.project_group',{abstract:true,url:'/project_group',template:'<div ui-view></div>',resolve:{isSuperuser:PermissionResolver.resolvePermission('is_superuser',true)}}).state('sb.project_group.list',{url:'/list',templateUrl:'app/project_group/template/list.html',controller:'ProjectGroupListController'}).state('sb.project_group.detail',{url:'/{id:any}',templateUrl:'app/project_group/template/detail.html',controller:'ProjectGroupDetailController',resolve:{projectGroup:function projectGroup($stateParams,ProjectGroup,$q){var deferred=$q.defer();ProjectGroup.get({id:$stateParams.id},function(result){deferred.resolve(result);},function(error){deferred.reject(error);});return deferred.promise;}}});});angular.module('sb.projects',['ui.router','sb.services','sb.util','sb.auth']).config(function($stateProvider,$urlRouterProvider,SessionResolver,PermissionResolver){'use strict';$urlRouterProvider.when('/project','/project/list');$stateProvider.state('sb.project',{abstract:true,url:'/project',template:'<div ui-view></div>',resolve:{isSuperuser:PermissionResolver.resolvePermission('is_superuser',true)}}).state('sb.project.list',{url:'/list',templateUrl:'app/projects/template/list.html',controller:'ProjectListController'}).state('sb.project.detail',{url:'/{id:any}',templateUrl:'app/projects/template/detail.html',controller:'ProjectDetailController'});});angular.module('sb.search',['ui.router','sb.services','sb.util','sb.auth']).config(function($stateProvider){'use strict';$stateProvider.state('sb.search',{url:'/search',templateUrl:'app/search/template/index.html',controller:'SearchController'});});angular.module('sb.services',['ngResource','sb.notification']);angular.module('sb.story',['ui.router','sb.services','sb.util','ui.bootstrap']).config(function($stateProvider,$urlRouterProvider,PreferenceProvider,TimelineEventTypes,SessionResolver){'use strict';$urlRouterProvider.when('/story','/story/list');var queryParams='q&status&tags&project_group_id&'+'project_id&assignee_id';var creationParams='title&description&project_id&'+'private&force_private&security&tags&team_id&user_id';$stateProvider.state('sb.story',{abstract:true,url:'/story',template:'<div ui-view></div>'}).state('sb.story.list',{url:'/list?'+queryParams,params:{'status':'active'},templateUrl:'app/stories/template/list.html',controller:'StoryListController'}).state('sb.story.detail',{url:'/{storyId:[0-9]+}',templateUrl:'app/stories/template/detail.html',controller:'StoryDetailController',resolve:{story:function story(Story,$stateParams){return Story.get({id:$stateParams.storyId}).$promise;},creator:function creator(story,User){if(!story.creator_id){return{};}else{return User.get({id:story.creator_id}).$promise;}},tasks:function tasks(Task,$stateParams){return Task.browse({story_id:$stateParams.storyId}).$promise;},currentUser:function currentUser(CurrentUser,Session){var user=Session.resolveSessionState().then(function(){if(Session.isLoggedIn()){return CurrentUser.resolve();}return{};});return user;},worklists:function worklists(Worklist,$stateParams,CurrentUser){var userPromise=CurrentUser.resolve();return userPromise.then(function(user){return Worklist.browse({story_id:$stateParams.storyId,subscriber_id:user.id,hide_lanes:''}).$promise;},function(){return[];});}}}).state('sb.story.new',{url:'/new?'+creationParams,templateUrl:'app/stories/template/new_page.html',controller:'StoryNewController',resolve:{isLoggedIn:SessionResolver.requireLoggedIn,currentUser:SessionResolver.requireCurrentUser}});TimelineEventTypes.forEach(function(type){PreferenceProvider.addPreference('display_events_'+type,'true');});});angular.module('storyboard',['sb.services','sb.templates','sb.dashboard','sb.pages','sb.projects','sb.auth','sb.story','sb.profile','sb.notification','sb.search','sb.admin','sb.subscription','sb.project_group','sb.worklist','sb.board','sb.due_date','sb.task','ui.router','ui.bootstrap','monospaced.elastic','angularMoment','angular-data.DSCacheFactory','viewhead','ngSanitize','as.sortable']).constant('angularMomentConfig',{preprocess:'utc',timezone:'UTC'}).config(function($urlRouterProvider,$locationProvider,$httpProvider,msdElasticConfig,$stateProvider,SessionResolver,PreferenceResolver){'use strict';$urlRouterProvider.otherwise('/');$locationProvider.hashPrefix('!');$httpProvider.defaults.headers.common['X-Client']='StoryBoard';msdElasticConfig.append='\n';$stateProvider.state('sb',{abstract:true,url:'',template:'<div ui-view></div>',resolve:{sessionState:SessionResolver.resolveSessionState,preferences:PreferenceResolver.resolvePreferences}});}).run(function($log,$rootScope,$document,$transitions,LastLocation){'use strict';var resolvingClassName='resolving';var body=$document.find('body');$transitions.onStart({},function(transition){body.addClass(resolvingClassName);$rootScope.isResolving=true;LastLocation.onStateChange(transition);});$transitions.onSuccess({},function(){body.removeClass(resolvingClassName);$rootScope.isResolving=false;});$transitions.onError({},function(){body.removeClass(resolvingClassName);$rootScope.isResolving=false;});}).run(function($log,$rootScope,$state,$transitions){'use strict';$transitions.onError({},function(){return false;});}).run(function($http,DSCacheFactory){'use strict';DSCacheFactory.createCache('defaultCache',{maxAge:60000,deleteOnExpire:'passive'});$http.defaults.cache=DSCacheFactory.get('defaultCache');});angular.module('sb.subscription',['sb.notification']);angular.module('sb.task',['ui.router']).config(function($stateProvider){'use strict';$stateProvider.state('sb.task',{url:'/task/{taskId:[0-9]+}',resolve:{redirect:function redirect(Task,$stateParams,$q,$state){Task.get({id:$stateParams.taskId}).$promise.then(function(task){$state.go('sb.story.detail',{storyId:task.story_id});});}}});});angular.module('sb.util',['ui.router','LocalStorageModule']).run(function(){'use strict';angular.element.prototype.hide=function(){this.addClass('ng-hide');};angular.element.prototype.show=function(){this.removeClass('ng-hide');};});angular.module('sb.worklist',['ui.router','sb.services','sb.util','ui.bootstrap']).config(function($stateProvider,$urlRouterProvider){'use strict';$urlRouterProvider.when('/worklist','/worklist/list');$stateProvider.state('sb.worklist',{abstract:true,url:'/worklist',template:'<div ui-view></div>'}).state('sb.worklist.detail',{url:'/{worklistID:[0-9]+}',controller:'WorklistDetailController',templateUrl:'app/worklists/template/detail.html',resolve:{worklist:function worklist(Worklist,$stateParams){return Worklist.get({id:$stateParams.worklistID}).$promise;},permissions:function permissions(Worklist,$stateParams){return Worklist.Permissions.get({id:$stateParams.worklistID}).$promise;}}});});angular.module('sb.admin').controller('TeamAdminController',function($scope,$modal,Team,Preference){'use strict';$scope.teams=[];$scope.filterQuery='';$scope.addTeam=function(){$modal.open({templateUrl:'app/admin/template/team_new.html',backdrop:'static',controller:'TeamNewController'}).result.then(function(){$scope.search();});};var pageSize=Preference.get('page_size');$scope.searchOffset=0;$scope.search=function(){var searchQuery=$scope.filterQuery||'';$scope.teams=Team.browse({name:searchQuery,offset:$scope.searchOffset,limit:pageSize},function(results,headers){$scope.searchTotal=parseInt(headers('X-Total'))||results.length;$scope.searchOffset=parseInt(headers('X-Offset'))||0;$scope.searchLimit=parseInt(headers('X-Limit'))||0;});};$scope.updatePageSize=function(value){Preference.set('page_size',value).then(function(){pageSize=value;$scope.search();});};$scope.nextPage=function(){$scope.searchOffset+=pageSize;$scope.search();};$scope.previousPage=function(){$scope.searchOffset-=pageSize;if($scope.searchOffset<0){$scope.searchOffset=0;}$scope.search();};$scope.search();});angular.module('sb.admin').controller('TeamEditController',function($scope,team,members,projects,$state,Team,User,Project,DSCacheFactory,storyboardApiBase,$q){'use strict';$scope.team=team;$scope.members=members;$scope.projects=projects;$scope.editing=false;$scope.isUpdating=false;$scope.save=function(){$scope.isUpdating=true;$scope.team.$update(function(updated){DSCacheFactory.get('defaultCache').put(storyboardApiBase+'/teams/'+$scope.team.id,updated);$scope.isUpdating=false;$scope.editing=false;});};var oldName=$scope.team.name;var oldSecurity=$scope.team.security;$scope.toggleEdit=function(){if(!$scope.editing){oldName=$scope.team.name;oldSecurity=$scope.team.security;}else if($scope.editing){$scope.team.name=oldName;$scope.team.security=oldSecurity;}$scope.editing=!$scope.editing;};$scope.toggleAddMember=function(){$scope.adding=!$scope.adding;};$scope.addUser=function(model){$scope.members.push(model);Team.UsersController.create({team_id:$scope.team.id,user_id:model.id},function(){DSCacheFactory.get('defaultCache').remove(storyboardApiBase+'/teams/'+$scope.team.id+'/users');});};$scope.removeUser=function(user){var idx=$scope.members.indexOf(user);$scope.members.splice(idx,1);Team.UsersController.delete({team_id:$scope.team.id,user_id:user.id},function(){DSCacheFactory.get('defaultCache').remove(storyboardApiBase+'/teams/'+$scope.team.id+'/users');});};$scope.searchUsers=function(value){var memberIds=$scope.members.map(function(user){return user.id;});var deferred=$q.defer();User.browse({full_name:value,limit:10},function(searchResults){var results=[];angular.forEach(searchResults,function(result){if(memberIds.indexOf(result.id)===-1){results.push(result);}});deferred.resolve(results);});return deferred.promise;};$scope.toggleAddProject=function(){$scope.addingProject=!$scope.addingProject;};$scope.addProject=function(model){$scope.projects.push(model);Team.ProjectsController.create({team_id:$scope.team.id,project_id:model.id},function(){DSCacheFactory.get('defaultCache').remove(storyboardApiBase+'/teams/'+$scope.team.id+'/projects');});};$scope.removeProject=function(project){var idx=$scope.projects.indexOf(project);$scope.projects.splice(idx,1);Team.ProjectsController.delete({team_id:$scope.team.id,project_id:project.id},function(){DSCacheFactory.get('defaultCache').remove(storyboardApiBase+'/teams/'+$scope.team.id+'/projects');});};$scope.searchProjects=function(value){var projectIds=$scope.projects.map(function(project){return project.id;});var deferred=$q.defer();Project.browse({name:value,limit:10},function(searchResults){var results=[];angular.forEach(searchResults,function(result){if(projectIds.indexOf(result.id)===-1){results.push(result);}});deferred.resolve(results);});return deferred.promise;};});angular.module('sb.admin').controller('TeamNewController',function($log,$scope,$modalInstance,Team,User,Project,$q){'use strict';$scope.isSaving=false;$scope.team=new Team();$scope.members=[];$scope.projects=[];$scope.save=function(){$scope.isSaving=true;$scope.team.$create(function(team){var users=[];angular.forEach($scope.members,function(member){users.push(Team.UsersController.create({team_id:team.id,user_id:member.id}).$promise);});$q.all(users).then(function(){$modalInstance.close(team);});},function(error){$scope.isSaving=false;$log.error(error);$modalInstance.dismiss(error);});};$scope.close=function(){$modalInstance.dismiss('cancel');};$scope.toggleAddMember=function(){$scope.addingMember=!$scope.addingMember;};$scope.addUser=function(model){$scope.members.push(model);};$scope.removeUser=function(user){var idx=$scope.members.indexOf(user);$scope.members.splice(idx,1);};$scope.searchUsers=function(value){var memberIds=$scope.members.map(function(user){return user.id;});var deferred=$q.defer();User.browse({full_name:value,limit:10},function(searchResults){var results=[];angular.forEach(searchResults,function(result){if(memberIds.indexOf(result.id)===-1){results.push(result);}});deferred.resolve(results);});return deferred.promise;};$scope.toggleAddProject=function(){$scope.addingProject=!$scope.addingProject;};$scope.addProject=function(model){$scope.projects.push(model);};$scope.removeProject=function(project){var idx=$scope.projects.indexOf(project);$scope.projects.splice(idx,1);};$scope.searchProjects=function(value){var projectIds=$scope.projects.map(function(project){return project.id;});var deferred=$q.defer();Project.browse({name:value,limit:10},function(searchResults){var results=[];angular.forEach(searchResults,function(result){if(projectIds.indexOf(result.id)===-1){results.push(result);}});deferred.resolve(results);});return deferred.promise;};});angular.module('sb.admin').controller('UserAdminController',function($scope,$modal,User,Preference){'use strict';$scope.users=[];$scope.filterQuery='';$scope.addUser=function(){$modal.open({templateUrl:'app/admin/template/user_new.html',backdrop:'static',controller:'UserNewController'}).result.then(function(){$scope.search();});};var pageSize=Preference.get('page_size');$scope.searchOffset=0;$scope.search=function(){var searchQuery=$scope.filterQuery||'';$scope.users=User.browse({full_name:searchQuery,offset:$scope.searchOffset,limit:pageSize},function(results,headers){$scope.searchTotal=parseInt(headers('X-Total'))||results.length;$scope.searchOffset=parseInt(headers('X-Offset'))||0;$scope.searchLimit=parseInt(headers('X-Limit'))||0;});};$scope.updatePageSize=function(value){Preference.set('page_size',value).then(function(){pageSize=value;$scope.search();});};$scope.nextPage=function(){$scope.searchOffset+=pageSize;$scope.search();};$scope.previousPage=function(){$scope.searchOffset-=pageSize;if($scope.searchOffset<0){$scope.searchOffset=0;}$scope.search();};$scope.search();});angular.module('sb.admin').controller('UserEditController',function($scope,user,$state){'use strict';$scope.user=user;$scope.save=function(){if(!$scope.user.email){delete $scope.user.email;}$scope.user.$update(function(){$state.go('sb.admin.user');});};$scope.cancel=function(){$state.go('sb.admin.user');};});angular.module('sb.admin').controller('UserNewController',function($log,$scope,$modalInstance,User){'use strict';$scope.isSaving=false;$scope.user=new User();$scope.save=function(){$scope.isSaving=true;$scope.user.$create(function(user){$modalInstance.close(user);},function(error){$scope.isSaving=false;$log.error(error);$modalInstance.dismiss(error);});};$scope.close=function(){$modalInstance.dismiss('cancel');};});angular.module('sb.auth').controller('AuthAuthorizeController',function($stateParams,$state,$log,OpenId){'use strict';if(!!$stateParams.error){$log.debug('Error received, redirecting to auth.error.');$state.go('sb.auth.error',$stateParams);return;}OpenId.authorize();});angular.module('sb.auth').controller('AuthDeauthorizeController',function(Session,$state,$log){'use strict';$log.debug('Logging out');Session.destroySession();$state.go('sb.index');});angular.module('sb.auth').controller('AuthErrorController',function($scope,$stateParams){'use strict';$scope.error=$stateParams.error||'Unknown';$scope.errorDescription=$stateParams.error_description||'No description received from server.';});angular.module('sb.auth').controller('AuthTokenController',function($state,$log,OpenId,Session,$searchParams,UrlUtil,LastLocation){'use strict';if(!!$searchParams.error){$log.debug('Error received, redirecting to auth.error.');$state.go('sb.auth.error',$searchParams);return;}OpenId.token($searchParams).then(function(token){Session.updateSession(token).then(function(){LastLocation.go('sb.page.about',{});});},function(error){Session.destroySession();$state.go('sb.auth.error',error);});});angular.module('sb.auth').controller('LoginRequiredModalController',function($state,$scope,$modalInstance){'use strict';$scope.login=function(){$state.go('sb.auth.authorize');$modalInstance.dismiss('success');};$scope.close=function(){$modalInstance.dismiss('cancel');};});angular.module('sb.util').directive('permission',function($log,PermissionManager){'use strict';return{restrict:'A',link:function link($scope,element,attrs){element.hide();var permName=attrs.permission;var permValue=attrs.permissionValue||true;PermissionManager.listen($scope,permName,function(actualValue){if(!!actualValue&&actualValue.toString()===permValue.toString()){element.show();}else{element.hide();}});}};});angular.module('sb.auth').factory('httpOAuthTokenInterceptor',function(AccessToken,$injector,$q,$log,$window){'use strict';var refreshPromise=null;function getCurrentToken(){return $q.when({type:AccessToken.getTokenType()||null,value:AccessToken.getAccessToken()||null,expired:AccessToken.isExpired()||AccessToken.expiresSoon(),refresh:AccessToken.getRefreshToken()||null});}function refreshIfNeeded(token){if(!token.expired){return $q.when(token);}if(!token.refresh){return $q.when(token);}if(refreshPromise){$log.debug('Returning in-flight refresh promise.');return refreshPromise;}$log.debug('Attempting to refresh auth token.');var deferred=$q.defer();refreshPromise=deferred.promise;var OpenId=$injector.get('OpenId');OpenId.token({grant_type:'refresh_token',refresh_token:token.refresh}).then(function(data){AccessToken.setToken(data);},function(){AccessToken.clear();$window.location.reload();}).finally(function(){deferred.resolve(getCurrentToken());refreshPromise=null;});return deferred.promise;}return{request:function request(httpConfig){function decorateHeader(token){if(token.type&&token.value){httpConfig.headers.Authorization=token.type+' '+token.value;}return $q.when(httpConfig);}if(httpConfig.url.indexOf('/openid/')>-1){return $q.when(httpConfig);}return $q.when(getCurrentToken()).then(refreshIfNeeded).then(decorateHeader);}};}).config(function($httpProvider){'use strict';$httpProvider.interceptors.unshift('httpOAuthTokenInterceptor');});angular.module('sb.auth').run(function($log,$modal,Notification,Session,Priority){'use strict';function handle_403(){var modalInstance=$modal.open({templateUrl:'app/auth/template/modal/superuser_required.html',backdrop:'static',controller:function controller($modalInstance,$scope){$scope.close=function(){$modalInstance.dismiss('cancel');};}});return modalInstance.result;}Notification.intercept(function(message){if(message.type==='http'){if(message.message===403){handle_403();}return false;}},Priority.BEFORE);});angular.module('sb.auth').run(function($log,$modal,Notification,SessionState,Priority){'use strict';Notification.intercept(function(message){switch(message.type){case SessionState.LOGGED_IN:return true;case SessionState.LOGGED_OUT:message.message='You have been logged out.';break;default:break;}},Priority.AFTER);});angular.module('sb.auth').value('SessionState',{LOGGED_IN:'logged_in',LOGGED_OUT:'logged_out',PENDING:'pending'});angular.module('sb.auth').constant('PermissionResolver',{requirePermission:function requirePermission(permName,requiredValue){'use strict';return function($q,$log,PermissionManager){var deferred=$q.defer();PermissionManager.resolve(permName).then(function(value){$log.debug('permission:',permName,requiredValue,value);if(value===requiredValue){deferred.resolve(value);}else{deferred.reject(value);}},function(error){$log.debug('permission:',error);deferred.reject(error);});return deferred.promise;};},resolvePermission:function resolvePermission(permName){'use strict';return function($q,$log,PermissionManager){var deferred=$q.defer();PermissionManager.resolve(permName).then(function(value){deferred.resolve(value);},function(){deferred.resolve(false);});return deferred.promise;};}});angular.module('sb.auth').constant('SessionResolver',function(){'use strict';function resolveSessionState(deferred,desiredSessionState,Session){return function(){var sessionState=Session.getSessionState();if(sessionState===desiredSessionState){deferred.resolve(sessionState);}else{deferred.reject(sessionState);}};}return{resolveSessionState:function resolveSessionState($q,$log,Session,SessionState){var deferred=$q.defer();$log.debug('Resolving session state...');Session.resolveSessionState().then(function(sessionState){deferred.resolve(sessionState);},function(error){$log.error(error);deferred.resolve(SessionState.LOGGED_OUT);});return deferred.promise;},requireLoggedOut:function requireLoggedOut($q,$log,Session,SessionState){$log.debug('Resolving logged-out-only route...');var deferred=$q.defer();var resolveLoggedOut=resolveSessionState(deferred,SessionState.LOGGED_OUT,Session);if(Session.getSessionState()===SessionState.PENDING){Session.resolveSessionState().then(resolveLoggedOut);}else{resolveLoggedOut();}return deferred.promise;},requireLoggedIn:function requireLoggedIn($q,$log,Session,$rootScope,SessionState){$log.debug('Resolving logged-in-only route...');var deferred=$q.defer();var resolveLoggedIn=resolveSessionState(deferred,SessionState.LOGGED_IN,Session);if(Session.getSessionState()===SessionState.PENDING){Session.resolveSessionState().then(resolveLoggedIn);}else{resolveLoggedIn();}return deferred.promise;},requireCurrentUser:function requireCurrentUser($q,$log,CurrentUser){$log.debug('Resolving current user...');return CurrentUser.resolve();}};}());angular.module('sb.auth').factory('AccessToken',function(localStorageService,preExpireDelta){'use strict';var TOKEN_TYPE='token_type';var ACCESS_TOKEN='access_token';var REFRESH_TOKEN='refresh_token';var ID_TOKEN='id_token';var EXPIRES_IN='expires_in';var ISSUE_DATE='issue_date';return{clear:function clear(){localStorageService.remove(TOKEN_TYPE);localStorageService.remove(ACCESS_TOKEN);localStorageService.remove(REFRESH_TOKEN);localStorageService.remove(ID_TOKEN);localStorageService.remove(EXPIRES_IN);localStorageService.remove(ISSUE_DATE);},setToken:function setToken(jsonToken){this.setTokenType(jsonToken.token_type);this.setAccessToken(jsonToken.access_token);this.setRefreshToken(jsonToken.refresh_token);this.setIdToken(jsonToken.id_token);this.setIssueDate(jsonToken.issue_date);this.setExpiresIn(jsonToken.expires_in);},isExpired:function isExpired(){var expiresIn=this.getExpiresIn()||0;var issueDate=this.getIssueDate()||0;var now=Math.round(new Date().getTime()/1000);return issueDate+expiresIn<now;},expiresSoon:function expiresSoon(){var expiresIn=this.getExpiresIn()||0;var issueDate=this.getIssueDate()||0;var now=Math.round(new Date().getTime()/1000);return issueDate+expiresIn-preExpireDelta<now;},getTokenType:function getTokenType(){return localStorageService.get(TOKEN_TYPE);},setTokenType:function setTokenType(value){return localStorageService.set(TOKEN_TYPE,value);},getIssueDate:function getIssueDate(){return parseInt(localStorageService.get(ISSUE_DATE))||null;},setIssueDate:function setIssueDate(value){return localStorageService.set(ISSUE_DATE,parseInt(value));},getExpiresIn:function getExpiresIn(){return parseInt(localStorageService.get(EXPIRES_IN))||0;},setExpiresIn:function setExpiresIn(value){return localStorageService.set(EXPIRES_IN,parseInt(value));},getAccessToken:function getAccessToken(){return localStorageService.get(ACCESS_TOKEN)||null;},setAccessToken:function setAccessToken(value){return localStorageService.set(ACCESS_TOKEN,value);},getRefreshToken:function getRefreshToken(){return localStorageService.get(REFRESH_TOKEN)||null;},setRefreshToken:function setRefreshToken(value){return localStorageService.set(REFRESH_TOKEN,value);},getIdToken:function getIdToken(){return localStorageService.get(ID_TOKEN)||null;},setIdToken:function setIdToken(value){return localStorageService.set(ID_TOKEN,value);}};});angular.module('sb.auth').factory('CurrentUser',function(SessionState,Session,AccessToken,$rootScope,$log,$q,User,Notification,Priority){'use strict';var currentUser=null;var currentPromise=null;function resolveLoggedInSession(){var deferred=$q.defer();Session.resolveSessionState().then(function(sessionState){if(sessionState===SessionState.LOGGED_IN){deferred.resolve(sessionState);}else{deferred.reject(sessionState);}},function(error){deferred.reject(error);});return deferred.promise;}function resolveCurrentUser(){if(!!currentPromise){return currentPromise;}var deferred=$q.defer();currentPromise=deferred.promise;resolveLoggedInSession().then(function(){if(!!currentUser){deferred.resolve(currentUser);}else{User.get({id:AccessToken.getIdToken()},function(user){currentUser=user;deferred.resolve(user);},function(error){currentUser=null;deferred.reject(error);});}},function(error){currentUser=null;deferred.reject(error);});currentPromise.then(function(){currentPromise=null;},function(){currentPromise=null;});return currentPromise;}Notification.intercept(function(message){switch(message.type){case SessionState.LOGGED_IN:resolveCurrentUser();break;case SessionState.LOGGED_OUT:currentUser=null;break;default:break;}},Priority.LAST);return{resolve:function resolve(){return resolveCurrentUser();}};});angular.module('sb.auth').factory('OpenId',function($location,$window,$log,$http,$q,StringUtil,UrlUtil,storyboardApiBase,localStorageService){'use strict';var storageKey='openid_authorize_state';var authorizeUrl=storyboardApiBase+'/openid/authorize';var tokenUrl=storyboardApiBase+'/openid/token';var redirectUri=UrlUtil.buildApplicationUrl('/auth/token');var clientId=$location.host();return{authorize:function authorize(){var state=StringUtil.randomAlphaNumeric(20);localStorageService.set(storageKey,state);var openIdParams={response_type:'code',client_id:clientId,redirect_uri:redirectUri,scope:'user',state:state};$window.location.href=authorizeUrl+'?'+UrlUtil.serializeParameters(openIdParams);},token:function token(params){var deferred=$q.defer();var grant_type=params.grant_type||'authorization_code';var authorizationCode=params.code;var refreshToken=params.refresh_token;var tokenParams={grant_type:grant_type};if(grant_type==='authorization_code'){tokenParams.code=authorizationCode;}else{tokenParams.refresh_token=refreshToken;}var url=tokenUrl+'?'+UrlUtil.serializeParameters(tokenParams);$http({method:'POST',url:url}).then(function(response){$log.debug('Token creation succeeded.');var data=response.data;var dateHeader=response.headers('Date');if(!dateHeader){data.issue_date=Math.floor(Date.now()/1000);}else{data.issue_date=Math.floor(new Date(dateHeader)/1000);}deferred.resolve(data);},function(response){$log.debug('Token creation failed.');var error=response.data;if(!error.hasOwnProperty('error')){error={error:response.status,error_description:response.data};}deferred.reject(error);});return deferred.promise;}};});angular.module('sb.auth').factory('PermissionManager',function($log,$q,$rootScope,Session,SessionState,CurrentUser,Notification,Priority){'use strict';var permCache={};var NOTIFY_PERMISSIONS='notify_permissions';function resolvePermission(permName){var deferred=$q.defer();if(permCache.hasOwnProperty(permName)){deferred.resolve(permCache[permName]);}else{CurrentUser.resolve().then(function(user){permCache[permName]=user[permName];deferred.resolve(permCache[permName]);},function(error){deferred.reject(error);});}return deferred.promise;}function clearPermissionCache(){$log.debug('Resetting permission cache.');permCache={};$rootScope.$broadcast(NOTIFY_PERMISSIONS);}function permissionListenHandler(permName,handler){return function(){resolvePermission(permName).then(function(value){handler(value);},function(){handler(null);});};}return{initialize:function initialize(){$log.debug('Initializing permissions');var removeNotifier=Notification.intercept(function(message){switch(message.type){case SessionState.LOGGED_IN:case SessionState.LOGGED_OUT:clearPermissionCache();break;default:break;}},Priority.LAST);$rootScope.$on('$destroy',removeNotifier);if(Session.getSessionState()!==SessionState.PENDING){clearPermissionCache();}},listen:function listen(scope,permName,handler){var messageHandler=permissionListenHandler(permName,handler);scope.$on('$destroy',$rootScope.$on(NOTIFY_PERMISSIONS,messageHandler));messageHandler();},resolve:function resolve(permName){return resolvePermission(permName);}};});angular.module('sb.auth').constant('preExpireDelta',600);angular.module('sb.auth').factory('Session',function(SessionState,AccessToken,$rootScope,$log,$q,$state,SystemInfo,Notification,Severity){'use strict';var sessionState=SessionState.PENDING;function updateSessionState(newState){if(newState!==sessionState){sessionState=newState;Notification.send(newState,newState,Severity.SUCCESS);}}function validateToken(){var deferred=$q.defer();return SystemInfo.get({},function(info){if(AccessToken.getAccessToken()){deferred.resolve(info);}else{deferred.reject(info);}}).$promise;}function initializeSession(){var deferred=$q.defer();if(!AccessToken.getAccessToken()){$log.debug('No token found');updateSessionState(SessionState.LOGGED_OUT);deferred.resolve();}else{validateToken().then(function(){$log.debug('Token validated');updateSessionState(SessionState.LOGGED_IN);deferred.resolve(sessionState);},function(){$log.debug('Token not validated');AccessToken.clear();updateSessionState(SessionState.LOGGED_OUT);deferred.resolve(sessionState);});}return deferred.promise;}function _destroySession(){AccessToken.clear();updateSessionState(SessionState.LOGGED_OUT);$state.reload();}initializeSession();return{getSessionState:function getSessionState(){return sessionState;},resolveSessionState:function resolveSessionState(){var deferred=$q.defer();if(sessionState!==SessionState.PENDING){deferred.resolve(sessionState);}else{var unwatch=$rootScope.$watch(function(){return sessionState;},function(){if(sessionState!==SessionState.PENDING){deferred.resolve(sessionState);unwatch();}});}return deferred.promise;},isLoggedIn:function isLoggedIn(){return sessionState===SessionState.LOGGED_IN;},destroySession:function destroySession(){_destroySession();},updateSession:function updateSession(token){var deferred=$q.defer();if(!token){_destroySession();deferred.resolve(sessionState);}else{AccessToken.setToken(token);initializeSession().then(function(){deferred.resolve(sessionState);},function(){deferred.resolve(sessionState);});}return deferred.promise;}};});angular.module('sb.auth').factory('SessionModalService',function($modal){'use strict';return{showLoginRequiredModal:function showLoginRequiredModal(){var modalInstance=$modal.open({templateUrl:'app/auth/template'+'/modal/login_required.html',backdrop:'static',controller:'LoginRequiredModalController'});return modalInstance.result;}};});angular.module('sb.board').controller('AddBoardController',function($scope,$modalInstance,$state,params,Board,Project,Worklist,$q,BoardHelper){'use strict';function saveBoard(){$scope.board.$create(function(result){$scope.isSaving=false;$modalInstance.dismiss('success');$state.go('sb.board.detail',{boardID:result.id});});}function addLaneDetails(position){return function(lane){$scope.board.lanes.push({board_id:$scope.board.id,list_id:lane.id,position:position});};}function saveBoardWithLanes(){$scope.board.lanes=[];var lanePromises=[];for(var i=0;i<$scope.lanes.length;i++){var lane=$scope.lanes[i];var addLane=addLaneDetails(i);lane.project_id=$scope.board.project_id;lane.private=$scope.board.private;lanePromises.push(lane.$create(addLane));}$q.all(lanePromises).then(saveBoard);}$scope.save=function(){$scope.isSaving=true;if($scope.lanes.length>0){saveBoardWithLanes();}else{saveBoard();}};$scope.close=function(){$modalInstance.dismiss('cancel');};$scope.addLane=function(){$scope.lanes.push(new Worklist({title:'',editing:true}));};$scope.removeLane=function(lane){var idx=$scope.lanes.indexOf(lane);$scope.lanes.splice(idx,1);};$scope.toggleEdit=function(lane){lane.editing=!lane.editing;};$scope.lanesSortable={dragMove:BoardHelper.maybeScrollContainer('new-board')};$scope.isSaving=false;$scope.lanes=[];$scope.board=new Board({title:'',lanes:[]});});angular.module('sb.board').controller('BoardArchiveController',function($log,$scope,$state,board,$modalInstance){'use strict';$scope.board=board;$scope.isUpdating=true;$scope.error={};$scope.remove=function(){$scope.board.$delete(function(){$modalInstance.dismiss('success');$state.go('sb.dashboard.boards');});};$scope.close=function(){$modalInstance.dismiss('cancel');};});angular.module('sb.board').controller('BoardDetailController',function($scope,Worklist,$modal,Board,Project,$stateParams,BoardHelper,DueDate,$document,User,$q,moment){'use strict';$scope.board=new Board();function loadBoard(){var params={id:$stateParams.boardID};Board.Permissions.get(params,function(perms){$scope.permissions={editBoard:perms.indexOf('edit_board')>-1,moveCards:perms.indexOf('move_cards')>-1};});Board.get(params,function(board){var offsets=BoardHelper.recordLaneScrollbars($scope.board);$scope.board=board;$scope.owners=[];$scope.users=[];angular.forEach(board.owners,function(id){$scope.owners.push(User.get({id:id}));});angular.forEach(board.users,function(id){$scope.users.push(User.get({id:id}));});BoardHelper.scrollLanes(board,offsets);});}function showAddItemModal(_worklist){var modalInstance=$modal.open({size:'lg',templateUrl:'app/worklists/template/additem.html',backdrop:'static',controller:'WorklistAddItemController',resolve:{worklist:function worklist(){return _worklist;},valid:function valid(){var board=$scope.board;return function(item){var valid=true;angular.forEach(board.lanes,function(lane){var items=lane.worklist.items;angular.forEach(items,function(listItem){var type=item.type.toLowerCase();if(!item.hasOwnProperty('value')){item.value=item.id;}if(item.value===listItem.item_id&&type===listItem.item_type){valid=false;item.invalid=item.type+' is already in'+' the board ('+lane.worklist.title+' lane).';}});});return valid;};}}});return modalInstance.result;}$scope.addItem=function(worklist){loadBoard();showAddItemModal(worklist).finally(function(){loadBoard();});};$scope.toggleEditMode=function(){if($scope.showEditForm){loadBoard();}$scope.showEditForm=!$scope.showEditForm;};$scope.update=function(){$scope.isUpdating=true;var params={id:$scope.board.id};var owners={codename:'edit_board',users:$scope.board.owners};var users={codename:'move_cards',users:$scope.board.users};$scope.board.$update().then(function(){var updating=[Board.Permissions.update(params,owners).$promise,Board.Permissions.update(params,users).$promise];$q.all(updating).then(function(){$scope.isUpdating=false;$scope.toggleEditMode();});});};$scope.unarchive=function(){$scope.board.archived=false;$scope.board.$update().then(function(){angular.forEach($scope.board.lanes,function(lane){lane.worklist.archived=false;Worklist.update(lane.worklist);});});};$scope.remove=function(){var modalInstance=$modal.open({templateUrl:'app/boards/template/archive.html',backdrop:'static',controller:'BoardArchiveController',resolve:{board:function board(){return $scope.board;}}});return modalInstance.result;};$scope.addLane=function(){var modalInstance=$modal.open({size:'lg',templateUrl:'app/worklists/template/new.html',backdrop:'static',controller:'AddWorklistController',resolve:{params:function params(){return{};},redirect:function redirect(){return false;}}});modalInstance.result.then(function(worklist){$scope.board.lanes.push({list_id:worklist.id,worklist:Worklist.get({id:worklist.id}),position:$scope.board.lanes.length,board_id:$scope.board.id});Board.update($scope.board);});};$scope.removeLane=function(lane){var modalInstance=$modal.open({templateUrl:'app/worklists/template/delete.html',backdrop:'static',controller:'WorklistDeleteController',resolve:{worklist:function worklist(){return lane.worklist;},redirect:false}});modalInstance.result.then(function(){var idx=$scope.board.lanes.indexOf(lane);$scope.board.lanes.splice(idx,1);$scope.board.$update();});};$scope.removeCard=function(worklist,item){Worklist.ItemsController.delete({id:worklist.id,item_id:item.id}).$promise.then(function(){var idx=worklist.items.indexOf(item);worklist.items.splice(idx,1);});};function updateBoardLanes(){for(var i=0;i<$scope.board.lanes.length;i++){$scope.board.lanes[i].position=i;}Board.update($scope.board);}$scope.editWorklist=function(_worklist2){var modalInstance=$modal.open({size:'lg',templateUrl:'app/worklists/template/new.html',backdrop:'static',controller:'WorklistEditController',resolve:{worklist:function worklist(){return _worklist2;},board:function board(){return $scope.board;}}});modalInstance.result.finally(function(){loadBoard();});};$scope.searchUsers=function(value,array){var deferred=$q.defer();User.browse({full_name:value,limit:10},function(searchResults){var results=[];angular.forEach(searchResults,function(result){if(array.indexOf(result.id)===-1){results.push(result);}});deferred.resolve(results);});return deferred.promise;};$scope.formatUserName=function(model){if(!!model){return model.name;}return'';};$scope.addUser=function(model,modelArray,idArray){idArray.push(model.id);modelArray.push(model);};$scope.removeUser=function(model,modelArray,idArray){var idIdx=idArray.indexOf(model.id);idArray.splice(idIdx,1);var modelIdx=modelArray.indexOf(model);modelArray.splice(modelIdx,1);};$scope.newDueDate=function(){var modalInstance=$modal.open({templateUrl:'app/due_dates/template/new.html',backdrop:'static',controller:'DueDateNewController',resolve:{board:function board(){return $scope.board;}}});modalInstance.result.finally(function(){loadBoard();});};$scope.editDueDate=function(_dueDate){var modalInstance=$modal.open({templateUrl:'app/due_dates/template/new.html',backdrop:'static',controller:'DueDateEditController',resolve:{board:function board(){return $scope.board;},dueDate:function dueDate(){return _dueDate;}}});modalInstance.result.finally(function(){loadBoard();});};$scope.removeDueDate=function(_dueDate2){var modalInstance=$modal.open({templateUrl:'app/due_dates/template/remove_from_board.html',backdrop:'static',controller:'DueDateRemoveController',resolve:{board:function board(){return $scope.board;},dueDate:function dueDate(){return _dueDate2;}}});modalInstance.result.finally(function(){loadBoard();});};$scope.isDue=function(card){if(card.item_type==='task'){if(card.task.status==='merged'){return false;}}var now=moment();var tomorrow=now.clone();tomorrow.add(1,'day');if(!card.resolved_due_date){return false;}if((now.isSame(card.resolved_due_date.date)||now.isBefore(card.resolved_due_date.date))&&(tomorrow.isSame(card.resolved_due_date.date)||tomorrow.isAfter(card.resolved_due_date.date))){return true;}else{return false;}};$scope.isLate=function(card){if(card.item_type==='task'){if(card.task.status==='merged'){return false;}}var now=moment();if(!card.resolved_due_date){return false;}if(now.isAfter(card.resolved_due_date.date)){return true;}else{return false;}};$scope.showCardDetail=function(_card,lane){var modalInstance=$modal.open({templateUrl:'app/boards/template/card_details.html',backdrop:'static',controller:'CardDetailController',resolve:{card:function card(){return _card;},board:function board(){return $scope.board;},worklist:function worklist(){return lane.worklist;},permissions:function permissions(){return $scope.permissions;}}});modalInstance.result.finally(function(){loadBoard();});};$scope.lanesSortable={orderChanged:updateBoardLanes,dragMove:BoardHelper.maybeScrollContainer('kanban-board'),accept:function accept(sourceHandle,dest){return sourceHandle.itemScope.sortableScope.$id===dest.$id;}};$scope.cardsSortable={orderChanged:BoardHelper.moveCard,itemMoved:BoardHelper.moveCard,dragMove:BoardHelper.maybeScrollContainer('kanban-board'),accept:function accept(sourceHandle,dest){var srcParent=sourceHandle.itemScope.sortableScope.$parent;var dstParentSortable=dest.$parent.sortableScope;if(!$scope.permissions.editBoard){return true;}if(!srcParent.sortableScope){return false;}return srcParent.sortableScope.$id===dstParentSortable.$id;}};$document[0].ondragstart=function(event){event.preventDefault();};loadBoard();$scope.showEditForm=false;$scope.showAddOwner=false;$scope.isUpdating=false;});angular.module('sb.board').controller('BoardsListController',function($scope){'use strict';$scope.boardResourceTypes=['Board'];$scope.worklistResourceTypes=['Worklist'];});angular.module('sb.board').controller('CardDetailController',function($scope,card,board,worklist,permissions,Story,Task,DueDate,Worklist,$document,$timeout,$modalInstance,$modal){'use strict';$scope.modifications={title:'',description:'',notes:''};$scope.toggleEditTitle=function(){if(!(permissions.moveCards||permissions.editBoard)){return false;}if(!$scope.editingTitle){if(card.item_type==='story'){$scope.modifications.title=card.story.title;}else if(card.item_type==='task'){$scope.modifications.title=card.task.title;}}$scope.editingTitle=!$scope.editingTitle;};$scope.editTitle=function(){var params={};if(card.item_type==='story'){params={id:card.story.id,title:$scope.modifications.title};Story.update(params,function(updated){$scope.toggleEditTitle();card.story.title=updated.title;});}else if(card.item_type==='task'){params={id:card.task.id,title:$scope.modifications.title};Task.update(params,function(updated){$scope.toggleEditTitle();card.task.title=updated.title;});}};$scope.toggleEditDescription=function(){if(!(permissions.moveCards||permissions.editBoard)){return false;}if(!$scope.editingTitle){$scope.modifications.description=$scope.story.description;}$scope.editingDescription=!$scope.editingDescription;};$scope.editStoryDescription=function(){var params={id:$scope.story.id,description:$scope.modifications.description};Story.update(params,function(updated){$scope.toggleEditDescription();$scope.story.description=updated.description;});};$scope.toggleEditNotes=function(){if(!(permissions.moveCards||permissions.editBoard)){return false;}if(!$scope.editingTitle){$scope.modifications.notes=$scope.card.task.link;}$scope.editingNotes=!$scope.editingNotes;};$scope.editTaskNotes=function(){var params={id:card.task.id,link:$scope.modifications.notes};Task.update(params,function(updated){$scope.toggleEditNotes();$scope.card.task.link=updated.link;});};$scope.noDate={id:-1,date:null};$scope.getRelevantDueDates=function(){$scope.relevantDates=[];angular.forEach(board.due_dates,function(date){if(date.assignable){$scope.relevantDates.push(date);}});};$scope.toggleEditDueDate=function(){if(permissions.moveCards||permissions.editBoard){$scope.editingDueDate=!$scope.editingDueDate;}};$scope.toggleDueDateDropdown=function(){var dropdown=$document[0].getElementById('due-dates-dropdown');var button=dropdown.getElementsByTagName('button')[0];$timeout(function(){button.click();},0);};function cardHasDate(date){for(var i=0;i<card[card.item_type].due_dates.length;i++){if(card[card.item_type].due_dates[i]===date.id){return true;}}return false;}function assignDueDate(date){if(card.item_type==='task'){date.tasks.push(card.task);}else if(card.item_type==='story'){date.stories.push(card.story);}var params={id:date.id,tasks:date.tasks,stories:date.stories};DueDate.update(params).$promise.then(function(updated){if(card.item_type==='task'){card.task.due_dates.push(updated.id);$scope.getRelevantDueDates(card.task.due_dates);}else if(card.item_type==='story'){card.story.due_dates.push(updated.id);$scope.getRelevantDueDates(card.story.due_dates);}$scope.assigningDueDate=false;});}$scope.setDisplayDate=function(date){if(!cardHasDate(date)&&date.id!==-1){assignDueDate(date);}card.resolved_due_date=date;var params={id:card.list_id,item_id:card.id,list_position:card.list_position,display_due_date:date.id};Worklist.ItemsController.update(params,function(){$scope.editingDueDate=false;});};$scope.validDueDate=function(dueDate){return dueDate&&!(dueDate===$scope.noDate);};$scope.toggleAssigneeTypeahead=function(){var typeahead=$document[0].getElementById('assignee');var assignLink=typeahead.getElementsByTagName('a')[0];$timeout(function(){assignLink.click();},0);};$scope.toggleEditAssignee=function(){$scope.editingAssignee=!$scope.editingAssignee;};$scope.updateTask=function(task){var params={id:task.id,assignee_id:task.assignee_id};Task.update(params,function(){$scope.editingAssignee=false;});};$scope.deleteCard=function(){Worklist.ItemsController.delete({id:$scope.card.list_id,item_id:$scope.card.id},function(){$modalInstance.close('deleted');});};$scope.close=function(){$modalInstance.close('closed');};$scope.newDueDate=function(){var modalInstance=$modal.open({templateUrl:'app/due_dates/template/new.html',backdrop:'static',controller:'DueDateNewController',resolve:{board:function board(){return $scope.board;}}});modalInstance.result.then(function(dueDate){if(dueDate.hasOwnProperty('date')){board.due_dates.push(dueDate);}$scope.getRelevantDueDates();$scope.setDisplayDate(dueDate);});};if(card.item_type==='task'){$scope.story=Story.get({id:card.task.story_id});}else if(card.item_type==='story'){$scope.story=card.story;}$scope.getRelevantDueDates();$scope.card=card;$scope.board=board;$scope.permissions=permissions;$scope.worklist=worklist;$scope.showDescription=true;$scope.showTaskNotes=true;$scope.assigningDueDate=false;$scope.editingDueDate=false;$scope.editingDescription=false;$scope.editingNotes=false;$scope.editingAssignee=false;});angular.module('sb.board').factory('BoardHelper',function($document,$window,$timeout,Worklist){'use strict';function scrollFunction(elementID){return function(itemPosition,containment,eventObj){if(eventObj){var container=document.getElementById(elementID);var offsetX=$window.pageXOffset||$document[0].documentElement.scrollLeft;var targetX=eventObj.pageX-offsetX;var leftBound=container.clientLeft+container.offsetLeft;var parent=container.offsetParent;while(parent){leftBound+=parent.offsetLeft;parent=parent.offsetParent;}var rightBound=leftBound+container.clientWidth;if(targetX<leftBound){container.scrollLeft-=10;}else if(targetX>rightBound){container.scrollLeft+=10;}}};}function moveCard(result){var list=result.dest.sortableScope.$parent.lane.worklist;var position=result.dest.index;var item=list.items[position];item.list_position=position;Worklist.ItemsController.update({id:list.id,item_id:item.id,list_position:item.list_position,list_id:list.id});}function recordLaneScrollbars(board){var scrollbars={};angular.forEach(board.lanes,function(lane){var elem=$document[0].getElementById('lane-'+lane.id);if(!!elem){scrollbars[lane.id]=elem.scrollTop;}});return scrollbars;}function scrollLanes(board,scrollbars){angular.forEach(board.lanes,function(lane){$timeout(function(){var elem=$document[0].getElementById('lane-'+lane.id);if(!!elem){elem.scrollTop=scrollbars[lane.id];}});});}return{maybeScrollContainer:scrollFunction,moveCard:moveCard,recordLaneScrollbars:recordLaneScrollbars,scrollLanes:scrollLanes};});angular.module('sb.board').factory('NewBoardService',function($modal,$log,Session,SessionModalService){'use strict';return{showNewBoardModal:function showNewBoardModal(userId){if(!Session.isLoggedIn()){return SessionModalService.showLoginRequiredModal();}else{var modalInstance=$modal.open({size:'lg',templateUrl:'app/boards/template/new.html',backdrop:'static',controller:'AddBoardController',resolve:{params:function params(){return{userId:userId||null};}}});return modalInstance.result;}}};});angular.module('sb.dashboard').controller('BoardsWorklistsController',function($scope,currentUser,Worklist,Board,SubscriptionList){'use strict';var params={user_id:currentUser.id};$scope.loadingBoards=true;$scope.loadingWorklists=true;Board.browse(params).$promise.then(function(boards){$scope.loadingBoards=false;$scope.boards=boards;});Worklist.browse(params).$promise.then(function(worklists){$scope.loadingWorklists=false;$scope.worklists=worklists;});$scope.worklistSubscriptions=SubscriptionList.subsList('worklist',currentUser);});angular.module('sb.dashboard').controller('DashboardController',function($q,$scope,currentUser,Story,SubscriptionList,SubscriptionEvent,Task){'use strict';$scope.filterTasks=Task.browse({assignee_id:currentUser.id},function(tasks){var todo=[];var progress=[];var review=[];var invalid=[];angular.forEach(tasks,function(task){task.type='Task';if(task.status==='review'){review.push(task);}else if(task.status==='todo'){todo.push(task);}else if(task.status==='inprogress'){progress.push(task);}else{invalid.push(task);}});$scope.reviewTasks=review;$scope.todoTasks=todo;$scope.progressTasks=progress;$scope.invalidTasks=invalid;});$scope.updateTask=function(task,fieldName,value){if(!!fieldName){task[fieldName]=value;}task.$update(function(){$scope.showTaskEditForm=false;});};$scope.createdStories=Story.browse({creator_id:currentUser.id});$scope.showActive=true;$scope.showMerged=true;$scope.showInvalid=true;$scope.filterStories=function(){var status=[];if($scope.showActive){status.push('active');}if($scope.showMerged){status.push('merged');}if($scope.showInvalid){status.push('invalid');}if(status.length===0){$scope.createdStories=[];return;}Story.browse({sort_field:'id',sort_dir:'desc',status:status,creator_id:currentUser.id},function(result){$scope.createdStories=result;});};function loadEvents(){$scope.subscriptionEvents=null;SubscriptionEvent.browse({subscriber_id:currentUser.id,offset:0,limit:50,sort_dir:'desc',sort_field:'created_at'},function(results){results.forEach(function(row){if(row.hasOwnProperty('event_info')){row.event_info=JSON.parse(row.event_info);}else{row.event_info={};}});$scope.subscriptionEvents=results;$scope.collapsedEvents=results.length>1;});}loadEvents();$scope.removeEvent=function(event){var deferred=$q.defer();deferred.resolve([event.$delete(function(){var idx=$scope.subscriptionEvents.indexOf(event);$scope.subscriptionEvents.splice(idx,1);})]);return deferred.promise;};$scope.removeAllEvents=function(){var promises=[];for(var i=0;i<$scope.subscriptionEvents.length;i++){var event=$scope.subscriptionEvents[i];var promise=$scope.removeEvent(event);promises.push(promise);}$q.all(promises).then(loadEvents);};$scope.storySubscriptions=SubscriptionList.subsList('story',currentUser);});angular.module('sb.dashboard').controller('DashboardSubscriptionsController',function($scope,Story,Project,ProjectGroup,SubscriptionList,Worklist,currentUser){'use strict';$scope.storySubscriptions=SubscriptionList.subsList('story',currentUser);$scope.stories=Story.browse({subscriber_id:currentUser.id});$scope.projectSubscriptions=SubscriptionList.subsList('project',currentUser);$scope.projects=Project.browse({subscriber_id:currentUser.id});$scope.projectGroupSubscriptions=SubscriptionList.subsList('project_group',currentUser);$scope.projectGroups=ProjectGroup.browse({subscriber_id:currentUser.id});$scope.worklistSubscriptions=SubscriptionList.subsList('worklist',currentUser);$scope.worklists=Worklist.browse({subscriber_id:currentUser.id});});angular.module('sb.dashboard').controller('HomeController',function($state,sessionState,SessionState){'use strict';if(sessionState===SessionState.LOGGED_IN){$state.go('sb.dashboard.stories');}else{$state.go('sb.page.about');}});angular.module('sb.dashboard').controller('WorklistEventController',function($scope,Worklist){'use strict';$scope.worklist=Worklist.get({id:$scope.evt.event_info.worklist_id});});angular.module('sb.dashboard').directive('subscriptionEvent',function($log,User){'use strict';return{restrict:'A',scope:{subscriptionEvent:'@'},link:function link(scope){try{var evt=JSON.parse(scope.subscriptionEvent);scope.evt=evt;scope.author=User.get({id:evt.author_id});scope.event_type=evt.event_type;scope.created_at=evt.created_at;}catch(e){$log.error(e);}},templateUrl:'app/dashboard/template/subscription_event.html'};});angular.module('sb.due_date').controller('DueDateEditController',function($scope,$modalInstance,$state,$q,DueDate,User,board,dueDate){'use strict';$scope.owners=[];$scope.users=[];angular.forEach(dueDate.owners,function(id){$scope.owners.push(User.get({id:id}));});angular.forEach(dueDate.users,function(id){$scope.users.push(User.get({id:id}));});$scope.searchUsers=function(value,array){var deferred=$q.defer();User.browse({full_name:value,limit:10},function(searchResults){var results=[];angular.forEach(searchResults,function(result){if(array.indexOf(result.id)===-1){results.push(result);}});deferred.resolve(results);});return deferred.promise;};$scope.formatUserName=function(model){if(!!model){return model.name;}return'';};$scope.addUser=function(model,modelArray,idArray){idArray.push(model.id);modelArray.push(model);};$scope.removeUser=function(model,modelArray,idArray){var idIdx=idArray.indexOf(model.id);idArray.splice(idIdx,1);var modelIdx=modelArray.indexOf(model);modelArray.splice(modelIdx,1);};function saveDueDate(){DueDate.update($scope.dueDate,function(result){var params={id:$scope.dueDate.id};var owners={codename:'edit_date',users:$scope.dueDate.owners};var users={codename:'assign_date',users:$scope.dueDate.users};DueDate.Permissions.update(params,users).$promise.then(function(){DueDate.Permissions.update(params,owners).$promise.then(function(){$scope.isSaving=false;$modalInstance.close(result);});});});}$scope.save=function(){$scope.isSaving=true;$scope.dueDate.date.second(0);saveDueDate();};$scope.close=function(){$modalInstance.dismiss('cancel');};$scope.isSaving=false;$scope.dueDate=dueDate;$scope.modalTitle='Edit Due Date';});angular.module('sb.due_date').controller('DueDateNewController',function($scope,$modalInstance,$state,$q,DueDate,board,CurrentUser,User){'use strict';var currentUser=CurrentUser.resolve();$scope.owners=[];$scope.users=[];angular.forEach(board.owners,function(id){$scope.owners.push(User.get({id:id}));});angular.forEach(board.users,function(id){$scope.users.push(User.get({id:id}));});function saveDueDate(){if($scope.mode==='edit'){$scope.dueDate.$create(function(result){$scope.isSaving=false;$modalInstance.close(result);});}else if($scope.mode==='find'){DueDate.update({id:$scope.selected.id,board_id:board.id},function(result){$scope.isSaving=false;$modalInstance.close(result);});}}$scope.searchUsers=function(value,array){var deferred=$q.defer();User.browse({full_name:value,limit:10},function(searchResults){var results=[];angular.forEach(searchResults,function(result){if(array.indexOf(result.id)===-1){results.push(result);}});deferred.resolve(results);});return deferred.promise;};$scope.formatUserName=function(model){if(!!model){return model.name;}return'';};$scope.addUser=function(model,modelArray,idArray){idArray.push(model.id);modelArray.push(model);};$scope.removeUser=function(model,modelArray,idArray){var idIdx=idArray.indexOf(model.id);idArray.splice(idIdx,1);var modelIdx=modelArray.indexOf(model);modelArray.splice(modelIdx,1);};$scope.save=function(){$scope.isSaving=true;$scope.dueDate.date.second(0);saveDueDate();};$scope.close=function(){$modalInstance.dismiss('cancel');};$scope.setMode=function(mode){$scope.mode=mode;};$scope.searchDueDates=function(){DueDate.browse($scope.criteria,function(results){var existing=[];angular.forEach(board.due_dates,function(date){existing.push(date.id);});$scope.results=results;angular.forEach(results,function(result){if(existing.indexOf(result.id)!==-1){var idx=$scope.results.indexOf(result);$scope.results.splice(idx,1);}});});};$scope.select=function(dueDate){$scope.selected=dueDate;};$scope.selected={};$scope.criteria={};currentUser.then(function(result){currentUser=result;$scope.criteria={user:currentUser.id};});$scope.isSaving=false;$scope.newDueDate=true;$scope.modalTitle='New Due Date';$scope.mode='edit';$scope.dueDate=new DueDate({name:''});if(!!board){$scope.dueDate.board_id=board.id;$scope.dueDate.owners=board.owners;$scope.dueDate.users=board.users;}});angular.module('sb.board').controller('DueDateRemoveController',function($log,$scope,$state,board,dueDate,$modalInstance,DueDate){'use strict';$scope.board=board;$scope.dueDate=dueDate;$scope.isUpdating=true;$scope.error={};$scope.remove=function(){DueDate.delete({id:dueDate.id,board_id:board.id},function(){$modalInstance.close('success');});};$scope.close=function(){$modalInstance.dismiss('cancel');};});angular.module('sb.notification').controller('NotificationsController',function($scope,Notification){'use strict';var defaultDisplayCount=5;$scope.displayCount=defaultDisplayCount;$scope.notifications=[];$scope.remove=function(notification){var idx=$scope.notifications.indexOf(notification);if(idx>-1){$scope.notifications.splice(idx,1);}if($scope.notifications.length<=defaultDisplayCount){$scope.displayCount=defaultDisplayCount;}};$scope.showMore=function(){$scope.displayCount=Math.min($scope.notifications.length,$scope.displayCount+5);};$scope.$on('$destroy',Notification.subscribe(function(notification){$scope.notifications.push(notification);}));});angular.module('sb.notification').directive('notifications',function(){'use strict';return{restrict:'E',templateUrl:'app/notification/template/notifications.html',controller:'NotificationsController'};});angular.module('sb.notification').constant('Priority',{BEFORE:-1,FIRST:0,LAST:999,AFTER:1000});angular.module('sb.notification').constant('Severity',{ERROR:'error',WARNING:'warning',INFO:'info',SUCCESS:'success'});angular.module('sb.notification').factory('Notification',function($log,Severity,Priority){'use strict';var subscribers=[];var interceptors=[];return{send:function send(type,message,severity,cause,callback,callbackLabel){if(!type||!message){$log.warn('Invoked Notification.send() without a type'+' or message.');return;}var n={'type':type,'message':message,'severity':severity||Severity.INFO,'cause':cause||null,'callback':callback||null,'callbackLabel':callbackLabel||null,'date':new Date()};for(var i=0;i<interceptors.length;i++){if(!!interceptors[i].method(n)){return;}}for(var j=0;j<subscribers.length;j++){subscribers[j](n);}},intercept:function intercept(interceptor,priority){var i={'priority':priority||Priority.LAST,'method':interceptor};interceptors.unshift(i);interceptors.sort(function(a,b){return a.priority-b.priority;});return function(){var idx=interceptors.indexOf(i);interceptors.splice(idx,1);};},subscribe:function subscribe(subscriber){subscribers.push(subscriber);return function(){subscribers.remove(subscriber);};}};});angular.module('sb.profile').controller('ProfilePreferencesController',function($scope,Preference,Notification,Severity){'use strict';$scope.preferences=Preference.getAll();$scope.save=function(){$scope.saving=true;Preference.saveAll($scope.preferences).then(function(){Notification.send('preferences','Preferences Saved!',Severity.SUCCESS);$scope.saving=false;},function(){$scope.saving=false;});};});angular.module('sb.profile').controller('ProfileTokenNewController',function($q,$log,$scope,$modalInstance,UserToken,user){'use strict';$scope.isSaving=false;$scope.token=new UserToken({user_id:user.id,expires_in:3600});$scope.save=function(){$scope.isSaving=true;$scope.token.$create(function(token){$modalInstance.close(token);$scope.isSaving=false;},function(){$scope.isSaving=false;});};$scope.close=function(){$modalInstance.dismiss('cancel');};});angular.module('sb.profile').controller('ProfileTokensController',function($scope,UserToken,tokens,$modal){'use strict';$scope.tokens=tokens;$scope.deleteToken=function(token){token.$delete(function(){var idx=$scope.tokens.indexOf(token);if(idx>-1){$scope.tokens.splice(idx,1);}});};$scope.issueToken=function(){$modal.open({templateUrl:'app/profile/template/token_new.html',backdrop:'static',controller:'ProfileTokenNewController',resolve:{user:function user(CurrentUser){return CurrentUser.resolve();}}}).result.then(function(token){$scope.tokens.push(token);});};});angular.module('sb.profile').controller('ProfileTokenItemController',function($scope,AccessToken){'use strict';var now=new Date();$scope.created=new Date($scope.token.created_at);$scope.expires=new Date($scope.token.created_at);$scope.expires.setSeconds($scope.expires.getSeconds()+$scope.token.expires_in);$scope.expired=$scope.expires.getTime()<now.getTime();$scope.current=$scope.token.access_token===AccessToken.getAccessToken();});angular.module('sb.project_group').controller('ProjectGroupDeleteController',function($scope,projectGroup,$modalInstance){'use strict';$scope.projectGroup=projectGroup;$scope.isUpdating=true;$scope.error={};$scope.remove=function(){$scope.projectGroup.$delete(function(){$modalInstance.close('success');});};$scope.close=function(){$modalInstance.dismiss('cancel');};});angular.module('sb.project_group').controller('ProjectGroupDetailController',function($scope,$stateParams,projectGroup,Story,Project,Preference,SubscriptionList,CurrentUser,Subscription,$q,ProjectGroupItem,ArrayUtil,$log){'use strict';var projectPageSize=Preference.get('project_group_detail_projects_page_size')||0;var storyPageSize=Preference.get('project_group_detail_stories_page_size')||0;$scope.projectGroup=projectGroup;$scope.projects=[];$scope.isSearchingProjects=false;$scope.editMode=false;$scope.toggleEdit=function(){$scope.editMode=!$scope.editMode;};$scope.listProjects=function(){$scope.isSearchingProjects=true;Project.browse({project_group_id:projectGroup.id,offset:$scope.projectSearchOffset,limit:projectPageSize,sort_dir:'desc'},function(result,headers){$scope.projectCount=parseInt(headers('X-Total'))||result.length;$scope.projectSearchOffset=parseInt(headers('X-Offset'))||0;$scope.projectSearchLimit=parseInt(headers('X-Limit'))||0;$scope.projects=result;$scope.isSearchingProjects=false;},function(error){$scope.error=error;$scope.isSearchingProjects=false;});};$scope.stories=[];$scope.selectedStatus={};$scope.selectedStatus.showActive=true;$scope.selectedStatus.showMerged=false;$scope.selectedStatus.showInvalid=false;$scope.filterStories=function(){var status=[];if($scope.selectedStatus.showActive){status.push('active');}if($scope.selectedStatus.showMerged){status.push('merged');}if($scope.selectedStatus.showInvalid){status.push('invalid');}if(status.length===0){$scope.stories=[];return;}Story.browse({project_group_id:projectGroup.id,sort_field:'id',sort_dir:'desc',status:status,offset:$scope.storySearchOffset,limit:storyPageSize},function(result,headers){$scope.storyCount=parseInt(headers('X-Total'))||result.length;$scope.storySearchOffset=parseInt(headers('X-Offset'))||0;$scope.storySearchLimit=parseInt(headers('X-Limit'))||0;$scope.stories=result;$scope.isSearchingStories=false;},function(error){$scope.error=error;$scope.isSearchingStories=false;});};$scope.nextPage=function(type){if(type==='stories'){$scope.storySearchOffset+=storyPageSize;$scope.filterStories();}else if(type==='projects'){$scope.projectSearchOffset+=projectPageSize;$scope.listProjects();}};$scope.previousPage=function(type){if(type==='stories'){$scope.storySearchOffset-=storyPageSize;if($scope.storySearchOffset<0){$scope.storySearchOffset=0;}$scope.filterStories();}else if(type==='projects'){$scope.projectSearchOffset-=projectPageSize;if($scope.projectSearchOffset<0){$scope.projectSearchOffset=0;}$scope.listProjects();}};$scope.updatePageSize=function(type,value){if(type==='stories'){Preference.set('project_group_detail_stories_page_size',value).then(function(){storyPageSize=value;$scope.filterStories();});}else if(type==='projects'){Preference.set('project_group_detail_projects_page_size',value).then(function(){projectPageSize=value;$scope.listProjects();});}};$scope.isSaving=false;$scope.searchProjects=function(value){var deferred=$q.defer();Project.browse({name:value,limit:10},function(results){var idxList=[];for(var i=0;i<$scope.projects.length;i++){var project=$scope.projects[i];if(!!project){idxList.push(project.id);}}for(var j=results.length-1;j>=0;j--){var resultId=results[j].id;if(idxList.indexOf(resultId)>-1){results.splice(j,1);}}deferred.resolve(results);},function(error){$log.error(error);deferred.resolve([]);});return deferred.promise;};$scope.formatProjectName=function(model){if(!!model){return model.name;}return'';};$scope.removeProject=function(index){$scope.projects.splice(index,1);};$scope.save=function(){$scope.isSaving=true;ProjectGroupItem.browse({projectGroupId:$scope.projectGroup.id},function(results){var loadedIds=[];results.forEach(function(project){loadedIds.push(project.id);});var promises=[];var desiredIds=[];$scope.projects.forEach(function(project){desiredIds.push(project.id);});var idsToDelete=ArrayUtil.difference(loadedIds,desiredIds);idsToDelete.forEach(function(id){var removeProjectDeferred=$q.defer();var item=new ProjectGroupItem({id:id,projectGroupId:projectGroup.id});item.$delete(function(result){removeProjectDeferred.resolve(result);},function(error){removeProjectDeferred.reject(error);});promises.push(removeProjectDeferred.promise);});var idsToAdd=ArrayUtil.difference(desiredIds,loadedIds);idsToAdd.forEach(function(id){var addProjectDeferred=$q.defer();var item=new ProjectGroupItem({id:id,projectGroupId:projectGroup.id});item.$create(function(result){addProjectDeferred.resolve(result);},function(error){addProjectDeferred.reject(error);});promises.push(addProjectDeferred.promise);});var deferred=$q.defer();promises.push(deferred.promise);$scope.projectGroup.$update(function(success){deferred.resolve(success);},function(error){$log.error(error);deferred.reject(error);});$q.all(promises).then(function(){$scope.editMode=false;$scope.isSaving=false;},function(error){$log.error(error);});});};$scope.addProject=function(){$scope.projects.push({});};$scope.selectNewProject=function(index,model){$scope.projects[index]=model;};$scope.checkValidProjects=function(){if($scope.projects.length===0){return false;}for(var i=0;i<$scope.projects.length;i++){var project=$scope.projects[i];if(!project.id){return false;}}return true;};$scope.listProjects();$scope.filterStories();var cuPromise=CurrentUser.resolve();$scope.resolvedUser=false;cuPromise.then(function(user){$scope.projectSubscriptions=SubscriptionList.subsList('project',user);$scope.storySubscriptions=SubscriptionList.subsList('story',user);$scope.projectGroupSubscription=Subscription.browse({target_type:'project_group',target_id:$scope.projectGroup.id,user_id:user.id});$scope.resolvedUser=true;});});angular.module('sb.project_group').controller('ProjectGroupItemController',function($scope,$log,ProjectGroupItem){'use strict';$scope.projectGroupItems=[];$scope.loadingProjectGroupItems=false;if(!$scope.projectGroup){return;}var id=$scope.projectGroup.id;$scope.loadingProjectGroupItems=true;ProjectGroupItem.browse({projectGroupId:id},function(results){$scope.loadingProjectGroupItems=false;$scope.projectGroupItems=results;$scope.collapsed=results.length>1;},function(error){$log.error(error);$scope.loadingProjectGroupItems=false;});});angular.module('sb.project_group').controller('ProjectGroupListController',function($scope,$modal,SubscriptionList,CurrentUser,$state,$location,SearchHelper){'use strict';$scope.resourceTypes=['ProjectGroup'];var params=$location.search();$scope.defaultCriteria=SearchHelper.parseParameters(params);$scope.newProjectGroup=function(){$scope.modalInstance=$modal.open({templateUrl:'app/project_group/template/new.html',backdrop:'static',controller:'ProjectGroupNewController'});$scope.modalInstance.result.then(function(projectGroup){$scope.showMobileNewMenu=false;$state.go('sb.project_group.detail',{id:projectGroup.id});});};var cuPromise=CurrentUser.resolve();cuPromise.then(function(user){$scope.projectGroupSubscriptions=SubscriptionList.subsList('project_group',user);});});angular.module('sb.project_group').controller('ProjectGroupNewController',function($q,$log,$scope,$modalInstance,ProjectGroup,ProjectGroupItem,Project){'use strict';$scope.isSaving=false;$scope.projects=[{}];$scope.projectGroup=new ProjectGroup();$scope.error={};$scope.searchProjects=function(value){var deferred=$q.defer();Project.browse({name:value,limit:10},function(results){var idxList=[];for(var i=0;i<$scope.projects.length;i++){var project=$scope.projects[i];if(!!project){idxList.push(project.id);}}for(var j=results.length-1;j>=0;j--){var resultId=results[j].id;if(idxList.indexOf(resultId)>-1){results.splice(j,1);}}deferred.resolve(results);},function(error){$log.error(error);$scope.isSaving=false;});return deferred.promise;};$scope.formatProjectName=function(model){if(!!model){return model.name;}return'';};$scope.addProject=function(){$scope.projects.push({});};$scope.selectNewProject=function(index,model){$scope.projects[index]=model;};$scope.removeProject=function(index){$scope.projects.splice(index,1);};$scope.save=function(){$scope.isSaving=true;$scope.projectGroup.$save(function(projectGroup){var promises=[];$scope.projects.forEach(function(project){var deferred=$q.defer();var item=new ProjectGroupItem({id:project.id,projectGroupId:projectGroup.id});item.$create(function(result){deferred.resolve(result);},function(error){deferred.reject(error);});promises.push(deferred.promise);});$q.all(promises).then(function(){$modalInstance.close(projectGroup);},function(error){$log.error(error.data.faultstring);$scope.error=error.data.faultstring;$modalInstance.dismiss('cancel');$scope.isSaving=false;});},function(error){$modalInstance.dismiss('cancel');$log.error(error.data.faultstring);$scope.error=error.data.faultString;$scope.isSaving=false;});};$scope.close=function(){$modalInstance.dismiss('cancel');};$scope.checkValidProjects=function(){if($scope.projects.length===0){return false;}for(var i=0;i<$scope.projects.length;i++){var project=$scope.projects[i];if(!project.id){return false;}}return true;};});angular.module('sb.projects').controller('ProjectDetailController',function($scope,$rootScope,$state,$stateParams,Project,Story,Session,isSuperuser,CurrentUser,Subscription){'use strict';var id=$stateParams.hasOwnProperty('id')?$stateParams.id:null;if(!isNaN(id)){id=parseInt(id,10);}if(id===null){$state.go('sb.index');return;}$scope.isLoading=true;$scope.isUpdating=false;$scope.error={};function handleServiceError(error){$scope.error=error;$scope.isLoading=false;$scope.isUpdating=false;}$scope.projectSubscription={};$scope.resolvedUser=false;function handleServiceSuccess(){$scope.isLoading=false;$scope.isUpdating=false;var cuPromise=CurrentUser.resolve();cuPromise.then(function(user){$scope.projectSubscription=Subscription.browse({target_type:'project',target_id:$scope.project.id,user_id:user.id});$scope.resolvedUser=true;});}function loadProject(){return Project.get({'id':id},function(result){handleServiceSuccess();return result;},handleServiceError);}$scope.project=loadProject();$scope.cancel=function(){loadProject();$scope.showEditForm=false;};$scope.toggleEditMode=function(){if(isSuperuser){$scope.showEditForm=!$scope.showEditForm;setTimeout(function(){$rootScope.$broadcast('elastic:adjust');},1);}else{$scope.showEditForm=false;}};$scope.update=function(){$scope.isUpdating=true;$scope.error={};$scope.project.$update(function(){$scope.isUpdating=false;$scope.showEditForm=false;handleServiceSuccess();},handleServiceError);};});angular.module('sb.projects').controller('ProjectListController',function($scope,$modal,isSuperuser,SubscriptionList,CurrentUser,$location,SearchHelper){'use strict';$scope.is_superuser=isSuperuser;$scope.resourceTypes=['Project'];var params=$location.search();$scope.defaultCriteria=SearchHelper.parseParameters(params);$scope.addProject=function(){$scope.modalInstance=$modal.open({size:'lg',templateUrl:'app/projects/template/new.html',backdrop:'static',controller:'ProjectNewController'});};var cuPromise=CurrentUser.resolve();cuPromise.then(function(user){$scope.projectSubscriptions=SubscriptionList.subsList('project',user);});});angular.module('sb.projects').controller('ProjectNewController',function($scope,$state,$modalInstance,Project){'use strict';$scope.newProject=new Project();$scope.isCreating=false;$scope.error={};$scope.createProject=function(){$scope.isCreating=true;$scope.error={};$scope.newProject.$create(function(project){$modalInstance.dismiss('success');$state.go('sb.project.detail',{id:project.id});},function(error){$scope.isCreating=false;$scope.error=error;});};$scope.close=function(){$modalInstance.dismiss('cancel');};});angular.module('sb.projects').controller('ProjectStoryListController',function($scope,$state,$stateParams,Story,NewStoryService,Preference,SubscriptionList,CurrentUser){'use strict';var pageSize=Preference.get('project_detail_page_size');function resetScope(){$scope.storyCount=0;$scope.stories=[];$scope.error={};}$scope.searchQuery='';$scope.isSearching=false;$scope.filter='active';$scope.offsets={'active':0,'merged':0,'invalid':0};$scope.setFilter=function(state){$scope.offsets[$scope.filter]=$scope.searchOffset;$scope.filter=state;$scope.searchOffset=$scope.offsets[$scope.filter];$scope.search();};$scope.search=function(){resetScope();$scope.isSearching=true;Story.browse({project_id:$scope.project.id,status:$scope.filter||null,offset:$scope.searchOffset,limit:pageSize,sort_dir:'desc'},function(result,headers){$scope.storyCount=parseInt(headers('X-Total'))||result.length;$scope.searchOffset=parseInt(headers('X-Offset'))||0;$scope.searchLimit=parseInt(headers('X-Limit'))||0;$scope.stories=result;$scope.isSearching=false;},function(error){$scope.error=error;$scope.isSearching=false;});};$scope.updatePageSize=function(value){Preference.set('project_detail_page_size',value).then(function(){pageSize=value;$scope.search();});};$scope.nextPage=function(){$scope.searchOffset+=pageSize;$scope.search();};$scope.previousPage=function(){$scope.searchOffset-=pageSize;if($scope.searchOffset<0){$scope.searchOffset=0;}$scope.search();};$scope.newStory=function(){NewStoryService.showNewStoryModal($scope.project.id).then(function(story){$state.go('sb.story.detail',{storyId:story.id});});};resetScope();$scope.project.$promise.then(function(){$scope.search();});var cuPromise=CurrentUser.resolve();cuPromise.then(function(user){$scope.storySubscriptions=SubscriptionList.subsList('story',user);});});angular.module('sb.search').controller('SearchController',function($log,$q,$scope,Criteria,$location,SearchHelper){'use strict';var params=$location.search();$scope.defaultCriteria=SearchHelper.parseParameters(params);$scope.resourceTypes=['TaskStatus','Story','Project','User','Task','ProjectGroup','Board','Worklist'];});angular.module('sb.search').controller('SearchCriteriaController',function($log,$q,$scope,$location,$injector,Criteria){'use strict';var resourceTypes=[];$scope.criteria=[];$scope.init=function(types,defaultCriteria){resourceTypes=types||$scope.resourceTypes||resourceTypes;if(!!defaultCriteria){defaultCriteria.then(function(criteria){$scope.criteria=criteria;});}else{$scope.criteria=[];}$scope.searchForCriteria=Criteria.buildCriteriaSearch(resourceTypes,5);};$scope.$on('refresh-types',function(){$scope.init();});$scope.rewriteQueryString=function(){var params={};angular.forEach(resourceTypes,function(resourceName){var resource=$injector.get(resourceName);angular.forEach($scope.criteria,function(){var criteriaMap=resource.criteriaMap($scope.criteria);angular.extend(params,criteriaMap);});});$location.search(params);};$scope.addCriteria=function(item){for(var i=$scope.criteria.length-1;i>=0;i--){var cItem=$scope.criteria[i];if(cItem===item){continue;}if(item.type===cItem.type&&item.type!=='Tags'){$scope.criteria.splice(i,1);}}$scope.rewriteQueryString();};$scope.removeCriteria=function(item){var idx=$scope.criteria.indexOf(item);if(idx>-1){$scope.criteria.splice(idx,1);}$scope.rewriteQueryString();};$scope.$watchCollection(function(){return $scope.criteria;},function(){$scope.hasSomeValidCriteria=false;resourceTypes.forEach(function(resourceName){var validCriteria=Criteria.filterCriteria(resourceName,$scope.criteria);if(validCriteria.length===$scope.criteria.length){$scope.hasSomeValidCriteria=true;}});});$scope.searchForCriteria=function(){var deferred=$q.defer();deferred.resolve([]);return deferred.promise;};});angular.module('sb.search').directive('searchResults',function($log,$parse,Criteria,$injector,Preference){'use strict';return{restrict:'A',scope:true,link:function link($scope,$element,args){var resourceName=args.searchResource;var pageSize=args.searchPageSize||Preference.get('page_size');var searchWithoutCriteria=args.searchWithoutCriteria==='true';var criteria=[];$scope.isSearching=false;$scope.searchResults=[];$scope.sortField='updated_at';$scope.sortDirection='desc';function handleErrorResult(){$scope.isSearching=false;}function handleSearchResult(results,headers){$scope.searchTotal=parseInt(headers('X-Total'))||results.length;$scope.searchOffset=parseInt(headers('X-Offset'))||0;$scope.searchLimit=parseInt(headers('X-Limit'))||0;$scope.searchResults=results;$scope.isSearching=false;}function updateResults(){$scope.validCriteria=Criteria.filterCriteria(resourceName,criteria);$scope.hasCriteria=criteria.length>0;$scope.hasValidCriteria=searchWithoutCriteria||$scope.validCriteria.length===criteria.length&&$scope.hasCriteria;if(!$scope.hasValidCriteria){$scope.searchResults=[];$scope.isSearching=false;return;}var params=Criteria.mapCriteria(resourceName,$scope.validCriteria);var resource=$injector.get(resourceName);if(!resource){$log.error('Invalid resource name: '+resourceName);return;}params.limit=pageSize;params.offset=$scope.searchOffset;$scope.isSearching=true;if(!params.hasOwnProperty('q')){params.sort_field=$scope.sortField;params.sort_dir=$scope.sortDirection;resource.browse(params,handleSearchResult,handleErrorResult);}else{resource.search(params,handleSearchResult,handleErrorResult);}}$scope.stories_sort_field='Sort Field';$scope.sort_stories_by_field=function(selected){$scope.stories_sort_field=selected.toString();var res=$scope.searchResults;switch(selected){case'Title':res.sort(function compare(a,b){if(a.title<b.title){return-1;}if(a.title>b.title){return 1;}return 0;});break;case'Tags':res.sort(function compare(a,b){if(a.tags<b.tags){return-1;}if(a.tags>b.tags){return 1;}return 0;});break;case'Status':res.sort(function compare(a,b){if(a.status<b.status){return-1;}if(a.status>b.status){return 1;}return 0;});break;case'Updated':res.sort(function compare(a,b){if(a.updated_at<b.updated_at){return-1;}if(a.updated_at>b.updated_at){return 1;}return 0;});break;}};$scope.tasks_sort_field='Sort Field';$scope.sort_tasks_by_field=function(selected){$scope.tasks_sort_field=selected.toString();var res=$scope.searchResults;switch(selected){case'Story':res.sort(function compare(a,b){if(a.story_id<b.story_id){return-1;}if(a.story_id>b.story_id){return 1;}return 0;});break;case'Status':res.sort(function compare(a,b){if(a.status<b.status){return-1;}if(a.status>b.status){return 1;}return 0;});break;case'Title':res.sort(function compare(a,b){if(a.title<b.title){return-1;}if(a.title>b.title){return 1;}return 0;});break;case'Project':res.sort(function compare(a,b){if(a.project_id<b.project_id){return-1;}if(a.project_id>b.project_id){return 1;}return 0;});break;case'Created at':res.sort(function compare(a,b){if(a.created_at<b.created_at){return-1;}if(a.created_at>b.created_at){return 1;}return 0;});break;case'Updated Since':res.sort(function compare(a,b){if(a.updated_at<b.updated_at){return-1;}if(a.updated_at>b.updated_at){return 1;}return 0;});break;}};$scope.updatePageSize=function(value){Preference.set('page_size',value).then(function(){pageSize=value;updateResults();});};$scope.toggleFilter=function(fieldName){if($scope.sortField===fieldName){$scope.sortDirection=$scope.sortDirection==='asc'?'desc':'asc';}else{$scope.sortField=fieldName;$scope.sortDirection='desc';}updateResults();};$scope.nextPage=function(){$scope.searchOffset+=pageSize;updateResults();};$scope.previousPage=function(){$scope.searchOffset-=pageSize;if($scope.searchOffset<0){$scope.searchOffset=0;}updateResults();};$scope.$watchCollection($parse(args.searchCriteria),function(results){criteria=results;updateResults();});}};});angular.module('sb.search').factory('SearchHelper',function(User,Project,ProjectGroup,Story,Task,Criteria,$filter,$q){'use strict';function parseParameters(params){var criteria=[];var promises=[];if(params.q){criteria.push(Criteria.create('Text',params.q));}if(params.title){criteria.push(Criteria.create('Text',params.title));}if(params.status){criteria.push(Criteria.create('StoryStatus',params.status,$filter('capitalize')(params.status)));}if(params.tags){if(params.tags.constructor===Array){angular.forEach(params.tags,function(tag){criteria.push(Criteria.create('Tags',tag,tag));});}else{criteria.push(Criteria.create('Tags',params.tags,params.tags));}}if(params.assignee_id||params.creator_id){var id=params.assignee_id||params.creator_id;var userPromise=User.get({'id':id}).$promise;promises.push(userPromise);userPromise.then(function(result){criteria.push(Criteria.create('User',params.assignee_id,result.full_name+' <'+result.email+'>'));});}if(params.project_id){var projectParams={'id':params.project_id};var projectPromise=Project.get(projectParams).$promise;promises.push(projectPromise);projectPromise.then(function(result){criteria.push(Criteria.create('Project',params.project_id,result.name));});}if(params.project_group_id){var groupParams={'id':params.project_group_id};var groupPromise=ProjectGroup.get(groupParams).$promise;promises.push(groupPromise);groupPromise.then(function(result){criteria.push(Criteria.create('ProjectGroup',params.project_group_id,result.title));});}if(params.story_id){var storyParams={'id':params.story_id};var storyPromise=Story.get(storyParams).$promise;promises.push(storyPromise);storyPromise.then(function(result){criteria.push(Criteria.create('Story',params.story_id,result.title));});}if(params.task_id){var taskParams={'id':params.task_id};var taskPromise=Task.get(taskParams).$promise;promises.push(taskPromise);taskPromise.then(function(result){criteria.push(Criteria.create('Task',params.task_id,result.title));});}var deferred=$q.defer();$q.all(promises).then(function(){deferred.resolve(criteria);});return deferred.promise;}return{parseParameters:parseParameters};});angular.module('sb.services').service('Criteria',function($q,$log,$injector,Preference){'use strict';return{filterCriteria:function filterCriteria(resourceName,criteria){var resource=$injector.get(resourceName);if(!resource||!resource.hasOwnProperty('criteriaFilter')){$log.warn('Attempting to filter criteria for unknown '+'resource "'+resourceName+'"');return[];}return resource.criteriaFilter(criteria);},mapCriteria:function mapCriteria(resourceName,criteria){var resource=$injector.get(resourceName);if(!resource||!resource.hasOwnProperty('criteriaMap')){$log.warn('Attempting to map criteria for unknown '+'resource "'+resourceName+'"');return{};}return resource.criteriaMap(criteria);},create:function create(type,value,title){title=title||value;return{'type':type,'value':value,'title':title};},buildCriteriaSearch:function buildCriteriaSearch(types,pageSize){pageSize=pageSize||Preference.get('page_size');var resolvers=[];types.forEach(function(type){var resource=$injector.get(type);if(!resource.hasOwnProperty('criteriaResolvers')){$log.warn('Resource type "'+type+'" does not implement criteriaResolvers.');return;}resource.criteriaResolvers().forEach(function(resolver){if(resolvers.indexOf(resolver)===-1){resolvers.push(resolver);}});});return function(searchString){var deferred=$q.defer();var promises=[];resolvers.forEach(function(resolver){promises.push(resolver(searchString,pageSize));});$q.all(promises).then(function(results){var criteria=[];results.forEach(function(result){result.forEach(function(item){criteria.push(item);});});deferred.resolve(criteria);});return deferred.promise;};},buildCriteriaFilter:function buildCriteriaFilter(parameterMap){return function(criteria){var filteredCriteria=[];criteria.forEach(function(item){if(parameterMap.hasOwnProperty(item.type)){filteredCriteria.push(item);}});return filteredCriteria;};},buildCriteriaMap:function buildCriteriaMap(parameterMap){return function(criteria){var params={};criteria.forEach(function(item){if(parameterMap.hasOwnProperty(item.type)){if(parameterMap[item.type]==='tags'){if(!('tags'in params)){params.tags=[item.value];}else{params.tags.push(item.value);}}else{params[parameterMap[item.type]]=item.value;}}});return params;};}};});angular.module('sb.services').factory('StoryStatus',function(Criteria,$q){'use strict';var validStatusCriteria=[Criteria.create('StoryStatus','active','Active'),Criteria.create('StoryStatus','merged','Merged'),Criteria.create('StoryStatus','invalid','Invalid')];return{criteriaResolver:function criteriaResolver(searchString){var deferred=$q.defer();searchString=searchString||'';searchString=searchString.toLowerCase();var criteria=[];validStatusCriteria.forEach(function(criteriaItem){var title=criteriaItem.title.toLowerCase();if(title.indexOf(searchString)>-1||'status'.indexOf(searchString)===0){criteria.push(criteriaItem);}});deferred.resolve(criteria);return deferred.promise;}};});angular.module('sb.services').factory('TaskPriority',function(Criteria,$q){'use strict';var validPriorityCriteria=[Criteria.create('TaskPriority','high','High'),Criteria.create('TaskPriority','medium','Medium'),Criteria.create('TaskPriority','low','Low')];return{criteriaResolver:function criteriaResolver(searchString){var deferred=$q.defer();searchString=searchString||'';searchString=searchString.toLowerCase();var criteria=[];validPriorityCriteria.forEach(function(criteriaItem){var title=criteriaItem.title.toLowerCase();if(title.indexOf(searchString)>-1||'priority'.indexOf(searchString)===0){criteria.push(criteriaItem);}});deferred.resolve(criteria);return deferred.promise;}};});angular.module('sb.services').factory('Text',function(Criteria,$q){'use strict';return{criteriaResolver:function criteriaResolver(searchString){var deferred=$q.defer();deferred.resolve([Criteria.create('Text',searchString)]);return deferred.promise;}};});angular.module('sb.services').directive('calendar',function(moment){'use strict';return{restrict:'E',templateUrl:'app/services/template/calendar.html',scope:{selectedDate:'='},link:function link(scope){function buildWeek(date){var days=[];for(var i=0;i<7;i++){days.push({name:date.format('dd').substring(0,1),number:date.date(),isToday:date.isSame(new Date(),'day'),isCurrentMonth:date.month()===scope.month.month(),isSelected:date.isSame(scope.selectedDate,'day'),date:date});date=date.clone();date.add(1,'d');}return days;}function buildMonth(start){scope.weeks=[];var date=start.clone();var monthIndex=date.month();var done=false;var count=0;date.date(1).isoWeekday(1);while(!done){scope.weeks.push({days:buildWeek(date.clone())});date.add(1,'w');monthIndex=date.month();done=count++>2&&monthIndex!==start.month();}}scope.select=function(day){scope.selectedDate=day.date;if(scope.selectedDate.isBefore(scope.month,'month')){scope.previous();}else if(scope.selectedDate.isAfter(scope.month,'month')){scope.next();}buildMonth(scope.selectedDate.clone());};scope.previous=function(){var start=scope.month.clone();start.subtract(1,'month');scope.month.subtract(1,'month');buildMonth(start);};scope.next=function(){var start=scope.month.clone();start.add(1,'month');scope.month.add(1,'month');buildMonth(start);};scope.incrementTime=function(unit){scope.selectedDate.add(1,unit);if(!scope.selectedDate.isSame(scope.month,'month')){scope.next();}buildMonth(scope.selectedDate.clone());};scope.decrementTime=function(unit){scope.selectedDate.subtract(1,unit);if(!scope.selectedDate.isSame(scope.month,'month')){scope.previous();}buildMonth(scope.selectedDate.clone());};scope.toggleEdit=function(unit){if(unit==='hour'){if(scope.editHour){scope.selectedDate.hour(scope.editedHour);}else{scope.editedHour=scope.selectedDate.hour();}scope.editHour=!scope.editHour;}else if(unit==='minute'){if(scope.editMinute){scope.selectedDate.minute(scope.editedMinute);}else{scope.editedMinute=scope.selectedDate.minute();}scope.editMinute=!scope.editMinute;}};scope.selectedDate=moment(scope.selectedDate)||moment();scope.month=scope.selectedDate.clone();buildMonth(scope.selectedDate.clone());}};});angular.module('sb.services').directive('insertMarkdown',function($sanitize,$window){'use strict';var md=$window.markdownit({breaks:true,html:true,highlight:function highlight(code,lang){if(lang&&$window.hljs.getLanguage(lang)){return $window.hljs.highlight(lang,code,true).value;}return'';},linkify:true});return{restrict:'E',scope:{content:'='},link:function link(scope,elem){scope.$watch('content',function(newVal){var html=md.render(newVal);elem.html('<div>'+$sanitize(html)+'</div>');},true);}};});angular.module('sb.services').directive('resultSetPager',function(){'use strict';return{restrict:'E',templateUrl:'app/services/template/result_set_pager.html',scope:{total:'=',offset:'=',limit:'=',listType:'=',minimalPager:'=',pageSize:'&onPageSize',nextPage:'&onNextPage',previousPage:'&onPreviousPage'}};});angular.module('sb.services').factory('httpCacheHandler',function($q,$cacheFactory){'use strict';var $httpDefaultCache=$cacheFactory.get('$http');return{response:function response(_response){var method=_response.config.method;var url=_response.config.url;var obj=_response.data;switch(method){case'POST':if(obj.hasOwnProperty('id')){$httpDefaultCache.put(url+'/'+obj.id,obj);}break;case'PUT':$httpDefaultCache.put(url,obj);break;case'DELETE':$httpDefaultCache.remove(url);break;default:break;}return _response;}};}).config(function($httpProvider){'use strict';$httpProvider.interceptors.push('httpCacheHandler');});angular.module('sb.services').factory('httpErrorBroadcaster',function($q,$rootScope,Notification,Severity){'use strict';function sendEvent(severity,response){if(!!response.status){Notification.send('http',response.status,severity,response);}}return{response:function response(_response2){if(!!_response2){sendEvent(Severity.SUCCESS,_response2);}return _response2;},responseError:function responseError(response){if(!!response){sendEvent(Severity.ERROR,response);}return $q.reject(response);}};}).config(function($httpProvider){'use strict';$httpProvider.interceptors.unshift('httpErrorBroadcaster');});angular.module('sb.services').run(function(Notification,Priority){'use strict';function filterTemplateRequests(message){if(message.type!=='http'){return false;}var request=message.cause;var url=request.config.url;if(url.substr(-5)==='.html'){return true;}}function filterSuccessful(message){var response=message.cause;if(message.type!=='http'||!response){return false;}var successful_requests=[200,201,202,203,204,205,206,207,208,226];if(successful_requests.indexOf(response.status)>=0){return true;}}function rewriteHttpStatus(message){if(message.type!=='http'){return;}var httpStatus=message.message;var request=message.cause;if(!httpStatus||!request||!request.data){return;}var data=request.data;var method=request.config.method;var url=request.config.url;message.message=httpStatus+': '+method+' '+url+': ';if(data.hasOwnProperty('faultstring')){message.message+=data.faultstring;}else if(data.hasOwnProperty('field')&&data.hasOwnProperty('message')){message.message+=data.field+': '+data.message;}else{message.message+='No error details available.';}}Notification.intercept(filterTemplateRequests,Priority.BEFORE);Notification.intercept(filterSuccessful,Priority.LAST);Notification.intercept(rewriteHttpStatus,Priority.AFTER);});angular.module('sb.services').provider('Preference',function(){'use strict';var preferenceInstance=null;var defaults={};this.addPreference=function(name,defaultValue){defaults[name]=defaultValue;};function Preference($q,$log,Session,AccessToken,UserPreference,SessionState){var preferences={};this.resolveUserPreferences=function(){var deferred=$q.defer();var sessionPromise=Session.resolveSessionState();sessionPromise.then(function(state){if(state===SessionState.LOGGED_IN){UserPreference.get({id:AccessToken.getIdToken()},function(prefs){deferred.resolve(prefs);},function(){deferred.resolve(defaults);});}else{deferred.resolve(defaults);}},function(){deferred.resolve(defaults);});return deferred.promise;};this.getAll=function(){var result={};for(var def_key in defaults){result[def_key]=this.get(def_key);}for(var key in preferences){result[key]=preferences[key];}return result;};this.saveAll=function(newPrefs){for(var key in defaults){if(preferences.hasOwnProperty(key)){if(preferences[key]!==newPrefs[key]){$log.debug('Preference Change: '+key+' -> '+newPrefs[key]);preferences[key]=newPrefs[key];}}}return this.save();};this.get=function(key){if(!defaults.hasOwnProperty(key)){$log.warn('Attempt to get unregistered preference: '+key);return null;}if(!preferences.hasOwnProperty(key)){$log.warn('Setting default preference: ',key,defaults[key]);this.set(key,defaults[key],true);}return preferences[key];};this.set=function(key,value,isDefault){if(!defaults.hasOwnProperty(key)){$log.warn('Attempt to set unregistered preference: '+key);return null;}preferences[key]=value;return this.save(isDefault);};this.refresh=function(){var deferred=$q.defer();this.resolveUserPreferences().then(function(newPrefs){preferences=newPrefs;deferred.resolve(preferences);});return deferred.promise;};this.save=function(isDefault){var deferred=$q.defer();if(isDefault){deferred.resolve();}else if(!preferences.$save){deferred.resolve();}else{preferences.$save({id:AccessToken.getIdToken()},function(){deferred.resolve();},function(){deferred.resolve();});}return deferred.promise;};}this.$get=function($injector){if(!preferenceInstance){preferenceInstance=$injector.instantiate(Preference);}return preferenceInstance;};}).config(function(PreferenceProvider){'use strict';PreferenceProvider.addPreference('page_size',10);PreferenceProvider.addPreference('story_detail_page_size',10);PreferenceProvider.addPreference('project_group_detail_projects_page_size',10);PreferenceProvider.addPreference('project_group_detail_stories_page_size',10);PreferenceProvider.addPreference('project_detail_page_size',10);PreferenceProvider.addPreference('plugin_email_enable','false');PreferenceProvider.addPreference('receive_notifications_worklists',false);});angular.module('sb.services').constant('storyboardApiBase','/api/v1');angular.module('sb.services').constant('PreferenceResolver',{resolvePreferences:function resolvePreferences(Preference){'use strict';return Preference.refresh();}});angular.module('sb.services').factory('Board',function(ResourceFactory,Worklist,$resource,storyboardApiBase){'use strict';var resource=ResourceFactory.build('/boards/:id','/boards/search',{id:'@id'},false,true);var permissionsSignature={'create':{method:'POST'},'get':{method:'GET',cache:false,isArray:true},'update':{method:'PUT'}};resource.Permissions=$resource(storyboardApiBase+'/boards/:id/permissions',{id:'@id'},permissionsSignature);ResourceFactory.applySearch('Board',resource,'title',{Text:'title',Story:'story_id',Task:'task_id',User:'creator_id'});return resource;});angular.module('sb.services').factory('Branch',function(ResourceFactory){'use strict';var resource=ResourceFactory.build('/branches/:id','/branches/search',{id:'@id'});ResourceFactory.applySearch('Branch',resource,'name',{Text:'q',Project:'project_id'});return resource;});angular.module('sb.services').factory('Comment',function(ResourceFactory,$resource,storyboardApiBase){'use strict';var resource=ResourceFactory.build('/stories/:story_id/comments/:id','/stories/0/search',{id:'@id',story_id:'@story_id'});var historySignature={'get':{method:'GET',isArray:true}};resource.History=$resource(storyboardApiBase+'/stories/:story_id/comments/:id/history',{id:'@id',story_id:'@story_id'},historySignature);return resource;});angular.module('sb.services').factory('DueDate',function(ResourceFactory,$resource,storyboardApiBase){'use strict';var resource=ResourceFactory.build('/due_dates/:id','/due_dates/search',{id:'@id'},false,true);var permissionsSignature={'create':{method:'POST'},'get':{method:'GET',cache:false,isArray:true},'update':{method:'PUT'}};resource.Permissions=$resource(storyboardApiBase+'/due_dates/:id/permissions',{id:'@id'},permissionsSignature);ResourceFactory.applySearch('DueDate',resource,'name',{Text:'q',User:'owner',Board:'board_id',Worklist:'worklist_id'});return resource;});angular.module('sb.services').factory('Project',function(ResourceFactory){'use strict';var resource=ResourceFactory.build('/projects/:id','/projects/search',{id:'@id'});ResourceFactory.applySearch('Project',resource,'name',{Text:'q'});return resource;});angular.module('sb.services').factory('ProjectGroup',function(ResourceFactory){'use strict';var resource=ResourceFactory.build('/project_groups/:id','/project_groups/search',{id:'@id'});ResourceFactory.applySearch('ProjectGroup',resource,'title',{Text:'title'});return resource;});angular.module('sb.services').factory('ProjectGroupItem',function($resource,storyboardApiBase){'use strict';return $resource(storyboardApiBase+'/project_groups/:projectGroupId/projects/:id',{projectGroupId:'@projectGroupId',id:'@id'},{'create':{method:'PUT',transformRequest:function transformRequest(){return'';}},'delete':{method:'DELETE'},'query':{method:'GET',isArray:true,responseType:'json'},'browse':{method:'GET',isArray:true,responseType:'json',cache:false}});});angular.module('sb.services').factory('Search',function($q,$log,Project,Story,User,Criteria){'use strict';return{project:function project(searchString){var deferred=$q.defer();Project.search({q:searchString},function(result){var projResults=[];result.forEach(function(item){projResults.push(Criteria.create('project',item.id,item.name));});deferred.resolve(projResults);},function(){deferred.resolve([]);});return deferred.promise;},user:function user(searchString){var deferred=$q.defer();User.search({q:searchString},function(result){var userResults=[];result.forEach(function(item){userResults.push(Criteria.create('user',item.id,item.full_name,item.email));});deferred.resolve(userResults);},function(){deferred.resolve([]);});return deferred.promise;},story:function story(searchString){var deferred=$q.defer();Story.search({q:searchString},function(result){var storyResults=[];result.forEach(function(item){storyResults.push(Criteria.create('story',item.id,item.title));});deferred.resolve(storyResults);},function(){deferred.resolve([]);});return deferred.promise;},all:function all(searchString){var deferred=$q.defer();var criteria=[];$q.all({projects:this.project(searchString),stories:this.story(searchString),users:this.user(searchString)}).then(function(results){results.projects.forEach(function(item){criteria.push(item);});results.stories.forEach(function(item){criteria.push(item);});results.users.forEach(function(item){criteria.push(item);});deferred.resolve(criteria);});return deferred.promise;}};});angular.module('sb.services').factory('Story',function(ResourceFactory,$resource,storyboardApiBase){'use strict';var resource=ResourceFactory.build('/stories/:id','/stories/search',{id:'@id'});var tags_signature={'update':{method:'PUT',transformRequest:function transformRequest(){return'';}},'delete':{method:'DELETE',transformRequest:function transformRequest(){return'';}}};var actorSignature={'create':{method:'PUT'},'get':{method:'GET',isArray:true},'delete':{method:'DELETE',transformRequest:function transformRequest(){return'';}}};resource.TagsController=$resource(storyboardApiBase+'/stories/:id/tags',{id:'@id'},tags_signature);resource.UsersController=$resource(storyboardApiBase+'/stories/:story_id/users',{story_id:'@story_id'},actorSignature);resource.TeamsController=$resource(storyboardApiBase+'/stories/:story_id/teams',{story_id:'@story_id'},actorSignature);ResourceFactory.applySearch('Story',resource,'title',{Text:'q',StoryStatus:'status',Tags:'tags',ProjectGroup:'project_group_id',Project:'project_id',User:'assignee_id'});return resource;});angular.module('sb.services').factory('Subscription',function(ResourceFactory){'use strict';return ResourceFactory.build('/subscriptions/:id','/subscriptions/search',{id:'@id'});});angular.module('sb.services').factory('SubscriptionEvent',function(ResourceFactory){'use strict';return ResourceFactory.build('/subscription_events/:id','/subscription_events/search',{id:'@id'});});angular.module('sb.services').factory('SubscriptionList',function(Session,Subscription){'use strict';return{subsList:function subsList(resource,user){if(!Session.isLoggedIn()){return null;}else{return Subscription.browse({user_id:user.id,target_type:resource});}}};});angular.module('sb.services').factory('SystemInfo',function($resource,storyboardApiBase){'use strict';return $resource(storyboardApiBase+'/systeminfo',{},{'get':{method:'GET',cache:true}});});angular.module('sb.services').factory('Tags',function(ResourceFactory){'use strict';var resource=ResourceFactory.build('/tags/:id','/tags/search',{id:'@id'});ResourceFactory.applySearch('Tags',resource,'name',{},true);return resource;});angular.module('sb.services').factory('Task',function(ResourceFactory){'use strict';var resource=ResourceFactory.build('/tasks/:id','/tasks/search',{id:'@id'});ResourceFactory.applySearch('Task',resource,'title',{Text:'q',TaskStatus:'status',TaskPriority:'priority',Story:'story_id',User:'assignee_id',Project:'project_id',ProjectGroup:'project_group_id'});return resource;});angular.module('sb.services').factory('TaskStatus',function(ResourceFactory){'use strict';var resource=ResourceFactory.build('/task_statuses/:id','/task_statuses/search',{id:'@id'},true);ResourceFactory.applySearch('TaskStatus',resource,'name',{Text:'q'});return resource;});angular.module('sb.services').factory('Team',function(ResourceFactory,$resource,storyboardApiBase){'use strict';var resource=ResourceFactory.build('/teams/:team_id','/teams/search',{team_id:'@id'});var subresourceSignature={'create':{method:'PUT'},'get':{method:'GET',isArray:true},'delete':{method:'DELETE',transformRequest:function transformRequest(){return'';}}};resource.UsersController=$resource(storyboardApiBase+'/teams/:team_id/users',{team_id:'@team_id'},subresourceSignature);resource.ProjectsController=$resource(storyboardApiBase+'/teams/:team_id/projects',{team_id:'@team_id'},subresourceSignature);return resource;});angular.module('sb.services').factory('TimelineEvent',function(ResourceFactory){'use strict';return ResourceFactory.build('/stories/:story_id/events/:id','/stories/:story_id/events/search',{id:'@id',story_id:'@story_id'});});angular.module('sb.services').factory('User',function(ResourceFactory,$resource,DSCacheFactory,storyboardApiBase){'use strict';var signature={'create':{method:'POST'},'get':{method:'GET'},'update':{method:'PUT',interceptor:{response:function response(_response3){var user=_response3.resource;DSCacheFactory.get('defaultCache').put(storyboardApiBase+'/users/'+user.id,user);}}},'delete':{method:'DELETE'},'browse':{method:'GET',isArray:true,responseType:'json',cache:false},'search':{method:'GET',url:storyboardApiBase+'/users/search',isArray:true,responseType:'json',cache:false}};var resource=$resource(storyboardApiBase+'/users/:id',{id:'@id'},signature);ResourceFactory.applySearch('User',resource,'full_name',{Text:'q'});return resource;});angular.module('sb.services').factory('UserPreference',function($resource,storyboardApiBase){'use strict';return $resource(storyboardApiBase+'/users/:id/preferences',{id:'@id'},{'get':{method:'GET',cache:true}});});angular.module('sb.services').factory('UserToken',function(ResourceFactory){'use strict';var resource=ResourceFactory.build('/users/:user_id/tokens/:id',null,{user_id:'@user_id',id:'@id'});return resource;});angular.module('sb.services').factory('Worklist',function(ResourceFactory,$resource,storyboardApiBase){'use strict';var resource=ResourceFactory.build('/worklists/:id','/worklists/search',{id:'@id'},false,true);var items_signature={'create':{method:'POST'},'get':{method:'GET',cache:false,isArray:true},'update':{method:'PUT'},'delete':{method:'DELETE',transformRequest:function transformRequest(){return'';}}};resource.ItemsController=$resource(storyboardApiBase+'/worklists/:id/items/:item_id',{id:'@id',item_id:'@item_id'},items_signature);var permissionsSignature={'create':{method:'POST'},'get':{method:'GET',cache:false,isArray:true},'update':{method:'PUT'}};resource.Permissions=$resource(storyboardApiBase+'/worklists/:id/permissions',{id:'@id'},permissionsSignature);var filtersSignature={'create':{method:'POST'},'get':{method:'GET',cache:false,isArray:true},'update':{method:'PUT'},'delete':{method:'DELETE',transformRequest:function transformRequest(){return'';}}};resource.Filters=$resource(storyboardApiBase+'/worklists/:id/filters/:filter_id',{id:'@id'},filtersSignature);ResourceFactory.applySearch('Worklist',resource,'title',{Text:'title',Story:'story_id',Task:'task_id',User:'creator_id'});return resource;});angular.module('sb.services').service('ResourceFactory',function($q,$log,$injector,Criteria,$resource,storyboardApiBase,Preference){'use strict';function buildSignature(searchUrl,cacheSearchResults,disableCachedGets){cacheSearchResults=!!cacheSearchResults;disableCachedGets=!!disableCachedGets;return{'create':{method:'POST'},'get':{method:'GET',cache:!disableCachedGets},'update':{method:'PUT'},'delete':{method:'DELETE'},'browse':{method:'GET',isArray:true,responseType:'json',cache:cacheSearchResults},'search':{method:'GET',url:searchUrl,isArray:true,responseType:'json',cache:cacheSearchResults}};}return{build:function build(restUri,searchUri,resourceParameters,cacheSearchResults,disableCachedGets){if(!restUri){$log.error('Cannot use resource factory '+'without a base REST uri.');return null;}cacheSearchResults=!!cacheSearchResults;var signature=buildSignature(storyboardApiBase+searchUri,cacheSearchResults,disableCachedGets);return $resource(storyboardApiBase+restUri,resourceParameters,signature);},applySearch:function applySearch(resourceName,resource,nameField,searchParameters,useNameField){var criteriaResolvers=[];for(var type in searchParameters){var typeResource=$injector.get(type);if(!!typeResource&&typeResource.hasOwnProperty('criteriaResolver')){criteriaResolvers.push(typeResource.criteriaResolver);}}resource.criteriaResolvers=function(){return criteriaResolvers;};if(!!nameField){resource.criteriaResolver=function(searchString,pageSize){pageSize=pageSize||Preference.get('page_size');var deferred=$q.defer();var queryParams={};queryParams[nameField]=searchString;queryParams.limit=pageSize;resource.browse(queryParams,function(result){var criteriaResults=[];result.forEach(function(item){if(useNameField){criteriaResults.push(Criteria.create(resourceName,item[nameField],item[nameField]));}else if(item.hasOwnProperty('id')){criteriaResults.push(Criteria.create(resourceName,item.id,item[nameField]));}else{criteriaResults.push(Criteria.create(resourceName,item.key,item[nameField]));}});deferred.resolve(criteriaResults);},function(){deferred.resolve([]);});return deferred.promise;};}resource.criteriaFilter=Criteria.buildCriteriaFilter(searchParameters);resource.criteriaMap=Criteria.buildCriteriaMap(searchParameters);}};});angular.module('sb.story').controller('CommentHistoryController',function($scope,$modalInstance,history,comment){'use strict';$scope.history=history;$scope.comment=comment;});angular.module('sb.story').controller('StoryDeleteController',function($log,$scope,$state,story,$modalInstance){'use strict';$scope.story=story;$scope.isUpdating=true;$scope.error={};$scope.remove=function(){$scope.story.$delete(function(){$modalInstance.dismiss('success');$state.go('sb.project.list');});};$scope.close=function(){$modalInstance.dismiss('cancel');};});angular.module('sb.story').controller('StoryDetailController',function($log,$rootScope,$scope,$state,$stateParams,$modal,Session,Preference,TimelineEvent,Comment,TimelineEventTypes,story,Story,Project,Branch,creator,tasks,Task,DSCacheFactory,User,$q,storyboardApiBase,SessionModalService,moment,$document,$anchorScroll,$timeout,$location,currentUser,enableEditableComments,Tags,worklists,Team,StoryHelper){'use strict';var pageSize=Preference.get('story_detail_page_size');var firstLoad=true;$scope.enableEditableComments=enableEditableComments;$anchorScroll.yOffset=50;$scope.filterMode='advanced';$scope.story=story;$scope.creator=creator;$scope.projectNames=[];$scope.projects={};$scope.tasks=tasks;$scope.tasks_sort_field={label:'Id',value:'id'};$scope.changeOrder=function(orderBy){$scope.tasks_sort_field.label=orderBy.toString();switch(orderBy){case'Id':$scope.tasks_sort_field.value='id';break;case'Status':$scope.tasks_sort_field.value='status';break;case'Title':$scope.tasks_sort_field.value='title';break;}};function mapTaskToProject(task){Project.get({id:task.project_id}).$promise.then(function(project){var idx=$scope.projectNames.indexOf(project.name);if(idx<0){$scope.projectNames.push(project.name);$scope.projects[project.name]=project;$scope.projects[project.name].branchNames=[];$scope.projects[project.name].branches={};}Branch.get({id:task.branch_id}).$promise.then(function(branch){var branchIdx=$scope.projects[project.name].branchNames.indexOf(branch.name);if(branchIdx>-1){$scope.projects[project.name].branches[branch.name].tasks.push(task);}else{$scope.projects[project.name].branches[branch.name]=branch;$scope.projects[project.name].branches[branch.name].tasks=[task];$scope.projects[project.name].branches[branch.name].newTask=new Task({story_id:$scope.story.id,branch_id:branch.id,project_id:project.id,status:'todo'});$scope.projects[project.name].branchNames.push(branch.name);}});});}angular.forEach(tasks,mapTaskToProject);function setWorklists(){function isNotArchived(card){return!card.archived;}var taskIds=$scope.tasks.map(function(task){return task.id;});for(var i=0;i<worklists.length;i++){var worklist=worklists[i];worklist.relatedItems=[];worklist.items=worklist.items.filter(isNotArchived);for(var j=0;j<worklist.items.length;j++){var item=worklist.items[j];if(item.item_type==='story'){if(item.item_id===story.id){worklist.relatedItems.push(item);}}else if(item.item_type==='task'){if(taskIds.indexOf(item.item_id)>-1){worklist.relatedItems.push(item);}}}}$scope.worklists=worklists.map(function(list){if(list.relatedItems.length>0){return list;}}).filter(function(list){return list;});}setWorklists();$scope.showWorklistsModal=function(){var modalInstance=$modal.open({templateUrl:'app/stories/template/worklists.html',backdrop:'static',controller:'StoryWorklistsController',resolve:{worklists:function worklists(){return $scope.worklists;}}});return modalInstance.result;};function reloadPagePreferences(){TimelineEventTypes.forEach(function(type){var pref_name='display_events_'+type;$scope[pref_name]=Preference.get(pref_name)==='true';});pageSize=Preference.get('story_detail_page_size');$scope.loadEvents();}$scope.filterComments=function(){$scope.filterMode='comments';angular.forEach(TimelineEventTypes,function(type){var pref_name='display_events_'+type;$scope[pref_name]=false;});$scope.display_events_user_comment=true;$scope.display_events_story_created=true;$scope.loadEvents();};$scope.filterAll=function(){$scope.filterMode='all';angular.forEach(TimelineEventTypes,function(type){var pref_name='display_events_'+type;$scope[pref_name]=true;});$scope.loadEvents();};$scope.isSearching=false;$scope.loadEvents=function(){$scope.isSearching=true;var params={};params.sort_field='id';params.sort_dir='asc';params.story_id=$scope.story.id;params.event_type=TimelineEventTypes.map(function(type){var pref_name='display_events_'+type;if($scope[pref_name]){return type;}}).filter(function(item){return item;});TimelineEvent.browse(params,function(result){var eventResults=[];result.forEach(function(item){item.author=User.get({id:item.author_id});item.event_info=JSON.parse(item.event_info);eventResults.push(item);});$scope.events=eventResults;$scope.isSearching=false;if(firstLoad){firstLoad=false;$timeout(function(){$anchorScroll();},0);}},function(){$scope.isSearching=false;});};reloadPagePreferences();$scope.nextPage=function(){$scope.searchOffset+=pageSize;$scope.loadEvents();};$scope.previousPage=function(){$scope.searchOffset-=pageSize;if($scope.searchOffset<0){$scope.searchOffset=0;}$scope.loadEvents();};$scope.updatePageSize=function(value){Preference.set('story_detail_page_size',value).then(function(){pageSize=value;$scope.loadEvents();});};$scope.newComment=new Comment({});function handleServiceError(error){$scope.error=error;$scope.isLoading=false;$scope.isUpdating=false;}function handleServiceSuccess(){$scope.isLoading=false;$scope.isUpdating=false;}$scope.toggleEditMode=function(){if(Session.isLoggedIn()){$scope.showEditForm=!$scope.showEditForm;setTimeout(function(){$rootScope.$broadcast('elastic:adjust');},1);}else{$scope.showEditForm=false;}};$scope.showEditForm=false;$scope.isLoading=true;$scope.isUpdating=false;$scope.isSavingComment=false;$scope.error={};$scope.update=function(){$scope.isUpdating=true;$scope.error={};$scope.story.$update(function(){$scope.showEditForm=false;$scope.previewStory=false;handleServiceSuccess();},handleServiceError);};$scope.cancel=function(){$scope.showEditForm=false;};$scope.privacyLocked=false;$scope.updateSecurity=function(forcePrivate,update){$scope.privacyLocked=StoryHelper.updateSecurity(forcePrivate,update,$scope.story,$scope.tasks);};$scope.remove=function(){var modalInstance=$modal.open({templateUrl:'app/stories/template/delete.html',backdrop:'static',controller:'StoryDeleteController',resolve:{story:function story(){return $scope.story;}}});return modalInstance.result;};$scope.updateFilter=function(){var modalInstance=$modal.open({templateUrl:'app/stories/template/update_filter.html',backdrop:'static',controller:'TimelineFilterController'});$scope.filterMode='advanced';modalInstance.result.then(reloadPagePreferences);$scope.searchLimit=Preference.get('story_detail_page_size');};$scope.previewingComment=false;$scope.togglePreview=function(val){$scope.previewingComment=!$scope.previewingComment;if(val===true||val===false){$scope.previewingComment=val;}};$scope.quote=function(event){var timestamp=moment(event.created_at);var reference='<footer>'+event.author.full_name+' on '+timestamp.format('YYYY-MM-DD [at] HH:mm:ss')+'</footer>';var lines=event.comment.content.split('\n');for(var i=0;i<lines.length;i++){lines[i]='> '+lines[i];}lines.push('> '+reference);var quoted=lines.join('\n');if($scope.newComment.content){$scope.newComment.content+='\n\n'+quoted;}else{$scope.newComment.content=quoted;}$document[0].getElementById('comment').focus();};$scope.isLinked=function(event){if($location.hash()==='comment-'+event.comment.id){return true;}return false;};$scope.isAuthor=function(event){if(currentUser.id===event.author_id){return true;}return false;};$scope.addComment=function(){function resetSavingFlag(){$scope.isSavingComment=false;}if(!$scope.newComment.content){$log.warn('No content in comment, discarding submission');return;}$scope.isSavingComment=true;$scope.togglePreview(false);$scope.newComment.$create({story_id:$scope.story.id},function(){$scope.newComment=new Comment({});resetSavingFlag();$scope.loadEvents();});};$scope.edit=function(event){event.editing=true;event.comment.edited=angular.copy(event.comment.content);};$scope.editComment=function(event){event.isUpdating=true;Comment.update({id:story.id,comment_id:event.comment.id,content:event.comment.edited},function(result){event.comment.content=result.content;event.isUpdating=false;event.editing=false;},function(){event.isUpdating=false;event.editing=false;});};$scope.showHistory=function(event){var modalInstance=$modal.open({size:'lg',templateUrl:'app/stories/template/comments/history.html',backdrop:'static',controller:'CommentHistoryController',resolve:{history:function history(){if(event.comment&&event.comment.updated_at){return Comment.History.get({story_id:story.id,id:event.comment.id});}return[];},comment:function comment(){return event.comment;}}});return modalInstance.result;};$scope.showLoginRequiredModal=function(){SessionModalService.showLoginRequiredModal();};$scope.searchActors=function(value,users,teams){var userIds=users.map(function(user){return user.id;});var teamIds=teams.map(function(team){return team.id;});var deferred=$q.defer();var usersDeferred=$q.defer();var teamsDeferred=$q.defer();User.browse({full_name:value,limit:10},function(searchResults){var results=[];angular.forEach(searchResults,function(result){if(userIds.indexOf(result.id)===-1){result.name=result.full_name;result.type='user';results.push(result);}});usersDeferred.resolve(results);});Team.browse({name:value,limit:10},function(searchResults){var results=[];angular.forEach(searchResults,function(result){if(teamIds.indexOf(result.id)===-1){result.type='team';results.push(result);}});teamsDeferred.resolve(results);});var searches=[teamsDeferred.promise,usersDeferred.promise];$q.all(searches).then(function(searchResults){var results=[];angular.forEach(searchResults,function(promise){angular.forEach(promise,function(result){results.push(result);});});deferred.resolve(results);});return deferred.promise;};$scope.addActor=function(model){if(model.type==='user'){$scope.story.users.push(model);}else if(model.type==='team'){$scope.story.teams.push(model);}};$scope.removeUser=function(model){var idx=$scope.story.users.indexOf(model);$scope.story.users.splice(idx,1);};$scope.removeTeam=function(model){var idx=$scope.story.teams.indexOf(model);$scope.story.teams.splice(idx,1);};$scope.newTask=new Task({story_id:$scope.story.id,status:'todo'});$scope.createTask=function(task,branch){var savingTask=new Task(angular.copy(task));savingTask.$save(function(savedTask){$scope.tasks.push(savedTask);if(branch){branch.tasks.push(savedTask);}else{mapTaskToProject(savedTask);$scope.updateSecurity(false,true);}$scope.loadEvents();task.title='';});};function cleanBranchAndProject(projectName,branchName){var project=$scope.projects[projectName];var branch=project.branches[branchName];var nameIdx=-1;if(branch.tasks.length===0){nameIdx=project.branchNames.indexOf(branchName);if(nameIdx>-1){project.branchNames.splice(nameIdx,1);}delete project.branches[branchName];}if(project.branchNames.length===0){nameIdx=$scope.projectNames.indexOf(projectName);if(nameIdx>-1){$scope.projectNames.splice(nameIdx,1);}delete $scope.projects[projectName];}}$scope.updateTask=function(task,fieldName,value,projectName,branchName){var params={id:task.id};params[fieldName]=value;task[fieldName]=value;if(!!task.id){Task.update(params,function(){$scope.showTaskEditForm=false;$scope.loadEvents();}).$promise.then(function(updated){if(fieldName==='project_id'){var project=$scope.projects[projectName];var branch=project.branches[branchName];var branchTaskIndex=branch.tasks.indexOf(task);if(branchTaskIndex>-1){branch.tasks.splice(branchTaskIndex,1);}cleanBranchAndProject(projectName,branchName);mapTaskToProject(updated);$scope.updateSecurity(false,true);}});}};$scope.editNotes=function(task){task.tempNotes=task.link;task.editing=true;};$scope.cancelEditNotes=function(task){task.tempNotes='';task.editing=false;};$scope.showAddWorklist=function(_task){$modal.open({templateUrl:'app/stories/template/add_task_to_worklist.html',backdrop:'static',controller:'StoryTaskAddWorklistController',resolve:{task:function task(){return _task;}}});};$scope.removeTask=function(_task2,projectName,branchName){var modalInstance=$modal.open({templateUrl:'app/stories/template/delete_task.html',backdrop:'static',controller:'StoryTaskDeleteController',resolve:{task:function task(){return _task2;},params:function params(){return{lastTask:$scope.tasks.length===1};}}});modalInstance.result.then(function(){var taskIndex=$scope.tasks.indexOf(_task2);if(taskIndex>-1){$scope.tasks.splice(taskIndex,1);}var project=$scope.projects[projectName];var branch=project.branches[branchName];var branchTaskIndex=branch.tasks.indexOf(_task2);if(branchTaskIndex>-1){branch.tasks.splice(branchTaskIndex,1);}cleanBranchAndProject(projectName,branchName);$scope.loadEvents();});};$scope.TagsController=new Story.TagsController({'id':story.id});$scope.showAddTag=false;$scope.toggleAddTag=function(){$scope.newTag.name=null;$scope.showAddTag=!$scope.showAddTag;};$scope.addTag=function(tag_name){if(!!tag_name){$scope.TagsController.$update({tags:[tag_name]},function(updatedStory){DSCacheFactory.get('defaultCache').put(storyboardApiBase+'/stories/'+story.id,updatedStory);$scope.story.tags.push(tag_name);$scope.loadEvents();},handleServiceError);$scope.newTag.name=null;}};$scope.removeTag=function(tag_name){$scope.TagsController.$delete({tags:[tag_name]},function(){var tagIndex=$scope.story.tags.indexOf(tag_name);DSCacheFactory.get('defaultCache').remove(storyboardApiBase+'/stories/'+story.id);if(tagIndex>-1){$scope.story.tags.splice(tagIndex,1);}$scope.loadEvents();},handleServiceError);};$scope.searchTags=function(value){return Tags.browse({name:value,limit:10}).$promise;};$scope.updateViewValue=function(value){$scope.newTag.name=value;};$scope.newTag={};});angular.module('sb.story').controller('StoryListController',function($scope,$state,Criteria,NewStoryService,SubscriptionList,CurrentUser,$stateParams,SearchHelper){'use strict';$scope.resourceTypes=['Story'];$scope.defaultCriteria=SearchHelper.parseParameters($stateParams);$scope.newStory=function(){NewStoryService.showNewStoryModal().then(function(story){$state.go('sb.story.detail',{storyId:story.id});});};var cuPromise=CurrentUser.resolve();cuPromise.then(function(user){$scope.storySubscriptions=SubscriptionList.subsList('story',user);});});angular.module('sb.story').controller('StoryListItemController',function($scope,TaskStatus){'use strict';function getStatusClass(status){var className='';switch(status){case'inprogress':className='text-info';break;case'review':className='text-warning';break;case'merged':className='text-success';break;case'invalid':className='muted';break;default:className='';break;}return className;}$scope.expandRow=false;$scope.status_texts=[];$scope.status_classes=[];TaskStatus.query({},function(items){for(var i=0;i<items.length;i++){$scope.status_texts[items[i].key]=items[i].name;$scope.status_classes[items[i].key]=getStatusClass(items[i].key);}});switch($scope.story.status){case'active':$scope.statusLabelStyle='label-info';break;case'merged':$scope.statusLabelStyle='label-success';break;case'invalid':$scope.statusLabelStyle='label-default';break;default:$scope.statusLabelStyle='label-default';break;}});angular.module('sb.story').controller('StoryModalController',function($scope,$modalInstance,params,Project,Story,Task,User,Team,$q,CurrentUser,StoryHelper){'use strict';var currentUser=CurrentUser.resolve();$scope.projects=Project.browse({});currentUser.then(function(user){$scope.story=new Story({title:'',users:[user],teams:[]});});$scope.tasks=[new Task({title:''})];$scope.updateSecurity=function(forcePrivate,update){$scope.privacyLocked=StoryHelper.updateSecurity(forcePrivate,update,$scope.story,$scope.tasks);};if(params.projectId){Project.get({id:params.projectId},function(project){$scope.asyncProject=project;$scope.tasks=[new Task({title:'',project_id:project.id})];});}var lastTitle='',trackingStoryTitle=true;$scope.$on('$destroy',$scope.$watch(function(){return $scope.story.title;},function(newTitle){if(!trackingStoryTitle){return;}var task=$scope.tasks[0];if(trackingStoryTitle&&task.title===lastTitle){task.title=newTitle;lastTitle=newTitle;}else{trackingStoryTitle=false;}}));$scope.save=function(){$scope.story.$create(function(story){var resolvingTasks=$scope.tasks.length;$scope.tasks.forEach(function(task){task.story_id=story.id;task.$create(function(){resolvingTasks--;if(resolvingTasks===0){$modalInstance.close(story);}});});});};$scope.close=function(){$modalInstance.dismiss('cancel');};$scope.addTask=function(){var lastTask=$scope.tasks[$scope.tasks.length-1];var project_id=lastTask.project_id;if(!project_id){project_id=params.projectId||null;}var current_task=new Task({project_id:project_id});if(project_id){Project.get({id:project_id},function(project){$scope.asyncProject=project;});}$scope.tasks.push(current_task);$scope.updateSecurity(true,false);};$scope.removeTask=function(task){if($scope.tasks.length<2){return;}var idx=$scope.tasks.indexOf(task);$scope.tasks.splice(idx,1);};$scope.searchProjects=function(value){return Project.browse({name:value,limit:10}).$promise;};$scope.formatProjectName=function(model){if(!!model){return model.name;}return'';};$scope.selectNewProject=function(model,task){task.project_id=model.id;$scope.updateSecurity(true,false);};$scope.searchActors=function(value,users,teams){var userIds=users.map(function(user){return user.id;});var teamIds=teams.map(function(team){return team.id;});var deferred=$q.defer();var usersDeferred=$q.defer();var teamsDeferred=$q.defer();User.browse({full_name:value,limit:10},function(searchResults){var results=[];angular.forEach(searchResults,function(result){if(userIds.indexOf(result.id)===-1){result.name=result.full_name;result.type='user';results.push(result);}});usersDeferred.resolve(results);});Team.browse({name:value,limit:10},function(searchResults){var results=[];angular.forEach(searchResults,function(result){if(teamIds.indexOf(result.id)===-1){result.type='team';results.push(result);}});teamsDeferred.resolve(results);});var searches=[teamsDeferred.promise,usersDeferred.promise];$q.all(searches).then(function(searchResults){var results=[];angular.forEach(searchResults,function(promise){angular.forEach(promise,function(result){results.push(result);});});deferred.resolve(results);});return deferred.promise;};$scope.addActor=function(model){if(model.type==='user'){$scope.story.users.push(model);}else if(model.type==='team'){$scope.story.teams.push(model);}};$scope.removeUser=function(model){var idx=$scope.story.users.indexOf(model);$scope.story.users.splice(idx,1);};$scope.removeTeam=function(model){var idx=$scope.story.teams.indexOf(model);$scope.story.teams.splice(idx,1);};});angular.module('sb.story').controller('StoryNewController',function($scope,$state,$stateParams,Story,Project,Branch,Tags,Task,Team,User,StoryHelper,$q,storyboardApiBase,currentUser){'use strict';$scope.updateSecurity=function(forcePrivate,update){$scope.privacyLocked=StoryHelper.updateSecurity(forcePrivate,update,$scope.story,$scope.tasks);};var story=new Story({title:$stateParams.title,description:$stateParams.description,private:!!$stateParams.private||!!$stateParams.force_private||!!$stateParams.security,security:!!$stateParams.security,users:[currentUser],teams:[]});var stateTeamIds=[];if(!!$stateParams.team_id){if($stateParams.team_id.constructor!==Array){stateTeamIds.push($stateParams.team_id);}else{stateTeamIds.push.apply(stateTeamIds,$stateParams.team_id);}}var stateUserIds=[];if(!!$stateParams.user_id){if($stateParams.user_id.constructor!==Array){stateUserIds.push($stateParams.user_id);}else{stateUserIds.push.apply(stateUserIds,$stateParams.user_id);}}angular.forEach(stateTeamIds,function(team_id){Team.get({team_id:team_id}).$promise.then(function(team){story.teams.push(team);});});angular.forEach(stateUserIds,function(user_id){User.get({id:user_id}).$promise.then(function(user){story.users.push(user);});});$scope.story=story;if(!!$stateParams.tags&&$stateParams.tags.constructor!==Array){$stateParams.tags=[$stateParams.tags];}$scope.tags=$stateParams.tags||[];$scope.forcePrivate=!!$stateParams.force_private;$scope.projectNames=[];$scope.projects={};$scope.tasks=[];$scope.updateSecurity(true,false);$scope.isLoading=true;$scope.isUpdating=false;$scope.isValid=function(){return!!$scope.tasks.length&&!!$scope.story.title;};function createTasks(createdStory){var resolvingTasks=$scope.tasks.length;angular.forEach($scope.tasks,function(task){task.story_id=createdStory.id;task.$create(function(){resolvingTasks--;if(resolvingTasks===0){$state.go('sb.story.detail',{storyId:createdStory.id});}});});}$scope.createStory=function(){$scope.isUpdating=true;if($scope.forcePrivate){$scope.story.private=true;}$scope.story.$create(function(createdStory){var tagsController=new Story.TagsController({id:createdStory.id});if($scope.tags.length>0){tagsController.$update({tags:$scope.tags},createTasks);}else{createTasks(createdStory);}},function(){$scope.isUpdating=false;});};$scope.searchActors=function(value,users,teams){var userIds=users.map(function(user){return user.id;});var teamIds=teams.map(function(team){return team.id;});var deferred=$q.defer();var usersDeferred=$q.defer();var teamsDeferred=$q.defer();User.browse({full_name:value,limit:10},function(searchResults){var results=[];angular.forEach(searchResults,function(result){if(userIds.indexOf(result.id)===-1){result.name=result.full_name;result.type='user';results.push(result);}});usersDeferred.resolve(results);});Team.browse({name:value,limit:10},function(searchResults){var results=[];angular.forEach(searchResults,function(result){if(teamIds.indexOf(result.id)===-1){result.type='team';results.push(result);}});teamsDeferred.resolve(results);});var searches=[teamsDeferred.promise,usersDeferred.promise];$q.all(searches).then(function(searchResults){var results=[];angular.forEach(searchResults,function(promise){angular.forEach(promise,function(result){results.push(result);});});deferred.resolve(results);});return deferred.promise;};$scope.addActor=function(model){if(model.type==='user'){$scope.story.users.push(model);}else if(model.type==='team'){$scope.story.teams.push(model);}};$scope.removeUser=function(model){var idx=$scope.story.users.indexOf(model);$scope.story.users.splice(idx,1);};$scope.removeTeam=function(model){var idx=$scope.story.teams.indexOf(model);$scope.story.teams.splice(idx,1);};$scope.newTask=new Task({project_id:$stateParams.project_id,show:true,status:'todo',title:$stateParams.title});function mapTaskToProject(task){Project.get({id:task.project_id}).$promise.then(function(project){var idx=$scope.projectNames.indexOf(project.name);if(idx<0){$scope.projectNames.push(project.name);$scope.projects[project.name]=project;$scope.projects[project.name].branchNames=[];$scope.projects[project.name].branches={};}Branch.get({id:task.branch_id}).$promise.then(function(branch){var branchIdx=$scope.projects[project.name].branchNames.indexOf(branch.name);if(branchIdx>-1){$scope.projects[project.name].branches[branch.name].tasks.push(task);}else{$scope.projects[project.name].branches[branch.name]=branch;$scope.projects[project.name].branches[branch.name].tasks=[task];$scope.projects[project.name].branches[branch.name].newTask=new Task({story_id:$scope.story.id,branch_id:branch.id,project_id:project.id,status:'todo'});$scope.projects[project.name].branchNames.push(branch.name);}});});}$scope.validTask=function(task){return!isNaN(task.project_id)&&!!task.title;};$scope.createTask=function(task,branch){var savedTask=new Task(angular.copy(task));if(branch){branch.tasks.push(savedTask);}else{var params={project_id:task.project_id,name:'master'};Branch.browse(params).$promise.then(function(result){if(result){savedTask.branch_id=result[0].id;mapTaskToProject(savedTask);}});}$scope.tasks.push(savedTask);$scope.updateSecurity(true,false);task.title='';};function cleanBranchAndProject(projectName,branchName){var project=$scope.projects[projectName];var branch=project.branches[branchName];var nameIdx=-1;if(branch.tasks.length===0){nameIdx=project.branchNames.indexOf(branchName);if(nameIdx>-1){project.branchNames.splice(nameIdx,1);}delete project.branches[branchName];}if(project.branchNames.length===0){nameIdx=$scope.projectNames.indexOf(projectName);if(nameIdx>-1){$scope.projectNames.splice(nameIdx,1);}delete $scope.projects[projectName];}}$scope.updateTask=function(task,fieldName,value,projectName,branchName){var params={id:task.id};params[fieldName]=value;task[fieldName]=value;if(fieldName==='project_id'){var project=$scope.projects[projectName];var branch=project.branches[branchName];var branchTaskIndex=branch.tasks.indexOf(task);if(branchTaskIndex>-1){branch.tasks.splice(branchTaskIndex,1);}cleanBranchAndProject(projectName,branchName);mapTaskToProject(task);$scope.updateSecurity(true,false);}};$scope.editNotes=function(task){task.tempNotes=task.link;task.editing=true;};$scope.cancelEditNotes=function(task){task.tempNotes='';task.editing=false;};$scope.removeTask=function(task,projectName,branchName){var taskIndex=$scope.tasks.indexOf(task);if(taskIndex>-1){$scope.tasks.splice(taskIndex,1);}var project=$scope.projects[projectName];var branch=project.branches[branchName];var branchTaskIndex=branch.tasks.indexOf(task);if(branchTaskIndex>-1){branch.tasks.splice(branchTaskIndex,1);}cleanBranchAndProject(projectName,branchName);};$scope.showAddTag=false;$scope.toggleAddTag=function(){$scope.showAddTag=!$scope.showAddTag;};$scope.addTag=function(tag_name){if(!!tag_name){$scope.showAddTag=false;$scope.tags.push(tag_name);}};$scope.removeTag=function(tag_name){var tagIndex=$scope.tags.indexOf(tag_name);if(tagIndex>-1){$scope.tags.splice(tagIndex,1);}};$scope.searchTags=function(value){return Tags.browse({name:value,limit:10}).$promise;};$scope.updateViewValue=function(value){$scope.newTag.name=value;};$scope.newTag={};});angular.module('sb.story').controller('StoryTaskAddWorklistController',function($log,$scope,$state,task,$modalInstance,Worklist){'use strict';$scope.task=task;$scope.defaultCriteria=[];$scope.selected='none';$scope.select=function(worklist){$scope.selected=worklist;};$scope.add=function(){var params={item_id:task.id,id:$scope.selected.id,list_position:$scope.selected.items.length,item_type:'task'};Worklist.ItemsController.create(params,function(item){$modalInstance.dismiss(item);});};$scope.close=function(){$modalInstance.dismiss('cancel');};});angular.module('sb.story').controller('StoryTaskDeleteController',function($log,$scope,$state,task,$modalInstance,params){'use strict';$scope.task=task;$scope.params=params;$scope.isUpdating=true;$scope.error={};$scope.remove=function(){$scope.task.$delete(function(){$modalInstance.close('success');});};$scope.close=function(){$modalInstance.dismiss('cancel');};});angular.module('sb.story').controller('StoryWorklistsController',function($scope,$modalInstance,worklists){'use strict';$scope.close=function(){$modalInstance.dismiss('cancel');};$scope.worklists=worklists;});angular.module('sb.story').controller('TimelineFilterController',function($scope,$modalInstance,Preference,TimelineEventTypes){'use strict';function init(){TimelineEventTypes.forEach(function(type){var pref_name='display_events_'+type;$scope[pref_name]=Preference.get(pref_name);});}$scope.close=function(){$modalInstance.dismiss('cancel');};$scope.save=function(){TimelineEventTypes.forEach(function(type){var pref_name='display_events_'+type;var old_value=Preference.get(pref_name);var new_value=$scope[pref_name];if(old_value!==new_value){Preference.set(pref_name,new_value);}});return $modalInstance.close();};init();});angular.module('sb.story').factory('NewStoryService',function($modal,$log,Session,SessionModalService){'use strict';return{showNewStoryModal:function showNewStoryModal(projectId){if(!Session.isLoggedIn()){return SessionModalService.showLoginRequiredModal();}else{var modalInstance=$modal.open({size:'lg',templateUrl:'app/stories/template/new.html',backdrop:'static',controller:'StoryModalController',resolve:{params:function params(){return{projectId:projectId||null};}}});return modalInstance.result;}}};});angular.module('sb.story').factory('StoryHelper',function(Story,Team){'use strict';function updateSecurity(forcePrivate,update,story,tasks){var privacyLocked;if(story.security){if(forcePrivate){story.private=true;privacyLocked=true;}var projects=tasks.map(function(task){return task.project_id;}).filter(function(value){return!isNaN(value);});angular.forEach(projects,function(project_id){Team.browse({project_id:project_id},function(teams){var teamIds=story.teams.map(function(team){return team.id;});teams=teams.filter(function(team){return teamIds.indexOf(team.id)===-1&&team.security;});angular.forEach(teams,function(team){story.teams.push(team);if(update){Story.TeamsController.create({story_id:story.id,team_id:team.id});}});});});}else{if(forcePrivate){privacyLocked=false;}}return privacyLocked;}return{updateSecurity:updateSecurity};});angular.element(document).ready(function(){'use strict';var initInjector=angular.injector(['ng']);var $http=initInjector.get('$http');var $log=initInjector.get('$log');function initializeApplication(config){var defaults={enableEditableComments:false};for(var key in defaults){if(!config.hasOwnProperty(key)){config[key]=defaults[key];}}for(key in config){$log.debug('Configuration: '+key+' -> '+config[key]);angular.module('storyboard').constant(key,config[key]);}angular.bootstrap(document,['storyboard']);}$log.info('Attempting to load parameters from ./config.json');$http.get('./config.json').then(function(response){initializeApplication(response.data);},function(){$log.warn('Cannot load ./config.json, using defaults.');initializeApplication({});});});angular.module('storyboard').controller('ApplicationController',function($scope,$state,$rootScope,$transitions){'use strict';function hasSubmenu(state){for(var stateName in state.views){if(!!stateName.match(/^submenu@/)){return true;}}if(!!state.parent){return hasSubmenu(state.parent);}else{return false;}}$transitions.onSuccess({},function(){$scope.hasSubmenu=hasSubmenu($state.$current);});$scope.hasSubmenu=false;});angular.module('storyboard').controller('HeaderController',function($q,$scope,$rootScope,$state,$modal,NewStoryService,Session,SessionState,CurrentUser,Criteria,Notification,Priority,Project,Story,ProjectGroup,NewWorklistService,NewBoardService,SessionModalService,Severity,Task){'use strict';function resolveCurrentUser(){CurrentUser.resolve().then(function(user){$scope.currentUser=user;},function(){$scope.currentUser=null;});}resolveCurrentUser();$scope.currentUser=null;$scope.newStory=function(){var projectId=null;if($state.current.name==='sb.project.detail'){projectId=$state.params.id;}NewStoryService.showNewStoryModal(projectId).then(function(story){$scope.showMobileNewMenu=false;$state.go('sb.story.detail',{storyId:story.id});});};$scope.newWorklist=function(){NewWorklistService.showNewWorklistModal().then(function(worklist){$scope.showMobileNewMenu=false;$state.go('sb.worklist.detail',{worklistID:worklist.id});});};$scope.newBoard=function(){NewBoardService.showNewBoardModal().then(function(board){$scope.showMobileNewMenu=false;$state.go('sb.board.detail',{boardID:board.id});});};$scope.newProject=function(){$scope.modalInstance=$modal.open({size:'lg',templateUrl:'app/projects/template/new.html',backdrop:'static',controller:'ProjectNewController'});};$scope.newProjectGroup=function(){$scope.modalInstance=$modal.open({templateUrl:'app/project_group/template/new.html',backdrop:'static',controller:'ProjectGroupNewController'});$scope.modalInstance.result.then(function(projectGroup){$scope.showMobileNewMenu=false;$state.go('sb.project_group.detail',{id:projectGroup.id});});};$scope.showLoginRequiredModal=function(){SessionModalService.showLoginRequiredModal();};$scope.logout=function(){Session.destroySession();};$scope.searchString='';$scope.search=function(criteria){switch(criteria.type){case'Text':$state.go('sb.search',{q:criteria.value});break;case'ProjectGroup':$state.go('sb.project_group.detail',{id:criteria.value});break;case'Project':$state.go('sb.project.detail',{id:criteria.value});break;case'Story':$state.go('sb.story.detail',{storyId:criteria.value});break;case'Task':$state.go('sb.task',{taskId:criteria.value});break;}$scope.searchString='';};$scope.quickSearch=function(searchString){var deferred=$q.defer();searchString=searchString||'';var searches=[];var headerGET=false;Notification.intercept(function(message){if(message.type==='http'&&message.severity===Severity.ERROR&&message.message===404&&headerGET){return true;}});if(searchString.match(/^[0-9]+$/)){var getProjectGroupDeferred=$q.defer();var getProjectDeferred=$q.defer();var getStoryDeferred=$q.defer();var getTaskDeferred=$q.defer();headerGET=true;ProjectGroup.get({id:searchString},function(result){getProjectGroupDeferred.resolve(Criteria.create('ProjectGroup',result.id,result.name));},function(){getProjectGroupDeferred.resolve(null);});Project.get({id:searchString},function(result){getProjectDeferred.resolve(Criteria.create('Project',result.id,result.name));},function(){getProjectDeferred.resolve(null);});Story.get({id:searchString},function(result){getStoryDeferred.resolve(Criteria.create('Story',result.id,result.title));},function(){getStoryDeferred.resolve(null);});Task.get({id:searchString},function(result){getTaskDeferred.resolve(Criteria.create('Task',result.id,result.title));},function(){getTaskDeferred.resolve(null);});searches.push(getProjectGroupDeferred.promise);searches.push(getProjectDeferred.promise);searches.push(getStoryDeferred.promise);searches.push(getTaskDeferred.promise);}else{searches.push(ProjectGroup.criteriaResolver(searchString,5));searches.push(Project.criteriaResolver(searchString,5));searches.push(Story.criteriaResolver(searchString,5));}$q.all(searches).then(function(searchResults){headerGET=false;var criteria=[Criteria.create('Text',searchString)];var addResult=function addResult(item){criteria.push(item);};for(var i=0;i<searchResults.length;i++){var results=searchResults[i];if(!results){continue;}if(!!results.forEach){results.forEach(addResult);}else{addResult(results);}}deferred.resolve(criteria);});return deferred.promise;};Notification.intercept(function(message){switch(message.type){case SessionState.LOGGED_IN:resolveCurrentUser();break;case SessionState.LOGGED_OUT:$scope.currentUser=null;break;default:break;}},Priority.LAST);});angular.module('sb.util').directive('subscribe',function(CurrentUser,Notification,Priority,Session,SessionState,Subscription){'use strict';return{restrict:'E',scope:{resource:'@',resourceId:'=',subscriptions:'='},templateUrl:'app/subscription/template/subscribe.html',link:function link($scope){var cuPromise=CurrentUser.resolve();$scope.enabled=Session.isLoggedIn();$scope.subscribed=false;$scope.resolving=false;$scope.subscription=null;$scope.currentUser=null;cuPromise.then(function(user){$scope.currentUser=user;});function setSubscription(subscription){$scope.subscription=subscription||null;$scope.subscribed=!!$scope.subscription;}function resolveSubscription(){if(!Session.isLoggedIn()){setSubscription();return;}$scope.resolving=true;cuPromise.then(function(user){Subscription.browse({user_id:user.id,target_type:$scope.resource,target_id:$scope.resourceId},function(results){setSubscription(results[0]);$scope.resolving=false;},function(){setSubscription();$scope.resolving=false;});});}var removeNotifier=Notification.intercept(function(message){switch(message.type){case SessionState.LOGGED_IN:$scope.enabled=true;resolveSubscription();break;case SessionState.LOGGED_OUT:$scope.enabled=false;$scope.subscribed=false;break;}},Priority.LAST);$scope.$on('$destroy',removeNotifier);$scope.toggleSubscribe=function(){if($scope.resolving){return;}$scope.resolving=true;if(!!$scope.subscription){$scope.subscription.$delete(function(){setSubscription();$scope.resolving=false;},function(){$scope.resolving=false;});}else{cuPromise.then(function(user){var sub=new Subscription({user_id:user.id,target_type:$scope.resource,target_id:$scope.resourceId});sub.$create(function(result){setSubscription(result);$scope.resolving=false;},function(){$scope.resolving=false;});});}};function resolveSubsList(){if(!Session.isLoggedIn()){setSubscription();return;}$scope.resolving=true;cuPromise.then(function(){angular.forEach($scope.subscriptions,function(sub){if($scope.resourceId===sub.target_id){setSubscription(sub);}});$scope.resolving=false;});}if(!!$scope.subscriptions){$scope.subscriptions.$promise.then(resolveSubsList);}else{resolveSubscription();}}};});angular.module('sb.util').constant('TimelineEventTypes',['story_created','story_details_changed','tags_added','tags_deleted','task_created','task_assignee_changed','task_status_changed','task_priority_changed','task_details_changed','task_deleted','user_comment']);angular.module('sb.util').run(function($rootScope){'use strict';var regex='^[a-zA-Z0-9]+([\\-\\./]?[a-zA-Z0-9]+)*$';$rootScope.PROJECT_NAME_REGEX=new RegExp(regex);});angular.module('sb.util').directive('tagComplete',function($q,$parse,$rootScope,$position,typeaheadParser,$timeout){'use strict';var HOT_KEYS=[9,13,27,38,40];return{restrict:'EA',replace:true,scope:{tagCompleteTags:'=',tagCompleteLabelField:'@',tagCompleteTagTemplateUrl:'=',tagCompleteOptionTemplateUrl:'=',tagCompleteVerify:'&',tagCompleteOnSelect:'&',tagCompleteLoading:'&',tagRemoveCallback:'&',maxTags:'=',placeholder:'@'},templateUrl:'app/util/template/tag_complete.html',link:function link($scope,$element,attrs){var $input=$element.find('input');$scope.$watch(function(){return $scope.tagCompleteTags.length;},function(tags){if(tags>0){$input[0].placeholder='';}else{$input[0].placeholder=$scope.placeholder||'';}});$element[0].focus=function(){$input[0].focus();};var parserResult=typeaheadParser.parse(attrs.tagComplete);var isLoadingSetter=function isLoadingSetter(isLoading){if(!!$scope.tagCompleteLoading){$scope.tagCompleteLoading({isLoading:isLoading});}};$scope.tagCompleteTemplateUrl=$parse(attrs.tagCompleteTemplateUrl);$scope.hasFocus=false;var resetMatches=function resetMatches(){$scope.matches=[];$scope.activeIdx=-1;};var getMatchesAsync=function getMatchesAsync(inputValue){if(!$scope.hasFocus||!inputValue){return;}var locals={$viewValue:inputValue};isLoadingSetter(true);$q.when(parserResult.source($scope.$parent,locals)).then(function(matches){if(inputValue===$scope.newTagName&&$scope.hasFocus){$scope.matches=[];for(var i=0;i<matches.length;i++){$scope.matches.push({label:parserResult.viewMapper($scope.$parent,locals),model:matches[i]});}if(matches.length>0){$scope.activeIdx=0;$scope.query=inputValue;}else{resetMatches();}isLoadingSetter(false);$scope.position=$position.position($element);$scope.position.top=$scope.position.top+$element.prop('offsetHeight');}},function(){resetMatches();isLoadingSetter(false);});};$scope.$watch(function(){return $scope.newTagName;},getMatchesAsync);$input.on('focus',function(){$scope.hasFocus=true;if(!$rootScope.$$phase){$scope.$digest();}});$input.on('blur',function(){$timeout(function(){resetMatches();$scope.newTagName='';$scope.hasFocus=false;if(!$rootScope.$$phase){$scope.$digest();}},200);});$input.on('keydown',function(evt){if($scope.matches.length===0||HOT_KEYS.indexOf(evt.which)===-1){return;}evt.preventDefault();if(evt.which===40){$scope.activeIdx=($scope.activeIdx+1)%$scope.matches.length;$scope.$digest();}else if(evt.which===38){$scope.activeIdx=($scope.activeIdx?$scope.activeIdx:$scope.matches.length)-1;$scope.$digest();}else if(evt.which===13||evt.which===9){$scope.$apply(function(){$scope.select($scope.activeIdx);});}else if(evt.which===27){evt.stopPropagation();resetMatches();$scope.$digest();}});$scope.deletePressed=function(){var selectedTags=$scope.tagCompleteTags||[];if(selectedTags.length>0&&!$scope.newTagName){$scope.tagRemoveCallback(selectedTags.pop());return true;}};$scope.focus=function(){$input[0].focus();};$scope.noFocus=function(event){event.stopImmediatePropagation();};$scope.select=function(idx){var item=$scope.matches[idx].model;$scope.tagCompleteTags.push(item);$scope.newTagName='';resetMatches();if(!!$scope.tagCompleteOnSelect){$scope.tagCompleteOnSelect({tag:item});}};$scope.removeTag=function(tag){if(!$scope.tagCompleteTags){return;}var idx=$scope.tagCompleteTags.indexOf(tag);if(idx>-1){$scope.tagCompleteTags.splice(idx,1);}$scope.tagRemoveCallback(tag);};resetMatches();}};}).directive('tagCompleteTag',function($http,$templateCache,$compile,$parse){'use strict';return{restrict:'EA',scope:{index:'=',tag:'=',labelField:'=',removeTag:'&'},link:function link(scope,element,attrs){var tplUrl=$parse(attrs.templateUrl)(scope.$parent)||'/tag_complete/default_tag_template.html';$http.get(tplUrl,{cache:$templateCache}).success(function(tplContent){element.replaceWith($compile(tplContent.trim())(scope));});}};});angular.module('sb.util').directive('tagInput',function(){'use strict';return{restrict:'E',replace:true,scope:{'selectedTags':'=ngModel'},require:'ngModel',controller:'TagInputController',templateUrl:'app/util/template/tag_input.html'};});angular.module('sb.util').controller('TagInputController',function($element,$scope){'use strict';$scope.newTagName='';$scope.deletePressed=function(){if($scope.newTagName.length===0){$scope.selectedTags.pop();return true;}return false;};$scope.addTag=function(){if(!$scope.selectedTags){$scope.selectedTags=[];}if($scope.newTagName.length>0&&$scope.selectedTags.indexOf($scope.newTagName)===-1){$scope.selectedTags.push($scope.newTagName);$scope.newTagName='';}};$scope.focus=function(){$element.find('input[name=tagInputField]').focus();};$scope.noFocus=function(event){event.stopImmediatePropagation();};});angular.module('sb.util').directive('activePath',function($location,$rootScope,$transitions){'use strict';return{link:function link($scope,element,attrs){var activePath=attrs.activePath;function setActivePath(){var path=$location.path();var isMatchedPath=path.match(activePath)!==null;element.toggleClass('active',isMatchedPath);}var disconnectBinding=$transitions.onSuccess({},function setActivePath(){var path=$location.path();var isMatchedPath=path.match(activePath)!==null;element.toggleClass('active',isMatchedPath);});$scope.$on('$destroy',disconnectBinding);setActivePath();}};});angular.module('sb.util').directive('autoresizeWidth',function($document){'use strict';return{link:function link($scope,$element){var shadow=angular.element('<span></span>');shadow.attr('class',$element.attr('class'));shadow.css({display:'none','white-space':'pre',width:'auto',visibility:'hidden'});$document.find('body').append(shadow);$scope.$on('$destroy',function(){shadow.remove();});function recalculateSize(event){var value=$element.val()||'M';if(event&&event.type==='keypress'){value+=String.fromCharCode(event.which);}shadow.text(value);shadow.css('display','inline-block');try{$element[0].offsetWidth=shadow[0].offsetWidth;}finally{shadow.css('display','none');}}$element.bind('keypress keyup',recalculateSize);recalculateSize();}};});angular.module('sb.util').directive('ngDelete',function(){'use strict';return function(scope,element,attrs){element.bind('keydown keypress',function(event){if(event.which===8){var preventDefault=false;scope.$apply(function(){preventDefault=scope.$eval(attrs.ngDelete);});if(preventDefault){event.preventDefault();}}});};});angular.module('sb.util').directive('ngEnter',function(){'use strict';return function(scope,element,attrs){element.bind('keydown keypress',function(event){if(event.which===13){scope.$apply(function(){scope.$eval(attrs.ngEnter);});event.preventDefault();}});};});angular.module('sb.util').directive('focus',function($timeout){'use strict';return{link:function link($scope,$element,$attrs){var focus=$scope.$eval($attrs.focus);if(typeof focus==='undefined'){focus=true;}if(!focus){return;}var e=$element[0];if(!!e&&!!e.focus){$timeout(function(){e.focus();},10);}}};});angular.module('sb.util').directive('focusOnShow',function($timeout){'use strict';return{restrict:'A',link:function link(scope,element,attrs){if(attrs.ngShow){scope.$watch(attrs.ngShow,function(show){if(show){$timeout(function(){element[0].focus();},0);}});}}};});angular.module('sb.util').directive('inputInline',function(){'use strict';return{require:'ngModel',restrict:'E',templateUrl:'app/util/template/input_inline.html',scope:{enabled:'=',asInline:'=',autoFocus:'=',onChange:'&',emptyPrompt:'@',emptyDisabledPrompt:'@',maxLength:'=',placeholder:'@placeholder'},link:function link($scope,element,attrs,ngModel){$scope.showForm=!$scope.asInline;$scope.toggleForm=function(){if(!!$scope.asInline){$scope.showForm=$scope.enabled?!$scope.showForm:false;}else{$scope.showForm=true;}};$scope.onInputBlur=function(value){if(value!==ngModel.$viewValue){ngModel.$setViewValue(value);$scope.onChange();}$scope.toggleForm();};$scope.$watch(function(){return ngModel.$viewValue;},function(value){if($scope.inputText!==value){$scope.inputText=!!value?value:'';}});}};});angular.module('sb.util').directive('projectTypeahead',function(Project,$timeout){'use strict';return{require:'ngModel',restrict:'E',templateUrl:'app/util/template/project_typeahead.html',scope:{enabled:'=',asInline:'=',autoFocus:'=',onChange:'&',emptyPrompt:'@',emptyDisabledPrompt:'@',placeholder:'@placeholder'},link:function link($scope,element,attrs,ngModel){$scope.showForm=!$scope.asInline;$scope.toggleForm=function(){if(!!$scope.asInline){if($scope.showForm){$timeout(function(){$scope.showForm=$scope.enabled?!$scope.showForm:false;},200);}else{$scope.showForm=true;}}else{$scope.showForm=true;}};$scope.searchProjects=function(value){return Project.browse({name:value,limit:10}).$promise;};$scope.loadProject=function(){var projectId=ngModel.$viewValue||null;if(!!projectId){$scope.project=Project.get({id:projectId},function(project){$scope.selectedProject=project;},function(){$scope.project=null;$scope.selectedProject=null;});}else{$scope.project=null;$scope.selectedProject=null;}};$scope.updateViewValue=function(value){if(value!==ngModel.$viewValue){ngModel.$setViewValue(value);$scope.onChange();}};$scope.formatProjectName=function(model){if(!!model){return model.name;}return'';};$scope.$watch(function(){return ngModel.$viewValue;},$scope.loadProject);}};});angular.module('sb.util').directive('resolveStory',function($parse,Story){'use strict';return{restrict:'A',scope:true,link:function link($scope,$element,$attrs){var storyId=$parse($attrs.resolveStory)($scope.$parent);if(!!storyId){$scope.story=Story.get({id:storyId});}else{$scope.story=null;}}};});angular.module('sb.util').directive('ngShiftEnter',function(){'use strict';return function(scope,element,attrs){element.bind('keydown keypress',function(event){if(event.which===13&&event.shiftKey){scope.$apply(function(){scope.$eval(attrs.ngShiftEnter);});event.preventDefault();}});};});angular.module('sb.util').directive('storyStatusLabel',function(){'use strict';return{restrict:'E',templateUrl:'app/util/template/story_status_label.html',scope:{story:'='},controller:function controller($scope){function getStoryStatus(){if(!$scope.story){return null;}else{return $scope.story.status;}}function updateStoryLabel(){switch(getStoryStatus()){case'invalid':$scope.labelStyle='label-default';break;case'active':$scope.labelStyle='label-info';break;case'merged':$scope.labelStyle='label-success';break;default:$scope.labelStyle='label-default';}}var unwatch=$scope.$watch(getStoryStatus,updateStoryLabel);$scope.$on('$destroy',unwatch);updateStoryLabel();}};});angular.module('sb.util').directive('storyTaskStatus',function(TaskStatus){'use strict';return{restrict:'E',templateUrl:'app/util/template/story_task_status.html',scope:{story:'='},link:function link($scope){TaskStatus.query({},function(items){var statuses=[];for(var i=0;i<items.length;i++){statuses[items[i].key]=items[i].name;}$scope.status_texts=statuses;});$scope.orderStatus=function(item){var order=['todo','inprogress','review','invalid','merged'];return order.indexOf(item.key);};}};});angular.module('sb.util').directive('taskPriorityDropdown',function(){'use strict';return{restrict:'E',templateUrl:'app/util/template/task_priority_dropdown.html',scope:{priority:'@',onChange:'&',editable:'@'},link:function link($scope){$scope.style='default';$scope.setPriority=function(newPriority){if(newPriority!==$scope.priority){$scope.priority=newPriority;$scope.onChange({priority:newPriority});}};}};});angular.module('sb.util').directive('taskStatusDropdown',function(TaskStatus){'use strict';function setStyle(status){switch(status){case'invalid':return'default';case'merged':return'success';case'inprogress':return'info';case'review':return'warning';case'todo':return'default';default:return'default';}}return{restrict:'E',templateUrl:'app/util/template/task_status_dropdown.html',scope:{status:'@',onChange:'&',editable:'@'},link:function link($scope){TaskStatus.query({},function(items){$scope.taskStatuses=items;$scope.statusName=$scope.status;for(var i=0;i<items.length;i++){if(items[i].key===$scope.status){$scope.statusName=items[i].name;}}});$scope.style=setStyle($scope.status);$scope.setStatus=function(newStatus){if(newStatus!==$scope.status){$scope.style=setStyle(newStatus);$scope.status=newStatus;for(var i=0;i<$scope.taskStatuses.length;i++){if($scope.taskStatuses[i].key===$scope.status){$scope.statusName=$scope.taskStatuses[i].name;}}$scope.onChange({status:newStatus});}};}};});angular.module('sb.util').directive('timeMoment',function(DateUtil){'use strict';return{restrict:'A',templateUrl:'app/util/template/time_moment.html',scope:{eventdate:'=',shortDate:'=',formatString:'=',noTimeAgo:'@'},controller:function controller($scope){function updateTimeAgo(){if(!$scope.noTimeAgo){$scope.needsTimeAgo=DateUtil.needsTimeAgo($scope.eventdate);}else{$scope.needsTimeAgo=false;}}var unwatch=$scope.$watch(updateTimeAgo);$scope.$on('$destroy',unwatch);updateTimeAgo();}};});angular.module('sb.util').directive('timelineEvent',function($log){'use strict';return{restrict:'E',replace:true,link:function link(scope,element,attrs){var tlEvent;try{tlEvent=JSON.parse(attrs.tlEvent);scope.event_type=tlEvent.event_type;}catch(error){$log.warn(error);scope.event_type='unknown';}},templateUrl:'app/stories/template/comments/template_switch.html'};});angular.module('sb.util').directive('userTypeahead',function(User,$timeout){'use strict';return{require:'ngModel',restrict:'E',templateUrl:'app/util/template/user_typeahead.html',scope:{enabled:'=',asInline:'=',autoFocus:'=',onChange:'&',onBlur:'&',onFocus:'&',emptyPrompt:'@',emptyDisabledPrompt:'@',placeholder:'@placeholder'},link:function link($scope,element,attrs,ngModel){$scope.showForm=!$scope.asInline;$scope.toggleForm=function(evt){if(evt&&!evt.target.value){$scope.updateViewValue(null);}if(!!$scope.asInline){if($scope.showForm){$timeout(function(){$scope.showForm=$scope.enabled?!$scope.showForm:false;},200);$scope.onBlur();}else{$scope.showForm=true;$scope.onFocus();}}else{$scope.showForm=true;}};$scope.searchUsers=function(value){return User.browse({full_name:value,limit:10}).$promise;};$scope.loadUser=function(){var userId=ngModel.$viewValue||null;if(!!userId){User.get({id:userId},function(user){$scope.user=user;$scope.selectedUser=user;},function(){$scope.user=null;$scope.selectedUser=null;});}else{$scope.user=null;$scope.selectedUser=null;}};$scope.updateViewValue=function(value){if(value!==ngModel.$viewValue){ngModel.$setViewValue(value);$scope.onChange();}};$scope.handleEscapeKey=function(evt){if(evt.keyCode===27){evt.target.blur();}};$scope.handleEnterKey=function(evt){if(evt.keyCode===13){if(evt&&!evt.target.value){$scope.updateViewValue(null);}evt.target.blur();}};$scope.formatUserName=function(model){if(!!model){return model.full_name+' <'+model.email+'>';}return'';};$scope.$watch(function(){return ngModel.$viewValue;},$scope.loadUser);}};});angular.module('sb.util').filter('capitalize',function(){'use strict';return function(value){try{return value.charAt(0).toUpperCase()+value.slice(1);}catch(e){return value;}};});angular.module('sb.util').filter('debug',function($log){'use strict';return function(value){$log.debug('DEBUG',value);return value;};});angular.module('sb.util').filter('taskPriorityLabel',function(){'use strict';return function(value){switch(value){case'high':return'High';case'medium':return'Medium';case'low':return'Low';default:return'Unknown Priority';}};});angular.module('sb.util').filter('truncate',function(){'use strict';return function(value,length){if(value&&value.length>length){value=value.substr(0,length-3)+'...';}return value;};});angular.module('sb.util').factory('ArrayUtil',function(){'use strict';return{intersection:function intersection(A,B){var result=[];A.forEach(function(item){if(B.indexOf(item)>-1){result.push(item);}});return result;},difference:function difference(U,A){var result=[];U.forEach(function(item){if(A.indexOf(item)===-1){result.push(item);}});return result;}};});angular.module('sb.util').factory('DateUtil',function(){'use strict';return{needsTimeAgo:function needsTimeAgo(targetDate){if(targetDate){var currentDate=new Date().getTime();var daydiff=(currentDate-Date.parse(targetDate))/(1000*60*60*24);return daydiff<1&&daydiff>=0;}else{return true;}}};});angular.module('sb.util').factory('StringUtil',function(){'use strict';var defaultLength=32;var alphaNumeric='ABCDEFGHIJKLMNOPQRSTUVWXYZ'+'abcdefghijklmnopqrstuvwxyz'+'0123456789';return{randomAlphaNumeric:function randomAlphaNumeric(length){return this.random(length,alphaNumeric);},random:function random(length,characters){length=length||defaultLength;characters=characters||alphaNumeric;var text='';for(var i=0;i<length;i++){text+=characters.charAt(Math.floor(Math.random()*characters.length));}return text;}};});angular.module('sb.util').factory('UrlUtil',function($window){'use strict';return{getFullUrlPrefix:function getFullUrlPrefix(){var origin=$window.location.origin;var path=$window.location.pathname;return origin+path;},buildApplicationUrl:function buildApplicationUrl(fragment){return this.getFullUrlPrefix()+'#!'+fragment;},serializeParameters:function serializeParameters(params){var pairs=[];for(var prop in params){if(!params.hasOwnProperty(prop)){continue;}pairs.push(encodeURIComponent(prop)+'='+encodeURIComponent(params[prop]));}return pairs.join('&');},deserializeParameters:function deserializeParameters(queryString){var params={};var queryComponents=queryString.split('&');for(var i=0;i<queryComponents.length;i++){var parts=queryComponents[i].split('=');var key=decodeURIComponent(parts[0])||null;var value=decodeURIComponent(parts[1])||null;if(!!key&&!!value){params[key]=value;}}return params;}};});angular.module('sb.util').provider('$searchParams',function($windowProvider){'use strict';var pageParams={};this.extractSearchParameters=function(){var window=$windowProvider.$get();var search=window.location.search;if(search.charAt(0)==='?'){search=search.substr(1);}var queryComponents=search.split('&');for(var i=0;i<queryComponents.length;i++){var parts=queryComponents[i].split('=');var key=decodeURIComponent(parts[0])||null;var value=decodeURIComponent(parts[1])||null;if(!!key&&!!value){pageParams[key]=value;}}};this.$get=function(){return angular.copy(pageParams);};}).config(function($searchParamsProvider,$windowProvider){'use strict';$searchParamsProvider.extractSearchParameters();var window=$windowProvider.$get();var url=new URL(window.location.toString());url.search='';if(window.location.toString()!==url.toString()){window.history.replaceState({},window.document.title,url.toString());}});angular.module('sb.util').factory('LastLocation',function($rootScope,localStorageService,$state){'use strict';return{go:function go(defaultStateName,defaultStateParams){var last=localStorageService.get('lastLocation');if(!last){$state.go(defaultStateName,defaultStateParams);}else{last=angular.fromJson(last);$state.go(last.name,last.params);}},onStateChange:function onStateChange(transition){if(transition.$to().name.indexOf('sb.auth')===-1){var data={'name':transition.$to().name,'params':transition.params()};localStorageService.set('lastLocation',angular.toJson(data));}}};});angular.module('sb.worklist').controller('AddWorklistController',function($scope,$modalInstance,$state,params,redirect,Worklist){'use strict';var blankFilter={type:'Story',filter_criteria:[{negative:false,field:null,value:null,title:null}]};$scope.save=function(){$scope.isSaving=true;$scope.worklist.$create(function(result){$scope.isSaving=false;$modalInstance.close(result);if(redirect){$state.go('sb.worklist.detail',{worklistID:result.id});}});};$scope.close=function(){$modalInstance.dismiss('cancel');};$scope.setType=function(type){$scope.newFilter.type=type;$scope.resourceTypes=[type];$scope.$broadcast('refresh-types');};$scope.setCriterion=function(criterion,tag){criterion.field=tag.type;criterion.value=tag.value.toString();criterion.title=tag.title;};$scope.addCriterion=function(filter){filter.filter_criteria.push({negative:false,field:null,value:null,title:null});};$scope.removeTag=function(criterion){if($scope.newFilter.filter_criteria.length>1){var idx=$scope.newFilter.filter_criteria.indexOf(criterion);$scope.newFilter.filter_criteria.splice(idx,1);}else{criterion.field=null;criterion.value=null;criterion.title=null;}};$scope.checkNewFilter=function(){var valid=true;angular.forEach($scope.newFilter.filter_criteria,function(criterion){if(criterion.field==null||criterion.value==null||criterion.title==null){valid=false;}});return valid;};$scope.remove=function(filter){var idx=$scope.worklist.filters.indexOf(filter);$scope.worklist.filters.splice(idx,1);};$scope.saveNewFilter=function(){var added=angular.copy($scope.newFilter);$scope.worklist.filters.push(added);$scope.showAddFilter=false;$scope.newFilter=angular.copy(blankFilter);};$scope.isSaving=false;$scope.worklist=new Worklist({title:'',filters:[]});$scope.resourceTypes=['Story'];$scope.showAddFilter=true;$scope.newFilter=angular.copy(blankFilter);$scope.modalTitle='New Worklist';});angular.module('sb.worklist').controller('WorklistAddItemController',function($log,$scope,$state,worklist,$modalInstance,Story,Task,NewStoryService,Criteria,Worklist,$q,valid){'use strict';$scope.worklist=worklist;$scope.items=[];$scope.saving=false;$scope.loadingItems=false;$scope.error={};$scope.newStory=function(){NewStoryService.showNewStoryModal();};var unstaged=function unstaged(item){var accept=true;angular.forEach($scope.items,function(selectedItem){if(!selectedItem.hasOwnProperty('value')){selectedItem.value=selectedItem.id;}if(!item.hasOwnProperty('value')){item.value=item.id;}if(selectedItem.type===item.type&&selectedItem.value===item.value){accept=false;item.invalid=item.type+' is already waiting to be added.';}});return accept;};$scope.save=function(){$scope.saving=true;var creates=[];var offset=$scope.worklist.items.length;for(var i=0;i<$scope.items.length;i++){var item=$scope.items[i];var item_type='';if(item.type==='Task'){item_type='task';}else if(item.type==='Story'){item_type='story';}if(!item.hasOwnProperty('value')){item.value=item.id;}var params={item_id:item.value,id:$scope.worklist.id,list_position:offset+i,item_type:item_type};if(valid(item)){creates.push(Worklist.ItemsController.create(params).$promise);}}$q.all(creates).then(function(){$scope.saving=false;$modalInstance.dismiss('success');});};$scope.removeItem=function(item){var idx=$scope.items.indexOf(item);$scope.items.splice(idx,1);};$scope.targets=['Stories','Tasks'];$scope.searchTarget='Tasks';$scope.searchQuery='';$scope.searchItems=function(value){var searchString=value||'';var searches=[];if(searchString!==''){if($scope.searchTarget==='Stories'){searches.push(Story.criteriaResolver(searchString,50));}else if($scope.searchTarget==='Tasks'){searches.push(Task.criteriaResolver(searchString,50));}}$q.all(searches).then(function(searchResults){var validated=[];var invalid=[];var addResult=function addResult(item){if(valid(item)&&unstaged(item)){validated.push(item);}else{invalid.push(item);}};for(var i=0;i<searchResults.length;i++){var results=searchResults[i];if(!results){continue;}if(!!results.forEach){results.forEach(addResult);}else{addResult(results);}}$scope.searchResults=validated;$scope.invalidSearchResults=invalid;});};$scope.setSearchTarget=function(target){$scope.searchTarget=target;$scope.searchItems($scope.searchQuery);};$scope.loadTasks=function(story){story.loadingTasks=true;Task.browse({story_id:story.value},function(tasks){var results=[];var invalid=[];angular.forEach(tasks,function(task){task.type='Task';if(valid(task)&&unstaged(task)){results.push(task);}else{invalid.push(task);}});story.tasks=results;story.invalidTasks=invalid;story.loadingTasks=false;});};$scope.formatItemName=function(model){if(!!model){return model.title;}return'';};$scope.selectTask=function(task,source,event){event.stopPropagation();task.type='Task';$scope.items.push(task);if(source.length>0){var idx=source.indexOf(task);source.splice(idx,1);}};$scope.selectStory=function(story,source,event){event.stopPropagation();story.type='Story';$scope.items.push(story);if(source.length>0){var idx=source.indexOf(story);source.splice(idx,1);}};$scope.close=function(){$modalInstance.dismiss('cancel');};});angular.module('sb.worklist').controller('WorklistDeleteController',function($log,$scope,$state,worklist,redirect,$modalInstance,Worklist){'use strict';$scope.worklist=worklist;$scope.isUpdating=true;$scope.error={};$scope.remove=function(){Worklist.delete({id:$scope.worklist.id},function(){if(!!redirect){$state.go('sb.dashboard.boards');}return $modalInstance.close('success');});};$scope.close=function(){$modalInstance.dismiss('cancel');};});angular.module('sb.worklist').controller('WorklistDetailController',function($scope,$modal,$timeout,$stateParams,Worklist,BoardHelper,$document,User,$q,worklist,permissions){'use strict';function resolvePermissions(){$scope.owners=[];$scope.users=[];angular.forEach($scope.worklist.owners,function(id){$scope.owners.push(User.get({id:id}));});angular.forEach($scope.worklist.users,function(id){$scope.users.push(User.get({id:id}));});}function loadWorklist(){var params={id:$stateParams.worklistID};Worklist.Permissions.get(params,function(perms){$scope.permissions={editWorklist:perms.indexOf('edit_worklist')>-1,moveItems:perms.indexOf('move_items')>-1};});Worklist.get(params,function(result){$scope.worklist=result;resolvePermissions();});}$scope.update=function(){var params={id:$scope.worklist.id};var owners={codename:'edit_worklist',users:$scope.worklist.owners};var users={codename:'move_items',users:$scope.worklist.users};$scope.worklist.$update().then(function(){var updating=[Worklist.Permissions.update(params,owners).$promise,Worklist.Permissions.update(params,users).$promise];angular.forEach($scope.worklist.filters,function(filter){var filterParams={id:$scope.worklist.id,filter_id:filter.id};updating.push(Worklist.Filters.update(filterParams,filter).$promise);});$q.all(updating).then(function(){$scope.toggleEditMode();});});};$scope.unarchive=function(){$scope.worklist.archived=false;$scope.worklist.$update();};$scope.toggleEditMode=function(){if($scope.editing){loadWorklist();}$scope.editing=!$scope.editing;};function showAddItemModal(){var modalInstance=$modal.open({size:'lg',templateUrl:'app/worklists/template/additem.html',backdrop:'static',controller:'WorklistAddItemController',resolve:{worklist:function worklist(){return $scope.worklist;},valid:function valid(){return function(){return true;};}}});return modalInstance.result;}$scope.addItem=function(){showAddItemModal().finally(loadWorklist);};$scope.removeListItem=function(item){Worklist.ItemsController.delete({id:$scope.worklist.id,item_id:item.id}).$promise.then(function(){var idx=$scope.worklist.items.indexOf(item);$scope.worklist.items.splice(idx,1);});};$scope.remove=function(){var modalInstance=$modal.open({templateUrl:'app/worklists/template/delete.html',backdrop:'static',controller:'WorklistDeleteController',resolve:{worklist:function worklist(){return $scope.worklist;},redirect:function redirect(){return true;}}});return modalInstance.result;};$scope.searchUsers=function(value,array){var deferred=$q.defer();User.browse({full_name:value,limit:10},function(searchResults){var results=[];angular.forEach(searchResults,function(result){if(array.indexOf(result.id)===-1){results.push(result);}});deferred.resolve(results);});return deferred.promise;};$scope.formatUserName=function(model){if(!!model){return model.name;}return'';};$scope.addUser=function(model,modelArray,idArray){idArray.push(model.id);modelArray.push(model);};$scope.removeUser=function(model,modelArray,idArray){var idIdx=idArray.indexOf(model.id);idArray.splice(idIdx,1);var modelIdx=modelArray.indexOf(model);modelArray.splice(modelIdx,1);};var blankFilter={type:'Story',filter_criteria:[{negative:false,field:null,value:null,title:null}]};$scope.setType=function(type){$scope.newFilter.type=type;$scope.resourceTypes=[type];$scope.$broadcast('refresh-types');};$scope.setCriterion=function(criterion,tag){criterion.field=tag.type;criterion.value=tag.value.toString();criterion.title=tag.title;};$scope.addCriterion=function(filter){filter.filter_criteria.push({negative:false,field:null,value:null,title:null});};$scope.removeTag=function(criterion){if($scope.newFilter.filter_criteria.length>1){var idx=$scope.newFilter.filter_criteria.indexOf(criterion);$scope.newFilter.filter_criteria.splice(idx,1);}else{criterion.field=null;criterion.value=null;criterion.title=null;}};$scope.checkNewFilter=function(){var valid=true;angular.forEach($scope.newFilter.filter_criteria,function(criterion){if(criterion.field==null||criterion.value==null||criterion.title==null){valid=false;}});return valid;};$scope.removeFilter=function(filter){var idx=$scope.worklist.filters.indexOf(filter);Worklist.Filters.delete({id:$scope.worklist.id,filter_id:filter.id});$scope.worklist.filters.splice(idx,1);};$scope.saveNewFilter=function(){var added=angular.copy($scope.newFilter);Worklist.Filters.create({id:$scope.worklist.id},added,function(result){$scope.worklist.filters.push(result);});$scope.showAddFilter=false;$scope.newFilter=angular.copy(blankFilter);};$scope.isSaving=false;$scope.resourceTypes=['Story'];$scope.showAddFilter=false;$scope.newFilter=angular.copy(blankFilter);$scope.sortableOptions={accept:function accept(sourceHandle,dest){return sourceHandle.itemScope.sortableScope.$id===dest.$id;},orderChanged:function orderChanged(result){var list=result.dest.sortableScope.$parent.worklist;var position=result.dest.index;var item=list.items[position];item.list_position=position;Worklist.ItemsController.update({id:list.id,item_id:item.id,list_position:item.list_position});}};$document[0].ondragstart=function(event){event.preventDefault();};$scope.worklist=worklist;$scope.permissions={editWorklist:permissions.indexOf('edit_worklist')>-1,moveItems:permissions.indexOf('move_items')>-1};resolvePermissions();});angular.module('sb.worklist').controller('WorklistEditController',function($scope,$modalInstance,$state,worklist,board,Worklist){'use strict';var blankFilter={type:'Story',filter_criteria:[{negative:false,field:null,value:null,title:null}]};$scope.save=function(){$scope.isSaving=true;Worklist.update($scope.worklist,function(){$scope.isSaving=false;$modalInstance.dismiss('success');});};$scope.close=function(){$modalInstance.dismiss('cancel');};$scope.setType=function(type){$scope.newFilter.type=type;$scope.resourceTypes=[type];$scope.$broadcast('refresh-types');};$scope.setCriterion=function(criterion,tag){criterion.field=tag.type;criterion.value=tag.value.toString();criterion.title=tag.title;};$scope.addCriterion=function(filter){filter.filter_criteria.push({negative:false,field:null,value:null,title:null});};$scope.removeTag=function(criterion){if($scope.newFilter.filter_criteria.length>1){var idx=$scope.newFilter.filter_criteria.indexOf(criterion);$scope.newFilter.filter_criteria.splice(idx,1);}else{criterion.field=null;criterion.value=null;criterion.title=null;}};$scope.checkNewFilter=function(){var valid=true;angular.forEach($scope.newFilter.filter_criteria,function(criterion){if(criterion.field==null||criterion.value==null||criterion.title==null){valid=false;}});return valid;};$scope.remove=function(filter){var idx=$scope.worklist.filters.indexOf(filter);Worklist.Filters.delete({id:$scope.worklist.id,filter_id:filter.id});$scope.worklist.filters.splice(idx,1);};$scope.saveNewFilter=function(){var added=angular.copy($scope.newFilter);Worklist.Filters.create({id:$scope.worklist.id},added,function(result){$scope.worklist.filters.push(result);});$scope.showAddFilter=false;$scope.newFilter=angular.copy(blankFilter);};$scope.isSaving=false;$scope.worklist=worklist;$scope.resourceTypes=['Story'];$scope.showAddFilter=false;$scope.newFilter=angular.copy(blankFilter);$scope.modalTitle='Edit Worklist';});angular.module('sb.worklist').factory('NewWorklistService',function($modal,$log,Session,SessionModalService){'use strict';return{showNewWorklistModal:function showNewWorklistModal(userId){if(!Session.isLoggedIn()){return SessionModalService.showLoginRequiredModal();}else{var modalInstance=$modal.open({size:'lg',templateUrl:'app/worklists/template/new.html',backdrop:'static',controller:'AddWorklistController',resolve:{params:function params(){return{userId:userId||null};},redirect:function redirect(){return true;}}});return modalInstance.result;}}};});
//# sourceMappingURL=storyboard.js.map
