angular.module("sb.templates",["app/admin/template/admin_submenu.html","app/admin/template/project_group.html","app/admin/template/project_group_delete.html","app/admin/template/project_group_edit.html","app/admin/template/project_group_new.html","app/admin/template/team.html","app/admin/template/team_edit.html","app/admin/template/user.html","app/admin/template/user_edit.html","app/admin/template/user_new.html","app/auth/template/busy.html","app/auth/template/error.html","app/auth/template/modal/login_required.html","app/dashboard/template/dashboard.html","app/dashboard/template/index.html","app/notification/template/notifications.html","app/pages/template/about.html","app/profile/template/preferences.html","app/profile/template/profile_submenu.html","app/projects/template/detail.html","app/projects/template/list.html","app/projects/template/new.html","app/search/template/criteria_tag_item.html","app/search/template/index.html","app/search/template/project_search_item.html","app/search/template/story_search_item.html","app/search/template/task_search_item.html","app/search/template/typeahead_criteria_item.html","app/search/template/user_search_item.html","app/stories/template/comments/story_created.html","app/stories/template/comments/story_details_changed.html","app/stories/template/comments/task_assignee_changed.html","app/stories/template/comments/task_created.html","app/stories/template/comments/task_deleted.html","app/stories/template/comments/task_details_changed.html","app/stories/template/comments/task_priority_changed.html","app/stories/template/comments/task_status_changed.html","app/stories/template/comments/template_switch.html","app/stories/template/comments/user_comment.html","app/stories/template/delete.html","app/stories/template/delete_task.html","app/stories/template/detail.html","app/stories/template/list.html","app/stories/template/new.html","app/stories/template/story_list_item.html","app/stories/template/task_edit_form.html","app/stories/template/update_filter.html","app/storyboard/template/header_menu.html","app/storyboard/template/side_menu.html","app/util/template/story_status_label.html","app/util/template/story_task_status.html","app/util/template/tag_complete.html","app/util/template/tag_input.html","app/util/template/task_priority_dropdown.html","app/util/template/task_status_dropdown.html","app/util/template/time_moment.html"]),angular.module("app/admin/template/admin_submenu.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/admin/template/admin_submenu.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n<ul class="nav nav-pills nav-stacked text-center">\n    <li active-path="^\\/admin/user.*">\n        <a href="#!/admin/user" title="Users">\n            <i class="fa fa-sb-user fa-lg"></i>\n        </a>\n    </li>\n    <li active-path="^\\/admin/project_group.*">\n        <a href="#!/admin/project_group" title="Project Groups">\n            <i class="fa fa-sb-project-group fa-lg"></i>\n        </a>\n    </li>\n    <li active-path="^\\/admin/team.*">\n        <a href="#!/admin/team" title="Teams">\n            <i class="fa fa-sb-team fa-lg"></i>\n        </a>\n    </li>\n</ul>')}]),angular.module("app/admin/template/project_group.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/admin/template/project_group.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="container">\n    <div class="row">\n        <div class="col-xs-12">\n            <h1><i class="fa fa-sb-project-group"></i> Project Groups</h1>\n        </div>\n    </div>\n    <div class="row">\n        <div class="col-md-3 col-sm-4 col-xs-10">\n            <div class="has-feedback has-feedback-no-label">\n                <input id="projectInput"\n                       type="text"\n                       class="form-control"\n                       ng-model="filterQuery"\n                       required\n                       ng-disabled="!projectGroups.$resolved"\n                       ng-enter="search()"\n                       placeholder="Search Project Groups">\n                <span class="form-control-feedback text-muted\n                form-control-feedback-sm">\n                    <i class="fa fa-refresh fa-spin"\n                       ng-hide="projectGroups.$resolved"></i>\n                    <i class="fa fa-search"\n                       ng-show="projectGroups.$resolved"></i>\n                </span>\n            </div>\n        </div>\n        <div class="col-md-6 col-sm-5 hidden-xs">\n            <div class="form form-horizontal">\n                <p class="form-control-static text-muted">\n                    ({{projectGroups.length}} found)\n                </p>\n            </div>\n        </div>\n        <div class="col-sm-3 col-xs-2">\n            <button class="btn btn-primary pull-right"\n                    ng-click="addProjectGroup()">\n                <i class="fa fa-plus"></i>\n                <span class="hidden-xs">Add Project Group</span>\n            </button>\n        </div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12">\n            <!-- Spacer -->\n            <br/>\n            <table class="table table-condensed table-striped">\n\n                <tbody ng-if="!projectGroups.$resolved">\n                <tr>\n                    <td>\n                        <span class="text-muted text-center">\n                            <i class="fa fa-spin fa-refresh"></i>\n                        </span>\n                    </td>\n                </tr>\n                </tbody>\n\n                <tbody ng-if="projectGroups.$resolved && projectGroups.length == 0">\n                <tr>\n                    <td class="text-center">\n                        <em class="text-muted">\n                            No project groups found.\n                        </em>\n                    </td>\n                </tr>\n                </tbody>\n\n                <tbody ng-if="projectGroups.$resolved && projectGroups.length > 0">\n                <tr ng-repeat="projectGroup in projectGroups">\n                    <td class="col-sm-3 col-xs-4">\n                        <i class="fa fa-sb-project-group text-muted"></i>\n                        <a href="#!/admin/project_group/{{projectGroup.id}}">\n                            {{projectGroup.title}}\n                        </a>\n                    </td>\n                    <td class="col-sm-9 col-xs-8"\n                        ng-controller="ProjectGroupItemController">\n                        <div class="pull-right btn-group btn-group-xs">\n                            <a class="btn btn-link "\n                               href="#!/admin/project_group/{{projectGroup.id}}">\n                                <i class="fa fa-edit fa-lg"></i>\n                            </a>\n                            <a class="btn btn-link "\n                               href=""\n                               ng-click="deleteProjectGroup(projectGroup)">\n                                <i class="fa fa-times fa-lg"></i>\n                            </a>\n                        </div>\n                        <table>\n                            <tbody ng-if="loadingProjectGroupItems">\n                            <tr>\n                                <td>\n                                    <span class="text-muted text-center">\n                                        <i class="fa fa-spin fa-refresh"></i>\n                                    </span>\n                                </td>\n                            </tr>\n                            </tbody>\n\n                            <tbody ng-if="projectGroupItems.length == 0 && !loadingProjectGroupItems">\n                            <tr>\n                                <td>\n                                    <em class="text-muted">\n                                        This group does not contain any\n                                        projects.\n                                    </em>\n                                </td>\n                            </tr>\n                            </tbody>\n\n                            <tbody ng-if="projectGroupItems.length > 0">\n                            <tr ng-repeat="project in projectGroupItems">\n                                <td>\n                                    <a href="#!/project/{{project.id}}">\n                                        <i class="fa fa-sb-project text-muted"></i>\n                                        {{project.name}}\n                                    </a>\n                                </td>\n                            </tr>\n                            </tbody>\n                        </table>\n                    </td>\n                </tr>\n                </tbody>\n            </table>\n        </div>\n    </div>\n</div>')}]),angular.module("app/admin/template/project_group_delete.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/admin/template/project_group_delete.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n<div class="panel panel-default">\n    <div class="panel-heading">\n        <button type="button" class="close" aria-hidden="true"\n                ng-click="close()">&times;</button>\n        <h3 class="panel-title">{{projectGroup.title}}</h3>\n    </div>\n    <div class="panel-body">\n        <div class="row">\n            <div class="col-sm-8 col-sm-offset-2">\n                <h2 class="text-danger text-center">\n                    Are you certain that you want to delete this project group?\n                </h2>\n\n                <p class="text-center lead">\n                    This action cannot be undone.\n                </p>\n\n                <div class="text-center">\n                    <a href="" class="btn btn-danger" ng-click="remove()">\n                        Remove this project group\n                    </a>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>')}]),angular.module("app/admin/template/project_group_edit.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/admin/template/project_group_edit.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="container">\n    <div class="row">\n        <div class="col-xs-12">\n            <h1><i class="fa fa-sb-project-group"></i> {{projectGroup.title}}\n            </h1>\n        </div>\n    </div>\n\n    <div class="row">\n        <div class="col-xs-12">\n            <form class="form-horizontal"\n                  role="form"\n                  name="projectGroupForm">\n                <div class="form-group">\n                    <label for="title" class="col-sm-2 control-label">\n                        Title:\n                    </label>\n\n                    <div class="col-sm-10">\n                        <input id="title"\n                               type="text"\n                               class="form-control"\n                               ng-model="projectGroup.title"\n                               required\n                               ng-disabled="isSaving"\n                               placeholder="Project Group Title">\n                    </div>\n                </div>\n                <div class="form-group">\n                    <label for="name" class="col-sm-2 control-label">\n                        URL:\n                    </label>\n\n                    <div class="col-sm-10">\n                        <input id="name"\n                               type="text"\n                               class="form-control"\n                               ng-model="projectGroup.name"\n                               required\n                               ng-disabled="isSaving"\n                               placeholder="URL Stub for the project group">\n                    </div>\n                </div>\n            </form>\n        </div>\n    </div>\n    <div class="row">\n        <div class="col-sm-2 text-right">\n            <label class="control-label">\n                Projects:\n            </label>\n        </div>\n        <div class="col-sm-10">\n            <form role="form" name="projectsForm">\n                <table class="table table-striped table-outlined">\n                    <tbody>\n                    <tr ng-repeat="(index, project) in projects"\n                        ng-include\n                        src="\'/inline/project_row.html\'">\n                    </tr>\n                    </tbody>\n                </table>\n            </form>\n        </div>\n    </div>\n    <div class="row">\n        <div class="col-xs-4 col-xs-offset-2">\n            <button type="button"\n                    class="btn btn-default"\n                    ng-disabled="isSaving"\n                    ng-click="addProject()">\n                &plus;\n                Add another project\n            </button>\n        </div>\n        <div class="col-xs-6 text-right">\n            <button type="button"\n                    class="btn btn-primary"\n                    ng-click="save()"\n                    ng-disabled="!projectGroupForm.$valid || !projectsForm.$valid || isSaving">\n                Save\n            </button>\n            <a href="#!/admin/project_group"\n               ng-disabled="isSaving"\n               class="btn btn-default">\n                Cancel\n            </a>\n        </div>\n    </div>\n</div>\n\n<!-- Template for story metadata -->\n<script type="text/ng-template" id="/inline/project_row.html">\n    <td class="col-xs-11">\n        <div class="has-feedback has-feedback-no-label">\n            <input id="project"\n                   type="text"\n                   placeholder="Select a Project"\n                   required\n                   ng-model="project"\n                   typeahead-editable="false"\n                   typeahead="project as project.name for project\n                   in searchProjects($viewValue)"\n                   typeahead-loading="loadingProjects"\n                   typeahead-on-select="selectNewProject(index, $model)"\n                   typeahead-input-formatter="formatProjectName($model)"\n                   ng-disabled="isSaving"\n                   class="form-control input-sm"\n                    />\n            <span class="form-control-feedback text-muted\n            form-control-feedback-sm">\n                <i class="fa fa-refresh fa-spin" ng-show="loadingProjects"></i>\n                <i class="fa fa-search" ng-hide="loadingProjects"></i>\n            </span>\n        </div>\n    </td>\n    <th class="col-xs-1"\n        ng-show="projects.length > 1">\n        <button type="button" class="close"\n                ng-click="removeProject(index)">\n            &times;\n        </button>\n    </th>\n</script>\n')}]),angular.module("app/admin/template/project_group_new.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/admin/template/project_group_new.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="panel panel-default">\n    <div class="panel-heading">\n        <button type="button" class="close" aria-hidden="true"\n                ng-click="close()">&times;</button>\n        <h3 class="panel-title">New Project Group</h3>\n    </div>\n    <div class="panel-body">\n        <div class="row">\n            <div class="col-xs-12">\n                <form class="form-horizontal"\n                      role="form"\n                      name="projectGroupForm">\n                    <div class="form-group">\n                        <label for="title" class="col-sm-2 control-label">\n                            Title:\n                        </label>\n\n                        <div class="col-sm-10">\n                            <input id="title"\n                                   type="text"\n                                   class="form-control"\n                                   ng-model="projectGroup.title"\n                                   required\n                                   ng-disabled="isSaving"\n                                   placeholder="Project Group Title">\n                        </div>\n                    </div>\n                    <div class="form-group">\n                        <label for="name" class="col-sm-2 control-label">\n                            URL:\n                        </label>\n\n                        <div class="col-sm-10">\n                            <input id="name"\n                                   type="text"\n                                   class="form-control"\n                                   ng-model="projectGroup.name"\n                                   required\n                                   ng-disabled="isSaving"\n                                   placeholder="URL Stub for the project group">\n                        </div>\n                    </div>\n                </form>\n            </div>\n        </div>\n        <div class="row">\n            <div class="col-xs-12">\n                <form role="form" name="projectsForm">\n                    <table class="table table-striped table-outlined">\n                        <tbody>\n                        <tr ng-repeat="(index, project) in projects"\n                            ng-include\n                            src="\'/inline/project_row.html\'">\n                        </tr>\n                        </tbody>\n                    </table>\n                </form>\n            </div>\n        </div>\n        <div class="row">\n            <div class="col-xs-6">\n                <button type="button"\n                        class="btn btn-default"\n                        ng-disabled="isSaving"\n                        ng-click="addProject()">\n                    &plus;\n                    Add another project\n                </button>\n            </div>\n            <div class="col-xs-6 text-right">\n                <button type="button"\n                        class="btn btn-primary"\n                        ng-click="save()"\n                        ng-disabled="!projectGroupForm.$valid || !projectsForm.$valid || isSaving">\n                    Save Changes\n                </button>\n                <button type="button"\n                        ng-click="close()"\n                        ng-disabled="isSaving"\n                        class="btn btn-default">\n                    Cancel\n                </button>\n            </div>\n        </div>\n    </div>\n</div>\n\n<!-- Template for story metadata -->\n<script type="text/ng-template" id="/inline/project_row.html">\n    <td class="col-xs-11">\n        <div class="has-feedback has-feedback-no-label">\n            <input id="project"\n                   type="text"\n                   placeholder="Select a Project"\n                   required\n                   ng-model="project"\n                   typeahead-editable="false"\n                   typeahead="project as project.name for project\n                   in searchProjects($viewValue)"\n                   typeahead-loading="loadingProjects"\n                   typeahead-on-select="selectNewProject(index, $model)"\n                   typeahead-input-formatter="formatProjectName($model)"\n                   ng-disabled="isSaving"\n                   class="form-control input-sm"\n                    />\n            <span class="form-control-feedback text-muted\n            form-control-feedback-sm">\n                <i class="fa fa-refresh fa-spin" ng-show="loadingProjects"></i>\n                <i class="fa fa-search" ng-hide="loadingProjects"></i>\n            </span>\n        </div>\n    </td>\n    <th class="col-xs-1"\n        ng-show="projects.length > 1">\n        <button type="button" class="close"\n                ng-click="removeProject(index)">\n            &times;\n        </button>\n    </th>\n</script>\n')}]),angular.module("app/admin/template/team.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/admin/template/team.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="container">\n    <div class="row">\n        <div class="col-xs-12">\n            <h1><i class="fa fa-sb-team"></i> Teams</h1>\n        </div>\n    </div>\n    <div class="row">\n        <div class="col-xs-12">\n            <p>This feature has not yet been implemented.</p>\n        </div>\n    </div>\n</div>')}]),angular.module("app/admin/template/team_edit.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/admin/template/team_edit.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="container">\n    <div class="row">\n        <div class="col-xs-12">\n            <h1><i class="fa fa-sb-team"></i> Edit Team</h1>\n        </div>\n    </div>\n    <div class="row">\n        <div class="col-xs-12">\n            <p>This feature has not yet been implemented.</p>\n        </div>\n    </div>\n</div>')}]),angular.module("app/admin/template/user.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/admin/template/user.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="container">\n    <div class="row">\n        <div class="col-xs-12">\n            <h1><i class="fa fa-sb-user"></i> Users</h1>\n        </div>\n    </div>\n    <div class="row">\n        <div class="col-md-3 col-sm-4 col-xs-10">\n            <div class="has-feedback has-feedback-no-label">\n                <input id="userInput"\n                       type="text"\n                       class="form-control"\n                       ng-model="filterQuery"\n                       required\n                       ng-disabled="!users.$resolved"\n                       ng-enter="search()"\n                       placeholder="Search Users">\n                <span class="form-control-feedback text-muted\n                form-control-feedback-sm">\n                    <i class="fa fa-refresh fa-spin"\n                       ng-hide="users.$resolved"></i>\n                    <i class="fa fa-search"\n                       ng-show="users.$resolved"></i>\n                </span>\n            </div>\n        </div>\n        <div class="col-md-6 col-sm-5 hidden-xs">\n            <div class="form form-horizontal">\n                <p class="form-control-static text-muted">\n                    ({{users.length}} found)\n                </p>\n            </div>\n        </div>\n        <div class="col-sm-3 col-xs-2">\n            <button class="btn btn-primary pull-right"\n                    ng-click="addUser()">\n                <i class="fa fa-plus"></i>\n                <span class="hidden-xs">Create User</span>\n            </button>\n        </div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12">\n            <!-- Spacer -->\n            <br/>\n            <table class="table table-condensed table-striped">\n\n                <tbody ng-if="!users.$resolved">\n                <tr>\n                    <td>\n                        <span class="text-muted text-center">\n                            <i class="fa fa-spin fa-refresh"></i>\n                        </span>\n                    </td>\n                </tr>\n                </tbody>\n\n                <tbody ng-if="users.$resolved && users.length == 0">\n                <tr>\n                    <td class="text-center">\n                        <em class="text-muted">\n                            No users found.\n                        </em>\n                    </td>\n                </tr>\n                </tbody>\n\n                <tbody ng-if="users.$resolved && users.length > 0">\n                <tr ng-repeat="user in users">\n                    <td>\n                        <i class="fa fa-sb-user text-muted"></i>\n                        <a href="#!/admin/user/{{user.id}}">\n                            {{user.username}}\n                        </a>\n                    </td>\n                    <td>\n                        <a href="#!/admin/user/{{user.id}}">\n                            {{user.full_name}}\n                        </a>\n                    </td>\n                    <td>\n                        Email:\n                        <span ng-if="user.email">\n                            {{user.email}}\n                        </span>\n                        <span ng-if="!user.email">\n                            Hidden\n                        </span>\n                    </td>\n                    <td class="hidden-xs">\n                        Last Login:\n                        <span time-moment\n                              eventdate="user.last_login"\n                              ng-if="user.last_login"></span>\n                        <span ng-if="!user.last_login">Never</span>\n                    </td>\n                    <td class="text-right">\n                        <a href="#!/admin/user/{{user.id}}">\n                            <i class="fa fa-edit"></i>\n                        </a>\n                    </td>\n                </tr>\n                </tbody>\n            </table>\n        </div>\n    </div>\n</div>\n')}]),angular.module("app/admin/template/user_edit.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/admin/template/user_edit.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="container">\n    <div class="row">\n        <div class="col-xs-12">\n            <h1><i class="fa fa-sb-user"></i> {{user.username}}</h1>\n        </div>\n    </div>\n\n    <div class="row">\n        <div class="col-xs-12">\n            <form class="form-horizontal"\n                  role="form"\n                  name="projectGroupForm">\n                <div class="form-group">\n                    <label for="username" class="col-sm-2 control-label">\n                        Username:\n                    </label>\n\n                    <div class="col-sm-10">\n                        <input id="username"\n                               type="text"\n                               class="form-control"\n                               ng-model="user.username"\n                               required\n                               ng-disabled="isSaving"\n                               placeholder="The unique user name.">\n                    </div>\n                </div>\n                <div class="form-group">\n                    <label for="full_name" class="col-sm-2 control-label">\n                        Full Name:\n                    </label>\n\n                    <div class="col-sm-10">\n                        <input id="full_name"\n                               type="text"\n                               class="form-control"\n                               ng-model="user.full_name"\n                               required\n                               ng-disabled="isSaving"\n                               placeholder="The user\'s full name.">\n                    </div>\n                </div>\n                <div class="form-group">\n                    <label for="email" class="col-sm-2 control-label">\n                        Email:\n                    </label>\n\n                    <div class="col-sm-10">\n                        <input id="email"\n                               type="email"\n                               class="form-control"\n                               ng-model="user.email"\n                               required\n                               ng-disabled="isSaving"\n                               placeholder="The user\'s email address.">\n                    </div>\n                </div>\n                <div class="form-group">\n                    <div class="col-sm-offset-2 col-sm-10">\n                        <div class="checkbox">\n                            <label>\n                                <input type="checkbox"\n                                       ng-model="user.is_superuser"\n                                       name="is_superuser"\n                                       id="is_superuser"/> Admin\n                            </label>\n                        </div>\n                    </div>\n                </div>\n                <div class="form-group">\n                    <div class="col-sm-offset-2 col-sm-10">\n                        <div class="checkbox">\n                            <label>\n                                <input type="checkbox"\n                                       ng-model="user.enable_login"\n                                       name="enable_login"\n                                       id="enable_login"/> Enable Login\n                            </label>\n                        </div>\n                    </div>\n                </div>\n            </form>\n        </div>\n    </div>\n\n    <div class="panel-body">\n        <div class="row">\n            <div class="col-xs-12">\n                <form class="form-horizontal"\n                      role="form"\n                      name="userForm">\n                    <div class="form-group">\n                    </div>\n                </form>\n            </div>\n        </div>\n        <div class="row">\n            <div class="col-xs-12 text-right">\n                <button type="button"\n                        class="btn btn-primary"\n                        ng-click="save()"\n                        ng-disabled="!userForm.$valid || isSaving">\n                    Save Changes\n                </button>\n                <button type="button"\n                        ng-click="cancel()"\n                        ng-disabled="isSaving"\n                        class="btn btn-default">\n                    Cancel\n                </button>\n            </div>\n        </div>\n    </div>\n</div>')
}]),angular.module("app/admin/template/user_new.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/admin/template/user_new.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="panel panel-default">\n    <div class="panel-heading">\n        <button type="button" class="close" aria-hidden="true"\n                ng-click="close()">&times;</button>\n        <h3 class="panel-title">New User</h3>\n    </div>\n    <div class="panel-body">\n        <div class="row">\n            <div class="col-xs-12">\n                <form class="form-horizontal"\n                      role="form"\n                      name="userForm">\n                    <div class="form-group">\n                        <label for="username" class="col-sm-3 control-label">\n                            Username:\n                        </label>\n\n                        <div class="col-sm-9">\n                            <input id="username"\n                                   type="text"\n                                   class="form-control"\n                                   ng-model="user.username"\n                                   required\n                                   ng-disabled="isSaving"\n                                   placeholder="The unique user name.">\n                        </div>\n                    </div>\n                    <div class="form-group">\n                        <label for="full_name" class="col-sm-3 control-label">\n                            Full Name:\n                        </label>\n\n                        <div class="col-sm-9">\n                            <input id="full_name"\n                                   type="text"\n                                   class="form-control"\n                                   ng-model="user.full_name"\n                                   required\n                                   ng-disabled="isSaving"\n                                   placeholder="The user\'s full name.">\n                        </div>\n                    </div>\n                    <div class="form-group">\n                        <label for="email" class="col-sm-3 control-label">\n                            Email:\n                        </label>\n\n                        <div class="col-sm-9">\n                            <input id="email"\n                                   type="email"\n                                   class="form-control"\n                                   ng-model="user.email"\n                                   required\n                                   ng-disabled="isSaving"\n                                   placeholder="The user\'s email address.">\n                        </div>\n                    </div>\n                    <div class="form-group">\n                        <div class="col-sm-offset-3 col-sm-9">\n                            <div class="checkbox">\n                                <label>\n                                    <input type="checkbox"\n                                           ng-model="user.is_superuser"\n                                           name="is_superuser"\n                                           id="is_superuser"/> Admin\n                                </label>\n                            </div>\n                        </div>\n                    </div>\n                    <div class="form-group">\n                        <div class="col-sm-offset-3 col-sm-9">\n                            <div class="checkbox">\n                                <label>\n                                    <input type="checkbox"\n                                           ng-model="user.enable_login"\n                                           name="enable_login"\n                                           id="enable_login"/> Enable Login\n                                </label>\n                            </div>\n                        </div>\n                    </div>\n                </form>\n            </div>\n        </div>\n        <div class="row">\n            <div class="col-xs-12 text-right">\n                <button type="button"\n                        class="btn btn-primary"\n                        ng-click="save()"\n                        ng-disabled="!userForm.$valid || isSaving">\n                    Create User\n                </button>\n                <button type="button"\n                        ng-click="close()"\n                        ng-disabled="isSaving"\n                        class="btn btn-default">\n                    Cancel\n                </button>\n            </div>\n        </div>\n    </div>\n</div>')}]),angular.module("app/auth/template/busy.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/auth/template/busy.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~         http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="container">\n    <div class="row">\n        <div class="col-xs-12">\n            <p class="text-center text-muted">\n                <br/>\n                <i class="fa fa-refresh fa-lg fa-spin"></i>\n            </p>\n        </div>\n    </div>\n</div>')}]),angular.module("app/auth/template/error.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/auth/template/error.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~         http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="container">\n    <div class="row">\n        <div class="col-xs-12">\n            <h1>Oh no!</h1>\n\n            <p class="lead">We encountered an unexpected error while trying to\n                log you in. The error message below should be helpful,\n                though if it\'s not you can contact our engineers in\n                #storyboard on\n                <a href="http://freenode.net/" target="_blank">\n                    Freenode\n                </a>.\n            </p>\n\n            <dl class="dl-horizontal text-danger">\n                <dt>Error Code:</dt>\n                <dd>{{error}}</dd>\n                <dt>Error Description:</dt>\n                <dd>{{errorDescription}}</dd>\n            </dl>\n\n            <!-- TODO(krotscheck): If a user reaches this point, they should\n            be easily able to submit a bug report to storyboard -->\n        </div>\n    </div>\n</div>')}]),angular.module("app/auth/template/modal/login_required.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/auth/template/modal/login_required.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~         http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n<div class="panel panel-default">\n    <div class="panel-heading">\n        <button type="button" class="close" aria-hidden="true"\n                ng-click="close()">&times;</button>\n        <h3 class="panel-title">Authentication required</h3>\n    </div>\n    <div class="panel-body">\n        <div class="row">\n            <div class="col-xs-12 text-center">\n                <a href="" class="btn btn-primary btn-lg" ng-click="login()">\n                    Please log in\n                </a>\n            </div>\n        </div>\n    </div>\n</div>')}]),angular.module("app/dashboard/template/dashboard.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/dashboard/template/dashboard.html",'<div class="container">\n    <div class="row">\n        <div class="col-sm-12">\n            <h1>Dashboard</h1>\n        </div>\n        <div class="col-sm-12">\n            <table class="table table-striped">\n                <thead>\n                <th colspan="2">Stories assigned to me</th>\n                </thead>\n                <tbody>\n                <tr ng-repeat="story in assignedStories">\n                    <td class="col-sm-2">\n                        <story-status-label story="story"/>\n                    </td>\n                    <td>\n                        <p>\n                            <a href="#!/story/{{story.id}}">\n                                {{story.title}}\n                            </a>\n                        </p>\n                        <story-task-status story="story"/>\n                    </td>\n                </tr>\n                </tbody>\n                <tbody ng-show="assignedStories.length == 0">\n                <td colspan="3" class="text-center text-muted">\n                    <em>\n                        There are no active stories currently assigned to you.\n                    </em>\n                </td>\n                </tbody>\n            </table>\n        </div>\n    </div>\n</div>\n')}]),angular.module("app/dashboard/template/index.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/dashboard/template/index.html",'<div class="container">\n    <div class="row">\n        <div class="col-sm-12">\n            <h1>StoryBoard</h1>\n\n            <p class="lead">A task tracking system for inter-related\n                projects.</p>\n        </div>\n    </div>\n</div>')}]),angular.module("app/notification/template/notifications.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/notification/template/notifications.html",'<div class="notification-container">\n    <div ng-repeat="n in notifications | limitTo: displayCount"\n         ng-switch="n.severity">\n        <div ng-switch-when="error"\n             class="alert alert-danger">\n            <div ng-include\n                 src="\'/inline/notification_detail.html\'"></div>\n        </div>\n        <div ng-switch-when="warning"\n             class="alert alert-warning">\n            <div ng-include\n                 src="\'/inline/notification_detail.html\'"></div>\n        </div>\n        <div ng-switch-when="info"\n             class="alert alert-info">\n            <div ng-include\n                 src="\'/inline/notification_detail.html\'"></div>\n        </div>\n        <div ng-switch-when="success"\n             class="alert alert-success">\n            <div ng-include\n                 src="\'/inline/notification_detail.html\'"></div>\n        </div>\n    </div>\n    <div ng-show="notifications.length &gt; displayCount"\n         class="alert alert-info">\n        Showing {{displayCount}} of {{notifications.length}}\n        messages.\n        <a href=""\n           class="alert-link pull-right"\n           ng-click="showMore()">\n            <i class="fa fa-arrow-circle-down"></i>\n            Show More\n        </a>\n    </div>\n</div>\n\n\n<script type="text/ng-template" id="/inline/notification_detail.html">\n    <button type="button" class="close" ng-click="remove(n)">\n        &times;\n    </button>\n    {{n.message}}\n</script>')}]),angular.module("app/pages/template/about.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/pages/template/about.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ 	http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="container">\n    <div class="row">\n        <div class="col-xs-12">\n            <h1>StoryBoard</h1>\n\n            <p class="lead">A task tracking system for inter-related\n                projects.</p>\n\n        </div>\n    </div>\n    <div class="row">\n        <div class="col-sm-8">\n\n            <h2>Stories</h2>\n\n            <p>It all begins with a <strong>story</strong>. A story is a\n                bug report or proposed feature. Stories are then further\n                split into <strong>tasks</strong>, which affect a given\n                project and branch. You can easily track backports of\n                bugs to a specific branch, or plan cross-project\n                features.</p>\n            <a href="#!/story" class="btn btn-primary">\n                Access Stories\n                <i class="fa fa-chevron-right"></i>\n            </a>\n\n            <h2>Projects</h2>\n\n            <p>StoryBoard lets you efficiently track your work across a\n                large number of interrelated projects. Flexible\n                <strong>project groups</strong> lets you get the views\n                that makes the most sense to you.</p>\n            <a href="#!/project" class="btn btn-primary">\n                Access Projects\n                <i class="fa fa-chevron-right"></i>\n            </a>\n\n            <h2>But why?</h2>\n            <p>The OpenStack project has run into a number of limitations\n	        with existing tools; in particular, the workflow needed by\n	        a highly-distributed system that spans multiple projects\n	        is not well served.  This system uses the best concepts\n	        from existing tools and goes beyond to support the needs\n	        of the OpenStack project.</p>\n        <p><a href="http://git.openstack.org/cgit/openstack-infra/storyboard/tree/README.rst"\n               target="_blank"\n               class="btn btn-primary">\n                See project README\n                <i class="fa fa-chevron-right"></i>\n            </a>\n        </div>\n        <div class="col-sm-4">\n            <hr class="visible-xs"/>\n            <h4>Contributing</h4>\n\n            <p>StoryBoard is open source! If you would like to contribute to\n                the development of StoryBoard, you must follow the steps in the\n                "If you\'re a developer, start here" section of this page:</p>\n\n            <p><a href=" http://wiki.openstack.org/HowToContribute"\n                  target="_blank">\n                http://wiki.openstack.org/HowToContribute\n            </a></p>\n\n            <hr/>\n            <h4>Attribution</h4>\n\n            <p>StoryBoard was built with the help of the following openly\n                licensed projects.</p>\n\n            <p><strong>FontAwesome </strong></p>\n\n            <p><a href="http://fontawesome.io/" target="_blank">\n                The iconic font designed for Bootstrap\n            </a></p>\n\n            <p><strong>AngularJS</strong></p>\n\n            <p><a href="http://angularjs.org/" target="_blank">\n                Superheroic JavaScript Framework\n            </a></p>\n\n            <p><strong>Bootstrap</strong></p>\n\n            <p><a href="http://getbootstrap.com/" target="_blank">\n                Mobile first front-end framework\n            </a></p>\n\n        </div>\n    </div>\n</div>\n</div>\n')}]),angular.module("app/profile/template/preferences.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/profile/template/preferences.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~         http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="container" ng-hide="isLoading">\n    <div class="row">\n        <div class="col-xs-12">\n            <h1>Preferences</h1>\n        </div>\n    </div>\n    <div class="row">\n        <div class="col-md-6">\n            <form name="preferencesForm">\n                <div class="form-group">\n                    <label>Page size</label>\n\n                    <p class="help-block">\n                        How many results would you like to see when viewing\n                        lists?\n                    </p>\n\n                    <div>\n                        <input type="radio" name="pageSize"\n                               id="pageSize10" value="10"\n                               ng-model="pageSize">\n                        <label for="pageSize10">10</label>\n                        &nbsp;\n                        <input type="radio" name="pageSize"\n                               id="pageSize25" value="25"\n                               ng-model="pageSize">\n                        <label for="pageSize25">25</label>\n                        &nbsp;\n                        <input type="radio" name="pageSize"\n                               id="pageSize50" value="50"\n                               ng-model="pageSize">\n                        <label for="pageSize50">50</label>\n                        &nbsp;\n                        <input type="radio" name="pageSize"\n                               id="pageSize100" value="100"\n                               ng-model="pageSize">\n                        <label for="pageSize100">100</label>\n                    </div>\n                </div>\n\n                <hr/>\n\n                <div class="form-group">\n                    <label>Timeline events</label>\n\n                    <p class="help-block">\n                        Which types of Timeline events would you like to be\n                        displayed?\n                    </p>\n\n                    <div>\n                        <input type="checkbox" name="enabledTypes"\n                               id="storyCreated"\n                               ng-model="enabled_event_types.story_created">\n                        <label for="storyCreated">Story created</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="storyDetailsChanged"\n                               ng-model="enabled_event_types.story_details_changed">\n                        <label for="storyDetailsChanged">Story details changed</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="taskCreated"\n                               ng-model="enabled_event_types.task_created">\n                        <label for="taskCreated">Task created</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="taskAssigneeChanged"\n                               ng-model="enabled_event_types.task_assignee_changed">\n                        <label for="taskAssigneeChanged">Task assignee changed</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="taskStatusChanged"\n                               ng-model="enabled_event_types.task_status_changed">\n                        <label for="taskStatusChanged">Task status changed</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="taskPriorityChanged"\n                               ng-model="enabled_event_types.task_priority_changed">\n                        <label for="taskStatusChanged">Task priority changed</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="taskDetailsChanged"\n                               ng-model="enabled_event_types.task_details_changed">\n                        <label for="taskDetailsChanged">Task details Changed</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="taskDeleted"\n                               ng-model="enabled_event_types.task_deleted">\n                        <label for="taskDeleted">Task deleted</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="userComment"\n                               ng-model="enabled_event_types.user_comment">\n                        <label for="userComment">User comment</label>\n                    </div>\n                </div>\n\n                <hr/>\n\n                <div class="form-group">\n                    <button type="button" class="btn btn-default"\n                            ng-click="save()">\n                        Save\n                    </button>\n                    <p class="help-block text-success">{{message}}</p>\n                </div>\n            </form>\n        </div>\n    </div>\n</div>\n')}]),angular.module("app/profile/template/profile_submenu.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/profile/template/profile_submenu.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<ul class="nav nav-pills nav-stacked text-center">\n    <li active-path="^\\/profile/preferences.*">\n        <a href="#!/profile/preferences" title="Preferences">\n            <i class="fa fa-sb-profile-preferences fa-lg"></i>\n        </a>\n    </li>\n</ul>')}]),angular.module("app/projects/template/detail.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/projects/template/detail.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~         http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="container">\n    <div class="row">\n        <div ng-include\n             class="col-xs-12"\n             src="\'/inline/project_detail.html\'"\n             ng-hide="showEditForm">\n        </div>\n        <div ng-include\n             src="\'/inline/project_detail_form.html\'"\n             ng-show="showEditForm">\n        </div>\n        <div ng-include src="\'/inline/story_list.html\'"></div>\n    </div>\n</div>\n\n\n<!-- Template for the header and description -->\n<script type="text/ng-template" id="/inline/project_detail.html">\n    <h1>\n        <span ng-show="project.name">\n            {{project.name}}\n        </span>\n        <em ng-hide="project.name" class="text-muted">\n            No title\n        </em>\n        <small ng-show="isLoggedIn">\n            <a href="" ng-click="toggleEditMode()" permission="is_superuser">\n                <i class="fa fa-pencil"></i>\n            </a>\n        </small>\n    </h1>\n    <p>\n        <span ng-show="project.description"\n              class="honor-carriage-return">{{project.description}}\n        </span>\n        <em ng-hide="project.description" class="text-muted">\n            No description provided\n        </em>\n    </p>\n</script>\n\n\n<!-- Template for the header and description -->\n<script type="text/ng-template" id="/inline/project_detail_form.html">\n    <br/>\n    <form name="projectForm">\n        <div class="form-group"\n             ng-class="{\'has-error\': projectForm.name.$invalid}">\n            <input id="name"\n                   name="name"\n                   type="text"\n                   class="form-control"\n                   ng-model="project.name"\n                   required\n                   ng-pattern="PROJECT_NAME_REGEX"\n                   maxlength="50"\n                   ng-minlength="3"\n                   ng-disabled="isUpdating"\n                   placeholder="Project Name">\n            </input>\n            <div class="help-block text-danger"\n                 ng-show="projectForm.name.$invalid">\n                 <span ng-show="projectForm.name.$error.required">\n                     A project name is required.\n                 </span>\n                 <span ng-show="projectForm.name.$error.pattern">\n                     A project name must begin with a letter, and may only\n                     contain letters, numbers, forward slashes, periods, and\n                     dashes. It should not start or end with a separator and\n                     must not contain two or more sequential separators.\n                 </span>\n                 <span ng-show="projectForm.name.$error.minlength">\n                     A project name must have at least 3 characters.\n                 </span>\n            </div>\n        </div>\n        <div class="form-group"\n             ng-class="{\'has-error\': projectForm.description.$invalid}">\n            <textarea name="description"\n                      placeholder="Enter a project description here"\n                      class="form-control"\n                      rows="3"\n                      msd-elastic\n                      required\n                      ng-disabled="isUpdating"\n                      ng-model="project.description">\n            </textarea>\n\n            <div ng-show="projectForm.description.$error.required"\n                 class="help-block text-danger">\n                A project description is required.\n            </div>\n        </div>\n\n        <div class="clearfix">\n            <div class="pull-right">\n                <div class="btn" ng-show="isUpdating">\n                    <i class="fa fa-spinner fa-lg fa-spin"></i>\n                </div>\n                <button type="button"\n                        class="btn btn-primary"\n                        ng-click="update()"\n                        ng-disabled="!projectForm.$valid">\n                    Save\n                </button>\n                <button type="button"\n                        class="btn btn-default"\n                        ng-click="cancel()">\n                    Cancel\n                </button>\n            </div>\n        </div>\n    </form>\n    <hr/>\n</script>\n\n<!-- Template for the task list -->\n<script type="text/ng-template" id="/inline/story_list.html">\n    <div ng-controller="ProjectStoryListController">\n        <div class="col-xs-12">\n            <a href=""\n               class="btn btn-link pull-right"\n               ng-click="newStory()"\n               ng-show="isLoggedIn">\n                <i class="fa fa-plus"></i>\n                Add story\n            </a>\n            <ul class="nav nav-tabs clearfix">\n                <li ng-class="{\'active\': filter == \'active\'}">\n                    <a href=""\n                       ng-click="setFilter(\'active\')">Active</a>\n                </li>\n                <li ng-class="{\'active\': filter == \'merged\'}">\n                    <a href=""\n                       ng-click="setFilter(\'merged\')">Merged</a>\n                </li>\n                <li ng-class="{\'active\': filter == \'invalid\'}">\n                    <a href=""\n                       ng-click="setFilter(\'invalid\')">Invalid</a>\n                </li>\n            </ul>\n            <table class="table table-striped"\n                   ng-hide="isSearching || stories.length == 0">\n                <tbody>\n                <tr ng-repeat="story in stories"\n                    ng-controller="StoryListItemController"\n                    ng-include="\'app/stories/template/story_list_item.html\'">\n                </tr>\n                </tbody>\n            </table>\n\n            <div ng-show="isSearching">\n                <hr/>\n                <p class="text-center">\n                    <i class="fa fa-refresh fa-spin fa-lg"></i>\n                </p>\n            </div>\n\n            <p ng-show="!isSearching && stories.length == 0"\n               class="text-center text-warning">\n                <br/>\n                <em> We were unable to find any stories.\n                    Perhaps you would like to create one?</em>\n            </p>\n        </div>\n    </div>\n</script>\n\n')}]),angular.module("app/projects/template/list.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/projects/template/list.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ 	http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n<div class="container"\n     ng-controller="SearchCriteriaController"\n     ng-init="init(resourceTypes, defaultCriteria)"\n     search-results\n     search-resource="Project"\n     search-criteria="criteria"\n     search-without-criteria="true">\n    <div class="row">\n        <div class="col-xs-12">\n            <h1><i class="fa fa-sb-project"></i> Projects</h1>\n        </div>\n    </div>\n\n    <div class="row">\n        <div class="col-lg-9 col-sm-8 col-xs-10">\n            <div class="form-group has-feedback has-feedback-no-label">\n                <div id="search-criteria"\n                     tag-complete="criteria as criteria.title for criteria in searchForCriteria($viewValue)"\n                     tag-complete-tags="criteria"\n                     tag-complete-label-field="title"\n                     tag-complete-option-template-url="\'app/search/template/typeahead_criteria_item.html\'"\n                     tag-complete-tag-template-url="\'app/search/template/criteria_tag_item.html\'"\n                     tag-complete-loading="loadingCriteria = isLoading"\n                     tag-complete-on-select="addCriteria(tag)"\n                     placeholder="Search Projects">\n                </div>\n                <span class="form-control-feedback text-muted">\n                    <i class="fa fa-search"\n                       ng-hide="loadingCriteria"></i>\n                    <i class="fa fa-refresh fa-spin"\n                       ng-show="loadingCriteria"></i>\n                </span>\n            </div>\n        </div>\n        <div class="col-lg-1 col-sm-2 hidden-xs">\n            <div class="form form-horizontal">\n                <p class="form-control-static text-muted">\n                    ({{searchResults.length}} found)\n                </p>\n            </div>\n        </div>\n        <div class="col-xs-2" permission="is_superuser">\n            <a class="btn btn-primary pull-right"\n               href="#!/project/new">\n                <i class="fa fa-plus"></i>\n                <span class="hidden-xs">Create Project</span>\n            </a>\n        </div>\n    </div>\n\n    <div class="row"\n         ng-if="!hasValidCriteria">\n        <div class="col-xs-12 text-muted text-center">\n            <em>What would you like to search by?</em>\n        </div>\n    </div>\n\n    <div class="row"\n         ng-if="hasValidCriteria">\n        <div class="col-xs-12">\n            <br/>\n        </div>\n        <div class="col-xs-12">\n            <table class="table table-condensed table-striped">\n                <thead>\n                <tr>\n                    <th>\n                        <a ng-click="toggleFilter(\'name\')">\n                            Project\n                            <i class="fa fa-caret-down"\n                               ng-if="sortField == \'name\' && sortDirection == \'desc\'">\n                            </i>\n                            <i class="fa fa-caret-up"\n                               ng-if="sortField == \'name\' && sortDirection == \'asc\'">\n                            </i>\n                        </a>\n                    </th>\n                    <th>\n                        <a ng-click="toggleFilter(\'created_at\')">\n                            Created\n                            <i class="fa fa-caret-down"\n                               ng-if="sortField == \'created_at\' && sortDirection == \'desc\'">\n                            </i>\n                            <i class="fa fa-caret-up"\n                               ng-if="sortField == \'created_at\' && sortDirection == \'asc\'">\n                            </i>\n                        </a>\n                    </th>\n                    <th>\n                        <a ng-click="toggleFilter(\'updated_at\')">\n                            Updated\n                            <i class="fa fa-caret-down"\n                               ng-if="sortField == \'updated_at\' && sortDirection == \'desc\'">\n                            </i>\n                            <i class="fa fa-caret-up"\n                               ng-if="sortField == \'updated_at\' && sortDirection == \'asc\'">\n                            </i>\n                        </a>\n                    </th>\n                </tr>\n                </thead>\n                <tbody ng-if="searchResults.length != 0">\n                <tr ng-repeat="project in searchResults"\n                    ng-include="\'app/search/template/project_search_item.html\'">\n                </tr>\n                </tbody>\n\n                <tbody ng-if="searchResults.length == 0 &amp;&amp; !isSearching">\n                <td class="text-center text-muted" colspan="3">\n                    <em>No projects found.</em>\n                </td>\n                </tbody>\n\n                <tbody ng-if="isSearching">\n                <td colspan="3">\n                    <small class="fa fa-spin fa-refresh text-muted">\n                    </small>\n                </td>\n                </tbody>\n            </table>\n        </div>\n    </div>\n</div>\n')
}]),angular.module("app/projects/template/new.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/projects/template/new.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~         http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="container">\n    <div class="row">\n        <div class="col-xs-12">\n            <h1>New Project</h1>\n        </div>\n    </div>\n    <div class="row">\n        <div class="col-xs-12">\n            <form class="form-horizontal" role="form" name="projectForm">\n                <div class="form-group"\n                     ng-class="{\'has-error\': projectForm.name.$invalid &&\n                      !projectForm.name.$pristine}">\n                    <label for="name" class="col-sm-2 control-label">\n                        Project Name:\n                    </label>\n\n                    <div class="col-sm-10">\n                        <input id="name"\n                               name="name"\n                               type="text"\n                               class="form-control"\n                               ng-model="newProject.name"\n                               required\n                               ng-pattern="PROJECT_NAME_REGEX"\n                               maxlength="50"\n                               ng-minlength="3"\n                               placeholder="Project Name">\n\n                        <div class="help-block text-danger"\n                             ng-show="!projectForm.name.$pristine &&\n                             projectForm.name.$invalid">\n                            <span ng-show="projectForm.name.$error.required">\n                                A project name is required.\n                            </span>\n                            <span ng-show="projectForm.name.$error.pattern">\n                                A project name must begin with a letter, and\n                                may only contain letters, numbers, forward\n                                slashes, periods, and dashes. It should not\n                                start or end with a separator and must not\n                                contain two or more sequential separators.\n                            </span>\n                            <span ng-show="projectForm.name.$error.minlength">\n                                A project name must have at least 3 characters.\n                            </span>\n                        </div>\n                    </div>\n                </div>\n                <div class="form-group"\n                     ng-class="{\'has-error\': projectForm.description.$invalid\n                     && !projectForm.description.$pristine}">\n                    <label for="description"\n                           class="col-sm-2 control-label">\n                        Project Description\n                    </label>\n\n                    <div class="col-sm-10">\n                        <textarea id="description"\n                                  name="description"\n                                  class="form-control"\n                                  ng-model="newProject.description"\n                                  msd-elastic\n                                  required\n                                  placeholder="A brief project description">\n                        </textarea>\n\n                        <div class="help-block text-danger"\n                             ng-show="!projectForm.description.$pristine &&\n                             projectForm.description.$invalid">\n                            <span ng-show="projectForm.description.$error.required">\n                                A project description is required.\n                            </span>\n                        </div>\n                    </div>\n                </div>\n                <div class="form-group">\n                    <div class="col-sm-offset-2 col-sm-10">\n                        <button type="button"\n                                ng-click="createProject()"\n                                class="btn btn-primary"\n                                ng-disabled="!projectForm.$valid">\n                            Create project\n                        </button>\n                        <a href="#!/project/list"\n                           class="btn btn-default">\n                            Cancel\n                        </a>\n                    </div>\n                </div>\n            </form>\n        </div>\n    </div>\n</div>\n')}]),angular.module("app/search/template/criteria_tag_item.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/search/template/criteria_tag_item.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<span ng-switch="tag.type">\n    <div class="tag" ng-switch-when="Text">\n        {{tag.value}}\n        <a class="tag-remove"\n           ng-click="removeTag({tag:tag})">\n            &times;\n        </a>\n    </div>\n    <div class="tag tag-success" ng-switch-when="User">\n        <i class="fa fa-user"></i> {{tag.title}}\n        <a class="tag-remove"\n           ng-click="removeTag({tag:tag})">\n            &times;\n        </a>\n    </div>\n    <div class="tag tag-warning" ng-switch-when="Story">\n        <i class="fa fa-sb-story"></i> {{tag.title}}\n        <a class="tag-remove"\n           ng-click="removeTag({tag:tag})">\n            &times;\n        </a>\n    </div>\n    <div class="tag tag-default" ng-switch-when="StoryStatus">\n        <i class="fa fa-flag"></i> Story Status: {{tag.title}}\n        <a class="tag-remove"\n           ng-click="removeTag({tag:tag})">\n            &times;\n        </a>\n    </div>\n    <div class="tag tag-info" ng-switch-when="Project">\n        <i class="fa fa-sb-project"></i> {{tag.title}}\n        <a class="tag-remove"\n           ng-click="removeTag({tag:tag})">\n            &times;\n        </a>\n    </div>\n    <div class="tag tag-danger" ng-switch-default>\n        <i class="fa fa-question"></i> {{tag.type}}: {{tag.value}}\n        <a class="tag-remove"\n           ng-click="removeTag({tag:tag})">\n            &times;\n        </a>\n    </div>\n</span>')}]),angular.module("app/search/template/index.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/search/template/index.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ 	http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n<div class="container" ng-controller="SearchCriteriaController"\n     ng-init="init(resourceTypes, defaultCriteria)">\n    <div class="row">\n        <div class="col-xs-12">\n            <h1>Search</h1>\n        </div>\n    </div>\n    <div class="row">\n        <div class="col-sm-12">\n            <div class="form-group has-feedback has-feedback-no-label">\n                <div id="search-criteria"\n                     focus\n                     tag-complete="criteria as criteria.title for criteria in searchForCriteria($viewValue)"\n                     tag-complete-tags="criteria"\n                     tag-complete-label-field="title"\n                     tag-complete-option-template-url="\'app/search/template/typeahead_criteria_item.html\'"\n                     tag-complete-tag-template-url="\'app/search/template/criteria_tag_item.html\'"\n                     tag-complete-loading="loadingCriteria = isLoading"\n                     tag-complete-on-select="addCriteria(tag)">\n                </div>\n                <span class="form-control-feedback text-muted">\n                    <i class="fa fa-search"\n                       ng-hide="loadingCriteria"></i>\n                    <i class="fa fa-refresh fa-spin"\n                       ng-show="loadingCriteria"></i>\n                </span>\n            </div>\n        </div>\n    </div>\n    <div class="row"\n         ng-if="criteria.length == 0">\n         <div class="col-xs-12 text-muted text-center">\n             <em>What would you like to search by?</em>\n         </div>\n     </div>\n    <div class="row"\n         ng-if="!hasSomeValidCriteria">\n        <div class="col-xs-12 text-muted text-center">\n            <em>Your search parameters are too restrictive. Try removing\n                some!</em>\n        </div>\n    </div>\n\n    <div class="row"\n         ng-if="criteria.length > 0"\n         search-results\n         search-resource="Project"\n         search-criteria="criteria">\n        <div class="col-xs-12" ng-if="hasValidCriteria">\n            <hr/>\n        </div>\n        <div class="col-xs-2 text-center text-muted" ng-if="hasValidCriteria">\n            <span class="hidden-xs">\n                <i class="fa fa-3x fa-sb-project"></i>\n                <br/>\n                <small>Projects</small>\n            </span>\n            <i class="fa fa-2x fa-sb-project visible-xs"></i>\n        </div>\n        <div class="col-xs-10" ng-if="hasValidCriteria">\n            <table class="table table-condensed table-striped table-clean">\n                <tbody ng-if="searchResults.length != 0">\n                <tr ng-repeat="project in searchResults"\n                    ng-include="\'app/search/template/project_search_item.html\'">\n                </tr>\n                </tbody>\n\n                <tbody ng-if="hasValidCriteria &amp;&amp; searchResults.length == 0 &amp;&amp; !isSearching">\n                <td class="text-center text-muted">\n                    <em>No projects found.</em>\n                </td>\n                </tbody>\n\n                <tbody ng-if="!hasValidCriteria">\n                <td class="text-center text-muted">\n                    <em>Your search criteria are not valid for this item.</em>\n                </td>\n                </tbody>\n\n                <tbody ng-if="isSearching">\n                <td colspan="2">\n                    <small class="fa fa-spin fa-refresh text-muted">\n                    </small>\n                </td>\n                </tbody>\n            </table>\n        </div>\n    </div>\n    <div class="row"\n         ng-if="criteria.length > 0"\n         search-results\n         search-resource="Story"\n         search-criteria="criteria">\n        <div class="col-xs-12" ng-if="hasValidCriteria">\n            <hr/>\n        </div>\n        <div class="col-xs-2 text-center text-muted" ng-if="hasValidCriteria">\n            <span class="hidden-xs">\n                <i class="fa fa-3x fa-sb-story"></i>\n                <br/>\n                <small>Stories</small>\n            </span>\n            <i class="fa fa-2x fa-sb-story visible-xs"></i>\n        </div>\n        <div class="col-xs-10" ng-if="hasValidCriteria">\n            <table class="table table-condensed table-striped table-clean">\n                <tbody ng-if="searchResults.length != 0">\n                <tr ng-repeat="story in searchResults"\n                    ng-include="\'app/search/template/story_search_item.html\'">\n                </tr>\n                </tbody>\n\n                <tbody ng-if="hasValidCriteria &amp;&amp; searchResults.length == 0 &amp;&amp; !isSearching">\n                <td class="text-center text-muted">\n                    <em>No stories found.</em>\n                </td>\n                </tbody>\n\n                <tbody ng-if="!hasValidCriteria">\n                <td class="text-center text-muted">\n                    <em>Your search criteria are not valid for this item.</em>\n                </td>\n                </tbody>\n\n                <tbody ng-if="isSearching">\n                <td colspan="2">\n                    <small class="fa fa-spin fa-refresh text-muted">\n                    </small>\n                </td>\n                </tbody>\n            </table>\n        </div>\n    </div>\n    <div class="row"\n         ng-if="criteria.length > 0"\n         search-results\n         search-resource="Task"\n         search-criteria="criteria">\n        <div class="col-xs-12" ng-if="hasValidCriteria">\n            <hr/>\n        </div>\n        <div class="col-xs-2 text-center text-muted" ng-if="hasValidCriteria">\n            <span class="hidden-xs">\n                <i class="fa fa-3x fa-sb-task"></i>\n                <br/>\n                <small>Tasks</small>\n            </span>\n            <i class="fa fa-2x fa-sb-task visible-xs"></i>\n        </div>\n        <div class="col-xs-10" ng-if="hasValidCriteria">\n            <table class="table table-condensed table-striped table-clean">\n                <tbody ng-if="searchResults.length != 0">\n                <tr ng-repeat="task in searchResults"\n                    ng-include="\'app/search/template/task_search_item.html\'">\n                </tr>\n                </tbody>\n\n                <tbody ng-if="hasValidCriteria &amp;&amp; searchResults.length == 0 &amp;&amp; !isSearching">\n                <td class="text-center text-muted">\n                    <em>No tasks found.</em>\n                </td>\n                </tbody>\n\n                <tbody ng-if="!hasValidCriteria">\n                <td class="text-center text-muted">\n                    <em>Your search criteria are not valid for this item.</em>\n                </td>\n                </tbody>\n\n                <tbody ng-if="isSearching">\n                <td colspan="2">\n                    <small class="fa fa-spin fa-refresh text-muted">\n                    </small>\n                </td>\n                </tbody>\n            </table>\n        </div>\n    </div>\n    <div class="row"\n         ng-if="criteria.length > 0"\n         search-results\n         search-resource="User"\n         search-criteria="criteria">\n        <div class="col-xs-12" ng-if="hasValidCriteria">\n            <hr/>\n        </div>\n        <div class="col-xs-2 text-center text-muted" ng-if="hasValidCriteria">\n            <span class="hidden-xs">\n                <i class="fa fa-3x fa-sb-user"></i>\n                <br/>\n                <small>Users</small>\n            </span>\n            <i class="fa fa-2x fa-sb-user visible-xs"></i>\n        </div>\n        <div class="col-xs-10" ng-if="hasValidCriteria">\n            <table class="table table-condensed table-striped table-clean">\n                <tbody ng-if="searchResults.length != 0">\n                <tr ng-repeat="user in searchResults"\n                    ng-include="\'app/search/template/user_search_item.html\'">\n                </tr>\n                </tbody>\n\n                <tbody ng-if="hasValidCriteria &amp;&amp; searchResults.length == 0 &amp;&amp; !isSearching">\n                <td class="text-center text-muted">\n                    <em>No users found.</em>\n                </td>\n                </tbody>\n\n                <tbody ng-if="!hasValidCriteria">\n                <td class="text-center text-muted">\n                    <em>Your search criteria are not valid for this item.</em>\n                </td>\n                </tbody>\n\n                <tbody ng-if="isSearching">\n                <td colspan="2">\n                    <small class="fa fa-spin fa-refresh text-muted">\n                    </small>\n                </td>\n                </tbody>\n            </table>\n        </div>\n    </div>\n</div>')}]),angular.module("app/search/template/project_search_item.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/search/template/project_search_item.html",'<td>\n    <a href="#!/project/{{project.id}}">\n        {{project.name}}\n    </a>\n    <br/>\n    <span class="text-muted">\n        {{project.description}}\n    </span>\n</td>\n<td>\n    <span time-moment eventdate="project.created_at">\n    </span>\n</td>\n<td>\n    <span time-moment eventdate="project.updated_at">\n    </span>\n</td>')}]),angular.module("app/search/template/story_search_item.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/search/template/story_search_item.html",'<td>\n    <a href="#!/story/{{story.id}}">\n        {{story.id}}: {{story.title}}\n    </a>\n    <br />\n    <span class="text-muted">\n        {{story.description}}\n    </span>\n</td>\n<td>\n    <span time-moment eventdate="story.created_at">\n    </span>\n</td>\n<td>\n    <span time-moment eventdate="story.updated_at">\n    </span>\n</td>\n<td class="text-right">\n    <story-status-label story="story"/>\n</td>')}]),angular.module("app/search/template/task_search_item.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/search/template/task_search_item.html",'<td class="col-xs-2 col-sm-1">\n    <task-priority-dropdown\n            editable="false"\n            priority="{{task.priority}}"\n            />\n</td>\n<td>\n    <task-status-dropdown\n            editable="false"\n            status="{{task.status}}"\n            class="pull-right"\n            ></task-status-dropdown>\n    {{task.title}}\n    <br/>\n    <small class="text-muted"\n           resolve-story="task.story_id">\n        <a href="#!/story/{{story.id}}">\n            {{story.id}}: {{story.title}}</a>\n    </small>\n</td>')}]),angular.module("app/search/template/typeahead_criteria_item.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/search/template/typeahead_criteria_item.html",'<a ng-switch="match.model.type"\n   class="header-criteria-item">\n    <span ng-switch-when="Text">\n        <i class="fa fa-search text-muted"></i>&emsp;{{match.model.title}}\n    </span>\n    <span ng-switch-when="Story">\n        <i class="fa fa-sb-story text-muted"></i>&emsp;{{match.model.value}}:\n        {{match.model.title}}\n    </span>\n    <span ng-switch-when="StoryStatus">\n        <i class="fa fa-flag text-muted"></i>&emsp;Story Status:\n        {{match.model.title}}\n    </span>\n    <span ng-switch-when="Project">\n        <i class="fa fa-sb-project text-muted"></i>&emsp;{{match.model.title}}\n    </span>\n    <span ng-switch-when="User">\n        <i class="fa fa-sb-user text-muted"></i>&emsp;{{match.model.title}}\n    </span>\n    <span ng-switch-default>\n        <i class="fa fa-question text-muted"></i>&emsp;{{match.model.type}}\n    </span>\n</a>')}]),angular.module("app/search/template/user_search_item.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/search/template/user_search_item.html",'<td>{{user.full_name}}</td>\n<td class="text-right">\n    <span class="text-muted">Last Login:</span>\n    {{user.last_login | date: \'mediumDate\'}}\n</td>')}]),angular.module("app/stories/template/comments/story_created.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/stories/template/comments/story_created.html",'<div class="discussion-comment" ng-show="enabled_event_types.story_created">\n    <p class="discussion-comment-author">\n        <span time-moment eventdate="event.created_at" class="pull-right"></span>\n        <span>{{ author.full_name }} created this story.</span>\n    </p>\n</div>\n')}]),angular.module("app/stories/template/comments/story_details_changed.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/stories/template/comments/story_details_changed.html",'<div class="discussion-comment" ng-show="enabled_event_types.story_details_changed">\n    <p class="discussion-comment-author">\n        <span time-moment eventdate="event.created_at" class="pull-right"></span>\n        <span>{{ author.full_name }} updated this story.</span>\n    </p>\n</div>\n')}]),angular.module("app/stories/template/comments/task_assignee_changed.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/stories/template/comments/task_assignee_changed.html",'<div class="discussion-comment" ng-show="enabled_event_types.task_assignee_changed">\n    <p class="discussion-comment-author">\n        <span time-moment eventdate="event.created_at" class="pull-right"></span>\n        <span>{{author.full_name}} updated assignee for "{{ event_info.task_title }}":\n        {{ event_info.old_assignee_fullname }} ==> {{ event_info.new_assignee_fullname }}.</span>\n    </p>\n</div>\n')}]),angular.module("app/stories/template/comments/task_created.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/stories/template/comments/task_created.html",'<div class="discussion-comment" ng-show="enabled_event_types.task_created">\n    <p class="discussion-comment-author">\n        <span time-moment eventdate="event.created_at" class="pull-right"></span>\n        <span>{{ author.full_name }} created "{{ event_info.task_title }}".</span>\n    </p>\n</div>\n')}]),angular.module("app/stories/template/comments/task_deleted.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/stories/template/comments/task_deleted.html",'<div class="discussion-comment" ng-show="enabled_event_types.task_deleted">\n    <p class="discussion-comment-author">\n        <span time-moment eventdate="event.created_at" class="pull-right"></span>\n        <span>{{ author.full_name }} deleted "{{ event_info.task_title }}".</span>\n    </p>\n</div>\n')}]),angular.module("app/stories/template/comments/task_details_changed.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/stories/template/comments/task_details_changed.html",'<div class="discussion-comment" ng-show="enabled_event_types.task_details_changed">\n    <p class="discussion-comment-author">\n        <span time-moment eventdate="event.created_at" class="pull-right"></span>\n        <span>{{ author.full_name }} updated "{{ event_info.task_title }}".</span>\n    </p>\n</div>\n')}]),angular.module("app/stories/template/comments/task_priority_changed.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/stories/template/comments/task_priority_changed.html",'<div class="discussion-comment" ng-show="enabled_event_types.task_priority_changed">\n    <p class="discussion-comment-author">\n        <span time-moment eventdate="event.created_at" class="pull-right"></span>\n        <span>{{author.full_name}} updated "{{ event_info.task_title }}" priority:\n        {{ event_info.old_priority }} ==> {{ event_info.new_priority }}.</span>\n    </p>\n</div>\n')}]),angular.module("app/stories/template/comments/task_status_changed.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/stories/template/comments/task_status_changed.html",'<div class="discussion-comment" ng-show="enabled_event_types.task_status_changed">\n    <p class="discussion-comment-author">\n        <span time-moment eventdate="event.created_at" class="pull-right"></span>\n        <span>{{author.full_name}} updated "{{ event_info.task_title }}" status:\n        {{ event_info.old_status }} ==> {{ event_info.new_status }}.</span>\n    </p>\n</div>\n')}]),angular.module("app/stories/template/comments/template_switch.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/stories/template/comments/template_switch.html",'<div ng-switch="event_type">\n    <div ng-switch-when="story_created">\n        <div ng-include src="\'app/stories/template/comments/story_created.html\'"></div>\n    </div>\n    <div ng-switch-when="story_details_changed">\n        <div ng-include src="\'app/stories/template/comments/story_details_changed.html\'"></div>\n    </div>\n    <div ng-switch-when="task_assignee_changed">\n        <div ng-include src="\'app/stories/template/comments/task_assignee_changed.html\'"></div>\n    </div>\n    <div ng-switch-when="task_created">\n        <div ng-include src="\'app/stories/template/comments/task_created.html\'"></div>\n    </div>\n    <div ng-switch-when="task_deleted">\n        <div ng-include src="\'app/stories/template/comments/task_deleted.html\'"></div>\n    </div>\n    <div ng-switch-when="task_details_changed">\n        <div ng-include src="\'app/stories/template/comments/task_details_changed.html\'"></div>\n    </div>\n    <div ng-switch-when="task_status_changed">\n        <div ng-include src="\'app/stories/template/comments/task_status_changed.html\'"></div>\n    </div>\n    <div ng-switch-when="task_priority_changed">\n        <div ng-include src="\'app/stories/template/comments/task_priority_changed.html\'"></div>\n    </div>\n    <div ng-switch-when="user_comment">\n        <div ng-include src="\'app/stories/template/comments/user_comment.html\'"></div>\n    </div>\n    <div ng-switch-default>\n        <div class="discussion-comment">\n            <p class="discussion-comment-author">\n                An unknown event occurred.\n                <span time-moment eventdate="event.created_at" class="pull-right"></span>\n            </p>\n        </div>\n    </div>\n\n</div>\n')}]),angular.module("app/stories/template/comments/user_comment.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/stories/template/comments/user_comment.html",'<div class="discussion-comment" ng-show="enabled_event_types.user_comment">\n    <p class="discussion-comment-author">\n        {{ author.full_name }}\n        <span time-moment eventdate="event.created_at" class="pull-right"></span>\n    </p>\n\n    <p ng-show="event.comment.content"\n       class="honor-carriage-return">{{event.comment.content}}\n    </p>\n\n    <p><em ng-hide="event.comment.content"\n           class="text-muted">\n        The author left a blank comment.\n    </em></p>\n</div>\n')}]),angular.module("app/stories/template/delete.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/stories/template/delete.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~         http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n<div class="panel panel-default">\n    <div class="panel-heading">\n        <button type="button" class="close" aria-hidden="true"\n                ng-click="close()">&times;</button>\n        <h3 class="panel-title">{{story.title}}</h3>\n    </div>\n    <div class="panel-body">\n        <div class="row">\n            <div class="col-sm-8 col-sm-offset-2">\n                <h2 class="text-danger text-center">\n                    Are you certain that you want to delete this story?\n                </h2>\n\n                <p class="text-center lead">\n                    This action cannot be undone.\n                </p>\n\n                <div class="text-center">\n                    <a href="" class="btn btn-danger" ng-click="remove()">\n                        Remove this story\n                    </a>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>')}]),angular.module("app/stories/template/delete_task.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/stories/template/delete_task.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~         http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n<div class="panel panel-default">\n    <div class="panel-heading">\n        <button type="button" class="close" aria-hidden="true"\n                ng-click="close()">&times;</button>\n        <h3 class="panel-title">{{task.title}}</h3>\n    </div>\n    <div class="panel-body">\n        <div class="row">\n            <div class="col-sm-8 col-sm-offset-2">\n                <h2 class="text-danger text-center">\n                    Are you certain that you want to delete this task?\n                </h2>\n\n                <p class="text-center lead">\n                    This action cannot be undone.\n                </p>\n\n                <div class="text-center">\n                    <a href="" class="btn btn-danger" ng-click="remove()">\n                        Remove this task\n                    </a>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>')}]),angular.module("app/stories/template/detail.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/stories/template/detail.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~         http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<div class="container" ng-controller="StoryDetailController">\n    <div class="row">\n        <div class="col-xs-12">\n            <div ng-include\n                 src="\'/inline/story_detail.html\'"\n                 ng-hide="showEditForm">\n            </div>\n            <div ng-include\n                 src="\'/inline/story_detail_form.html\'"\n                 ng-show="showEditForm">\n            </div>\n            <div ng-include src="\'/inline/task_list.html\'"></div>\n            <hr/>\n            <div ng-include src="\'/inline/discussion.html\'"></div>\n        </div>\n    </div>\n</div>\n\n\n<!-- Template for the header and description -->\n<script type="text/ng-template" id="/inline/story_detail.html">\n    <h1>\n\n        <span ng-show="story.title">\n            {{story.title}}\n        </span>\n        <em ng-hide="story.title" class="text-muted">\n            No title\n        </em>\n        <small ng-show="isLoggedIn">\n            <a href="" ng-click="toggleEditMode()" >\n                <i class="fa fa-pencil"></i>\n            </a>\n        </small>\n    </h1>\n    <p><strong>Author:</strong>\n        <em ng-show="!story.creator_id" class="text-muted">\n            None\n        </em>\n        <span ng-show="story.creator_id && !creator.$resolved">\n            <i class="fa fa-refresh fa-spin"></i>\n        </span>\n        <span ng-show="creator.full_name">\n            {{creator.full_name}}\n        </span>\n        <br/>\n        <strong>Last updated:</strong>\n        <span time-moment eventdate="story.created_at"  ng-if="!story.updated_at"></span>\n        <span time-moment eventdate="story.updated_at" ng-if="story.updated_at"></span>\n        <em ng-hide="story.updated_at || story.created_at" class="text-muted">\n            Never\n        </em>\n    </p>\n    <p>\n        <span ng-show="story.description"\n              class="honor-carriage-return">{{story.description}}\n        </span>\n        <em ng-hide="story.description" class="text-muted">\n            No description provided\n        </em>\n    </p>\n</script>\n\n\n<!-- Template for the header and description -->\n<script type="text/ng-template" id="/inline/story_detail_form.html">\n    <form name="storyForm">\n        <div class="form-group">\n            <textarea type="text"\n                      class="form-control context-edit h1"\n                      ng-model="story.title"\n                      required\n                      ng-disabled="isUpdating"\n                      placeholder="Story Title">\n            </textarea>\n        </div>\n        <div class="form-group">\n            <textarea placeholder="Enter a story description here"\n                      class="form-control context-edit"\n                      msd-elastic\n                      rows="3"\n                      required\n                      ng-disabled="isUpdating"\n                      ng-model="story.description">\n            </textarea>\n        </div>\n\n        <div class="clearfix">\n            <div class="pull-right">\n                <div class="btn" ng-show="isUpdating">\n                    <i class="fa fa-spinner fa-lg fa-spin"></i>\n                </div>\n                <button type="button"\n                        class="btn btn-primary"\n                        ng-click="update()"\n                        ng-disabled="!storyForm.$valid">\n                    Save\n                </button>\n                <button type="button"\n                        class="btn btn-default"\n                        ng-click="cancel()">\n                    Cancel\n                </button>\n            </div>\n            <button type="button"\n                    class="btn btn-link"\n                    ng-click="remove()">\n                Remove this story\n            </button>\n        </div>\n    </form>\n</script>\n\n\n<!-- Template for the task list -->\n<script type="text/ng-template" id="/inline/task_list.html">\n    <table class="table table-striped"\n           ng-controller="StoryTaskListController">\n        <thead>\n        <tr>\n            <td colspan="3"><strong>Tasks</strong></td>\n            <td colspan="3" class="text-right">\n                <small>\n                    <a href=""\n                       ng-click="showAddTaskForm = !showAddTaskForm"\n                       ng-show="isLoggedIn">\n                        <i class="fa fa-plus"></i>\n                        Add task\n                    </a>\n                </small>\n            </td>\n        </tr>\n        </thead>\n        <tbody>\n        <tr ng-repeat="task in tasks"\n            ng-include\n            src="\'/inline/task_list_item.html\'"\n            ng-controller="StoryTaskListItemController">\n        </tr>\n        <tr ng-show="tasks.length == 0 && !showAddTaskForm">\n            <td colspan="6">\n                <p class="text-muted text-center">\n                    <em>This story has no tasks.</em>\n                </p>\n            </td>\n        </tr>\n        </tbody>\n        <tfoot ng-show="showAddTaskForm">\n        <tr>\n            <td></td>\n            <td colspan="3">\n                <task-edit-form\n                        task="newTask"\n                        button-label="Add Task"\n                        on-button-click="addTask()"\n                        />\n            </td>\n            <td colspan="2"></td>\n        </tr>\n        </tfoot>\n\n    </table>\n</script>\n\n\n<!-- Template for the task list -->\n<script type="text/ng-template" id="/inline/discussion.html">\n    <div ng-controller="StoryDiscussionController">\n        <h4>Events timeline\n            <a href ng-click="updateFilter()"><i class="fa fa-gear"></i></a>\n        </h4>\n        <div class="discussion">\n            <div class="alert alert-warning"\n                 ng-show="comments.length == 0">\n                The discussion hasn\'t started yet\n            </div>\n            <div ng-repeat="event in events"\n                 ng-controller="StoryDiscussionItemController">\n                <timeline-event tl_event={{event}} />\n            </div>\n\n            <form class="discussion-comment-form comment"\n                  id="commentForm"\n                  name="commentForm"\n                  ng-show="isLoggedIn">\n                <div class="form-group">\n                    <textarea id="comment"\n                              placeholder="Enter your comment here"\n                              class="form-control"\n                              msd-elastic\n                              rows="3"\n                              required\n                              ng-disabled="isSavingComment"\n                              ng-shift-enter="addComment()"\n                              ng-model="newComment.content">\n                    </textarea>\n                </div>\n                <div class="form-group clearfix">\n                    <button type="button"\n                            class="btn btn-primary pull-right"\n                            ng-click="addComment()"\n                            ng-disabled="!commentForm.$valid || isSavingComment">\n                        Comment\n                    </button>\n                </div>\n            </form>\n        </div>\n    </div>\n</script>\n\n<!-- Template for an item in the task list -->\n<script type="text/ng-template" id="/inline/task_list_item.html">\n    <td ng-show="isLoggedIn">\n        <a href=""\n           ng-click="showTaskEditForm = true"\n           ng-hide="showTaskEditForm">\n            <i class="fa fa-caret-right fa-lg"></i>\n        </a>\n        <a href=""\n           ng-click="showTaskEditForm = false"\n           ng-show="showTaskEditForm">\n            <i class="fa fa-caret-down fa-lg"></i>\n        </a>\n    </td>\n    <td ng-hide="showTaskEditForm">\n        <a href=""\n           ng-show="isLoggedIn"\n           ng-click="showTaskEditForm = true">\n            {{task.title}}\n        </a>\n        <span ng-hide="isLoggedIn">\n            {{task.title}}\n        </span>\n    </td>\n    <td ng-hide="showTaskEditForm">\n        <a href=""\n           ng-click="showTaskEditForm = true"\n           ng-show="isLoggedIn">\n            <span ng-show="project">\n                {{project.name}}\n            </span>\n            <em class="text-muted" ng-hide="project">\n                Project not found\n            </em>\n        </a>\n        <span ng-hide="isLoggedIn">\n            <span ng-show="project">\n                {{project.name}}\n            </span>\n            <em class="text-muted" ng-hide="project">\n                Project not found\n            </em>\n        </span>\n    </td>\n    <td ng-hide="showTaskEditForm">\n        <span ng-show="assignee">\n            {{assignee.full_name}}\n        </span>\n        <em class="text-muted" ng-hide="assignee">\n            Not assigned\n        </em>\n    </td>\n    <td ng-show="showTaskEditForm"\n        colspan="3">\n        <task-edit-form\n                task="task"\n                on-button-click="updateTask()"\n                button-label="Update"\n                />\n    </td>\n    <td class="text-right">\n        <task-priority-dropdown\n                editable="{{isLoggedIn}}"\n                on-change="updatePriority(priority)"\n                priority="{{task.priority}}"\n                />\n    </td>\n    <td class="text-right">\n        <task-status-dropdown\n                editable="{{isLoggedIn}}"\n                on-change="updateStatus(status)"\n                status="{{task.status}}"\n                />\n    </td>\n    <td class="text-right">\n        <a ng-show="isLoggedIn"\n           ng-click="removeTask()">\n            <i class="fa fa-times fa-lg"></i>\n        </a>\n    </td>\n</script>\n\n<!-- Template for story metadata -->\n<script type="text/ng-template" id="/inline/metadata.html">\n\n</script>\n')
}]),angular.module("app/stories/template/list.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/stories/template/list.html",'<!--\n  ~ Copyright (c) 2014 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ 	http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n<div class="container"\n     ng-controller="SearchCriteriaController"\n     ng-init="init(resourceTypes, defaultCriteria)"\n     search-results\n     search-resource="Story"\n     search-criteria="criteria"\n     search-sort-field="sortField"\n     search-sort-direction="sortDirection">\n    <div class="row">\n        <div class="col-xs-12">\n            <h1><i class="fa fa-sb-story"></i> Stories</h1>\n        </div>\n    </div>\n\n    <div class="row">\n        <div class="col-lg-9 col-sm-8 col-xs-10">\n            <div class="form-group has-feedback has-feedback-no-label">\n                <div id="search-criteria"\n                     tag-complete="criteria as criteria.title for criteria in searchForCriteria($viewValue)"\n                     tag-complete-tags="criteria"\n                     tag-complete-label-field="title"\n                     tag-complete-option-template-url="\'app/search/template/typeahead_criteria_item.html\'"\n                     tag-complete-tag-template-url="\'app/search/template/criteria_tag_item.html\'"\n                     tag-complete-loading="loadingCriteria = isLoading"\n                     tag-complete-on-select="addCriteria(tag)"\n                     placeholder="Search Stories">\n                </div>\n                <span class="form-control-feedback text-muted">\n                    <i class="fa fa-search"\n                       ng-hide="loadingCriteria"></i>\n                    <i class="fa fa-refresh fa-spin"\n                       ng-show="loadingCriteria"></i>\n                </span>\n            </div>\n        </div>\n        <div class="col-lg-1 col-sm-2 hidden-xs">\n            <div class="form form-horizontal">\n                <p class="form-control-static text-muted">\n                    ({{searchResults.length}} found)\n                </p>\n            </div>\n        </div>\n        <div class="col-xs-2">\n            <button class="btn btn-primary pull-right"\n                    ng-click="newStory()">\n                <i class="fa fa-plus"></i>\n                <span class="hidden-xs">Create Story</span>\n            </button>\n        </div>\n    </div>\n\n    <div class="row"\n         ng-if="criteria.length == 0">\n        <div class="col-xs-12 text-muted text-center">\n            <hr/>\n            <em>What would you like to search by?</em>\n        </div>\n    </div>\n\n    <div class="row" ng-if="criteria.length > 0">\n        <div class="col-xs-12" ng-if="hasValidCriteria">\n            <br/>\n        </div>\n        <div class="col-xs-12" ng-if="hasValidCriteria">\n            <table class="table table-condensed table-striped">\n                <thead>\n                <tr>\n                    <th>\n                        <a ng-click="toggleFilter(\'title\')">\n                            Story\n                            <i class="fa fa-caret-down"\n                               ng-if="sortField == \'title\' && sortDirection == \'desc\'">\n                            </i>\n                            <i class="fa fa-caret-up"\n                               ng-if="sortField == \'title\' && sortDirection == \'asc\'">\n                            </i>\n                        </a>\n                    </th>\n                    <th>\n                        <a ng-click="toggleFilter(\'created_at\')">\n                            Created\n                            <i class="fa fa-caret-down"\n                               ng-if="sortField == \'created_at\' && sortDirection == \'desc\'">\n                            </i>\n                            <i class="fa fa-caret-up"\n                               ng-if="sortField == \'created_at\' && sortDirection == \'asc\'">\n                            </i>\n                        </a>\n                    </th>\n                    <th>\n                        <a ng-click="toggleFilter(\'updated_at\')">\n                            Updated\n                            <i class="fa fa-caret-down"\n                               ng-if="sortField == \'updated_at\' && sortDirection == \'desc\'">\n                            </i>\n                            <i class="fa fa-caret-up"\n                               ng-if="sortField == \'updated_at\' && sortDirection == \'asc\'">\n                            </i>\n                        </a>\n                    </th>\n                    <th class="text-right">\n                        <a ng-click="toggleFilter(\'status\')">\n                            Status\n                            <i class="fa fa-caret-down"\n                               ng-if="sortField == \'status\' && sortDirection == \'desc\'">\n                            </i>\n                            <i class="fa fa-caret-up"\n                               ng-if="sortField == \'status\' && sortDirection == \'asc\'">\n                            </i>\n                        </a>\n                    </th>\n                </tr>\n                </thead>\n                <tbody ng-if="searchResults.length != 0">\n                <tr ng-repeat="story in searchResults"\n                    ng-include="\'app/search/template/story_search_item.html\'">\n                </tr>\n                </tbody>\n\n                <tbody ng-if="hasValidCriteria &amp;&amp; searchResults.length == 0 &amp;&amp; !isSearching">\n                <td class="text-center text-muted" colspan="4">\n                    <em>No stories found.</em>\n                </td>\n                </tbody>\n\n                <tbody ng-if="!hasValidCriteria">\n                <td class="text-center text-muted" colspan="4">\n                    <em>Your search criteria are not valid for this item.</em>\n                </td>\n                </tbody>\n\n                <tbody ng-if="isSearching">\n                <td colspan="4">\n                    <small class="fa fa-spin fa-refresh text-muted">\n                    </small>\n                </td>\n                </tbody>\n            </table>\n        </div>\n    </div>\n</div>\n')}]),angular.module("app/stories/template/new.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/stories/template/new.html",'<div class="panel panel-default">\n    <div class="panel-heading">\n        <button type="button" class="close" aria-hidden="true"\n                ng-click="close()">&times;</button>\n        <h3 class="panel-title">New Story</h3>\n    </div>\n    <div class="panel-body">\n        <div class="row">\n            <div class="col-xs-12">\n                <form class="form-horizontal" role="form" name="storyForm">\n                    <div class="form-group">\n                        <label for="name" class="col-sm-2 control-label">\n                            Title:\n                        </label>\n\n                        <div class="col-sm-10">\n                            <input id="name"\n                                   focus\n                                   type="text"\n                                   class="form-control"\n                                   ng-model="story.title"\n                                   required\n                                   placeholder="Story Title">\n                        </div>\n                    </div>\n                    <div class="form-group">\n                        <label for="description"\n                               class="col-sm-2 control-label">\n                            Description\n                        </label>\n\n                        <div class="col-sm-10">\n                            <textarea id="description"\n                                      class="form-control"\n                                      ng-model="story.description"\n                                      msd-elastic\n                                      required\n                                      placeholder="A brief story description">\n                            </textarea>\n                        </div>\n                    </div>\n                </form>\n            </div>\n        </div>\n        <div class="row">\n            <div class="col-xs-12">\n                <form role="form" name="tasksForm">\n                    <table class="table table-striped table-outlined">\n                        <tbody>\n                        <tr ng-repeat="(index, task) in tasks" ng-include\n                                src="\'/inline/task_row.html\'">\n                        </tr>\n                        </tbody>\n                    </table>\n                </form>\n            </div>\n        </div>\n        <div class="row">\n            <div class="col-xs-6">\n                <button type="button"\n                        class="btn btn-default"\n                        ng-click="addTask()">\n                    &plus;\n                    Add another task\n                </button>\n            </div>\n            <div class="col-xs-6 text-right">\n                <button type="button"\n                        class="btn btn-primary"\n                        ng-click="save()"\n                        ng-disabled="!storyForm.$valid || !tasksForm.$valid">\n                    Save Changes\n                </button>\n                <button type="button"\n                        ng-click="close()"\n                        class="btn btn-default">\n                    Cancel\n                </button>\n            </div>\n        </div>\n    </div>\n</div>\n\n<!-- Template for story metadata -->\n<script type="text/ng-template" id="/inline/task_row.html">\n    <td>\n        <input type="text"\n               class="form-control input-sm"\n               ng-model="task.title"\n               required\n               placeholder="Task Title">\n    </td>\n    <td class="col-xs-4">\n        <div class="has-feedback has-feedback-no-label">\n            <input id="project"\n                   type="text"\n                   placeholder="Select a Project"\n                   required\n                   ng-model="asyncProject"\n                   typeahead-editable="false"\n                   typeahead="project as project.name for project\n                   in searchProjects($viewValue)"\n                   typeahead-loading="loadingProjects"\n                   typeahead-input-formatter="formatProjectName($model)"\n                   typeahead-on-select="selectNewProject($model, task)"\n                   class="form-control input-sm"\n                    />\n            <span class="form-control-feedback text-muted\n            form-control-feedback-sm">\n                <i class="fa fa-refresh fa-spin" ng-show="loadingProjects"></i>\n                <i class="fa fa-search" ng-hide="loadingProjects"></i>\n            </span>\n        </div>\n    </td>\n    <th class="col-xs-1"\n        ng-show="tasks.length > 1">\n        <button type="button" class="close"\n                ng-click="removeTask(task)">\n            &times;\n        </button>\n    </th>\n</script>\n')}]),angular.module("app/stories/template/story_list_item.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/stories/template/story_list_item.html",'<td style="white-space: nowrap">\n    <a href=""\n       ng-click="expandRow = !expandRow">\n        <i class="fa fa-caret-down"\n           ng-show="expandRow"></i>\n        <i class="fa fa-caret-right"\n           ng-hide="expandRow"></i>\n    </a>&nbsp;\n    <strong>\n        <a href="#!/story/{{story.id}}">\n            {{story.id}}\n        </a>\n    </strong>\n</td>\n<td>\n    <p>\n        <strong>\n            <a href="#!/story/{{story.id}}">\n                {{story.title}}\n            </a>\n        </strong>\n        <br/>\n        <small class="text-muted honor-carriage-return"\n               ng-show="expandRow">{{story.description}}\n        </small>\n    </p>\n</td>\n<td class="text-right">\n    <p class="label {{statusLabelStyle}}"\n       ng-click="expandRow = !expandRow">\n        <i class="fa fa-caret-down"\n           ng-show="expandRow"></i>\n        <i class="fa fa-caret-right"\n           ng-hide="expandRow"></i>\n        {{story.status | capitalize}}\n    </p>\n    <table ng-show="expandRow"\n           class="table table-clean table-supercondensed">\n        <tr>\n            <th>\n                <small>Todo:</small>\n            </th>\n            <td>\n                <strong>\n                    <small>{{story.todo || 0}}</small>\n                </strong>\n            </td>\n        </tr>\n        <tr class="text-info">\n            <th>\n                <small>Progress:</small>\n            </th>\n            <td>\n                <strong>\n                    <small>{{story.inprogress || 0}}</small>\n                </strong>\n            </td>\n        </tr>\n        <tr class="text-warning">\n            <th>\n                <small>Review:</small>\n            </th>\n            <td>\n                <strong>\n                    <small>{{story.review || 0}}</small>\n                </strong>\n            </td>\n        </tr>\n        <tr class="text-success">\n            <th>\n                <small>Merged:</small>\n            </th>\n            <td>\n                <strong>\n                    <small>{{story.merged || 0}}</small>\n                </strong>\n            </td>\n        </tr>\n        <tr class="text-muted">\n            <th>\n                <small>Invalid:</small>\n            </th>\n            <td>\n                <strong>\n                    <small>{{story.invalid || 0}}</small>\n                </strong>\n            </td>\n        </tr>\n    </table>\n</td>')}]),angular.module("app/stories/template/task_edit_form.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/stories/template/task_edit_form.html",'<form name="taskForm">\n    <div class="form-group">\n        <label for="title">Task Summary:</label>\n        <textarea\n                id="title"\n                name="title"\n                ng-model="task.title"\n                required\n                maxlength="255"\n                placeholder="Describe the specifics of your task here"\n                class="form-control input-sm">\n        </textarea>\n    </div>\n    <div class="form-group has-feedback">\n        <label for="project">Affected Project:</label>\n        <input id="project"\n               type="text"\n               ng-model="asyncProject"\n               typeahead-editable="false"\n               typeahead="project as project.name for project in searchProjects($viewValue)"\n               typeahead-loading="loadingProjects"\n               typeahead-input-formatter="formatProjectName($model)"\n               typeahead-on-select="selectNewProject($model)"\n               class="form-control input-sm"\n                />\n        <span class="form-control-feedback text-muted form-control-feedback-sm">\n            <i class="fa fa-refresh fa-spin" ng-show="loadingProjects"></i>\n            <i class="fa fa-search" ng-hide="loadingProjects"></i>\n        </span>\n    </div>\n    <div class="form-group has-feedback">\n        <label for="assignee">Assigned To:</label>\n        <input id="assignee"\n               type="text"\n               ng-model="asyncUser"\n               placeholder="Choose a user."\n               typeahead-editable="false"\n               typeahead="user as user.full_name for user in searchUsers($viewValue)"\n               typeahead-loading="loadingUsers"\n               typeahead-input-formatter="formatUserName($model)"\n               typeahead-on-select="selectNewUser($model)"\n               class="form-control input-sm"\n                />\n        <span class="form-control-feedback text-muted form-control-feedback-sm">\n            <i class="fa fa-refresh fa-spin" ng-show="loadingUsers"></i>\n            <i class="fa fa-search" ng-hide="loadingUsers"></i>\n        </span>\n    </div>\n    <div class="form-group has-feedback">\n        <label for="priority">Priority:</label>\n        <select id="priority"\n                class="form-control input-sm"\n                ng-model="task.priority">\n            <option value="high">High</option>\n            <option value="medium">Medium</option>\n            <option value="low">Low</option>\n        </select>\n    </div>\n    <div class="form-group">\n        <div class="clearfix">\n            <div class="pull-right">\n                <div class="btn" ng-show="isUpdating">\n                    <i class="fa fa-spinner fa-lg fa-spin"></i>\n                </div>\n                <button type="button"\n                        class="btn btn-primary"\n                        ng-click="onButtonClick({})"\n                        ng-disabled="!taskForm.$valid">\n                    {{buttonLabel}}\n                </button>\n            </div>\n        </div>\n    </div>\n</form>\n</form>')}]),angular.module("app/stories/template/update_filter.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/stories/template/update_filter.html",'<div class="panel panel-default">\n    <div class="panel-heading">\n        <button type="button" class="close" aria-hidden="true"\n                ng-click="close()">&times;</button>\n        <h3 class="panel-title">Update Timeline filter</h3>\n    </div>\n    <div class="panel-body">\n        <div class="row">\n            <div class="col-xs-12">\n                <form class="form-horizontal" role="form" name="fiterForm">\n                    <div class="form-group col-sm-10">\n                        <label>Timeline events</label>\n\n                        <p class="help-block">\n                            Which types of Timeline events would you like to be\n                            displayed?\n                        </p>\n                    </div>\n                    <div class="form-group col-sm-10">\n\n                        <input type="checkbox" name="enabledTypes"\n                               id="storyCreated"\n                               ng-model="enabled_event_types.story_created">\n                        <label for="storyCreated">Story created</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="storyDetailsChanged"\n                               ng-model="enabled_event_types.story_details_changed">\n                        <label for="storyDetailsChanged">Story details changed</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="taskCreated"\n                               ng-model="enabled_event_types.task_created">\n                        <label for="taskCreated">Task created</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="taskAssigneeChanged"\n                               ng-model="enabled_event_types.task_assignee_changed">\n                        <label for="taskAssigneeChanged">Task assignee changed</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="taskStatusChanged"\n                               ng-model="enabled_event_types.task_status_changed">\n                        <label for="taskStatusChanged">Task status changed</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="taskDetailsChanged"\n                               ng-model="enabled_event_types.task_details_changed">\n                        <label for="taskDetailsChanged">Task details changed</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="taskDeleted"\n                               ng-model="enabled_event_types.task_deleted">\n                        <label for="taskDeleted">Task deleted</label>\n                        <br/>\n                        <input type="checkbox" name="enabledTypes"\n                               id="userComment"\n                               ng-model="enabled_event_types.user_comment">\n                        <label for="userComment">User comment</label>\n                    </div>\n                </form>\n            </div>\n        </div>\n\n        <div class="row">\n            <div class="col-xs-6 text-right">\n                <button type="button"\n                        class="btn btn-primary"\n                        ng-click="save()">\n                    Save Changes\n                </button>\n                <button type="button"\n                        ng-click="close()"\n                        class="btn btn-default">\n                    Cancel\n                </button>\n            </div>\n        </div>\n    </div>\n</div>')}]),angular.module("app/storyboard/template/header_menu.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/storyboard/template/header_menu.html",'<!--\n  ~ Copyright (c) 2013 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ 	http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<nav class="navbar navbar-default navbar-fixed-top"\n     role="navigation">\n    <div class="container-fluid visible-xs"\n         ng-include\n         src="\'/inline/header_mobile.html\'">\n    </div>\n    <div class="container-fluid hidden-xs"\n         ng-include\n         src="\'/inline/header_regular.html\'">\n    </div>\n</nav>\n\n<!-- The menu for regular sized screens -->\n<script type="text/ng-template" id="/inline/header_regular.html">\n    <div ng-controller="HeaderController">\n\n        <div class="navbar-header">\n            <a class="navbar-brand" href="#!/">\n                <i class="icon icon_storyboard fa-lg"></i>\n                StoryBoard\n            </a>\n        </div>\n\n        <ul class="nav navbar-nav">\n            <li>&nbsp;&nbsp;</li>\n            <li>\n                <button type="button"\n                        class="btn btn-primary navbar-btn"\n                        ng-click="newStory()">\n                    <i class="fa fa-plus-circle"></i>\n                    New Story\n                </button>\n            </li>\n        </ul>\n\n        <ul class="nav navbar-nav navbar-right">\n            <li ng-hide="isLoggedIn">\n                <a href="#!/auth/authorize">\n                    <i class="fa fa-sign-in"></i>\n                    Login\n                </a>\n            </li>\n            <li class="dropdown" ng-show="isLoggedIn">\n                <a href="#" class="dropdown-toggle" data-toggle="dropdown">\n                <span ng-show="currentUser.$resolved">\n                    {{currentUser.full_name}}\n                </span>\n                    <em class="text-muted"\n                        ng-hide="currentUser.$resolved">\n                        Loading...\n                    </em>\n                    <i class="fa fa-caret-down"></i>\n                </a>\n                <ul class="dropdown-menu">\n                    <li>\n                        <a href="#!/auth/deauthorize">\n                            <i class="fa fa-sign-out"></i>\n                            Logout\n                        </a>\n                    </li>\n                </ul>\n            </li>\n        </ul>\n\n        <form class="navbar-form navbar-right" role="search">\n            <div class="form-group has-feedback">\n                <input type="text"\n                       class="form-control"\n                       placeholder="Search"\n                       ng-model="searchString"\n                       typeahead-append-to-body="true"\n                       typeahead-editable="false"\n                       typeahead="criteria as criteria.title for criteria in quickSearch($viewValue)"\n                       typeahead-loading="headerCriteriaLoading"\n                       typeahead-on-select="search($model)"\n                       typeahead-template-url="app/search/template/typeahead_criteria_item.html"\n                       />\n            <span class="form-control-feedback text-muted">\n                <i class="fa fa-search" ng-hide="headerCriteriaLoading"></i>\n                <i class="fa fa-spin fa-refresh"\n                   ng-show="headerCriteriaLoading"></i>\n            </span>\n            </div>\n        </form>\n    </div>\n</script>\n\n\n<!-- The menu for xs sized screens -->\n<script type="text/ng-template" id="/inline/header_mobile.html">\n    <div ng-controller="HeaderController">\n        <div class="navbar-header">\n            <button type="button"\n                    class="btn btn-sm btn-primary navbar-btn pull-right"\n                    data-toggle="collapse"\n                    data-target="#mobile-dropdown-menu"\n                    ng-show="isLoggedIn">\n                <i class="fa fa-gear"></i>\n            </button>\n            <a href="#!/auth/authorize"\n               class="btn btn-sm btn-primary navbar-btn pull-right"\n               ng-hide="isLoggedIn">\n                <i class="fa fa-sign-in"></i>\n            </a>\n            <a href="#" ng-click="newStory()"\n               class="btn btn-sm btn-primary navbar-btn">\n                <i class="fa fa-plus-circle"></i>\n                New Story\n            </a>\n            <a class="navbar-brand" href="#!/">StoryBoard</a>\n        </div>\n\n        <div class="collapse navbar-collapse" id="mobile-dropdown-menu">\n            <ul class="nav navbar-nav">\n                <li active-path="^\\/profile\\/preferences*">\n                    <a href="#!/profile/preferences">\n                        <i class="fa fa-user"></i>\n                        <span ng-show="currentUser.$resolved">\n                            {{currentUser.full_name}}\n                        </span>\n                        <em class="text-muted"\n                            ng-hide="currentUser.$resolved">\n                            Loading...\n                        </em>\n                    </a>\n                </li>\n                <li class="divider"></li>\n                <li><a href="#!/auth/deauthorize">\n                    <i class="fa fa-sign-out"></i>\n                    Logout\n                </a></li>\n            </ul>\n        </div>\n    </div>\n</script>')}]),angular.module("app/storyboard/template/side_menu.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/storyboard/template/side_menu.html",'<!--\n  ~ Copyright (c) 2013 Hewlett-Packard Development Company, L.P.\n  ~\n  ~ Licensed under the Apache License, Version 2.0 (the "License"); you may\n  ~ not use this file except in compliance with the License. You may obtain\n  ~ a copy of the License at\n  ~\n  ~ 	http://www.apache.org/licenses/LICENSE-2.0\n  ~\n  ~ Unless required by applicable law or agreed to in writing, software\n  ~ distributed under the License is distributed on an "AS IS" BASIS, WITHOUT\n  ~ WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the\n  ~ License for the specific language governing permissions and limitations\n  ~ under the License.\n  -->\n\n<nav class="navbar navbar-inverse navbar-fixed-side\n        navbar-fixed-side-header-offset"\n     role="navigation"\n     ng-class="{\'navbar-fixed-side-has-submenu\': hasSubmenu}">\n    <div class="nav-main">\n        <ul class="nav nav-pills nav-stacked text-center">\n            <li active-path="^\\/search.*">\n                <a href="#!/search">\n                    <i class="fa fa-search fa-lg visible-sm visible-xs"></i>\n                    <i class="fa fa-search fa-3x visible-lg visible-md"></i>\n                    <small class="visible-lg visible-md">Search</small>\n                </a>\n            </li>\n            <li class="nav-divider"></li>\n            <li active-path="^\\/(dashboard)?$">\n                <a href="#!/">\n                    <i class="fa fa-dashboard fa-lg visible-sm visible-xs"></i>\n                    <i class="fa fa-dashboard fa-3x visible-lg visible-md"></i>\n                    <small class="visible-lg visible-md">Dashboard</small>\n                </a>\n            </li>\n            <li active-path="^\\/project\\/*">\n                <a href="#!/project">\n                    <i class="fa fa-sb-project fa-lg visible-sm visible-xs"></i>\n                    <i class="fa fa-sb-project fa-3x visible-lg visible-md"></i>\n                    <small class="visible-lg visible-md">Projects</small>\n                </a>\n            </li>\n            <li active-path="^\\/story.*">\n                <a href="#!/story">\n                    <i class="fa fa-sb-story fa-lg visible-sm visible-xs"></i>\n                    <i class="fa fa-sb-story fa-3x visible-lg visible-md"></i>\n                    <small class="visible-lg visible-md">Stories</small>\n                </a>\n            </li>\n            <li class="nav-divider" ng-if="isLoggedIn"></li>\n            <li active-path="^\\/profile.*" ng-if="isLoggedIn">\n                <a href="#!/profile">\n                    <i class="fa fa-sb-profile fa-lg visible-sm visible-xs"></i>\n                    <i class="fa fa-sb-profile fa-3x visible-lg visible-md"></i>\n                    <small class="visible-lg visible-md">Profile</small>\n                </a>\n            </li>\n            <li active-path="^\\/admin.*" permission="is_superuser">\n                <a href="#!/admin">\n                    <i class="fa fa-sb-admin fa-lg visible-sm visible-xs"></i>\n                    <i class="fa fa-sb-admin fa-3x visible-lg visible-md"></i>\n                    <small class="visible-lg visible-md">Admin</small>\n                </a>\n            </li>\n        </ul>\n        <ul class="list-unstyled nav-bottom visible-md visible-lg">\n            <li active-path="^\\/page\\/about.*$">\n                <a href="#!/page/about">\n                    <i class="fa fa-question-circle visible-xs"></i>\n                    <small class="hidden-xs">About</small>\n                </a>\n            </li>\n            <li>\n                <a href="http://www.apache.org/licenses/LICENSE-2.0"\n                   target="_blank">\n                    <i class="fa fa-exclamation-circle visible-xs"></i>\n                    <small class="hidden-xs">License</small>\n                </a>\n            </li>\n        </ul>\n    </div>\n    <div ui-view="submenu"\n         class="nav-submenu">\n    </div>\n</nav>')
}]),angular.module("app/util/template/story_status_label.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/util/template/story_status_label.html",'<span class="label {{labelStyle}}" ng-show="!!story">\n    {{story.status | capitalize}}\n</span>')}]),angular.module("app/util/template/story_task_status.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/util/template/story_task_status.html",'<small>\n<span class="badge"\n      ng-class="{\'badge-primary\': story.todo  > 0}">\n    {{story.todo}}\n</span> ToDo\n    &nbsp;\n<span class="badge"\n      ng-class="{\'badge-primary\': story.inprogress  > 0}">\n    {{story.inprogress}}\n</span> In Progress\n    &nbsp;\n<span class="badge"\n      ng-class="{\'badge-primary\': story.review  > 0}">\n    {{story.review}}\n</span> In Review\n    &nbsp;\n<span class="badge"\n      ng-class="{\'badge-primary\': story.merged  > 0}">\n    {{story.merged}}\n</span> Merged\n    &nbsp;\n<span class="badge"\n      ng-class="{\'badge-primary\': story.invalid  > 0}">\n    {{story.invalid}}\n</span> Invalid\n</small>')}]),angular.module("app/util/template/tag_complete.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/util/template/tag_complete.html",'<div class="tag-complete"\n     ng-class="{\'focused\': hasFocus}">\n    <div class="form-control tag-input"\n         ng-click="focus()">\n        <span ng-repeat="tag in tagCompleteTags track by $index"\n              ng-click="noFocus($event)">\n            <div tag-complete-tag\n                 index="$index"\n                 tag="tag"\n                 label-field="tagCompleteLabelField"\n                 template-url="tagCompleteTagTemplateUrl"\n                 remove-tag="removeTag(tag)">\n            </div>\n            <span ng-include="getTemplateUrl()"></span>\n        </span>\n        <input name="tagInputField"\n               type="text"\n               class="tag-input"\n               autoresize-width\n               ng-delete="deletePressed()"\n               ng-model="newTagName">\n        </input>\n    </div>\n    <div typeahead-popup\n         matches="matches"\n         active="activeIdx"\n         position="position"\n         template-url="{{tagCompleteOptionTemplateUrl}}"\n         select="select(activeIdx)">\n    </div>\n\n    <!-- Default tag template -->\n    <script type="text/ng-template"\n            id="/tag_complete/default_tag_template.html">\n        <div class="tag">\n            {{tag[labelField]}}\n            <a class="tag-remove"\n               ng-click="removeTag({tag:tag})">\n                &times;\n            </a>\n        </div>\n    </script>\n</div>\n')}]),angular.module("app/util/template/tag_input.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/util/template/tag_input.html",'<div class="form-control tag-input" ng-click="focus()">\n    <div class="tag" ng-repeat="tag in selectedTags"\n         ng-click="noFocus($event)">\n        {{tag}}\n        <a class="tag-remove" ng-click="removeTag(tag)">\n            &times;\n        </a>\n    </div>\n\n    <input name="tagInputField"\n           class="tag-input dropdown-toggle"\n           type="text"\n           autoresize-width\n           ng-model="newTagName"\n           ng-delete="deletePressed()"\n           ng-enter="addTag()">\n    </input>\n</div>')}]),angular.module("app/util/template/task_priority_dropdown.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/util/template/task_priority_dropdown.html",'<span class="label label-{{style}}" ng-hide="editable">\n    {{priority | taskPriorityLabel}}\n</span>\n<div class="dropdown" ng-show="editable">\n    <a class="btn btn-{{style}} btn-xs dropdown-toggle">\n        {{priority | taskPriorityLabel}}\n        <i class="fa fa-caret-down"></i>\n    </a>\n    <ul class="dropdown-menu dropdown-menu-right">\n        <li ng-class="{disabled: priority == \'high\'}">\n            <a href="" ng-click="setPriority(\'high\')">\n                {{\'high\' | taskPriorityLabel}}\n            </a>\n        </li>\n        <li ng-class="{disabled: priority == \'medium\'}">\n            <a href="" ng-click="setPriority(\'medium\')">\n                {{\'medium\' | taskPriorityLabel}}\n            </a>\n        </li>\n        <li ng-class="{disabled: priority == \'low\'}">\n            <a href="" ng-click="setPriority(\'low\')">\n                {{\'low\' | taskPriorityLabel}}\n            </a>\n        </li>\n    </ul>\n</div>\n')}]),angular.module("app/util/template/task_status_dropdown.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/util/template/task_status_dropdown.html",'<span class="label label-{{style}}" ng-hide="editable">\n    {{status | taskStatusLabel}}\n</span>\n<div class="dropdown" ng-show="editable">\n    <a class="btn btn-{{style}} btn-xs dropdown-toggle">\n        {{status | taskStatusLabel}}\n        <i class="fa fa-caret-down"></i>\n    </a>\n    <ul class="dropdown-menu dropdown-menu-right">\n        <li ng-class="{disabled: status == \'invalid\'}">\n            <a href="" ng-click="setStatus(\'invalid\')">\n                {{\'invalid\' | taskStatusLabel}}\n            </a>\n        </li>\n        <li ng-class="{disabled: status == \'todo\'}">\n            <a href="" ng-click="setStatus(\'todo\')">\n                {{\'todo\' | taskStatusLabel}}\n            </a>\n        </li>\n        <li ng-class="{disabled: status == \'inprogress\'}">\n            <a href="" ng-click="setStatus(\'inprogress\')">\n                {{\'inprogress\' | taskStatusLabel}}\n            </a>\n        </li>\n        <li ng-class="{disabled: status == \'review\'}">\n            <a href="" ng-click="setStatus(\'review\')">\n                {{\'review\' | taskStatusLabel}}\n            </a>\n        </li>\n        <li ng-class="{disabled: status == \'merged\'}">\n            <a href="" ng-click="setStatus(\'merged\')">\n                {{\'merged\' | taskStatusLabel}}\n            </a>\n        </li>\n    </ul>\n</div>\n')}]),angular.module("app/util/template/time_moment.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("app/util/template/time_moment.html",'<span ng-if="needsTimeAgo" am-time-ago="eventdate" title="{{eventdate | date:\'yyyy-MM-dd HH:mm:ss Z\'}}" ></span>\n<span ng-if="!needsTimeAgo">\n{{eventdate | date:\'yyyy-MM-dd HH:mm:ss Z\'}}</span>\n')}]);