angular.module("sb.admin",["sb.services","sb.templates","sb.util","ui.router"]).config(function($stateProvider,$urlRouterProvider,PermissionResolver){"use strict";$urlRouterProvider.when("/admin","/admin/user"),$stateProvider.state("sb.admin",{"abstract":!0,views:{"submenu@":{templateUrl:"app/admin/template/admin_submenu.html"},"@":{template:"<div ui-view></div>"}},url:"/admin",resolve:{isSuperuser:PermissionResolver.requirePermission("is_superuser",!0)}}).state("sb.admin.user",{url:"/user",templateUrl:"app/admin/template/user.html",controller:"UserAdminController"}).state("sb.admin.user_edit",{url:"/user/:id",templateUrl:"app/admin/template/user_edit.html",controller:"UserEditController",resolve:{user:function($stateParams,User){return User.get({id:$stateParams.id}).$promise}}}).state("sb.admin.team",{url:"/team",templateUrl:"app/admin/template/team.html"}).state("sb.admin.team_edit",{url:"/team/:id",templateUrl:"app/admin/template/team_edit.html"})}),angular.module("sb.auth",["sb.services","sb.templates","ui.router","sb.util","LocalStorageModule"]).config(function($stateProvider,SessionResolver){"use strict";$stateProvider.state("sb.auth",{"abstract":!0,template:"<div ui-view></div>",url:"/auth"}).state("sb.auth.authorize",{url:"/authorize?error&error_description",templateUrl:"app/auth/template/busy.html",controller:"AuthAuthorizeController",resolve:{isLoggedOut:SessionResolver.requireLoggedOut}}).state("sb.auth.deauthorize",{url:"/deauthorize",templateUrl:"app/auth/template/busy.html",controller:"AuthDeauthorizeController",resolve:{isLoggedIn:SessionResolver.requireLoggedIn}}).state("sb.auth.token",{url:"/token?code&state&error&error_description",templateUrl:"app/auth/template/busy.html",controller:"AuthTokenController",resolve:{isLoggedOut:SessionResolver.requireLoggedOut}}).state("sb.auth.error",{url:"/error?error&error_description",templateUrl:"app/auth/template/error.html",controller:"AuthErrorController"})}).run(function($rootScope,SessionState,Session,PermissionManager,RefreshManager,Notification,Priority){"use strict";PermissionManager.initialize(),Notification.intercept(function(message){switch(message.type){case SessionState.LOGGED_IN:$rootScope.isLoggedIn=!0;break;case SessionState.LOGGED_OUT:$rootScope.isLoggedIn=!1}},Priority.LAST),RefreshManager.scheduleRefresh()}),angular.module("sb.board",["ui.router","sb.services","sb.util","ui.bootstrap"]).config(function($stateProvider,$urlRouterProvider){"use strict";$urlRouterProvider.when("/board","/board/list"),$stateProvider.state("sb.board",{"abstract":!0,url:"/board",template:"<div ui-view></div>"}).state("sb.board.detail",{url:"/{boardID:[0-9]+}",controller:"BoardDetailController",templateUrl:"app/boards/template/detail.html"})}),angular.module("sb.dashboard",["sb.services","sb.templates","sb.auth","ui.router","ui.bootstrap"]).config(function($stateProvider,SessionResolver){"use strict";$stateProvider.state("sb.index",{url:"/",templateUrl:"app/dashboard/template/index.html",controller:"HomeController",resolve:{sessionState:SessionResolver.resolveSessionState}}).state("sb.dashboard",{"abstract":!0,url:"/dashboard",resolve:{sessionState:SessionResolver.resolveSessionState,currentUser:SessionResolver.requireCurrentUser},views:{"submenu@":{templateUrl:"app/dashboard/template/submenu.html"},"@":{template:"<div ui-view></div>"}}}).state("sb.dashboard.stories",{url:"/stories",controller:"DashboardController",templateUrl:"app/dashboard/template/dashboard.html"}).state("sb.dashboard.boards",{url:"/boards",controller:"BoardsWorklistsController",templateUrl:"app/dashboard/template/boards_worklists.html"})}),angular.module("sb.notification",[]),angular.module("sb.pages",["sb.services","sb.templates","sb.pages","ui.router"]).config(function($stateProvider){"use strict";$stateProvider.state("sb.page",{"abstract":!0,url:"/page",template:"<div ui-view></div>"}).state("sb.page.about",{url:"/about",templateUrl:"app/pages/template/about.html"})}),angular.module("sb.profile",["sb.services","sb.templates","sb.auth","ui.router","ui.bootstrap"]).config(function($stateProvider,SessionResolver,$urlRouterProvider){"use strict";$urlRouterProvider.when("/profile","/profile/preferences"),$stateProvider.state("sb.profile",{"abstract":!0,url:"/profile",resolve:{isLoggedIn:SessionResolver.requireLoggedIn,currentUser:SessionResolver.requireCurrentUser},views:{"submenu@":{templateUrl:"app/profile/template/profile_submenu.html"},"@":{template:"<div ui-view></div>"}}}).state("sb.profile.preferences",{url:"/preferences",templateUrl:"app/profile/template/preferences.html",controller:"ProfilePreferencesController"}).state("sb.profile.tokens",{url:"/tokens",templateUrl:"app/profile/template/tokens.html",controller:"ProfileTokensController",resolve:{tokens:function(CurrentUser,UserToken,$q){var deferred=$q.defer();return CurrentUser.resolve().then(function(currentUser){UserToken.query({user_id:currentUser.id},function(results){deferred.resolve(results)},function(error){deferred.reject(error)})},function(error){deferred.reject(error)}),deferred.promise}}})}),angular.module("sb.project_group",["ui.router","sb.services","sb.util","sb.auth"]).config(function($stateProvider,$urlRouterProvider,PermissionResolver){"use strict";$urlRouterProvider.when("/project_group","/project_group/list"),$stateProvider.state("sb.project_group",{"abstract":!0,url:"/project_group",template:"<div ui-view></div>",resolve:{isSuperuser:PermissionResolver.resolvePermission("is_superuser",!0)}}).state("sb.project_group.list",{url:"/list",templateUrl:"app/project_group/template/list.html",controller:"ProjectGroupListController"}).state("sb.project_group.detail",{url:"/{id:[0-9]+}",templateUrl:"app/project_group/template/detail.html",controller:"ProjectGroupDetailController",resolve:{projectGroup:function($stateParams,ProjectGroup,$q){var deferred=$q.defer();return ProjectGroup.get({id:$stateParams.id},function(result){deferred.resolve(result)},function(error){deferred.reject(error)}),deferred.promise}}}).state("sb.project_group.edit",{url:"/{id:[0-9]+}/edit",templateUrl:"app/project_group/template/edit.html",controller:"ProjectGroupEditController",resolve:{projectGroup:function($stateParams,ProjectGroup){return ProjectGroup.get({id:$stateParams.id}).$promise},projects:function($stateParams,ProjectGroupItem){return ProjectGroupItem.browse({projectGroupId:$stateParams.id}).$promise},isSuperuser:PermissionResolver.requirePermission("is_superuser",!0)}})}),angular.module("sb.projects",["ui.router","sb.services","sb.util","sb.auth"]).config(function($stateProvider,$urlRouterProvider,SessionResolver,PermissionResolver){"use strict";$urlRouterProvider.when("/project","/project/list"),$stateProvider.state("sb.project",{"abstract":!0,url:"/project",template:"<div ui-view></div>",resolve:{isSuperuser:PermissionResolver.resolvePermission("is_superuser",!0)}}).state("sb.project.list",{url:"/list",templateUrl:"app/projects/template/list.html",controller:"ProjectListController"}).state("sb.project.detail",{url:"/{id:[0-9]+}",templateUrl:"app/projects/template/detail.html",controller:"ProjectDetailController"})}),angular.module("sb.search",["ui.router","sb.services","sb.util","sb.auth"]).config(function($stateProvider){"use strict";$stateProvider.state("sb.search",{url:"/search?q",templateUrl:"app/search/template/index.html",controller:"SearchController"})}),angular.module("sb.services",["ngResource","sb.notification"]),angular.module("sb.story",["ui.router","sb.services","sb.util","ui.bootstrap"]).config(function($stateProvider,$urlRouterProvider,PreferenceProvider,TimelineEventTypes){"use strict";$urlRouterProvider.when("/story","/story/list"),$stateProvider.state("sb.story",{"abstract":!0,url:"/story",template:"<div ui-view></div>"}).state("sb.story.list",{url:"/list",templateUrl:"app/stories/template/list.html",controller:"StoryListController"}).state("sb.story.detail",{url:"/{storyId:[0-9]+}",templateUrl:"app/stories/template/detail.html",controller:"StoryDetailController",resolve:{story:function(Story,$stateParams){return Story.get({id:$stateParams.storyId}).$promise},creator:function(story,User){return story.creator_id?User.get({id:story.creator_id}).$promise:{}},tasks:function(Task,$stateParams){return Task.browse({story_id:$stateParams.storyId}).$promise}}}),TimelineEventTypes.forEach(function(type){PreferenceProvider.addPreference("display_events_"+type,"true")})}),angular.module("storyboard",["sb.services","sb.templates","sb.dashboard","sb.pages","sb.projects","sb.auth","sb.story","sb.profile","sb.notification","sb.search","sb.admin","sb.subscription","sb.project_group","sb.worklist","sb.board","ui.router","ui.bootstrap","monospaced.elastic","angularMoment","angular-data.DSCacheFactory","viewhead","ngSanitize","as.sortable"]).constant("angularMomentConfig",{preprocess:"utc",timezone:"UTC"}).config(function($urlRouterProvider,$locationProvider,$httpProvider,msdElasticConfig,$stateProvider,SessionResolver,PreferenceResolver){"use strict";$urlRouterProvider.otherwise("/"),$locationProvider.hashPrefix("!"),$httpProvider.defaults.headers.common["X-Client"]="StoryBoard",msdElasticConfig.append="\n",$stateProvider.state("sb",{"abstract":!0,url:"",template:"<div ui-view></div>",resolve:{sessionState:SessionResolver.resolveSessionState,preferences:PreferenceResolver.resolvePreferences}}),marked.setOptions({highlight:function(code){return hljs.highlightAuto(code).value}})}).run(function($log,$rootScope,$document){"use strict";var resolvingClassName="resolving",body=$document.find("body");$rootScope.$on("$stateChangeStart",function(){body.addClass(resolvingClassName),$rootScope.isResolving=!0}),$rootScope.$on("$stateChangeSuccess",function(){body.removeClass(resolvingClassName),$rootScope.isResolving=!1}),$rootScope.$on("$stateChangeError",function(){body.removeClass(resolvingClassName),$rootScope.isResolving=!1})}).run(function($log,$rootScope,$state){"use strict";$rootScope.$on("$stateChangeError",function(){$state.go("sb.index")})}).run(function($http,DSCacheFactory){"use strict";DSCacheFactory.createCache("defaultCache",{maxAge:6e4,deleteOnExpire:"passive"}),$http.defaults.cache=DSCacheFactory.get("defaultCache")}),angular.module("sb.subscription",["sb.notification"]),angular.module("sb.util",["ui.router","LocalStorageModule"]).run(function(){"use strict";angular.element.prototype.hide=function(){this.addClass("ng-hide")},angular.element.prototype.show=function(){this.removeClass("ng-hide")}}),angular.module("sb.worklist",["ui.router","sb.services","sb.util","ui.bootstrap"]).config(function($stateProvider,$urlRouterProvider){"use strict";$urlRouterProvider.when("/worklist","/worklist/list"),$stateProvider.state("sb.worklist",{"abstract":!0,url:"/worklist",template:"<div ui-view></div>"}).state("sb.worklist.detail",{url:"/{worklistID:[0-9]+}",controller:"WorklistDetailController",templateUrl:"app/worklists/template/detail.html"})}),angular.module("sb.admin").controller("UserAdminController",function($scope,$modal,User,Preference){"use strict";$scope.users=[],$scope.filterQuery="",$scope.addUser=function(){$modal.open({templateUrl:"app/admin/template/user_new.html",controller:"UserNewController"}).result.then(function(){$scope.search()})};var pageSize=Preference.get("page_size");$scope.searchOffset=0,$scope.search=function(){var searchQuery=$scope.filterQuery||"";$scope.users=User.browse({full_name:searchQuery,offset:$scope.searchOffset,limit:pageSize},function(results,headers){$scope.searchTotal=parseInt(headers("X-Total"))||results.length,$scope.searchOffset=parseInt(headers("X-Offset"))||0,$scope.searchLimit=parseInt(headers("X-Limit"))||0})},$scope.updatePageSize=function(value){Preference.set("page_size",value).then(function(){pageSize=value,$scope.search()})},$scope.nextPage=function(){$scope.searchOffset+=pageSize,$scope.search()},$scope.previousPage=function(){$scope.searchOffset-=pageSize,$scope.searchOffset<0&&($scope.searchOffset=0),$scope.search()},$scope.search()}),angular.module("sb.admin").controller("UserEditController",function($scope,user,$state){"use strict";$scope.user=user,$scope.save=function(){$scope.user.$update(function(){$state.go("sb.admin.user")})},$scope.cancel=function(){$state.go("sb.admin.user")}}),angular.module("sb.admin").controller("UserNewController",function($log,$scope,$modalInstance,User){"use strict";$scope.isSaving=!1,$scope.user=new User,$scope.save=function(){$scope.isSaving=!0,$scope.user.$create(function(user){$modalInstance.close(user)},function(error){$scope.isSaving=!1,$log.error(error),$modalInstance.dismiss(error)})},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.auth").controller("AuthAuthorizeController",function($stateParams,$state,$log,OpenId,$window,LastLocation,localStorageService){"use strict";return $stateParams.error?($log.debug("Error received, redirecting to auth.error."),void $state.go("sb.auth.error",$stateParams)):(localStorageService.set("lastPath",LastLocation.get()),void OpenId.authorize())}),angular.module("sb.auth").controller("AuthDeauthorizeController",function(Session,$state,$log){"use strict";$log.debug("Logging out"),Session.destroySession(),$state.go("sb.index")}),angular.module("sb.auth").controller("AuthErrorController",function($scope,$stateParams){"use strict";$scope.error=$stateParams.error||"Unknown",$scope.errorDescription=$stateParams.error_description||"No description received from server."}),angular.module("sb.auth").controller("AuthTokenController",function($state,$log,OpenId,Session,$searchParams,$window,UrlUtil,LastLocation){"use strict";function buildNextPath(){var location=LastLocation.get();return location.indexOf("/auth")>-1&&(location="/"),location}return $searchParams.error?($log.debug("Error received, redirecting to auth.error."),void $state.go("sb.auth.error",$searchParams)):void OpenId.token($searchParams).then(function(token){Session.updateSession(token).then(function(){var nextPath=buildNextPath();$window.location.href=UrlUtil.buildApplicationUrl(nextPath)})},function(error){Session.destroySession(),$state.go("sb.auth.error",error)})}),angular.module("sb.auth").controller("LoginRequiredModalController",function($state,$scope,$modalInstance){"use strict";$scope.login=function(){$state.go("sb.auth.authorize"),$modalInstance.dismiss("success")},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.util").directive("permission",function($log,PermissionManager){"use strict";return{restrict:"A",link:function($scope,element,attrs){element.hide();var permName=attrs.permission,permValue=attrs.permissionValue||!0;PermissionManager.listen($scope,permName,function(actualValue){actualValue&&actualValue.toString()===permValue.toString()?element.show():element.hide()})}}}),angular.module("sb.auth").factory("httpAuthorizationHeader",function(AccessToken){"use strict";return{request:function(request){var token=AccessToken.getAccessToken(),type=AccessToken.getTokenType();return token&&(request.headers.Authorization=type+" "+token),request}}}).config(function($httpProvider){"use strict";$httpProvider.interceptors.push("httpAuthorizationHeader")}),angular.module("sb.auth").run(function($log,$modal,Notification,RefreshManager,Session,Priority){"use strict";function handle_401(){RefreshManager.tryRefresh().then(function(){$log.info("Token refreshed on 401")},function(){$log.info("Could not refresh token. Destroying session"),Session.destroySession()})}function handle_403(){var modalInstance=$modal.open({templateUrl:"app/auth/template/modal/superuser_required.html",controller:function($modalInstance,$scope){$scope.close=function(){$modalInstance.dismiss("cancel")}}});return modalInstance.result}Notification.intercept(function(message){return"http"===message.type?(401===message.message&&handle_401(),403===message.message&&handle_403(),!1):void 0},Priority.BEFORE)}),angular.module("sb.auth").run(function($log,$modal,Notification,SessionState,Priority){"use strict";Notification.intercept(function(message){switch(message.type){case SessionState.LOGGED_IN:return!0;case SessionState.LOGGED_OUT:message.message="You have been logged out."}},Priority.AFTER)}),angular.module("sb.auth").value("SessionState",{LOGGED_IN:"logged_in",LOGGED_OUT:"logged_out",PENDING:"pending"}),angular.module("sb.auth").constant("PermissionResolver",{requirePermission:function(permName,requiredValue){"use strict";return function($q,$log,PermissionManager){var deferred=$q.defer();return PermissionManager.resolve(permName).then(function(value){$log.debug("permission:",permName,requiredValue,value),value===requiredValue?deferred.resolve(value):deferred.reject(value)},function(error){$log.debug("permission:",error),deferred.reject(error)}),deferred.promise}},resolvePermission:function(permName){"use strict";return function($q,$log,PermissionManager){var deferred=$q.defer();return PermissionManager.resolve(permName).then(function(value){deferred.resolve(value)},function(){deferred.resolve(!1)}),deferred.promise}}}),angular.module("sb.auth").constant("SessionResolver",function(){"use strict";function resolveSessionState(deferred,desiredSessionState,Session){return function(){var sessionState=Session.getSessionState();sessionState===desiredSessionState?deferred.resolve(sessionState):deferred.reject(sessionState)}}return{resolveSessionState:function($q,$log,Session,SessionState){var deferred=$q.defer();return $log.debug("Resolving session state..."),Session.resolveSessionState().then(function(sessionState){deferred.resolve(sessionState)},function(error){$log.error(error),deferred.resolve(SessionState.LOGGED_OUT)}),deferred.promise},requireLoggedOut:function($q,$log,Session,SessionState){$log.debug("Resolving logged-out-only route...");var deferred=$q.defer(),resolveLoggedOut=resolveSessionState(deferred,SessionState.LOGGED_OUT,Session);return Session.getSessionState()===SessionState.PENDING?Session.resolveSessionState().then(resolveLoggedOut):resolveLoggedOut(),deferred.promise},requireLoggedIn:function($q,$log,Session,$rootScope,SessionState){$log.debug("Resolving logged-in-only route...");var deferred=$q.defer(),resolveLoggedIn=resolveSessionState(deferred,SessionState.LOGGED_IN,Session);return Session.getSessionState()===SessionState.PENDING?Session.resolveSessionState().then(resolveLoggedIn):resolveLoggedIn(),deferred.promise},requireCurrentUser:function($q,$log,CurrentUser){return $log.debug("Resolving current user..."),CurrentUser.resolve()}}}()),angular.module("sb.auth").factory("AccessToken",function(localStorageService,preExpireDelta){"use strict";var TOKEN_TYPE="token_type",ACCESS_TOKEN="access_token",REFRESH_TOKEN="refresh_token",ID_TOKEN="id_token",EXPIRES_IN="expires_in",ISSUE_DATE="issue_date";return{clear:function(){localStorageService.remove(TOKEN_TYPE),localStorageService.remove(ACCESS_TOKEN),localStorageService.remove(REFRESH_TOKEN),localStorageService.remove(ID_TOKEN),localStorageService.remove(EXPIRES_IN),localStorageService.remove(ISSUE_DATE)},setToken:function(jsonToken){this.setTokenType(jsonToken.token_type),this.setAccessToken(jsonToken.access_token),this.setRefreshToken(jsonToken.refresh_token),this.setIdToken(jsonToken.id_token),this.setIssueDate(jsonToken.issue_date),this.setExpiresIn(jsonToken.expires_in)},isExpired:function(){var expiresIn=this.getExpiresIn()||0,issueDate=this.getIssueDate()||0,now=Math.round((new Date).getTime()/1e3);return now>issueDate+expiresIn},expiresSoon:function(){var expiresIn=this.getExpiresIn()||0,issueDate=this.getIssueDate()||0,now=Math.round((new Date).getTime()/1e3);return now>issueDate+expiresIn-preExpireDelta},getTokenType:function(){return localStorageService.get(TOKEN_TYPE)},setTokenType:function(value){return localStorageService.set(TOKEN_TYPE,value)},getIssueDate:function(){return parseInt(localStorageService.get(ISSUE_DATE))||null},setIssueDate:function(value){return localStorageService.set(ISSUE_DATE,parseInt(value))},getExpiresIn:function(){return parseInt(localStorageService.get(EXPIRES_IN))||0},setExpiresIn:function(value){return localStorageService.set(EXPIRES_IN,parseInt(value))},getAccessToken:function(){return localStorageService.get(ACCESS_TOKEN)||null},setAccessToken:function(value){return localStorageService.set(ACCESS_TOKEN,value)},getRefreshToken:function(){return localStorageService.get(REFRESH_TOKEN)||null},setRefreshToken:function(value){return localStorageService.set(REFRESH_TOKEN,value)},getIdToken:function(){return localStorageService.get(ID_TOKEN)||null},setIdToken:function(value){return localStorageService.set(ID_TOKEN,value)}}}),angular.module("sb.auth").factory("CurrentUser",function(SessionState,Session,AccessToken,$rootScope,$log,$q,User,Notification,Priority){"use strict";function resolveLoggedInSession(){var deferred=$q.defer();return Session.resolveSessionState().then(function(sessionState){sessionState===SessionState.LOGGED_IN?deferred.resolve(sessionState):deferred.reject(sessionState)},function(error){deferred.reject(error)}),deferred.promise}function resolveCurrentUser(){if(currentPromise)return currentPromise;var deferred=$q.defer();return currentPromise=deferred.promise,resolveLoggedInSession().then(function(){currentUser?deferred.resolve(currentUser):User.get({id:AccessToken.getIdToken()},function(user){currentUser=user,deferred.resolve(user)},function(error){currentUser=null,deferred.reject(error)})},function(error){currentUser=null,deferred.reject(error)}),currentPromise.then(function(){currentPromise=null},function(){currentPromise=null}),currentPromise}var currentUser=null,currentPromise=null;return Notification.intercept(function(message){switch(message.type){case SessionState.LOGGED_IN:resolveCurrentUser();break;case SessionState.LOGGED_OUT:currentUser=null}},Priority.LAST),{resolve:function(){return resolveCurrentUser()}}}),angular.module("sb.auth").factory("OpenId",function($location,$window,$log,$http,$q,StringUtil,UrlUtil,storyboardApiBase,localStorageService){"use strict";var storageKey="openid_authorize_state",authorizeUrl=storyboardApiBase+"/openid/authorize",tokenUrl=storyboardApiBase+"/openid/token",redirectUri=UrlUtil.buildApplicationUrl("/auth/token"),clientId=$location.host();return{authorize:function(){var state=StringUtil.randomAlphaNumeric(20);localStorageService.set(storageKey,state);var openIdParams={response_type:"code",client_id:clientId,redirect_uri:redirectUri,scope:"user",state:state};$window.location.href=authorizeUrl+"?"+UrlUtil.serializeParameters(openIdParams)},token:function(params){var deferred=$q.defer(),grant_type=params.grant_type||"authorization_code",authorizationCode=params.code,refreshToken=params.refresh_token,tokenParams={grant_type:grant_type};"authorization_code"===grant_type?tokenParams.code=authorizationCode:tokenParams.refresh_token=refreshToken;var url=tokenUrl+"?"+UrlUtil.serializeParameters(tokenParams);return $http({method:"POST",url:url}).then(function(response){$log.debug("Token creation succeeded.");var data=response.data,dateHeader=response.headers("Date");dateHeader?data.issue_date=Math.floor(new Date(dateHeader)/1e3):data.issue_date=Math.floor(Date.now()/1e3),deferred.resolve(data)},function(response){$log.debug("Token creation failed.");var error=response.data;error.hasOwnProperty("error")||(error={error:response.status,error_description:response.data}),deferred.reject(error)}),deferred.promise}}}),angular.module("sb.auth").factory("PermissionManager",function($log,$q,$rootScope,Session,SessionState,CurrentUser,Notification,Priority){"use strict";function resolvePermission(permName){var deferred=$q.defer();return permCache.hasOwnProperty(permName)?deferred.resolve(permCache[permName]):CurrentUser.resolve().then(function(user){permCache[permName]=user[permName],deferred.resolve(permCache[permName])},function(error){deferred.reject(error)}),deferred.promise}function clearPermissionCache(){$log.debug("Resetting permission cache."),permCache={},$rootScope.$broadcast(NOTIFY_PERMISSIONS)}function permissionListenHandler(permName,handler){return function(){resolvePermission(permName).then(function(value){handler(value)},function(){handler(null)})}}var permCache={},NOTIFY_PERMISSIONS="notify_permissions";return{initialize:function(){$log.debug("Initializing permissions");var removeNotifier=Notification.intercept(function(message){switch(message.type){case SessionState.LOGGED_IN:case SessionState.LOGGED_OUT:clearPermissionCache()}},Priority.LAST);$rootScope.$on("$destroy",removeNotifier),Session.getSessionState()!==SessionState.PENDING&&clearPermissionCache()},listen:function(scope,permName,handler){var messageHandler=permissionListenHandler(permName,handler);scope.$on("$destroy",$rootScope.$on(NOTIFY_PERMISSIONS,messageHandler)),messageHandler()},resolve:function(permName){return resolvePermission(permName)}}}),angular.module("sb.auth").constant("preExpireDelta",600),angular.module("sb.auth").service("RefreshManager",function($q,$log,$timeout,preExpireDelta,AccessToken,OpenId){"use strict";var currentRefresh=null,nextRefreshPromise=null,scheduledForToken=null,self=this;this.tryRefresh=function(){if(!currentRefresh){currentRefresh=$q.defer(),currentRefresh.promise.then(function(){currentRefresh=null},function(){currentRefresh=null});var refresh_token=AccessToken.getRefreshToken(),is_expired=AccessToken.isExpired(),expires_soon=AccessToken.expiresSoon();refresh_token?is_expired||expires_soon?($log.info("Trying to refresh token"),OpenId.token({grant_type:"refresh_token",refresh_token:refresh_token}).then(function(data){AccessToken.setToken(data),currentRefresh.resolve(!0),self.scheduleRefresh()},function(){AccessToken.clear(),currentRefresh.reject()})):($log.info("No refresh required for current access token."),currentRefresh.resolve(!0)):($log.info("No refresh token found. Aborting refresh."),currentRefresh.reject())}return currentRefresh.promise},this.scheduleRefresh=function(){if(!AccessToken.getRefreshToken()||AccessToken.isExpired())return void $log.info("Current token does not require deferred refresh.");var expiresAt=AccessToken.getIssueDate()+AccessToken.getExpiresIn();if(nextRefreshPromise&&AccessToken.getAccessToken()===scheduledForToken)return void $log.info("The refresh is already scheduled.");var now=Math.round((new Date).getTime()/1e3),delay=1e3*(expiresAt-preExpireDelta-now);nextRefreshPromise=$timeout(self.tryRefresh,delay,!1),scheduledForToken=AccessToken.getAccessToken(),$log.info("Refresh scheduled to happen in "+delay+" ms")}}),angular.module("sb.auth").factory("Session",function(SessionState,AccessToken,$rootScope,$log,$q,$state,SystemInfo,RefreshManager,Notification,Severity){"use strict";function updateSessionState(newState){newState!==sessionState&&(sessionState=newState,Notification.send(newState,newState,Severity.SUCCESS))}function validateToken(){var deferred=$q.defer();return RefreshManager.tryRefresh().then(function(){SystemInfo.get({},function(info){deferred.resolve(info)},function(error){deferred.reject(error)})}),deferred.promise}function initializeSession(){var deferred=$q.defer();return AccessToken.getAccessToken()?validateToken().then(function(){$log.debug("Token validated"),updateSessionState(SessionState.LOGGED_IN),deferred.resolve(sessionState)},function(){$log.debug("Token not validated"),AccessToken.clear(),updateSessionState(SessionState.LOGGED_OUT),deferred.resolve(sessionState)}):($log.debug("No token found"),updateSessionState(SessionState.LOGGED_OUT),deferred.resolve()),deferred.promise}function destroySession(){AccessToken.clear(),updateSessionState(SessionState.LOGGED_OUT),$state.reload()}var sessionState=SessionState.PENDING;return initializeSession(),{getSessionState:function(){return sessionState},resolveSessionState:function(){var deferred=$q.defer();if(sessionState!==SessionState.PENDING)deferred.resolve(sessionState);else var unwatch=$rootScope.$watch(function(){return sessionState},function(){sessionState!==SessionState.PENDING&&(deferred.resolve(sessionState),unwatch())});return deferred.promise},isLoggedIn:function(){return sessionState===SessionState.LOGGED_IN},destroySession:function(){destroySession()},updateSession:function(token){var deferred=$q.defer();return token?(AccessToken.setToken(token),initializeSession().then(function(){deferred.resolve(sessionState)},function(){deferred.resolve(sessionState)})):(destroySession(),deferred.resolve(sessionState)),deferred.promise}}}),angular.module("sb.auth").factory("SessionModalService",function($modal){"use strict";return{showLoginRequiredModal:function(){var modalInstance=$modal.open({templateUrl:"app/auth/template/modal/login_required.html",controller:"LoginRequiredModalController"});return modalInstance.result}}}),angular.module("sb.board").controller("AddBoardController",function($scope,$modalInstance,$state,params,Board,Project,Worklist,$q,BoardHelper){"use strict";function saveBoard(){$scope.board.$create(function(result){$scope.isSaving=!1,$modalInstance.dismiss("success"),$state.go("sb.board.detail",{boardID:result.id})})}function addLaneDetails(position){return function(lane){$scope.board.lanes.push({board_id:$scope.board.id,list_id:lane.id,position:position})}}function saveBoardWithLanes(){$scope.board.lanes=[];for(var lanePromises=[],i=0;i<$scope.lanes.length;i++){var lane=$scope.lanes[i],addLane=addLaneDetails(i);lane.project_id=$scope.board.project_id,lane["private"]=$scope.board["private"],lanePromises.push(lane.$create(addLane))}$q.all(lanePromises).then(saveBoard)}$scope.save=function(){$scope.isSaving=!0,$scope.lanes.length>0?saveBoardWithLanes():saveBoard()},$scope.close=function(){$modalInstance.dismiss("cancel")},$scope.addLane=function(){$scope.lanes.push(new Worklist({title:"",editing:!0}))},$scope.removeLane=function(lane){var idx=$scope.lanes.indexOf(lane);$scope.lanes.splice(idx,1)},$scope.toggleEdit=function(lane){lane.editing=!lane.editing},$scope.lanesSortable={dragMove:BoardHelper.maybeScrollContainer("new-board")},$scope.isSaving=!1,$scope.lanes=[],$scope.board=new Board({title:"",lanes:[]})}),angular.module("sb.board").controller("BoardArchiveController",function($log,$scope,$state,board,$modalInstance){"use strict";$scope.board=board,$scope.isUpdating=!0,$scope.error={},$scope.remove=function(){$scope.board.$delete(function(){$modalInstance.dismiss("success"),$state.go("sb.dashboard.boards")})},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.board").controller("BoardDetailController",function($scope,Worklist,$modal,Board,Project,$stateParams,BoardHelper,$document,User,$q){"use strict";function loadBoard(){var params={id:$stateParams.boardID};Board.Permissions.get(params,function(perms){$scope.permissions={editBoard:perms.indexOf("edit_board")>-1,moveCards:perms.indexOf("move_cards")>-1}}),Board.get(params,function(board){$scope.board=board,$scope.owners=[],$scope.users=[],angular.forEach(board.owners,function(id){$scope.owners.push(User.get({id:id}))}),angular.forEach(board.users,function(id){$scope.users.push(User.get({id:id}))})})}function showAddItemModal(worklist){var modalInstance=$modal.open({size:"lg",templateUrl:"app/worklists/template/additem.html",controller:"WorklistAddItemController",resolve:{worklist:function(){return worklist},valid:function(){var board=$scope.board;return function(item){var valid=!0;return angular.forEach(board.lanes,function(lane){var items=lane.worklist.items;angular.forEach(items,function(listItem){var type=item.type.toLowerCase();item.hasOwnProperty("value")||(item.value=item.id),item.value===listItem.item_id&&type===listItem.item_type&&(valid=!1,item.invalid=item.type+" is already in the board ("+lane.worklist.title+" lane).")})}),valid}}}});return modalInstance.result}function updateBoardLanes(){for(var i=0;i<$scope.board.lanes.length;i++)$scope.board.lanes[i].position=i;$scope.board.$update()}$scope.addItem=function(worklist){loadBoard(),showAddItemModal(worklist)["finally"](function(){loadBoard()})},$scope.toggleEditMode=function(){$scope.showEditForm&&loadBoard(),
$scope.showEditForm=!$scope.showEditForm},$scope.update=function(){$scope.isUpdating=!0;var params={id:$scope.board.id},owners={codename:"edit_board",users:$scope.board.owners},users={codename:"move_cards",users:$scope.board.users};$scope.board.$update().then(function(){var updating=[Board.Permissions.update(params,owners).$promise,Board.Permissions.update(params,users).$promise];$q.all(updating).then(function(){$scope.isUpdating=!1,$scope.toggleEditMode()})})},$scope.remove=function(){var modalInstance=$modal.open({templateUrl:"app/boards/template/archive.html",controller:"BoardArchiveController",resolve:{board:function(){return $scope.board}}});return modalInstance.result},$scope.addLane=function(){$scope.board.lanes.push({worklist:new Worklist({id:null,title:"",editing:!0}),position:$scope.board.lanes.length,board_id:$scope.board.id})},$scope.removeLane=function(lane){var modalInstance=$modal.open({templateUrl:"app/worklists/template/delete.html",controller:"WorklistDeleteController",resolve:{worklist:function(){return lane.worklist},redirect:!1}});modalInstance.result.then(function(){var idx=$scope.board.lanes.indexOf(lane);$scope.board.lanes.splice(idx,1),$scope.board.$update()})},$scope.removeCard=function(worklist,item){Worklist.ItemsController["delete"]({id:worklist.id,item_id:item.id}).$promise.then(function(){var idx=worklist.items.indexOf(item);worklist.items.splice(idx,1)})},$scope.toggleEditLane=function(lane){lane.worklist.editing&&(null===lane.worklist.id?lane.worklist.$create().then(function(list){lane.list_id=list.id,$scope.board.$update()}):Worklist.update({id:lane.worklist.id},lane.worklist)),lane.worklist.editing=!lane.worklist.editing},$scope.searchUsers=function(value,array){var deferred=$q.defer();return User.browse({full_name:value,limit:10},function(searchResults){var results=[];angular.forEach(searchResults,function(result){-1===array.indexOf(result.id)&&results.push(result)}),deferred.resolve(results)}),deferred.promise},$scope.formatUserName=function(model){return model?model.name:""},$scope.addUser=function(model,modelArray,idArray){idArray.push(model.id),modelArray.push(model)},$scope.removeUser=function(model,modelArray,idArray){var idIdx=idArray.indexOf(model.id);idArray.splice(idIdx,1);var modelIdx=modelArray.indexOf(model);modelArray.splice(modelIdx,1)},$scope.lanesSortable={orderChanged:updateBoardLanes,dragMove:BoardHelper.maybeScrollContainer("kanban-board"),accept:function(sourceHandle,dest){return sourceHandle.itemScope.sortableScope.$id===dest.$id}},$scope.cardsSortable={orderChanged:BoardHelper.moveCardInLane,itemMoved:BoardHelper.moveCardBetweenLanes,dragMove:BoardHelper.maybeScrollContainer("kanban-board"),accept:function(sourceHandle,dest){var srcParent=sourceHandle.itemScope.sortableScope.$parent,dstParentSortable=dest.$parent.sortableScope;return $scope.permissions.editBoard?srcParent.sortableScope?srcParent.sortableScope.$id===dstParentSortable.$id:!1:!0}},$document[0].ondragstart=function(event){event.preventDefault()},loadBoard(),$scope.showEditForm=!1,$scope.showAddOwner=!1,$scope.isUpdating=!1}),angular.module("sb.board").factory("BoardHelper",function($document,$window,Worklist){"use strict";function scrollFunction(elementID){return function(itemPosition,containment,eventObj){if(eventObj){for(var container=document.getElementById(elementID),offsetX=$window.pageXOffset||$document[0].documentElement.scrollLeft,targetX=eventObj.pageX-offsetX,leftBound=container.clientLeft+container.offsetLeft,parent=container.offsetParent;parent;)leftBound+=parent.offsetLeft,parent=parent.offsetParent;var rightBound=leftBound+container.clientWidth;leftBound>targetX?container.scrollLeft-=10:targetX>rightBound&&(container.scrollLeft+=10)}}}function moveCardInLane(result){for(var list=result.source.sortableScope.$parent.lane.worklist,i=0;i<list.items.length;i++){var item=list.items[i];item.position=i,Worklist.ItemsController.update({id:list.id,item_id:item.id,list_position:item.position})}}function moveCardBetweenLanes(result){moveCardInLane(result);for(var dst=result.dest.sortableScope.$parent.lane.worklist,i=0;i<dst.items.length;i++){var item=dst.items[i];item.position=i,item.list_id=dst.id,Worklist.ItemsController.update({id:dst.id,item_id:item.id,list_position:item.position,list_id:item.list_id})}}return{maybeScrollContainer:scrollFunction,moveCardInLane:moveCardInLane,moveCardBetweenLanes:moveCardBetweenLanes}}),angular.module("sb.board").factory("NewBoardService",function($modal,$log,Session,SessionModalService){"use strict";return{showNewBoardModal:function(userId){if(Session.isLoggedIn()){var modalInstance=$modal.open({size:"lg",templateUrl:"app/boards/template/new.html",controller:"AddBoardController",resolve:{params:function(){return{userId:userId||null}}}});return modalInstance.result}return SessionModalService.showLoginRequiredModal()}}}),angular.module("sb.dashboard").controller("BoardsWorklistsController",function($scope,currentUser,Worklist,Board){"use strict";var params={user_id:currentUser.id};$scope.loadingBoards=!0,$scope.loadingWorklists=!0,Board.browse(params).$promise.then(function(boards){$scope.loadingBoards=!1,$scope.boards=boards}),Worklist.browse(params).$promise.then(function(worklists){$scope.loadingWorklists=!1,$scope.worklists=worklists})}),angular.module("sb.dashboard").controller("DashboardController",function($q,$scope,currentUser,Story,SubscriptionList,SubscriptionEvent){"use strict";function loadEvents(){$scope.subscriptionEvents=null,SubscriptionEvent.browse({subscriber_id:currentUser.id},function(results){results.forEach(function(row){row.hasOwnProperty("event_info")?row.event_info=JSON.parse(row.event_info):row.event_info={}}),$scope.subscriptionEvents=results,$scope.collapsedEvents=results.length>1})}$scope.assignedStories=Story.browse({assignee_id:currentUser.id,status:"active"}),$scope.createdStories=Story.browse({creator_id:currentUser.id,status:"active"}),loadEvents(),$scope.removeEvent=function(event){var deferred=$q.defer();return deferred.resolve([event.$delete(function(){var idx=$scope.subscriptionEvents.indexOf(event);$scope.subscriptionEvents.splice(idx,1)})]),deferred.promise},$scope.removeAllEvents=function(){for(var promises=[],i=0;i<$scope.subscriptionEvents.length;i++){var event=$scope.subscriptionEvents[i],promise=$scope.removeEvent(event);promises.push(promise)}$q.all(promises).then(loadEvents)},$scope.storySubscriptions=SubscriptionList.subsList("story",currentUser)}),angular.module("sb.dashboard").controller("HomeController",function($state,sessionState,SessionState){"use strict";sessionState===SessionState.LOGGED_IN?$state.go("sb.dashboard.stories"):$state.go("sb.page.about")}),angular.module("sb.dashboard").directive("subscriptionEvent",function($log,User){"use strict";return{restrict:"A",scope:{subscriptionEvent:"@"},link:function(scope){try{var evt=JSON.parse(scope.subscriptionEvent);scope.evt=evt,scope.author=User.get({id:evt.author_id}),scope.event_type=evt.event_type,scope.created_at=evt.created_at}catch(e){$log.error(e)}},templateUrl:"app/dashboard/template/subscription_event.html"}}),angular.module("sb.notification").controller("NotificationsController",function($scope,Notification){"use strict";var defaultDisplayCount=5;$scope.displayCount=defaultDisplayCount,$scope.notifications=[],$scope.remove=function(notification){var idx=$scope.notifications.indexOf(notification);idx>-1&&$scope.notifications.splice(idx,1),$scope.notifications.length<=defaultDisplayCount&&($scope.displayCount=defaultDisplayCount)},$scope.showMore=function(){$scope.displayCount=Math.min($scope.notifications.length,$scope.displayCount+5)},$scope.$on("$destroy",Notification.subscribe(function(notification){$scope.notifications.push(notification)}))}),angular.module("sb.notification").directive("notifications",function(){"use strict";return{restrict:"E",templateUrl:"app/notification/template/notifications.html",controller:"NotificationsController"}}),angular.module("sb.notification").constant("Priority",{BEFORE:-1,FIRST:0,LAST:999,AFTER:1e3}),angular.module("sb.notification").constant("Severity",{ERROR:"error",WARNING:"warning",INFO:"info",SUCCESS:"success"}),angular.module("sb.notification").factory("Notification",function($log,Severity,Priority){"use strict";var subscribers=[],interceptors=[];return{send:function(type,message,severity,cause,callback,callbackLabel){if(!type||!message)return void $log.warn("Invoked Notification.send() without a type or message.");for(var n={type:type,message:message,severity:severity||Severity.INFO,cause:cause||null,callback:callback||null,callbackLabel:callbackLabel||null,date:new Date},i=0;i<interceptors.length;i++)if(interceptors[i].method(n))return;for(var j=0;j<subscribers.length;j++)subscribers[j](n)},intercept:function(interceptor,priority){var i={priority:priority||Priority.LAST,method:interceptor};return interceptors.unshift(i),interceptors.sort(function(a,b){return a.priority-b.priority}),function(){var idx=interceptors.indexOf(i);interceptors.splice(idx,1)}},subscribe:function(subscriber){return subscribers.push(subscriber),function(){subscribers.remove(subscriber)}}}}),angular.module("sb.profile").controller("ProfilePreferencesController",function($scope,Preference,Notification,Severity){"use strict";$scope.preferences=Preference.getAll(),$scope.save=function(){$scope.saving=!0,Preference.saveAll($scope.preferences).then(function(){Notification.send("preferences","Preferences Saved!",Severity.SUCCESS),$scope.saving=!1},function(){$scope.saving=!1})}}),angular.module("sb.profile").controller("ProfileTokenNewController",function($q,$log,$scope,$modalInstance,UserToken,user){"use strict";$scope.isSaving=!1,$scope.token=new UserToken({user_id:user.id,expires_in:3600}),$scope.save=function(){$scope.isSaving=!0,$scope.token.$create(function(token){$modalInstance.close(token),$scope.isSaving=!1},function(){$scope.isSaving=!1})},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.profile").controller("ProfileTokensController",function($scope,UserToken,tokens,$modal){"use strict";$scope.tokens=tokens,$scope.deleteToken=function(token){token.$delete(function(){var idx=$scope.tokens.indexOf(token);idx>-1&&$scope.tokens.splice(idx,1)})},$scope.issueToken=function(){$modal.open({templateUrl:"app/profile/template/token_new.html",controller:"ProfileTokenNewController",resolve:{user:function(CurrentUser){return CurrentUser.resolve()}}}).result.then(function(token){$scope.tokens.push(token)})}}),angular.module("sb.profile").controller("ProfileTokenItemController",function($scope,AccessToken){"use strict";var now=new Date;$scope.created=new Date($scope.token.created_at),$scope.expires=new Date($scope.token.created_at),$scope.expires.setSeconds($scope.expires.getSeconds()+$scope.token.expires_in),$scope.expired=$scope.expires.getTime()<now.getTime(),$scope.current=$scope.token.access_token===AccessToken.getAccessToken()}),angular.module("sb.project_group").controller("ProjectGroupDeleteController",function($scope,projectGroup,$modalInstance){"use strict";$scope.projectGroup=projectGroup,$scope.isUpdating=!0,$scope.error={},$scope.remove=function(){$scope.projectGroup.$delete(function(){$modalInstance.close("success")})},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.project_group").controller("ProjectGroupDetailController",function($scope,$stateParams,projectGroup,Story,Project,Preference,SubscriptionList,CurrentUser){"use strict";var projectPageSize=Preference.get("project_group_detail_projects_page_size")||0,storyPageSize=Preference.get("project_group_detail_stories_page_size")||0;$scope.projectGroup=projectGroup,$scope.projects=[],$scope.isSearchingProjects=!1,$scope.listProjects=function(){$scope.isSearchingProjects=!0,Project.browse({project_group_id:projectGroup.id,offset:$scope.projectSearchOffset,limit:projectPageSize},function(result,headers){$scope.projectCount=parseInt(headers("X-Total"))||result.length,$scope.projectSearchOffset=parseInt(headers("X-Offset"))||0,$scope.projectSearchLimit=parseInt(headers("X-Limit"))||0,$scope.projects=result,$scope.isSearchingProjects=!1},function(error){$scope.error=error,$scope.isSearchingProjects=!1})},$scope.stories=[],$scope.showActive=!0,$scope.showMerged=!1,$scope.showInvalid=!1,$scope.filterStories=function(){var status=[];return $scope.showActive&&status.push("active"),$scope.showMerged&&status.push("merged"),$scope.showInvalid&&status.push("invalid"),0===status.length?void($scope.stories=[]):void Story.browse({project_group_id:projectGroup.id,sort_field:"id",sort_dir:"desc",status:status,offset:$scope.storySearchOffset,limit:storyPageSize},function(result,headers){$scope.storyCount=parseInt(headers("X-Total"))||result.length,$scope.storySearchOffset=parseInt(headers("X-Offset"))||0,$scope.storySearchLimit=parseInt(headers("X-Limit"))||0,$scope.stories=result,$scope.isSearchingStories=!1},function(error){$scope.error=error,$scope.isSearchingStories=!1})},$scope.nextPage=function(type){"stories"===type?($scope.storySearchOffset+=storyPageSize,$scope.filterStories()):"projects"===type&&($scope.projectSearchOffset+=projectPageSize,$scope.listProjects())},$scope.previousPage=function(type){"stories"===type?($scope.storySearchOffset-=storyPageSize,$scope.storySearchOffset<0&&($scope.storySearchOffset=0),$scope.filterStories()):"projects"===type&&($scope.projectSearchOffset-=projectPageSize,$scope.projectSearchOffset<0&&($scope.projectSearchOffset=0),$scope.listProjects())},$scope.updatePageSize=function(type,value){"stories"===type?Preference.set("project_group_detail_stories_page_size",value).then(function(){storyPageSize=value,$scope.filterStories()}):"projects"===type&&Preference.set("project_group_detail_projects_page_size",value).then(function(){projectPageSize=value,$scope.listProjects()})},$scope.listProjects(),$scope.filterStories();var cuPromise=CurrentUser.resolve();cuPromise.then(function(user){$scope.projectSubscriptions=SubscriptionList.subsList("project",user)}),cuPromise.then(function(user){$scope.storySubscriptions=SubscriptionList.subsList("story",user)})}),angular.module("sb.project_group").controller("ProjectGroupEditController",function($q,$log,$scope,$state,projectGroup,projects,Project,ProjectGroupItem,ArrayUtil){"use strict";$scope.projectGroup=projectGroup,$scope.projects=projects;var loadedIds=[];$scope.projects.forEach(function(project){loadedIds.push(project.id)}),$scope.isSaving=!1,$scope.searchProjects=function(value){var deferred=$q.defer();return Project.browse({name:value,limit:10},function(results){for(var idxList=[],i=0;i<$scope.projects.length;i++){var project=$scope.projects[i];project&&idxList.push(project.id)}for(var j=results.length-1;j>=0;j--){var resultId=results[j].id;idxList.indexOf(resultId)>-1&&results.splice(j,1)}deferred.resolve(results)},function(error){$log.error(error),deferred.resolve([])}),deferred.promise},$scope.formatProjectName=function(model){return model?model.name:""},$scope.removeProject=function(index){$scope.projects.splice(index,1)},$scope.save=function(){$scope.isSaving=!0;var promises=[],desiredIds=[];$scope.projects.forEach(function(project){desiredIds.push(project.id)});var idsToDelete=ArrayUtil.difference(loadedIds,desiredIds);idsToDelete.forEach(function(id){var removeProjectDeferred=$q.defer(),item=new ProjectGroupItem({id:id,projectGroupId:projectGroup.id});item.$delete(function(result){removeProjectDeferred.resolve(result)},function(error){removeProjectDeferred.reject(error)}),promises.push(removeProjectDeferred.promise)});var idsToAdd=ArrayUtil.difference(desiredIds,loadedIds);idsToAdd.forEach(function(id){var addProjectDeferred=$q.defer(),item=new ProjectGroupItem({id:id,projectGroupId:projectGroup.id});item.$create(function(result){addProjectDeferred.resolve(result)},function(error){addProjectDeferred.reject(error)}),promises.push(addProjectDeferred.promise)});var deferred=$q.defer();promises.push(deferred.promise),$scope.projectGroup.$update(function(success){deferred.resolve(success)},function(error){$log.error(error),deferred.reject(error)}),$q.all(promises).then(function(){$state.go("sb.project_group.list",{})},function(error){$log.error(error)})},$scope.addProject=function(){$scope.projects.push({})},$scope.selectNewProject=function(index,model){$scope.projects[index]=model},$scope.checkValidProjects=function(){if(0===$scope.projects.length)return!1;for(var i=0;i<$scope.projects.length;i++){var project=$scope.projects[i];if(!project.id)return!1}return!0}}),angular.module("sb.project_group").controller("ProjectGroupItemController",function($scope,$log,ProjectGroupItem){"use strict";if($scope.projectGroupItems=[],$scope.loadingProjectGroupItems=!1,$scope.projectGroup){var id=$scope.projectGroup.id;$scope.loadingProjectGroupItems=!0,ProjectGroupItem.browse({projectGroupId:id},function(results){$scope.loadingProjectGroupItems=!1,$scope.projectGroupItems=results,$scope.collapsed=results.length>1},function(error){$log.error(error),$scope.loadingProjectGroupItems=!1})}}),angular.module("sb.project_group").controller("ProjectGroupListController",function($scope,$modal,SubscriptionList,CurrentUser,$state){"use strict";$scope.resourceTypes=["ProjectGroup"],$scope.defaultCriteria=[],$scope.newProjectGroup=function(){$scope.modalInstance=$modal.open({templateUrl:"app/project_group/template/new.html",controller:"ProjectGroupNewController"}),$scope.modalInstance.result.then(function(projectGroup){$scope.showMobileNewMenu=!1,$state.go("sb.project_group.detail",{id:projectGroup.id})})};var cuPromise=CurrentUser.resolve();cuPromise.then(function(user){$scope.projectGroupSubscriptions=SubscriptionList.subsList("project_group",user)})}),angular.module("sb.project_group").controller("ProjectGroupNewController",function($q,$log,$scope,$modalInstance,ProjectGroup,ProjectGroupItem,Project){"use strict";$scope.isSaving=!1,$scope.projects=[{}],$scope.projectGroup=new ProjectGroup,$scope.error={},$scope.searchProjects=function(value){var deferred=$q.defer();return Project.browse({name:value,limit:10},function(results){for(var idxList=[],i=0;i<$scope.projects.length;i++){var project=$scope.projects[i];project&&idxList.push(project.id)}for(var j=results.length-1;j>=0;j--){var resultId=results[j].id;idxList.indexOf(resultId)>-1&&results.splice(j,1)}deferred.resolve(results)},function(error){$log.error(error),$scope.isSaving=!1}),deferred.promise},$scope.formatProjectName=function(model){return model?model.name:""},$scope.addProject=function(){$scope.projects.push({})},$scope.selectNewProject=function(index,model){$scope.projects[index]=model},$scope.removeProject=function(index){$scope.projects.splice(index,1)},$scope.save=function(){$scope.isSaving=!0,$scope.projectGroup.$save(function(projectGroup){var promises=[];$scope.projects.forEach(function(project){var deferred=$q.defer(),item=new ProjectGroupItem({id:project.id,projectGroupId:projectGroup.id});item.$create(function(result){deferred.resolve(result)},function(error){deferred.reject(error)}),promises.push(deferred.promise)}),$q.all(promises).then(function(){$modalInstance.close(projectGroup)},function(error){$log.error(error.data.faultstring),$scope.error=error.data.faultstring,$modalInstance.dismiss("cancel"),$scope.isSaving=!1})},function(error){$modalInstance.dismiss("cancel"),$log.error(error.data.faultstring),$scope.error=error.data.faultString,$scope.isSaving=!1})},$scope.close=function(){$modalInstance.dismiss("cancel")},$scope.checkValidProjects=function(){if(0===$scope.projects.length)return!1;for(var i=0;i<$scope.projects.length;i++){var project=$scope.projects[i];if(!project.id)return!1}return!0}}),angular.module("sb.projects").controller("ProjectDetailController",function($scope,$rootScope,$state,$stateParams,Project,Story,Session,isSuperuser){"use strict";function handleServiceError(error){$scope.error=error,$scope.isLoading=!1,$scope.isUpdating=!1}function handleServiceSuccess(){$scope.isLoading=!1,$scope.isUpdating=!1}function loadProject(){Project.get({id:id},function(result){$scope.project=result,handleServiceSuccess()},handleServiceError)}var id=$stateParams.hasOwnProperty("id")?parseInt($stateParams.id,10):null;$scope.project={},$scope.isLoading=!0,$scope.isUpdating=!1,$scope.error={},$scope.cancel=function(){loadProject(),$scope.showEditForm=!1},$scope.toggleEditMode=function(){isSuperuser?($scope.showEditForm=!$scope.showEditForm,setTimeout(function(){$rootScope.$broadcast("elastic:adjust")},1)):$scope.showEditForm=!1},$scope.update=function(){$scope.isUpdating=!0,$scope.error={},$scope.project.$update(function(){$scope.isUpdating=!1,$scope.showEditForm=!1,handleServiceSuccess()},handleServiceError)},loadProject()}),angular.module("sb.projects").controller("ProjectListController",function($scope,$modal,isSuperuser,SubscriptionList,CurrentUser){"use strict";$scope.is_superuser=isSuperuser,$scope.resourceTypes=["Project"],$scope.defaultCriteria=[],$scope.addProject=function(){$scope.modalInstance=$modal.open({size:"lg",templateUrl:"app/projects/template/new.html",controller:"ProjectNewController"})};var cuPromise=CurrentUser.resolve();cuPromise.then(function(user){$scope.projectSubscriptions=SubscriptionList.subsList("project",user)})}),angular.module("sb.projects").controller("ProjectNewController",function($scope,$state,$modalInstance,Project){"use strict";$scope.newProject=new Project,$scope.isCreating=!1,$scope.error={},$scope.createProject=function(){$scope.isCreating=!0,$scope.error={},$scope.newProject.$create(function(project){$modalInstance.dismiss("success"),$state.go("sb.project.detail",{id:project.id})},function(error){$scope.isCreating=!1,$scope.error=error})},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.projects").controller("ProjectStoryListController",function($scope,$state,$stateParams,Story,NewStoryService,Preference,SubscriptionList,CurrentUser){"use strict";function resetScope(){$scope.storyCount=0,$scope.stories=[],$scope.error={}}var id=$stateParams.hasOwnProperty("id")?parseInt($stateParams.id,10):null;if(null===id)return void $state.go("sb.index");var pageSize=Preference.get("project_detail_page_size");$scope.searchQuery="",$scope.isSearching=!1,$scope.filter="active",$scope.setFilter=function(state){$scope.filter=state,$scope.search()},$scope.search=function(){resetScope(),$scope.isSearching=!0,Story.browse({project_id:id,status:$scope.filter||null,offset:$scope.searchOffset,limit:pageSize},function(result,headers){$scope.storyCount=parseInt(headers("X-Total"))||result.length,$scope.searchOffset=parseInt(headers("X-Offset"))||0,$scope.searchLimit=parseInt(headers("X-Limit"))||0,$scope.stories=result,$scope.isSearching=!1},function(error){$scope.error=error,$scope.isSearching=!1})},$scope.updatePageSize=function(value){Preference.set("page_size",value).then(function(){pageSize=value,$scope.search()})},$scope.nextPage=function(){$scope.searchOffset+=pageSize,$scope.search()},$scope.previousPage=function(){$scope.searchOffset-=pageSize,$scope.searchOffset<0&&($scope.searchOffset=0),$scope.search()},$scope.newStory=function(){NewStoryService.showNewStoryModal(id).then(function(story){$state.go("sb.story.detail",{storyId:story.id})})},resetScope(),$scope.search();var cuPromise=CurrentUser.resolve();cuPromise.then(function(user){$scope.storySubscriptions=SubscriptionList.subsList("story",user)})}),angular.module("sb.search").controller("SearchController",function($log,$q,$scope,Criteria,$stateParams){"use strict";$scope.defaultCriteria=[],$scope.resourceTypes=["TaskStatus","Story","Project","User","Task","ProjectGroup"],$stateParams.hasOwnProperty("q")&&$stateParams.q&&$scope.defaultCriteria.push(Criteria.create("Text",$stateParams.q))}),angular.module("sb.search").controller("SearchCriteriaController",function($log,$q,$scope,Criteria){"use strict";var resourceTypes=[];$scope.criteria=[],$scope.init=function(types,defaultCriteria){resourceTypes=types||resourceTypes,$scope.criteria=defaultCriteria||[],$scope.searchForCriteria=Criteria.buildCriteriaSearch(resourceTypes,5)},$scope.addCriteria=function(item){for(var i=$scope.criteria.length-1;i>=0;i--){var cItem=$scope.criteria[i];cItem!==item&&item.type===cItem.type&&$scope.criteria.splice(i,1)}},$scope.removeCriteria=function(item){var idx=$scope.criteria.indexOf(item);idx>-1&&$scope.criteria.splice(idx,1)},$scope.$watchCollection(function(){return $scope.criteria},function(){$scope.hasSomeValidCriteria=!1,resourceTypes.forEach(function(resourceName){var validCriteria=Criteria.filterCriteria(resourceName,$scope.criteria);validCriteria.length===$scope.criteria.length&&($scope.hasSomeValidCriteria=!0)})}),$scope.searchForCriteria=function(){var deferred=$q.defer();return deferred.resolve([]),deferred.promise}}),angular.module("sb.search").directive("searchResults",function($log,$parse,Criteria,$injector,Preference){"use strict";return{restrict:"A",scope:!0,link:function($scope,$element,args){function handleErrorResult(){$scope.isSearching=!1}function handleSearchResult(results,headers){$scope.searchTotal=parseInt(headers("X-Total"))||results.length,$scope.searchOffset=parseInt(headers("X-Offset"))||0,$scope.searchLimit=parseInt(headers("X-Limit"))||0,$scope.searchResults=results,$scope.isSearching=!1}function updateResults(){if($scope.validCriteria=Criteria.filterCriteria(resourceName,criteria),$scope.hasCriteria=criteria.length>0,$scope.hasValidCriteria=searchWithoutCriteria||$scope.validCriteria.length===criteria.length&&$scope.hasCriteria,!$scope.hasValidCriteria)return $scope.searchResults=[],void($scope.isSearching=!1);var params=Criteria.mapCriteria(resourceName,$scope.validCriteria),resource=$injector.get(resourceName);return resource?(params.limit=pageSize,params.offset=$scope.searchOffset,$scope.isSearching=!0,void(params.hasOwnProperty("q")?resource.search(params,handleSearchResult,handleErrorResult):(params.sort_field=$scope.sortField,params.sort_dir=$scope.sortDirection,resource.browse(params,handleSearchResult,handleErrorResult)))):void $log.error("Invalid resource name: "+resourceName)}var resourceName=args.searchResource,pageSize=args.searchPageSize||Preference.get("page_size"),searchWithoutCriteria="true"===args.searchWithoutCriteria,criteria=[];$scope.isSearching=!1,$scope.searchResults=[],$scope.sortField="id",$scope.sortDirection="desc",$scope.updatePageSize=function(value){Preference.set("page_size",value).then(function(){pageSize=value,updateResults()})},$scope.toggleFilter=function(fieldName){$scope.sortField===fieldName?$scope.sortDirection="asc"===$scope.sortDirection?"desc":"asc":($scope.sortField=fieldName,$scope.sortDirection="desc"),updateResults()},$scope.nextPage=function(){$scope.searchOffset+=pageSize,updateResults()},$scope.previousPage=function(){$scope.searchOffset-=pageSize,$scope.searchOffset<0&&($scope.searchOffset=0),updateResults()},$scope.$watchCollection($parse(args.searchCriteria),function(results){criteria=results,updateResults()})}}}),angular.module("sb.services").service("Criteria",function($q,$log,$injector,Preference){"use strict";return{filterCriteria:function(resourceName,criteria){var resource=$injector.get(resourceName);return resource&&resource.hasOwnProperty("criteriaFilter")?resource.criteriaFilter(criteria):($log.warn('Attempting to filter criteria for unknown resource "'+resourceName+'"'),[])},mapCriteria:function(resourceName,criteria){var resource=$injector.get(resourceName);return resource&&resource.hasOwnProperty("criteriaMap")?resource.criteriaMap(criteria):($log.warn('Attempting to map criteria for unknown resource "'+resourceName+'"'),{})},create:function(type,value,title){return title=title||value,{type:type,value:value,title:title}},buildCriteriaSearch:function(types,pageSize){pageSize=pageSize||Preference.get("page_size");var resolvers=[];return types.forEach(function(type){var resource=$injector.get(type);return resource.hasOwnProperty("criteriaResolvers")?void resource.criteriaResolvers().forEach(function(resolver){-1===resolvers.indexOf(resolver)&&resolvers.push(resolver)}):void $log.warn('Resource type "'+type+'" does not implement criteriaResolvers.')}),function(searchString){var deferred=$q.defer(),promises=[];return resolvers.forEach(function(resolver){promises.push(resolver(searchString,pageSize))}),$q.all(promises).then(function(results){var criteria=[];results.forEach(function(result){result.forEach(function(item){criteria.push(item)})}),deferred.resolve(criteria)}),deferred.promise}},buildCriteriaFilter:function(parameterMap){return function(criteria){var filteredCriteria=[];return criteria.forEach(function(item){parameterMap.hasOwnProperty(item.type)&&filteredCriteria.push(item)}),filteredCriteria}},buildCriteriaMap:function(parameterMap){return function(criteria){var params={};return criteria.forEach(function(item){parameterMap.hasOwnProperty(item.type)&&(params[parameterMap[item.type]]=item.value)}),params}}}}),angular.module("sb.services").factory("StoryStatus",function(Criteria,$q){"use strict";var validStatusCriteria=[Criteria.create("StoryStatus","active","Active"),Criteria.create("StoryStatus","merged","Merged"),Criteria.create("StoryStatus","invalid","Invalid")];return{criteriaResolver:function(searchString){var deferred=$q.defer();searchString=searchString||"",searchString=searchString.toLowerCase();var criteria=[];return validStatusCriteria.forEach(function(criteriaItem){var title=criteriaItem.title.toLowerCase();(title.indexOf(searchString)>-1||0==="status".indexOf(searchString))&&criteria.push(criteriaItem)}),deferred.resolve(criteria),deferred.promise}}}),angular.module("sb.services").factory("TaskPriority",function(Criteria,$q){"use strict";var validPriorityCriteria=[Criteria.create("TaskPriority","high","High"),Criteria.create("TaskPriority","medium","Medium"),Criteria.create("TaskPriority","low","Low")];return{criteriaResolver:function(searchString){var deferred=$q.defer();searchString=searchString||"",searchString=searchString.toLowerCase();var criteria=[];return validPriorityCriteria.forEach(function(criteriaItem){var title=criteriaItem.title.toLowerCase();(title.indexOf(searchString)>-1||0==="priority".indexOf(searchString))&&criteria.push(criteriaItem)}),deferred.resolve(criteria),deferred.promise}}}),angular.module("sb.services").factory("Text",function(Criteria,$q){"use strict";return{criteriaResolver:function(searchString){var deferred=$q.defer();return deferred.resolve([Criteria.create("Text",searchString)]),deferred.promise}}}),angular.module("sb.services").directive("insertMarkdown",function($sanitize){"use strict";return{restrict:"E",scope:{content:"="},link:function(scope,elem){scope.$watch("content",function(newVal){elem.html("<div>"+$sanitize(marked(newVal))+"</div>")},!0)}}}),angular.module("sb.services").directive("resultSetPager",function(){"use strict";return{restrict:"E",templateUrl:"app/services/template/result_set_pager.html",scope:{total:"=",offset:"=",limit:"=",listType:"=",minimalPager:"=",pageSize:"&onPageSize",nextPage:"&onNextPage",previousPage:"&onPreviousPage"}}}),angular.module("sb.services").factory("httpCacheHandler",function($q,$cacheFactory){"use strict";var $httpDefaultCache=$cacheFactory.get("$http");return{response:function(response){var method=response.config.method,url=response.config.url,obj=response.data;switch(method){case"POST":obj.hasOwnProperty("id")&&$httpDefaultCache.put(url+"/"+obj.id,obj);break;case"PUT":$httpDefaultCache.put(url,obj);break;case"DELETE":$httpDefaultCache.remove(url)}return response}}}).config(function($httpProvider){"use strict";$httpProvider.interceptors.push("httpCacheHandler")}),angular.module("sb.services").factory("httpErrorBroadcaster",function($q,$rootScope,Notification,Severity){"use strict";function sendEvent(severity,response){response.status&&Notification.send("http",response.status,severity,response)}return{response:function(response){return response&&sendEvent(Severity.SUCCESS,response),response;
},responseError:function(response){return response&&sendEvent(Severity.ERROR,response),$q.reject(response)}}}).config(function($httpProvider){"use strict";$httpProvider.interceptors.unshift("httpErrorBroadcaster")}),angular.module("sb.services").run(function(Notification,Priority){"use strict";function filterTemplateRequests(message){if("http"!==message.type)return!1;var request=message.cause,url=request.config.url;return".html"===url.substr(-5)?!0:void 0}function filterSuccessful(message){var response=message.cause;if("http"!==message.type||!response)return!1;var successful_requests=[200,201,202,203,204,205,206,207,208,226];return successful_requests.indexOf(response.status)>=0?!0:void 0}function rewriteHttpStatus(message){if("http"===message.type){var httpStatus=message.message,request=message.cause;if(httpStatus&&request&&request.data){var data=request.data,method=request.config.method,url=request.config.url;message.message=httpStatus+": "+method+" "+url+": ",data.hasOwnProperty("faultstring")?message.message+=data.faultstring:data.hasOwnProperty("field")&&data.hasOwnProperty("message")?message.message+=data.field+": "+data.message:message.message+="No error details available."}}}Notification.intercept(filterTemplateRequests,Priority.BEFORE),Notification.intercept(filterSuccessful,Priority.LAST),Notification.intercept(rewriteHttpStatus,Priority.AFTER)}),angular.module("sb.services").provider("Preference",function(){"use strict";function Preference($q,$log,Session,AccessToken,UserPreference,SessionState){var preferences={};this.resolveUserPreferences=function(){var deferred=$q.defer(),sessionPromise=Session.resolveSessionState();return sessionPromise.then(function(state){state===SessionState.LOGGED_IN?UserPreference.get({id:AccessToken.getIdToken()},function(prefs){deferred.resolve(prefs)},function(){deferred.resolve(defaults)}):deferred.resolve(defaults)},function(){deferred.resolve(defaults)}),deferred.promise},this.getAll=function(){var result={};for(var def_key in defaults)result[def_key]=this.get(def_key);for(var key in preferences)result[key]=preferences[key];return result},this.saveAll=function(newPrefs){for(var key in defaults)preferences.hasOwnProperty(key)&&preferences[key]!==newPrefs[key]&&($log.debug("Preference Change: "+key+" -> "+newPrefs[key]),preferences[key]=newPrefs[key]);return this.save()},this.get=function(key){return defaults.hasOwnProperty(key)?(preferences.hasOwnProperty(key)||($log.warn("Setting default preference: ",key,defaults[key]),this.set(key,defaults[key],!0)),preferences[key]):($log.warn("Attempt to get unregistered preference: "+key),null)},this.set=function(key,value,isDefault){return defaults.hasOwnProperty(key)?(preferences[key]=value,this.save(isDefault)):($log.warn("Attempt to set unregistered preference: "+key),null)},this.refresh=function(){var deferred=$q.defer();return this.resolveUserPreferences().then(function(newPrefs){preferences=newPrefs,deferred.resolve(preferences)}),deferred.promise},this.save=function(isDefault){var deferred=$q.defer();return isDefault?deferred.resolve():preferences.$save?preferences.$save({id:AccessToken.getIdToken()},function(){deferred.resolve()},function(){deferred.resolve()}):deferred.resolve(),deferred.promise}}var preferenceInstance=null,defaults={};this.addPreference=function(name,defaultValue){defaults[name]=defaultValue},this.$get=function($injector){return preferenceInstance||(preferenceInstance=$injector.instantiate(Preference)),preferenceInstance}}).config(function(PreferenceProvider){"use strict";PreferenceProvider.addPreference("page_size",10),PreferenceProvider.addPreference("story_detail_page_size",10),PreferenceProvider.addPreference("project_group_detail_projects_page_size",10),PreferenceProvider.addPreference("project_group_detail_stories_page_size",10),PreferenceProvider.addPreference("project_detail_page_size",10),PreferenceProvider.addPreference("plugin_email_enable","false")}),angular.module("sb.services").constant("storyboardApiBase","/api/v1"),angular.module("sb.services").constant("PreferenceResolver",{resolvePreferences:function(Preference){"use strict";return Preference.refresh()}}),angular.module("sb.services").factory("Board",function(ResourceFactory,Worklist,$resource,storyboardApiBase){"use strict";var resource=ResourceFactory.build("/boards/:id","/boards/search",{id:"@id"},!1,!0),permissionsSignature={create:{method:"POST"},get:{method:"GET",cache:!1,isArray:!0},update:{method:"PUT"}};return resource.Permissions=$resource(storyboardApiBase+"/boards/:id/permissions",{id:"@id"},permissionsSignature),ResourceFactory.applySearch("Board",resource,"title",{Text:"title",Project:"project_id",User:"creator_id"}),resource}),angular.module("sb.services").factory("Comment",function(ResourceFactory){"use strict";return ResourceFactory.build("/stories/:story_id/comments/:id","/stories/0/search",{id:"@id",story_id:"@story_id"})}),angular.module("sb.services").factory("Project",function(ResourceFactory){"use strict";var resource=ResourceFactory.build("/projects/:id","/projects/search",{id:"@id"});return ResourceFactory.applySearch("Project",resource,"name",{Text:"q"}),resource}),angular.module("sb.services").factory("ProjectGroup",function(ResourceFactory){"use strict";var resource=ResourceFactory.build("/project_groups/:id","/project_groups/search",{id:"@id"});return ResourceFactory.applySearch("ProjectGroup",resource,"title",{Text:"title"}),resource}),angular.module("sb.services").factory("ProjectGroupItem",function($resource,storyboardApiBase){"use strict";return $resource(storyboardApiBase+"/project_groups/:projectGroupId/projects/:id",{projectGroupId:"@projectGroupId",id:"@id"},{create:{method:"PUT",transformRequest:function(){return""}},"delete":{method:"DELETE"},query:{method:"GET",isArray:!0,responseType:"json"},browse:{method:"GET",isArray:!0,responseType:"json",cache:!1}})}),angular.module("sb.services").factory("Search",function($q,$log,Project,Story,User,Criteria){"use strict";return{project:function(searchString){var deferred=$q.defer();return Project.search({q:searchString},function(result){var projResults=[];result.forEach(function(item){projResults.push(Criteria.create("project",item.id,item.name))}),deferred.resolve(projResults)},function(){deferred.resolve([])}),deferred.promise},user:function(searchString){var deferred=$q.defer();return User.search({q:searchString},function(result){var userResults=[];result.forEach(function(item){userResults.push(Criteria.create("user",item.id,item.full_name))}),deferred.resolve(userResults)},function(){deferred.resolve([])}),deferred.promise},story:function(searchString){var deferred=$q.defer();return Story.search({q:searchString},function(result){var storyResults=[];result.forEach(function(item){storyResults.push(Criteria.create("story",item.id,item.title))}),deferred.resolve(storyResults)},function(){deferred.resolve([])}),deferred.promise},all:function(searchString){var deferred=$q.defer(),criteria=[];return $q.all({projects:this.project(searchString),stories:this.story(searchString),users:this.user(searchString)}).then(function(results){results.projects.forEach(function(item){criteria.push(item)}),results.stories.forEach(function(item){criteria.push(item)}),results.users.forEach(function(item){criteria.push(item)}),deferred.resolve(criteria)}),deferred.promise}}}),angular.module("sb.services").factory("Story",function(ResourceFactory,$resource,storyboardApiBase){"use strict";var resource=ResourceFactory.build("/stories/:id","/stories/search",{id:"@id"}),tags_signature={update:{method:"PUT",transformRequest:function(){return""}},"delete":{method:"DELETE",transformRequest:function(){return""}}};return resource.TagsController=$resource(storyboardApiBase+"/stories/:id/tags",{id:"@id"},tags_signature),ResourceFactory.applySearch("Story",resource,"title",{Text:"q",StoryStatus:"status",ProjectGroup:"project_group_id",Project:"project_id",User:"assignee_id"}),resource}),angular.module("sb.services").factory("Subscription",function(ResourceFactory){"use strict";return ResourceFactory.build("/subscriptions/:id","/subscriptions/search",{id:"@id"})}),angular.module("sb.services").factory("SubscriptionEvent",function(ResourceFactory){"use strict";return ResourceFactory.build("/subscription_events/:id","/subscription_events/search",{id:"@id"})}),angular.module("sb.services").factory("SubscriptionList",function(Session,Subscription){"use strict";return{subsList:function(resource,user){return Session.isLoggedIn()?Subscription.browse({user_id:user.id,target_type:resource}):null}}}),angular.module("sb.services").factory("SystemInfo",function($resource,storyboardApiBase){"use strict";return $resource(storyboardApiBase+"/systeminfo",{},{get:{method:"GET",cache:!0}})}),angular.module("sb.services").factory("Task",function(ResourceFactory){"use strict";var resource=ResourceFactory.build("/tasks/:id","/tasks/search",{id:"@id"});return ResourceFactory.applySearch("Task",resource,"title",{Text:"q",TaskStatus:"status",TaskPriority:"priority",Story:"story_id",User:"assignee_id",Project:"project_id",ProjectGroup:"project_group_id"}),resource}),angular.module("sb.services").factory("TaskStatus",function(ResourceFactory){"use strict";var resource=ResourceFactory.build("/task_statuses/:id","/task_statuses/search",{id:"@id"},!0);return ResourceFactory.applySearch("TaskStatus",resource,"name",{Text:"q"}),resource}),angular.module("sb.services").factory("Team",function(ResourceFactory){"use strict";return ResourceFactory.build("/teams/:id","/teams/search",{id:"@id"})}),angular.module("sb.services").factory("TimelineEvent",function(ResourceFactory){"use strict";return ResourceFactory.build("/stories/:story_id/events/:id","/stories/:story_id/events/search",{id:"@id",story_id:"@story_id"})}),angular.module("sb.services").factory("User",function(ResourceFactory){"use strict";var resource=ResourceFactory.build("/users/:id","/users/search",{id:"@id"});return ResourceFactory.applySearch("User",resource,"full_name",{Text:"q"}),resource}),angular.module("sb.services").factory("UserPreference",function($resource,storyboardApiBase){"use strict";return $resource(storyboardApiBase+"/users/:id/preferences",{id:"@id"},{get:{method:"GET",cache:!0}})}),angular.module("sb.services").factory("UserToken",function(ResourceFactory){"use strict";var resource=ResourceFactory.build("/users/:user_id/tokens/:id",null,{user_id:"@user_id",id:"@id"});return resource}),angular.module("sb.services").factory("Worklist",function(ResourceFactory,$resource,storyboardApiBase){"use strict";var resource=ResourceFactory.build("/worklists/:id","/worklists/search",{id:"@id"},!1,!0),items_signature={create:{method:"POST"},get:{method:"GET",cache:!1,isArray:!0},update:{method:"PUT"},"delete":{method:"DELETE",transformRequest:function(){return""}}};resource.ItemsController=$resource(storyboardApiBase+"/worklists/:id/items/:item_id",{id:"@id",item_id:"@item_id"},items_signature);var permissionsSignature={create:{method:"POST"},get:{method:"GET",cache:!1,isArray:!0},update:{method:"PUT"}};return resource.Permissions=$resource(storyboardApiBase+"/worklists/:id/permissions",{id:"@id"},permissionsSignature),ResourceFactory.applySearch("Worklist",resource,"title",{Text:"title",Project:"project_id",User:"creator_id"}),resource}),angular.module("sb.services").service("ResourceFactory",function($q,$log,$injector,Criteria,$resource,storyboardApiBase,Preference){"use strict";function buildSignature(searchUrl,cacheSearchResults,disableCachedGets){return cacheSearchResults=!!cacheSearchResults,disableCachedGets=!!disableCachedGets,{create:{method:"POST"},get:{method:"GET",cache:!disableCachedGets},update:{method:"PUT"},"delete":{method:"DELETE"},browse:{method:"GET",isArray:!0,responseType:"json",cache:cacheSearchResults},search:{method:"GET",url:searchUrl,isArray:!0,responseType:"json",cache:cacheSearchResults}}}return{build:function(restUri,searchUri,resourceParameters,cacheSearchResults,disableCachedGets){if(!restUri)return $log.error("Cannot use resource factory without a base REST uri."),null;cacheSearchResults=!!cacheSearchResults;var signature=buildSignature(storyboardApiBase+searchUri,cacheSearchResults,disableCachedGets);return $resource(storyboardApiBase+restUri,resourceParameters,signature)},applySearch:function(resourceName,resource,nameField,searchParameters){var criteriaResolvers=[];for(var type in searchParameters){var typeResource=$injector.get(type);typeResource&&typeResource.hasOwnProperty("criteriaResolver")&&criteriaResolvers.push(typeResource.criteriaResolver)}resource.criteriaResolvers=function(){return criteriaResolvers},nameField&&(resource.criteriaResolver=function(searchString,pageSize){pageSize=pageSize||Preference.get("page_size");var deferred=$q.defer(),queryParams={};return queryParams[nameField]=searchString,queryParams.limit=pageSize,resource.browse(queryParams,function(result){var criteriaResults=[];result.forEach(function(item){criteriaResults.push(Criteria.create(resourceName,item.id,item[nameField]))}),deferred.resolve(criteriaResults)},function(){deferred.resolve([])}),deferred.promise}),resource.criteriaFilter=Criteria.buildCriteriaFilter(searchParameters),resource.criteriaMap=Criteria.buildCriteriaMap(searchParameters)}}}),angular.module("sb.story").controller("StoryDeleteController",function($log,$scope,$state,story,$modalInstance){"use strict";$scope.story=story,$scope.isUpdating=!0,$scope.error={},$scope.remove=function(){$scope.story.$delete(function(){$modalInstance.dismiss("success"),$state.go("sb.project.list")})},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.story").controller("StoryDetailController",function($log,$rootScope,$scope,$state,$stateParams,$modal,Session,Preference,TimelineEvent,Comment,TimelineEventTypes,story,Story,creator,tasks,Task,DSCacheFactory,User,storyboardApiBase,SubscriptionList,CurrentUser,SessionModalService){"use strict";function reloadPagePreferences(){TimelineEventTypes.forEach(function(type){var pref_name="display_events_"+type;$scope[pref_name]="true"===Preference.get(pref_name)}),pageSize=Preference.get("story_detail_page_size"),$scope.loadEvents()}function handleServiceError(error){$scope.error=error,$scope.isLoading=!1,$scope.isUpdating=!1}function handleServiceSuccess(){$scope.isLoading=!1,$scope.isUpdating=!1}var pageSize=Preference.get("story_detail_page_size");$scope.story=story,$scope.creator=creator,$scope.tasks=tasks,$scope.searchOffset=0,$scope.isSearching=!1,$scope.loadEvents=function(){$scope.isSearching=!0;var params={};params.sort_field="id",params.sort_dir="asc",params.story_id=$scope.story.id,params.offset=$scope.searchOffset,params.limit=pageSize,TimelineEvent.browse(params,function(result,headers){var eventResults=[];result.forEach(function(item){item.author=User.get({id:item.author_id}),item.event_info=JSON.parse(item.event_info),eventResults.push(item)}),$scope.searchTotal=parseInt(headers("X-Total")),$scope.searchOffset=parseInt(headers("X-Offset")),$scope.searchLimit=parseInt(headers("X-Limit")),$scope.events=eventResults,$scope.isSearching=!1},function(){$scope.isSearching=!1})},reloadPagePreferences(),$scope.nextPage=function(){$scope.searchOffset+=pageSize,$scope.loadEvents()},$scope.previousPage=function(){$scope.searchOffset-=pageSize,$scope.searchOffset<0&&($scope.searchOffset=0),$scope.loadEvents()},$scope.updatePageSize=function(value){Preference.set("story_detail_page_size",value).then(function(){pageSize=value,$scope.loadEvents()})},$scope.newComment=new Comment({}),$scope.toggleEditMode=function(){Session.isLoggedIn()?($scope.showEditForm=!$scope.showEditForm,setTimeout(function(){$rootScope.$broadcast("elastic:adjust")},1)):$scope.showEditForm=!1},$scope.showEditForm=!1,$scope.isLoading=!0,$scope.isUpdating=!1,$scope.isSavingComment=!1,$scope.error={},$scope.update=function(){$scope.isUpdating=!0,$scope.error={},$scope.story.$update(function(){$scope.showEditForm=!1,$scope.previewStory=!1,handleServiceSuccess()},handleServiceError)},$scope.cancel=function(){$scope.showEditForm=!1},$scope.remove=function(){var modalInstance=$modal.open({templateUrl:"app/stories/template/delete.html",controller:"StoryDeleteController",resolve:{story:function(){return $scope.story}}});return modalInstance.result},$scope.updateFilter=function(){var modalInstance=$modal.open({templateUrl:"app/stories/template/update_filter.html",controller:"TimelineFilterController"});modalInstance.result.then(reloadPagePreferences),$scope.searchLimit=Preference.get("story_detail_page_size")},$scope.previewingComment=!1,$scope.togglePreview=function(val){$scope.previewingComment=!$scope.previewingComment,(val===!0||val===!1)&&($scope.previewingComment=val)},$scope.addComment=function(){function resetSavingFlag(){$scope.isSavingComment=!1}return $scope.newComment.content?($scope.isSavingComment=!0,$scope.togglePreview(!1),void $scope.newComment.$create({story_id:$scope.story.id},function(){$scope.newComment=new Comment({}),resetSavingFlag(),$scope.loadEvents()})):void $log.warn("No content in comment, discarding submission")},$scope.showLoginRequiredModal=function(){SessionModalService.showLoginRequiredModal()},$scope.newTask=new Task({story_id:$scope.story.id,status:"todo",priority:"medium"}),$scope.createTask=function(){var savingTask=new Task(angular.copy($scope.newTask));savingTask.$save(function(savedTask){$scope.tasks.push(savedTask),$scope.loadEvents()})},$scope.updateTask=function(task,fieldName,value){fieldName&&(task[fieldName]=value),task.$update(function(){$scope.showTaskEditForm=!1,$scope.loadEvents()})},$scope.removeTask=function(task){var modalInstance=$modal.open({templateUrl:"app/stories/template/delete_task.html",controller:"StoryTaskDeleteController",resolve:{task:function(){return task},params:function(){return{lastTask:1===$scope.tasks.length}}}});modalInstance.result.then(function(){var taskIndex=$scope.tasks.indexOf(task);taskIndex>-1&&$scope.tasks.splice(taskIndex,1),$scope.loadEvents()})},$scope.TagsController=new Story.TagsController({id:story.id}),$scope.showAddTag=!1,$scope.toggleAddTag=function(){$scope.showAddTag=!$scope.showAddTag},$scope.addTag=function(tag_name){tag_name&&$scope.TagsController.$update({tags:[tag_name]},function(updatedStory){DSCacheFactory.get("defaultCache").put(storyboardApiBase+"/stories/"+story.id,updatedStory),$scope.showAddTag=!1,$scope.story.tags.push(tag_name),$scope.loadEvents()},handleServiceError)},$scope.removeTag=function(tag_name){$scope.TagsController.$delete({tags:[tag_name]},function(){var tagIndex=$scope.story.tags.indexOf(tag_name);DSCacheFactory.get("defaultCache").remove(storyboardApiBase+"/stories/"+story.id),tagIndex>-1&&$scope.story.tags.splice(tagIndex,1),$scope.loadEvents()},handleServiceError)};var cuPromise=CurrentUser.resolve();cuPromise.then(function(user){$scope.storySubscriptions=SubscriptionList.subsList("story",user)})}),angular.module("sb.story").controller("StoryListController",function($scope,$state,Criteria,NewStoryService,SubscriptionList,CurrentUser){"use strict";$scope.resourceTypes=["Story"],$scope.defaultCriteria=[Criteria.create("StoryStatus","active","Active")],$scope.newStory=function(){NewStoryService.showNewStoryModal().then(function(story){$state.go("sb.story.detail",{storyId:story.id})})};var cuPromise=CurrentUser.resolve();cuPromise.then(function(user){$scope.storySubscriptions=SubscriptionList.subsList("story",user)})}),angular.module("sb.story").controller("StoryListItemController",function($scope,TaskStatus){"use strict";function getStatusClass(status){var className="";switch(status){case"inprogress":className="text-info";break;case"review":className="text-warning";break;case"merged":className="text-success";break;case"invalid":className="muted";break;default:className=""}return className}switch($scope.expandRow=!1,$scope.status_texts=[],$scope.status_classes=[],TaskStatus.query({},function(items){for(var i=0;i<items.length;i++)$scope.status_texts[items[i].key]=items[i].name,$scope.status_classes[items[i].key]=getStatusClass(items[i].key)}),$scope.story.status){case"active":$scope.statusLabelStyle="label-info";break;case"merged":$scope.statusLabelStyle="label-success";break;case"invalid":$scope.statusLabelStyle="label-default";break;default:$scope.statusLabelStyle="label-default"}}),angular.module("sb.story").controller("StoryModalController",function($scope,$modalInstance,params,Project,Story,Task){"use strict";$scope.projects=Project.browse({}),$scope.story=new Story({title:""}),$scope.tasks=[new Task({title:"",project_id:params.projectId||null})],params.projectId&&Project.get({id:params.projectId},function(project){$scope.asyncProject=project});var lastTitle="",trackingStoryTitle=!0;$scope.$on("$destroy",$scope.$watch(function(){return $scope.story.title},function(newTitle){if(trackingStoryTitle){var task=$scope.tasks[0];trackingStoryTitle&&task.title===lastTitle?(task.title=newTitle,lastTitle=newTitle):trackingStoryTitle=!1}})),$scope.save=function(){$scope.story.$create(function(story){var resolvingTasks=$scope.tasks.length;$scope.tasks.forEach(function(task){task.story_id=story.id,task.$create(function(){resolvingTasks--,0===resolvingTasks&&$modalInstance.close(story)})})})},$scope.close=function(){$modalInstance.dismiss("cancel")},$scope.addTask=function(){var lastTask=$scope.tasks[$scope.tasks.length-1],project_id=lastTask.project_id;project_id||(project_id=params.projectId||null);var current_task=new Task({project_id:project_id});project_id&&Project.get({id:project_id},function(project){$scope.asyncProject=project}),$scope.tasks.push(current_task)},$scope.removeTask=function(task){if(!($scope.tasks.length<2)){var idx=$scope.tasks.indexOf(task);$scope.tasks.splice(idx,1)}},$scope.searchProjects=function(value){return Project.browse({name:value,limit:10}).$promise},$scope.formatProjectName=function(model){return model?model.name:""},$scope.selectNewProject=function(model,task){task.project_id=model.id}}),angular.module("sb.story").controller("StoryTaskDeleteController",function($log,$scope,$state,task,$modalInstance,params){"use strict";$scope.task=task,$scope.params=params,$scope.isUpdating=!0,$scope.error={},$scope.remove=function(){$scope.task.$delete(function(){$modalInstance.close("success")})},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.story").controller("TimelineFilterController",function($scope,$modalInstance,Preference,TimelineEventTypes){"use strict";function init(){TimelineEventTypes.forEach(function(type){var pref_name="display_events_"+type;$scope[pref_name]=Preference.get(pref_name)})}$scope.close=function(){$modalInstance.dismiss("cancel")},$scope.save=function(){return TimelineEventTypes.forEach(function(type){var pref_name="display_events_"+type,old_value=Preference.get(pref_name),new_value=$scope[pref_name];old_value!==new_value&&Preference.set(pref_name,new_value)}),$modalInstance.close()},init()}),angular.module("sb.story").factory("NewStoryService",function($modal,$log,Session,SessionModalService){"use strict";return{showNewStoryModal:function(projectId){if(Session.isLoggedIn()){var modalInstance=$modal.open({size:"lg",templateUrl:"app/stories/template/new.html",controller:"StoryModalController",resolve:{params:function(){return{projectId:projectId||null}}}});return modalInstance.result}return SessionModalService.showLoginRequiredModal()}}}),angular.element(document).ready(function(){"use strict";function initializeApplication(config){for(var key in config)$log.debug("Configuration: "+key+" -> "+config[key]),angular.module("storyboard").constant(key,config[key]);angular.bootstrap(document,["storyboard"])}var initInjector=angular.injector(["ng"]),$http=initInjector.get("$http"),$log=initInjector.get("$log");$log.info("Attempting to load parameters from ./config.json"),$http.get("./config.json").then(function(response){initializeApplication(response.data)},function(){$log.warn("Cannot load ./config.json, using defaults."),initializeApplication({})})}),angular.module("storyboard").controller("ApplicationController",function($scope,$state,$rootScope){"use strict";function hasSubmenu(state){for(var stateName in state.views)if(stateName.match(/^submenu@/))return!0;return state.parent?hasSubmenu(state.parent):!1}$rootScope.$on("$stateChangeSuccess",function(){$scope.hasSubmenu=hasSubmenu($state.$current)}),$scope.hasSubmenu=!1}),angular.module("storyboard").controller("HeaderController",function($q,$scope,$rootScope,$state,$modal,NewStoryService,Session,SessionState,CurrentUser,Criteria,Notification,Priority,Project,Story,ProjectGroup,NewWorklistService,NewBoardService,SessionModalService){"use strict";function resolveCurrentUser(){CurrentUser.resolve().then(function(user){$scope.currentUser=user},function(){$scope.currentUser=null})}resolveCurrentUser(),$scope.currentUser=null,$scope.newStory=function(){NewStoryService.showNewStoryModal().then(function(story){$scope.showMobileNewMenu=!1,$state.go("sb.story.detail",{storyId:story.id})})},$scope.newWorklist=function(){NewWorklistService.showNewWorklistModal().then(function(worklist){$scope.showMobileNewMenu=!1,$state.go("sb.worklist.detail",{worklistID:worklist.id})})},$scope.newBoard=function(){NewBoardService.showNewBoardModal().then(function(board){$scope.showMobileNewMenu=!1,$state.go("sb.board.detail",{boardID:board.id})})},$scope.newProject=function(){$scope.modalInstance=$modal.open({size:"lg",templateUrl:"app/projects/template/new.html",controller:"ProjectNewController"})},$scope.newProjectGroup=function(){$scope.modalInstance=$modal.open({templateUrl:"app/project_group/template/new.html",controller:"ProjectGroupNewController"}),$scope.modalInstance.result.then(function(projectGroup){$scope.showMobileNewMenu=!1,$state.go("sb.project_group.detail",{id:projectGroup.id})})},$scope.showLoginRequiredModal=function(){SessionModalService.showLoginRequiredModal()},$scope.logout=function(){Session.destroySession()},$scope.searchString="",$scope.search=function(criteria){switch(criteria.type){case"Text":$state.go("sb.search",{q:criteria.value});break;case"ProjectGroup":$state.go("sb.project_group.detail",{id:criteria.value});break;case"Project":$state.go("sb.project.detail",{id:criteria.value});break;case"Story":$state.go("sb.story.detail",{storyId:criteria.value})}$scope.searchString=""},$scope.quickSearch=function(searchString){var deferred=$q.defer();searchString=searchString||"";var searches=[];if(searchString.match(/^[0-9]+$/)){var getProjectGroupDeferred=$q.defer(),getProjectDeferred=$q.defer(),getStoryDeferred=$q.defer();ProjectGroup.get({id:searchString},function(result){getProjectGroupDeferred.resolve(Criteria.create("ProjectGroup",result.id,result.name))},function(){getProjectGroupDeferred.resolve(null)}),Project.get({id:searchString},function(result){getProjectDeferred.resolve(Criteria.create("Project",result.id,result.name))},function(){getProjectDeferred.resolve(null)}),Story.get({id:searchString},function(result){getStoryDeferred.resolve(Criteria.create("Story",result.id,result.title))},function(){getStoryDeferred.resolve(null)}),searches.push(getProjectGroupDeferred.promise),searches.push(getProjectDeferred.promise),searches.push(getStoryDeferred.promise)}else searches.push(ProjectGroup.criteriaResolver(searchString,5)),searches.push(Project.criteriaResolver(searchString,5)),searches.push(Story.criteriaResolver(searchString,5));return $q.all(searches).then(function(searchResults){for(var criteria=[Criteria.create("Text",searchString)],addResult=function(item){criteria.push(item)},i=0;i<searchResults.length;i++){var results=searchResults[i];results&&(results.forEach?results.forEach(addResult):addResult(results))}deferred.resolve(criteria)}),deferred.promise},Notification.intercept(function(message){switch(message.type){case SessionState.LOGGED_IN:resolveCurrentUser();break;case SessionState.LOGGED_OUT:$scope.currentUser=null}},Priority.LAST)}),angular.module("sb.util").directive("subscribe",function(CurrentUser,Notification,Priority,Session,SessionState,Subscription){"use strict";return{restrict:"E",scope:{resource:"@",resourceId:"=",subscriptions:"="},templateUrl:"app/subscription/template/subscribe.html",link:function($scope){function setSubscription(subscription){$scope.subscription=subscription||null,$scope.subscribed=!!$scope.subscription}function resolveSubscription(){return Session.isLoggedIn()?($scope.resolving=!0,void cuPromise.then(function(user){Subscription.browse({user_id:user.id,target_type:$scope.resource,target_id:$scope.resourceId},function(results){setSubscription(results[0]),$scope.resolving=!1},function(){setSubscription(),$scope.resolving=!1})})):void setSubscription()}function resolveSubsList(){return Session.isLoggedIn()?($scope.resolving=!0,void cuPromise.then(function(){angular.forEach($scope.subscriptions,function(subscription){$scope.resourceId===subscription.target_id&&setSubscription(subscription)}),$scope.resolving=!1})):void setSubscription()}var cuPromise=CurrentUser.resolve();$scope.enabled=Session.isLoggedIn(),$scope.subscribed=!1,$scope.resolving=!1,$scope.subscription=null,$scope.currentUser=null,cuPromise.then(function(user){$scope.currentUser=user});var removeNotifier=Notification.intercept(function(message){switch(message.type){case SessionState.LOGGED_IN:$scope.enabled=!0,resolveSubscription();break;case SessionState.LOGGED_OUT:$scope.enabled=!1,$scope.subscribed=!1}},Priority.LAST);$scope.$on("$destroy",removeNotifier),$scope.toggleSubscribe=function(){$scope.resolving||($scope.resolving=!0,$scope.subscription?$scope.subscription.$delete(function(){setSubscription(),$scope.resolving=!1},function(){$scope.resolving=!1}):cuPromise.then(function(user){var sub=new Subscription({user_id:user.id,target_type:$scope.resource,target_id:$scope.resourceId});sub.$create(function(result){setSubscription(result),$scope.resolving=!1},function(){$scope.resolving=!1})}))},$scope.subscriptions=$scope.subscriptions,$scope.subscriptions.$promise.then(resolveSubsList)}}}),angular.module("sb.util").constant("TimelineEventTypes",["story_created","story_details_changed","tags_added","tags_deleted","task_created","task_assignee_changed","task_status_changed","task_priority_changed","task_details_changed","task_deleted","user_comment"]),angular.module("sb.util").run(function($rootScope){"use strict";var regex="^[a-zA-Z0-9]+([\\-\\./]?[a-zA-Z0-9]+)*$";$rootScope.PROJECT_NAME_REGEX=new RegExp(regex)}),angular.module("sb.util").directive("tagComplete",function($q,$parse,$rootScope,$position,typeaheadParser,$timeout){"use strict";var HOT_KEYS=[9,13,27,38,40];return{restrict:"EA",replace:!0,scope:{tagCompleteTags:"=",tagCompleteLabelField:"@",tagCompleteTagTemplateUrl:"=",tagCompleteOptionTemplateUrl:"=",tagCompleteVerify:"&",tagCompleteOnSelect:"&",tagCompleteLoading:"&"},templateUrl:"app/util/template/tag_complete.html",link:function($scope,$element,attrs){var $input=$element.find("input");$element[0].focus=function(){$input[0].focus()};var parserResult=typeaheadParser.parse(attrs.tagComplete),isLoadingSetter=function(isLoading){$scope.tagCompleteLoading&&$scope.tagCompleteLoading({isLoading:isLoading})};$scope.tagCompleteTemplateUrl=$parse(attrs.tagCompleteTemplateUrl),$scope.hasFocus=!1;var resetMatches=function(){$scope.matches=[],$scope.activeIdx=-1},getMatchesAsync=function(inputValue){if($scope.hasFocus&&inputValue){var locals={$viewValue:inputValue};isLoadingSetter(!0),$q.when(parserResult.source($scope.$parent,locals)).then(function(matches){if(inputValue===$scope.newTagName&&$scope.hasFocus){$scope.matches=[];for(var i=0;i<matches.length;i++)$scope.matches.push({label:parserResult.viewMapper($scope.$parent,locals),model:matches[i]});matches.length>0?($scope.activeIdx=0,$scope.query=inputValue):resetMatches(),isLoadingSetter(!1),$scope.position=$position.position($element),$scope.position.top=$scope.position.top+$element.prop("offsetHeight")}},function(){resetMatches(),isLoadingSetter(!1);
})}};$scope.$watch(function(){return $scope.newTagName},getMatchesAsync),$input.on("focus",function(){$scope.hasFocus=!0,$rootScope.$$phase||$scope.$digest()}),$input.on("blur",function(){$timeout(function(){resetMatches(),$scope.newTagName="",$scope.hasFocus=!1,$rootScope.$$phase||$scope.$digest()},200)}),$input.on("keydown",function(evt){0!==$scope.matches.length&&-1!==HOT_KEYS.indexOf(evt.which)&&(evt.preventDefault(),40===evt.which?($scope.activeIdx=($scope.activeIdx+1)%$scope.matches.length,$scope.$digest()):38===evt.which?($scope.activeIdx=($scope.activeIdx?$scope.activeIdx:$scope.matches.length)-1,$scope.$digest()):13===evt.which||9===evt.which?$scope.$apply(function(){$scope.select($scope.activeIdx)}):27===evt.which&&(evt.stopPropagation(),resetMatches(),$scope.$digest()))}),$scope.deletePressed=function(){var selectedTags=$scope.tagCompleteTags||[];return selectedTags.length>0&&!$scope.newTagName?(selectedTags.pop(),!0):void 0},$scope.focus=function(){$input[0].focus()},$scope.noFocus=function(event){event.stopImmediatePropagation()},$scope.select=function(idx){var item=$scope.matches[idx].model;$scope.tagCompleteTags.push(item),$scope.newTagName="",resetMatches(),$scope.tagCompleteOnSelect&&$scope.tagCompleteOnSelect({tag:item})},$scope.removeTag=function(tag){if($scope.tagCompleteTags){var idx=$scope.tagCompleteTags.indexOf(tag);idx>-1&&$scope.tagCompleteTags.splice(idx,1)}},resetMatches()}}}).directive("tagCompleteTag",function($http,$templateCache,$compile,$parse){"use strict";return{restrict:"EA",scope:{index:"=",tag:"=",labelField:"=",removeTag:"&"},link:function(scope,element,attrs){var tplUrl=$parse(attrs.templateUrl)(scope.$parent)||"/tag_complete/default_tag_template.html";$http.get(tplUrl,{cache:$templateCache}).success(function(tplContent){element.replaceWith($compile(tplContent.trim())(scope))})}}}),angular.module("sb.util").directive("tagInput",function(){"use strict";return{restrict:"E",replace:!0,scope:{selectedTags:"=ngModel"},require:"ngModel",controller:"TagInputController",templateUrl:"app/util/template/tag_input.html"}}),angular.module("sb.util").controller("TagInputController",function($element,$scope){"use strict";$scope.newTagName="",$scope.deletePressed=function(){return 0===$scope.newTagName.length?($scope.selectedTags.pop(),!0):!1},$scope.addTag=function(){$scope.selectedTags||($scope.selectedTags=[]),$scope.newTagName.length>0&&-1===$scope.selectedTags.indexOf($scope.newTagName)&&($scope.selectedTags.push($scope.newTagName),$scope.newTagName="")},$scope.focus=function(){$element.find("input[name=tagInputField]").focus()},$scope.noFocus=function(event){event.stopImmediatePropagation()}}),angular.module("sb.util").directive("activePath",function($location,$rootScope){"use strict";return{link:function($scope,element,attrs){function setActivePath(){var path=$location.path(),isMatchedPath=null!==path.match(activePath);element.toggleClass("active",isMatchedPath)}var activePath=attrs.activePath,disconnectBinding=$rootScope.$on("$stateChangeSuccess",setActivePath);$scope.$on("$destroy",disconnectBinding),setActivePath()}}}),angular.module("sb.util").directive("autoresizeWidth",function($document){"use strict";return{link:function($scope,$element){function recalculateSize(event){var value=$element.val()||"M";event&&"keypress"===event.type&&(value+=String.fromCharCode(event.which)),shadow.text(value),shadow.css("display","inline-block");try{$element[0].offsetWidth=shadow[0].offsetWidth}finally{shadow.css("display","none")}}var shadow=angular.element("<span></span>");shadow.attr("class",$element.attr("class")),shadow.css({display:"none","white-space":"pre",width:"auto",visibility:"hidden"}),$document.find("body").append(shadow),$scope.$on("$destroy",function(){shadow.remove()}),$element.bind("keypress keyup",recalculateSize),recalculateSize()}}}),angular.module("sb.util").directive("ngDelete",function(){"use strict";return function(scope,element,attrs){element.bind("keydown keypress",function(event){if(8===event.which){var preventDefault=!1;scope.$apply(function(){preventDefault=scope.$eval(attrs.ngDelete)}),preventDefault&&event.preventDefault()}})}}),angular.module("sb.util").directive("ngEnter",function(){"use strict";return function(scope,element,attrs){element.bind("keydown keypress",function(event){13===event.which&&(scope.$apply(function(){scope.$eval(attrs.ngEnter)}),event.preventDefault())})}}),angular.module("sb.util").directive("focus",function($timeout){"use strict";return{link:function($scope,$element,$attrs){var focus=$scope.$eval($attrs.focus);if("undefined"==typeof focus&&(focus=!0),focus){var e=$element[0];e&&e.focus&&$timeout(function(){e.focus()},10)}}}}),angular.module("sb.util").directive("inputInline",function(){"use strict";return{require:"ngModel",restrict:"E",templateUrl:"app/util/template/input_inline.html",scope:{enabled:"=",asInline:"=",autoFocus:"=",onChange:"&",emptyPrompt:"@",emptyDisabledPrompt:"@",maxLength:"="},link:function($scope,element,attrs,ngModel){$scope.showForm=!$scope.asInline,$scope.toggleForm=function(){$scope.asInline?$scope.showForm=$scope.enabled?!$scope.showForm:!1:$scope.showForm=!0},$scope.onInputBlur=function(value){value!==ngModel.$viewValue&&(ngModel.$setViewValue(value),$scope.onChange()),$scope.toggleForm()},$scope.$watch(function(){return ngModel.$viewValue},function(value){$scope.inputText!==value&&($scope.inputText=value?value:"")})}}}),angular.module("sb.util").directive("projectTypeahead",function(Project,$timeout){"use strict";return{require:"ngModel",restrict:"E",templateUrl:"app/util/template/project_typeahead.html",scope:{enabled:"=",asInline:"=",autoFocus:"=",onChange:"&",emptyPrompt:"@",emptyDisabledPrompt:"@"},link:function($scope,element,attrs,ngModel){$scope.showForm=!$scope.asInline,$scope.toggleForm=function(){$scope.asInline&&$scope.showForm?$timeout(function(){$scope.showForm=$scope.enabled?!$scope.showForm:!1},200):$scope.showForm=!0},$scope.searchProjects=function(value){return Project.browse({name:value,limit:10}).$promise},$scope.loadProject=function(){var projectId=ngModel.$viewValue||null;projectId?$scope.project=Project.get({id:projectId},function(project){$scope.selectedProject=project},function(){$scope.project=null,$scope.selectedProject=null}):($scope.project=null,$scope.selectedProject=null)},$scope.updateViewValue=function(value){value!==ngModel.$viewValue&&(ngModel.$setViewValue(value),$scope.onChange())},$scope.formatProjectName=function(model){return model?model.name:""},$scope.$watch(function(){return ngModel.$viewValue},$scope.loadProject)}}}),angular.module("sb.util").directive("resolveStory",function($parse,Story){"use strict";return{restrict:"A",scope:!0,link:function($scope,$element,$attrs){var storyId=$parse($attrs.resolveStory)($scope.$parent);storyId?$scope.story=Story.get({id:storyId}):$scope.story=null}}}),angular.module("sb.util").directive("ngShiftEnter",function(){"use strict";return function(scope,element,attrs){element.bind("keydown keypress",function(event){13===event.which&&event.shiftKey&&(scope.$apply(function(){scope.$eval(attrs.ngShiftEnter)}),event.preventDefault())})}}),angular.module("sb.util").directive("storyStatusLabel",function(){"use strict";return{restrict:"E",templateUrl:"app/util/template/story_status_label.html",scope:{story:"="},controller:function($scope){function getStoryStatus(){return $scope.story?$scope.story.status:null}function updateStoryLabel(){switch(getStoryStatus()){case"invalid":$scope.labelStyle="label-default";break;case"active":$scope.labelStyle="label-info";break;case"merged":$scope.labelStyle="label-success";break;default:$scope.labelStyle="label-default"}}var unwatch=$scope.$watch(getStoryStatus,updateStoryLabel);$scope.$on("$destroy",unwatch),updateStoryLabel()}}}),angular.module("sb.util").directive("storyTaskStatus",function(TaskStatus){"use strict";return{restrict:"E",templateUrl:"app/util/template/story_task_status.html",scope:{story:"="},link:function($scope){TaskStatus.query({},function(items){for(var statuses=[],i=0;i<items.length;i++)statuses[items[i].key]=items[i].name;$scope.status_texts=statuses})}}}),angular.module("sb.util").directive("taskPriorityDropdown",function(){"use strict";return{restrict:"E",templateUrl:"app/util/template/task_priority_dropdown.html",scope:{priority:"@",onChange:"&",editable:"@"},link:function($scope){$scope.style="default",$scope.setPriority=function(newPriority){newPriority!==$scope.priority&&($scope.priority=newPriority,$scope.onChange({priority:newPriority}))}}}}),angular.module("sb.util").directive("taskStatusDropdown",function(TaskStatus){"use strict";function setStyle(status){switch(status){case"invalid":return"default";case"merged":return"success";case"inprogress":return"info";case"review":return"warning";case"todo":return"default";default:return"default"}}return{restrict:"E",templateUrl:"app/util/template/task_status_dropdown.html",scope:{status:"@",onChange:"&",editable:"@"},link:function($scope){TaskStatus.query({},function(items){$scope.taskStatuses=items,$scope.statusName=$scope.status;for(var i=0;i<items.length;i++)items[i].key===$scope.status&&($scope.statusName=items[i].name)}),$scope.style=setStyle($scope.status),$scope.setStatus=function(newStatus){if(newStatus!==$scope.status){$scope.style=setStyle(newStatus),$scope.status=newStatus;for(var i=0;i<$scope.taskStatuses.length;i++)$scope.taskStatuses[i].key===$scope.status&&($scope.statusName=$scope.taskStatuses[i].name);$scope.onChange({status:newStatus})}}}}}),angular.module("sb.util").directive("timeMoment",function(DateUtil){"use strict";return{restrict:"A",templateUrl:"app/util/template/time_moment.html",scope:{eventdate:"=",shortDate:"="},controller:function($scope){function updateTimeAgo(){$scope.needsTimeAgo=DateUtil.needsTimeAgo($scope.eventdate)}var unwatch=$scope.$watch(updateTimeAgo);$scope.$on("$destroy",unwatch),updateTimeAgo()}}}),angular.module("sb.util").directive("timelineEvent",function($log){"use strict";return{restrict:"E",replace:!0,link:function(scope,element,attrs){var tlEvent;try{tlEvent=JSON.parse(attrs.tlEvent),scope.event_type=tlEvent.event_type}catch(error){$log.warn(error),scope.event_type="unknown"}},templateUrl:"app/stories/template/comments/template_switch.html"}}),angular.module("sb.util").directive("userTypeahead",function(User,$timeout){"use strict";return{require:"ngModel",restrict:"E",templateUrl:"app/util/template/user_typeahead.html",scope:{enabled:"=",asInline:"=",autoFocus:"=",onChange:"&",emptyPrompt:"@",emptyDisabledPrompt:"@"},link:function($scope,element,attrs,ngModel){$scope.showForm=!$scope.asInline,$scope.toggleForm=function(evt){evt&&!evt.target.value&&$scope.updateViewValue(null),$scope.asInline&&$scope.showForm?$timeout(function(){$scope.showForm=$scope.enabled?!$scope.showForm:!1},200):$scope.showForm=!0},$scope.searchUsers=function(value){return User.browse({full_name:value,limit:10}).$promise},$scope.loadUser=function(){var userId=ngModel.$viewValue||null;userId?User.get({id:userId},function(user){$scope.user=user,$scope.selectedUser=user},function(){$scope.user=null,$scope.selectedUser=null}):($scope.user=null,$scope.selectedUser=null)},$scope.updateViewValue=function(value){value!==ngModel.$viewValue&&(ngModel.$setViewValue(value),$scope.onChange())},$scope.handleEscapeKey=function(evt){27===evt.keyCode&&evt.target.blur()},$scope.handleEnterKey=function(evt){13===evt.keyCode&&(evt&&!evt.target.value&&$scope.updateViewValue(null),evt.target.blur())},$scope.formatUserName=function(model){return model?model.full_name:""},$scope.$watch(function(){return ngModel.$viewValue},$scope.loadUser)}}}),angular.module("sb.util").filter("capitalize",function(){"use strict";return function(value){try{return value.charAt(0).toUpperCase()+value.slice(1)}catch(e){return value}}}),angular.module("sb.util").filter("debug",function($log){"use strict";return function(value){return $log.debug("DEBUG",value),value}}),angular.module("sb.util").filter("taskPriorityLabel",function(){"use strict";return function(value){switch(value){case"high":return"High";case"medium":return"Medium";case"low":return"Low";default:return"Unknown Priority"}}}),angular.module("sb.util").filter("truncate",function(){"use strict";return function(value,length){return value&&value.length>length&&(value=value.substr(0,length-3)+"..."),value}}),angular.module("sb.util").factory("ArrayUtil",function(){"use strict";return{intersection:function(A,B){var result=[];return A.forEach(function(item){B.indexOf(item)>-1&&result.push(item)}),result},difference:function(U,A){var result=[];return U.forEach(function(item){-1===A.indexOf(item)&&result.push(item)}),result}}}),angular.module("sb.util").factory("DateUtil",function(){"use strict";return{needsTimeAgo:function(targetDate){if(targetDate){var currentDate=(new Date).getTime(),daydiff=(currentDate-Date.parse(targetDate))/864e5;return 1>daydiff}return!0}}}),angular.module("sb.util").factory("StringUtil",function(){"use strict";var defaultLength=32,alphaNumeric="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";return{randomAlphaNumeric:function(length){return this.random(length,alphaNumeric)},random:function(length,characters){length=length||defaultLength,characters=characters||alphaNumeric;for(var text="",i=0;length>i;i++)text+=characters.charAt(Math.floor(Math.random()*characters.length));return text}}}),angular.module("sb.util").factory("UrlUtil",function($window){"use strict";return{getFullUrlPrefix:function(){var origin=$window.location.origin,path=$window.location.pathname;return origin+path},buildApplicationUrl:function(fragment){return this.getFullUrlPrefix()+"#!"+fragment},serializeParameters:function(params){var pairs=[];for(var prop in params)params.hasOwnProperty(prop)&&pairs.push(encodeURIComponent(prop)+"="+encodeURIComponent(params[prop]));return pairs.join("&")},deserializeParameters:function(queryString){for(var params={},queryComponents=queryString.split("&"),i=0;i<queryComponents.length;i++){var parts=queryComponents[i].split("="),key=decodeURIComponent(parts[0])||null,value=decodeURIComponent(parts[1])||null;key&&value&&(params[key]=value)}return params}}}),angular.module("sb.util").factory("$searchParams",function($window,UrlUtil){"use strict";var params={},search=$window.location.search;return search?("?"===search.charAt(0)&&(search=search.substr(1)),UrlUtil.deserializeParameters(search)):params}),angular.module("sb.util").factory("LastLocation",function($rootScope,localStorageService,$location){"use strict";function onLocationChange(){var path=$location.path();path&&-1===path.indexOf("/auth")&&localStorageService.set("lastLocation",path)}return{get:function(){return localStorageService.get("lastLocation")},initialize:function(){$rootScope.$on("$destroy",$rootScope.$on("$locationChangeStart",onLocationChange))}}}).run(function(LastLocation){"use strict";LastLocation.initialize()}),angular.module("sb.worklist").controller("AddWorklistController",function($scope,$modalInstance,$state,params,Worklist){"use strict";$scope.save=function(){$scope.isSaving=!0,$scope.worklist.$create(function(result){$scope.isSaving=!1,$modalInstance.dismiss("success"),$state.go("sb.worklist.detail",{worklistID:result.id})})},$scope.close=function(){$modalInstance.dismiss("cancel")},$scope.isSaving=!1,$scope.worklist=new Worklist({title:""})}),angular.module("sb.worklist").controller("WorklistAddItemController",function($log,$scope,$state,worklist,$modalInstance,Story,Task,Criteria,Worklist,$q,valid){"use strict";$scope.worklist=worklist,$scope.items=[],$scope.saving=!1,$scope.loadingItems=!1,$scope.error={};var unstaged=function(item){var accept=!0;return angular.forEach($scope.items,function(selectedItem){selectedItem.hasOwnProperty("value")||(selectedItem.value=selectedItem.id),item.hasOwnProperty("value")||(item.value=item.id),selectedItem.type===item.type&&selectedItem.value===item.value&&(accept=!1,item.invalid=item.type+" is already waiting to be added.")}),accept};$scope.save=function(){$scope.saving=!0;for(var creates=[],offset=$scope.worklist.items.length,i=0;i<$scope.items.length;i++){var item=$scope.items[i],item_type="";"Task"===item.type?item_type="task":"Story"===item.type&&(item_type="story"),item.hasOwnProperty("value")||(item.value=item.id);var params={item_id:item.value,id:$scope.worklist.id,list_position:offset+i,item_type:item_type};valid(item)&&creates.push(Worklist.ItemsController.create(params).$promise)}$q.all(creates).then(function(){$scope.saving=!1,$modalInstance.dismiss("success")})},$scope.removeItem=function(item){var idx=$scope.items.indexOf(item);$scope.items.splice(idx,1)},$scope.targets=["Stories","Tasks"],$scope.searchTarget="Tasks",$scope.searchQuery="",$scope.searchItems=function(value){var searchString=value||"",searches=[];""!==searchString&&("Stories"===$scope.searchTarget?searches.push(Story.criteriaResolver(searchString,50)):"Tasks"===$scope.searchTarget&&searches.push(Task.criteriaResolver(searchString,50))),$q.all(searches).then(function(searchResults){for(var validated=[],invalid=[],addResult=function(item){valid(item)&&unstaged(item)?validated.push(item):invalid.push(item)},i=0;i<searchResults.length;i++){var results=searchResults[i];results&&(results.forEach?results.forEach(addResult):addResult(results))}$scope.searchResults=validated,$scope.invalidSearchResults=invalid})},$scope.setSearchTarget=function(target){$scope.searchTarget=target,$scope.searchItems($scope.searchQuery)},$scope.loadTasks=function(story){story.loadingTasks=!0,Task.browse({story_id:story.value},function(tasks){var results=[],invalid=[];angular.forEach(tasks,function(task){task.type="Task",valid(task)&&unstaged(task)?results.push(task):invalid.push(task)}),story.tasks=results,story.invalidTasks=invalid,story.loadingTasks=!1})},$scope.formatItemName=function(model){return model?model.title:""},$scope.selectTask=function(task,source,event){if(event.stopPropagation(),task.type="Task",$scope.items.push(task),source.length>0){var idx=source.indexOf(task);source.splice(idx,1)}},$scope.selectStory=function(story,source,event){if(event.stopPropagation(),story.type="Story",$scope.items.push(story),source.length>0){var idx=source.indexOf(story);source.splice(idx,1)}},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.worklist").controller("WorklistDeleteController",function($log,$scope,$state,worklist,redirect,$modalInstance,Worklist){"use strict";$scope.worklist=worklist,$scope.isUpdating=!0,$scope.error={},$scope.remove=function(){Worklist["delete"]({id:$scope.worklist.id},function(){return redirect&&$state.go("sb.dashboard.boards"),$modalInstance.close("success")})},$scope.close=function(){$modalInstance.dismiss("cancel")}}),angular.module("sb.worklist").controller("WorklistDetailController",function($scope,$modal,$timeout,$stateParams,Worklist,BoardHelper,$document,User,$q){"use strict";function resolvePermissions(){$scope.owners=[],$scope.users=[],angular.forEach($scope.worklist.owners,function(id){$scope.owners.push(User.get({id:id}))}),angular.forEach($scope.worklist.users,function(id){$scope.users.push(User.get({id:id}))})}function loadWorklist(){var params={id:$stateParams.worklistID};Worklist.Permissions.get(params,function(perms){$scope.permissions={editWorklist:perms.indexOf("edit_worklist")>-1,moveItems:perms.indexOf("move_items")>-1}}),Worklist.get(params,function(result){$scope.worklist=result,resolvePermissions()})}function showAddItemModal(){var modalInstance=$modal.open({size:"lg",templateUrl:"app/worklists/template/additem.html",controller:"WorklistAddItemController",resolve:{worklist:function(){return $scope.worklist},valid:function(){return function(){return!0}}}});return modalInstance.result}$scope.update=function(){var params={id:$scope.worklist.id},owners={codename:"edit_worklist",users:$scope.worklist.owners},users={codename:"move_items",users:$scope.worklist.users};$scope.worklist.$update().then(function(){var updating=[Worklist.Permissions.update(params,owners).$promise,Worklist.Permissions.update(params,users).$promise];$q.all(updating).then(function(){$scope.toggleEditMode()})})},$scope.toggleEditMode=function(){$scope.editing&&loadWorklist(),$scope.editing=!$scope.editing},$scope.addItem=function(){showAddItemModal()["finally"](loadWorklist)},$scope.removeListItem=function(item){Worklist.ItemsController["delete"]({id:$scope.worklist.id,item_id:item.id}).$promise.then(function(){var idx=$scope.worklist.items.indexOf(item);$scope.worklist.items.splice(idx,1)})},$scope.remove=function(){var modalInstance=$modal.open({templateUrl:"app/worklists/template/delete.html",controller:"WorklistDeleteController",resolve:{worklist:function(){return $scope.worklist},redirect:function(){return!0}}});return modalInstance.result},$scope.searchUsers=function(value,array){var deferred=$q.defer();return User.browse({full_name:value,limit:10},function(searchResults){var results=[];angular.forEach(searchResults,function(result){-1===array.indexOf(result.id)&&results.push(result)}),deferred.resolve(results)}),deferred.promise},$scope.formatUserName=function(model){return model?model.name:""},$scope.addUser=function(model,modelArray,idArray){idArray.push(model.id),modelArray.push(model)},$scope.removeUser=function(model,modelArray,idArray){var idIdx=idArray.indexOf(model.id);idArray.splice(idIdx,1);var modelIdx=modelArray.indexOf(model);modelArray.splice(modelIdx,1)},$scope.sortableOptions={accept:function(sourceHandle,dest){return sourceHandle.itemScope.sortableScope.$id===dest.$id},orderChanged:function(result){for(var list=result.dest.sortableScope.$parent.worklist,i=0;i<list.items.length;i++){var item=list.items[i];Worklist.ItemsController.update({id:list.id,item_id:item.id,list_position:i})}}},$document[0].ondragstart=function(event){event.preventDefault()},loadWorklist()}),angular.module("sb.worklist").factory("NewWorklistService",function($modal,$log,Session,SessionModalService){"use strict";return{showNewWorklistModal:function(userId){if(Session.isLoggedIn()){var modalInstance=$modal.open({templateUrl:"app/worklists/template/new.html",controller:"AddWorklistController",resolve:{params:function(){return{userId:userId||null}}}});return modalInstance.result}return SessionModalService.showLoginRequiredModal()}}});