bifrost-create-vm-nodes
=======================

This role creates virtual machines for testing bifrost.

Requirements
------------

The following packages are required and ensured to be present:
- libvirt-bin
- qemu-utils
- qemu-kvm
- sgabios
- python-libvirt
- python-lxml


Warning
-------

For backward compatibility some variables listed below may default to values
of corresponding shell variables on the management host (where
ansible-playbook is launched) as described.
This behavior is deprecated and will be removed in the Queens release.
Non-default values for these variables should be passed to ansible-playbook
as extra-vars instead.

Role Variables
--------------

baremetal_csv_file: Deprecated. CSV file format is deprecated, and
                    this variable will be removed in the Queens release.
                    Use 'baremetal_json_file' variable instead.
                    Default is undefined. If defined, its value will be
                    used for 'baremetal_json_file' variable (see below),
                    although file created will still be in JSON format.

baremetal_json_file: Defaults to '/tmp/baremetal.json' but will be overridden
                     by 'baremetal_csv_file' if that is defined.

test_vm_memory_size: Tunable setting to allow a user to define a specific
                     amount of RAM in MB to allocate to guest/test VMs.
                     Defaults to "3072". Note: if this setting is modified
                     between test runs, you may need to undefine the test
                     virtual machine(s) that were previously created.

test_vm_domain_type: Tunable setting to allow a user to chosee the domain
                     type of the created VMs. The default is "qemu" and can
                     be set to kvm to enable kvm acceleration.

test_vm_num_nodes: Tunable setting to allow a user to define the number of
                   test VMs that will be created. They will all be created
                   with same settings.

test_vm_arch: Defines the architecture of VM to create.
              Defaults to "x86_64".
              The value of this variable is passed directly to libvirt
              when creating VMs.
              Generally users should not need to modify this setting.
              Any other than default value is untested.

test_vm_disk_gib: Disk size for VMs to be created, in GiB.
                  Defaults to shell variable 'VM_DISK' or,
                  if that is not set, to 10.

test_vm_cpu_count: Number of CPUs to create the VMs with.
                   Defaults to shell variable 'VM_CPU', or,
                   if that is not set, to 1.

test_vm_disk_cache: Disk cache mode to use by VMs disk.
                    Defaults to shell variable 'VM_DISK_CACHE', or,
                    if that is not set, to 'writeback'.

test_vm_node_names: Space-separated names for nodes to be created.
                    Defaults to shell variable 'TEST_VM_NODE_NAMES'.
                    If not set, VM names will be autogenerated.
                    Note that independent on the number of names in this list,
                    at most 'test_vm_num_nodes' VMs will be created.

test_vm_node_name_base: Base name to generate VM names when names
                        are not explicitly set.
                        Defaults to shell variable 'NODEBASE', or,
                        if that is not set, to 'testvm'.

test_vm_network: Name of the libvirt network to create the nodes on.
                 Defaults to shell variable 'VM_NET_BRIDGE', or,
                 if that is not set, to 'default'.

test_vm_storage_pool: Name of the libvirt storage pool to create disks
                      for VMs in.
                      Defaults to shell variable 'LIBVIRT_STORAGE_POOL', or,
                      if that is not set, to 'default'.
                      If absent, this pool will be created.

test_vm_storage_pool_path: Path used by the libvirt storage pool
                           'test_vm_storage_pool' if it has to be created.
                           Defaults to "/var/lib/libvirt/images".

test_vm_logdir: Folder where to store VM logs.
                Defaults to "/var/log/libvirt/baremetal_logs".

test_vm_emulator: Path to emulator executable used to define VMs in libvirt.
                  Defaults to "/usr/bin/qemu-system-x86_64".
                  Generally users should not need to modify this setting,
                  as it is OS-specific and is overwritten by
                  os/distribution-specific defaults in this role when needed.

test_vm_machine: Type of the VM to define in libvirt.
                 Defaults to "pc-1.0".
                 Generally users should not need to modify this setting,
                 as it is OS-specific and is overwritten by
                 os/distribution-specific defaults in this role when needed.

test_vm_libvirt_uri: URI to connect to libvirt for networks, storage and VM
                     related actions.
                     Defaults to shell variable 'LIBVIRT_CONNECT_URI', or,
                     if that is not set, to 'qemu:///system'.
                     Note that currently connecting to remote libvirt is
                     not tested and is unsupported.

test_vm_network: Name of the libvirt network to create for VMs.
                 Defaults to shell variable 'VM_NET_BRIDGE', or, if that is
                 not set, to 'default'.
                 The network is created only if it does not already exist.

network_interface: Name of the bridge to create when creating
                   'test_vm_network' libvirt network.
                   Defaults to "virbr0".
                   Name and default of this option are chosen to be the same
                   as in 'bifrost-ironic-install' role.

test_vm_network_ip: IP for the 'network_interface' bridge.
                    Defaults to '192.168.122.1'.
                    This setting is applied only when 'test_vm_network'
                    was absent and is created from scratch.

test_vm_network_netmask: Subnet mask for 'network_interface' bridge.
                         Defaults to '255.255.255.0'.
                         This setting is applied only when 'test_vm_network'
                         was absent and is created from scratch.

test_vm_network_enable_dhcp: Whether to enable DHCP on 'test_vm_network'.
                             Defaults to 'true'.
                             This setting is applied only when
                             'test_vm_network' was absent and is created
                             from scratch.

test_vm_network_dhcp_start: Start of DHCP range for 'test_vm_network'.
                            Defaults to '192.168.122.2'.
                            This setting is applied only when
                            'test_vm_network' was absent and is created
                            from scratch and when
                            'test_vm_network_enable_dhcp' is enabled.

test_vm_network_dhcp_end: End of of DHCP range for 'test_vm_network'.
                          Defaults to '192.168.122.254'.
                          This setting is applied only when
                          'test_vm_network' was absent and is created
                          from scratch and when
                          'test_vm_network_enable_dhcp' is enabled.

Dependencies
------------

None at this time.

Example Playbook
----------------

- hosts: localhost
  connection: local
  become: yes
  gather_facts: yes
  roles:
    - role: bifrost-create-vm-nodes

License
-------

Copyright (c) 2015 Hewlett-Packard Development Company, L.P.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Author Information
------------------

Ironic Developers
