/*
 * Decompiled with CFR 0.152.
 */
package com.rackspace.cloud.api.docs;

import com.agilejava.docbkx.maven.AbstractFoMojo;
import com.agilejava.docbkx.maven.PreprocessingFilter;
import com.agilejava.docbkx.maven.TransformerBuilder;
import com.rackspace.cloud.api.docs.CalabashHelper;
import com.rackspace.cloud.api.docs.DocBookResolver;
import com.rackspace.cloud.api.docs.FileUtils;
import com.rackspace.cloud.api.docs.GitHelper;
import com.rackspace.cloud.api.docs.GlossaryResolver;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class PDFMojo
extends AbstractFoMojo {
    private File imageDirectory;
    private File sourceDirectory;
    private File sourceDocBook;
    private File coverImageTemplate;
    private File coverImage;
    private static final String COVER_IMAGE_TEMPLATE_NAME = "cover.st";
    private static final String COVER_IMAGE_NAME = "cover.svg";
    private static final String COVER_XSL = "cloud/cover.xsl";
    private File projectBuildDirectory;
    private String branding;
    private String builtForOpenStack;
    private String coverLogoPath;
    private String secondaryCoverLogoPath;
    private String coverLogoLeft;
    private String coverLogoTop;
    private String coverUrl;
    private String coverColor;
    private String pageWidth;
    private String pageHeight;
    private String omitCover;
    private String doubleSided;
    private String variablelistAsBlocks;
    private String trimWadlUriCount;
    private String computeWadlPathFromDocbookPath;
    private String canonicalUrlBase;
    private String replacementsFile;
    private String failOnValidationError;
    private String security;
    private boolean strictImageValidation;
    private String draftStatus;
    private String statusBarText;
    private String bodyFont;
    private String monospaceFont;
    private String localFontPath;

    protected void setImageDirectory(File imageDirectory) {
        this.imageDirectory = imageDirectory;
    }

    protected File getImageDirectory() {
        return this.imageDirectory;
    }

    protected String getNonDefaultStylesheetLocation() {
        return "cloud/fo/docbook.xsl";
    }

    public void preProcess() throws MojoExecutionException {
        super.preProcess();
        File targetDirectory = this.getTargetDirectory();
        File imageParentDirectory = targetDirectory.getParentFile();
        File xslParentDirectory = targetDirectory.getParentFile();
        if (!targetDirectory.exists()) {
            FileUtils.mkdir(targetDirectory);
        }
        FileUtils.extractJaredDirectory("images", PDFMojo.class, imageParentDirectory);
        this.setImageDirectory(new File(imageParentDirectory, "images"));
        FileUtils.extractJaredDirectory("cloud/war", PDFMojo.class, xslParentDirectory);
        FileUtils.extractJaredDirectory("fonts", PDFMojo.class, imageParentDirectory);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void postProcessResult(File result) throws MojoExecutionException {
        FopFactory fopFactory = FopFactory.newInstance();
        FOUserAgent userAgent = fopFactory.newFOUserAgent();
        this.transformCover();
        Configuration configuration = this.loadFOPConfig();
        InputStream in = null;
        OutputStream out = null;
        try {
            String baseURL = this.sourceDirectory.toURI().toURL().toExternalForm();
            baseURL = baseURL.replace("file:/", "file:///");
            userAgent.setBaseURL(baseURL);
            System.err.println("Absolute path is " + baseURL);
            in = this.openFileForInput(result);
            out = this.openFileForOutput(this.getOutputFile(result));
            fopFactory.setUserConfig(configuration);
            Fop fop = fopFactory.newFop("application/pdf", userAgent, out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            StreamSource src = new StreamSource(in);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        catch (FOPException e) {
            try {
                throw new MojoExecutionException("Failed to convert to PDF", (Exception)((Object)e));
                catch (TransformerConfigurationException e2) {
                    throw new MojoExecutionException("Failed to load JAXP configuration", (Exception)e2);
                }
                catch (TransformerException e3) {
                    throw new MojoExecutionException("Failed to transform to PDF", (Exception)e3);
                }
                catch (MalformedURLException e4) {
                    throw new MojoExecutionException("Failed to get FO basedir", (Exception)e4);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)in);
    }

    protected InputStream openFileForInput(File file) throws MojoExecutionException {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fnfe) {
            throw new MojoExecutionException("Failed to open " + file + " for input.");
        }
    }

    protected File getOutputFile(File inputFile) {
        return new File(inputFile.getAbsolutePath().replaceAll(".fo$", ".pdf"));
    }

    protected OutputStream openFileForOutput(File file) throws MojoExecutionException {
        try {
            return new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException fnfe) {
            throw new MojoExecutionException("Failed to open " + file + " for output.");
        }
    }

    protected Configuration loadFOPConfig() throws MojoExecutionException {
        System.out.println("At load config");
        String fontPath = null != this.localFontPath && this.localFontPath != "" ? this.localFontPath : new File(this.getTargetDirectory().getParentFile(), "fonts").getAbsolutePath();
        StringTemplateGroup templateGroup = new StringTemplateGroup("fonts", fontPath);
        StringTemplate template = templateGroup.getInstanceOf("fontconfig");
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        template.setAttribute("fontPath", (Object)fontPath);
        String config = template.toString();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)config);
        }
        try {
            return builder.build(IOUtils.toInputStream((String)config));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Failed to load FOP config.", (Exception)ioe);
        }
        catch (SAXException saxe) {
            throw new MojoExecutionException("Failed to parse FOP config.", (Exception)saxe);
        }
        catch (ConfigurationException e) {
            throw new MojoExecutionException("Failed to do something Avalon requires....", (Exception)((Object)e));
        }
    }

    protected TransformerBuilder createTransformerBuilder(URIResolver resolver) {
        return super.createTransformerBuilder((URIResolver)new GlossaryResolver(new DocBookResolver(resolver, this.getType()), this.getType()));
    }

    public void adjustTransformer(Transformer transformer, String sourceFilename, File targetFile) {
        GitHelper.addCommitProperties(transformer, this.projectBuildDirectory, 7, this.getLog());
        super.adjustTransformer(transformer, sourceFilename, targetFile);
        transformer.setParameter("branding", this.branding);
        transformer.setParameter("builtForOpenStack", this.builtForOpenStack);
        transformer.setParameter("coverLogoPath", this.coverLogoPath);
        if (null != this.secondaryCoverLogoPath) {
            transformer.setParameter("secondaryCoverLogoPath", this.secondaryCoverLogoPath);
        }
        transformer.setParameter("coverLogoLeft", this.coverLogoLeft);
        transformer.setParameter("coverLogoTop", this.coverLogoTop);
        transformer.setParameter("coverUrl", this.coverUrl);
        transformer.setParameter("coverColor", this.coverColor);
        if (null != this.pageWidth) {
            transformer.setParameter("page.width", this.pageWidth);
        }
        if (null != this.pageHeight) {
            transformer.setParameter("page.height", this.pageHeight);
        }
        if (null != this.omitCover) {
            transformer.setParameter("omitCover", this.omitCover);
        }
        if (null != this.doubleSided) {
            transformer.setParameter("double.sided", this.doubleSided);
        }
        String sysDraftStatus = System.getProperty("draft.status");
        if (this.getLog().isDebugEnabled()) {
            this.getLog().info((CharSequence)("adjustTransformer():sysDraftStatus=" + sysDraftStatus));
        }
        if (null != sysDraftStatus && !sysDraftStatus.isEmpty()) {
            this.draftStatus = sysDraftStatus;
        }
        transformer.setParameter("draft.status", this.draftStatus);
        String sysStatusBarText = System.getProperty("statusBarText");
        if (null != sysStatusBarText && !sysStatusBarText.isEmpty()) {
            this.statusBarText = sysStatusBarText;
        }
        if (this.statusBarText != null) {
            transformer.setParameter("statusBarText", this.statusBarText);
        }
        if (this.bodyFont != null) {
            transformer.setParameter("bodyFont", this.bodyFont);
        }
        if (this.monospaceFont != null) {
            transformer.setParameter("monospaceFont", this.monospaceFont);
        }
        transformer.setParameter("project.build.directory", this.projectBuildDirectory.toURI().toString());
        String sysSecurity = System.getProperty("security");
        if (this.getLog().isDebugEnabled()) {
            this.getLog().info((CharSequence)("adjustTransformer():sysSecurity=" + sysSecurity));
        }
        if (null != sysSecurity && !sysSecurity.isEmpty()) {
            this.security = sysSecurity;
        }
        if (this.security != null) {
            transformer.setParameter("security", this.security);
        }
        if (this.trimWadlUriCount != null) {
            transformer.setParameter("trim.wadl.uri.count", this.trimWadlUriCount);
        }
        this.sourceDocBook = new File(sourceFilename);
        this.sourceDirectory = this.sourceDocBook.getParentFile();
        File imageDirectory = this.getImageDirectory();
        File calloutDirectory = new File(imageDirectory, "callouts");
        transformer.setParameter("docbook.infile", this.sourceDocBook.toURI().toString());
        transformer.setParameter("source.directory", this.sourceDirectory.toURI().toString());
        transformer.setParameter("compute.wadl.path.from.docbook.path", this.computeWadlPathFromDocbookPath);
        transformer.setParameter("admon.graphics.path", imageDirectory.toURI().toString());
        transformer.setParameter("callout.graphics.path", calloutDirectory.toURI().toString());
        File cloudSub = new File(imageDirectory, "cloud");
        File ccSub = new File(imageDirectory, "cc");
        this.coverImage = new File(cloudSub, COVER_IMAGE_NAME);
        this.coverImageTemplate = new File(cloudSub, COVER_IMAGE_TEMPLATE_NAME);
        this.coverImageTemplate = new File(cloudSub, "rackspace-cover.st");
        transformer.setParameter("cloud.api.background.image", this.coverImage.toURI().toString());
        transformer.setParameter("cloud.api.cc.image.dir", ccSub.toURI().toString());
    }

    protected void transformCover() throws MojoExecutionException {
        try {
            String sysStatusBarText;
            String sysDraftStatus;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(classLoader.getResourceAsStream(COVER_XSL)));
            if (this.coverColor != null) {
                transformer.setParameter("coverColor", this.coverColor);
            }
            if (null != (sysDraftStatus = System.getProperty("draft.status")) && !sysDraftStatus.isEmpty()) {
                this.draftStatus = sysDraftStatus;
            }
            if (null != this.draftStatus) {
                transformer.setParameter("draft.status", this.draftStatus);
            }
            if (null != (sysStatusBarText = System.getProperty("statusBarText")) && !sysStatusBarText.isEmpty()) {
                this.statusBarText = sysStatusBarText;
            }
            if (null != this.statusBarText) {
                transformer.setParameter("status.bar.text", this.statusBarText);
            }
            transformer.setParameter("branding", this.branding);
            String srcFilename = this.sourceDocBook.getName();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().info((CharSequence)("SOURCE FOR COVER PAGE: " + this.projectBuildDirectory + "/docbkx/" + srcFilename));
            }
            transformer.setParameter("docbook.infile", new File(this.projectBuildDirectory, "docbkx/" + srcFilename).toURI().toString());
            transformer.transform(new StreamSource(this.coverImageTemplate), new StreamResult(this.coverImage));
        }
        catch (TransformerConfigurationException e) {
            throw new MojoExecutionException("Failed to load JAXP configuration", (Exception)e);
        }
        catch (TransformerException e) {
            throw new MojoExecutionException("Failed to transform to cover", (Exception)e);
        }
    }

    protected Source createSource(String inputFilename, File sourceFile, PreprocessingFilter filter) throws MojoExecutionException {
        String pathToPipelineFile = "classpath:///pdf.xpl";
        String sourceFileNameNormalized = sourceFile.toURI().toString();
        InputSource inputSource = new InputSource(sourceFileNameNormalized);
        SAXSource source = new SAXSource((XMLReader)filter, inputSource);
        HashMap<String, Object> map = new HashMap<String, Object>();
        String sysSecurity = System.getProperty("security");
        this.getLog().info((CharSequence)("adjustTransformer():sysSecurity=" + sysSecurity));
        if (null != sysSecurity && !sysSecurity.isEmpty()) {
            this.security = sysSecurity;
        }
        map.put("targetDirectory", this.getTargetDirectory().getParentFile());
        map.put("targetHtmlContentDir", new File(this.getTargetDirectory(), "/wadls/"));
        map.put("security", this.security);
        map.put("canonicalUrlBase", this.canonicalUrlBase);
        map.put("replacementsFile", this.replacementsFile);
        map.put("failOnValidationError", this.failOnValidationError);
        map.put("project.build.directory", this.projectBuildDirectory);
        map.put("inputSrcFile", inputFilename);
        map.put("outputType", "pdf");
        map.put("strictImageValidation", String.valueOf(this.strictImageValidation));
        map.put("status.bar.text", this.getProperty("statusBarText"));
        map.put("bodyFont", this.getProperty("bodyFont"));
        map.put("monospaceFont", this.getProperty("monospaceFont"));
        map.put("draft.status", this.getProperty("draftStatus"));
        map.put("profile.os", this.getProperty("profileOs"));
        map.put("profile.arch", this.getProperty("profileArch"));
        map.put("profile.condition", this.getProperty("profileCondition"));
        map.put("profile.audience", this.getProperty("profileAudience"));
        map.put("profile.conformance", this.getProperty("profileConformance"));
        map.put("profile.revision", this.getProperty("profileRevision"));
        map.put("profile.userlevel", this.getProperty("profileUserlevel"));
        map.put("profile.vendor", this.getProperty("profileVendor"));
        return CalabashHelper.createSource(this.getLog(), source, pathToPipelineFile, map);
    }
}

