/*
 * Decompiled with CFR 0.152.
 */
package com.rackspace.cloud.api.docs;

import com.agilejava.docbkx.maven.AbstractWebhelpMojo;
import com.agilejava.docbkx.maven.PreprocessingFilter;
import com.agilejava.docbkx.maven.TransformerBuilder;
import com.rackspace.cloud.api.docs.CalabashHelper;
import com.rackspace.cloud.api.docs.DocBookResolver;
import com.rackspace.cloud.api.docs.FileUtils;
import com.rackspace.cloud.api.docs.GitHelper;
import com.rackspace.cloud.api.docs.PDFMojo;
import com.rackspace.cloud.api.docs.builders.PDFBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Properties;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class WebHelpMojo
extends AbstractWebhelpMojo {
    private String glossaryUri;
    private File sourceDirectory;
    private File sourceDocBook;
    private File atomFeed;
    private File atomFeedClean;
    private static final String COPY_XSL = "cloud/webhelp/copy.xsl";
    private MavenProject docProject;
    private File projectBuildDirectory;
    private String webhelpWar;
    private String publicationNotificationEmails;
    private String includeDateInPdfFilename;
    private String pdfFilenameBase;
    private String webhelpDirname;
    private String showChangebars;
    private String builtForOpenStack;
    private String coverLogoPath;
    private String secondaryCoverLogoPath;
    private String coverLogoLeft;
    private String coverLogoTop;
    private String coverUrl;
    private String coverColor;
    private String pageWidth;
    private String pageHeight;
    private String omitCover;
    private String doubleSided;
    private String metaRobots;
    private String useVersionForDisqus;
    private String useDisqusId;
    private String disqusIdentifier;
    private String branding;
    private String enableDisqus;
    private String disqusShortname;
    private String enableGoogleAnalytics;
    private String googleAnalyticsId;
    private String googleAnalyticsDomain;
    private String pdfUrl;
    private String autoPdfUrl;
    private String useLatestSuffixInPdfUrl;
    private String canonicalUrlBase;
    private String replacementsFile;
    private boolean makePdf;
    private boolean strictImageValidation;
    private String failOnValidationError;
    private String commentsPhp;
    private String security;
    private File baseDir;
    private String transformDir;
    private String trimWadlUriCount;
    private String computeWadlPathFromDocbookPath;
    private String feedbackEmail;
    private String socialIcons;
    private String legalNoticeUrl;
    private String draftStatus;
    private String statusBarText;
    private String bodyFont;
    private String monospaceFont;
    private String localFontPath;

    public void adjustTransformer(Transformer transformer, String sourceFilename, File targetFile) {
        String sysSecurity;
        String sysWebhelpWar;
        GitHelper.addCommitProperties(transformer, this.baseDir, 7, this.getLog());
        String webhelpOutdir = targetFile.getName().substring(0, targetFile.getName().lastIndexOf(46));
        String warBasename = null != this.webhelpDirname && !this.webhelpDirname.isEmpty() ? this.webhelpDirname : webhelpOutdir;
        targetFile = new File(this.getTargetDirectory() + "/" + warBasename + "/dummy.webhelp");
        super.adjustTransformer(transformer, sourceFilename, targetFile);
        transformer.setParameter("groupId", this.docProject.getGroupId());
        transformer.setParameter("artifactId", this.docProject.getArtifactId());
        transformer.setParameter("docProjectVersion", this.docProject.getVersion());
        transformer.setParameter("pomProjectName", this.docProject.getName());
        if (this.commentsPhp != null) {
            transformer.setParameter("comments.php", this.commentsPhp);
        }
        if (this.glossaryUri != null) {
            transformer.setParameter("glossary.uri", this.glossaryUri);
        }
        if (this.feedbackEmail != null) {
            transformer.setParameter("feedback.email", this.feedbackEmail);
        }
        if (this.useDisqusId != null) {
            transformer.setParameter("use.disqus.id", this.useDisqusId);
        }
        if (this.useVersionForDisqus != null) {
            transformer.setParameter("use.version.for.disqus", this.useVersionForDisqus);
        }
        transformer.setParameter("project.build.directory", this.projectBuildDirectory.toURI().toString());
        transformer.setParameter("branding", this.branding);
        transformer.setParameter("autoPdfUrl", this.autoPdfUrl);
        if (null != this.builtForOpenStack) {
            transformer.setParameter("builtForOpenStack", this.builtForOpenStack);
        }
        transformer.setParameter("coverLogoPath", this.coverLogoPath);
        if (null != this.secondaryCoverLogoPath) {
            transformer.setParameter("secondaryCoverLogoPath", this.secondaryCoverLogoPath);
        }
        transformer.setParameter("coverLogoLeft", this.coverLogoLeft);
        transformer.setParameter("coverLogoTop", this.coverLogoTop);
        transformer.setParameter("coverUrl", this.coverUrl);
        transformer.setParameter("coverColor", this.coverColor);
        if (null != this.pageWidth) {
            transformer.setParameter("page.width", this.pageWidth);
        }
        if (null != this.pageHeight) {
            transformer.setParameter("page.height", this.pageHeight);
        }
        if (null != this.omitCover) {
            transformer.setParameter("omitCover", this.omitCover);
        }
        if (null != this.doubleSided) {
            transformer.setParameter("double.sided", this.doubleSided);
        }
        transformer.setParameter("enable.disqus", this.enableDisqus);
        if (this.disqusShortname != null) {
            transformer.setParameter("disqus.shortname", this.disqusShortname);
        }
        if (this.disqusIdentifier != null) {
            transformer.setParameter("disqus_identifier", this.disqusIdentifier);
        }
        if (this.enableGoogleAnalytics != null) {
            transformer.setParameter("enable.google.analytics", this.enableGoogleAnalytics);
        }
        if (this.googleAnalyticsId != null) {
            transformer.setParameter("google.analytics.id", this.googleAnalyticsId);
        }
        if (this.googleAnalyticsDomain != null) {
            transformer.setParameter("google.analytics.domain", this.googleAnalyticsDomain);
        }
        if (this.pdfUrl != null) {
            transformer.setParameter("pdf.url", this.pdfUrl);
        }
        if (this.useLatestSuffixInPdfUrl != null) {
            transformer.setParameter("useLatestSuffixInPdfUrl", this.useLatestSuffixInPdfUrl);
        }
        if (this.legalNoticeUrl != null) {
            transformer.setParameter("legal.notice.url", this.legalNoticeUrl);
        }
        if (null != (sysWebhelpWar = System.getProperty("webhelp.war")) && !sysWebhelpWar.isEmpty()) {
            this.webhelpWar = sysWebhelpWar;
        }
        transformer.setParameter("webhelp.war", this.webhelpWar);
        if (null != this.includeDateInPdfFilename) {
            transformer.setParameter("includeDateInPdfFilename", this.includeDateInPdfFilename);
        }
        transformer.setParameter("pdfFilenameBase", this.pdfFilenameBase);
        transformer.setParameter("webhelpDirname", this.webhelpDirname);
        transformer.setParameter("publicationNotificationEmails", this.publicationNotificationEmails);
        String sysDraftStatus = System.getProperty("draft.status");
        if (null != sysDraftStatus && !sysDraftStatus.isEmpty()) {
            this.draftStatus = sysDraftStatus;
        }
        transformer.setParameter("draft.status", this.draftStatus);
        String sysStatusBarText = System.getProperty("statusBarText");
        if (null != sysStatusBarText && !sysStatusBarText.isEmpty()) {
            this.statusBarText = sysStatusBarText;
        }
        if (null != this.statusBarText) {
            transformer.setParameter("status.bar.text", this.statusBarText);
        }
        if (null != this.bodyFont) {
            transformer.setParameter("bodyFont", this.bodyFont);
        }
        if (null != this.monospaceFont) {
            transformer.setParameter("monospaceFont", this.monospaceFont);
        }
        if (this.canonicalUrlBase != null) {
            transformer.setParameter("canonical.url.base", this.canonicalUrlBase);
        }
        if (null != (sysSecurity = System.getProperty("security")) && !sysSecurity.isEmpty()) {
            this.security = sysSecurity;
        }
        if (this.security != null) {
            transformer.setParameter("security", this.security);
        }
        if (this.showChangebars != null) {
            transformer.setParameter("show.changebars", this.showChangebars);
        }
        if (this.metaRobots != null) {
            transformer.setParameter("meta.robots", this.metaRobots);
        }
        if (this.trimWadlUriCount != null) {
            transformer.setParameter("trim.wadl.uri.count", this.trimWadlUriCount);
        }
        transformer.setParameter("social.icons", this.socialIcons);
        this.sourceDocBook = new File(sourceFilename);
        this.sourceDirectory = this.sourceDocBook.getParentFile();
        transformer.setParameter("docbook.infile", this.sourceDocBook.toURI().toString());
        transformer.setParameter("source.directory", this.sourceDirectory.toURI().toString());
        transformer.setParameter("compute.wadl.path.from.docbook.path", this.computeWadlPathFromDocbookPath);
    }

    protected TransformerBuilder createTransformerBuilder(URIResolver resolver) {
        return super.createTransformerBuilder((URIResolver)new DocBookResolver(resolver, this.getType()));
    }

    protected String getNonDefaultStylesheetLocation() {
        return "cloud/webhelp/profile-webhelp.xsl";
    }

    public void postProcessResult(File result) throws MojoExecutionException {
        String warSuffixForWar;
        String webhelpOutdir = result.getName().substring(0, result.getName().lastIndexOf(46));
        String warBasename = null != this.webhelpDirname && !this.webhelpDirname.isEmpty() ? this.webhelpDirname : webhelpOutdir;
        result = new File(this.getTargetDirectory() + "/" + warBasename + "/" + "dummy.xml");
        super.postProcessResult(result);
        this.copyTemplate(result);
        this.transformFeed(result);
        Properties properties = new Properties();
        FileInputStream is = null;
        try {
            File f = new File(result.getParentFile(), "webapp/WEB-INF/bookinfo.properties");
            is = new FileInputStream(f);
            properties.load(is);
        }
        catch (Exception e) {
            System.out.println("Got an Exception: " + e.getMessage());
        }
        warBasename = warBasename == null ? null : new File(warBasename).getName();
        String warSuffix = this.webhelpDirname != null ? "" : properties.getProperty("warsuffix", "");
        String warPrefix = this.webhelpDirname != null ? "" : properties.getProperty("warprefix", "");
        String string = warSuffixForWar = warSuffix.equals("-external") ? "" : warSuffix;
        if (null != this.webhelpWar && !"0".equals(this.webhelpWar)) {
            File sourceDir = new File(result.getParentFile().getParentFile(), warBasename);
            File zipFile = new File(result.getParentFile().getParentFile(), warPrefix + warBasename + warSuffixForWar + ".war");
            try {
                FileOutputStream fout = new FileOutputStream(zipFile);
                ZipOutputStream zout = new ZipOutputStream(fout);
                FileUtils.addDirectory(zout, sourceDir);
                zout.close();
            }
            catch (IOException ioe) {
                System.out.println("IOException :" + ioe);
            }
        }
        File webhelpDirWithSecurity = new File(result.getParentFile().getParentFile(), warBasename + warSuffix);
        File webhelpOrigDir = new File(result.getParentFile().getParentFile(), webhelpOutdir);
        boolean success = webhelpOrigDir.renameTo(webhelpDirWithSecurity);
    }

    protected void copyTemplate(File result) throws MojoExecutionException {
        File targetDirectory = result.getParentFile();
        FileUtils.extractJaredDirectory("content", WebHelpMojo.class, targetDirectory);
        FileUtils.extractJaredDirectory("common", WebHelpMojo.class, targetDirectory);
        com.agilejava.docbkx.maven.FileUtils.copyFile((File)new File(targetDirectory, "common/images/favicon-" + this.branding + ".ico"), (File)new File(targetDirectory, "favicon.ico"));
        com.agilejava.docbkx.maven.FileUtils.copyFile((File)new File(targetDirectory, "common/css/positioning-" + this.branding + ".css"), (File)new File(targetDirectory, "common/css/positioning.css"));
        com.agilejava.docbkx.maven.FileUtils.copyFile((File)new File(targetDirectory, "common/main-" + this.branding + ".js"), (File)new File(targetDirectory, "common/main.js"));
    }

    protected void transformFeed(File result) throws MojoExecutionException {
        try {
            this.atomFeed = new File(result.getParentFile(), "atom-doctype.xml");
            this.atomFeedClean = new File(result.getParentFile(), "atom.xml");
            if (!this.atomFeed.isFile()) {
                return;
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(classLoader.getResourceAsStream(COPY_XSL)));
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            dbfactory.setValidating(false);
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            Document xmlDocument = builder.parse(this.atomFeed);
            DOMSource source = new DOMSource(xmlDocument);
            transformer.transform(source, new StreamResult(this.atomFeedClean));
            this.atomFeed.deleteOnExit();
        }
        catch (TransformerConfigurationException e) {
            throw new MojoExecutionException("Failed to load JAXP configuration", (Exception)e);
        }
        catch (ParserConfigurationException e) {
            throw new MojoExecutionException("Failed to configure parser", (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Sax exception", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("IO Exception", (Exception)e);
        }
        catch (TransformerException e) {
            throw new MojoExecutionException("Failed to transform to atom feed", (Exception)e);
        }
    }

    public void preProcess() throws MojoExecutionException {
        super.preProcess();
        File targetDirectory = this.getTargetDirectory();
        File xslParentDirectory = targetDirectory.getParentFile();
        if (!targetDirectory.exists()) {
            FileUtils.mkdir(targetDirectory);
        }
        FileUtils.extractJaredDirectory("cloud/war", PDFMojo.class, xslParentDirectory);
        FileUtils.extractJaredDirectory("cloud/webhelp", PDFMojo.class, xslParentDirectory);
    }

    protected Source createSource(String inputFilename, File sourceFile, PreprocessingFilter filter) throws MojoExecutionException {
        String theFileName;
        String pathToPipelineFile = "classpath:///webhelp.xpl";
        String sourceFileNameNormalized = sourceFile.toURI().toString();
        InputSource inputSource = new InputSource(sourceFileNameNormalized);
        SAXSource source = new SAXSource((XMLReader)filter, inputSource);
        HashMap<String, Object> map = new HashMap<String, Object>();
        String sysWebhelpWar = System.getProperty("webhelp.war");
        if (null != sysWebhelpWar && !sysWebhelpWar.isEmpty()) {
            this.webhelpWar = sysWebhelpWar;
        }
        String targetDirString = "";
        try {
            targetDirString = this.getTargetDirectory().getParentFile().getCanonicalPath().replace(File.separatorChar, '/');
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)("Exceptional!" + e));
        }
        map.put("targetDirectory", this.getTargetDirectory().getParentFile());
        map.put("webhelp.war", this.webhelpWar);
        map.put("publicationNotificationEmails", this.publicationNotificationEmails);
        map.put("includeDateInPdfFilename", this.includeDateInPdfFilename);
        map.put("pdfFilenameBase", this.pdfFilenameBase);
        map.put("webhelpDirname", this.webhelpDirname);
        map.put("groupId", this.docProject.getGroupId());
        map.put("artifactId", this.docProject.getArtifactId());
        map.put("docProjectVersion", this.docProject.getVersion());
        map.put("pomProjectName", this.docProject.getName());
        map.put("security", this.security);
        map.put("branding", this.branding);
        map.put("canonicalUrlBase", this.canonicalUrlBase);
        map.put("replacementsFile", this.replacementsFile);
        map.put("failOnValidationError", this.failOnValidationError);
        map.put("comments.php", this.commentsPhp);
        map.put("project.build.directory", this.projectBuildDirectory);
        map.put("inputSrcFile", inputFilename);
        map.put("strictImageValidation", String.valueOf(this.strictImageValidation));
        map.put("trim.wadl.uri.count", this.trimWadlUriCount);
        map.put("status.bar.text", this.getProperty("statusBarText"));
        map.put("bodyFont", this.getProperty("bodyFont"));
        map.put("monospaceFont", this.getProperty("monospaceFont"));
        map.put("draft.status", this.getProperty("draftStatus"));
        map.put("profile.os", this.getProperty("profileOs"));
        map.put("profile.arch", this.getProperty("profileArch"));
        map.put("profile.condition", this.getProperty("profileCondition"));
        map.put("profile.audience", this.getProperty("profileAudience"));
        map.put("profile.conformance", this.getProperty("profileConformance"));
        map.put("profile.revision", this.getProperty("profileRevision"));
        map.put("profile.userlevel", this.getProperty("profileUserlevel"));
        map.put("profile.vendor", this.getProperty("profileVendor"));
        int lastSlash = inputFilename.lastIndexOf("/");
        if (-1 != lastSlash) {
            theFileName = inputFilename.substring(lastSlash);
            String theDirName = inputFilename.substring(0, lastSlash);
            int index = theFileName.indexOf(46);
            if (-1 != index) {
                String targetFile = this.getTargetDirectory() + "/" + theDirName + theFileName.substring(0, index) + "/content/" + "ext_query.xml";
                map.put("targetExtQueryFile", targetFile);
                map.put("targetHtmlContentDir", new File(this.getTargetDirectory(), theDirName + theFileName.substring(0, index) + "/content/"));
                map.put("base.dir", new File(this.getTargetDirectory(), theDirName + theFileName.substring(0, index)));
                map.put("input.filename", theDirName + theFileName.substring(0, index));
            }
        } else {
            theFileName = inputFilename;
            int index = theFileName.indexOf(46);
            if (-1 != index) {
                File targetFile = new File(this.getTargetDirectory(), theFileName.substring(0, index) + "/content/ext_query.xml");
                map.put("targetExtQueryFile", targetFile);
                map.put("targetHtmlContentDir", new File(this.getTargetDirectory(), theFileName.substring(0, index) + "/content/"));
                File targetDir = new File(this.getTargetDirectory(), theFileName.substring(0, index) + "/");
                map.put("base.dir", targetDir);
                map.put("input.filename", theFileName.substring(0, index));
            }
        }
        if (null != this.webhelpDirname && !this.webhelpDirname.isEmpty()) {
            map.put("targetExtQueryFile", new File(this.getTargetDirectory(), this.webhelpDirname + "/content/ext_query.xml"));
            map.put("base.dir", new File(this.getTargetDirectory(), this.webhelpDirname));
            map.put("targetHtmlContentDir", new File(this.getTargetDirectory(), this.webhelpDirname + "/content/"));
        }
        map.put("targetDir", new File(this.baseDir, "figures"));
        if (this.makePdf) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().info((CharSequence)"\n************************************* START: Automatically generating PDF for WEBHELP *************************************");
            }
            File baseDir = this.getTargetDirectory().getParentFile();
            File targetDir = new File(baseDir.getAbsolutePath(), "autopdf");
            PDFBuilder pdfBuilder = new PDFBuilder();
            pdfBuilder.setProject(this.getMavenProject());
            pdfBuilder.setSourceDirectory(this.getSourceDirectory());
            pdfBuilder.setAutopdfTargetDirectory(targetDir);
            pdfBuilder.setCoverColor(this.coverColor);
            pdfBuilder.setPageWidth(this.pageWidth);
            pdfBuilder.setPageHeight(this.pageHeight);
            pdfBuilder.setOmitCover(this.omitCover);
            pdfBuilder.setDoubleSided(this.doubleSided);
            pdfBuilder.setCoverLogoPath(this.coverLogoPath);
            pdfBuilder.setSecondaryCoverLogoPath(this.secondaryCoverLogoPath);
            pdfBuilder.setCoverLogoLeft(this.coverLogoLeft);
            pdfBuilder.setCoverLogoTop(this.coverLogoTop);
            pdfBuilder.setCoverUrl(this.coverUrl);
            pdfBuilder.setPdfFilenameBase(this.pdfFilenameBase);
            pdfBuilder.setBranding(this.branding);
            pdfBuilder.setBuiltForOpenStack(this.builtForOpenStack);
            pdfBuilder.setSecurity(this.security);
            pdfBuilder.setDraftStatus(this.draftStatus);
            pdfBuilder.setStatusBarText(this.statusBarText);
            pdfBuilder.setBodyFont(this.bodyFont);
            pdfBuilder.setMonospaceFont(this.monospaceFont);
            pdfBuilder.setLocalFontPath(this.localFontPath);
            pdfBuilder.setTrimWadlUriCount(this.trimWadlUriCount);
            pdfBuilder.setComputeWadlPathFromDocbookPath(this.computeWadlPathFromDocbookPath);
            pdfBuilder.setInputFilename(inputFilename);
            pdfBuilder.setEntities(this.getEntities());
            pdfBuilder.setChapterAutolabel(this.getProperty("chapterAutolabel"));
            pdfBuilder.setAppendixAutolabel(this.getProperty("appendixAutolabel"));
            pdfBuilder.setSectionAutolabel(this.getProperty("sectionAutolabel"));
            pdfBuilder.setSectionLabelIncludesComponentLabel(this.getProperty("sectionLabelIncludesComponentLabel"));
            pdfBuilder.setFormalProcedures(this.getProperty("formalProcedures"));
            pdfBuilder.setGenerateToc(this.getProperty("generateToc"));
            pdfBuilder.setTocMaxDepth(this.getProperty("tocMaxDepth"));
            pdfBuilder.setTocSectionDepth(this.getProperty("tocSectionDepth"));
            pdfBuilder.setGlossaryCollection(this.getProperty("glossaryCollection"));
            File srcFilename = new File(this.projectBuildDirectory, "docbkx/" + sourceFile.getName());
            if (srcFilename.exists()) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("***********************" + srcFilename));
                }
                pdfBuilder.setSourceFilePath(srcFilename);
            } else {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("***********************" + this.getSourceDirectory() + File.separator + inputFilename));
                }
                pdfBuilder.setSourceFilePath(new File(this.getSourceDirectory(), inputFilename));
            }
            pdfBuilder.setProjectBuildDirectory(baseDir);
            pdfBuilder.preProcess();
            File foFile = pdfBuilder.processSources(map);
            File pdfFile = pdfBuilder.postProcessResult(foFile);
            if (pdfFile != null) {
                boolean moved;
                File targetDirForPdf = ((File)map.get("targetHtmlContentDir")).getParentFile();
                if (!targetDirForPdf.exists()) {
                    FileUtils.mkdir(targetDirForPdf);
                }
                if ((moved = pdfBuilder.movePdfToWebhelpDir(pdfFile, targetDirForPdf)) && this.getLog().isDebugEnabled()) {
                    this.getLog().info((CharSequence)"Successfully moved auto-generated PDF file to Webhelp target directory!");
                } else if (this.getLog().isDebugEnabled()) {
                    this.getLog().error((CharSequence)"Unable to move auto-generated PDF file to Webhelp target directory!");
                }
            }
            this.autoPdfUrl = "../" + foFile.getName();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().info((CharSequence)"************************************* END: Automatically generating PDF for WEBHELP *************************************\n");
            }
        }
        map.put("webhelp", "true");
        map.put("autoPdfUrl", this.autoPdfUrl);
        map.put("outputType", "html");
        return CalabashHelper.createSource(this.getLog(), source, pathToPipelineFile, map);
    }
}

