/*
 * Decompiled with CFR 0.152.
 */
package com.rackspace.cloud.api.docs;

import com.agilejava.docbkx.maven.AbstractHtmlMojo;
import com.agilejava.docbkx.maven.PreprocessingFilter;
import com.agilejava.docbkx.maven.TransformerBuilder;
import com.rackspace.cloud.api.docs.CalabashHelper;
import com.rackspace.cloud.api.docs.DocBookResolver;
import com.rackspace.cloud.api.docs.FileUtils;
import com.rackspace.cloud.api.docs.GitHelper;
import com.rackspace.cloud.api.docs.PDFMojo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.URIResolver;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class XhtmlMojo
extends AbstractHtmlMojo {
    private File xslDirectory;
    private File projectBuildDirectory;
    private String failOnValidationError;
    private String security;
    private String showChangebars;
    private String builtForOpenStack;
    private String metaRobots;
    private String useVersionForDisqus;
    private String useDisqusId;
    private String branding;
    private String enableDisqus;
    private String disqusShortname;
    private String enableGoogleAnalytics;
    private String googleAnalyticsId;
    private String googleAnalyticsDomain;
    private String pdfUrl;
    private String canonicalUrlBase;
    private String replacementsFile;
    private File baseDir;
    private File transformDir;
    private String trimWadlUriCount;
    private String computeWadlPathFromDocbookPath;
    private String feedbackEmail;
    private String socialIcons;
    private String legalNoticeUrl;
    private String chunkSectionDepth;

    protected TransformerBuilder createTransformerBuilder(URIResolver resolver) {
        return super.createTransformerBuilder((URIResolver)new DocBookResolver(resolver, this.getType()));
    }

    public void adjustTransformer(Transformer transformer, String sourceFilename, File targetFile) {
        GitHelper.addCommitProperties(transformer, this.baseDir, 7, this.getLog());
        super.adjustTransformer(transformer, sourceFilename, targetFile);
    }

    protected String getNonDefaultStylesheetLocation() {
        return "cloud/war/copy.xsl";
    }

    protected void setXslDirectory(File xslDirectory) {
        this.xslDirectory = xslDirectory;
    }

    protected File getXslDirectory() {
        return this.xslDirectory;
    }

    public void postProcessResult(File result) throws MojoExecutionException {
        super.postProcessResult(result);
        String warBasename = result.getName().substring(0, result.getName().lastIndexOf(46));
        String sourceDir = result.getParentFile() + "/" + warBasename;
        String zipFile = result.getParentFile() + "/" + warBasename + ".war";
        try {
            FileOutputStream fout = new FileOutputStream(zipFile);
            ZipOutputStream zout = new ZipOutputStream(fout);
            File fileSource = new File(sourceDir);
            FileUtils.addDirectory(zout, fileSource);
            zout.close();
            System.out.println("Zip file has been created!");
        }
        catch (IOException ioe) {
            System.out.println("IOException :" + ioe);
        }
    }

    public void preProcess() throws MojoExecutionException {
        super.preProcess();
        File targetDirectory = this.getTargetDirectory();
        File xslParentDirectory = targetDirectory.getParentFile();
        if (!targetDirectory.exists()) {
            FileUtils.mkdir(targetDirectory);
        }
        FileUtils.extractJaredDirectory("cloud/war", PDFMojo.class, xslParentDirectory);
        this.setXslDirectory(new File(xslParentDirectory, "xsls"));
    }

    protected Source createSource(String inputFilename, File sourceFile, PreprocessingFilter filter) throws MojoExecutionException {
        String pathToPipelineFile = "classpath:///war.xpl";
        Source source = super.createSource(inputFilename, sourceFile, filter);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("failOnValidationError", this.failOnValidationError);
        map.put("transform.dir", this.transformDir);
        if (this.feedbackEmail != null) {
            map.put("feedback.email", this.feedbackEmail);
        }
        if (this.useDisqusId != null) {
            map.put("use.disqus.id", this.useDisqusId);
        }
        if (this.useVersionForDisqus != null) {
            map.put("use.version.for.disqus", this.useVersionForDisqus);
        }
        map.put("project.build.directory", this.projectBuildDirectory);
        map.put("branding", this.branding);
        map.put("builtForOpenStack", this.builtForOpenStack);
        map.put("enable.disqus", this.enableDisqus);
        if (this.disqusShortname != null) {
            map.put("disqus.shortname", this.disqusShortname);
        }
        if (this.enableGoogleAnalytics != null) {
            map.put("enable.google.analytics", this.enableGoogleAnalytics);
        }
        if (this.googleAnalyticsId != null) {
            map.put("google.analytics.id", this.googleAnalyticsId);
        }
        if (this.googleAnalyticsDomain != null) {
            map.put("google.analytics.domain", this.googleAnalyticsDomain);
        }
        if (this.pdfUrl != null) {
            map.put("pdf.url", this.pdfUrl);
        }
        if (this.legalNoticeUrl != null) {
            map.put("legal.notice.url", this.legalNoticeUrl);
        }
        if (this.canonicalUrlBase != null) {
            map.put("canonical.url.base", this.canonicalUrlBase);
        }
        map.put("replacementsFile", this.replacementsFile);
        if (this.security != null) {
            map.put("security", this.security);
        }
        if (this.showChangebars != null) {
            map.put("show.changebars", this.showChangebars);
        }
        if (this.metaRobots != null) {
            map.put("meta.robots", this.metaRobots);
        }
        if (this.trimWadlUriCount != null) {
            map.put("trim.wadl.uri.count", this.trimWadlUriCount);
        }
        if (this.chunkSectionDepth != null) {
            map.put("chunk.section.depth", this.chunkSectionDepth);
        }
        map.put("social.icons", this.socialIcons);
        map.put("profile.os", this.getProperty("profileOs"));
        map.put("profile.arch", this.getProperty("profileArch"));
        map.put("profile.condition", this.getProperty("profileCondition"));
        map.put("profile.audience", this.getProperty("profileAudience"));
        map.put("profile.conformance", this.getProperty("profileConformance"));
        map.put("profile.revision", this.getProperty("profileRevision"));
        map.put("profile.userlevel", this.getProperty("profileUserlevel"));
        map.put("profile.vendor", this.getProperty("profileVendor"));
        map.put("inputSrcFile", inputFilename);
        int lastSlash = inputFilename.lastIndexOf("/");
        if (-1 != lastSlash) {
            String theFileName = inputFilename.substring(lastSlash);
            String theDirName = inputFilename.substring(0, lastSlash);
            int index = theFileName.indexOf(46);
            if (-1 != index) {
                File targetDir = new File("target/docbkx/xhtml/" + theDirName + theFileName.substring(0, index) + "/");
                map.put("base.dir", targetDir);
            }
        } else {
            String theFileName = inputFilename;
            int index = theFileName.indexOf(46);
            if (-1 != index) {
                File targetDir = new File("target/docbkx/xhtml/" + theFileName.substring(0, index) + "/");
                map.put("base.dir", targetDir);
                map.put("input.filename", theFileName.substring(0, index));
            }
        }
        return CalabashHelper.createSource(this.getLog(), source, pathToPipelineFile, map);
    }
}

