/*
 * Decompiled with CFR 0.152.
 */
package com.rackspace.cloud.api.docs.calabash.extensions;

import com.rackspace.cloud.api.docs.calabash.extensions.util.RelativePath;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

public class CopyTransformImage
implements ProcessMatchingNodes {
    private String xpath;
    private Map<String, String> baseUriToDirMap = new HashMap<String, String>();
    private AtomicInteger simpleUniqueNumberGenerator = new AtomicInteger();
    private Map<String, String> processedFilesMapForHtmlOutput = new HashMap<String, String>();
    private Set<String> processedFilesSetForPdfOutput = new HashSet<String>();
    private ProcessMatch matcher;
    private URI targetDirectoryUri;
    private URI targetHtmlContentDirectoryUri;
    private String outputType;
    private boolean errorsFound = false;
    private Log log = null;

    public Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    public CopyTransformImage(String _xpath, URI _targetDirectory, URI _targetHtmlContentDirectoryUri, String _outputType) {
        this.xpath = _xpath;
        this.targetDirectoryUri = _targetDirectory;
        this.targetHtmlContentDirectoryUri = _targetHtmlContentDirectoryUri;
        this.outputType = _outputType;
    }

    public boolean hasErrors() {
        return this.errorsFound;
    }

    public String getXPath() {
        return this.xpath;
    }

    public void setMatcher(ProcessMatch matcher) {
        this.matcher = matcher;
    }

    private String processSelectedImage(XdmNode imageDataFileRef) {
        URI baseUri = imageDataFileRef.getBaseURI();
        String fileRef = imageDataFileRef.getStringValue();
        URI baseDirUri = baseUri.resolve(".");
        String srcImgFilePath = FilenameUtils.normalize((String)(baseDirUri.getPath() + File.separator + fileRef));
        File srcImgFile = this.getFileHandle(srcImgFilePath.trim());
        if (fileRef.toLowerCase().startsWith("http://") || fileRef.toLowerCase().startsWith("https://")) {
            this.getLog().warn((CharSequence)("Found reference to an external image " + fileRef + " in " + baseUri.getPath()));
            return fileRef;
        }
        if (this.outputType.equals("pdf")) {
            if (!(this.processedFilesSetForPdfOutput.contains(srcImgFilePath) || this.isImageForHtmlOnly(imageDataFileRef.getParent()) || this.fileExists(srcImgFile))) {
                this.reportImageNotFoundError(baseUri, fileRef, srcImgFile);
            }
            this.processedFilesSetForPdfOutput.add(srcImgFilePath);
            return fileRef;
        }
        if (this.outputType.equals("html")) {
            String relativePathToCopiedFile;
            if (this.processedFilesMapForHtmlOutput.containsKey(srcImgFilePath)) {
                return this.processedFilesMapForHtmlOutput.get(srcImgFilePath);
            }
            String targetDirPath = this.calculateTargetDirPath(baseUri.getPath(), fileRef);
            File targetDir = this.makeDirs(targetDirPath);
            if (this.isImageForPdfOnly(imageDataFileRef.getParent())) {
                relativePathToCopiedFile = fileRef;
            } else if (!this.fileExists(srcImgFile)) {
                this.reportImageNotFoundError(baseUri, fileRef, srcImgFile);
                relativePathToCopiedFile = fileRef;
            } else if ("svg".equalsIgnoreCase(FilenameUtils.getExtension((String)srcImgFilePath))) {
                File svgFile = this.getFileHandle(srcImgFilePath);
                File copiedFile = new TransformSVGToPNG().transformAndCopy(svgFile, targetDir);
                relativePathToCopiedFile = RelativePath.getRelativePath(new File(this.targetHtmlContentDirectoryUri), copiedFile);
            } else {
                File copiedFile = this.copyFile(srcImgFile, targetDir);
                relativePathToCopiedFile = RelativePath.getRelativePath(new File(this.targetHtmlContentDirectoryUri), copiedFile);
            }
            this.processedFilesMapForHtmlOutput.put(srcImgFilePath, relativePathToCopiedFile);
            return relativePathToCopiedFile;
        }
        return fileRef;
    }

    private boolean isImageForHtmlOnly(XdmNode imageDataNode) {
        return this.parentRoleEquals(imageDataNode, "html");
    }

    private boolean isImageForPdfOnly(XdmNode imageDataNode) {
        return this.parentRoleEquals(imageDataNode, "fo") || this.parentRoleEquals(imageDataNode, "pdf");
    }

    private boolean parentRoleEquals(XdmNode node, String role) {
        String parentRole;
        XdmNode parent = node.getParent();
        String string = parentRole = parent == null ? null : parent.getAttributeValue(new QName("role"));
        return parentRole != null && parentRole.equalsIgnoreCase(role);
    }

    private String calculateTargetDirPath(String baseUriPath, String fileRef) {
        String targetDirForBaseUri = null;
        if (this.baseUriToDirMap.containsKey(baseUriPath)) {
            targetDirForBaseUri = this.baseUriToDirMap.get(baseUriPath);
        } else {
            targetDirForBaseUri = "" + this.simpleUniqueNumberGenerator.incrementAndGet();
            this.baseUriToDirMap.put(baseUriPath, targetDirForBaseUri);
        }
        String targetDirForFileRef = FilenameUtils.getPathNoEndSeparator((String)fileRef.replaceAll("\\.\\.", "a"));
        return targetDirForBaseUri + File.separator + targetDirForFileRef;
    }

    private File copyFile(File srcFile, File targetDir) {
        try {
            FileUtils.copyFileToDirectory((File)srcFile, (File)targetDir);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Unable to copy file: " + srcFile.getAbsolutePath() + " to " + targetDir.getAbsolutePath()));
            throw new XProcException((Throwable)e);
        }
        return new File(targetDir.getAbsolutePath(), srcFile.getName());
    }

    private void reportImageNotFoundError(URI baseUri, String fileRef, File srcImgFile) {
        this.getLog().error((CharSequence)("File not found: '" + srcImgFile + "'. " + "File is referred in '" + baseUri.getPath() + "' fileRef='" + fileRef + "'."));
        this.errorsFound = true;
    }

    private boolean fileExists(File file) {
        try {
            return file == null ? false : file.exists() && file.getCanonicalPath().endsWith(file.getName());
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Unable to access file: " + file.getAbsolutePath()));
            return false;
        }
    }

    private File makeDirs(String relativePath) {
        File dir = new File(this.targetDirectoryUri.getPath(), relativePath);
        if (dir.exists() || dir.mkdir() || dir.mkdirs()) {
            return dir;
        }
        this.getLog().error((CharSequence)("Unable to create directory: " + dir.getAbsolutePath()));
        return null;
    }

    private File getFileHandle(String filePath) {
        File handle = new File(filePath);
        return handle.isDirectory() ? null : handle;
    }

    public boolean processStartDocument(XdmNode node) throws SaxonApiException {
        return true;
    }

    public void processEndDocument(XdmNode node) throws SaxonApiException {
    }

    public boolean processStartElement(XdmNode node) throws SaxonApiException {
        return true;
    }

    public void processAttribute(XdmNode node) throws SaxonApiException {
        String newValue = this.processSelectedImage(node);
        this.matcher.addAttribute(node, newValue);
    }

    public void processEndElement(XdmNode node) throws SaxonApiException {
    }

    public void processText(XdmNode node) throws SaxonApiException {
        String newValue = this.processSelectedImage(node);
        this.matcher.addText(newValue);
    }

    public void processComment(XdmNode node) throws SaxonApiException {
        String newValue = this.processSelectedImage(node);
        this.matcher.addText(newValue);
    }

    public void processPI(XdmNode node) throws SaxonApiException {
        String newValue = this.processSelectedImage(node);
        this.matcher.addText(newValue);
    }

    private class TransformSVGToPNG {
        private TransformSVGToPNG() {
        }

        File transformAndCopy(File svgFile, File targetDir) {
            String pngFileName = FilenameUtils.getBaseName((String)svgFile.getPath()) + ".png";
            File pngFile = new File(targetDir, pngFileName);
            PNGTranscoder t = new PNGTranscoder();
            try {
                TranscoderInput input = new TranscoderInput(svgFile.toURI().toString());
                pngFile.createNewFile();
                FileOutputStream ostream = new FileOutputStream(pngFile);
                TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
                t.transcode(input, output);
                ostream.flush();
                ((OutputStream)ostream).close();
                return pngFile;
            }
            catch (IOException e) {
                CopyTransformImage.this.getLog().error((CharSequence)("An error occured while transforming " + svgFile.getAbsolutePath() + " to " + pngFile.getAbsolutePath()));
                throw new XProcException((Throwable)e);
            }
            catch (TranscoderException e) {
                CopyTransformImage.this.getLog().error((CharSequence)("Unable to convert " + svgFile.getAbsolutePath() + " to png"));
                throw new XProcException((Throwable)e);
            }
        }
    }
}

