/*
 * Decompiled with CFR 0.152.
 */
package com.rackspace.cloud.api.docs.calabash.extensions;

import com.rackspace.cloud.api.docs.calabash.extensions.Replacement;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

class XPathReplacement
implements Iterable<Replacement>,
ProcessMatchingNodes {
    String xpath;
    List<Replacement> replacements;
    ProcessMatch matcher;

    public XPathReplacement(String _xpath) {
        this.xpath = _xpath;
        this.replacements = new ArrayList<Replacement>();
    }

    public String getXPath() {
        return this.xpath;
    }

    public void setMatcher(ProcessMatch matcher) {
        this.matcher = matcher;
    }

    public void add(String oldVal, String newVal) {
        this.replacements.add(new Replacement(oldVal, newVal));
    }

    private String computeReplacement(XdmNode node) {
        String newValue = node.getStringValue();
        for (Replacement repl : this.replacements) {
            if (repl.oldValue.startsWith("\"") && repl.oldValue.endsWith("\"")) {
                newValue = newValue.replace(repl.oldValue.substring(1, repl.oldValue.length() - 1), repl.newValue);
                continue;
            }
            newValue = newValue.replaceAll(repl.oldValue, repl.newValue);
        }
        return newValue;
    }

    @Override
    public Iterator<Replacement> iterator() {
        return this.replacements.iterator();
    }

    public boolean processStartDocument(XdmNode node) throws SaxonApiException {
        return true;
    }

    public void processEndDocument(XdmNode node) throws SaxonApiException {
    }

    public boolean processStartElement(XdmNode node) throws SaxonApiException {
        return true;
    }

    public void processAttribute(XdmNode node) throws SaxonApiException {
        String newValue = this.computeReplacement(node);
        this.matcher.addAttribute(node, newValue);
    }

    public void processEndElement(XdmNode node) throws SaxonApiException {
    }

    public void processText(XdmNode node) throws SaxonApiException {
        String newValue = this.computeReplacement(node);
        this.matcher.addText(newValue);
    }

    public void processComment(XdmNode node) throws SaxonApiException {
        String newValue = this.computeReplacement(node);
        this.matcher.addText(newValue);
    }

    public void processPI(XdmNode node) throws SaxonApiException {
        String newValue = this.computeReplacement(node);
        this.matcher.addText(newValue);
    }
}

