/*
 * Decompiled with CFR 0.152.
 */
package com.rackspace.cloud.api.docs.pipeline.resolvers;

import com.rackspace.cloud.api.docs.pipeline.resolvers.SourceUriResolver;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.springframework.web.util.UriUtils;

public class InputStreamUriParameterResolver
extends SourceUriResolver {
    private static final String PREFIX = "reference:jio:";
    private final Map<String, InputStream> streams = new HashMap<String, InputStream>();
    private final List<URIResolver> resolvers = new ArrayList<URIResolver>();

    public InputStreamUriParameterResolver() {
    }

    public InputStreamUriParameterResolver(URIResolver parent) {
        super(parent);
    }

    public void addResolver(URIResolver resolver) {
        this.resolvers.add(resolver);
    }

    public String addStream(InputStream inputStreamReference) {
        String key = this.getHref(inputStreamReference);
        this.streams.put(key, inputStreamReference);
        return key;
    }

    public String addStream(InputStream inputStreamReference, String name) {
        String key = this.getHref(name);
        this.streams.put(key, inputStreamReference);
        return key;
    }

    public void removeStream(InputStream inputStreamReference) {
        String key = this.getHref(inputStreamReference);
        this.removeStream(key);
    }

    public void removeStream(String name) {
        this.streams.remove(name);
    }

    public String getHref(InputStream inputStreamReference) {
        try {
            return PREFIX + UriUtils.encodePathSegment((String)inputStreamReference.toString(), (String)"utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            return PREFIX + inputStreamReference.toString();
        }
    }

    public String getHref(String name) {
        return PREFIX + name;
    }

    public void clearStreams() {
        this.streams.clear();
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        InputStream stream = this.streams.get(href);
        if (stream != null) {
            try {
                return new StreamSource(stream, new URI(href).toString());
            }
            catch (URISyntaxException ex) {
                return new StreamSource(stream);
            }
        }
        if (!this.resolvers.isEmpty()) {
            for (URIResolver resolver : this.resolvers) {
                Source source = resolver.resolve(href, base);
                if (source == null) continue;
                return source;
            }
        }
        return super.resolve(href, base);
    }
}

