/*
 * Decompiled with CFR 0.152.
 */
package com.rackspace.cloud.api.docs;

import java.io.File;
import java.io.IOException;
import javax.xml.transform.Transformer;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;

class GitHelper {
    public static boolean addCommitProperties(Transformer transformer, File baseDir, int abbrevLen, Log log) {
        try {
            RepositoryBuilder builder = new RepositoryBuilder();
            Repository repository = ((RepositoryBuilder)((RepositoryBuilder)builder.findGitDir(baseDir)).readEnvironment()).build();
            ObjectId objectId = repository.resolve("HEAD");
            if (objectId != null) {
                transformer.setParameter("repository.commit", objectId.getName());
                transformer.setParameter("repository.commit.short", objectId.abbreviate(abbrevLen).name());
                return true;
            }
            log.warn((CharSequence)"Could not determine current repository commit hash.");
            return false;
        }
        catch (IOException ex) {
            log.warn((CharSequence)"Could not determine current repository commit hash.", (Throwable)ex);
            return false;
        }
    }

    private GitHelper() {
    }
}

