/*
 * Decompiled with CFR 0.152.
 */
package com.rackspace.cloud.api.docs.builders;

import com.agilejava.docbkx.maven.CachingTransformerBuilder;
import com.agilejava.docbkx.maven.Entity;
import com.agilejava.docbkx.maven.ExpressionHandler;
import com.agilejava.docbkx.maven.InjectingEntityResolver;
import com.agilejava.docbkx.maven.NullWriter;
import com.agilejava.docbkx.maven.Parameter;
import com.agilejava.docbkx.maven.PreprocessingFilter;
import com.agilejava.docbkx.maven.StylesheetResolver;
import com.agilejava.docbkx.maven.TransformerBuilder;
import com.icl.saxon.Controller;
import com.icl.saxon.TransformerFactoryImpl;
import com.rackspace.cloud.api.docs.CalabashHelper;
import com.rackspace.cloud.api.docs.DocBookResolver;
import com.rackspace.cloud.api.docs.FileUtils;
import com.rackspace.cloud.api.docs.GlossaryResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.project.MavenProject;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.codehaus.plexus.util.DirectoryScanner;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class PDFBuilder {
    private MavenProject project;
    protected String[] catalogs = new String[]{"catalog.xml", "docbook/catalog.xml"};
    private File coverImageTemplate;
    private File coverImage;
    private static final String COVER_IMAGE_TEMPLATE_NAME = "cover.st";
    private static final String COVER_IMAGE_NAME = "cover.svg";
    private static final String COVER_XSL = "cloud/cover.xsl";
    private String inputFilename = null;
    private File autopdfTargetDirectory = null;
    private File webhelpTargetDirectory = null;
    private File sourceDirectory = null;
    private File imageDirectory = null;
    private File sourceFilePath;
    private File projectBuildDirectory;
    private String coverColor;
    private String pageWidth;
    private String pageHeight;
    private String omitCover;
    private String doubleSided;
    private String coverLogoPath;
    private String secondaryCoverLogoPath;
    private String coverLogoLeft;
    private String coverLogoTop;
    private String coverUrl;
    private String branding;
    private String builtForOpenStack;
    private String security;
    private String chapterAutolabel;
    private String appendixAutolabel;
    private String sectionAutolabel;
    private String sectionLabelIncludesComponentLabel;
    private String formalProcedures;
    private String generateToc;
    private String tocMaxDepth;
    private String tocSectionDepth;
    private String glossaryCollection;
    private String draftStatus;
    private String statusBarText;
    private String bodyFont;
    private String monospaceFont;
    private String localFontPath;
    private String trimWadlUriCount;
    private String computeWadlPathFromDocbookPath;
    private String pdfFilenameBase;
    private String foCustomization;
    private List<Parameter> customizationParameters = new ArrayList<Parameter>();
    private List<Entity> entities;
    private Log log = null;

    public Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    public void preProcess() throws MojoExecutionException {
        File targetDirectory = this.getAutopdfTargetDirectory();
        File imageParentDirectory = targetDirectory.getParentFile();
        if (!targetDirectory.exists()) {
            FileUtils.mkdir(targetDirectory);
        }
        FileUtils.extractJaredDirectory("images", PDFBuilder.class, imageParentDirectory);
        this.setImageDirectory(new File(imageParentDirectory, "images"));
        FileUtils.extractJaredDirectory("fonts", PDFBuilder.class, imageParentDirectory);
    }

    public File processSources(Map<String, Object> map) throws MojoExecutionException {
        String[] included = this.scanIncludedFiles();
        CatalogManager catalogManager = this.createCatalogManager();
        CatalogResolver catalogResolver = new CatalogResolver(catalogManager);
        URIResolver uriResolver = this.createStyleSheetResolver(catalogResolver);
        InjectingEntityResolver injectingResolver = this.createEntityResolver((EntityResolver)catalogResolver);
        CatalogResolver resolver = catalogResolver;
        if (injectingResolver != null) {
            resolver = injectingResolver;
        }
        TransformerBuilder builder = this.createTransformerBuilder(uriResolver);
        SAXParserFactory factory = this.createParserFactory();
        int i = included.length - 1;
        if (i >= 0) {
            try {
                if (injectingResolver != null) {
                    injectingResolver.forceInjection();
                }
                String inputFilename = included[i];
                String baseTargetFile = null != this.pdfFilenameBase && !this.pdfFilenameBase.isEmpty() ? this.pdfFilenameBase : inputFilename.substring(0, inputFilename.length() - 4);
                String targetFilename = baseTargetFile + ".fo";
                File sourceFile = new File(this.sourceDirectory, inputFilename);
                File targetFile = new File(this.autopdfTargetDirectory, targetFilename);
                XMLReader reader = factory.newSAXParser().getXMLReader();
                reader.setEntityResolver((EntityResolver)resolver);
                PreprocessingFilter filter = this.createPIHandler((EntityResolver)resolver, reader);
                Source xmlSource = this.createSource(inputFilename, sourceFile, filter, map);
                Transformer transformer = builder.build();
                this.adjustTransformer(transformer, sourceFile.getAbsolutePath(), targetFile);
                StreamResult result = new StreamResult(targetFile.getAbsolutePath());
                transformer.transform(xmlSource, result);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)(targetFile + " has been generated."));
                }
                return targetFile;
            }
            catch (SAXException saxe) {
                throw new MojoExecutionException("Failed to parse " + this.sourceFilePath + ".", (Exception)saxe);
            }
            catch (TransformerException te) {
                throw new MojoExecutionException("Failed to transform " + this.sourceFilePath + ".", (Exception)te);
            }
            catch (ParserConfigurationException pce) {
                throw new MojoExecutionException("Failed to construct parser.", (Exception)pce);
            }
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File postProcessResult(File result) throws MojoExecutionException {
        FopFactory fopFactory = FopFactory.newInstance();
        FOUserAgent userAgent = fopFactory.newFOUserAgent();
        this.transformCover();
        String warBasename = result.getName().substring(0, result.getName().lastIndexOf(46));
        Properties properties = new Properties();
        try {
            File f = new File(this.projectBuildDirectory, "autopdf/pdf.properties");
            FileInputStream is = new FileInputStream(f);
            properties.load(is);
        }
        catch (Exception e) {
            System.out.println("Got an Exception: " + e.getMessage());
        }
        Configuration configuration = this.loadFOPConfig();
        FileInputStream in = null;
        FileOutputStream out = null;
        File targetPdfFile = null;
        try {
            String baseURL = this.sourceDirectory.toURI().toURL().toExternalForm();
            baseURL = baseURL.replace("file:/", "file:///");
            userAgent.setBaseURL(baseURL);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Absolute path is " + baseURL));
            }
            in = new FileInputStream(result);
            targetPdfFile = new File(result.getAbsolutePath().replaceAll(".fo$", properties.getProperty("pdfsuffix", "") + ".pdf"));
            out = new FileOutputStream(targetPdfFile);
            fopFactory.setUserConfig(configuration);
            Fop fop = fopFactory.newFop("application/pdf", userAgent, (OutputStream)out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            StreamSource src = new StreamSource(in);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        catch (FOPException e) {
            try {
                throw new MojoExecutionException("Failed to convert to PDF", (Exception)((Object)e));
                catch (TransformerConfigurationException e2) {
                    throw new MojoExecutionException("Failed to load JAXP configuration", (Exception)e2);
                }
                catch (TransformerException e3) {
                    throw new MojoExecutionException("Failed to transform to PDF", (Exception)e3);
                }
                catch (MalformedURLException e4) {
                    throw new MojoExecutionException("Failed to get FO basedir", (Exception)e4);
                }
                catch (FileNotFoundException e5) {
                    throw new MojoExecutionException("File not found!", (Exception)e5);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)in);
        return targetPdfFile;
    }

    public boolean movePdfToWebhelpDir(File pdfFile, File webhelpTargetDir) {
        return pdfFile.renameTo(new File(webhelpTargetDir, pdfFile.getName()));
    }

    public void adjustTransformer(Transformer transformer, String sourceFilename, File targetFile) {
        String sysDraftStatus;
        try {
            String str = new File(sourceFilename).getParentFile().toURI().toURL().toExternalForm();
            String baseUrl = str.replace("file:/", "file:///");
        }
        catch (MalformedURLException e) {
            this.getLog().warn((CharSequence)"Failed to get FO basedir", (Throwable)e);
        }
        transformer.setParameter("autoPdfGlossaryInfix", "/..");
        transformer.setParameter("branding", this.branding);
        if (null != this.builtForOpenStack) {
            transformer.setParameter("builtForOpenStack", this.builtForOpenStack);
        }
        transformer.setParameter("coverLogoPath", this.coverLogoPath);
        if (null != this.secondaryCoverLogoPath) {
            transformer.setParameter("secondaryCoverLogoPath", this.secondaryCoverLogoPath);
        }
        transformer.setParameter("coverLogoLeft", this.coverLogoLeft);
        transformer.setParameter("coverLogoTop", this.coverLogoTop);
        transformer.setParameter("coverUrl", this.coverUrl);
        transformer.setParameter("coverColor", this.coverColor);
        if (null != this.pageWidth) {
            transformer.setParameter("page.width", this.pageWidth);
        }
        if (null != this.pageHeight) {
            transformer.setParameter("page.height", this.pageHeight);
        }
        if (null != this.omitCover) {
            transformer.setParameter("omitCover", this.omitCover);
        }
        if (null != this.doubleSided) {
            transformer.setParameter("double.sided", this.doubleSided);
        }
        if (null != this.glossaryCollection) {
            transformer.setParameter("glossary.collection", this.glossaryCollection);
        }
        if (null != this.sectionAutolabel) {
            transformer.setParameter("section.autolabel", this.sectionAutolabel);
        }
        if (null != this.sectionLabelIncludesComponentLabel) {
            transformer.setParameter("section.label.includes.component.label", this.sectionLabelIncludesComponentLabel);
        }
        if (null != this.chapterAutolabel) {
            transformer.setParameter("chapter.autolabel", this.chapterAutolabel);
        }
        if (null != this.appendixAutolabel) {
            transformer.setParameter("appendix.autolabel", this.appendixAutolabel);
        }
        if (null != this.generateToc) {
            transformer.setParameter("generate.toc", this.generateToc);
        }
        if (null != this.tocMaxDepth) {
            transformer.setParameter("toc.max.depth", this.tocMaxDepth);
        }
        if (null != this.tocSectionDepth) {
            transformer.setParameter("toc.section.depth", this.tocSectionDepth);
        }
        if (null != this.formalProcedures) {
            transformer.setParameter("formal.procedures", this.formalProcedures);
        }
        transformer.setParameter("project.build.directory", this.projectBuildDirectory.toURI().toString());
        String sysSecurity = System.getProperty("security");
        if (null != sysSecurity && !sysSecurity.isEmpty()) {
            this.security = sysSecurity;
        }
        if (this.security != null) {
            transformer.setParameter("security", this.security);
        }
        if (null != (sysDraftStatus = System.getProperty("draft.status")) && !sysDraftStatus.isEmpty()) {
            this.draftStatus = sysDraftStatus;
        }
        transformer.setParameter("draft.status", this.draftStatus);
        String sysStatusBarText = System.getProperty("statusBarText");
        if (null != sysStatusBarText && !sysStatusBarText.isEmpty()) {
            this.statusBarText = sysStatusBarText;
        }
        if (null != this.statusBarText) {
            transformer.setParameter("status.bar.text", this.statusBarText);
        }
        if (null != this.bodyFont) {
            transformer.setParameter("bodyFont", this.bodyFont);
        }
        if (null != this.monospaceFont) {
            transformer.setParameter("monospaceFont", this.monospaceFont);
        }
        if (this.trimWadlUriCount != null) {
            transformer.setParameter("trim.wadl.uri.count", this.trimWadlUriCount);
        }
        File sourceDocBook = new File(sourceFilename);
        this.sourceDirectory = sourceDocBook.getParentFile();
        File imageDirectory = this.getImageDirectory();
        File calloutDirectory = new File(imageDirectory, "callouts");
        transformer.setParameter("docbook.infile", sourceDocBook.toURI().toString());
        transformer.setParameter("source.directory", this.sourceDirectory.toURI().toString());
        transformer.setParameter("compute.wadl.path.from.docbook.path", this.computeWadlPathFromDocbookPath);
        transformer.setParameter("pdfFilenameBase", this.pdfFilenameBase);
        transformer.setParameter("admon.graphics.path", imageDirectory.toURI().toString());
        transformer.setParameter("callout.graphics.path", calloutDirectory.toURI().toString());
        File cloudSub = new File(imageDirectory, "cloud");
        File ccSub = new File(imageDirectory, "cc");
        this.coverImage = new File(cloudSub, COVER_IMAGE_NAME);
        this.coverImageTemplate = new File(cloudSub, COVER_IMAGE_TEMPLATE_NAME);
        this.coverImageTemplate = new File(cloudSub, "rackspace-cover.st");
        transformer.setParameter("cloud.api.background.image", this.coverImage.toURI().toString());
        transformer.setParameter("cloud.api.cc.image.dir", ccSub.toURI().toString());
    }

    protected void transformCover() throws MojoExecutionException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(new StreamSource(classLoader.getResourceAsStream(COVER_XSL)));
            if (this.coverColor != null) {
                transformer.setParameter("coverColor", this.coverColor);
            }
            transformer.setParameter("branding", this.branding);
            File cloudSub = new File(this.imageDirectory, "cloud");
            File ccSub = new File(this.imageDirectory, "cc");
            this.coverImage = new File(cloudSub, COVER_IMAGE_NAME);
            this.coverImageTemplate = new File(cloudSub, COVER_IMAGE_TEMPLATE_NAME);
            this.coverImageTemplate = new File(cloudSub, "rackspace-cover.st");
            transformer.setParameter("cloud.api.background.image", this.coverImage.toURI().toString());
            transformer.setParameter("cloud.api.cc.image.dir", ccSub.toURI().toString());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().info((CharSequence)("SOURCE FOR COVER PAGE: " + this.sourceFilePath));
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("SOURCE FOR COVER PAGE: " + new File(this.projectBuildDirectory, this.inputFilename).getAbsolutePath()));
            }
            transformer.setParameter("docbook.infile", new File(this.projectBuildDirectory, this.inputFilename).toURI().toString());
            transformer.transform(new StreamSource(this.coverImageTemplate), new StreamResult(this.coverImage));
        }
        catch (TransformerConfigurationException e) {
            throw new MojoExecutionException("Failed to load JAXP configuration", (Exception)e);
        }
        catch (TransformerException e) {
            throw new MojoExecutionException("Failed to transform to cover", (Exception)e);
        }
    }

    protected Configuration loadFOPConfig() throws MojoExecutionException {
        String fontPath = null != this.localFontPath && this.localFontPath != "" ? this.localFontPath : new File(this.getAutopdfTargetDirectory().getParentFile(), "fonts").getAbsolutePath();
        StringTemplateGroup templateGroup = new StringTemplateGroup("fonts", fontPath);
        StringTemplate template = templateGroup.getInstanceOf("fontconfig");
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        template.setAttribute("fontPath", (Object)fontPath);
        String config = template.toString();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)config);
        }
        try {
            return builder.build(IOUtils.toInputStream((String)config));
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Failed to load FOP config.", (Exception)ioe);
        }
        catch (SAXException saxe) {
            throw new MojoExecutionException("Failed to parse FOP config.", (Exception)saxe);
        }
        catch (ConfigurationException e) {
            throw new MojoExecutionException("Failed to do something Avalon requires....", (Exception)((Object)e));
        }
    }

    public void setInputFilename(String inputFilename) {
        this.inputFilename = inputFilename;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public File getAutopdfTargetDirectory() {
        return this.autopdfTargetDirectory;
    }

    public void setAutopdfTargetDirectory(File autopdfTargetDirectory) {
        this.autopdfTargetDirectory = autopdfTargetDirectory;
    }

    public File getWebhelpTargetDirectory() {
        return this.webhelpTargetDirectory;
    }

    public void setWebhelpTargetDirectory(File webhelpTargetDirectory) {
        this.webhelpTargetDirectory = webhelpTargetDirectory;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public File getImageDirectory() {
        return this.imageDirectory;
    }

    public void setImageDirectory(File imageDirectory) {
        this.imageDirectory = imageDirectory;
    }

    public File getSourceFilePath() {
        return this.sourceFilePath;
    }

    public void setSourceFilePath(File sourceDocBook) {
        this.sourceFilePath = sourceDocBook;
    }

    public File getProjectBuildDirectory() {
        return this.projectBuildDirectory;
    }

    public void setProjectBuildDirectory(File projectBuildDirectory) {
        this.projectBuildDirectory = projectBuildDirectory;
    }

    public String getCoverColor() {
        return this.coverColor;
    }

    public void setCoverColor(String coverColor) {
        this.coverColor = coverColor;
    }

    public String getCoverLogoPath() {
        return this.coverLogoPath;
    }

    public void setCoverLogoPath(String coverLogoPath) {
        this.coverLogoPath = coverLogoPath;
    }

    public String getSecondaryCoverLogoPath() {
        return this.secondaryCoverLogoPath;
    }

    public void setSecondaryCoverLogoPath(String secondaryCoverLogoPath) {
        this.secondaryCoverLogoPath = secondaryCoverLogoPath;
    }

    public String getCoverLogoLeft() {
        return this.coverLogoLeft;
    }

    public void setCoverLogoLeft(String coverLogoLeft) {
        this.coverLogoLeft = coverLogoLeft;
    }

    public String getCoverLogoTop() {
        return this.coverLogoTop;
    }

    public void setCoverLogoTop(String coverLogoTop) {
        this.coverLogoTop = coverLogoTop;
    }

    public String getCoverUrl() {
        return this.coverUrl;
    }

    public void setCoverUrl(String coverUrl) {
        this.coverUrl = coverUrl;
    }

    public String getBranding() {
        return this.branding;
    }

    public void setBranding(String branding) {
        this.branding = branding;
    }

    public String getBuiltForOpenStack() {
        return this.builtForOpenStack;
    }

    public void setBuiltForOpenStack(String builtForOpenStack) {
        this.builtForOpenStack = builtForOpenStack;
    }

    public String getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(String pageWidth) {
        this.pageWidth = pageWidth;
    }

    public String getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(String pageHeight) {
        this.pageHeight = pageHeight;
    }

    public String getOmitCover() {
        return this.omitCover;
    }

    public void setOmitCover(String omitCover) {
        this.omitCover = omitCover;
    }

    public String getDoubleSided() {
        return this.doubleSided;
    }

    public void setDoubleSided(String doubleSided) {
        this.doubleSided = doubleSided;
    }

    public String getSecurity() {
        return this.security;
    }

    public void setSecurity(String security) {
        this.security = security;
    }

    public String getChapterAutolabel() {
        return this.chapterAutolabel;
    }

    public void setChapterAutolabel(String chapterAutolabel) {
        this.chapterAutolabel = chapterAutolabel;
    }

    public String getAppendixAutolabel() {
        return this.appendixAutolabel;
    }

    public void setAppendixAutolabel(String appendixAutolabel) {
        this.appendixAutolabel = appendixAutolabel;
    }

    public String getSectionAutolabel() {
        return this.sectionAutolabel;
    }

    public void setSectionAutolabel(String sectionAutolabel) {
        this.sectionAutolabel = sectionAutolabel;
    }

    public String getGlossaryCollection() {
        return this.glossaryCollection;
    }

    public void setGlossaryCollection(String glossaryCollection) {
        this.glossaryCollection = glossaryCollection;
    }

    public String getSectionLabelIncludesComponentLabel() {
        return this.sectionLabelIncludesComponentLabel;
    }

    public void setSectionLabelIncludesComponentLabel(String sectionLabelIncludesComponentLabel) {
        this.sectionLabelIncludesComponentLabel = sectionLabelIncludesComponentLabel;
    }

    public String getFormalProcedures() {
        return this.formalProcedures;
    }

    public void setFormalProcedures(String formalProcedures) {
        this.formalProcedures = formalProcedures;
    }

    public String getGenerateToc() {
        return this.generateToc;
    }

    public void setGenerateToc(String generateToc) {
        this.generateToc = generateToc;
    }

    public String getTocMaxDepth() {
        return this.tocMaxDepth;
    }

    public void setTocSectionDepth(String tocSectionDepth) {
        this.tocSectionDepth = tocSectionDepth;
    }

    public String getTocSectionDepth() {
        return this.tocSectionDepth;
    }

    public void setTocMaxDepth(String tocMaxDepth) {
        this.tocMaxDepth = tocMaxDepth;
    }

    public String getDraftStatus() {
        return this.draftStatus;
    }

    public void setDraftStatus(String draftStatus) {
        this.draftStatus = draftStatus;
    }

    public String getStatusBarText() {
        return this.statusBarText;
    }

    public void setStatusBarText(String statusBarText) {
        this.statusBarText = statusBarText;
    }

    public void setBodyFont(String bodyFont) {
        this.bodyFont = bodyFont;
    }

    public String getBodyFont() {
        return this.bodyFont;
    }

    public void setMonospaceFont(String monospaceFont) {
        this.monospaceFont = monospaceFont;
    }

    public String getMonospaceFont() {
        return this.monospaceFont;
    }

    public void setLocalFontPath(String localFontPath) {
        this.localFontPath = localFontPath;
    }

    public String getLocalFontPath() {
        return this.localFontPath;
    }

    public String getTrimWadlUriCount() {
        return this.trimWadlUriCount;
    }

    public void setTrimWadlUriCount(String trimWadlUriCount) {
        this.trimWadlUriCount = trimWadlUriCount;
    }

    public String getComputeWadlPathFromDocbookPath() {
        return this.computeWadlPathFromDocbookPath;
    }

    public void setComputeWadlPathFromDocbookPath(String computeWadlPathFromDocbookPath) {
        this.computeWadlPathFromDocbookPath = computeWadlPathFromDocbookPath;
    }

    public String getPdfFilenameBase() {
        return this.pdfFilenameBase;
    }

    public void setPdfFilenameBase(String pdfFilenameBase) {
        this.pdfFilenameBase = pdfFilenameBase;
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public void setEntities(List<Entity> entities) {
        this.entities = entities;
    }

    private InjectingEntityResolver createEntityResolver(EntityResolver resolver) {
        if (this.getEntities() != null) {
            return new InjectingEntityResolver(this.getEntities(), resolver, this.getType(), this.getLog());
        }
        return null;
    }

    protected String getNonDefaultStylesheetLocation() {
        return "cloud/fo/docbook.xsl";
    }

    protected URL getNonDefaultStylesheetURL() {
        if (this.getNonDefaultStylesheetLocation() != null) {
            URL url = this.getClass().getClassLoader().getResource(this.getNonDefaultStylesheetLocation());
            return url;
        }
        return null;
    }

    private String[] scanIncludedFiles() {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.sourceDirectory);
        scanner.setIncludes(new String[]{this.inputFilename});
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    protected CatalogManager createCatalogManager() {
        CatalogManager manager = new CatalogManager();
        manager.setIgnoreMissingProperties(true);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        StringBuffer builder = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < this.catalogs.length; ++i) {
            String catalog = this.catalogs[i];
            try {
                Enumeration<URL> enumeration = classLoader.getResources(catalog);
                while (enumeration.hasMoreElements()) {
                    if (!first) {
                        builder.append(';');
                    } else {
                        first = false;
                    }
                    URL resource = enumeration.nextElement();
                    builder.append(resource.toExternalForm());
                }
                continue;
            }
            catch (IOException ioe) {
                this.getLog().warn((CharSequence)("Failed to search for catalog files: " + catalog));
            }
        }
        String catalogFiles = builder.toString();
        if (catalogFiles.length() == 0) {
            this.getLog().warn((CharSequence)"Failed to find catalog files.");
        } else {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Catalogs to load: " + catalogFiles));
            }
            manager.setCatalogFiles(catalogFiles);
        }
        return manager;
    }

    private URIResolver createStyleSheetResolver(CatalogResolver catalogResolver) throws MojoExecutionException {
        StylesheetResolver uriResolver;
        try {
            URL url;
            URL uRL = url = this.getNonDefaultStylesheetURL() == null ? this.getDefaultStylesheetURL() : this.getNonDefaultStylesheetURL();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Using stylesheet: " + url.toExternalForm()));
            }
            uriResolver = new StylesheetResolver("urn:docbkx:stylesheet", (Source)new StreamSource(url.openStream(), url.toExternalForm()), (URIResolver)catalogResolver);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Failed to read stylesheet.", (Exception)ioe);
        }
        return uriResolver;
    }

    protected URL getDefaultStylesheetURL() {
        URL url = this.getClass().getClassLoader().getResource(this.getDefaultStylesheetLocation());
        return url;
    }

    public String getDefaultStylesheetLocation() {
        return "docbook/fo/docbook.xsl";
    }

    public String getType() {
        return "fo";
    }

    protected TransformerBuilder createTransformerBuilder(URIResolver resolver) {
        GlossaryResolver resolver1 = new GlossaryResolver(new DocBookResolver(resolver, this.getType()), this.getType());
        return new CachingTransformerBuilder((TransformerBuilder)new DefaultTransformerBuilder(resolver1));
    }

    protected URL getStylesheetURL() {
        URL url = this.getClass().getClassLoader().getResource(this.getStylesheetLocation());
        if (url == null) {
            try {
                if (this.getStylesheetLocation().startsWith("http://")) {
                    return new URL(this.getStylesheetLocation());
                }
                return new File(this.getStylesheetLocation()).toURI().toURL();
            }
            catch (MalformedURLException mue) {
                return null;
            }
        }
        return url;
    }

    public String getStylesheetLocation() {
        if (this.foCustomization != null) {
            return this.foCustomization;
        }
        if (this.getNonDefaultStylesheetLocation() == null) {
            return this.getDefaultStylesheetLocation();
        }
        return this.getNonDefaultStylesheetLocation();
    }

    protected boolean isShowXslMessages() {
        return false;
    }

    public List<Parameter> getCustomizationParameters() {
        return this.customizationParameters;
    }

    private SAXParserFactory createParserFactory() {
        SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
        factory.setXIncludeAware(this.getXIncludeSupported());
        return factory;
    }

    private boolean getXIncludeSupported() {
        return true;
    }

    private PreprocessingFilter createPIHandler(EntityResolver resolver, XMLReader reader) {
        PreprocessingFilter filter = new PreprocessingFilter(reader);
        ExpressionHandler resolvingHandler = new ExpressionHandler(new VariableResolver(){

            public Object resolveVariable(String name) throws ELException {
                if ("date".equals(name)) {
                    return DateFormat.getDateInstance(1).format(new Date());
                }
                if ("project".equals(name)) {
                    return PDFBuilder.this.getProject();
                }
                return PDFBuilder.this.getProject().getProperties().get(name);
            }
        }, this.getLog());
        filter.setHandlers(Arrays.asList(resolvingHandler));
        filter.setEntityResolver(resolver);
        return filter;
    }

    protected Source createSource(String inputFilename, File sourceFile, PreprocessingFilter filter, Map<String, Object> map) throws MojoExecutionException {
        String pathToPipelineFile = "classpath:///pdf.xpl";
        String sourceFileNameNormalized = sourceFile.toURI().toString();
        InputSource inputSource = new InputSource(sourceFileNameNormalized);
        SAXSource source = new SAXSource((XMLReader)filter, inputSource);
        HashMap<String, Object> localMap = new HashMap<String, Object>(map);
        localMap.put("outputType", "pdf");
        localMap.remove("webhelp");
        localMap.remove("webhelp.war");
        localMap.remove("groupId");
        localMap.remove("artifactId");
        localMap.remove("docProjectVersion");
        return CalabashHelper.createSource(this.getLog(), source, pathToPipelineFile, localMap);
    }

    public static void main(String[] args) {
        try {
            System.out.println("setting up fonts and images directories\n");
            System.out.println("FOP ExampleFO2PDF\n");
            System.out.println("Preparing...");
            File sourceDir = new File("/Users/salmanqureshi/Projects/Rackspace/Dev/compute-api-final/openstack-compute-api-2/src");
            File baseDir = new File("/Users/salmanqureshi/Projects/Rackspace/Dev/compute-api-final/openstack-compute-api-2");
            System.out.println("Transforming...");
            PDFBuilder pdfBuilder = new PDFBuilder();
            File targetDir = new File(baseDir, "target/docbkx/pdf1");
            pdfBuilder.setSourceDirectory(sourceDir);
            pdfBuilder.setAutopdfTargetDirectory(targetDir);
            pdfBuilder.setImageDirectory(targetDir.getParentFile());
            pdfBuilder.setBranding("rackspace");
            pdfBuilder.setInputFilename("os-compute-devguide.xml");
            pdfBuilder.setSourceFilePath(new File(sourceDir, "os-compute-devguide.xml"));
            pdfBuilder.setProjectBuildDirectory(sourceDir.getParentFile());
            pdfBuilder.preProcess();
            System.out.println("Success!");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    private class DefaultTransformerBuilder
    implements TransformerBuilder {
        private URIResolver resolver;

        public DefaultTransformerBuilder(URIResolver resolver) {
            this.resolver = resolver;
        }

        public Transformer build() throws TransformerBuilder.TransformerBuilderException {
            Transformer transformer = this.createTransformer(this.resolver);
            transformer.setURIResolver(this.resolver);
            return transformer;
        }

        protected Transformer createTransformer(URIResolver uriResolver) throws TransformerBuilder.TransformerBuilderException {
            URL url = PDFBuilder.this.getStylesheetURL();
            try {
                TransformerFactoryImpl transformerFactory = new TransformerFactoryImpl();
                transformerFactory.setURIResolver(uriResolver);
                StreamSource source = new StreamSource(url.openStream(), url.toExternalForm());
                Transformer transformer = transformerFactory.newTransformer(source);
                if (!PDFBuilder.this.isShowXslMessages()) {
                    Controller controller = (Controller)transformer;
                    try {
                        controller.makeMessageEmitter();
                        controller.getMessageEmitter().setWriter((Writer)new NullWriter());
                    }
                    catch (TransformerException te) {
                        PDFBuilder.this.getLog().error((CharSequence)"Failed to redirect xsl:message output.", (Throwable)te);
                    }
                }
                if (PDFBuilder.this.getCustomizationParameters() != null) {
                    for (Parameter param : PDFBuilder.this.getCustomizationParameters()) {
                        if (param.getName() == null) continue;
                        transformer.setParameter(param.getName(), param.getValue());
                    }
                }
                return transformer;
            }
            catch (IOException ioe) {
                throw new TransformerBuilder.TransformerBuilderException("Failed to read stylesheet from " + url.toExternalForm(), (Throwable)ioe);
            }
            catch (TransformerConfigurationException tce) {
                throw new TransformerBuilder.TransformerBuilderException("Failed to build Transformer from " + url.toExternalForm(), (Throwable)tce);
            }
        }
    }
}

