/*
 * Decompiled with CFR 0.152.
 */
package com.rackspace.cloud.api.docs.calabash.extensions;

import com.rackspace.cloud.api.docs.calabash.extensions.XPathReplacement;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

public class ReplaceTextXProcStep
extends DefaultStep {
    private static final QName _replacements_file = new QName("", "replacements.file");
    private static Pattern XPATH_LINE = Pattern.compile("^XPATH=(.+)$");
    private static Pattern COMMENT_LINE = Pattern.compile("^#(.+)$");
    private static Pattern REPLACEMENT_LINE = Pattern.compile("(.+)->(.*)");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private ProcessMatch matcher = null;
    private Log log = null;

    public Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    public ReplaceTextXProcStep(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    public void run() throws SaxonApiException {
        super.run();
        List<XPathReplacement> replacements = this.readReplacementsFile(this.getOption(_replacements_file, "replacements.config"));
        XdmNode updatedDoc = this.makeReplacements(this.source.read(), replacements);
        this.result.write(updatedDoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<XPathReplacement> readReplacementsFile(String fileName) {
        ArrayList<XPathReplacement> xpathReplacements = new ArrayList<XPathReplacement>();
        XPathReplacement currentXPath = new XPathReplacement("//text()");
        File replacementsFile = new File(fileName);
        long fileLength = replacementsFile.length();
        if (fileLength > 0L) {
            BufferedReader br = null;
            try {
                String line;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().info((CharSequence)("REPLACEMENTS FILE = " + replacementsFile.getAbsolutePath()));
                }
                br = new BufferedReader(new FileReader(replacementsFile));
                while ((line = br.readLine()) != null) {
                    Matcher xpathLine = XPATH_LINE.matcher(line);
                    Matcher commentLine = COMMENT_LINE.matcher(line);
                    Matcher replacementLine = REPLACEMENT_LINE.matcher(line);
                    if (xpathLine.matches()) {
                        currentXPath = new XPathReplacement(xpathLine.group(1).trim());
                        xpathReplacements.add(currentXPath);
                        continue;
                    }
                    if (commentLine.matches() || !replacementLine.matches()) continue;
                    currentXPath.add(replacementLine.group(1).trim(), replacementLine.group(2).trim());
                }
                if (xpathReplacements.size() != 0 || !this.getLog().isDebugEnabled()) return xpathReplacements;
                this.getLog().info((CharSequence)("SKIPPING REPLACEMENTS: Replacements file is empty or was not found at specified location '" + fileName + "'."));
                return xpathReplacements;
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Unable to process replacements config file", (Throwable)e);
                return xpathReplacements;
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)"Unable to release/close replacements config file", (Throwable)e);
                }
            }
        }
        if (!this.getLog().isDebugEnabled()) return xpathReplacements;
        this.getLog().info((CharSequence)("SKIPPING REPLACEMENTS: Replacements file is empty or was not found at specified location '" + fileName + "'."));
        return xpathReplacements;
    }

    private XdmNode makeReplacements(XdmNode doc, List<XPathReplacement> replacements) {
        for (XPathReplacement xpathRepl : replacements) {
            this.matcher = new ProcessMatch(this.runtime, (ProcessMatchingNodes)xpathRepl);
            xpathRepl.setMatcher(this.matcher);
            this.matcher.match(doc, new RuntimeValue(xpathRepl.getXPath()));
            doc = this.matcher.getResult();
        }
        return doc;
    }
}

