/*
 * Decompiled with CFR 0.152.
 */
package com.rackspace.cloud.api.docs.calabash.extensions.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RelativePath {
    private static List<String> getPathList(File f) {
        ArrayList<String> l = new ArrayList<String>();
        try {
            for (File r = f.getCanonicalFile(); r != null; r = r.getParentFile()) {
                l.add(r.getName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            l = null;
        }
        return l;
    }

    private static String matchPathLists(List<String> r, List<String> f) {
        int j;
        String s = "";
        int i = r.size() - 1;
        for (j = f.size() - 1; i >= 0 && j >= 0 && r.get(i).equals(f.get(j)); --i, --j) {
        }
        while (i >= 0) {
            s = s + ".." + File.separator;
            --i;
        }
        while (j >= 1) {
            s = s + f.get(j) + File.separator;
            --j;
        }
        s = s + f.get(j);
        return s;
    }

    public static String getRelativePath(File home, File f) {
        List<String> homelist = RelativePath.getPathList(home);
        List<String> filelist = RelativePath.getPathList(f);
        String s = RelativePath.matchPathLists(homelist, filelist);
        return s;
    }

    public static void main(String[] args) {
        String home = "/home/user1/content/myfolder";
        String file = "/home/user1/figures/fig.png";
        System.out.println("home = " + home);
        System.out.println("file = " + file);
        System.out.println("path = " + RelativePath.getRelativePath(new File(home), new File(file)));
    }
}

