/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import net.bull.javamelody.Counter;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.MonitoringProxy;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;

public final class JpaWrapper {
    private static final boolean DISABLED = Boolean.parseBoolean(Parameters.getParameter(Parameter.DISABLED));
    private static final Counter JPA_COUNTER = MonitoringProxy.getJpaCounter();

    private JpaWrapper() {
    }

    static Counter getJpaCounter() {
        return JPA_COUNTER;
    }

    public static EntityManagerFactory createEntityManagerFactoryProxy(EntityManagerFactory entityManagerFactory) {
        if (DISABLED || !JPA_COUNTER.isDisplayed()) {
            return entityManagerFactory;
        }
        return JdbcWrapper.createProxy(entityManagerFactory, new EntityManagerFactoryHandler(entityManagerFactory));
    }

    static EntityManager createEntityManagerProxy(EntityManager entityManager) {
        if (DISABLED || !JPA_COUNTER.isDisplayed()) {
            return entityManager;
        }
        return JdbcWrapper.createProxy(entityManager, new EntityManagerHandler(entityManager));
    }

    static Query createQueryProxy(Query query, String requestName) {
        return JdbcWrapper.createProxy(query, new QueryHandler(query, requestName));
    }

    static Object doInvoke(Object object, Method method, Object[] args, String requestName) throws Throwable {
        boolean systemError = false;
        try {
            JPA_COUNTER.bindContextIncludingCpu(requestName);
            Object object2 = method.invoke(object, args);
            return object2;
        }
        catch (Error e) {
            systemError = true;
            throw e;
        }
        finally {
            JPA_COUNTER.addRequestForCurrentContext(systemError);
        }
    }

    private static class QueryHandler
    implements InvocationHandler {
        private final Query query;
        private final String requestName;

        QueryHandler(Query query, String requestName) {
            this.query = query;
            this.requestName = requestName;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (("getSingleResult".equals(methodName) || "getResultList".equals(methodName) || "executeUpdate".equals(methodName)) && (args == null || args.length == 0)) {
                return JpaWrapper.doInvoke(this.query, method, args, this.requestName);
            }
            if (methodName.startsWith("set") && method.getReturnType() != null && Query.class.isAssignableFrom(method.getReturnType())) {
                method.invoke((Object)this.query, args);
                return proxy;
            }
            return method.invoke((Object)this.query, args);
        }
    }

    private static class EntityManagerHandler
    implements InvocationHandler {
        private final EntityManager entityManager;

        EntityManagerHandler(EntityManager entityManager) {
            this.entityManager = entityManager;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (this.isCreateSomeQuery(method)) {
                Query query = (Query)method.invoke((Object)this.entityManager, args);
                String requestName = this.getQueryRequestName(methodName, args);
                query = JpaWrapper.createQueryProxy(query, requestName);
                return query;
            }
            if (this.isOneOfFindMethods(args, methodName)) {
                String requestName = "find(" + ((Class)args[0]).getSimpleName() + ')';
                return JpaWrapper.doInvoke(this.entityManager, method, args, requestName);
            }
            if (this.isMergePersistRefreshRemoveDetachOrLockMethod(methodName, args)) {
                String requestName = method.getName() + '(' + args[0].getClass().getSimpleName() + ')';
                return JpaWrapper.doInvoke(this.entityManager, method, args, requestName);
            }
            if ("flush".equals(methodName)) {
                String requestName = "flush()";
                return JpaWrapper.doInvoke(this.entityManager, method, args, "flush()");
            }
            return method.invoke((Object)this.entityManager, args);
        }

        private boolean isMergePersistRefreshRemoveDetachOrLockMethod(String methodName, Object[] args) {
            return args != null && args.length > 0 && ("merge".equals(methodName) || "persist".equals(methodName) || "refresh".equals(methodName) || "remove".equals(methodName) || "detach".equals(methodName) || "lock".equals(methodName));
        }

        private boolean isOneOfFindMethods(Object[] args, String methodName) {
            return "find".equals(methodName) && args != null && args.length > 0 && args[0] instanceof Class;
        }

        private boolean isCreateSomeQuery(Method method) {
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            boolean methodNameOk = "createQuery".equals(methodName) || "createNamedQuery".equals(methodName) || "createNativeQuery".equals(methodName) || "createStoredProcedureQuery".equals(methodName) || "createNamedStoredProcedureQuery".equals(methodName);
            return methodNameOk && returnType != null && Query.class.isAssignableFrom(returnType);
        }

        private String getQueryRequestName(String methodName, Object[] args) {
            StringBuilder requestName = new StringBuilder();
            requestName.append(methodName, "create".length(), methodName.length());
            EntityManagerHandler.appendArgs(requestName, args);
            return requestName.toString();
        }

        private static void appendArgs(StringBuilder requestName, Object[] args) {
            requestName.append('(');
            if (args != null) {
                String separator = "";
                for (Object arg : args) {
                    requestName.append(separator);
                    separator = ", ";
                    if (arg instanceof Class) {
                        requestName.append(((Class)arg).getSimpleName());
                        continue;
                    }
                    requestName.append(arg);
                }
            }
            requestName.append(')');
        }
    }

    private static class EntityManagerFactoryHandler
    implements InvocationHandler {
        private final EntityManagerFactory entityManagerFactory;

        EntityManagerFactoryHandler(EntityManagerFactory entityManagerFactory) {
            this.entityManagerFactory = entityManagerFactory;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = method.invoke((Object)this.entityManagerFactory, args);
            if (result instanceof EntityManager) {
                result = JpaWrapper.createEntityManagerProxy((EntityManager)result);
            }
            return result;
        }
    }
}

