package org.myorg.d2u;

import java.io.*;
import org.antlr.runtime.*;
import org.antlr.stringtemplate.*;
import org.antlr.stringtemplate.language.*;

public class Main {
    
    public static void main(String args[]) throws Exception {

        d2uLexer lex = new d2uLexer(new ANTLRInputStream(System.in));
        CommonTokenStream tokens = new CommonTokenStream(lex);
        d2uParser g = new d2uParser(tokens);
        StringTemplateGroup templates = new StringTemplateGroup(new FileReader("d2u.stg"), DefaultTemplateLexer.class);
        g.setTemplateLib(templates);
        
        if ( args.length > 0 ) {
           g.setNewline(args[0].toLowerCase());
        }
        
        try {
            g.lines();
        } catch (RecognitionException e) {
            e.printStackTrace();
        }
    }
}