__author__ = 'w00322934'

from rock import exception
from rock.i18n import _
from rock.openstack.common import jsonutils
from rock.openstack.common import log as logging

LOG = logging.getLogger(__name__)

def unpack_unicode(value_item):
    if isinstance(value_item, unicode):
        return eval(value_item)
    else:
        return value_item

def _dict_sum(*dicts):
    if isinstance(dicts[0], tuple) and len(dicts) == 1:
        dicts = dicts[0]
    _keys = set(sum([element.keys() for element in dicts],[]))
    _total = {}
    for _key in _keys:
        _value = [unpack_unicode(element.get(_key)) for element in dicts if element.has_key(_key)]
        # LOG.info("key :: %s, value ==> %s,  type : %s" % (_key, _value, type(_value[0])))
        # LOG.info("isdict :: %s, value ==> %s,  type : %s" % (isinstance(_value[0], dict), _value[0], type(_value[0])))
        if isinstance(_value[0], dict):
            _total[_key] = _dict_sum(tuple(_value))
        else:
            _total[_key] = sum([int(element.get(_key,0)) for element in dicts])
    return _total

def _dict_subtract(total_dict, subtract_dict):
    for sub_key, sub_cap in subtract_dict.items():
        # sub_key = unpack_unicode(sub_key)
        sub_cap = unpack_unicode(sub_cap)
        # LOG.info("key:: %s, total_value::%s, sub_cap::%s " % (sub_key, total_dict[sub_key], sub_cap))
        if isinstance(sub_cap, dict):
            total_dict[sub_key] = _dict_subtract(total_dict[sub_key], sub_cap)
        elif sub_key in ["bps", "pps"]:
            if total_dict.has_key(sub_key) and total_dict[sub_key] >= int(sub_cap):
                total_dict[sub_key] -= int(sub_cap)
            else:
                LOG.error(
                    "Localhost pool remain capability  %s  but request accelerator capability %s" % (
                        total_dict, sub_key))
                raise exception.AcceleratorPoolFailed(pool=total_dict, capability = sub_key)
    if total_dict.has_key('free_vf_num'):
        if total_dict['free_vf_num'] >= 1:
            total_dict['free_vf_num'] -= 1
        else:
            LOG.error("Localhost pool free-vf-num %s is not enough for request" % (
                total_dict['free_vf_num']))
            raise exception.AcceleratorNumFailed(pool=total_dict)
    return total_dict

def dict_acc_back(total_dict, accelerator_dict):
    for sub_key, sub_cap in accelerator_dict.items():
        # sub_key = unpack_unicode(sub_key)
        sub_cap = unpack_unicode(sub_cap)
        # LOG.info("key:: %s, total_value::%s, sub_cap::%s " % (sub_key, total_dict[sub_key], sub_cap))
        if isinstance(sub_cap, dict):
            total_dict[sub_key] = dict_acc_back(total_dict[sub_key], sub_cap)
        elif sub_key in ["bps", "pps"]:
            total_dict[sub_key] += int(sub_cap)
    if total_dict.has_key('free_vf_num'):
        total_dict['free_vf_num'] += 1
    return total_dict