/**
 * Copyright 2015 Cisco Systems, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License. You may obtain
 * a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

(function() {
  'use strict';

  angular
    .module('horizon.dashboard.container-infra.cluster-templates')
    .factory('horizon.dashboard.container-infra.cluster-templates.model', ClusterTemplateModel);

  ClusterTemplateModel.$inject = [
    'horizon.app.core.openstack-service-api.magnum'
  ];

  function ClusterTemplateModel(magnum) {
    var model = {
      newClusterTemplateSpec: {},

      // API methods
      init: init,
      createClusterTemplate: createClusterTemplate
    };

    function initNewClusterTemplateSpec() {
      model.newClusterTemplateSpec = {
        name: null,
        coe: "",
        public: null,
        registry_enabled: null,
        tls_disabled: null,
        image_id: "",
        flavor_id: "",
        master_flavor_id: "",
        docker_volume_size: null,
        docker_storage_driver: "devicemapper",
        keypair_id: "",
        network_driver: "",
        volume_driver: "",
        http_proxy: null,
        https_proxy: null,
        no_proxy: null,
        external_network_id: "",
        fixed_network: "",
        fixed_subnet: "",
        dns_nameserver: null,
        master_lb_enabled: "",
        floating_ip_enabled: true,
        labels: null,
        network_drivers : [{name: "", label: gettext("Choose a Network Driver")},
                           {name: "docker", label: gettext("Docker")},
                           {name: "flannel", label: gettext("Flannel")}],
        volume_drivers : [{name: "", label: gettext("Choose a Volume Driver")},
                          {name: "cinder", label: gettext("Cinder")},
                          {name: "rexray", label: gettext("Rexray")}],
        docker_storage_drivers: [{name: "devicemapper", label: gettext("Device Mapper")},
                                 {name: "overlay", label: gettext("Overley")}]
      };
    }

    function init() {
      // Reset the new cluster template spec
      initNewClusterTemplateSpec();
    }

    function createClusterTemplate() {
      var finalSpec = angular.copy(model.newClusterTemplateSpec);

      cleanNullProperties(finalSpec);

      return magnum.createClusterTemplate(finalSpec);
    }

    function cleanNullProperties(finalSpec) {
      // Initially clean fields that don't have any value.
      // Not only "null", blank too.
      // "network_drivers" and "volume_drivers" are used for pull-down options.
      // These are not for submittion.
      for (var key in finalSpec) {
        if (finalSpec.hasOwnProperty(key) && finalSpec[key] === null || finalSpec[key] === "" ||
            key === "network_drivers" || key === "volume_drivers" ||
            key === "docker_storage_drivers") {
          delete finalSpec[key];
        }
      }
    }

    return model;
  }
})();
