# Copyright 2015 FUJITSU LIMITED
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

import unittest

import mock

from monasca_log_api.healthcheck import keystone_protocol

_APP = mock.Mock()
_CONF = {}


class TestKeystoneProtocol(unittest.TestCase):
    def test_should_return_none_if_healthcheck(self):
        instance = keystone_protocol.SkippingAuthProtocol(_APP, _CONF)
        request = mock.Mock()
        request.path = '/healthcheck'

        ret_val = instance.process_request(request)

        self.assertIsNone(ret_val)

    @mock.patch('keystonemiddleware.auth_token.AuthProtocol.process_request')
    def test_should_enter_keystone_auth_if_not_healthcheck(self, proc_request):
        instance = keystone_protocol.SkippingAuthProtocol(_APP, _CONF)
        request = mock.Mock()
        request.path = '/v2.0/logs/single'

        instance.process_request(request)

        self.assertTrue(proc_request.called)
