# Copyright (c) 2012 OpenStack Foundation
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from nova.compute import resource_tracker
from nova import objects


class FakeResourceTracker(resource_tracker.ResourceTracker):
    """Version without a DB requirement."""

    def _create(self, context, values):
        self._write_ext_resources(values)
        self.compute_node = values
        self.compute_node['id'] = 1

    def _update(self, context):
        self._write_ext_resources(self.compute_node)

    def _get_service(self, context):
        return objects.Service(id=1)
