# Copyright (c) 2016 OpenStack Foundation
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from oslo_config import cfg

servicegroup_driver = cfg.StrOpt('servicegroup_driver',
                                  default='db',
                                  help='The driver for servicegroup '
                                       'service.',
                                  choices=['db', 'mc'])

SERVICEGROUP_OPTS = [servicegroup_driver]


def register_opts(conf):
    conf.register_opts(SERVICEGROUP_OPTS)


def list_opts():
    return {'DEFAULT': SERVICEGROUP_OPTS}
