# vim: tabstop=4 shiftwidth=4 softtabstop=4

# Copyright 2010 United States Government as represented by the
# Administrator of the National Aeronautics and Space Administration.
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.


from nova.utils import import_object
from nova.rpc.common import RemoteError, LOG
from nova import flags

FLAGS = flags.FLAGS
flags.DEFINE_string('rpc_backend',
                    'nova.rpc.amqp',
                    "The messaging module to use, defaults to AMQP.")

RPCIMPL = import_object(FLAGS.rpc_backend)


def create_connection(new=True):
    return RPCIMPL.Connection.instance(new=True)


def create_consumer(conn, topic, proxy, fanout=False):
    if fanout:
        return RPCIMPL.FanoutAdapterConsumer(
                connection=conn,
                topic=topic,
                proxy=proxy)
    else:
        return RPCIMPL.TopicAdapterConsumer(
                connection=conn,
                topic=topic,
                proxy=proxy)


def create_consumer_set(conn, consumers):
    return RPCIMPL.ConsumerSet(connection=conn, consumer_list=consumers)


def call(context, topic, msg):
    return RPCIMPL.call(context, topic, msg)


def cast(context, topic, msg):
    return RPCIMPL.cast(context, topic, msg)


def fanout_cast(context, topic, msg):
    return RPCIMPL.fanout_cast(context, topic, msg)


def multicall(context, topic, msg):
    return RPCIMPL.multicall(context, topic, msg)
