# Copyright (c) 2011-2012 OpenStack, LLC
# Copyright (c) 2012 Canonical Ltd
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.


from nova import log as logging
from nova.scheduler import filters
from nova import utils


LOG = logging.getLogger(__name__)


class ArchFilter(filters.BaseHostFilter):
    """Filter out hosts that can not support the guest architecture.
    Note: This is supported for libvirt only now.
    """

    def host_passes(self, host_state, filter_properties):
        spec = filter_properties.get('request_spec', {})
        props = spec.get('instance_properties', {})

        cpu_info = host_state.capabilities.get('cpu_info')
        permitted_instances = cpu_info.get('permitted_instance_types', None)

        instance_arch = utils.sys_platform_translate(props.get('architecture'))

        if permitted_instances and instance_arch in permitted_instances:
            return True

        LOG.warn(_('%(host_state)s fails permitted_instance_types'), locals())
        return False
