.\" dpkg manual page - start-stop-daemon(8)
.\"
.\" Copyright © 1999 Klee Dienes <klee@mit.edu>
.\" Copyright © 1999 Ben Collins <bcollins@debian.org>
.\" Copyright © 2000-2001 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2002-2003 Adam Heath <doogie@debian.org>
.\" Copyright © 2004 Scott James Remnant <keybuk@debian.org>
.\" Copyright © 2008-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH start\-stop\-daemon 8 %RELEASE_DATE% %VERSION% dpkg\-Programmsammlung
.nh
.SH BEZEICHNUNG
start\-stop\-daemon \- startet und stoppt System\-Daemon\-Programme
.
.SH ÜBERSICHT
\fBstart\-stop\-daemon\fP [\fIOption\fP …] \fIBefehl\fP
.
.SH BESCHREIBUNG
\fBstart\-stop\-daemon\fP wird zur Steuerung der Erzeugung und Beendigung von
Prozessen auf Systemebene verwendet. Durch die Verwendung einer der
Abgleich\-Optionen kann \fBstart\-stop\-daemon\fP so konfiguriert werden, dass er
existierende Instanzen von einem laufenden Prozess finden kann.
.PP
Hinweis: Falls \fB\-\-pid\fP oder \fB\-\-pidfile\fP nicht angegeben ist, verhält sich
\fBstart\-stop\-daemon\fP ähnlich zu \fBkillall\fP(1). \fBstart\-stop\-daemon\fP wird die
Prozesstabelle nach Prozessen durchsuchen, die auf den Prozessnamen, die
Eltern\-PID, uid und/oder gid (falls angegeben) passen. Jeder passende
Prozess wird \fB\-\-start\fP daran hindern, den Daemon zu starten. Allen
passenden Prozessen wird das TERM\-Signal (oder das mit \fB\-\-signal\fP oder
\fB\-\-retry\fP angegebene) geschickt, falls \fB\-\-stop\fP angegeben ist. Für Daemons
die langlebige Kinder haben, die ein \fB\-\-stop\fP überleben müssen, müssen Sie
eine PID\-Datei angeben.
.
.SH BEFEHLE
.TP 
\fB\-S\fP, \fB\-\-start\fP [\fB\-\-\fP] \fIArgumente\fP
Prüfe auf Existenz eines angegebenen Prozesses. Falls ein solcher Prozess
existiert führt \fBstart\-stop\-daemon\fP nichts aus und beendet sich mit
Fehlerstatus 1 (0, falls \fB\-\-oknodo\fP angegeben wurde). Falls ein solcher
Prozess nicht existiert, dann startet es eine Instanz, entweder unter
Verwendung des ausführbaren Programms, das mittels \fB\-\-exec\fP (oder, falls
angegeben, mittels \fB\-\-startas\fP) spezifiziert wurde. Jedes weitere auf der
Befehlszeile nach \fB\-\-\fP angegebene Argument wird unverändert an das zu
startende Programm weitergegeben.
.TP 
\fB\-K\fP, \fB\-\-stop\fP
Überprüft auf die Existenz eines speziellen Prozesses. Falls ein solcher
Prozess existiert, dann sendet \fBstart\-stop\-daemon\fP das durch \fB\-\-signal\fP
angegebene Signal und beendet sich mit Fehlerstatus 0. Falls kein solcher
Prozess existiert, dann beendet sich \fBstart\-stop\-daemon\fP mit Fehlerstatus 1
(0 falls \fB\-\-oknodo\fP angegeben ist). Falls \fB\-\-retry\fP angegeben wurde, wird
\fBstart\-stop\-daemon\fP überprüfen, ob der/die Prozess(e) beendet wurden.
.TP 
\fB\-T\fP, \fB\-\-status\fP
Überprüft auf die Existenz eines bestimmten Prozesses und liefert den
Exit\-Status\-Code entsprechend der »LSB Init Script Actions« zurück (seit
Version 1.16.1).
.TP 
\fB\-H\fP, \fB\-\-help\fP
Zeige Bedienungsinformationen und beendet sich.
.TP 
\fB\-V\fP, \fB\-\-version\fP
Zeige die Programmversion und beendet sich.
.
.SH OPTIONEN
.SS Abgleichoptionen
.TP 
\fB\-\-pid\fP \fIPID\fP
Prüfe auf einen Prozess mit der angegebenen \fIPID\fP (seit Version
1.17.6). Die \fIPID\fP muss eine Zahl größer Null sein.
.TP 
\fB\-\-ppid\fP \fIPPID\fP
Prüfe auf einen Prozess mit der angegebenen Eltern\-PID \fIPPID\fP (seit Version
1.17.7). Die \fIPPID\fP muss eine Zahl größer Null sein.
.TP 
\fB\-p\fP, \fB\-\-pidfile\fP \fIpid\-Datei\fP
Prüfe, ob ein Prozess \fIpid\-Datei\fP erstellt hat. Hinweis: Wird diese
Abgleichoption alleine verwandt, könnte auf nicht geplante Prozesse
eingewirkt werden, falls der alte Prozess beendet wurde, ohne dass er
\fIpid\-Datei\fP entfernen konnte.
.TP 
\fB\-x\fP, \fB\-\-exec\fP \fIProgramm\fP
Überprüfe auf Prozesse, die Instanzen von diesem Programm sind. Das Argument
\fIProgramm\fP sollte ein absoluter Pfadname sein. Hinweis: Dies könnte bei
interpretierten Skripten nicht wie geplant funktionieren, da das \fIProgramm\fP
auf den Interpreter zeigt. Berücksichtigen Sie, dass dies auch auf Prozesse,
die innerhalb einer Chroot laufen, passen könnte, daher könnten andere
Abgleichrestriktionen benötigt werden.
.TP 
\fB\-n\fP, \fB\-\-name\fP \fIProzessname\fP
Überprüfe auf Prozesse mit dem Namen \fIProzessname\fP. Der \fIProzessname\fP ist
normalerweise der Dateiname des Prozesses, er könnte aber vom Prozess selbst
geändert worden sein. Hinweis: Auf den meisten Systemen wird diese
Information aus dem »comm«\-Namen des Prozesses aus dem Kernel
ausgelesen. Dieser hat typischerweise eine recht kurze Längenbegrenzung
(mehr als 15 Zeichen anzunehmen ist nicht portabel).
.TP 
\fB\-u\fP, \fB\-\-user\fP \fIBenutzername\fP|\fIuid\fP
Überprüfe auf Prozesse die dem mit \fIBenutzername\fP oder \fIuid\fP
spezifizierten Benutzer gehören. Hinweis: Wird diese Abgleichoption alleine
verwandt, wird auf alle Prozesse, die auf den Benutzer passen, eingewirkt.
.
.SS "Allgemeine Optionen:"
.TP 
\fB\-g\fP, \fB\-\-group\fP \fIGruppe\fP|\fIgid\fP
Wechsle zum Starten des Prozesses zur \fIGruppe\fP oder \fIgid\fP.
.TP 
\fB\-s\fP, \fB\-\-signal\fP \fISignal\fP
Mit \fB\-\-stop\fP wird das an den zu beendenden Prozess zu sendende Signal
spezifiziert (standardmäßig TERM).
.TP 
\fB\-R\fP, \fB\-\-retry\fP \fIZeitüberschreitung\fP|\fIPlan\fP
Mit \fB\-\-stop\fP spezifiziert, dass \fBstart\-stop\-daemon\fP überprüfen soll, ob
der Prozess (die Prozesse) sich beenden. Es überprüft wiederholt, ob
passende Prozesse laufen, bis dies nicht mehr der Fall ist. Falls sich die
Prozesse nicht beenden, werden weitere im »Plan« angegebene Aktionen
durchgeführt.

Falls \fIZeitüberschreitung\fP anstelle von \fIPlan\fP spezifiziert wird, dann
wird der Plan
\fISignal\fP\fB/\fP\fIZeitüberschreitung\fP\fB/KILL/\fP\fIZeitüberschreitung\fP verwendet,
wobei \fISignal\fP das mit \fB\-\-signal\fP spezifizierte Signal ist.

\fIPlan\fP ist eine Liste von mindestens zwei durch Schrägstriche (\fB/\fP)
getrennten Punkten; jeder Punkt kann aus \fB\-\fP\fISignalnummer\fP oder
[\fB\-\fP]\fISignalname\fP bestehen, was bedeutet, dass dieses Signal gesendet
werden soll, oder aus \fIZeitüberschreitung\fP, was bedeutet, dass soviele
Sekunden auf das Beenden von Prozessen gewartet werden soll, oder aus
\fBforever\fP was bedeutet, den Rest des Plans falls notwendig für immer zu
wiederholen.

Falls das Ende des Plans erreicht wird und \fBforever\fP nicht spezifiziert
wurde, dann beendet sich der \fBstart\-stop\-daemon\fP mit dem Fehlerstatus
2. Falls ein Plan spezifiziert wurde, dann wird jedes mit \fB\-\-signal\fP
spezifizierte Signal ignoriert.
.TP 
\fB\-a\fP, \fB\-\-startas\fP \fIPfadname\fP
Mit \fB\-\-start\fP wird der über \fIPfadname\fP spezifizierte Prozess
gestartet. Falls nicht angegeben, werden standardmäßig die an \fB\-\-exec\fP
übergebenen Argumente verwendet.
.TP 
\fB\-t\fP, \fB\-\-test\fP
Gebe die Aktionen aus, die erledigt würden und setze die entsprechenden
Rückgabewerte, führe aber keine Aktionen durch.
.TP 
\fB\-o\fP, \fB\-\-oknodo\fP
Liefert den Rückgabewert 0 anstatt 1 falls keine Aktionen ausgeführt wurden
(würden).
.TP 
\fB\-q\fP, \fB\-\-quiet\fP
Gebe keine informativen Meldungen aus, zeige nur Fehlermeldungen an.
.TP 
\fB\-c \fP, \fB \-\-chuid \fP\fIBenutzername\fP|\fIuid\fP[\fB:\fP\fIGruppe\fP|\fIgid\fP]
Wechsele vor dem Start des Prozesses zu diesem Benutzername/uid. Sie können
durch Anhängen von \fB:\fP auch die Gruppe spezifizieren, in diesem Fall wird
die Gruppe oder gid wie bei dem Befehl \fBchown\fP(1)
(\fIBenutzer\fP\fB:\fP\fIGruppe\fP) angegeben. Falls ein Benutzer ohne Gruppe
angegeben ist, wird die primäre GID für diesen Benutzer verwandt. Wenn Sie
diese Option verwenden, müssen Sie daran denken, dass die primäre und
zusätzliche Gruppen auch gesetzt werden, selbst wenn die Option \fB\-\-group\fP
nicht angegeben wird. Die Option \fB\-\-group\fP ist nur für Gruppen, in denen
der Benutzer normalerweise kein Mitglied ist (wie das Hinzufügen von
pro\-Prozess Gruppenmitgliedschaften für generische Benutzer wie \fBnobody\fP).
.TP 
\fB\-r\fP, \fB\-\-chroot\fP \fIWurzel\fP
Chdir und chroot vor dem Start des Prozesse zu \fIWurzel\fP. Bitte beachten
Sie, dass die PID\-Datei auch nach dem chroot geschrieben wird.
.TP 
\fB\-d\fP, \fB\-\-chdir\fP \fIPfad\fP
Chdir vor dem Starten des Prozesses zu \fIPfad\fP. Dies wird, falls die
\fB\-r\fP|\fB\-\-chroot\fP Option gesetzt ist, nach dem chroot durchgeführt. Falls
nicht angegeben, wird \fBstart\-stop\-daemon\fP vor dem Prozess\-Start in das
Wurzelverzeichnis wechseln.
.TP 
\fB\-b\fP, \fB\-\-background\fP
Typischerweise verwendet für Programme, die sich nicht selbständig
ablösen. Diese Option zwingt \fBstart\-stop\-daemon\fP vor dem Start des
Prozesses einen Fork durchzuführen, und zwingt diesen dann in den
Hintergrund. \fBWarnung: start\-stop\-daemon\fP kann nicht den Rückgabewert
überprüfen, falls der Prozess aus \fBirgendeinem\fP Grund nicht startet. Dies
ist ein letztes Mittel und ist nur für Programme gedacht, bei denen das
selbstständige Forken keinen Sinn ergibt oder wo es nicht sinnvoll ist, den
Code hierfür hinzuzufügen.
.TP 
\fB\-C\fP, \fB\-\-no\-close\fP
Keinen Dateideskriptor schließen, wenn ein Daemon in den Hintergrund
gezwungen wird (seit Version 1.16.5). Dies wird zu Fehlersuchzwecken
angewandt oder um Dateideskriptoren zur Protokollierung der Prozessausgabe
umzuleiten. Nur relevant bei der Verwendung von \fB\-\-background\fP.
.TP 
\fB\-N\fP, \fB\-\-nicelevel\fP \fIGanzzahl\fP
Dies ändert die Priorität des Prozesses bevor er gestartet wird.
.TP 
\fB\-P\fP, \fB\-\-procsched\fP \fIStrategie\fP\fB:\fP\fIPriorität\fP
Dies ändert die Prozesssteuerstrategie (»process scheduler policy«) und die
Priorität des Prozesses, bevor dieser gestartet wird (seit Version
1.15.0). Die Priorität kann optional festgelegt werden, indem ein \fB:\fP
gefolgt von einem Wert angegeben wird. Die Standard\-\fIPriorität\fP beträgt
0. Die derzeit unterstützten Werte für die Strategie lauten \fBother\fP,
\fBfifo\fP und \fBrr\fP.
.TP 
\fB\-I\fP, \fB\-\-iosched\fP \fIKlasse\fP\fB:\fP\fIPriorität\fP
Dies ändert die IO\-Steuerklasse (»IO scheduler class«) und die Priorität des
Prozesses, bevor dieser gestartet wird (seit Version 1.15.0). Die Priorität
kann optional festgelegt werden, indem ein \fB:\fP gefolgt von einem Wert
angegeben wird. Die Standard\-\fIPriorität\fP beträgt 4, außer \fIKlasse\fP lautet
\fBidle\fP, dann beträgt sie immer 7. Die derzeit unterstützten Werte für die
\fIKlasse\fP lauten \fBidle\fP, \fBbest\-effort\fP und \fBreal\-time\fP.
.TP 
\fB\-k\fP, \fB\-\-umask\fP \fIMaske\fP
Dies setzt die umask des Prozesses, bevor er gestartet wird (seit Version
1.13.22).
.TP 
\fB\-m\fP, \fB\-\-make\-pidfile\fP
Verwendet, wenn ein Programm gestartet wird, das keine eigene PID\-Datei
anlegt. Diese Option sorgt dafür, dass \fBstart\-stop\-daemon\fP die mit
\fB\-\-pidfile\fP referenzierte Datei anlegt und die PID kurz vor der Ausführung
des Prozesse hineinlegt. Beachten Sie, dass die Datei beim Anhalten des
Programms nur entfernt wird, falls \fB\-\-remove\-pidfile\fP verwandt
wird. \fBHinweis:\fP Diese Funktion könnte in nicht allen Fällen
funktionieren. Insbesondere wenn das auszuführende Programm sich vom
Hauptprozess forkt. Deshalb ist diese Option normalerweise nur in
Kombination mit der Option \fB\-\-background\fP sinnvoll.
.TP 
\fB\-\-remove\-pidfile\fP
Wird verwandt, wenn ein Programm gestoppt wird, das seine PID\-Datei nicht
entfernt (seit Version 1.17.19). Diese Option führt dazu, dass
\fBstart\-stop\-daemon\fP die durch \fB\-\-pidfile\fP referenzierte Datei nach der
Beendigung des Prozesses entfernt.
.TP 
\fB\-v\fP, \fB\-\-verbose\fP
Gibt ausführliche informative Meldungen aus.
.
.SH RÜCKGABEWERT
.TP 
\fB0\fP
Die angeforderte Aktion wurde durchgeführt. Falls \fB\-\-oknodo\fP angegeben
wurde, kann es auch sein, dass nicht durchgeführt wurde. Das kann passieren,
wenn \fB\-\-start\fP angegeben wurde und der passende Prozess bereits lief oder
wenn \fB\-\-stop\fP angegeben wurde und es keinen passenden Prozess gab.
.TP 
\fB1\fP
Falls \fB\-\-oknodo\fP nicht angegeben war und nichts durchgeführt wurde.
.TP 
\fB2\fP
Falls \fB\-\-stop\fP und \fB\-\-retry\fP angegeben waren, aber das Ende des Plans
erreicht wurde und die Prozesse noch liefen.
.TP 
\fB3\fP
Jeder andere Fehler.
.PP
Bei der Verwendung des Befehls \fB\-\-status\fP werden die folgenden Statuscodes
zurückgeliefert:
.TP 
\fB0\fP
Programm läuft.
.TP 
\fB1\fP
Programm läuft nicht und die PID\-Datei existiert.
.TP 
\fB3\fP
Programm läuft nicht.
.TP 
\fB4\fP
Programmstatus kann nicht bestimmt werden.
.
.SH BEISPIEL
Starte den Daemon \fBfood\fP falls noch keiner läuft (ein Prozess mit Namen
food, der als Benutzer food mit PID in food.pid läuft):
.IP
.nf
start\-stop\-daemon \-\-start \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-startas /usr/sbin/food \e
	\-\-chuid food \-\- \-\-daemon
.fi
.PP
Schicke \fBSIGTERM\fP an \fBfood\fP und warte bis zu fünf Sekunden auf sein
Beenden:
.IP
.nf
start\-stop\-daemon \-\-stop \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-retry 5
.fi
.PP
Vorführung eines angepassten Plans zum Beenden von \fBfood\fP:
.IP
.nf
start\-stop\-daemon \-\-stop \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-retry=TERM/30/KILL/5
.fi
.SH ÜBERSETZUNG
Die deutsche Übersetzung wurde 2004, 2006-2016 von Helge Kreutzmann
<debian@helgefjell.de>, 2007 von Florian Rehnisch <eixman@gmx.de> und
2008 von Sven Joachim <svenjoac@gmx.de>
angefertigt. Diese Übersetzung ist Freie Dokumentation; lesen Sie die
GNU General Public License Version 2 oder neuer für die Kopierbedingungen.
Es gibt KEINE HAFTUNG.
