.\" dselect manual page - dselect(1)
.\"
.\" Copyright © 1995 Juho Vuori <javuori@cc.helsinki.fi>
.\" Copyright © 2000 Josip Rodin
.\" Copyright © 2001 Joost Kooij
.\" Copyright © 2001 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2010-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dselect 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOME
dselect \- frontend per la gestione dei pacchetti Debian
.
.SH SINTASSI
\fBdselect\fP [\fIoption\fP...] [\fIcommand\fP...]
.
.SH DESCRIZIONE
\fBdselect\fP
è una delle interfacce utente principali per la gestione di pacchetti in un sistema
Debian. Nel menu principale di \fBdselect\fP, l'amministratore di sistema può:
 \- aggiornare l'elenco delle versioni disponibili dei pacchetti,
 \- visualizzare lo stato dei pacchetti installati e disponibili,
 \- modificare le selezioni dei pacchetti e gestire le dipendenze,
 \- installare nuovi pacchetti o aggiornarli alle versioni più nuove.
.PP
\fBdselect\fP funziona come frontend per \fBdpkg\fP(1), lo strumento per la
gestione a basso livello dei pacchetti Debian. Ha un gestore delle selezioni
dei pacchetti a tutto schermo con un risolutore delle dipendenze e dei
conflitti tra i pacchetti. Quando viene eseguito con i privilegi di
amministratore, si possono installare, aggiornare e rimuovere pacchetti. È
possibile configurare vari metodi di accesso per recuperare le informazioni
sulle versioni disponibili dei pacchetti e i pacchetti installabili dai
repository dei pacchetti. A seconda del metodo di accesso usato, questi
repository possono essere server di archivi pubblici su Internet, server di
archivi locali o cdrom. Il metodo di accesso raccomandato è \fIapt\fP, che
viene fornito dal pacchetto \fBapt\fP.
.PP
Normally \fBdselect\fP is invoked without parameters. An interactive menu is
presented, offering the user a list of commands. If a command is given as
argument, then that command is started immediately. Several command line
parameters are still available to modify the running behaviour of \fBdselect\fP
or show additional information about the program.
.
.SH OPZIONI
All options can be specified both on the command line and in the \fBdselect\fP
configuration file \fI%PKGCONFDIR%/dselect.cfg\fP or the files on the
configuration directory \fI%PKGCONFDIR%/dselect.cfg.d/\fP. Each line in the
configuration file is either an option (exactly the same as the command line
option but without leading hyphens) or a comment (if it starts with a
‘\fB#\fP’).
.br
.TP 
\fB\-\-admindir\fP\fI directory\fP
Changes the directory where the dpkg ‘\fIstatus\fP’, ‘\fIavailable\fP’ and similar
files are located.  This defaults to \fI%ADMINDIR%\fP and normally there
shouldn't be any need to change it.
.TP 
\fB\-D\fP\fIfile\fP, \fB\-\-debug\fP \fIfile\fP
Attiva il debug. Le informazioni di debug vengono inviate a \fIfile\fP.
.TP 
\fB\-\-expert\fP
Attiva la modalità per esperti, cioè non visualizza messaggi di aiuto
potenzialmente di disturbo.
.TP 
\fB\-\-colour\fP|\fB\-\-color\fP \fIscreenpart\fP:[\fIforeground\fP],[\fIbackground\fP][:\fIattr\fP[\fI+attr\fP]...]
Configura i colori dello schermo. Questo funziona solo se il display
supporta i colori. Questa opzione può essere usata più volte (ed è meglio
usarla in \fIdselect.cfg\fP). Ogni uso cambia il colore (e opzionalmente altri
attributi) di una parte dello schermo; le parti dello schermo (dall'alto in
basso) sono:
.RS
.TP 
\fBtitle\fP
Il titolo della schermata.
.TP 
\fBlisthead\fP
La riga di intestazione sopra all'elenco dei pacchetti.
.TP 
\fBlist\fP
L'elenco scorribile dei pacchetti (e anche alcuni testi di aiuto).
.TP 
\fBlistsel\fP
La voce selezionata nell'elenco.
.TP 
\fBpkgstate\fP
Nell'elenco dei pacchetti, il testo che indica lo stato corrente di ciascun
pacchetto.
.TP 
\fBpkgstatesel\fP
Nell'elenco dei pacchetti, il testo che indica lo stato corrente del
pacchetto attualmente selezionato.
.TP 
\fBinfohead\fP
La riga di intestazione che visualizza lo stato del pacchetto attualmente
selezionato.
.TP 
\fBinfodesc\fP
La descrizione breve del pacchetto.
.TP 
\fBinfo\fP
Usato per visualizzare informazioni su un pacchetto, come la descrizione del
pacchetto.
.TP 
\fBinfofoot\fP
L'ultima riga dello schermo quando si selezionano pacchetti.
.TP 
\fBquery\fP
Usato per visualizzare le righe di interrogazione.
.TP 
\fBhelpscreen\fP
Colore delle schermate di aiuto.
.RE
.IP
La parte dello schermo è seguita da due punti («:») e dall'indicazione del
colore. Si può specificare il colore di primo piano, il colore di sfondo o
entrambi, scavalcando le impostazioni dei colori usate in fase di
compilazione. Usare i nomi dei colori standard di curses.
.IP
Optionally, after the color specification is another colon, and an attribute
specification. This is a list of one or more attributes, separated by plus
(‘+’) characters.  Available attributes include (not all of these will work
on all terminals): \fBnormal\fP, \fBstandout\fP, \fBunderline\fP, \fBreverse\fP,
\fBblink\fP, \fBbright\fP, \fBdim\fP, \fBbold\fP
.TP 
\fB\-?\fP, \fB\-\-help\fP
Stampa un breve messaggio di aiuto e termina con successo.
.TP 
\fB\-\-version\fP
Stampa informazioni sulla versione e termina con successo.
.
.SH COMANDI
When \fBdselect\fP is started it can perform the following commands, either
directly if it was specified on the command line or by prompting the user
with a menu of available commands if running interactively:
.SS accesso
Sceglie e configura un metodo di accesso per accedere ai repository dei
pacchetti.
.sp
In modo predefinito, \fBdselect\fP fornisce svariati metodi, come \fIcdrom\fP,
\fImulti_cd\fP, \fInfs\fP, \fImulti_nfs\fP, \fIharddisk\fP, \fImounted\fP, \fImulti_mount\fP,
\fIfloppy\fP o \fIftp\fP, ma altri pacchetti possono fornire metodi aggiuntivi, ad
esempio il metodo di accesso \fIapt\fP fornito dal pacchetto \fBapt\fP.
.sp
L'uso del metodo di accesso \fIapt\fP è caldamente raccomandato.
.sp
.SS aggiornamento
Aggiorna il database dei pacchetti disponibili.
.sp
Recupera un elenco delle versioni dei pacchetti disponibili dal repository
dei pacchetti, configurato per il metodo di accesso attuale, e aggiorna il
database di dpkg. Gli elenchi dei pacchetti vengono comunemente forniti dal
repository in forma di file \fIPackages\fP o \fIPackages.gz\fP. Questi file
possono essere generati dai manutentori dei repository usndo il programma
\fBdpkg\-scanpackages\fP(1).
.sp
Details of the update command depend on the access method's implementation.
Normally the process is straightforward and requires no user interaction.
.sp
.SS selezione
Visualizza o gestisce le selezioni e le dipendenze dei pacchetti.
.sp
Questa è la funzione principale di \fBdselect\fP. Nella schermata di selezione,
l'utente può passare un rassegna un elenco di tutti i pacchetti disponibili
e installati. Quando eseguito con i privilegi di amministratore è anche
possibile modificare in modo interattivo lo stato di selezione dei
pacchetti. \fBdselect\fP tiene traccia delle implicazioni di queste modifiche
per altri pacchetti con dipendenze o in conflitto.
.sp
Quando viene rilevato un conflitto o una dipendenza non soddisfatta, viene
proposta all'utente una sottoschermata di risoluzione delle dipendenze. In
questa schermata viene mostrato un elenco di pacchetti in conflitto o
dipendenti e la ragione per cui sono presenti. L'utente può applicare le
azioni suggerite proposte da \fBdselect\fP, scavalcarle o annullare tutte le
modifiche, incluse quelle che hanno creato le dipendenze non soddisfatte o i
conflitti.
.sp
L'uso della schermata di gestione della selezione interattiva dei pacchetti
viene spiegata in maggior dettaglio in seguito.
.sp
.SS installazione
Installa i pacchetti selezionati.
.sp
Il metodo di accesso configurato recupererà i pacchetti installabili o
aggiornabili dai repository pertinenti e li installerà usando \fBdpkg\fP. A
seconda dell'implementazione del metodo di accesso, tutti i pacchetti
possono essere recuperati prima dell'installazione, oppure recuperati quando
necessario. Alcuni metodi di accesso possono anche rimuovere i pacchetti che
sono stati contrassegnati per la rimozione.
.sp
Se si verifica un errore durante l'installazione, è normalmente
consigliabile eseguire l'installazione di nuovo. Nella maggior parte dei
casi i problemi spariranno o verranno risolti. Se i problemi persistono o
l'installazione effettuata non era corretta, investigare le cause e le
circostanze e inviare una segnalazione di bug nel sistema di tracciamento
dei bug di Debian. Le istruzioni su come farlo possono essere trovate su
https://bugs.debian.org/ o lette nella documentazione per \fBbug\fP(1) o
\fBreportbug\fP(1), se sono installati.
.sp
Details of the install command depend on the access method's
implementation.  The user's attention and input may be required during
installation, configuration or removal of packages. This depends on the
maintainer scripts in the package. Some packages make use of the
\fBdebconf\fP(1)  library, allowing for more flexible or even automated
installation setups.
.sp
.SS configurazione
Configura qualsiasi pacchetto precedentemente installato, ma non pienamente
configurato.
.sp
.SS rimozione
Rimuove o elimina completamente i pacchetti installati che sono
contrassegnati per la rimozione.
.sp
.SS esci
Quit \fBdselect\fP.
.sp
Esce dal programma con il codice di errore zero (successo).
.sp
.
.SH "GESTIONE DELLE SELEZIONI DEI PACCHETTI"
.sp
.SS Introduzione
.sp
\fBdselect\fP directly exposes the administrator to some of the complexities
involved with managing large sets of packages with many
interdependencies. For a user who is unfamiliar with the concepts and the
ways of the debian package management system, it can be quite
overwhelming. Although \fBdselect\fP is aimed at easing package management and
administration, it is only instrumental in doing so and cannot be assumed to
be a sufficient substitute for administrator skill and understanding. The
user is required to be familiar with the concepts underlying the Debian
packaging system.  In case of doubt, consult the \fBdpkg\fP(1) manpage and the
distribution policy.
.sp
Unless \fBdselect\fP is run in expert or immediate mode, a help screen is first
displayed when choosing this command from the menu. The user is \fIstrongly\fP
advised to study all of the information presented in the online help
screens, when one pops up.  The online help screens can at any time be
invoked with the ‘\fB?\fP’ key.
.sp
.SS "Aspetto della schermata"
.sp
La schermata di selezione è in modo predefinito suddivisa in una metà
superiore e una inferiore. Quella superiore mostra un elenco di pacchetti;
una barra cursore può selezionare un singolo pacchetto o un gruppo di
pacchetti, se possibile, selezionando l'intestazione del gruppo. La metà
inferiore della schermata mostra alcuni dettagli sul pacchetto attualmente
selezionato nella metà superiore; il genere di dettagli visualizzati può
variare.
.sp
Pressing the ‘\fBI\fP’ key toggles a full\-screen display of the packages list,
an enlarged view of the package details, or the equally split screen.
.sp
.SS "Vista dei dettagli del pacchetto"
.sp
The package details view by default shows the extended package description
for the package that is currently selected in the packages status list.
The type of detail can be toggled by pressing the ‘\fBi\fP’ key.
This alternates between:
 \- the extended description
 \- the control information for the installed version
 \- the control information for the available version
.sp
In una schermata di risoluzione delle dipendenze, c'è anche la possibilità
di visualizzare le specifiche dipendenze irrisolte o i conflitti relativi al
pacchetto e che fanno sì che venga elencato qui.
.sp
.SS "Elenco dello stato dei pacchetti"
.sp
La schermata di selezione principale visualizza un elenco di tutti i
pacchetti di cui il sistema di gestione dei pacchetti di Debian è al
corrente. Questo include i pacchetti installati sul sistema e i pacchetti
noti al database dei pacchetti disponibili.
.sp
For every package, the list shows the package's status, priority, section,
installed and available architecture, installed and available versions, the
package name and its short description, all in one line.  By pressing the
‘\fBA\fP’ key, the display of the installed and available architecture can be
toggled between on an off.  By pressing the ‘\fBV\fP’ key, the display of the
installed and available version can be toggled between on an off.  By
pressing the ‘\fBv\fP’ key, the package status display is toggled between
verbose and shorthand.  Shorthand display is the default.
.sp
L'indicazione di stato concisa è composta da quattro parti: un contrassegno
di errore che normalmente dovrebbe essere vuoto, lo stato attuale, l'ultimo
stato selezionato e lo stato di selezione corrente. I primi due riguardano
l'effettivo stato del pacchetto, gli ultimi due riguardano le selezioni
effettuate dall'utente.
.sp
Questi sono i significati dei codici di indicazione concisa dello stato dei pacchetti:
 Contrassegno di errore:
  \fIvuoto\fP   nessun errore
  \fBR\fP       errore grave, necessaria la reinstallazione;
 Stato di installazione:
  \fIvuoto\fP   non installato;
  \fB*\fP       completamente installato e configurato;
  \fB\-\fP       non installato ma possono essere ancora presenti alcuni file di configurazione;
  \fBU\fP       spacchettato ma non ancora configurato;
  \fBC\fP       semi\-configurato (si è verificato un errore);
  \fBI\fP       semi\-installato (si è verificato un errore).
 Selezioni attuali e richieste:
  \fB*\fP       marcato per l'installazione o l'aggiornamento;
  \fB\-\fP       marcato per la rimozione, i file di configurazione rimangono;
  \fB=\fP       bloccato: il pacchetto non verrà affatto considerato;
  \fB_\fP       marcato per l'eliminazione, rimuove anche la configurazione;
  \fBn\fP       il pacchetto è nuovo e deve ancora essere marcato.
.sp
.SS "Movimenti del cursore e dello schermo"
.sp
È possibile muoversi nell'elenco delle selezioni dei pacchetti e nelle
schermate della risoluzione dei conflitti di dipendenza usando i comandi di
movimento associati ai seguenti tasti:
.br
  \fBp, Up, k\fP           muove la barra cursore in alto
  \fBn, Down, j\fP         muove la barra cursore in basso
  \fBP, Pgup, Backspace\fP scorre l'elenco 1 pagina in su
  \fBN, Pgdn, Space\fP     scorre l'elenco 1 pagina in giù
  \fB^p\fP                 scorre l'elenco 1 riga in su
  \fB^n\fP                 scorre l'elenco 1 riga in giù
  \fBt, Home\fP            salta all'inizio dell'elenco
  \fBe, End\fP             salta alla fine dell'elenco
  \fBu\fP                  scorre le informazioni 1 pagina in su
  \fBd\fP                  scorre le informazioni 1 pagina in giù
  \fB^u\fP                 scorre le informazioni 1 riga in su
  \fB^d\fP                 scorre le informazioni 1 riga in giù
  \fBB, Left\-arrow\fP      scorre orizzontalmente il display di 1/3 dello schermo a sinistra
  \fBF, Right\-arrow\fP     scorre orizzontalmente il display di 1/3 dello schermo a destra
  \fB^b\fP                 scorre orizzontalmente il display di 1 carattere a sinistra
  \fB^f\fP                 scorre orizzontalmente il display di 1 carattere a destra
.sp
.SS "Ricerca e ordinamento"
.sp
The list of packages can be searched by package name. This is done by
pressing ‘\fB/\fP’, and typing a simple search string. The string is
interpreted as a \fBregex\fP(7)  regular expression.  If you add ‘\fB/d\fP’ to the
search expression, dselect will also search in descriptions.  If you add
‘\fB/i\fP’ the search will be case insensitive.  You may combine these two
suffixes like this: ‘\fB/id\fP’.  Repeated searching is accomplished by
repeatedly pressing the ‘\fBn\fP’ or ‘\fB\e\fP’ keys, until the wanted package is
found.  If the search reaches the bottom of the list, it wraps to the top
and continues searching from there.
.sp
The list sort order can be varied by pressing
the ‘\fBo\fP’ and ‘\fBO\fP’ keys repeatedly.
The following nine sort orderings can be selected:
 alphabet          available           status
 priority+section  available+priority  status+priority
 section+priority  available+section   status+section
.br
Quando non esplicitamente elencato, il criterio alfabetico viene usato come
chiave di sotto\-ordinamento.
.sp
.SS "Modificare le selezioni"
.sp
Lo stato di selezione richiesto per i singoli pacchetti può essere
modificato con i seguenti comandi:
  \fB+, Insert\fP    installa o aggiorna
  \fB=, H\fP         blocca allo stato e alla versione attuali
  \fB:, G\fP         sblocca: aggiorna o lascia non installato
  \fB\-, Delete\fP    rimuove, ma lascia i file di configurazione
  \fB_\fP            rimuove ed elimina la configurazione
.sp
Quando il cambiamento richiesto ha come risultato una o più dipendenze non
soddisfatte o conflitti, \fBdselect\fP propone all'utente una schermata di
risoluzione delle dipendenze; quest'ultima verrà spiegata meglio in seguito.
.sp
È anche possibile applicare questi comandi a gruppi di selezioni di
pacchetti, mettendo la barra cursore su un'intestazione di un
gruppo. L'esatto raggruppamento dei pacchetti dipende dalle impostazioni
attuali per l'ordinamento dell'elenco.
.sp
Si dovrebbe prestare la dovuta attenzione quando si modificano grandi gruppi
di selezioni, perché ciò può istantaneamente creare un grande numero di
dipendenze non soddisfatte o di conflitti, che vengono elencati tutti in
un'unica schermata di risoluzione delle dipendenze, rendendoli veramente
difficili da gestire. In pratica, solo le operazioni di blocco e sblocco
sono utili quando applicate a gruppi.
.sp
.SS "Risoluzione delle dipendenze e dei conflitti"
.sp
Quando il cambiamento richiesto ha come risultato una o più dipendenze non
soddisfatte o conflitti, \fBdselect\fP propone all'utente una schermata di
risoluzione delle dipendenze. Prima viene comunque visualizzata una
schermata di aiuto informativa.
.sp
La metà superiore di questa schermata elenca tutti i pacchetti che avranno
dipendenze non soddisfatte o conflitti, come risultato della modifica
richiesta, e tutti i pacchetti la cui installazione può risolvere qualcuna
di queste dipendenze, o la cui rimozione può risolvere qualcuno dei
conflitti. La metà inferiore visualizza in modo predefinito le dipendenze o
i conflitti che fanno sì che il pacchetto attualmente selezionato sia
presente nell'elenco.
.sp
Quando il sotto\-elenco dei pacchetti è inizialmente visualizzato, \fBdselect\fP
può già aver impostato lo stato di selezione richiesto per alcuni dei
pacchetti elencati, allo scopo di risolvere le dipendenze o i conflitti che
hanno causato la visualizzazione della schermata di risoluzione. Solitamente
è bene seguire i suggerimenti proposti da \fBdselect\fP.
.sp
The listed packages' selection state may be reverted to the original
settings, as they were before the unresolved depends or conflicts were
created, by pressing the ‘\fBR\fP’ key.  By pressing the ‘\fBD\fP’ key, the
automatic suggestions are reset, but the change that caused the dependency
resolution screen to be prompted is kept as requested.  Finally, by pressing
‘\fBU\fP’, the selections are again set to the automatic suggestion values.
.sp
.SS "Stabilire le selezioni richieste"
.sp
Premendo \fBInvio\fP, si accetta l'insieme attualmente visualizzato delle
selezioni. Se \fBdselect\fP non rileva alcuna dipendenza non soddisfatta come
risultato delle selezioni richieste, le nuove selezioni saranno
impostate. Tuttavia, se vi sono dipendenze non soddisfatte, \fBdselect\fP
interrogherà nuovamente l'utente con una schermata di risoluzione delle
dipendenze.
.sp
To alter a set of selections that creates unresolved depends or conflicts
and forcing \fBdselect\fP to accept it, press the ‘\fBQ\fP’ key. This sets the
selections as specified by the user, unconditionally. Generally, don't do
this unless you've read the fine print.
.sp
The opposite effect, to back out any selections change requests and go back
to the previous list of selections, is attained by pressing the ‘\fBX\fP’ or
\fBescape\fP keys. By repeatedly pressing these keys, any possibly detrimental
changes to the requested package selections can be backed out completely to
the last established settings.
.sp
If you mistakenly establish some settings and wish to revert all the
selections to what is currently installed on the system, press the ‘\fBC\fP’
key.  This is somewhat similar to using the unhold command on all packages,
but provides a more obvious panic button in cases where the user pressed
\fBenter\fP by accident.
.sp
.
.SH "STATO D'USCITA"
.TP 
\fB0\fP
The requested command was successfully performed.
.TP 
\fB2\fP
Fatal or unrecoverable error due to invalid command\-line usage, or
interactions with the system, such as accesses to the database, memory
allocations, etc.
.
.SH AMBIENTE
.TP 
\fBHOME\fP
Se impostata, \fBdselect\fP la userà come directory in cui leggere il file di
configurazione specifico dell'utente.
.
.SH BUG
L'interfaccia di selezione dei pacchetti di \fBdselect\fP è fonte di confusione
per alcuni nuovi utenti. A quanto si dice, fa piangere persino gli
sviluppatori del kernel esperti.
.sp
La documentazione è carente.
.sp
Non c'è un'opzione aiuto nel menu principale.
.sp
L'elenco visibile dei pacchetti disponibili non può essere ridotto.
.sp
I metodi di accesso integrati non possono più stare al passo con gli
standard di qualità attuali. Usare il metodo di accesso fornito da apt; non
solo non è difettoso, ma è anche molto più flessibile dei metodi di accesso
integrati.
.
.SH "VEDERE ANCHE"
\fBdpkg\fP(1), \fBapt\-get\fP(8), \fBsources.list\fP(5), \fBdeb\fP(5).
