# == Class: ceilometer::dispatcher::gnocchi
#
# Configure Gnocchi dispatcher for Ceilometer
#
# === Parameters:
#
# [*filter_service_activity*]
#   (Optional) Filter out samples generated by Gnocchi service activity.
#   Defaults to $::os_service_default.
#
# [*filter_project*]
#   (Optional) Gnocchi project used to filter out samples
#   generated by Gnocchi service activity
#   Defaults to $::os_service_default.
#
# [*resources_definition_file*]
#   (Optional) The Yaml file that defines mapping between samples
#   and gnocchi resources/metrics.
#   Defaults to $::os_service_default.
#
# DEPRECATED PARAMETERS
#
# [*url*]
#   (Optional) Gnocchi URL
#   Defaults to undef
#
# [*archive_policy*]
#   (Optional) The archive policy to use when the dispatcher
#   Defaults to undef
#
#

class ceilometer::dispatcher::gnocchi (
  $filter_service_activity   = $::os_service_default,
  $filter_project            = $::os_service_default,
  $resources_definition_file = $::os_service_default,
  # DEPRECATED PARAMETERS
  $url                       = undef,
  $archive_policy            = undef,
) {

  include ::ceilometer::deps

  if $archive_policy {
    warning('archive_policy parameter is deprecated, has no effect and will be removed in the Q release.')
  }
  if $url {
    warning('url parameter is deprecated, has no effect and will be removed in the Q release.')
  }

  ceilometer_config {
    'dispatcher_gnocchi/filter_service_activity':   value => $filter_service_activity;
    'dispatcher_gnocchi/filter_project':            value => $filter_project;
    'dispatcher_gnocchi/resources_definition_file': value => $resources_definition_file;
  }

}
