# Copyright 2015 Red Hat, Inc.
# All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

# == Class: tripleo::noop
#
# Enable noop mode for various Puppet resource types via collectors.
#
# === Parameters:
# [*package*]
#  Whether Package resources should be noop.
#  Defaults to true
#
# [*file*]
#  Whether File resources should be noop.
#  Defaults to true
#
# [*service*]
#  Whether Service resources should be noop.
#  Defaults to true
#
# [*exec*]
#  Whether Exec resources should be noop.
#  Defaults to true
#
# [*user*]
#  Whether User resources should be noop.
#  Defaults to true
#
# [*group*]
#  Whether Group resources should be noop.
#  Defaults to true
#
# [*cron*]
#  Whether Cron resources should be noop.
#  Defaults to true
#
#
class tripleo::noop (
  $package = true,
  $file = true,
  $service = true,
  $exec = true,
  $user = true,
  $group = true,
  $cron = true,
) {

  Package <| |> { noop => $package}
  File <| |> { noop => $file}
  Service <| |> { noop => $service}
  Exec <| |> { noop => $exec}
  User <| |> { noop => $user}
  Group <| |> { noop => $group}
  Cron <| |> { noop => $cron}

}
