# Copyright 2018 OpenStack Foundation.
#
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.

"""add function aliases support

Revision ID: 004
Revises: 003
Create Date: 2018-05-17 03:09:04.888969

"""

# revision identifiers, used by Alembic.
revision = '004'
down_revision = '003'

from alembic import op
import sqlalchemy as sa


def upgrade():
    op.create_table(
        'function_aliases',
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('updated_at', sa.DateTime(), nullable=True),
        sa.Column('project_id', sa.String(length=80), nullable=False),
        sa.Column('id', sa.String(length=36), nullable=False),
        sa.Column('name', sa.String(length=255), nullable=False),
        sa.Column('function_id', sa.String(length=36), nullable=False),
        sa.Column('function_version', sa.Integer, nullable=False),
        sa.Column('description', sa.String(length=255), nullable=True),
        sa.PrimaryKeyConstraint('id'),
        sa.ForeignKeyConstraint(['function_id'], [u'functions.id']),
        sa.UniqueConstraint('function_id', 'function_version', 'project_id'),
        sa.UniqueConstraint('name', 'project_id'),
        sa.Index(
            'function_aliases_project_id_function_id_function_version',
            'project_id', 'function_id', 'function_version'
        ),
        sa.Index(
            'function_aliases_project_id_name',
            'project_id', 'name'
        )
    )
