/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.swift.auth;

import org.apache.hadoop.fs.swift.auth.AuthenticationRequestV3;

public class TokenAuthenticationRequestV3
extends AuthenticationRequestV3 {
    private final IdentityWrapper identity;

    public TokenAuthenticationRequestV3(String token) {
        this.identity = new IdentityWrapper(new TokenWrapper(token));
    }

    public IdentityWrapper getIdentity() {
        return this.identity;
    }

    @Override
    public String toString() {
        return "Authenticate(v3) as token";
    }

    public static class TokenWrapper {
        private final String token;

        public TokenWrapper(String token) {
            this.token = token;
        }

        public String getId() {
            return this.token;
        }
    }

    public static class IdentityWrapper {
        private final TokenWrapper token;
        private final String[] methods;

        public IdentityWrapper(TokenWrapper token) {
            this.token = token;
            this.methods = new String[]{"token"};
        }

        public String[] getMethods() {
            return this.methods;
        }

        public TokenWrapper getToken() {
            return this.token;
        }
    }
}

