/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.swift.snative;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Header;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.swift.exceptions.SwiftConfigurationException;
import org.apache.hadoop.fs.swift.exceptions.SwiftException;
import org.apache.hadoop.fs.swift.exceptions.SwiftInvalidResponseException;
import org.apache.hadoop.fs.swift.exceptions.SwiftOperationFailedException;
import org.apache.hadoop.fs.swift.http.HttpBodyContent;
import org.apache.hadoop.fs.swift.http.SwiftRestClient;
import org.apache.hadoop.fs.swift.snative.SwiftFileStatus;
import org.apache.hadoop.fs.swift.snative.SwiftObjectFileStatus;
import org.apache.hadoop.fs.swift.util.DurationStats;
import org.apache.hadoop.fs.swift.util.JSONUtil;
import org.apache.hadoop.fs.swift.util.SwiftObjectPath;
import org.apache.hadoop.fs.swift.util.SwiftUtils;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.apache.hadoop.util.ReflectionUtils;
import org.codehaus.jackson.map.type.CollectionType;

public class SwiftNativeFileSystemStore {
    private static final Pattern URI_PATTERN = Pattern.compile("\"\\S+?\"");
    private static final String PATTERN = "EEE, d MMM yyyy hh:mm:ss zzz";
    private static final Log LOG = LogFactory.getLog(SwiftNativeFileSystemStore.class);
    private URI uri;
    private SwiftRestClient swiftRestClient;
    private DNSToSwitchMapping dnsToSwitchMapping;

    public void initialize(URI fsURI, Configuration configuration) throws IOException {
        this.uri = fsURI;
        this.dnsToSwitchMapping = (DNSToSwitchMapping)ReflectionUtils.newInstance((Class)configuration.getClass("topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class), (Configuration)configuration);
        this.swiftRestClient = SwiftRestClient.getInstance(fsURI, configuration);
    }

    public String toString() {
        return "SwiftNativeFileSystemStore with " + this.swiftRestClient;
    }

    public long getBlocksize() {
        return 1024L * this.swiftRestClient.getBlocksizeKB();
    }

    public long getPartsizeKB() {
        return this.swiftRestClient.getPartSizeKB();
    }

    public int getBufferSizeKB() {
        return this.swiftRestClient.getBufferSizeKB();
    }

    public int getThrottleDelay() {
        return this.swiftRestClient.getThrottleDelay();
    }

    public void uploadFile(Path path, InputStream inputStream, long length) throws IOException {
        this.swiftRestClient.upload(this.toObjectPath(path), inputStream, length, new Header[0]);
    }

    public void uploadFilePart(Path path, int partNumber, InputStream inputStream, long length) throws IOException {
        String stringPath = path.toUri().getPath();
        String partitionFilename = SwiftUtils.partitionFilenameFromNumber(partNumber);
        stringPath = stringPath.endsWith("/") ? stringPath.concat(partitionFilename) : stringPath.concat("/").concat(partitionFilename);
        this.swiftRestClient.upload(new SwiftObjectPath(this.toDirPath(path).getContainer(), stringPath), inputStream, length, new Header[0]);
    }

    public void createManifestForPartUpload(Path path) throws IOException {
        String pathString = this.toObjectPath(path).toString();
        if (!pathString.endsWith("/")) {
            pathString = pathString.concat("/");
        }
        if (pathString.startsWith("/")) {
            pathString = pathString.substring(1);
        }
        this.swiftRestClient.upload(this.toObjectPath(path), new ByteArrayInputStream(new byte[0]), 0L, new Header("X-Object-Manifest", pathString));
    }

    public SwiftFileStatus getObjectMetadata(Path path) throws IOException {
        return this.getObjectMetadata(path, true);
    }

    public Header[] getObjectHeaders(Path path, boolean newest) throws IOException, FileNotFoundException {
        SwiftObjectPath objectPath = this.toObjectPath(path);
        return this.stat(objectPath, newest);
    }

    public SwiftFileStatus getObjectMetadata(Path path, boolean newest) throws IOException, FileNotFoundException {
        String pathUri;
        SwiftObjectPath objectPath = this.toObjectPath(path);
        Path statusPath = path;
        if (statusPath.toUri().toString().endsWith("/") && (pathUri = statusPath.toUri().toString()).length() > 1) {
            statusPath = new Path(pathUri.substring(0, pathUri.length() - 1));
        }
        Header[] headers = null;
        try {
            headers = this.stat(objectPath, newest);
        }
        catch (FileNotFoundException e) {
            try {
                objectPath = this.toDirPath(path);
                headers = this.stat(objectPath, newest);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (headers == null || headers.length == 0) {
            if (this.existsPseudoDirectory(objectPath)) {
                Path pseudoDirPath = this.getCorrectSwiftPath(statusPath);
                return SwiftFileStatus.createPseudoDirStatus(pseudoDirPath);
            }
            throw new FileNotFoundException("Not Found " + path.toUri());
        }
        boolean isDir = false;
        long length = 0L;
        long lastModified = 0L;
        SwiftObjectPath dloPrefix = null;
        for (Header header : headers) {
            String[] values;
            String headerName = header.getName();
            if (headerName.equals("X-Container-Object-Count") || headerName.equals("X-Container-Bytes-Used")) {
                length = 0L;
                isDir = true;
            }
            if ("Content-Length".equals(headerName)) {
                length = Long.parseLong(header.getValue());
            }
            if ("Last-Modified".equals(headerName)) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(PATTERN, Locale.US);
                try {
                    lastModified = simpleDateFormat.parse(header.getValue()).getTime();
                }
                catch (ParseException e) {
                    throw new SwiftException("Failed to parse " + header.toString(), e);
                }
            }
            if (!headerName.equals("X-Object-Manifest") || (values = header.getValue().split("/", 2)).length != 2) continue;
            dloPrefix = new SwiftObjectPath(values[0], "/" + values[1]);
        }
        if (lastModified == 0L) {
            lastModified = System.currentTimeMillis();
        }
        if (objectPath.toString().endsWith("/")) {
            isDir = true;
        }
        Path correctSwiftPath = this.getCorrectSwiftPath(statusPath);
        return new SwiftFileStatus(length, isDir, 1, this.getBlocksize(), lastModified, correctSwiftPath, dloPrefix);
    }

    private Header[] stat(SwiftObjectPath objectPath, boolean newest) throws IOException {
        Header[] headers = newest ? this.swiftRestClient.headRequest("getObjectMetadata-newest", objectPath, SwiftRestClient.NEWEST) : this.swiftRestClient.headRequest("getObjectMetadata", objectPath, new Header[0]);
        return headers;
    }

    private boolean existsPseudoDirectory(SwiftObjectPath path) {
        try {
            String pseudoDirName = path.getObject();
            if (pseudoDirName.endsWith("/")) {
                String obj = path.getObject();
                path = new SwiftObjectPath(path.getContainer(), obj.substring(0, obj.length() - 1));
            } else {
                pseudoDirName = pseudoDirName.concat("/");
            }
            byte[] bytes = this.swiftRestClient.listDeepObjectsInDirectory(path, false, false, new Header[0]);
            CollectionType collectionType = JSONUtil.getJsonMapper().getTypeFactory().constructCollectionType(List.class, SwiftObjectFileStatus.class);
            List fileStatusList = (List)JSONUtil.toObject(new String(bytes), collectionType);
            for (SwiftObjectFileStatus status : fileStatusList) {
                if (!pseudoDirName.equals(status.getSubdir())) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public HttpBodyContent getObject(Path path) throws IOException {
        List<String> locations = this.getDataLocalEndpoints(path);
        for (String url : locations) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Reading " + path + " from location: " + url));
            }
            try {
                return this.swiftRestClient.getData(new URI(url), SwiftRestClient.NEWEST);
            }
            catch (Exception exception) {
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reading " + path + " from proxy node"));
        }
        return this.swiftRestClient.getData(this.toObjectPath(path), SwiftRestClient.NEWEST);
    }

    private List<String> getDataLocalEndpoints(Path path) throws IOException {
        String hostRack = this.getHostRack();
        List<URI> uriLocations = this.getObjectLocation(path);
        ArrayList<String> strLocations = new ArrayList<String>();
        final HashMap<String, Integer> similarityMap = new HashMap<String, Integer>();
        for (URI uri : uriLocations) {
            String url = uri.toString();
            int similarity = this.getSimilarity(this.getRack(uri.getHost()), hostRack);
            if (similarity <= 0) continue;
            strLocations.add(url);
            similarityMap.put(url, similarity);
        }
        Collections.sort(strLocations, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer dst1 = (Integer)similarityMap.get(o1);
                Integer dst2 = (Integer)similarityMap.get(o2);
                return -dst1.compareTo(dst2);
            }
        });
        return strLocations;
    }

    private int getSimilarity(String rack1, String rack2) {
        int i;
        String[] r1 = rack1.split("/");
        String[] r2 = rack2.split("/");
        for (i = 1; i < r1.length && i < r2.length && r1[i].equals(r2[i]); ++i) {
        }
        return i - 1;
    }

    private String getHostRack() throws SwiftException {
        String hostAddress;
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new SwiftException("Failed to get localhost address", e);
        }
        return this.getRack(hostAddress);
    }

    private String getRack(String url) {
        return (String)this.dnsToSwitchMapping.resolve(Arrays.asList(url)).get(0);
    }

    public HttpBodyContent getObject(Path path, long byteRangeStart, long length) throws IOException {
        List<String> locations = this.getDataLocalEndpoints(path);
        for (String url : locations) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Reading " + path + " from location: " + url));
            }
            try {
                return this.swiftRestClient.getData(new URI(url), byteRangeStart, length);
            }
            catch (Exception exception) {
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reading " + path + " from proxy node"));
        }
        return this.swiftRestClient.getData(this.toObjectPath(path), byteRangeStart, length);
    }

    private List<FileStatus> listDirectory(SwiftObjectPath path, boolean listDeep, boolean newest, boolean addTrailingSlash) throws IOException {
        byte[] bytes;
        ArrayList<FileStatus> files = new ArrayList<FileStatus>();
        Path correctSwiftPath = this.getCorrectSwiftPath(path);
        try {
            bytes = this.swiftRestClient.listDeepObjectsInDirectory(path, listDeep, addTrailingSlash, new Header[0]);
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("File/Directory not found " + path));
            }
            if (SwiftUtils.isRootDir(path)) {
                return Collections.emptyList();
            }
            throw e;
        }
        catch (SwiftInvalidResponseException e) {
            if (e.getStatusCode() == 204) {
                if (SwiftUtils.isRootDir(path)) {
                    return Collections.emptyList();
                }
                SwiftFileStatus stat = this.getObjectMetadata(correctSwiftPath, newest);
                if (stat.isDir()) {
                    return Collections.emptyList();
                }
                files.add(stat);
                return files;
            }
            throw e;
        }
        CollectionType collectionType = JSONUtil.getJsonMapper().getTypeFactory().constructCollectionType(List.class, SwiftObjectFileStatus.class);
        List fileStatusList = (List)JSONUtil.toObject(new String(bytes), collectionType);
        if (fileStatusList.isEmpty()) {
            SwiftFileStatus objectMetadata = this.getObjectMetadata(correctSwiftPath, newest);
            if (objectMetadata.isFile()) {
                files.add(objectMetadata);
            }
            return files;
        }
        String pathWithSlash = path.getObject();
        if (!pathWithSlash.endsWith("/")) {
            pathWithSlash = pathWithSlash.concat("/");
        }
        String prevObjName = "";
        for (SwiftObjectFileStatus status : fileStatusList) {
            String name = status.getName();
            if (name == null) {
                name = status.getSubdir();
            }
            if (name == null || name.equals(pathWithSlash)) continue;
            if (!name.endsWith("/")) {
                Path filePath = this.getCorrectSwiftPath(new Path(name));
                files.add(this.getObjectMetadata(filePath, newest));
                prevObjName = name;
                continue;
            }
            if (prevObjName.length() + 1 == name.length() && name.startsWith(prevObjName)) continue;
            Path dirPath = this.getCorrectSwiftPath(this.toDirPath(new Path(name)));
            files.add(this.getObjectMetadata(dirPath, newest));
        }
        return files;
    }

    public FileStatus[] listSubPaths(Path path, boolean recursive, boolean newest) throws IOException {
        List<FileStatus> fileStatuses = this.listDirectory(this.toDirPath(path), recursive, newest, true);
        return fileStatuses.toArray(new FileStatus[fileStatuses.size()]);
    }

    public void createDirectory(Path path) throws IOException {
        this.innerCreateDirectory(this.toDirPath(path));
    }

    private void innerCreateDirectory(SwiftObjectPath swiftObjectPath) throws IOException {
        this.swiftRestClient.putRequest(swiftObjectPath, new Header[0]);
    }

    private SwiftObjectPath toDirPath(Path path) throws SwiftConfigurationException {
        return SwiftObjectPath.fromPath(this.uri, path, true);
    }

    private SwiftObjectPath toObjectPath(Path path) throws SwiftConfigurationException {
        return SwiftObjectPath.fromPath(this.uri, path);
    }

    public List<URI> getObjectLocation(Path path) throws IOException {
        byte[] objectLocation = this.swiftRestClient.getObjectLocation(this.toObjectPath(path), new Header[0]);
        if (objectLocation == null || objectLocation.length == 0) {
            return new LinkedList<URI>();
        }
        return SwiftNativeFileSystemStore.extractUris(new String(objectLocation), path);
    }

    public boolean deleteObject(FileStatus status) throws IOException {
        SwiftObjectPath swiftObjectPath = status.isDir() ? this.toDirPath(status.getPath()) : this.toObjectPath(status.getPath());
        if (!SwiftUtils.isRootDir(swiftObjectPath)) {
            return this.swiftRestClient.delete(swiftObjectPath, new Header[0]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Not deleting root directory entry");
        }
        return true;
    }

    public boolean objectExists(Path path) throws IOException {
        return this.objectExists(this.toObjectPath(path));
    }

    public boolean objectExists(SwiftObjectPath path) throws IOException {
        try {
            Header[] headers = this.swiftRestClient.headRequest("objectExists", path, SwiftRestClient.NEWEST);
            return headers.length != 0;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rename(Path src, Path dst) throws FileNotFoundException, SwiftOperationFailedException, IOException {
        boolean destIsDir;
        SwiftObjectPath destObject;
        SwiftFileStatus dstMetadata;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mv " + src + " " + dst));
        }
        boolean renamingOnToSelf = src.equals((Object)dst);
        SwiftFileStatus srcMetadata = this.getObjectMetadata(src);
        SwiftObjectPath srcObject = srcMetadata.isDirectory() ? this.toDirPath(src) : this.toObjectPath(src);
        if (SwiftUtils.isRootDir(srcObject)) {
            throw new SwiftOperationFailedException("cannot rename root dir");
        }
        try {
            dstMetadata = this.getObjectMetadata(dst);
            destObject = dstMetadata.isDirectory() ? this.toDirPath(dst) : this.toObjectPath(dst);
        }
        catch (FileNotFoundException e) {
            LOG.debug((Object)"Destination does not exist");
            dstMetadata = null;
            destObject = this.toObjectPath(dst);
        }
        Path srcParent = src.getParent();
        Path dstParent = dst.getParent();
        if (dstParent != null && !dstParent.equals((Object)srcParent)) {
            try {
                this.getObjectMetadata(dstParent);
            }
            catch (FileNotFoundException e) {
                LOG.debug((Object)("destination parent directory " + dstParent + " doesn't exist"));
                throw e;
            }
        }
        boolean destExists = dstMetadata != null;
        boolean bl = destIsDir = destExists && dstMetadata.isDirectory();
        if (srcMetadata.isFile()) {
            SwiftObjectPath destPath;
            block22: {
                if (destExists) {
                    if (destIsDir) {
                        destPath = this.toObjectPath(new Path(dst, src.getName()));
                        break block22;
                    } else {
                        if (!renamingOnToSelf) {
                            throw new SwiftOperationFailedException("cannot rename a file over one that already exists");
                        }
                        LOG.debug((Object)"Renaming file onto self: no-op => success");
                        return;
                    }
                }
                destPath = this.toObjectPath(dst);
            }
            this.copyThenDeleteObject(srcObject, srcMetadata, destPath);
            return;
        }
        if (destExists && !destIsDir) {
            throw new SwiftOperationFailedException("the source is a directory, but not the destination");
        }
        Path targetPath = destExists ? new Path(dst, src.getName()) : dst;
        SwiftObjectPath targetObjectPath = this.toDirPath(targetPath);
        if (srcObject.isEqualToOrParentOf(targetObjectPath)) {
            throw new SwiftOperationFailedException("cannot move a directory under itself");
        }
        LOG.info((Object)("mv  " + srcObject + " " + targetPath));
        List<FileStatus> childStats = this.listDirectory(srcObject, true, true, true);
        this.logDirectory("Directory to copy ", srcObject, childStats);
        String srcURI = src.toUri().toString();
        int prefixStripCount = srcURI.length() + 1;
        for (FileStatus fileStatus : childStats) {
            SwiftObjectPath copyDestination;
            SwiftObjectPath copySource;
            Path copySourcePath = fileStatus.getPath();
            String copySourceURI = copySourcePath.toUri().toString();
            String copyDestSubPath = copySourceURI.substring(prefixStripCount);
            Path copyDestPath = new Path(targetPath, copyDestSubPath);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("srcURI=" + srcURI + "; copySourceURI=" + copySourceURI + "; copyDestSubPath=" + copyDestSubPath + "; copyDestPath=" + copyDestPath));
            }
            if (fileStatus.isDir()) {
                copySource = this.toDirPath(copySourcePath);
                copyDestination = this.toDirPath(copyDestPath);
            } else {
                copySource = this.toObjectPath(copySourcePath);
                copyDestination = this.toObjectPath(copyDestPath);
            }
            try {
                this.copyThenDeleteObject(copySource, (SwiftFileStatus)fileStatus, copyDestination);
            }
            catch (FileNotFoundException e) {
                LOG.info((Object)("Skipping rename of " + copySourcePath));
            }
            this.throttle();
        }
        if (SwiftUtils.isRootDir(srcObject)) return;
        try {
            if (srcMetadata.isPseudoDir()) return;
            this.copyThenDeleteObject(srcObject, srcMetadata, targetObjectPath);
            return;
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)"Source directory deleted during rename", (Throwable)e);
            this.innerCreateDirectory(destObject);
        }
    }

    private void logDirectory(String message, SwiftObjectPath objectPath, Iterable<FileStatus> statuses) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(message + ": listing of " + objectPath));
            for (FileStatus fileStatus : statuses) {
                LOG.debug((Object)fileStatus.getPath());
            }
        }
    }

    private void copyThenDeleteObject(SwiftObjectPath srcObject, SwiftFileStatus srcMeta, SwiftObjectPath destObject) throws IOException {
        this.copyObject(srcObject, srcMeta, destObject, true);
    }

    private void copyObject(SwiftObjectPath srcObject, SwiftFileStatus srcMeta, SwiftObjectPath destObject, boolean deleteSrc) throws IOException {
        if (srcObject.isEqualToOrParentOf(destObject)) {
            throw new SwiftException("Can't copy " + srcObject + " onto " + destObject);
        }
        if (srcMeta.isDLO()) {
            Path newPrefixPath = this.getCorrectSwiftPath(destObject);
            String newPrefixName = newPrefixPath.toUri().getPath();
            if (!newPrefixName.endsWith("/")) {
                newPrefixName = newPrefixName.concat("/");
            }
            String oldPrefixName = srcMeta.getDLOPrefix().getObject();
            List<FileStatus> segments = this.listDirectory(srcMeta.getDLOPrefix(), true, true, true);
            this.createManifestForPartUpload(newPrefixPath);
            for (FileStatus s : segments) {
                SwiftObjectPath destSeg;
                if (s.getLen() == 0L) continue;
                String oldName = s.getPath().toUri().getPath();
                String newName = newPrefixName + oldName.substring(oldPrefixName.length());
                SwiftObjectPath srcSeg = new SwiftObjectPath(srcObject.getContainer(), oldName);
                if (this.swiftRestClient.copyObject(srcSeg, destSeg = new SwiftObjectPath(destObject.getContainer(), newName), new Header[0])) continue;
                throw new SwiftException("Copy of " + srcSeg + " to " + destSeg + "failed");
            }
            if (deleteSrc) {
                for (FileStatus s : segments) {
                    SwiftObjectPath srcSeg = new SwiftObjectPath(srcObject.getContainer(), s.getPath().toUri().getPath());
                    this.swiftRestClient.delete(srcSeg, new Header[0]);
                }
            }
        } else {
            boolean copySucceeded = this.swiftRestClient.copyObject(srcObject, destObject, new Header[0]);
            if (!copySucceeded) {
                throw new SwiftException("Copy of " + srcObject + " to " + destObject + "failed");
            }
        }
        if (deleteSrc) {
            this.swiftRestClient.delete(srcObject, new Header[0]);
        }
    }

    public Path getCorrectSwiftPath(Path path) throws SwiftException {
        try {
            URI fullUri = new URI(this.uri.getScheme(), this.uri.getAuthority(), path.toUri().getPath(), null, null);
            return new Path(fullUri);
        }
        catch (URISyntaxException e) {
            throw new SwiftException("Specified path " + path + " is incorrect", e);
        }
    }

    private Path getCorrectSwiftPath(SwiftObjectPath path) throws SwiftException {
        try {
            URI fullUri = new URI(this.uri.getScheme(), this.uri.getAuthority(), path.getObject(), null, null);
            return new Path(fullUri);
        }
        catch (URISyntaxException e) {
            throw new SwiftException("Specified path " + path + " is incorrect", e);
        }
    }

    public static List<URI> extractUris(String json, Path path) throws SwiftOperationFailedException {
        Matcher matcher = URI_PATTERN.matcher(json);
        ArrayList<URI> result = new ArrayList<URI>();
        while (matcher.find()) {
            String s = matcher.group();
            String uri = s.substring(1, s.length() - 1);
            try {
                URI createdUri = URI.create(uri);
                result.add(createdUri);
            }
            catch (IllegalArgumentException e) {
                throw new SwiftOperationFailedException(String.format("could not convert \"%s\" into a URI. source: %s  first JSON: %s", uri, path, json.substring(0, 256)));
            }
        }
        return result;
    }

    public void throttle() throws InterruptedIOException {
        int throttleDelay = this.getThrottleDelay();
        if (throttleDelay > 0) {
            try {
                Thread.sleep(throttleDelay);
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException(e.toString()).initCause(e);
            }
        }
    }

    public List<DurationStats> getOperationStatistics() {
        return this.swiftRestClient.getOperationStatistics();
    }

    public boolean delete(Path absolutePath, boolean recursive) throws IOException {
        FileStatus[] statuses;
        Path swiftPath = this.getCorrectSwiftPath(absolutePath);
        SwiftUtils.debug(LOG, "Deleting path '%s' recursive=%b", absolutePath, recursive);
        boolean askForNewest = true;
        SwiftFileStatus fileStatus = this.getObjectMetadata(swiftPath, askForNewest);
        try {
            statuses = this.listSubPaths(absolutePath, true, askForNewest);
        }
        catch (IOException e) {
            statuses = new FileStatus[]{};
        }
        int filecount = statuses.length;
        SwiftUtils.debug(LOG, "Path '%s' %d status entries'", absolutePath, filecount);
        if (filecount == 0) {
            this.deleteObject(fileStatus);
            return true;
        }
        if (LOG.isDebugEnabled()) {
            SwiftUtils.debug(LOG, SwiftUtils.fileStatsToString(statuses, "\n"), new Object[0]);
        }
        if (filecount == 1 && swiftPath.equals((Object)statuses[0].getPath())) {
            SwiftUtils.debug(LOG, "Deleting simple file %s", absolutePath);
            this.deleteObject(fileStatus);
            return true;
        }
        if (!fileStatus.isDirectory()) {
            LOG.debug((Object)"Multiple child entries but entry has data: assume partitioned");
        } else if (!recursive) {
            throw new SwiftOperationFailedException("Directory " + (Object)((Object)fileStatus) + " is not empty: " + SwiftUtils.fileStatsToString(statuses, "; "));
        }
        for (FileStatus entryStatus : statuses) {
            Path entryPath = entryStatus.getPath();
            try {
                boolean deleted = this.deleteObject(entryStatus);
                if (!deleted) {
                    SwiftUtils.debug(LOG, "Failed to delete entry '%s'; continuing", entryPath);
                }
            }
            catch (FileNotFoundException e) {
                SwiftUtils.debug(LOG, "Path '%s' is no longer present; continuing", entryPath);
            }
            this.throttle();
        }
        SwiftUtils.debug(LOG, "Deleting base entry %s", absolutePath);
        this.deleteObject(fileStatus);
        return true;
    }

    public FileStatus[] listSegments(FileStatus file, boolean newest) throws IOException {
        SwiftObjectPath prefix = ((SwiftFileStatus)file).getDLOPrefix();
        if (prefix == null) {
            return new FileStatus[0];
        }
        List<FileStatus> objects = this.listDirectory(prefix, true, newest, false);
        ArrayList<FileStatus> segments = new ArrayList<FileStatus>(objects.size());
        for (FileStatus status : objects) {
            if (status.isDir()) continue;
            segments.add(status);
        }
        return segments.toArray(new FileStatus[segments.size()]);
    }
}

