/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.swift.auth;

import java.util.Map;
import org.apache.hadoop.fs.swift.auth.AuthenticationRequestV3;
import org.apache.hadoop.fs.swift.auth.PasswordCredentialsV3;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonWriteNullProperties;

@JsonWriteNullProperties(value=false)
public class PasswordAuthenticationRequestV3
extends AuthenticationRequestV3 {
    private final IdentityWrapper identity;
    private final ScopeWrapper scope;

    public PasswordAuthenticationRequestV3(ScopeWrapper scope, PasswordCredentialsV3 passwordCreds) {
        this.identity = new IdentityWrapper(new PasswordWrapper(passwordCreds));
        this.scope = scope;
    }

    public PasswordAuthenticationRequestV3(String projectName, PasswordCredentialsV3 passwordCreds) {
        this(projectName == null ? null : new ScopeWrapper(new ProjectWrapper(projectName, passwordCreds.domain)), passwordCreds);
    }

    public IdentityWrapper getIdentity() {
        return this.identity;
    }

    public ScopeWrapper getScope() {
        return this.scope;
    }

    @Override
    public String toString() {
        return "Authenticate(v3) as " + this.identity.getPassword().getUser();
    }

    public static class TrustWrapper {
        private final String id;

        public TrustWrapper(String trustId) {
            this.id = trustId;
        }

        public String getId() {
            return this.id;
        }
    }

    public static class ProjectWrapper {
        private final String name;
        private final Map<String, String> domain;

        public ProjectWrapper(String projectName, Map<String, String> domain) {
            this.domain = domain;
            this.name = projectName;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getDomain() {
            return this.domain;
        }
    }

    @JsonWriteNullProperties(value=false)
    public static class ScopeWrapper {
        private final ProjectWrapper project;
        private final TrustWrapper trust;

        public ScopeWrapper(ProjectWrapper project) {
            this.project = project;
            this.trust = null;
        }

        public ScopeWrapper(TrustWrapper trust) {
            this.project = null;
            this.trust = trust;
        }

        public ProjectWrapper getProject() {
            return this.project;
        }

        @JsonProperty(value="OS-TRUST:trust")
        public TrustWrapper getTrust() {
            return this.trust;
        }
    }

    public static class PasswordWrapper {
        private final PasswordCredentialsV3 user;

        public PasswordWrapper(PasswordCredentialsV3 user) {
            this.user = user;
        }

        public PasswordCredentialsV3 getUser() {
            return this.user;
        }
    }

    public static class IdentityWrapper {
        private final PasswordWrapper password;
        private final String[] methods;

        public IdentityWrapper(PasswordWrapper password) {
            this.password = password;
            this.methods = new String[]{"password"};
        }

        public PasswordWrapper getPassword() {
            return this.password;
        }

        public String[] getMethods() {
            return this.methods;
        }
    }
}

