# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['skyline_nginx', 'skyline_nginx.cmd', 'skyline_nginx.config']

package_data = \
{'': ['*'], 'skyline_nginx': ['templates/*']}

install_requires = \
['click==7.1.2',
 'jinja2==2.11.3',
 'keystoneauth1==3.17.4',
 'markupsafe==2.0.1',
 'pydantic==1.8.2',
 'python-keystoneclient==3.21.0',
 'skyline-apiserver',
 'skyline-config',
 'skyline-console',
 'skyline-log']

entry_points = \
{'console_scripts': ['nginx-generator = skyline_nginx.cmd.generate_nginx:main']}

setup_kwargs = {
    'name': 'skyline-nginx',
    'version': '0.1.0',
    'description': '',
    'long_description': None,
    'author': 'OpenStack',
    'author_email': 'openstack-discuss@lists.openstack.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
