# Copyright 2021 99cloud
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from __future__ import annotations

from skyline_apiserver.config.openstack import (
    default_region,
    interface_type,
    keystone_url,
    nginx_prefix,
    service_mapping,
    system_project,
    system_project_domain,
    system_user_domain,
    system_user_name,
    system_user_password,
)

GROUP_NAME = __name__.split(".")[-1]
ALL_OPTS = (
    default_region,
    keystone_url,
    system_project_domain,
    system_project,
    system_user_domain,
    system_user_name,
    system_user_password,
    interface_type,
    nginx_prefix,
    service_mapping,
)

__all__ = ("GROUP_NAME", "ALL_OPTS")
