<?php

/**
 * Returns the predefined administrative areas.
 *
 * @param $country_code
 *   The country code for which administrative areas should be returned.
 *
 * @return
 *   An array of predefined administrative areas for the given country code, or
 *   NULL if not found.
 */
function addressfield_get_administrative_areas($country_code) {
  $administrative_areas = array();
  $administrative_areas['AE'] = array(
    'AZ' => t('Abu Dhabi'),
    'FU' => t('Fujairah'),
    'UQ' => t('Umm al-Quwain'),
    'SH' => t('Sharjah'),
    'DU' => t('Dubai'),
    'RK' => t('Ras al-Khaimah'),
    'AJ' => t('Ajmān'),
  );
  $administrative_areas['AR'] = array(
    'B' => t('Buenos Aires'),
    'K' => t('Catamarca'),
    'H' => t('Chaco'),
    'U' => t('Chubut'),
    'C' => t('Ciudad de Buenos Aires'),
    'X' => t('Córdoba'),
    'W' => t('Corrientes'),
    'E' => t('Entre Ríos'),
    'P' => t('Formosa'),
    'Y' => t('Jujuy'),
    'L' => t('La Pampa'),
    'F' => t('La Rioja'),
    'M' => t('Mendoza'),
    'N' => t('Misiones'),
    'Q' => t('Neuquén'),
    'R' => t('Río Negro'),
    'A' => t('Salta'),
    'J' => t('San Juan'),
    'D' => t('San Luis'),
    'Z' => t('Santa Cruz'),
    'S' => t('Santa Fe'),
    'G' => t('Santiago del Estero'),
    'V' => t('Tierra del Fuego'),
    'T' => t('Tucumán'),
  );
  $administrative_areas['AU'] = array(
    'ACT' => t('Australian Capital Territory'),
    'NSW' => t('New South Wales'),
    'NT' => t('Northern Territory'),
    'QLD' => t('Queensland'),
    'SA' => t('South Australia'),
    'TAS' => t('Tasmania'),
    'VIC' => t('Victoria'),
    'WA' => t('Western Australia'),
  );
  $administrative_areas['BR'] = array(
    'AC' => t('Acre'),
    'AL' => t('Alagoas'),
    'AM' => t('Amazonas'),
    'AP' => t('Amapá'),
    'BA' => t('Bahia'),
    'CE' => t('Ceará'),
    'DF' => t('Distrito Federal'),
    'ES' => t('Espírito Santo'),
    'GO' => t('Goiás'),
    'MA' => t('Maranhão'),
    'MG' => t('Minas Gerais'),
    'MS' => t('Mato Grosso do Sul'),
    'MT' => t('Mato Grosso'),
    'PA' => t('Pará'),
    'PB' => t('Paraíba'),
    'PE' => t('Pernambuco'),
    'PI' => t('Piauí'),
    'PR' => t('Paraná'),
    'RJ' => t('Rio de Janeiro'),
    'RN' => t('Rio Grande do Norte'),
    'RO' => t('Rondônia'),
    'RR' => t('Roraima'),
    'RS' => t('Rio Grande do Sul'),
    'SC' => t('Santa Catarina'),
    'SE' => t('Sergipe'),
    'SP' => t('São Paulo'),
    'TO' => t('Tocantins'),
  );
  $administrative_areas['CA'] = array(
    'AB' => t('Alberta'),
    'BC' => t('British Columbia'),
    'MB' => t('Manitoba'),
    'NB' => t('New Brunswick'),
    'NL' => t('Newfoundland and Labrador'),
    'NT' => t('Northwest Territories'),
    'NS' => t('Nova Scotia'),
    'NU' => t('Nunavut'),
    'ON' => t('Ontario'),
    'PE' => t('Prince Edward Island'),
    'QC' => t('Quebec'),
    'SK' => t('Saskatchewan'),
    'YT' => t('Yukon Territory'),
  );
  $administrative_areas['CL'] = array(
    'AI' => t('Aysén del General Carlos Ibáñez del Campo'),
    'AN' => t('Antofagasta'),
    'AR' => t('Araucanía'),
    'AP' => t('Arica y Parinacota'),
    'AT' => t('Atacama'),
    'BI' => t('Biobío'),
    'CO' => t('Coquimbo'),
    'LI' => t('Libertador General Bernardo O\'Higgins'),
    'LL' => t('Los Lagos'),
    'LR' => t('Los Ríos'),
    'MA' => t('Magallanes y de la Antártica Chilena'),
    'ML' => t('Maule'),
    'RM' => t('Metropolitana de Santiago'),
    'TA' => t('Tarapacá'),
    'VS' => t('Valparaíso'),
  );
  $administrative_areas['CN'] = array(
    '34' => t('Anhui Sheng'),
    '92' => t('Macau'),
    '11' => t('Beijing Shi'),
    '50' => t('Chongqing Shi'),
    '35' => t('Fujian Sheng'),
    '62' => t('Gansu Sheng'),
    '44' => t('Guangdong Sheng'),
    '45' => t('Guangxi Zhuangzuzizhiqu'),
    '52' => t('Guizhou Sheng'),
    '46' => t('Hainan Sheng'),
    '13' => t('Hebei Sheng'),
    '41' => t('Henan Sheng'),
    '23' => t('Heilongjiang Sheng'),
    '42' => t('Hubei Sheng'),
    '43' => t('Hunan Sheng'),
    '22' => t('Jilin Sheng'),
    '32' => t('Jiangsu Sheng'),
    '36' => t('Jiangxi Sheng'),
    '21' => t('Liaoning Sheng'),
    '15' => t('Neimenggu Zizhiqu'),
    '64' => t('Ningxia Huizuzizhiqu'),
    '63' => t('Qinghai Sheng'),
    '37' => t('Shandong Sheng'),
    '14' => t('Shanxi Sheng'),
    '61' => t('Shaanxi Sheng'),
    '31' => t('Shanghai Shi'),
    '51' => t('Sichuan Sheng'),
    '71' => t('Taiwan'),
    '12' => t('Tianjin Shi'),
    '54' => t('Xizang Zizhiqu'),
    '91' => t('Hong Kong'),
    '65' => t('Xinjiang Weiwuerzizhiqu'),
    '53' => t('Yunnan Sheng'),
    '33' => t('Zhejiang Sheng'),
  );
  $administrative_areas['CO'] = array(
    'AMA' => t('Amazonas'),
    'ANT' => t('Antioquia'),
    'ARA' => t('Arauca'),
    'ATL' => t('Atlántico'),
    'BOL' => t('Bolívar'),
    'BOY' => t('Boyacá'),
    'CAL' => t('Caldas'),
    'CAQ' => t('Caquetá'),
    'CAS' => t('Casanare'),
    'CAU' => t('Cauca'),
    'CES' => t('Cesar'),
    'COR' => t('Córdoba'),
    'CUN' => t('Cundinamarca'),
    'CHO' => t('Chocó'),
    'GUA' => t('Guainía'),
    'GUV' => t('Guaviare'),
    'HUI' => t('Huila'),
    'LAG' => t('La Guajira'),
    'MAG' => t('Magdalena'),
    'MET' => t('Meta'),
    'NAR' => t('Nariño'),
    'NSA' => t('Norte de Santander'),
    'PUT' => t('Putumayo'),
    'QUI' => t('Quindío'),
    'RIS' => t('Risaralda'),
    'SAP' => t('San Andrés, Providencia y Santa Catalina'),
    'SAN' => t('Santander'),
    'SUC' => t('Sucre'),
    'TOL' => t('Tolima'),
    'VAC' => t('Valle del Cauca'),
    'VAU' => t('Vaupés'),
    'VID' => t('Vichada'),
  );
  $administrative_areas['EE'] = array(
    '37' => t('Harjumaa'),
    '39' => t('Hiiumaa'),
    '44' => t('Ida-Virumaa'),
    '49' => t('Jõgevamaa'),
    '51' => t('Järvamaa'),
    '57' => t('Läänemaa'),
    '59' => t('Lääne-Virumaa'),
    '65' => t('Põlvamaa'),
    '67' => t('Pärnumaa'),
    '70' => t('Raplamaa'),
    '74' => t('Saaremaa'),
    '78' => t('Tartumaa'),
    '82' => t('Valgamaa'),
    '84' => t('Viljandimaa'),
    '86' => t('Võrumaa'),
  );
  $administrative_areas['EG'] = array(
    'ALX' => t('Alexandria'),
    'ASN' => t('Aswan'),
    'AST' => t('Asyut'),
    'BH' => t('Beheira'),
    'BNS' => t('Beni Suef'),
    'C' => t('Cairo'),
    'DK' => t('Dakahlia'),
    'DT' => t('Damietta'),
    'FYM' => t('Faiyum'),
    'GH' => t('Gharbia'),
    'GZ' => t('Giza'),
    'IS' => t('Ismailia'),
    'KFS' => t('Kafr el-Sheikh'),
    'MT' => t('Matruh'),
    'MN' => t('Minya'),
    'MNF' => t('Monufia'),
    'WAD' => t('New Valley'),
    'SIN' => t('North Sinai'),
    'PTS' => t('Port Said'),
    'KB' => t('Qalyubia'),
    'KN' => t('Qena'),
    'BA' => t('Red Sea'),
    'SHR' => t('Sharqia'),
    'SHG' => t('Sohag'),
    'JS' => t('South Sinai'),
    'SUZ' => t('Suez'),
    'LX' => t('Luxor'),
  );
  $administrative_areas['ES'] = array(
    'C' => t("A Coruña"),
    'VI' => t('Alava'),
    'AB' => t('Albacete'),
    'A' => t('Alicante'),
    'AL' => t("Almería"),
    'O' => t('Asturias'),
    'AV' => t("Ávila"),
    'BA' => t('Badajoz'),
    'PM' => t('Baleares'),
    'B' => t('Barcelona'),
    'BU' => t('Burgos'),
    'CC' => t("Cáceres"),
    'CA' => t("Cádiz"),
    'S' => t('Cantabria'),
    'CS' => t("Castellón"),
    'CE' => t('Ceuta'),
    'CR' => t('Ciudad Real'),
    'CO' => t("Córdoba"),
    'CU' => t('Cuenca'),
    'GI' => t('Gerona'),
    'GR' => t('Granada'),
    'GU' => t('Guadalajara'),
    'SS' => t("Guipúzcoa"),
    'H' => t('Huelva'),
    'HU' => t('Huesca'),
    'J' => t("Jaén"),
    'LO' => t('La Rioja'),
    'GC' => t('Las Palmas'),
    'LE' => t("León"),
    'L' => t("Lérida"),
    'LU' => t('Lugo'),
    'M' => t('Madrid'),
    'MA' => t("Málaga"),
    'ML' => t('Melilla'),
    'MU' => t('Murcia'),
    'NA' => t('Navarra'),
    'OR' => t('Ourense'),
    'P' => t('Palencia'),
    'PO' => t('Pontevedra'),
    'SA' => t('Salamanca'),
    'TF' => t('Santa Cruz de Tenerife'),
    'SG' => t('Segovia'),
    'SE' => t('Sevilla'),
    'SO' => t('Soria'),
    'T' => t('Tarragona'),
    'TE' => t('Teruel'),
    'TO' => t('Toledo'),
    'V' => t('Valencia'),
    'VA' => t('Valladolid'),
    'BI' => t('Vizcaya'),
    'ZA' => t('Zamora'),
    'Z' => t('Zaragoza'),
  );
  $administrative_areas['HK'] = array(
    // HK subdivisions have no ISO codes assigned.
    'Kowloon' => t('Kowloon'),
    'Hong Kong Island' => t('Hong Kong Island'),
    'New Territories' => t('New Territories'),
  );
  $administrative_areas['ID'] = array(
    'AC' => t('Aceh'),
    'BA' => t('Bali'),
    'BB' => t('Bangka Belitung'),
    'BT' => t('Banten'),
    'BE' => t('Bengkulu'),
    'JK' => t('DKI Jakarta'),
    'YO' => t('D.I. Yogyakarta'),
    'GO' => t('Gorontalo'),
    'JA' => t('Jambi'),
    'JB' => t('Jawa Barat'),
    'JT' => t('Jawa Tengah'),
    'JI' => t('Jawa Timur'),
    'KB' => t('Kalimantan Barat'),
    'KS' => t('Kalimantan Selatan'),
    'KT' => t('Kalimantan Tengah'),
    'KI' => t('Kalimantan Timur'),
    'KR' => t('Kepulauan Riau'),
    'LA' => t('Lampung'),
    'MA' => t('Maluku'),
    'MU' => t('Maluku Utara'),
    'NB' => t('Nusa Tenggara Barat'),
    'NT' => t('Nusa Tenggara Timur'),
    'PA' => t('Papua'),
    'PB' => t('Papua Barat'),
    'RI' => t('Riau'),
    'SR' => t('Sulawesi Barat'),
    'SN' => t('Sulawesi Selatan'),
    'ST' => t('Sulawesi Tengah'),
    'SG' => t('Sulawesi Tenggara'),
    'SA' => t('Sulawesi Utara'),
    'SB' => t('Sumatera Barat'),
    'SS' => t('Sumatera Selatan'),
    'SU' => t('Sumatera Utara'),
  );
  $administrative_areas['IE'] = array(
    'CW' => t('Co Carlow'),
    'CN' => t('Co Cavan'),
    'CE' => t('Co Clare'),
    'CO' => t('Co Cork'),
    'DL' => t('Co Donegal'),
    'D' => t('Co Dublin'),
    'D1' => t('Dublin 1'),
    'D2' => t('Dublin 2'),
    'D3' => t('Dublin 3'),
    'D4' => t('Dublin 4'),
    'D5' => t('Dublin 5'),
    'D6' => t('Dublin 6'),
    'D6W' => t('Dublin 6w'),
    'D7' => t('Dublin 7'),
    'D8' => t('Dublin 8'),
    'D9' => t('Dublin 9'),
    'D10' => t('Dublin 10'),
    'D11' => t('Dublin 11'),
    'D12' => t('Dublin 12'),
    'D13' => t('Dublin 13'),
    'D14' => t('Dublin 14'),
    'D15' => t('Dublin 15'),
    'D16' => t('Dublin 16'),
    'D17' => t('Dublin 17'),
    'D18' => t('Dublin 18'),
    'D19' => t('Dublin 19'),
    'D20' => t('Dublin 20'),
    'D21' => t('Dublin 21'),
    'D22' => t('Dublin 22'),
    'D23' => t('Dublin 23'),
    'D24' => t('Dublin 24'),
    'G' => t('Co Galway'),
    'KY' => t('Co Kerry'),
    'KE' => t('Co Kildare'),
    'KK' => t('Co Kilkenny'),
    'LS' => t('Co Laois'),
    'LM' => t('Co Leitrim'),
    'LK' => t('Co Limerick'),
    'LD' => t('Co Longford'),
    'LH' => t('Co Louth'),
    'MO' => t('Co Mayo'),
    'MH' => t('Co Meath'),
    'MN' => t('Co Monaghan'),
    'OY' => t('Co Offaly'),
    'RN' => t('Co Roscommon'),
    'SO' => t('Co Sligo'),
    'TA' => t('Co Tipperary'),
    'WD' => t('Co Waterford'),
    'WH' => t('Co Westmeath'),
    'WX' => t('Co Wexford'),
    'WW' => t('Co Wicklow'),
  );
  $administrative_areas['IN'] = array(
    'AP' => t('Andhra Pradesh'),
    'AR' => t('Arunachal Pradesh'),
    'AS' => t('Assam'),
    'BR' => t('Bihar'),
    'CT' => t('Chhattisgarh'),
    'DD' => t('Daman & Diu'),
    'DN' => t('Dadra & Nagar Haveli'),
    'GA' => t('Goa'),
    'GJ' => t('Gujarat'),
    'HP' => t('Himachal Pradesh'),
    'HR' => t('Haryana'),
    'JH' => t('Jharkhand'),
    'JK' => t('Jammu & Kashmir'),
    'KA' => t('Karnataka'),
    'KL' => t('Kerala'),
    'MH' => t('Maharashtra'),
    'MN' => t('Manipur'),
    'ML' => t('Meghalaya'),
    'MP' => t('Madhya Pradesh'),
    'MZ' => t('Mizoram'),
    'NL' => t('Nagaland'),
    'OR' => t('Odisha'),
    'PB' => t('Punjab'),
    'RJ' => t('Rajasthan'),
    'SK' => t('Sikkim'),
    'TN' => t('Tamil Nadu'),
    'TG' => t('Telangana'),
    'TR' => t('Tripura'),
    'UP' => t('Uttar Pradesh'),
    'UT' => t('Uttarakhand'),
    'WB' => t('West Bengal'),
    ' ' => t('--'),
    'AN' => t('Andaman & Nicobar'),
    'CH' => t('Chandigarh'),
    'DN' => t('Dadra & Nagar Haveli'),
    'DD' => t('Daman & Diu'),
    'DL' => t('Delhi'),
    'LD' => t('Lakshadweep'),
    'PY' => t('Puducherry'),
  );
  $administrative_areas['IT'] = array(
    'AG' => t('Agrigento'),
    'AL' => t('Alessandria'),
    'AN' => t('Ancona'),
    'AO' => t('Aosta'),
    'AP' => t('Ascoli Piceno'),
    'AQ' => t("L'Aquila"),
    'AR' => t('Arezzo'),
    'AT' => t('Asti'),
    'AV' => t('Avellino'),
    'BA' => t('Bari'),
    'BG' => t('Bergamo'),
    'BI' => t('Biella'),
    'BL' => t('Belluno'),
    'BN' => t('Benevento'),
    'BO' => t('Bologna'),
    'BR' => t('Brindisi'),
    'BS' => t('Brescia'),
    'BT' => t('Barletta-Andria-Trani'),
    'BZ' => t('Bolzano/Bozen'),
    'CA' => t('Cagliari'),
    'CB' => t('Campobasso'),
    'CE' => t('Caserta'),
    'CH' => t('Chieti'),
    'CI' => t('Carbonia-Iglesias'),
    'CL' => t('Caltanissetta'),
    'CN' => t('Cuneo'),
    'CO' => t('Como'),
    'CR' => t('Cremona'),
    'CS' => t('Cosenza'),
    'CT' => t('Catania'),
    'CZ' => t('Catanzaro'),
    'EN' => t('Enna'),
    'FC' => t('Forlì-Cesena'),
    'FE' => t('Ferrara'),
    'FG' => t('Foggia'),
    'FI' => t('Firenze'),
    'FM' => t('Fermo'),
    'FR' => t('Frosinone'),
    'GE' => t('Genova'),
    'GO' => t('Gorizia'),
    'GR' => t('Grosseto'),
    'IM' => t('Imperia'),
    'IS' => t('Isernia'),
    'KR' => t('Crotone'),
    'LC' => t('Lecco'),
    'LE' => t('Lecce'),
    'LI' => t('Livorno'),
    'LO' => t('Lodi'),
    'LT' => t('Latina'),
    'LU' => t('Lucca'),
    'MB' => t('Monza e Brianza'),
    'MC' => t('Macerata'),
    'ME' => t('Messina'),
    'MI' => t('Milano'),
    'MN' => t('Mantova'),
    'MO' => t('Modena'),
    'MS' => t('Massa-Carrara'),
    'MT' => t('Matera'),
    'NA' => t('Napoli'),
    'NO' => t('Novara'),
    'NU' => t('Nuoro'),
    'OG' => t('Ogliastra'),
    'OR' => t('Oristano'),
    'OT' => t('Olbia-Tempio'),
    'PA' => t('Palermo'),
    'PC' => t('Piacenza'),
    'PD' => t('Padova'),
    'PE' => t('Pescara'),
    'PG' => t('Perugia'),
    'PI' => t('Pisa'),
    'PN' => t('Pordenone'),
    'PO' => t('Prato'),
    'PR' => t('Parma'),
    'PT' => t('Pistoia'),
    'PU' => t('Pesaro e Urbino'),
    'PV' => t('Pavia'),
    'PZ' => t('Potenza'),
    'RA' => t('Ravenna'),
    'RC' => t('Reggio Calabria'),
    'RE' => t('Reggio Emilia'),
    'RG' => t('Ragusa'),
    'RI' => t('Rieti'),
    'RM' => t('Roma'),
    'RN' => t('Rimini'),
    'RO' => t('Rovigo'),
    'SA' => t('Salerno'),
    'SI' => t('Siena'),
    'SO' => t('Sondrio'),
    'SP' => t('La Spezia'),
    'SR' => t('Siracusa'),
    'SS' => t('Sassari'),
    'SV' => t('Savona'),
    'TA' => t('Taranto'),
    'TE' => t('Teramo'),
    'TN' => t('Trento'),
    'TO' => t('Torino'),
    'TP' => t('Trapani'),
    'TR' => t('Terni'),
    'TS' => t('Trieste'),
    'TV' => t('Treviso'),
    'UD' => t('Udine'),
    'VA' => t('Varese'),
    'VB' => t('Verbano-Cusio-Ossola'),
    'VC' => t('Vercelli'),
    'VE' => t('Venezia'),
    'VI' => t('Vicenza'),
    'VR' => t('Verona'),
    'VS' => t('Medio Campidano'),
    'VT' => t('Viterbo'),
    'VV' => t('Vibo Valentia'),
  );
  $administrative_areas['JM'] = array(
    '13' => 'Clarendon',
    '09' => 'Hanover',
    '01' => 'Kingston',
    '12' => 'Manchester',
    '04' => 'Portland',
    '02' => 'St. Andrew',
    '06' => 'St. Ann',
    '14' => 'St. Catherine',
    '11' => 'St. Elizabeth',
    '08' => 'St. James',
    '05' => 'St. Mary',
    '03' => 'St. Thomas',
    '07' => 'Trelawny',
    '10' => 'Westmoreland',
  );
  $administrative_areas['JP'] = array(
    '01' => t('Hokkaido'),
    '02' => t('Aomori'),
    '03' => t('Iwate'),
    '04' => t('Miyagi'),
    '05' => t('Akita'),
    '06' => t('Yamagata'),
    '07' => t('Fukushima'),
    '08' => t('Ibaraki'),
    '09' => t('Tochigi'),
    '10' => t('Gunma'),
    '11' => t('Saitama'),
    '12' => t('Chiba'),
    '13' => t('Tokyo'),
    '14' => t('Kanagawa'),
    '15' => t('Niigata'),
    '16' => t('Toyama'),
    '17' => t('Ishikawa'),
    '18' => t('Fukui'),
    '19' => t('Yamanashi'),
    '20' => t('Nagano'),
    '21' => t('Gifu'),
    '22' => t('Shizuoka'),
    '23' => t('Aichi'),
    '24' => t('Mie'),
    '25' => t('Shiga'),
    '26' => t('Kyoto'),
    '27' => t('Osaka'),
    '28' => t('Hyogo'),
    '29' => t('Nara'),
    '30' => t('Wakayama'),
    '31' => t('Tottori'),
    '32' => t('Shimane'),
    '33' => t('Okayama'),
    '34' => t('Hiroshima'),
    '35' => t('Yamaguchi'),
    '36' => t('Tokushima'),
    '37' => t('Kagawa'),
    '38' => t('Ehime'),
    '39' => t('Kochi'),
    '40' => t('Fukuoka'),
    '41' => t('Saga'),
    '42' => t('Nagasaki'),
    '43' => t('Kumamoto'),
    '44' => t('Oita'),
    '45' => t('Miyazaki'),
    '46' => t('Kagoshima'),
    '47' => t('Okinawa'),
  );
  $administrative_areas['KR'] = array(
    '11' => t('Seoul'),
    '26' => t('Busan'),
    '27' => t('Daegu'),
    '30' => t('Daejeon'),
    '29' => t('Gwangju'),
    '28' => t('Incheon'),
    '31' => t('Ulsan'),
    '43' => t('Chungcheongbuk-do'),
    '44' => t('Chungcheongnam-do'),
    '42' => t('Gangwon-do'),
    '41' => t('Gyeonggi-do'),
    '47' => t('Gyeongsangbuk-do'),
    '48' => t('Gyeongsangnam-do'),
    '49' => t('Jeju-do'),
    '45' => t('Jeollabuk-do'),
    '46' => t('Jeollanam-do'),
    '50' => t('Sejong'),
  );
  $administrative_areas['KZ'] = array(
    'AST' => t('Astana'),
    'ALA' => t('Almaty'),
    'ALM' => t('Almaty region'),
    'AKM' => t('Aqmola region'),
    'AKT' => t('Aqtöbe region'),
    'ATY' => t('Atyraū region'),
    'ZAP' => t('Batys Qazaqstan region'),
    'MAN' => t('Mangghystaū region'),
    'YUZ' => t('Ongtüstik Qazaqstan region'),
    'PAV' => t('Pavlodar region'),
    'KAR' => t('Qaraghandy region'),
    'KUS' => t('Qostanay region'),
    'KZY' => t('Qyzylorda region'),
    'VOS' => t('Shyghys Qazaqstan region'),
    'SEV' => t('Soltüstik Qazaqstan region'),
    'ZHA' => t('Zhambyl region'),
  );
  $administrative_areas['MX'] = array(
    'AGU' => t('Aguascalientes'),
    'BCN' => t('Baja California'),
    'BCS' => t('Baja California Sur'),
    'CAM' => t('Campeche'),
    'COA' => t('Coahuila'),
    'COL' => t('Colima'),
    'CHP' => t('Chiapas'),
    'CHH' => t('Chihuahua'),
    'DIF' => t('Distrito Federal'),
    'DUG' => t('Durango'),
    'MEX' => t('Estado de México'),
    'GUA' => t('Guanajuato'),
    'GRO' => t('Guerrero'),
    'HID' => t('Hidalgo'),
    'JAL' => t('Jalisco'),
    'MIC' => t('Michoacán'),
    'MOR' => t('Morelos'),
    'NAY' => t('Nayarit'),
    'NLE' => t('Nuevo León'),
    'OAX' => t('Oaxaca'),
    'PUE' => t('Puebla'),
    'QUE' => t('Queretaro'),
    'ROO' => t('Quintana Roo'),
    'SLP' => t('San Luis Potosí'),
    'SIN' => t('Sinaloa'),
    'SON' => t('Sonora'),
    'TAB' => t('Tabasco'),
    'TAM' => t('Tamaulipas'),
    'TLA' => t('Tlaxcala'),
    'VER' => t('Veracruz'),
    'YUC' => t('Yucatán'),
    'ZAC' => t('Zacatecas'),
  );
  $administrative_areas['MY'] = array(
    '01' => t('Johor'),
    '02' => t('Kedah'),
    '03' => t('Kelantan'),
    '14' => t('Kuala Lumpur'),
    '15' => t('Labuan'),
    '04' => t('Melaka'),
    '05' => t('Negeri Sembilan'),
    '06' => t('Pahang'),
    '08' => t('Perak'),
    '09' => t('Perlis'),
    '07' => t('Pulau Pinang'),
    '16' => t('Putrajaya'),
    '12' => t('Sabah'),
    '13' => t('Sarawak'),
    '10' => t('Selangor'),
    '11' => t('Terengganu'),
    );
  $administrative_areas['PE'] = array(
    'AMA' => t('Amazonas'),
    'ANC' => t('Ancash'),
    'APU' => t('Apurimac'),
    'ARE' => t('Arequipa'),
    'AYA' => t('Ayacucho'),
    'CAJ' => t('Cajamarca'),
    'CAL' => t('Callao'),
    'CUS' => t('Cusco'),
    'HUV' => t('Huancavelica'),
    'HUC' => t('Huanuco'),
    'ICA' => t('Ica'),
    'JUN' => t('Junin'),
    'LAL' => t('La Libertad'),
    'LAM' => t('Lambayeque'),
    'LIM' => t('Lima'),
    'LOR' => t('Loreto'),
    'MDD' => t('Madre de Dios'),
    'MOQ' => t('Moquegua'),
    'PAS' => t('Pasco'),
    'PIU' => t('Piura'),
    'PUN' => t('Puno'),
    'SAM' => t('San Martin'),
    'TAC' => t('Tacna'),
    'TUM' => t('Tumbes'),
    'UCA' => t('Ucayali'),
  );
  $administrative_areas['RU'] = array(
    'MOW' => t('Moskva'),
    'SPE' => t('Sankt-Peterburg'),
    'AD' => t('Adygeya, Respublika'),
    'AL' => t('Altay, Respublika'),
    'BA' => t('Bashkortostan, Respublika'),
    'BU' => t('Buryatiya, Respublika'),
    'CE' => t('Chechenskaya Respublika'),
    'CU' => t('Chuvashskaya Respublika'),
    'DA' => t('Dagestan, Respublika'),
    'IN' => t('Ingushetiya, Respublika'),
    'KB' => t('Kabardino-Balkarskaya Respublika'),
    'KL' => t('Kalmykiya, Respublika'),
    'KC' => t('Karachayevo-Cherkesskaya Respublika'),
    'KR' => t('Kareliya, Respublika'),
    'KK' => t('Khakasiya, Respublika'),
    'KO' => t('Komi, Respublika'),
    'ME' => t('Mariy El, Respublika'),
    'MO' => t('Mordoviya, Respublika'),
    'SA' => t('Sakha, Respublika [Yakutiya]'),
    'SE' => t('Severnaya Osetiya-Alaniya, Respublika'),
    'TA' => t('Tatarstan, Respublika'),
    'TY' => t('Tyva, Respublika [Tuva]'),
    'UD' => t('Udmurtskaya Respublika'),
    'ALT' => t('Altayskiy kray'),
    'KAM' => t('Kamchatskiy kray'),
    'KHA' => t('Khabarovskiy kray'),
    'KDA' => t('Krasnodarskiy kray'),
    'KYA' => t('Krasnoyarskiy kray'),
    'PER' => t('Permskiy kray'),
    'PRI' => t('Primorskiy kray'),
    'STA' => t('Stavropolskiy kray'),
    'ZAB' => t('Zabaykalskiy kray'),
    'AMU' => t('Amurskaya oblast'),
    'ARK' => t('Arkhangelskaya oblast'),
    'AST' => t('Astrakhanskaya oblast'),
    'BEL' => t('Belgorodskaya oblast'),
    'BRY' => t('Bryanskaya oblast'),
    'CHE' => t('Chelyabinskaya oblast'),
    'IRK' => t('Irkutskaya oblast'),
    'IVA' => t('Ivanovskaya oblast'),
    'KGD' => t('Kaliningradskaya oblast'),
    'KLU' => t('Kaluzhskaya oblast'),
    'KEM' => t('Kemerovskaya oblast'),
    'KIR' => t('Kirovskaya oblast'),
    'KOS' => t('Kostromskaya oblast'),
    'KGN' => t('Kurganskaya oblast'),
    'KRS' => t('Kurskaya oblast'),
    'LEN' => t('Leningradskaya oblast'),
    'LIP' => t('Lipetskaya oblast'),
    'MAG' => t('Magadanskaya oblast'),
    'MOS' => t('Moskovskaya oblast'),
    'MUR' => t('Murmanskaya oblast'),
    'NIZ' => t('Nizhegorodskaya oblast'),
    'NGR' => t('Novgorodskaya oblast'),
    'NVS' => t('Novosibirskaya oblast'),
    'OMS' => t('Omskaya oblast'),
    'ORE' => t('Orenburgskaya oblast'),
    'ORL' => t('Orlovskaya oblast'),
    'PNZ' => t('Penzenskaya oblast'),
    'PSK' => t('Pskovskaya oblast'),
    'ROS' => t('Rostovskaya oblast'),
    'RYA' => t('Ryazanskaya oblast'),
    'SAK' => t('Sakhalinskaya oblast'),
    'SAM' => t('Samarskaya oblast'),
    'SAR' => t('Saratovskaya oblast'),
    'SMO' => t('Smolenskaya oblast'),
    'SVE' => t('Sverdlovskaya oblast'),
    'TAM' => t('Tambovskaya oblast'),
    'TOM' => t('Tomskaya oblast'),
    'TUL' => t('Tulskaya oblast'),
    'TVE' => t('Tverskaya oblast'),
    'TYU' => t('Tyumenskaya oblast'),
    'ULY' => t('Ulyanovskaya oblast'),
    'VLA' => t('Vladimirskaya oblast'),
    'VGG' => t('Volgogradskaya oblast'),
    'VLG' => t('Vologodskaya oblast'),
    'VOR' => t('Voronezhskaya oblast'),
    'YAR' => t('Yaroslavskaya oblast'),
    'YEV' => t('Yevreyskaya avtonomnaya oblast'),
    'CHU' => t('Chukotskiy avtonomnyy okrug'),
    'KHM' => t('Khanty-Mansiyskiy avtonomnyy okrug-Yugra'),
    'NEN' => t('Nenetskiy avtonomnyy okrug'),
    'YAN' => t('Yamalo-Nenetskiy avtonomnyy okrug'),
  );
  $administrative_areas['TR'] = array(
    '01' => t('Adana'),
    '02' => t('Adıyaman'),
    '03' => t('Afyon'),
    '04' => t('Ağrı'),
    '68' => t('Aksaray'),
    '05' => t('Amasya'),
    '06' => t('Ankara'),
    '07' => t('Antalya'),
    '75' => t('Ardahan'),
    '08' => t('Artvin'),
    '09' => t('Aydın'),
    '10' => t('Balıkesir'),
    '74' => t('Bartın'),
    '72' => t('Batman'),
    '69' => t('Bayburt'),
    '11' => t('Bilecik'),
    '12' => t('Bingöl'),
    '13' => t('Bitlis'),
    '14' => t('Bolu'),
    '15' => t('Burdur'),
    '16' => t('Bursa'),
    '17' => t('Çanakkale'),
    '18' => t('Çankırı'),
    '19' => t('Çorum'),
    '20' => t('Denizli'),
    '21' => t('Diyarbakır'),
    '81' => t('Düzce'),
    '22' => t('Edirne'),
    '23' => t('Elazığ'),
    '24' => t('Erzincan'),
    '25' => t('Erzurum'),
    '26' => t('Eskişehir'),
    '27' => t('Gaziantep'),
    '28' => t('Giresun'),
    '29' => t('Gümüşhane'),
    '30' => t('Hakkari'),
    '31' => t('Hatay'),
    '76' => t('Iğdır'),
    '32' => t('Isparta'),
    '34' => t('İstanbul'),
    '35' => t('İzmir'),
    '46' => t('Kahramanmaraş'),
    '78' => t('Karabük'),
    '70' => t('Karaman'),
    '36' => t('Kars'),
    '37' => t('Kastamonu'),
    '38' => t('Kayseri'),
    '71' => t('Kırıkkale'),
    '39' => t('Kırklareli'),
    '40' => t('Kırşehir'),
    '79' => t('Kilis'),
    '41' => t('Kocaeli'),
    '42' => t('Konya'),
    '43' => t('Kütahya'),
    '44' => t('Malatya'),
    '45' => t('Manisa'),
    '47' => t('Mardin'),
    '33' => t('Mersin'),
    '48' => t('Muğla'),
    '49' => t('Muş'),
    '50' => t('Nevşehir'),
    '51' => t('Niğde'),
    '52' => t('Ordu'),
    '80' => t('Osmaniye'),
    '53' => t('Rize'),
    '54' => t('Sakarya'),
    '55' => t('Samsun'),
    '56' => t('Siirt'),
    '57' => t('Sinop'),
    '58' => t('Sivas'),
    '63' => t('Şanlıurfa'),
    '73' => t('Şırnak'),
    '59' => t('Tekirdağ'),
    '60' => t('Tokat'),
    '61' => t('Trabzon'),
    '62' => t('Tunceli'),
    '64' => t('Uşak'),
    '65' => t('Van'),
    '77' => t('Yalova'),
    '66' => t('Yozgat'),
    '67' => t('Zonguldak'),
  );
  $administrative_areas['TW'] = array(
    'TXG' => t('Taichung City'),
    'TPE' => t('Taipei City'),
    'TTT' => t('Taitung County'),
    'TNN' => t('Tainan City'),
    'ILA' => t('Yilan County'),
    'HUA' => t('Hualien County'),
    'Kinmen County' => t('Kinmen County'),
    'NAN' => t('Nantou County'),
    'PIF' => t('Pingtung County'),
    'MIA' => t('Miaoli County'),
    'TAO' => t('Taoyuan County'),
    'KHH' => t('Kaohsiung City'),
    'KEE' => t('Keelung City'),
    'Lienchiang County' => t('Lienchiang County'),
    'YUN' => t('Yunlin County'),
    'TPQ' => t('New Taipei City'),
    'HSZ' => t('Hsinchu City'),
    'HSQ' => t('Hsinchu County'),
    'CYI' => t('Chiayi City'),
    'CYQ' => t('Chiayi County'),
    'CHA' => t('Changhua County'),
    'PEN' => t('Penghu County'),
  );
  $administrative_areas['UA'] = array(
    '43' => t('Crimea'),
    '05' => t('Vinnyts\'ka oblast'),
    '07' => t('Volyns\'ka oblast'),
    '12' => t('Dnipropetrovsk Oblast'),
    '14' => t('Donetsk Oblast'),
    '18' => t('Zhytomyrs\'ka oblast'),
    '21' => t('Zakarpats\'ka oblast'),
    '23' => t('Zaporiz\'ka oblast'),
    '26' => t('Ivano-Frankivs\'ka oblast'),
    '30' => t('Kyiv city'),
    '30' => t('Kiev Oblast'),
    '35' => t('Kirovohrads\'ka oblast'),
    '09' => t('Luhans\'ka oblast'),
    '46' => t('Lviv Oblast'),
    '48' => t('Mykolaivs\'ka oblast'),
    '51' => t('Odessa Oblast'),
    '53' => t('Poltavs\'ka oblast'),
    '56' => t('Rivnens\'ka oblast'),
    '40' => t('Sevastopol\' city'),
    '59' => t('Sums\'ka oblast'),
    '61' => t('Ternopil\'s\'ka oblast'),
    '63' => t('Kharkiv Oblast'),
    '65' => t('Khersons\'ka oblast'),
    '68' => t('Khmel\'nyts\'ka oblast'),
    '71' => t('Cherkas\'ka oblast'),
    '77' => t('Chernivets\'ka oblast'),
    '74' => t('Chernihivs\'ka oblast'),
  );
  $administrative_areas['US'] = array(
    'AL' => t('Alabama'),
    'AK' => t('Alaska'),
    'AZ' => t('Arizona'),
    'AR' => t('Arkansas'),
    'CA' => t('California'),
    'CO' => t('Colorado'),
    'CT' => t('Connecticut'),
    'DE' => t('Delaware'),
    'DC' => t('District of Columbia'),
    'FL' => t('Florida'),
    'GA' => t('Georgia'),
    'HI' => t('Hawaii'),
    'ID' => t('Idaho'),
    'IL' => t('Illinois'),
    'IN' => t('Indiana'),
    'IA' => t('Iowa'),
    'KS' => t('Kansas'),
    'KY' => t('Kentucky'),
    'LA' => t('Louisiana'),
    'ME' => t('Maine'),
    'MD' => t('Maryland'),
    'MA' => t('Massachusetts'),
    'MI' => t('Michigan'),
    'MN' => t('Minnesota'),
    'MS' => t('Mississippi'),
    'MO' => t('Missouri'),
    'MT' => t('Montana'),
    'NE' => t('Nebraska'),
    'NV' => t('Nevada'),
    'NH' => t('New Hampshire'),
    'NJ' => t('New Jersey'),
    'NM' => t('New Mexico'),
    'NY' => t('New York'),
    'NC' => t('North Carolina'),
    'ND' => t('North Dakota'),
    'OH' => t('Ohio'),
    'OK' => t('Oklahoma'),
    'OR' => t('Oregon'),
    'PA' => t('Pennsylvania'),
    'RI' => t('Rhode Island'),
    'SC' => t('South Carolina'),
    'SD' => t('South Dakota'),
    'TN' => t('Tennessee'),
    'TX' => t('Texas'),
    'UT' => t('Utah'),
    'VT' => t('Vermont'),
    'VA' => t('Virginia'),
    'WA' => t('Washington'),
    'WV' => t('West Virginia'),
    'WI' => t('Wisconsin'),
    'WY' => t('Wyoming'),
    ' ' => t('--'),
    'AA' => t('Armed Forces (Americas)'),
    'AE' => t('Armed Forces (Europe, Canada, Middle East, Africa)'),
    'AP' => t('Armed Forces (Pacific)'),
    'AS' => t('American Samoa'),
    'FM' => t('Federated States of Micronesia'),
    'GU' => t('Guam'),
    'MH' => t('Marshall Islands'),
    'MP' => t('Northern Mariana Islands'),
    'PW' => t('Palau'),
    'PR' => t('Puerto Rico'),
    'VI' => t('Virgin Islands'),
  );
  $administrative_areas['VE'] = array(
    'Z' => t('Amazonas'),
    'B' => t('Anzoátegui'),
    'C' => t('Apure'),
    'D' => t('Aragua'),
    'E' => t('Barinas'),
    'F' => t('Bolívar'),
    'G' => t('Carabobo'),
    'H' => t('Cojedes'),
    'Y' => t('Delta Amacuro'),
    'W' => t('Dependencias Federales'),
    'A' => t('Distrito Federal'),
    'I' => t('Falcón'),
    'J' => t('Guárico'),
    'K' => t('Lara'),
    'L' => t('Mérida'),
    'M' => t('Miranda'),
    'N' => t('Monagas'),
    'O' => t('Nueva Esparta'),
    'P' => t('Portuguesa'),
    'R' => t('Sucre'),
    'S' => t('Táchira'),
    'T' => t('Trujillo'),
    'X' => t('Vargas'),
    'U' => t('Yaracuy'),
    'V' => t('Zulia'),
  );

  // Allow other modules to alter the administrative areas.
  drupal_alter('addressfield_administrative_areas', $administrative_areas);

  return isset($administrative_areas[$country_code]) ? $administrative_areas[$country_code] : null;
}
