CREATE OR REPLACE PROCEDURE SP_SET_SERVER_TOKEN_TTL
(
P_TOKEN_TTL                    IN        NUMBER, -- IN SECOND
P_CONSUMER_KEY                 IN        VARCHAR2,
P_TOKEN                        IN        VARCHAR2,
P_RESULT                       OUT       NUMBER
)
AS

 -- PROCEDURE TO Set the ttl of a server access token.

BEGIN

  P_RESULT := 0;
  

UPDATE OAUTH_CONSUMER_TOKEN
SET OCT_TOKEN_TTL = SYSDATE + (P_TOKEN_TTL/(24*60*60)) -- DATE_ADD(NOW(), INTERVAL %D SECOND)
WHERE OCT_TOKEN = P_TOKEN
AND OCT_OCR_ID_REF IN (SELECT OCR_ID FROM OAUTH_CONSUMER_REGISTRY WHERE OCR_CONSUMER_KEY = P_CONSUMER_KEY);
              
  
EXCEPTION
WHEN OTHERS THEN
-- CALL THE FUNCTION TO LOG ERRORS
ROLLBACK;
P_RESULT := 1; -- ERROR
END;
/
