<?php

/**
 * @file
 * Filled installation of Drupal 7.0, for test purposes.
 *
 * This file was generated by the dump-database-d7.sh tool, from an
 * installation of Drupal 7, filled with data using the generate-d7-content.sh
 * tool. It has the following modules installed:
 *  - block
 *  - color
 *  - comment
 *  - contextual
 *  - dashboard
 *  - dblog
 *  - entity
 *  - field
 *  - field_sql_storage
 *  - field_ui
 *  - file
 *  - filter
 *  - help
 *  - image
 *  - list
 *  - menu
 *  - node
 *  - number
 *  - og
 *  - og_ui
 *  - options
 *  - overlay
 *  - path
 *  - rdf
 *  - search
 *  - shortcut
 *  - system
 *  - taxonomy
 *  - text
 *  - toolbar
 *  - update
 *  - user
 *  - devel
 *  - standard
 */

db_create_table('actions', array(
  'fields' => array(
    'aid' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '0',
    ),
    'type' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'callback' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'parameters' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'label' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'module' => 'system',
  'name' => 'actions',
));
db_insert('actions')->fields(array(
  'aid',
  'type',
  'callback',
  'parameters',
  'label',
))
->values(array(
  'aid' => 'comment_publish_action',
  'type' => 'comment',
  'callback' => 'comment_publish_action',
  'parameters' => '',
  'label' => 'Publish comment',
))
->values(array(
  'aid' => 'comment_save_action',
  'type' => 'comment',
  'callback' => 'comment_save_action',
  'parameters' => '',
  'label' => 'Save comment',
))
->values(array(
  'aid' => 'comment_unpublish_action',
  'type' => 'comment',
  'callback' => 'comment_unpublish_action',
  'parameters' => '',
  'label' => 'Unpublish comment',
))
->values(array(
  'aid' => 'node_make_sticky_action',
  'type' => 'node',
  'callback' => 'node_make_sticky_action',
  'parameters' => '',
  'label' => 'Make content sticky',
))
->values(array(
  'aid' => 'node_make_unsticky_action',
  'type' => 'node',
  'callback' => 'node_make_unsticky_action',
  'parameters' => '',
  'label' => 'Make content unsticky',
))
->values(array(
  'aid' => 'node_promote_action',
  'type' => 'node',
  'callback' => 'node_promote_action',
  'parameters' => '',
  'label' => 'Promote content to front page',
))
->values(array(
  'aid' => 'node_publish_action',
  'type' => 'node',
  'callback' => 'node_publish_action',
  'parameters' => '',
  'label' => 'Publish content',
))
->values(array(
  'aid' => 'node_save_action',
  'type' => 'node',
  'callback' => 'node_save_action',
  'parameters' => '',
  'label' => 'Save content',
))
->values(array(
  'aid' => 'node_unpromote_action',
  'type' => 'node',
  'callback' => 'node_unpromote_action',
  'parameters' => '',
  'label' => 'Remove content from front page',
))
->values(array(
  'aid' => 'node_unpublish_action',
  'type' => 'node',
  'callback' => 'node_unpublish_action',
  'parameters' => '',
  'label' => 'Unpublish content',
))
->values(array(
  'aid' => 'system_block_ip_action',
  'type' => 'user',
  'callback' => 'system_block_ip_action',
  'parameters' => '',
  'label' => 'Ban IP address of current user',
))
->values(array(
  'aid' => 'user_block_user_action',
  'type' => 'user',
  'callback' => 'user_block_user_action',
  'parameters' => '',
  'label' => 'Block current user',
))
->execute();

db_create_table('authmap', array(
  'fields' => array(
    'aid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'authname' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'module' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
  ),
  'unique keys' => array(
    'authname' => array(
      'authname',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'foreign keys' => array(
    'user' => array(
      'table' => 'users',
      'columns' => array(
        'uid' => 'uid',
      ),
    ),
  ),
  'module' => 'user',
  'name' => 'authmap',
));

db_create_table('batch', array(
  'fields' => array(
    'bid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'token' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
    ),
    'batch' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'indexes' => array(
    'token' => array(
      'token',
    ),
  ),
  'module' => 'system',
  'name' => 'batch',
));

db_create_table('block', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
    ),
    'module' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
    ),
    'delta' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '0',
    ),
    'theme' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'region' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
    ),
    'custom' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'visibility' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'pages' => array(
      'type' => 'text',
      'not null' => TRUE,
    ),
    'title' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
      'translatable' => TRUE,
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 1,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'unique keys' => array(
    'tmd' => array(
      'theme',
      'module',
      'delta',
    ),
  ),
  'indexes' => array(
    'list' => array(
      'theme',
      'status',
      'region',
      'weight',
      'module',
    ),
  ),
  'module' => 'block',
  'name' => 'block',
));
db_insert('block')->fields(array(
  'bid',
  'module',
  'delta',
  'theme',
  'status',
  'weight',
  'region',
  'custom',
  'visibility',
  'pages',
  'title',
  'cache',
))
->values(array(
  'bid' => '1',
  'module' => 'system',
  'delta' => 'main',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'content',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '2',
  'module' => 'search',
  'delta' => 'form',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '-1',
  'region' => 'sidebar_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '3',
  'module' => 'node',
  'delta' => 'recent',
  'theme' => 'seven',
  'status' => '1',
  'weight' => '10',
  'region' => 'dashboard_main',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '4',
  'module' => 'user',
  'delta' => 'login',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'sidebar_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '5',
  'module' => 'system',
  'delta' => 'navigation',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'sidebar_first',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '6',
  'module' => 'system',
  'delta' => 'powered-by',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '10',
  'region' => 'footer',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '7',
  'module' => 'system',
  'delta' => 'help',
  'theme' => 'bartik',
  'status' => '1',
  'weight' => '0',
  'region' => 'help',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '8',
  'module' => 'system',
  'delta' => 'main',
  'theme' => 'seven',
  'status' => '1',
  'weight' => '0',
  'region' => 'content',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '9',
  'module' => 'system',
  'delta' => 'help',
  'theme' => 'seven',
  'status' => '1',
  'weight' => '0',
  'region' => 'help',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '10',
  'module' => 'user',
  'delta' => 'login',
  'theme' => 'seven',
  'status' => '1',
  'weight' => '10',
  'region' => 'content',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '11',
  'module' => 'user',
  'delta' => 'new',
  'theme' => 'seven',
  'status' => '1',
  'weight' => '0',
  'region' => 'dashboard_sidebar',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '12',
  'module' => 'search',
  'delta' => 'form',
  'theme' => 'seven',
  'status' => '1',
  'weight' => '-10',
  'region' => 'dashboard_sidebar',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '13',
  'module' => 'comment',
  'delta' => 'recent',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '14',
  'module' => 'node',
  'delta' => 'syndicate',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '15',
  'module' => 'node',
  'delta' => 'recent',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '16',
  'module' => 'shortcut',
  'delta' => 'shortcuts',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '17',
  'module' => 'system',
  'delta' => 'management',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '18',
  'module' => 'system',
  'delta' => 'user-menu',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '19',
  'module' => 'system',
  'delta' => 'main-menu',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '20',
  'module' => 'user',
  'delta' => 'new',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '21',
  'module' => 'user',
  'delta' => 'online',
  'theme' => 'bartik',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '22',
  'module' => 'comment',
  'delta' => 'recent',
  'theme' => 'seven',
  'status' => '1',
  'weight' => '0',
  'region' => 'dashboard_inactive',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '23',
  'module' => 'node',
  'delta' => 'syndicate',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '24',
  'module' => 'shortcut',
  'delta' => 'shortcuts',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '25',
  'module' => 'system',
  'delta' => 'powered-by',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '10',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '26',
  'module' => 'system',
  'delta' => 'navigation',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '27',
  'module' => 'system',
  'delta' => 'management',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '28',
  'module' => 'system',
  'delta' => 'user-menu',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '29',
  'module' => 'system',
  'delta' => 'main-menu',
  'theme' => 'seven',
  'status' => '0',
  'weight' => '0',
  'region' => '-1',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '30',
  'module' => 'user',
  'delta' => 'online',
  'theme' => 'seven',
  'status' => '1',
  'weight' => '0',
  'region' => 'dashboard_inactive',
  'custom' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->execute();

db_create_table('block_custom', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'body' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
      'translatable' => TRUE,
    ),
    'info' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'format' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => FALSE,
    ),
  ),
  'unique keys' => array(
    'info' => array(
      'info',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'module' => 'block',
  'name' => 'block_custom',
));

db_create_table('block_node_type', array(
  'fields' => array(
    'module' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
    ),
    'delta' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
    ),
  ),
  'primary key' => array(
    'module',
    'delta',
    'type',
  ),
  'indexes' => array(
    'type' => array(
      'type',
    ),
  ),
  'module' => 'node',
  'name' => 'block_node_type',
));

db_create_table('block_role', array(
  'fields' => array(
    'module' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
    ),
    'delta' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
    ),
    'rid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
  ),
  'primary key' => array(
    'module',
    'delta',
    'rid',
  ),
  'indexes' => array(
    'rid' => array(
      'rid',
    ),
  ),
  'module' => 'block',
  'name' => 'block_role',
));

db_create_table('blocked_ips', array(
  'fields' => array(
    'iid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'ip' => array(
      'type' => 'varchar',
      'length' => 40,
      'not null' => TRUE,
      'default' => '',
    ),
  ),
  'indexes' => array(
    'blocked_ip' => array(
      'ip',
    ),
  ),
  'primary key' => array(
    'iid',
  ),
  'module' => 'system',
  'name' => 'blocked_ips',
));

db_create_table('cache', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'serialized' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'module' => 'system',
  'name' => 'cache',
));

db_create_table('cache_block', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'serialized' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'module' => 'block',
  'name' => 'cache_block',
));

db_create_table('cache_bootstrap', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'serialized' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'module' => 'system',
  'name' => 'cache_bootstrap',
));

db_create_table('cache_field', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'serialized' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'module' => 'field',
  'name' => 'cache_field',
));

db_create_table('cache_filter', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'serialized' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'module' => 'filter',
  'name' => 'cache_filter',
));

db_create_table('cache_form', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'serialized' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'module' => 'system',
  'name' => 'cache_form',
));

db_create_table('cache_image', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'serialized' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'module' => 'image',
  'name' => 'cache_image',
));

db_create_table('cache_menu', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'serialized' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'module' => 'system',
  'name' => 'cache_menu',
));

db_create_table('cache_page', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'serialized' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'module' => 'system',
  'name' => 'cache_page',
));

db_create_table('cache_path', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'serialized' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'module' => 'system',
  'name' => 'cache_path',
));

db_create_table('cache_update', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'serialized' => array(
      'type' => 'int',
      'size' => 'small',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'expire' => array(
      'expire',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'module' => 'update',
  'name' => 'cache_update',
));

db_create_table('comment', array(
  'fields' => array(
    'cid' => array(
      'type' => 'serial',
      'not null' => TRUE,
    ),
    'pid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'subject' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'status' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 1,
      'size' => 'tiny',
    ),
    'thread' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 60,
      'not null' => FALSE,
    ),
    'mail' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => FALSE,
    ),
    'homepage' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => FALSE,
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 12,
      'not null' => TRUE,
      'default' => '',
    ),
  ),
  'indexes' => array(
    'comment_status_pid' => array(
      'pid',
      'status',
    ),
    'comment_num_new' => array(
      'nid',
      'status',
      'created',
      'cid',
      'thread',
    ),
    'comment_uid' => array(
      'uid',
    ),
    'comment_nid_language' => array(
      'nid',
      'language',
    ),
    'comment_created' => array(
      'created',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'foreign keys' => array(
    'comment_node' => array(
      'table' => 'node',
      'columns' => array(
        'nid' => 'nid',
      ),
    ),
    'comment_author' => array(
      'table' => 'users',
      'columns' => array(
        'uid' => 'uid',
      ),
    ),
  ),
  'module' => 'comment',
  'name' => 'comment',
));

db_create_table('date_format_locale', array(
  'fields' => array(
    'format' => array(
      'type' => 'varchar',
      'length' => 100,
      'not null' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 12,
      'not null' => TRUE,
    ),
  ),
  'primary key' => array(
    'type',
    'language',
  ),
  'module' => 'system',
  'name' => 'date_format_locale',
));

db_create_table('date_format_type', array(
  'fields' => array(
    'type' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
    ),
    'title' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
    ),
    'locked' => array(
      'type' => 'int',
      'size' => 'tiny',
      'default' => 0,
      'not null' => TRUE,
    ),
  ),
  'primary key' => array(
    'type',
  ),
  'indexes' => array(
    'title' => array(
      'title',
    ),
  ),
  'module' => 'system',
  'name' => 'date_format_type',
));
db_insert('date_format_type')->fields(array(
  'type',
  'title',
  'locked',
))
->values(array(
  'type' => 'long',
  'title' => 'Long',
  'locked' => '1',
))
->values(array(
  'type' => 'medium',
  'title' => 'Medium',
  'locked' => '1',
))
->values(array(
  'type' => 'short',
  'title' => 'Short',
  'locked' => '1',
))
->execute();

db_create_table('date_formats', array(
  'fields' => array(
    'dfid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'unsigned' => TRUE,
    ),
    'format' => array(
      'type' => 'varchar',
      'length' => 100,
      'not null' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
    ),
    'locked' => array(
      'type' => 'int',
      'size' => 'tiny',
      'default' => 0,
      'not null' => TRUE,
    ),
  ),
  'primary key' => array(
    'dfid',
  ),
  'unique keys' => array(
    'formats' => array(
      'format',
      'type',
    ),
  ),
  'module' => 'system',
  'name' => 'date_formats',
));
db_insert('date_formats')->fields(array(
  'dfid',
  'format',
  'type',
  'locked',
))
->values(array(
  'dfid' => '1',
  'format' => 'Y-m-d H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '2',
  'format' => 'm/d/Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '3',
  'format' => 'd/m/Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '4',
  'format' => 'Y/m/d - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '5',
  'format' => 'd.m.Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '6',
  'format' => 'm/d/Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '7',
  'format' => 'd/m/Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '8',
  'format' => 'Y/m/d - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '9',
  'format' => 'M j Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '10',
  'format' => 'j M Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '11',
  'format' => 'Y M j - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '12',
  'format' => 'M j Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '13',
  'format' => 'j M Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '14',
  'format' => 'Y M j - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '15',
  'format' => 'D, Y-m-d H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '16',
  'format' => 'D, m/d/Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '17',
  'format' => 'D, d/m/Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '18',
  'format' => 'D, Y/m/d - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '19',
  'format' => 'F j, Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '20',
  'format' => 'j F, Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '21',
  'format' => 'Y, F j - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '22',
  'format' => 'D, m/d/Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '23',
  'format' => 'D, d/m/Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '24',
  'format' => 'D, Y/m/d - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '25',
  'format' => 'F j, Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '26',
  'format' => 'j F Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '27',
  'format' => 'Y, F j - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '28',
  'format' => 'j. F Y - G:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '29',
  'format' => 'l, F j, Y - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '30',
  'format' => 'l, j F, Y - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '31',
  'format' => 'l, Y,  F j - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '32',
  'format' => 'l, F j, Y - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '33',
  'format' => 'l, j F Y - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '34',
  'format' => 'l, Y,  F j - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '35',
  'format' => 'l, j. F Y - G:i',
  'type' => 'long',
  'locked' => '1',
))
->execute();

db_create_table('field_config', array(
  'fields' => array(
    'id' => array(
      'type' => 'serial',
      'not null' => TRUE,
    ),
    'field_name' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
    ),
    'module' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'active' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'storage_type' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
    ),
    'storage_module' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'storage_active' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'locked' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'data' => array(
      'type' => 'blob',
      'size' => 'big',
      'not null' => TRUE,
      'serialize' => TRUE,
    ),
    'cardinality' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'translatable' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'deleted' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'id',
  ),
  'indexes' => array(
    'field_name' => array(
      'field_name',
    ),
    'active' => array(
      'active',
    ),
    'storage_active' => array(
      'storage_active',
    ),
    'deleted' => array(
      'deleted',
    ),
    'module' => array(
      'module',
    ),
    'storage_module' => array(
      'storage_module',
    ),
    'type' => array(
      'type',
    ),
    'storage_type' => array(
      'storage_type',
    ),
  ),
  'module' => 'field',
  'name' => 'field_config',
));
db_insert('field_config')->fields(array(
  'id',
  'field_name',
  'type',
  'module',
  'active',
  'storage_type',
  'storage_module',
  'storage_active',
  'locked',
  'data',
  'cardinality',
  'translatable',
  'deleted',
))
->values(array(
  'id' => '1',
  'field_name' => 'comment_body',
  'type' => 'text_long',
  'module' => 'text',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:12:"entity_types";a:1:{i:0;s:7:"comment";}s:12:"translatable";b:0;s:8:"settings";a:0:{}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"foreign keys";a:1:{s:6:"format";a:2:{s:5:"table";s:13:"filter_format";s:7:"columns";a:1:{s:6:"format";s:6:"format";}}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '2',
  'field_name' => 'body',
  'type' => 'text_with_summary',
  'module' => 'text',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:12:"entity_types";a:1:{i:0;s:4:"node";}s:12:"translatable";b:0;s:8:"settings";a:0:{}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"foreign keys";a:1:{s:6:"format";a:2:{s:5:"table";s:13:"filter_format";s:7:"columns";a:1:{s:6:"format";s:6:"format";}}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '3',
  'field_name' => 'field_tags',
  'type' => 'taxonomy_term_reference',
  'module' => 'taxonomy',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:8:"settings";a:1:{s:14:"allowed_values";a:1:{i:0;a:2:{s:10:"vocabulary";s:4:"tags";s:6:"parent";i:0;}}}s:12:"entity_types";a:0:{}s:12:"translatable";b:0;s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"foreign keys";a:1:{s:3:"tid";a:2:{s:5:"table";s:18:"taxonomy_term_data";s:7:"columns";a:1:{s:3:"tid";s:3:"tid";}}}s:7:"indexes";a:1:{s:3:"tid";a:1:{i:0;s:3:"tid";}}}',
  'cardinality' => '-1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '4',
  'field_name' => 'field_image',
  'type' => 'image',
  'module' => 'image',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:7:"indexes";a:1:{s:3:"fid";a:1:{i:0;s:3:"fid";}}s:8:"settings";a:2:{s:10:"uri_scheme";s:6:"public";s:13:"default_image";b:0;}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"entity_types";a:0:{}s:12:"translatable";b:0;s:12:"foreign keys";a:1:{s:3:"fid";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:3:"fid";s:3:"fid";}}}}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '5',
  'field_name' => 'group_audience',
  'type' => 'group',
  'module' => 'og',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:5:"no_ui";b:1;s:12:"entity_types";a:0:{}s:12:"translatable";b:0;s:8:"settings";a:0:{}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"foreign keys";a:1:{s:2:"og";a:2:{s:5:"table";s:2:"og";s:7:"columns";a:1:{s:3:"gid";s:3:"gid";}}}s:7:"indexes";a:1:{s:3:"gid";a:1:{i:0;s:3:"gid";}}}',
  'cardinality' => '-1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '6',
  'field_name' => 'og_membership_request',
  'type' => 'text_long',
  'module' => 'text',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:6:{s:12:"entity_types";a:1:{i:0;s:13:"og_membership";}s:12:"translatable";b:0;s:8:"settings";a:0:{}s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"foreign keys";a:1:{s:6:"format";a:2:{s:5:"table";s:13:"filter_format";s:7:"columns";a:1:{s:6:"format";s:6:"format";}}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '7',
  'field_name' => 'group_group',
  'type' => 'list_boolean',
  'module' => 'list',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:5:"no_ui";b:1;s:8:"settings";a:2:{s:14:"allowed_values";a:2:{i:0;s:11:"Not a group";i:1;s:5:"Group";}s:23:"allowed_values_function";s:0:"";}s:12:"entity_types";a:0:{}s:12:"translatable";b:0;s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"foreign keys";a:0:{}s:7:"indexes";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->values(array(
  'id' => '8',
  'field_name' => 'og_roles_permissions',
  'type' => 'list_boolean',
  'module' => 'list',
  'active' => '1',
  'storage_type' => 'field_sql_storage',
  'storage_module' => 'field_sql_storage',
  'storage_active' => '1',
  'locked' => '0',
  'data' => 'a:7:{s:5:"no_ui";b:1;s:8:"settings";a:2:{s:14:"allowed_values";a:2:{i:0;s:33:"Use default roles and permissions";i:1;s:38:"Override default roles and permissions";}s:23:"allowed_values_function";s:0:"";}s:12:"entity_types";a:0:{}s:12:"translatable";b:0;s:7:"storage";a:4:{s:4:"type";s:17:"field_sql_storage";s:8:"settings";a:0:{}s:6:"module";s:17:"field_sql_storage";s:6:"active";i:1;}s:12:"foreign keys";a:0:{}s:7:"indexes";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}}',
  'cardinality' => '1',
  'translatable' => '0',
  'deleted' => '0',
))
->execute();

db_create_table('field_config_instance', array(
  'fields' => array(
    'id' => array(
      'type' => 'serial',
      'not null' => TRUE,
    ),
    'field_id' => array(
      'type' => 'int',
      'not null' => TRUE,
    ),
    'field_name' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'entity_type' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'size' => 'big',
      'not null' => TRUE,
      'serialize' => TRUE,
    ),
    'deleted' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'id',
  ),
  'indexes' => array(
    'field_name_bundle' => array(
      'field_name',
      'entity_type',
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
  ),
  'module' => 'field',
  'name' => 'field_config_instance',
));
db_insert('field_config_instance')->fields(array(
  'id',
  'field_id',
  'field_name',
  'entity_type',
  'bundle',
  'data',
  'deleted',
))
->values(array(
  'id' => '1',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_page',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '2',
  'field_id' => '2',
  'field_name' => 'body',
  'entity_type' => 'node',
  'bundle' => 'page',
  'data' => 'a:6:{s:5:"label";s:4:"Body";s:6:"widget";a:4:{s:4:"type";s:26:"text_textarea_with_summary";s:8:"settings";a:2:{s:4:"rows";i:20;s:12:"summary_rows";i:5;}s:6:"weight";i:-4;s:6:"module";s:4:"text";}s:8:"settings";a:3:{s:15:"display_summary";b:1;s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:0;}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:0;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '3',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_article',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '4',
  'field_id' => '2',
  'field_name' => 'body',
  'entity_type' => 'node',
  'bundle' => 'article',
  'data' => 'a:6:{s:5:"label";s:4:"Body";s:6:"widget";a:4:{s:4:"type";s:26:"text_textarea_with_summary";s:8:"settings";a:2:{s:4:"rows";i:20;s:12:"summary_rows";i:5;}s:6:"weight";i:-4;s:6:"module";s:4:"text";}s:8:"settings";a:3:{s:15:"display_summary";b:1;s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:0;}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:0;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '5',
  'field_id' => '3',
  'field_name' => 'field_tags',
  'entity_type' => 'node',
  'bundle' => 'article',
  'data' => 'a:6:{s:5:"label";s:4:"Tags";s:11:"description";s:63:"Enter a comma-separated list of words to describe your content.";s:6:"widget";a:4:{s:4:"type";s:21:"taxonomy_autocomplete";s:6:"weight";i:-4;s:8:"settings";a:2:{s:4:"size";i:60;s:17:"autocomplete_path";s:21:"taxonomy/autocomplete";}s:6:"module";s:8:"taxonomy";}s:7:"display";a:2:{s:7:"default";a:5:{s:4:"type";s:28:"taxonomy_term_reference_link";s:6:"weight";i:10;s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:6:"module";s:8:"taxonomy";}s:6:"teaser";a:5:{s:4:"type";s:28:"taxonomy_term_reference_link";s:6:"weight";i:10;s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:6:"module";s:8:"taxonomy";}}s:8:"settings";a:1:{s:18:"user_register_form";b:0;}s:8:"required";b:0;}',
  'deleted' => '0',
))
->values(array(
  'id' => '6',
  'field_id' => '4',
  'field_name' => 'field_image',
  'entity_type' => 'node',
  'bundle' => 'article',
  'data' => 'a:6:{s:5:"label";s:5:"Image";s:11:"description";s:40:"Upload an image to go with this article.";s:8:"required";b:0;s:8:"settings";a:9:{s:14:"file_directory";s:11:"field/image";s:15:"file_extensions";s:16:"png gif jpg jpeg";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";b:1;s:11:"title_field";s:0:"";s:13:"default_image";i:0;s:18:"user_register_form";b:0;}s:6:"widget";a:4:{s:4:"type";s:11:"image_image";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:6:"weight";i:-1;s:6:"module";s:5:"image";}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:5:"image";s:8:"settings";a:2:{s:11:"image_style";s:5:"large";s:10:"image_link";s:0:"";}s:6:"weight";i:-1;s:6:"module";s:5:"image";}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:5:"image";s:8:"settings";a:2:{s:11:"image_style";s:6:"medium";s:10:"image_link";s:7:"content";}s:6:"weight";i:-1;s:6:"module";s:5:"image";}}}',
  'deleted' => '0',
))
->values(array(
  'id' => '7',
  'field_id' => '5',
  'field_name' => 'group_audience',
  'entity_type' => 'user',
  'bundle' => 'user',
  'data' => 'a:9:{s:5:"label";s:15:"Groups audience";s:11:"widget_type";s:14:"group_audience";s:22:"default_value_function";s:31:"og_field_audience_default_value";s:10:"view modes";a:2:{s:4:"full";a:3:{s:5:"label";s:4:"Full";s:4:"type";s:15:"og_list_default";s:15:"custom settings";b:0;}s:6:"teaser";a:3:{s:5:"label";s:6:"Teaser";s:4:"type";s:15:"og_list_default";s:15:"custom settings";b:0;}}s:8:"settings";a:1:{s:18:"user_register_form";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:15:"og_list_default";s:8:"settings";a:0:{}s:6:"module";s:2:"og";s:6:"weight";i:0;}}s:6:"widget";a:4:{s:4:"type";s:14:"group_audience";s:8:"settings";a:1:{s:9:"opt_group";s:4:"auto";}s:6:"weight";i:7;s:6:"module";s:2:"og";}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '8',
  'field_id' => '6',
  'field_name' => 'og_membership_request',
  'entity_type' => 'og_membership',
  'bundle' => 'og_membership_type_default',
  'data' => 'a:6:{s:5:"label";s:15:"Request message";s:11:"description";s:61:"This is the text a user may send to the group administrators.";s:8:"required";b:0;s:8:"settings";a:2:{s:15:"text_processing";i:0;s:18:"user_register_form";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:0;}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}}',
  'deleted' => '0',
))
->values(array(
  'id' => '9',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_school',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '10',
  'field_id' => '7',
  'field_name' => 'group_group',
  'entity_type' => 'node',
  'bundle' => 'school',
  'data' => 'a:9:{s:5:"label";s:5:"Group";s:11:"description";s:33:"Determine if this is an OG group.";s:13:"display_label";i:1;s:6:"widget";a:4:{s:6:"module";s:7:"options";s:8:"settings";a:1:{s:13:"display_label";i:0;}s:4:"type";s:13:"options_onoff";s:6:"weight";i:0;}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:1;}}s:10:"view modes";a:2:{s:4:"full";a:3:{s:5:"label";s:4:"Full";s:4:"type";s:18:"og_group_subscribe";s:15:"custom settings";b:0;}s:6:"teaser";a:3:{s:5:"label";s:6:"Teaser";s:4:"type";s:18:"og_group_subscribe";s:15:"custom settings";b:0;}}s:7:"display";a:1:{s:7:"default";a:5:{s:4:"type";s:18:"og_group_subscribe";s:5:"label";s:5:"above";s:8:"settings";a:0:{}s:6:"module";s:5:"og_ui";s:6:"weight";i:0;}}s:8:"settings";a:1:{s:18:"user_register_form";b:0;}s:8:"required";b:0;}',
  'deleted' => '0',
))
->values(array(
  'id' => '11',
  'field_id' => '2',
  'field_name' => 'body',
  'entity_type' => 'node',
  'bundle' => 'school',
  'data' => 'a:6:{s:5:"label";s:4:"Body";s:6:"widget";a:4:{s:4:"type";s:26:"text_textarea_with_summary";s:8:"settings";a:2:{s:4:"rows";i:20;s:12:"summary_rows";i:5;}s:6:"weight";i:1;s:6:"module";s:4:"text";}s:8:"settings";a:3:{s:15:"display_summary";b:1;s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:1;}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:1;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '12',
  'field_id' => '1',
  'field_name' => 'comment_body',
  'entity_type' => 'comment',
  'bundle' => 'comment_node_class',
  'data' => 'a:6:{s:5:"label";s:7:"Comment";s:8:"settings";a:2:{s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:8:"required";b:1;s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:8:"settings";a:0:{}s:6:"module";s:4:"text";}}s:6:"widget";a:4:{s:4:"type";s:13:"text_textarea";s:8:"settings";a:1:{s:4:"rows";i:5;}s:6:"weight";i:0;s:6:"module";s:4:"text";}s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '13',
  'field_id' => '5',
  'field_name' => 'group_audience',
  'entity_type' => 'node',
  'bundle' => 'class',
  'data' => 'a:9:{s:5:"label";s:15:"Groups audience";s:11:"widget_type";s:14:"group_audience";s:22:"default_value_function";s:31:"og_field_audience_default_value";s:10:"view modes";a:2:{s:4:"full";a:3:{s:5:"label";s:4:"Full";s:4:"type";s:15:"og_list_default";s:15:"custom settings";b:0;}s:6:"teaser";a:3:{s:5:"label";s:6:"Teaser";s:4:"type";s:15:"og_list_default";s:15:"custom settings";b:0;}}s:8:"settings";a:1:{s:18:"user_register_form";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:15:"og_list_default";s:8:"settings";a:0:{}s:6:"module";s:2:"og";s:6:"weight";i:0;}}s:6:"widget";a:4:{s:4:"type";s:14:"group_audience";s:8:"settings";a:1:{s:9:"opt_group";s:4:"auto";}s:6:"weight";i:0;s:6:"module";s:2:"og";}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '14',
  'field_id' => '2',
  'field_name' => 'body',
  'entity_type' => 'node',
  'bundle' => 'class',
  'data' => 'a:6:{s:5:"label";s:4:"Body";s:6:"widget";a:4:{s:4:"type";s:26:"text_textarea_with_summary";s:8:"settings";a:2:{s:4:"rows";i:20;s:12:"summary_rows";i:5;}s:6:"weight";i:1;s:6:"module";s:4:"text";}s:8:"settings";a:3:{s:15:"display_summary";b:1;s:15:"text_processing";i:1;s:18:"user_register_form";b:0;}s:7:"display";a:2:{s:7:"default";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"weight";i:1;}s:6:"teaser";a:5:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:6:"module";s:4:"text";s:6:"weight";i:1;}}s:8:"required";b:0;s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->values(array(
  'id' => '15',
  'field_id' => '8',
  'field_name' => 'og_roles_permissions',
  'entity_type' => 'node',
  'bundle' => 'school',
  'data' => 'a:9:{s:5:"label";s:27:"Group roles and permissions";s:11:"widget_type";s:14:"options_select";s:8:"required";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:10:"view modes";a:2:{s:4:"full";a:3:{s:5:"label";s:4:"Full";s:4:"type";s:12:"list_default";s:15:"custom settings";b:0;}s:6:"teaser";a:3:{s:5:"label";s:6:"Teaser";s:4:"type";s:12:"list_default";s:15:"custom settings";b:0;}}s:8:"settings";a:1:{s:18:"user_register_form";b:0;}s:7:"display";a:1:{s:7:"default";a:5:{s:5:"label";s:5:"above";s:4:"type";s:12:"list_default";s:8:"settings";a:0:{}s:6:"module";s:4:"list";s:6:"weight";i:2;}}s:6:"widget";a:4:{s:4:"type";s:15:"options_buttons";s:8:"settings";a:0:{}s:6:"weight";i:2;s:6:"module";s:7:"options";}s:11:"description";s:0:"";}',
  'deleted' => '0',
))
->execute();

db_create_table('field_data_body', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'entity_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => FALSE,
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'body_value' => array(
      'type' => 'text',
      'size' => 'big',
      'not null' => FALSE,
    ),
    'body_summary' => array(
      'type' => 'text',
      'size' => 'big',
      'not null' => FALSE,
    ),
    'body_format' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => FALSE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'body_format' => array(
      'body_format',
    ),
  ),
  'foreign keys' => array(
    'body_format' => array(
      'table' => 'filter_format',
      'columns' => array(
        'body_format' => 'format',
      ),
    ),
  ),
  'module' => 'field_sql_storage',
  'name' => 'field_data_body',
));
db_insert('field_data_body')->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'body_value',
  'body_summary',
  'body_format',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'school',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'body_value' => 'This is a regular group.',
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'school',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '2',
  'language' => 'und',
  'delta' => '0',
  'body_value' => 'This is a group with Override roles and permissions.',
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->execute();

db_create_table('field_data_comment_body', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'entity_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => FALSE,
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'comment_body_value' => array(
      'type' => 'text',
      'size' => 'big',
      'not null' => FALSE,
    ),
    'comment_body_format' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => FALSE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'comment_body_format' => array(
      'comment_body_format',
    ),
  ),
  'foreign keys' => array(
    'comment_body_format' => array(
      'table' => 'filter_format',
      'columns' => array(
        'comment_body_format' => 'format',
      ),
    ),
  ),
  'module' => 'field_sql_storage',
  'name' => 'field_data_comment_body',
));

db_create_table('field_data_field_image', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'entity_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => FALSE,
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'field_image_fid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'unsigned' => TRUE,
    ),
    'field_image_alt' => array(
      'type' => 'varchar',
      'length' => 512,
      'not null' => FALSE,
    ),
    'field_image_title' => array(
      'type' => 'varchar',
      'length' => 1024,
      'not null' => FALSE,
    ),
    'field_image_width' => array(
      'type' => 'int',
      'unsigned' => TRUE,
    ),
    'field_image_height' => array(
      'type' => 'int',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'field_image_fid' => array(
      'field_image_fid',
    ),
  ),
  'foreign keys' => array(
    'field_image_fid' => array(
      'table' => 'file_managed',
      'columns' => array(
        'field_image_fid' => 'fid',
      ),
    ),
  ),
  'module' => 'field_sql_storage',
  'name' => 'field_data_field_image',
));

db_create_table('field_data_field_tags', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'entity_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => FALSE,
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'field_tags_tid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => FALSE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'field_tags_tid' => array(
      'field_tags_tid',
    ),
  ),
  'foreign keys' => array(
    'field_tags_tid' => array(
      'table' => 'taxonomy_term_data',
      'columns' => array(
        'field_tags_tid' => 'tid',
      ),
    ),
  ),
  'module' => 'field_sql_storage',
  'name' => 'field_data_field_tags',
));

db_create_table('field_data_group_audience', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'entity_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => FALSE,
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'group_audience_gid' => array(
      'type' => 'float',
      'unsigned' => TRUE,
      'not null' => FALSE,
    ),
    'group_audience_state' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => FALSE,
      'default' => '',
    ),
    'group_audience_created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'group_audience_gid' => array(
      'group_audience_gid',
    ),
  ),
  'foreign keys' => array(
    'group_audience_og' => array(
      'table' => 'og',
      'columns' => array(
        'group_audience_gid' => 'gid',
      ),
    ),
  ),
  'module' => 'field_sql_storage',
  'name' => 'field_data_group_audience',
));
db_insert('field_data_group_audience')->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'group_audience_gid',
  'group_audience_state',
  'group_audience_created',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694728',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '1',
  'group_audience_gid' => '2',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694858',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '2',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694751',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '3',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694751',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '4',
  'revision_id' => '4',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694751',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '5',
  'revision_id' => '5',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694751',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '6',
  'revision_id' => '6',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694751',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '7',
  'revision_id' => '7',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694751',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '7',
  'revision_id' => '7',
  'language' => 'und',
  'delta' => '1',
  'group_audience_gid' => '2',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694933',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '8',
  'revision_id' => '8',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694752',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '9',
  'revision_id' => '9',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694752',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '10',
  'revision_id' => '10',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694752',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '11',
  'revision_id' => '11',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694752',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '11',
  'revision_id' => '11',
  'language' => 'und',
  'delta' => '1',
  'group_audience_gid' => '2',
  'group_audience_state' => '2',
  'group_audience_created' => '1346694912',
))
->execute();

db_create_table('field_data_group_group', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'entity_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => FALSE,
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'group_group_value' => array(
      'type' => 'int',
      'not null' => FALSE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'group_group_value' => array(
      'group_group_value',
    ),
  ),
  'module' => 'field_sql_storage',
  'name' => 'field_data_group_group',
));
db_insert('field_data_group_group')->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'group_group_value',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'school',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'group_group_value' => '1',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'school',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '2',
  'language' => 'und',
  'delta' => '0',
  'group_group_value' => '1',
))
->execute();

db_create_table('field_data_og_membership_request', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'entity_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => FALSE,
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'og_membership_request_value' => array(
      'type' => 'text',
      'size' => 'big',
      'not null' => FALSE,
    ),
    'og_membership_request_format' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => FALSE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'og_membership_request_format' => array(
      'og_membership_request_format',
    ),
  ),
  'foreign keys' => array(
    'og_membership_request_format' => array(
      'table' => 'filter_format',
      'columns' => array(
        'og_membership_request_format' => 'format',
      ),
    ),
  ),
  'module' => 'field_sql_storage',
  'name' => 'field_data_og_membership_request',
));
db_insert('field_data_og_membership_request')->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'og_membership_request_value',
  'og_membership_request_format',
))
->values(array(
  'entity_type' => 'og_membership',
  'bundle' => 'og_membership_type_default',
  'deleted' => '0',
  'entity_id' => '13',
  'revision_id' => '13',
  'language' => 'und',
  'delta' => '0',
  'og_membership_request_value' => '',
  'og_membership_request_format' => NULL,
))
->values(array(
  'entity_type' => 'og_membership',
  'bundle' => 'og_membership_type_default',
  'deleted' => '0',
  'entity_id' => '14',
  'revision_id' => '14',
  'language' => 'und',
  'delta' => '0',
  'og_membership_request_value' => '',
  'og_membership_request_format' => NULL,
))
->execute();

db_create_table('field_data_og_roles_permissions', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'entity_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => FALSE,
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'og_roles_permissions_value' => array(
      'type' => 'int',
      'not null' => FALSE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'og_roles_permissions_value' => array(
      'og_roles_permissions_value',
    ),
  ),
  'module' => 'field_sql_storage',
  'name' => 'field_data_og_roles_permissions',
));
db_insert('field_data_og_roles_permissions')->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'og_roles_permissions_value',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'school',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'og_roles_permissions_value' => '0',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'school',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '2',
  'language' => 'und',
  'delta' => '0',
  'og_roles_permissions_value' => '1',
))
->execute();

db_create_table('field_revision_body', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'entity_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'body_value' => array(
      'type' => 'text',
      'size' => 'big',
      'not null' => FALSE,
    ),
    'body_summary' => array(
      'type' => 'text',
      'size' => 'big',
      'not null' => FALSE,
    ),
    'body_format' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => FALSE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'body_format' => array(
      'body_format',
    ),
  ),
  'foreign keys' => array(
    'body_format' => array(
      'table' => 'filter_format',
      'columns' => array(
        'body_format' => 'format',
      ),
    ),
  ),
  'module' => 'field_sql_storage',
  'name' => 'field_revision_body',
));
db_insert('field_revision_body')->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'body_value',
  'body_summary',
  'body_format',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'school',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'body_value' => 'This is a regular group.',
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'school',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '2',
  'language' => 'und',
  'delta' => '0',
  'body_value' => 'This is a group with Override roles and permissions.',
  'body_summary' => '',
  'body_format' => 'filtered_html',
))
->execute();

db_create_table('field_revision_comment_body', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'entity_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'comment_body_value' => array(
      'type' => 'text',
      'size' => 'big',
      'not null' => FALSE,
    ),
    'comment_body_format' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => FALSE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'comment_body_format' => array(
      'comment_body_format',
    ),
  ),
  'foreign keys' => array(
    'comment_body_format' => array(
      'table' => 'filter_format',
      'columns' => array(
        'comment_body_format' => 'format',
      ),
    ),
  ),
  'module' => 'field_sql_storage',
  'name' => 'field_revision_comment_body',
));

db_create_table('field_revision_field_image', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'entity_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'field_image_fid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'unsigned' => TRUE,
    ),
    'field_image_alt' => array(
      'type' => 'varchar',
      'length' => 512,
      'not null' => FALSE,
    ),
    'field_image_title' => array(
      'type' => 'varchar',
      'length' => 1024,
      'not null' => FALSE,
    ),
    'field_image_width' => array(
      'type' => 'int',
      'unsigned' => TRUE,
    ),
    'field_image_height' => array(
      'type' => 'int',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'field_image_fid' => array(
      'field_image_fid',
    ),
  ),
  'foreign keys' => array(
    'field_image_fid' => array(
      'table' => 'file_managed',
      'columns' => array(
        'field_image_fid' => 'fid',
      ),
    ),
  ),
  'module' => 'field_sql_storage',
  'name' => 'field_revision_field_image',
));

db_create_table('field_revision_field_tags', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'entity_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'field_tags_tid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => FALSE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'field_tags_tid' => array(
      'field_tags_tid',
    ),
  ),
  'foreign keys' => array(
    'field_tags_tid' => array(
      'table' => 'taxonomy_term_data',
      'columns' => array(
        'field_tags_tid' => 'tid',
      ),
    ),
  ),
  'module' => 'field_sql_storage',
  'name' => 'field_revision_field_tags',
));

db_create_table('field_revision_group_audience', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'entity_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'group_audience_gid' => array(
      'type' => 'float',
      'unsigned' => TRUE,
      'not null' => FALSE,
    ),
    'group_audience_state' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => FALSE,
      'default' => '',
    ),
    'group_audience_created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'group_audience_gid' => array(
      'group_audience_gid',
    ),
  ),
  'foreign keys' => array(
    'group_audience_og' => array(
      'table' => 'og',
      'columns' => array(
        'group_audience_gid' => 'gid',
      ),
    ),
  ),
  'module' => 'field_sql_storage',
  'name' => 'field_revision_group_audience',
));
db_insert('field_revision_group_audience')->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'group_audience_gid',
  'group_audience_state',
  'group_audience_created',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694728',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '1',
  'group_audience_gid' => '2',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694858',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '2',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694751',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '3',
  'revision_id' => '3',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694751',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '4',
  'revision_id' => '4',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694751',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '5',
  'revision_id' => '5',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694751',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '6',
  'revision_id' => '6',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694751',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '7',
  'revision_id' => '7',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694751',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '7',
  'revision_id' => '7',
  'language' => 'und',
  'delta' => '1',
  'group_audience_gid' => '2',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694933',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '8',
  'revision_id' => '8',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694752',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '9',
  'revision_id' => '9',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694752',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '10',
  'revision_id' => '10',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694752',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '11',
  'revision_id' => '11',
  'language' => 'und',
  'delta' => '0',
  'group_audience_gid' => '1',
  'group_audience_state' => '1',
  'group_audience_created' => '1346694752',
))
->values(array(
  'entity_type' => 'user',
  'bundle' => 'user',
  'deleted' => '0',
  'entity_id' => '11',
  'revision_id' => '11',
  'language' => 'und',
  'delta' => '1',
  'group_audience_gid' => '2',
  'group_audience_state' => '2',
  'group_audience_created' => '1346694912',
))
->execute();

db_create_table('field_revision_group_group', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'entity_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'group_group_value' => array(
      'type' => 'int',
      'not null' => FALSE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'group_group_value' => array(
      'group_group_value',
    ),
  ),
  'module' => 'field_sql_storage',
  'name' => 'field_revision_group_group',
));
db_insert('field_revision_group_group')->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'group_group_value',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'school',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'group_group_value' => '1',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'school',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '2',
  'language' => 'und',
  'delta' => '0',
  'group_group_value' => '1',
))
->execute();

db_create_table('field_revision_og_membership_request', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'entity_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'og_membership_request_value' => array(
      'type' => 'text',
      'size' => 'big',
      'not null' => FALSE,
    ),
    'og_membership_request_format' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => FALSE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'og_membership_request_format' => array(
      'og_membership_request_format',
    ),
  ),
  'foreign keys' => array(
    'og_membership_request_format' => array(
      'table' => 'filter_format',
      'columns' => array(
        'og_membership_request_format' => 'format',
      ),
    ),
  ),
  'module' => 'field_sql_storage',
  'name' => 'field_revision_og_membership_request',
));
db_insert('field_revision_og_membership_request')->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'og_membership_request_value',
  'og_membership_request_format',
))
->values(array(
  'entity_type' => 'og_membership',
  'bundle' => 'og_membership_type_default',
  'deleted' => '0',
  'entity_id' => '13',
  'revision_id' => '13',
  'language' => 'und',
  'delta' => '0',
  'og_membership_request_value' => '',
  'og_membership_request_format' => NULL,
))
->values(array(
  'entity_type' => 'og_membership',
  'bundle' => 'og_membership_type_default',
  'deleted' => '0',
  'entity_id' => '14',
  'revision_id' => '14',
  'language' => 'und',
  'delta' => '0',
  'og_membership_request_value' => '',
  'og_membership_request_format' => NULL,
))
->execute();

db_create_table('field_revision_og_roles_permissions', array(
  'fields' => array(
    'entity_type' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'bundle' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'deleted' => array(
      'type' => 'int',
      'size' => 'tiny',
      'not null' => TRUE,
      'default' => 0,
    ),
    'entity_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'revision_id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'og_roles_permissions_value' => array(
      'type' => 'int',
      'not null' => FALSE,
    ),
  ),
  'primary key' => array(
    'entity_type',
    'entity_id',
    'revision_id',
    'deleted',
    'delta',
    'language',
  ),
  'indexes' => array(
    'entity_type' => array(
      'entity_type',
    ),
    'bundle' => array(
      'bundle',
    ),
    'deleted' => array(
      'deleted',
    ),
    'entity_id' => array(
      'entity_id',
    ),
    'revision_id' => array(
      'revision_id',
    ),
    'language' => array(
      'language',
    ),
    'og_roles_permissions_value' => array(
      'og_roles_permissions_value',
    ),
  ),
  'module' => 'field_sql_storage',
  'name' => 'field_revision_og_roles_permissions',
));
db_insert('field_revision_og_roles_permissions')->fields(array(
  'entity_type',
  'bundle',
  'deleted',
  'entity_id',
  'revision_id',
  'language',
  'delta',
  'og_roles_permissions_value',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'school',
  'deleted' => '0',
  'entity_id' => '1',
  'revision_id' => '1',
  'language' => 'und',
  'delta' => '0',
  'og_roles_permissions_value' => '0',
))
->values(array(
  'entity_type' => 'node',
  'bundle' => 'school',
  'deleted' => '0',
  'entity_id' => '2',
  'revision_id' => '2',
  'language' => 'und',
  'delta' => '0',
  'og_roles_permissions_value' => '1',
))
->execute();

db_create_table('file_managed', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'filename' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
      'binary' => TRUE,
    ),
    'uri' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
      'binary' => TRUE,
    ),
    'filemime' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'filesize' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'timestamp' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'uid' => array(
      'uid',
    ),
    'status' => array(
      'status',
    ),
    'timestamp' => array(
      'timestamp',
    ),
  ),
  'unique keys' => array(
    'uri' => array(
      'uri',
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'foreign keys' => array(
    'file_owner' => array(
      'table' => 'users',
      'columns' => array(
        'uid' => 'uid',
      ),
    ),
  ),
  'module' => 'system',
  'name' => 'file_managed',
));
db_insert('file_managed')->fields(array(
  'fid',
  'uid',
  'filename',
  'uri',
  'filemime',
  'filesize',
  'status',
  'timestamp',
))
->values(array(
  'fid' => '1',
  'uid' => '2',
  'filename' => 'picture-2.png',
  'uri' => 'public://pictures/picture-2_62.png',
  'filemime' => 'image/png',
  'filesize' => '886',
  'status' => '1',
  'timestamp' => '1346694751',
))
->values(array(
  'fid' => '2',
  'uid' => '3',
  'filename' => 'picture-3.png',
  'uri' => 'public://pictures/picture-3_62.png',
  'filemime' => 'image/png',
  'filesize' => '882',
  'status' => '1',
  'timestamp' => '1346694751',
))
->values(array(
  'fid' => '3',
  'uid' => '4',
  'filename' => 'picture-4.png',
  'uri' => 'public://pictures/picture-4_62.png',
  'filemime' => 'image/png',
  'filesize' => '939',
  'status' => '1',
  'timestamp' => '1346694751',
))
->values(array(
  'fid' => '4',
  'uid' => '5',
  'filename' => 'picture-5.png',
  'uri' => 'public://pictures/picture-5_62.png',
  'filemime' => 'image/png',
  'filesize' => '859',
  'status' => '1',
  'timestamp' => '1346694751',
))
->values(array(
  'fid' => '5',
  'uid' => '6',
  'filename' => 'picture-6.png',
  'uri' => 'public://pictures/picture-6_62.png',
  'filemime' => 'image/png',
  'filesize' => '910',
  'status' => '1',
  'timestamp' => '1346694751',
))
->values(array(
  'fid' => '6',
  'uid' => '7',
  'filename' => 'picture-7.png',
  'uri' => 'public://pictures/picture-7_62.png',
  'filemime' => 'image/png',
  'filesize' => '830',
  'status' => '1',
  'timestamp' => '1346694751',
))
->values(array(
  'fid' => '7',
  'uid' => '8',
  'filename' => 'picture-8.png',
  'uri' => 'public://pictures/picture-8_62.png',
  'filemime' => 'image/png',
  'filesize' => '893',
  'status' => '1',
  'timestamp' => '1346694751',
))
->values(array(
  'fid' => '8',
  'uid' => '9',
  'filename' => 'picture-9.png',
  'uri' => 'public://pictures/picture-9_62.png',
  'filemime' => 'image/png',
  'filesize' => '916',
  'status' => '1',
  'timestamp' => '1346694751',
))
->values(array(
  'fid' => '9',
  'uid' => '10',
  'filename' => 'picture-10.png',
  'uri' => 'public://pictures/picture-10_62.png',
  'filemime' => 'image/png',
  'filesize' => '878',
  'status' => '1',
  'timestamp' => '1346694751',
))
->values(array(
  'fid' => '10',
  'uid' => '11',
  'filename' => 'picture-11.png',
  'uri' => 'public://pictures/picture-11_62.png',
  'filemime' => 'image/png',
  'filesize' => '854',
  'status' => '1',
  'timestamp' => '1346694751',
))
->execute();

db_create_table('file_usage', array(
  'fields' => array(
    'fid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'module' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
    ),
    'id' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'count' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'fid',
    'type',
    'id',
    'module',
  ),
  'indexes' => array(
    'type_id' => array(
      'type',
      'id',
    ),
    'fid_count' => array(
      'fid',
      'count',
    ),
    'fid_module' => array(
      'fid',
      'module',
    ),
  ),
  'module' => 'system',
  'name' => 'file_usage',
));

db_create_table('filter', array(
  'fields' => array(
    'format' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
    ),
    'module' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'settings' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
      'serialize' => TRUE,
    ),
  ),
  'primary key' => array(
    'format',
    'name',
  ),
  'indexes' => array(
    'list' => array(
      'weight',
      'module',
      'name',
    ),
  ),
  'module' => 'filter',
  'name' => 'filter',
));
db_insert('filter')->fields(array(
  'format',
  'module',
  'name',
  'weight',
  'status',
  'settings',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '2',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '1',
  'status' => '1',
  'settings' => 'a:3:{s:12:"allowed_html";s:74:"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:0;}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'filtered_html',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:1:{s:17:"filter_url_length";i:72;}',
))
->values(array(
  'format' => 'full_html',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '1',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'full_html',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:3:{s:12:"allowed_html";s:74:"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:0;}',
))
->values(array(
  'format' => 'full_html',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'full_html',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'full_html',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:1:{s:17:"filter_url_length";i:72;}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_autop',
  'weight' => '2',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_html',
  'weight' => '-10',
  'status' => '0',
  'settings' => 'a:3:{s:12:"allowed_html";s:74:"<a> <em> <strong> <cite> <blockquote> <code> <ul> <ol> <li> <dl> <dt> <dd>";s:16:"filter_html_help";i:1;s:20:"filter_html_nofollow";i:0;}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_htmlcorrector',
  'weight' => '10',
  'status' => '0',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_html_escape',
  'weight' => '0',
  'status' => '1',
  'settings' => 'a:0:{}',
))
->values(array(
  'format' => 'plain_text',
  'module' => 'filter',
  'name' => 'filter_url',
  'weight' => '1',
  'status' => '1',
  'settings' => 'a:1:{s:17:"filter_url_length";i:72;}',
))
->execute();

db_create_table('filter_format', array(
  'fields' => array(
    'format' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
      'translatable' => TRUE,
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'status' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 1,
      'size' => 'tiny',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'format',
  ),
  'unique keys' => array(
    'name' => array(
      'name',
    ),
  ),
  'indexes' => array(
    'status_weight' => array(
      'status',
      'weight',
    ),
  ),
  'module' => 'filter',
  'name' => 'filter_format',
));
db_insert('filter_format')->fields(array(
  'format',
  'name',
  'cache',
  'status',
  'weight',
))
->values(array(
  'format' => 'filtered_html',
  'name' => 'Filtered HTML',
  'cache' => '1',
  'status' => '1',
  'weight' => '0',
))
->values(array(
  'format' => 'full_html',
  'name' => 'Full HTML',
  'cache' => '1',
  'status' => '1',
  'weight' => '1',
))
->values(array(
  'format' => 'plain_text',
  'name' => 'Plain text',
  'cache' => '1',
  'status' => '1',
  'weight' => '10',
))
->execute();

db_create_table('flood', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
    ),
    'event' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
    ),
    'identifier' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'expiration' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'indexes' => array(
    'allow' => array(
      'event',
      'identifier',
      'timestamp',
    ),
    'purge' => array(
      'expiration',
    ),
  ),
  'module' => 'system',
  'name' => 'flood',
));

db_create_table('history', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'uid',
    'nid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
  ),
  'module' => 'node',
  'name' => 'history',
));
db_insert('history')->fields(array(
  'uid',
  'nid',
  'timestamp',
))
->values(array(
  'uid' => '1',
  'nid' => '1',
  'timestamp' => '1346694807',
))
->values(array(
  'uid' => '1',
  'nid' => '2',
  'timestamp' => '1346694952',
))
->execute();

db_create_table('image_effects', array(
  'fields' => array(
    'ieid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'isid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'weight' => array(
      'type' => 'int',
      'unsigned' => FALSE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'big',
      'serialize' => TRUE,
    ),
  ),
  'primary key' => array(
    'ieid',
  ),
  'indexes' => array(
    'isid' => array(
      'isid',
    ),
    'weight' => array(
      'weight',
    ),
  ),
  'foreign keys' => array(
    'image_style' => array(
      'table' => 'image_styles',
      'columns' => array(
        'isid' => 'isid',
      ),
    ),
  ),
  'module' => 'image',
  'name' => 'image_effects',
));

db_create_table('image_styles', array(
  'fields' => array(
    'isid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
    ),
  ),
  'primary key' => array(
    'isid',
  ),
  'unique keys' => array(
    'name' => array(
      'name',
    ),
  ),
  'module' => 'image',
  'name' => 'image_styles',
));

db_create_table('menu_custom', array(
  'fields' => array(
    'menu_name' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
      'translatable' => TRUE,
    ),
    'description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'translatable' => TRUE,
    ),
  ),
  'primary key' => array(
    'menu_name',
  ),
  'module' => 'menu',
  'name' => 'menu_custom',
));
db_insert('menu_custom')->fields(array(
  'menu_name',
  'title',
  'description',
))
->values(array(
  'menu_name' => 'devel',
  'title' => 'Development',
  'description' => 'Development link',
))
->values(array(
  'menu_name' => 'main-menu',
  'title' => 'Main menu',
  'description' => 'The <em>Main</em> menu is used on many sites to show the major sections of the site, often in a top navigation bar.',
))
->values(array(
  'menu_name' => 'management',
  'title' => 'Management',
  'description' => 'The <em>Management</em> menu contains links for administrative tasks.',
))
->values(array(
  'menu_name' => 'navigation',
  'title' => 'Navigation',
  'description' => 'The <em>Navigation</em> menu contains links intended for site visitors. Links are added to the <em>Navigation</em> menu automatically by some modules.',
))
->values(array(
  'menu_name' => 'user-menu',
  'title' => 'User menu',
  'description' => "The <em>User</em> menu contains links related to the user's account, as well as the 'Log out' link.",
))
->execute();

db_create_table('menu_links', array(
  'fields' => array(
    'menu_name' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'mlid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'plid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'link_path' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'router_path' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'link_title' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
      'translatable' => TRUE,
    ),
    'options' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'translatable' => TRUE,
    ),
    'module' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => 'system',
    ),
    'hidden' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'small',
    ),
    'external' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'small',
    ),
    'has_children' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'small',
    ),
    'expanded' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'small',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'depth' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'small',
    ),
    'customized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'small',
    ),
    'p1' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'p2' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'p3' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'p4' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'p5' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'p6' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'p7' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'p8' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'p9' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'updated' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'small',
    ),
  ),
  'indexes' => array(
    'path_menu' => array(
      array(
        'link_path',
        128,
      ),
      'menu_name',
    ),
    'menu_plid_expand_child' => array(
      'menu_name',
      'plid',
      'expanded',
      'has_children',
    ),
    'menu_parents' => array(
      'menu_name',
      'p1',
      'p2',
      'p3',
      'p4',
      'p5',
      'p6',
      'p7',
      'p8',
      'p9',
    ),
    'router_path' => array(
      array(
        'router_path',
        128,
      ),
    ),
  ),
  'primary key' => array(
    'mlid',
  ),
  'module' => 'system',
  'name' => 'menu_links',
));
db_insert('menu_links')->fields(array(
  'menu_name',
  'mlid',
  'plid',
  'link_path',
  'router_path',
  'link_title',
  'options',
  'module',
  'hidden',
  'external',
  'has_children',
  'expanded',
  'weight',
  'depth',
  'customized',
  'p1',
  'p2',
  'p3',
  'p4',
  'p5',
  'p6',
  'p7',
  'p8',
  'p9',
  'updated',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '1',
  'plid' => '0',
  'link_path' => 'admin',
  'router_path' => 'admin',
  'link_title' => 'Administration',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '9',
  'depth' => '1',
  'customized' => '0',
  'p1' => '1',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '2',
  'plid' => '0',
  'link_path' => 'user',
  'router_path' => 'user',
  'link_title' => 'User account',
  'options' => 'a:1:{s:5:"alter";b:1;}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '2',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '3',
  'plid' => '0',
  'link_path' => 'comment/%',
  'router_path' => 'comment/%',
  'link_title' => 'Comment permalink',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '3',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '4',
  'plid' => '0',
  'link_path' => 'filter/tips',
  'router_path' => 'filter/tips',
  'link_title' => 'Compose tips',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '4',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '5',
  'plid' => '0',
  'link_path' => 'node/%',
  'router_path' => 'node/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '5',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '6',
  'plid' => '0',
  'link_path' => 'node/add',
  'router_path' => 'node/add',
  'link_title' => 'Add content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '6',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '7',
  'plid' => '1',
  'link_path' => 'admin/appearance',
  'router_path' => 'admin/appearance',
  'link_title' => 'Appearance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:33:"Select and configure your themes.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-6',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '8',
  'plid' => '1',
  'link_path' => 'admin/config',
  'router_path' => 'admin/config',
  'link_title' => 'Configuration',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:20:"Administer settings.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '9',
  'plid' => '1',
  'link_path' => 'admin/content',
  'router_path' => 'admin/content',
  'link_title' => 'Content',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:32:"Administer content and comments.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '9',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '10',
  'plid' => '2',
  'link_path' => 'user/register',
  'router_path' => 'user/register',
  'link_title' => 'Create new account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '10',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '11',
  'plid' => '1',
  'link_path' => 'admin/dashboard',
  'router_path' => 'admin/dashboard',
  'link_title' => 'Dashboard',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:34:"View and customize your dashboard.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '11',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '12',
  'plid' => '1',
  'link_path' => 'admin/index',
  'router_path' => 'admin/index',
  'link_title' => 'Index',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-18',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '12',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '13',
  'plid' => '2',
  'link_path' => 'user/login',
  'router_path' => 'user/login',
  'link_title' => 'Log in',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '13',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '14',
  'plid' => '0',
  'link_path' => 'user/logout',
  'router_path' => 'user/logout',
  'link_title' => 'Log out',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '14',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '15',
  'plid' => '1',
  'link_path' => 'admin/modules',
  'router_path' => 'admin/modules',
  'link_title' => 'Modules',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:26:"Extend site functionality.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '16',
  'plid' => '0',
  'link_path' => 'user/%',
  'router_path' => 'user/%',
  'link_title' => 'My account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '16',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '17',
  'plid' => '1',
  'link_path' => 'admin/people',
  'router_path' => 'admin/people',
  'link_title' => 'People',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Manage user accounts, roles, and permissions.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-4',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '18',
  'plid' => '1',
  'link_path' => 'admin/reports',
  'router_path' => 'admin/reports',
  'link_title' => 'Reports',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:34:"View reports, updates, and errors.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'user-menu',
  'mlid' => '19',
  'plid' => '2',
  'link_path' => 'user/password',
  'router_path' => 'user/password',
  'link_title' => 'Request new password',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '2',
  'p2' => '19',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '20',
  'plid' => '1',
  'link_path' => 'admin/structure',
  'router_path' => 'admin/structure',
  'link_title' => 'Structure',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Administer blocks, content types, menus, etc.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-8',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '21',
  'plid' => '1',
  'link_path' => 'admin/tasks',
  'router_path' => 'admin/tasks',
  'link_title' => 'Tasks',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '21',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '22',
  'plid' => '0',
  'link_path' => 'comment/reply/%',
  'router_path' => 'comment/reply/%',
  'link_title' => 'Add new comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '22',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '23',
  'plid' => '3',
  'link_path' => 'comment/%/approve',
  'router_path' => 'comment/%/approve',
  'link_title' => 'Approve',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '23',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '24',
  'plid' => '3',
  'link_path' => 'comment/%/delete',
  'router_path' => 'comment/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '24',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '25',
  'plid' => '3',
  'link_path' => 'comment/%/edit',
  'router_path' => 'comment/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '25',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '26',
  'plid' => '0',
  'link_path' => 'taxonomy/term/%',
  'router_path' => 'taxonomy/term/%',
  'link_title' => 'Taxonomy term',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '26',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '27',
  'plid' => '3',
  'link_path' => 'comment/%/view',
  'router_path' => 'comment/%/view',
  'link_title' => 'View comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '27',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '28',
  'plid' => '17',
  'link_path' => 'admin/people/create',
  'router_path' => 'admin/people/create',
  'link_title' => 'Add user',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '28',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '29',
  'plid' => '20',
  'link_path' => 'admin/structure/block',
  'router_path' => 'admin/structure/block',
  'link_title' => 'Blocks',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:79:\"Configure what block content appears in your site's sidebars and other regions.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '29',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '30',
  'plid' => '16',
  'link_path' => 'user/%/cancel',
  'router_path' => 'user/%/cancel',
  'link_title' => 'Cancel account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '30',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '31',
  'plid' => '9',
  'link_path' => 'admin/content/comment',
  'router_path' => 'admin/content/comment',
  'link_title' => 'Comments',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:59:"List and edit site comments and the comment approval queue.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '9',
  'p3' => '31',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '32',
  'plid' => '11',
  'link_path' => 'admin/dashboard/configure',
  'router_path' => 'admin/dashboard/configure',
  'link_title' => 'Configure available dashboard blocks',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:53:"Configure which blocks can be shown on the dashboard.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '11',
  'p3' => '32',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '33',
  'plid' => '9',
  'link_path' => 'admin/content/node',
  'router_path' => 'admin/content/node',
  'link_title' => 'Content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '9',
  'p3' => '33',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '34',
  'plid' => '8',
  'link_path' => 'admin/config/content',
  'router_path' => 'admin/config/content',
  'link_title' => 'Content authoring',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:53:"Settings related to formatting and authoring content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '34',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '35',
  'plid' => '20',
  'link_path' => 'admin/structure/types',
  'router_path' => 'admin/structure/types',
  'link_title' => 'Content types',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:92:"Manage content types, including default status, front page promotion, comment settings, etc.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '36',
  'plid' => '11',
  'link_path' => 'admin/dashboard/customize',
  'router_path' => 'admin/dashboard/customize',
  'link_title' => 'Customize dashboard',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:25:"Customize your dashboard.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '11',
  'p3' => '36',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '37',
  'plid' => '5',
  'link_path' => 'node/%/delete',
  'router_path' => 'node/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '37',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '38',
  'plid' => '8',
  'link_path' => 'admin/config/development',
  'router_path' => 'admin/config/development',
  'link_title' => 'Development',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:18:"Development tools.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '38',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '39',
  'plid' => '16',
  'link_path' => 'user/%/edit',
  'router_path' => 'user/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '39',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '40',
  'plid' => '5',
  'link_path' => 'node/%/edit',
  'router_path' => 'node/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '40',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '41',
  'plid' => '18',
  'link_path' => 'admin/reports/fields',
  'router_path' => 'admin/reports/fields',
  'link_title' => 'Field list',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Overview of fields on all entity types.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '41',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '42',
  'plid' => '15',
  'link_path' => 'admin/modules/list',
  'router_path' => 'admin/modules/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '42',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '43',
  'plid' => '17',
  'link_path' => 'admin/people/people',
  'router_path' => 'admin/people/people',
  'link_title' => 'List',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:50:"Find and manage people interacting with your site.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '43',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '44',
  'plid' => '7',
  'link_path' => 'admin/appearance/list',
  'router_path' => 'admin/appearance/list',
  'link_title' => 'List',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:31:"Select and configure your theme";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-1',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '44',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '45',
  'plid' => '8',
  'link_path' => 'admin/config/media',
  'router_path' => 'admin/config/media',
  'link_title' => 'Media',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:12:"Media tools.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '46',
  'plid' => '20',
  'link_path' => 'admin/structure/menu',
  'router_path' => 'admin/structure/menu',
  'link_title' => 'Menus',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:86:"Add new menus to your site, edit existing menus, and rename and reorganize menu links.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '46',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '47',
  'plid' => '8',
  'link_path' => 'admin/config/people',
  'router_path' => 'admin/config/people',
  'link_title' => 'People',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:24:"Configure user accounts.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '47',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '48',
  'plid' => '17',
  'link_path' => 'admin/people/permissions',
  'router_path' => 'admin/people/permissions',
  'link_title' => 'Permissions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:64:"Determine access to features by selecting permissions for roles.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '48',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '49',
  'plid' => '18',
  'link_path' => 'admin/reports/dblog',
  'router_path' => 'admin/reports/dblog',
  'link_title' => 'Recent log messages',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"View events that have recently been logged.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-1',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '49',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '50',
  'plid' => '8',
  'link_path' => 'admin/config/regional',
  'router_path' => 'admin/config/regional',
  'link_title' => 'Regional and language',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:48:"Regional settings, localization and translation.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '51',
  'plid' => '5',
  'link_path' => 'node/%/revisions',
  'router_path' => 'node/%/revisions',
  'link_title' => 'Revisions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '51',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '52',
  'plid' => '8',
  'link_path' => 'admin/config/search',
  'router_path' => 'admin/config/search',
  'link_title' => 'Search and metadata',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:36:"Local site search, metadata and SEO.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '52',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '53',
  'plid' => '7',
  'link_path' => 'admin/appearance/settings',
  'router_path' => 'admin/appearance/settings',
  'link_title' => 'Settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:46:"Configure default and theme specific settings.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '53',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '54',
  'plid' => '18',
  'link_path' => 'admin/reports/status',
  'router_path' => 'admin/reports/status',
  'link_title' => 'Status report',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:74:\"Get a status report about your site's operation and any detected problems.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-60',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '54',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '55',
  'plid' => '8',
  'link_path' => 'admin/config/system',
  'router_path' => 'admin/config/system',
  'link_title' => 'System',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:37:"General system related configuration.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '55',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '56',
  'plid' => '20',
  'link_path' => 'admin/structure/taxonomy',
  'router_path' => 'admin/structure/taxonomy',
  'link_title' => 'Taxonomy',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:67:"Manage tagging, categorization, and classification of your content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '56',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '57',
  'plid' => '18',
  'link_path' => 'admin/reports/access-denied',
  'router_path' => 'admin/reports/access-denied',
  'link_title' => "Top 'access denied' errors",
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:35:\"View 'access denied' errors (403s).\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '57',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '58',
  'plid' => '18',
  'link_path' => 'admin/reports/page-not-found',
  'router_path' => 'admin/reports/page-not-found',
  'link_title' => "Top 'page not found' errors",
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:36:\"View 'page not found' errors (404s).\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '58',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '59',
  'plid' => '15',
  'link_path' => 'admin/modules/uninstall',
  'router_path' => 'admin/modules/uninstall',
  'link_title' => 'Uninstall',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '59',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '60',
  'plid' => '8',
  'link_path' => 'admin/config/user-interface',
  'router_path' => 'admin/config/user-interface',
  'link_title' => 'User interface',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:38:"Tools that enhance the user interface.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '60',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '61',
  'plid' => '5',
  'link_path' => 'node/%/view',
  'router_path' => 'node/%/view',
  'link_title' => 'View',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '61',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '62',
  'plid' => '16',
  'link_path' => 'user/%/view',
  'router_path' => 'user/%/view',
  'link_title' => 'View',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '62',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '63',
  'plid' => '8',
  'link_path' => 'admin/config/services',
  'router_path' => 'admin/config/services',
  'link_title' => 'Web services',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:30:"Tools related to web services.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '63',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '64',
  'plid' => '8',
  'link_path' => 'admin/config/workflow',
  'router_path' => 'admin/config/workflow',
  'link_title' => 'Workflow',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Content workflow, editorial workflow tools.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '64',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '65',
  'plid' => '26',
  'link_path' => 'taxonomy/term/%/edit',
  'router_path' => 'taxonomy/term/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '26',
  'p2' => '65',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '66',
  'plid' => '26',
  'link_path' => 'taxonomy/term/%/view',
  'router_path' => 'taxonomy/term/%/view',
  'link_title' => 'View',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '26',
  'p2' => '66',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '67',
  'plid' => '47',
  'link_path' => 'admin/config/people/accounts',
  'router_path' => 'admin/config/people/accounts',
  'link_title' => 'Account settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:109:"Configure default behavior of users, including registration requirements, e-mails, fields, and user pictures.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '47',
  'p4' => '67',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '68',
  'plid' => '55',
  'link_path' => 'admin/config/system/actions',
  'router_path' => 'admin/config/system/actions',
  'link_title' => 'Actions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"Manage the actions defined for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '55',
  'p4' => '68',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '69',
  'plid' => '29',
  'link_path' => 'admin/structure/block/add',
  'router_path' => 'admin/structure/block/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '29',
  'p4' => '69',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '70',
  'plid' => '35',
  'link_path' => 'admin/structure/types/add',
  'router_path' => 'admin/structure/types/add',
  'link_title' => 'Add content type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '70',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '71',
  'plid' => '46',
  'link_path' => 'admin/structure/menu/add',
  'router_path' => 'admin/structure/menu/add',
  'link_title' => 'Add menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '46',
  'p4' => '71',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '72',
  'plid' => '56',
  'link_path' => 'admin/structure/taxonomy/add',
  'router_path' => 'admin/structure/taxonomy/add',
  'link_title' => 'Add vocabulary',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '56',
  'p4' => '72',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '73',
  'plid' => '53',
  'link_path' => 'admin/appearance/settings/bartik',
  'router_path' => 'admin/appearance/settings/bartik',
  'link_title' => 'Bartik',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '53',
  'p4' => '73',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '74',
  'plid' => '52',
  'link_path' => 'admin/config/search/clean-urls',
  'router_path' => 'admin/config/search/clean-urls',
  'link_title' => 'Clean URLs',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Enable or disable clean URLs for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '52',
  'p4' => '74',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '75',
  'plid' => '55',
  'link_path' => 'admin/config/system/cron',
  'router_path' => 'admin/config/system/cron',
  'link_title' => 'Cron',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:40:"Manage automatic site maintenance tasks.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '55',
  'p4' => '75',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '76',
  'plid' => '50',
  'link_path' => 'admin/config/regional/date-time',
  'router_path' => 'admin/config/regional/date-time',
  'link_title' => 'Date and time',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:44:"Configure display formats for date and time.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '76',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '77',
  'plid' => '18',
  'link_path' => 'admin/reports/event/%',
  'router_path' => 'admin/reports/event/%',
  'link_title' => 'Details',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '77',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '78',
  'plid' => '45',
  'link_path' => 'admin/config/media/file-system',
  'router_path' => 'admin/config/media/file-system',
  'link_title' => 'File system',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:68:"Tell Drupal where to store uploaded files and how they are accessed.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '78',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '79',
  'plid' => '53',
  'link_path' => 'admin/appearance/settings/garland',
  'router_path' => 'admin/appearance/settings/garland',
  'link_title' => 'Garland',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '53',
  'p4' => '79',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '80',
  'plid' => '53',
  'link_path' => 'admin/appearance/settings/gizra',
  'router_path' => 'admin/appearance/settings/gizra',
  'link_title' => 'Gizra',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '53',
  'p4' => '80',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '81',
  'plid' => '53',
  'link_path' => 'admin/appearance/settings/global',
  'router_path' => 'admin/appearance/settings/global',
  'link_title' => 'Global settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-1',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '53',
  'p4' => '81',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '82',
  'plid' => '47',
  'link_path' => 'admin/config/people/ip-blocking',
  'router_path' => 'admin/config/people/ip-blocking',
  'link_title' => 'IP address blocking',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:28:"Manage blocked IP addresses.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '47',
  'p4' => '82',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '83',
  'plid' => '45',
  'link_path' => 'admin/config/media/image-styles',
  'router_path' => 'admin/config/media/image-styles',
  'link_title' => 'Image styles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:78:"Configure styles that can be used for resizing or adjusting images on display.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '83',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '84',
  'plid' => '45',
  'link_path' => 'admin/config/media/image-toolkit',
  'router_path' => 'admin/config/media/image-toolkit',
  'link_title' => 'Image toolkit',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:74:"Choose which image toolkit to use if you have installed optional toolkits.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '84',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '85',
  'plid' => '35',
  'link_path' => 'admin/structure/types/list',
  'router_path' => 'admin/structure/types/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '85',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '86',
  'plid' => '42',
  'link_path' => 'admin/modules/list/confirm',
  'router_path' => 'admin/modules/list/confirm',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '42',
  'p4' => '86',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '87',
  'plid' => '56',
  'link_path' => 'admin/structure/taxonomy/list',
  'router_path' => 'admin/structure/taxonomy/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '56',
  'p4' => '87',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '88',
  'plid' => '46',
  'link_path' => 'admin/structure/menu/list',
  'router_path' => 'admin/structure/menu/list',
  'link_title' => 'List menus',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '46',
  'p4' => '88',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '89',
  'plid' => '38',
  'link_path' => 'admin/config/development/logging',
  'router_path' => 'admin/config/development/logging',
  'link_title' => 'Logging and errors',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:154:\"Settings for logging and alerts modules. Various modules can route Drupal's system events to different destinations, such as syslog, database, email, etc.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-15',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '38',
  'p4' => '89',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '90',
  'plid' => '38',
  'link_path' => 'admin/config/development/maintenance',
  'router_path' => 'admin/config/development/maintenance',
  'link_title' => 'Maintenance mode',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:62:"Take the site offline for maintenance or bring it back online.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '38',
  'p4' => '90',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '91',
  'plid' => '38',
  'link_path' => 'admin/config/development/performance',
  'router_path' => 'admin/config/development/performance',
  'link_title' => 'Performance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:101:"Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '38',
  'p4' => '91',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '92',
  'plid' => '48',
  'link_path' => 'admin/people/permissions/list',
  'router_path' => 'admin/people/permissions/list',
  'link_title' => 'Permissions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:64:"Determine access to features by selecting permissions for roles.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-8',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '48',
  'p4' => '92',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '93',
  'plid' => '31',
  'link_path' => 'admin/content/comment/new',
  'router_path' => 'admin/content/comment/new',
  'link_title' => 'Published comments',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '9',
  'p3' => '31',
  'p4' => '93',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '94',
  'plid' => '63',
  'link_path' => 'admin/config/services/rss-publishing',
  'router_path' => 'admin/config/services/rss-publishing',
  'link_title' => 'RSS publishing',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:114:"Configure the site description, the number of items per feed and whether feeds should be titles/teasers/full-text.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '63',
  'p4' => '94',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '95',
  'plid' => '50',
  'link_path' => 'admin/config/regional/settings',
  'router_path' => 'admin/config/regional/settings',
  'link_title' => 'Regional settings',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:54:\"Settings for the site's default time zone and country.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '95',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '96',
  'plid' => '48',
  'link_path' => 'admin/people/permissions/roles',
  'router_path' => 'admin/people/permissions/roles',
  'link_title' => 'Roles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:30:"List, edit, or add user roles.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '48',
  'p4' => '96',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '97',
  'plid' => '46',
  'link_path' => 'admin/structure/menu/settings',
  'router_path' => 'admin/structure/menu/settings',
  'link_title' => 'Settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '46',
  'p4' => '97',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '98',
  'plid' => '53',
  'link_path' => 'admin/appearance/settings/seven',
  'router_path' => 'admin/appearance/settings/seven',
  'link_title' => 'Seven',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '53',
  'p4' => '98',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '99',
  'plid' => '55',
  'link_path' => 'admin/config/system/site-information',
  'router_path' => 'admin/config/system/site-information',
  'link_title' => 'Site information',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:104:"Change site name, e-mail address, slogan, default front page, and number of posts per page, error pages.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '55',
  'p4' => '99',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '100',
  'plid' => '53',
  'link_path' => 'admin/appearance/settings/stark',
  'router_path' => 'admin/appearance/settings/stark',
  'link_title' => 'Stark',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '53',
  'p4' => '100',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '101',
  'plid' => '34',
  'link_path' => 'admin/config/content/formats',
  'router_path' => 'admin/config/content/formats',
  'link_title' => 'Text formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:127:"Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '34',
  'p4' => '101',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '102',
  'plid' => '59',
  'link_path' => 'admin/modules/uninstall/confirm',
  'router_path' => 'admin/modules/uninstall/confirm',
  'link_title' => 'Uninstall',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '59',
  'p4' => '102',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '103',
  'plid' => '56',
  'link_path' => 'admin/structure/taxonomy/%',
  'router_path' => 'admin/structure/taxonomy/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '56',
  'p4' => '103',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '104',
  'plid' => '31',
  'link_path' => 'admin/content/comment/approval',
  'router_path' => 'admin/content/comment/approval',
  'link_title' => 'Unapproved comments',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '9',
  'p3' => '31',
  'p4' => '104',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '105',
  'plid' => '39',
  'link_path' => 'user/%/edit/account',
  'router_path' => 'user/%/edit/account',
  'link_title' => 'Account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '16',
  'p2' => '39',
  'p3' => '105',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '106',
  'plid' => '101',
  'link_path' => 'admin/config/content/formats/%',
  'router_path' => 'admin/config/content/formats/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '34',
  'p4' => '101',
  'p5' => '106',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '107',
  'plid' => '83',
  'link_path' => 'admin/config/media/image-styles/add',
  'router_path' => 'admin/config/media/image-styles/add',
  'link_title' => 'Add style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Add a new image style.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '83',
  'p5' => '107',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '108',
  'plid' => '103',
  'link_path' => 'admin/structure/taxonomy/%/add',
  'router_path' => 'admin/structure/taxonomy/%/add',
  'link_title' => 'Add term',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '56',
  'p4' => '103',
  'p5' => '108',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '109',
  'plid' => '101',
  'link_path' => 'admin/config/content/formats/add',
  'router_path' => 'admin/config/content/formats/add',
  'link_title' => 'Add text format',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '34',
  'p4' => '101',
  'p5' => '109',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '110',
  'plid' => '29',
  'link_path' => 'admin/structure/block/list/bartik',
  'router_path' => 'admin/structure/block/list/bartik',
  'link_title' => 'Bartik',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '29',
  'p4' => '110',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '111',
  'plid' => '68',
  'link_path' => 'admin/config/system/actions/configure',
  'router_path' => 'admin/config/system/actions/configure',
  'link_title' => 'Configure an advanced action',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '55',
  'p4' => '68',
  'p5' => '111',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '112',
  'plid' => '46',
  'link_path' => 'admin/structure/menu/manage/%',
  'router_path' => 'admin/structure/menu/manage/%',
  'link_title' => 'Customize menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '46',
  'p4' => '112',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '113',
  'plid' => '103',
  'link_path' => 'admin/structure/taxonomy/%/edit',
  'router_path' => 'admin/structure/taxonomy/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '56',
  'p4' => '103',
  'p5' => '113',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '114',
  'plid' => '35',
  'link_path' => 'admin/structure/types/manage/%',
  'router_path' => 'admin/structure/types/manage/%',
  'link_title' => 'Edit content type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '115',
  'plid' => '76',
  'link_path' => 'admin/config/regional/date-time/formats',
  'router_path' => 'admin/config/regional/date-time/formats',
  'link_title' => 'Formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:51:"Configure display format strings for date and time.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-9',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '76',
  'p5' => '115',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '116',
  'plid' => '29',
  'link_path' => 'admin/structure/block/list/garland',
  'router_path' => 'admin/structure/block/list/garland',
  'link_title' => 'Garland',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '29',
  'p4' => '116',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '117',
  'plid' => '29',
  'link_path' => 'admin/structure/block/list/gizra',
  'router_path' => 'admin/structure/block/list/gizra',
  'link_title' => 'Gizra',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '29',
  'p4' => '117',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '118',
  'plid' => '101',
  'link_path' => 'admin/config/content/formats/list',
  'router_path' => 'admin/config/content/formats/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '34',
  'p4' => '101',
  'p5' => '118',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '119',
  'plid' => '103',
  'link_path' => 'admin/structure/taxonomy/%/list',
  'router_path' => 'admin/structure/taxonomy/%/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '56',
  'p4' => '103',
  'p5' => '119',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '120',
  'plid' => '83',
  'link_path' => 'admin/config/media/image-styles/list',
  'router_path' => 'admin/config/media/image-styles/list',
  'link_title' => 'List',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:42:"List the current image styles on the site.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '83',
  'p5' => '120',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '121',
  'plid' => '68',
  'link_path' => 'admin/config/system/actions/manage',
  'router_path' => 'admin/config/system/actions/manage',
  'link_title' => 'Manage actions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"Manage the actions defined for your site.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '55',
  'p4' => '68',
  'p5' => '121',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '122',
  'plid' => '67',
  'link_path' => 'admin/config/people/accounts/settings',
  'router_path' => 'admin/config/people/accounts/settings',
  'link_title' => 'Settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '47',
  'p4' => '67',
  'p5' => '122',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '123',
  'plid' => '29',
  'link_path' => 'admin/structure/block/list/seven',
  'router_path' => 'admin/structure/block/list/seven',
  'link_title' => 'Seven',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '29',
  'p4' => '123',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '124',
  'plid' => '29',
  'link_path' => 'admin/structure/block/list/stark',
  'router_path' => 'admin/structure/block/list/stark',
  'link_title' => 'Stark',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '29',
  'p4' => '124',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '125',
  'plid' => '76',
  'link_path' => 'admin/config/regional/date-time/types',
  'router_path' => 'admin/config/regional/date-time/types',
  'link_title' => 'Types',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:44:"Configure display formats for date and time.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '76',
  'p5' => '125',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '126',
  'plid' => '51',
  'link_path' => 'node/%/revisions/%/delete',
  'router_path' => 'node/%/revisions/%/delete',
  'link_title' => 'Delete earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '5',
  'p2' => '51',
  'p3' => '126',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '127',
  'plid' => '51',
  'link_path' => 'node/%/revisions/%/revert',
  'router_path' => 'node/%/revisions/%/revert',
  'link_title' => 'Revert to earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '5',
  'p2' => '51',
  'p3' => '127',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '128',
  'plid' => '51',
  'link_path' => 'node/%/revisions/%/view',
  'router_path' => 'node/%/revisions/%/view',
  'link_title' => 'Revisions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '5',
  'p2' => '51',
  'p3' => '128',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '129',
  'plid' => '116',
  'link_path' => 'admin/structure/block/list/garland/add',
  'router_path' => 'admin/structure/block/list/garland/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '29',
  'p4' => '116',
  'p5' => '129',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '130',
  'plid' => '117',
  'link_path' => 'admin/structure/block/list/gizra/add',
  'router_path' => 'admin/structure/block/list/gizra/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '29',
  'p4' => '117',
  'p5' => '130',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '131',
  'plid' => '123',
  'link_path' => 'admin/structure/block/list/seven/add',
  'router_path' => 'admin/structure/block/list/seven/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '29',
  'p4' => '123',
  'p5' => '131',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '132',
  'plid' => '124',
  'link_path' => 'admin/structure/block/list/stark/add',
  'router_path' => 'admin/structure/block/list/stark/add',
  'link_title' => 'Add block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '29',
  'p4' => '124',
  'p5' => '132',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '133',
  'plid' => '125',
  'link_path' => 'admin/config/regional/date-time/types/add',
  'router_path' => 'admin/config/regional/date-time/types/add',
  'link_title' => 'Add date type',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:18:"Add new date type.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '76',
  'p5' => '125',
  'p6' => '133',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '134',
  'plid' => '115',
  'link_path' => 'admin/config/regional/date-time/formats/add',
  'router_path' => 'admin/config/regional/date-time/formats/add',
  'link_title' => 'Add format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Allow users to add additional date formats.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '76',
  'p5' => '115',
  'p6' => '134',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '135',
  'plid' => '112',
  'link_path' => 'admin/structure/menu/manage/%/add',
  'router_path' => 'admin/structure/menu/manage/%/add',
  'link_title' => 'Add link',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '46',
  'p4' => '112',
  'p5' => '135',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '136',
  'plid' => '29',
  'link_path' => 'admin/structure/block/manage/%/%',
  'router_path' => 'admin/structure/block/manage/%/%',
  'link_title' => 'Configure block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '29',
  'p4' => '136',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '137',
  'plid' => '30',
  'link_path' => 'user/%/cancel/confirm/%/%',
  'router_path' => 'user/%/cancel/confirm/%/%',
  'link_title' => 'Confirm account cancellation',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '16',
  'p2' => '30',
  'p3' => '137',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '138',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/delete',
  'router_path' => 'admin/structure/types/manage/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '138',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '139',
  'plid' => '82',
  'link_path' => 'admin/config/people/ip-blocking/delete/%',
  'router_path' => 'admin/config/people/ip-blocking/delete/%',
  'link_title' => 'Delete IP address',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '47',
  'p4' => '82',
  'p5' => '139',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '140',
  'plid' => '68',
  'link_path' => 'admin/config/system/actions/delete/%',
  'router_path' => 'admin/config/system/actions/delete/%',
  'link_title' => 'Delete action',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:17:"Delete an action.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '55',
  'p4' => '68',
  'p5' => '140',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '141',
  'plid' => '112',
  'link_path' => 'admin/structure/menu/manage/%/delete',
  'router_path' => 'admin/structure/menu/manage/%/delete',
  'link_title' => 'Delete menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '46',
  'p4' => '112',
  'p5' => '141',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '142',
  'plid' => '46',
  'link_path' => 'admin/structure/menu/item/%/delete',
  'router_path' => 'admin/structure/menu/item/%/delete',
  'link_title' => 'Delete menu link',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '46',
  'p4' => '142',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '143',
  'plid' => '96',
  'link_path' => 'admin/people/permissions/roles/delete/%',
  'router_path' => 'admin/people/permissions/roles/delete/%',
  'link_title' => 'Delete role',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '48',
  'p4' => '96',
  'p5' => '143',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '144',
  'plid' => '106',
  'link_path' => 'admin/config/content/formats/%/disable',
  'router_path' => 'admin/config/content/formats/%/disable',
  'link_title' => 'Disable text format',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '34',
  'p4' => '101',
  'p5' => '106',
  'p6' => '144',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '145',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/edit',
  'router_path' => 'admin/structure/types/manage/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '145',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '146',
  'plid' => '112',
  'link_path' => 'admin/structure/menu/manage/%/edit',
  'router_path' => 'admin/structure/menu/manage/%/edit',
  'link_title' => 'Edit menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '46',
  'p4' => '112',
  'p5' => '146',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '147',
  'plid' => '46',
  'link_path' => 'admin/structure/menu/item/%/edit',
  'router_path' => 'admin/structure/menu/item/%/edit',
  'link_title' => 'Edit menu link',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '46',
  'p4' => '147',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '148',
  'plid' => '96',
  'link_path' => 'admin/people/permissions/roles/edit/%',
  'router_path' => 'admin/people/permissions/roles/edit/%',
  'link_title' => 'Edit role',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '17',
  'p3' => '48',
  'p4' => '96',
  'p5' => '148',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '149',
  'plid' => '83',
  'link_path' => 'admin/config/media/image-styles/edit/%',
  'router_path' => 'admin/config/media/image-styles/edit/%',
  'link_title' => 'Edit style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:25:"Configure an image style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '83',
  'p5' => '149',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '150',
  'plid' => '112',
  'link_path' => 'admin/structure/menu/manage/%/list',
  'router_path' => 'admin/structure/menu/manage/%/list',
  'link_title' => 'List links',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '46',
  'p4' => '112',
  'p5' => '150',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '151',
  'plid' => '46',
  'link_path' => 'admin/structure/menu/item/%/reset',
  'router_path' => 'admin/structure/menu/item/%/reset',
  'link_title' => 'Reset menu link',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '46',
  'p4' => '151',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '152',
  'plid' => '83',
  'link_path' => 'admin/config/media/image-styles/delete/%',
  'router_path' => 'admin/config/media/image-styles/delete/%',
  'link_title' => 'Delete style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Delete an image style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '83',
  'p5' => '152',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '153',
  'plid' => '83',
  'link_path' => 'admin/config/media/image-styles/revert/%',
  'router_path' => 'admin/config/media/image-styles/revert/%',
  'link_title' => 'Revert style',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:22:"Revert an image style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '83',
  'p5' => '153',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '154',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/comment/display',
  'router_path' => 'admin/structure/types/manage/%/comment/display',
  'link_title' => 'Comment display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '4',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '154',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '155',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/comment/fields',
  'router_path' => 'admin/structure/types/manage/%/comment/fields',
  'link_title' => 'Comment fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '3',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '155',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '156',
  'plid' => '136',
  'link_path' => 'admin/structure/block/manage/%/%/configure',
  'router_path' => 'admin/structure/block/manage/%/%/configure',
  'link_title' => 'Configure block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '29',
  'p4' => '136',
  'p5' => '156',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '157',
  'plid' => '136',
  'link_path' => 'admin/structure/block/manage/%/%/delete',
  'router_path' => 'admin/structure/block/manage/%/%/delete',
  'link_title' => 'Delete block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '29',
  'p4' => '136',
  'p5' => '157',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '158',
  'plid' => '115',
  'link_path' => 'admin/config/regional/date-time/formats/%/delete',
  'router_path' => 'admin/config/regional/date-time/formats/%/delete',
  'link_title' => 'Delete date format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:47:"Allow users to delete a configured date format.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '76',
  'p5' => '115',
  'p6' => '158',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '159',
  'plid' => '125',
  'link_path' => 'admin/config/regional/date-time/types/%/delete',
  'router_path' => 'admin/config/regional/date-time/types/%/delete',
  'link_title' => 'Delete date type',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Allow users to delete a configured date type.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '76',
  'p5' => '125',
  'p6' => '159',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '160',
  'plid' => '115',
  'link_path' => 'admin/config/regional/date-time/formats/%/edit',
  'router_path' => 'admin/config/regional/date-time/formats/%/edit',
  'link_title' => 'Edit date format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Allow users to edit a configured date format.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '50',
  'p4' => '76',
  'p5' => '115',
  'p6' => '160',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '161',
  'plid' => '149',
  'link_path' => 'admin/config/media/image-styles/edit/%/add/%',
  'router_path' => 'admin/config/media/image-styles/edit/%/add/%',
  'link_title' => 'Add image effect',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:28:"Add a new effect to a style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '83',
  'p5' => '149',
  'p6' => '161',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '162',
  'plid' => '149',
  'link_path' => 'admin/config/media/image-styles/edit/%/effects/%',
  'router_path' => 'admin/config/media/image-styles/edit/%/effects/%',
  'link_title' => 'Edit image effect',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Edit an existing effect within a style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '83',
  'p5' => '149',
  'p6' => '162',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '163',
  'plid' => '162',
  'link_path' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'router_path' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'link_title' => 'Delete image effect',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Delete an existing effect from a style.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '45',
  'p4' => '83',
  'p5' => '149',
  'p6' => '162',
  'p7' => '163',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '164',
  'plid' => '46',
  'link_path' => 'admin/structure/menu/manage/main-menu',
  'router_path' => 'admin/structure/menu/manage/%',
  'link_title' => 'Main menu',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '46',
  'p4' => '164',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '165',
  'plid' => '46',
  'link_path' => 'admin/structure/menu/manage/management',
  'router_path' => 'admin/structure/menu/manage/%',
  'link_title' => 'Management',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '46',
  'p4' => '165',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '166',
  'plid' => '46',
  'link_path' => 'admin/structure/menu/manage/navigation',
  'router_path' => 'admin/structure/menu/manage/%',
  'link_title' => 'Navigation',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '46',
  'p4' => '166',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '167',
  'plid' => '46',
  'link_path' => 'admin/structure/menu/manage/user-menu',
  'router_path' => 'admin/structure/menu/manage/%',
  'link_title' => 'User menu',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '46',
  'p4' => '167',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '168',
  'plid' => '16',
  'link_path' => 'user/%/shortcuts',
  'router_path' => 'user/%/shortcuts',
  'link_title' => 'Shortcuts',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '168',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '169',
  'plid' => '60',
  'link_path' => 'admin/config/user-interface/shortcut',
  'router_path' => 'admin/config/user-interface/shortcut',
  'link_title' => 'Shortcuts',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:29:"Add and modify shortcut sets.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '60',
  'p4' => '169',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '170',
  'plid' => '169',
  'link_path' => 'admin/config/user-interface/shortcut/add-set',
  'router_path' => 'admin/config/user-interface/shortcut/add-set',
  'link_title' => 'Add shortcut set',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '60',
  'p4' => '169',
  'p5' => '170',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '171',
  'plid' => '169',
  'link_path' => 'admin/config/user-interface/shortcut/%',
  'router_path' => 'admin/config/user-interface/shortcut/%',
  'link_title' => 'Edit shortcuts',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '60',
  'p4' => '169',
  'p5' => '171',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '172',
  'plid' => '171',
  'link_path' => 'admin/config/user-interface/shortcut/%/add-link',
  'router_path' => 'admin/config/user-interface/shortcut/%/add-link',
  'link_title' => 'Add shortcut',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '60',
  'p4' => '169',
  'p5' => '171',
  'p6' => '172',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '173',
  'plid' => '171',
  'link_path' => 'admin/config/user-interface/shortcut/%/delete',
  'router_path' => 'admin/config/user-interface/shortcut/%/delete',
  'link_title' => 'Delete shortcut set',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '60',
  'p4' => '169',
  'p5' => '171',
  'p6' => '173',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '174',
  'plid' => '171',
  'link_path' => 'admin/config/user-interface/shortcut/%/edit',
  'router_path' => 'admin/config/user-interface/shortcut/%/edit',
  'link_title' => 'Edit set name',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '60',
  'p4' => '169',
  'p5' => '171',
  'p6' => '174',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '175',
  'plid' => '169',
  'link_path' => 'admin/config/user-interface/shortcut/link/%',
  'router_path' => 'admin/config/user-interface/shortcut/link/%',
  'link_title' => 'Edit shortcut',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '60',
  'p4' => '169',
  'p5' => '175',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '176',
  'plid' => '171',
  'link_path' => 'admin/config/user-interface/shortcut/%/links',
  'router_path' => 'admin/config/user-interface/shortcut/%/links',
  'link_title' => 'List links',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '60',
  'p4' => '169',
  'p5' => '171',
  'p6' => '176',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '177',
  'plid' => '175',
  'link_path' => 'admin/config/user-interface/shortcut/link/%/delete',
  'router_path' => 'admin/config/user-interface/shortcut/link/%/delete',
  'link_title' => 'Delete shortcut',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '60',
  'p4' => '169',
  'p5' => '175',
  'p6' => '177',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'shortcut-set-1',
  'mlid' => '178',
  'plid' => '0',
  'link_path' => 'node/add',
  'router_path' => 'node/add',
  'link_title' => 'Add content',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-20',
  'depth' => '1',
  'customized' => '0',
  'p1' => '178',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'shortcut-set-1',
  'mlid' => '179',
  'plid' => '0',
  'link_path' => 'admin/content',
  'router_path' => 'admin/content',
  'link_title' => 'Find content',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-19',
  'depth' => '1',
  'customized' => '0',
  'p1' => '179',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'main-menu',
  'mlid' => '180',
  'plid' => '0',
  'link_path' => '<front>',
  'router_path' => '',
  'link_title' => 'Home',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '1',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '180',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '181',
  'plid' => '0',
  'link_path' => 'search',
  'router_path' => 'search',
  'link_title' => 'Search',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '181',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '182',
  'plid' => '181',
  'link_path' => 'search/node',
  'router_path' => 'search/node',
  'link_title' => 'Content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '181',
  'p2' => '182',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '183',
  'plid' => '181',
  'link_path' => 'search/user',
  'router_path' => 'search/user',
  'link_title' => 'Users',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '181',
  'p2' => '183',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '184',
  'plid' => '1',
  'link_path' => 'admin/help',
  'router_path' => 'admin/help',
  'link_title' => 'Help',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:48:"Reference for usage, configuration, and modules.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '9',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '185',
  'plid' => '6',
  'link_path' => 'node/add/article',
  'router_path' => 'node/add/article',
  'link_title' => 'Article',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:89:"Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '6',
  'p2' => '185',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '186',
  'plid' => '6',
  'link_path' => 'node/add/page',
  'router_path' => 'node/add/page',
  'link_title' => 'Basic page',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:77:\"Use <em>basic pages</em> for your static content, such as an 'About us' page.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '6',
  'p2' => '186',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '187',
  'plid' => '182',
  'link_path' => 'search/node/%',
  'router_path' => 'search/node/%',
  'link_title' => 'Content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '181',
  'p2' => '182',
  'p3' => '187',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '188',
  'plid' => '18',
  'link_path' => 'admin/reports/search',
  'router_path' => 'admin/reports/search',
  'link_title' => 'Top search phrases',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:33:"View most popular search phrases.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '188',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '189',
  'plid' => '183',
  'link_path' => 'search/user/%',
  'router_path' => 'search/user/%',
  'link_title' => 'Users',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '181',
  'p2' => '183',
  'p3' => '189',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '190',
  'plid' => '184',
  'link_path' => 'admin/help/block',
  'router_path' => 'admin/help/block',
  'link_title' => 'block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '190',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '191',
  'plid' => '184',
  'link_path' => 'admin/help/color',
  'router_path' => 'admin/help/color',
  'link_title' => 'color',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '191',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '192',
  'plid' => '184',
  'link_path' => 'admin/help/comment',
  'router_path' => 'admin/help/comment',
  'link_title' => 'comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '192',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '193',
  'plid' => '184',
  'link_path' => 'admin/help/contextual',
  'router_path' => 'admin/help/contextual',
  'link_title' => 'contextual',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '193',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '194',
  'plid' => '184',
  'link_path' => 'admin/help/dashboard',
  'router_path' => 'admin/help/dashboard',
  'link_title' => 'dashboard',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '194',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '195',
  'plid' => '184',
  'link_path' => 'admin/help/dblog',
  'router_path' => 'admin/help/dblog',
  'link_title' => 'dblog',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '195',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '196',
  'plid' => '184',
  'link_path' => 'admin/help/field',
  'router_path' => 'admin/help/field',
  'link_title' => 'field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '196',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '197',
  'plid' => '184',
  'link_path' => 'admin/help/field_sql_storage',
  'router_path' => 'admin/help/field_sql_storage',
  'link_title' => 'field_sql_storage',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '197',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '198',
  'plid' => '184',
  'link_path' => 'admin/help/field_ui',
  'router_path' => 'admin/help/field_ui',
  'link_title' => 'field_ui',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '198',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '199',
  'plid' => '184',
  'link_path' => 'admin/help/file',
  'router_path' => 'admin/help/file',
  'link_title' => 'file',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '199',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '200',
  'plid' => '184',
  'link_path' => 'admin/help/filter',
  'router_path' => 'admin/help/filter',
  'link_title' => 'filter',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '200',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '201',
  'plid' => '184',
  'link_path' => 'admin/help/help',
  'router_path' => 'admin/help/help',
  'link_title' => 'help',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '201',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '202',
  'plid' => '184',
  'link_path' => 'admin/help/image',
  'router_path' => 'admin/help/image',
  'link_title' => 'image',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '202',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '203',
  'plid' => '184',
  'link_path' => 'admin/help/list',
  'router_path' => 'admin/help/list',
  'link_title' => 'list',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '203',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '204',
  'plid' => '184',
  'link_path' => 'admin/help/menu',
  'router_path' => 'admin/help/menu',
  'link_title' => 'menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '204',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '205',
  'plid' => '184',
  'link_path' => 'admin/help/node',
  'router_path' => 'admin/help/node',
  'link_title' => 'node',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '205',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '206',
  'plid' => '184',
  'link_path' => 'admin/help/number',
  'router_path' => 'admin/help/number',
  'link_title' => 'number',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '206',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '207',
  'plid' => '184',
  'link_path' => 'admin/help/options',
  'router_path' => 'admin/help/options',
  'link_title' => 'options',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '207',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '208',
  'plid' => '184',
  'link_path' => 'admin/help/overlay',
  'router_path' => 'admin/help/overlay',
  'link_title' => 'overlay',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '208',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '209',
  'plid' => '184',
  'link_path' => 'admin/help/path',
  'router_path' => 'admin/help/path',
  'link_title' => 'path',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '209',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '210',
  'plid' => '184',
  'link_path' => 'admin/help/rdf',
  'router_path' => 'admin/help/rdf',
  'link_title' => 'rdf',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '210',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '211',
  'plid' => '184',
  'link_path' => 'admin/help/search',
  'router_path' => 'admin/help/search',
  'link_title' => 'search',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '211',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '212',
  'plid' => '184',
  'link_path' => 'admin/help/shortcut',
  'router_path' => 'admin/help/shortcut',
  'link_title' => 'shortcut',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '212',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '213',
  'plid' => '184',
  'link_path' => 'admin/help/system',
  'router_path' => 'admin/help/system',
  'link_title' => 'system',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '213',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '214',
  'plid' => '184',
  'link_path' => 'admin/help/taxonomy',
  'router_path' => 'admin/help/taxonomy',
  'link_title' => 'taxonomy',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '214',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '215',
  'plid' => '184',
  'link_path' => 'admin/help/text',
  'router_path' => 'admin/help/text',
  'link_title' => 'text',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '215',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '216',
  'plid' => '184',
  'link_path' => 'admin/help/toolbar',
  'router_path' => 'admin/help/toolbar',
  'link_title' => 'toolbar',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '216',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '217',
  'plid' => '184',
  'link_path' => 'admin/help/user',
  'router_path' => 'admin/help/user',
  'link_title' => 'user',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '217',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '218',
  'plid' => '52',
  'link_path' => 'admin/config/search/settings',
  'router_path' => 'admin/config/search/settings',
  'link_title' => 'Search settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:67:"Configure relevance settings for search and other indexing options.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '52',
  'p4' => '218',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '219',
  'plid' => '52',
  'link_path' => 'admin/config/search/path',
  'router_path' => 'admin/config/search/path',
  'link_title' => 'URL aliases',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:46:\"Change your site's URL paths by aliasing them.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '52',
  'p4' => '219',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '220',
  'plid' => '219',
  'link_path' => 'admin/config/search/path/add',
  'router_path' => 'admin/config/search/path/add',
  'link_title' => 'Add alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '52',
  'p4' => '219',
  'p5' => '220',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '221',
  'plid' => '218',
  'link_path' => 'admin/config/search/settings/reindex',
  'router_path' => 'admin/config/search/settings/reindex',
  'link_title' => 'Clear index',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '52',
  'p4' => '218',
  'p5' => '221',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '222',
  'plid' => '219',
  'link_path' => 'admin/config/search/path/list',
  'router_path' => 'admin/config/search/path/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '52',
  'p4' => '219',
  'p5' => '222',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '223',
  'plid' => '219',
  'link_path' => 'admin/config/search/path/delete/%',
  'router_path' => 'admin/config/search/path/delete/%',
  'link_title' => 'Delete alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '52',
  'p4' => '219',
  'p5' => '223',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '224',
  'plid' => '219',
  'link_path' => 'admin/config/search/path/edit/%',
  'router_path' => 'admin/config/search/path/edit/%',
  'link_title' => 'Edit alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '52',
  'p4' => '219',
  'p5' => '224',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '225',
  'plid' => '15',
  'link_path' => 'admin/modules/install',
  'router_path' => 'admin/modules/install',
  'link_title' => 'Install new module',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '25',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '225',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '226',
  'plid' => '7',
  'link_path' => 'admin/appearance/install',
  'router_path' => 'admin/appearance/install',
  'link_title' => 'Install new theme',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '25',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '226',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '227',
  'plid' => '15',
  'link_path' => 'admin/modules/update',
  'router_path' => 'admin/modules/update',
  'link_title' => 'Update',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '15',
  'p3' => '227',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '228',
  'plid' => '18',
  'link_path' => 'admin/reports/updates',
  'router_path' => 'admin/reports/updates',
  'link_title' => 'Available updates',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:82:"Get a status report about available updates for your installed modules and themes.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-50',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '228',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '229',
  'plid' => '7',
  'link_path' => 'admin/appearance/update',
  'router_path' => 'admin/appearance/update',
  'link_title' => 'Update',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '7',
  'p3' => '229',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '230',
  'plid' => '184',
  'link_path' => 'admin/help/update',
  'router_path' => 'admin/help/update',
  'link_title' => 'update',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '230',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '231',
  'plid' => '228',
  'link_path' => 'admin/reports/updates/install',
  'router_path' => 'admin/reports/updates/install',
  'link_title' => 'Install new module or theme',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '25',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '228',
  'p4' => '231',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '232',
  'plid' => '228',
  'link_path' => 'admin/reports/updates/list',
  'router_path' => 'admin/reports/updates/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '228',
  'p4' => '232',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '233',
  'plid' => '228',
  'link_path' => 'admin/reports/updates/settings',
  'router_path' => 'admin/reports/updates/settings',
  'link_title' => 'Settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '50',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '228',
  'p4' => '233',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '234',
  'plid' => '228',
  'link_path' => 'admin/reports/updates/update',
  'router_path' => 'admin/reports/updates/update',
  'link_title' => 'Update',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '18',
  'p3' => '228',
  'p4' => '234',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '235',
  'plid' => '103',
  'link_path' => 'admin/structure/taxonomy/%/display',
  'router_path' => 'admin/structure/taxonomy/%/display',
  'link_title' => 'Manage display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '56',
  'p4' => '103',
  'p5' => '235',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '236',
  'plid' => '67',
  'link_path' => 'admin/config/people/accounts/display',
  'router_path' => 'admin/config/people/accounts/display',
  'link_title' => 'Manage display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '47',
  'p4' => '67',
  'p5' => '236',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '237',
  'plid' => '103',
  'link_path' => 'admin/structure/taxonomy/%/fields',
  'router_path' => 'admin/structure/taxonomy/%/fields',
  'link_title' => 'Manage fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '56',
  'p4' => '103',
  'p5' => '237',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '238',
  'plid' => '67',
  'link_path' => 'admin/config/people/accounts/fields',
  'router_path' => 'admin/config/people/accounts/fields',
  'link_title' => 'Manage fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '47',
  'p4' => '67',
  'p5' => '238',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '239',
  'plid' => '235',
  'link_path' => 'admin/structure/taxonomy/%/display/default',
  'router_path' => 'admin/structure/taxonomy/%/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '56',
  'p4' => '103',
  'p5' => '235',
  'p6' => '239',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '240',
  'plid' => '236',
  'link_path' => 'admin/config/people/accounts/display/default',
  'router_path' => 'admin/config/people/accounts/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '47',
  'p4' => '67',
  'p5' => '236',
  'p6' => '240',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '241',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/display',
  'router_path' => 'admin/structure/types/manage/%/display',
  'link_title' => 'Manage display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '241',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '242',
  'plid' => '114',
  'link_path' => 'admin/structure/types/manage/%/fields',
  'router_path' => 'admin/structure/types/manage/%/fields',
  'link_title' => 'Manage fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '242',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '243',
  'plid' => '235',
  'link_path' => 'admin/structure/taxonomy/%/display/full',
  'router_path' => 'admin/structure/taxonomy/%/display/full',
  'link_title' => 'Taxonomy term page',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '56',
  'p4' => '103',
  'p5' => '235',
  'p6' => '243',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '244',
  'plid' => '236',
  'link_path' => 'admin/config/people/accounts/display/full',
  'router_path' => 'admin/config/people/accounts/display/full',
  'link_title' => 'User account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '47',
  'p4' => '67',
  'p5' => '236',
  'p6' => '244',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '245',
  'plid' => '237',
  'link_path' => 'admin/structure/taxonomy/%/fields/%',
  'router_path' => 'admin/structure/taxonomy/%/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '56',
  'p4' => '103',
  'p5' => '237',
  'p6' => '245',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '246',
  'plid' => '238',
  'link_path' => 'admin/config/people/accounts/fields/%',
  'router_path' => 'admin/config/people/accounts/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '47',
  'p4' => '67',
  'p5' => '238',
  'p6' => '246',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '247',
  'plid' => '241',
  'link_path' => 'admin/structure/types/manage/%/display/default',
  'router_path' => 'admin/structure/types/manage/%/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '241',
  'p6' => '247',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '248',
  'plid' => '241',
  'link_path' => 'admin/structure/types/manage/%/display/full',
  'router_path' => 'admin/structure/types/manage/%/display/full',
  'link_title' => 'Full content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '241',
  'p6' => '248',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '249',
  'plid' => '241',
  'link_path' => 'admin/structure/types/manage/%/display/rss',
  'router_path' => 'admin/structure/types/manage/%/display/rss',
  'link_title' => 'RSS',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '241',
  'p6' => '249',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '250',
  'plid' => '241',
  'link_path' => 'admin/structure/types/manage/%/display/search_index',
  'router_path' => 'admin/structure/types/manage/%/display/search_index',
  'link_title' => 'Search index',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '3',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '241',
  'p6' => '250',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '251',
  'plid' => '241',
  'link_path' => 'admin/structure/types/manage/%/display/search_result',
  'router_path' => 'admin/structure/types/manage/%/display/search_result',
  'link_title' => 'Search result',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '4',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '241',
  'p6' => '251',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '252',
  'plid' => '241',
  'link_path' => 'admin/structure/types/manage/%/display/teaser',
  'router_path' => 'admin/structure/types/manage/%/display/teaser',
  'link_title' => 'Teaser',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '241',
  'p6' => '252',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '253',
  'plid' => '242',
  'link_path' => 'admin/structure/types/manage/%/fields/%',
  'router_path' => 'admin/structure/types/manage/%/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '242',
  'p6' => '253',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '254',
  'plid' => '245',
  'link_path' => 'admin/structure/taxonomy/%/fields/%/delete',
  'router_path' => 'admin/structure/taxonomy/%/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '56',
  'p4' => '103',
  'p5' => '237',
  'p6' => '245',
  'p7' => '254',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '255',
  'plid' => '245',
  'link_path' => 'admin/structure/taxonomy/%/fields/%/edit',
  'router_path' => 'admin/structure/taxonomy/%/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '56',
  'p4' => '103',
  'p5' => '237',
  'p6' => '245',
  'p7' => '255',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '256',
  'plid' => '245',
  'link_path' => 'admin/structure/taxonomy/%/fields/%/field-settings',
  'router_path' => 'admin/structure/taxonomy/%/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '56',
  'p4' => '103',
  'p5' => '237',
  'p6' => '245',
  'p7' => '256',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '257',
  'plid' => '245',
  'link_path' => 'admin/structure/taxonomy/%/fields/%/widget-type',
  'router_path' => 'admin/structure/taxonomy/%/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '56',
  'p4' => '103',
  'p5' => '237',
  'p6' => '245',
  'p7' => '257',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '258',
  'plid' => '246',
  'link_path' => 'admin/config/people/accounts/fields/%/delete',
  'router_path' => 'admin/config/people/accounts/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '47',
  'p4' => '67',
  'p5' => '238',
  'p6' => '246',
  'p7' => '258',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '259',
  'plid' => '246',
  'link_path' => 'admin/config/people/accounts/fields/%/edit',
  'router_path' => 'admin/config/people/accounts/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '47',
  'p4' => '67',
  'p5' => '238',
  'p6' => '246',
  'p7' => '259',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '260',
  'plid' => '246',
  'link_path' => 'admin/config/people/accounts/fields/%/field-settings',
  'router_path' => 'admin/config/people/accounts/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '47',
  'p4' => '67',
  'p5' => '238',
  'p6' => '246',
  'p7' => '260',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '261',
  'plid' => '246',
  'link_path' => 'admin/config/people/accounts/fields/%/widget-type',
  'router_path' => 'admin/config/people/accounts/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '47',
  'p4' => '67',
  'p5' => '238',
  'p6' => '246',
  'p7' => '261',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '262',
  'plid' => '154',
  'link_path' => 'admin/structure/types/manage/%/comment/display/default',
  'router_path' => 'admin/structure/types/manage/%/comment/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '154',
  'p6' => '262',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '263',
  'plid' => '154',
  'link_path' => 'admin/structure/types/manage/%/comment/display/full',
  'router_path' => 'admin/structure/types/manage/%/comment/display/full',
  'link_title' => 'Full comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '154',
  'p6' => '263',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '264',
  'plid' => '155',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '155',
  'p6' => '264',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '265',
  'plid' => '253',
  'link_path' => 'admin/structure/types/manage/%/fields/%/delete',
  'router_path' => 'admin/structure/types/manage/%/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '242',
  'p6' => '253',
  'p7' => '265',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '266',
  'plid' => '253',
  'link_path' => 'admin/structure/types/manage/%/fields/%/edit',
  'router_path' => 'admin/structure/types/manage/%/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '242',
  'p6' => '253',
  'p7' => '266',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '267',
  'plid' => '253',
  'link_path' => 'admin/structure/types/manage/%/fields/%/field-settings',
  'router_path' => 'admin/structure/types/manage/%/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '242',
  'p6' => '253',
  'p7' => '267',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '268',
  'plid' => '253',
  'link_path' => 'admin/structure/types/manage/%/fields/%/widget-type',
  'router_path' => 'admin/structure/types/manage/%/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '242',
  'p6' => '253',
  'p7' => '268',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '269',
  'plid' => '264',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%/delete',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '155',
  'p6' => '264',
  'p7' => '269',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '270',
  'plid' => '264',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%/edit',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '155',
  'p6' => '264',
  'p7' => '270',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '271',
  'plid' => '264',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%/field-settings',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '155',
  'p6' => '264',
  'p7' => '271',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '272',
  'plid' => '264',
  'link_path' => 'admin/structure/types/manage/%/comment/fields/%/widget-type',
  'router_path' => 'admin/structure/types/manage/%/comment/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '20',
  'p3' => '35',
  'p4' => '114',
  'p5' => '155',
  'p6' => '264',
  'p7' => '272',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '273',
  'plid' => '0',
  'link_path' => 'group/%/group',
  'router_path' => 'group/%/group',
  'link_title' => 'Group',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '273',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '274',
  'plid' => '0',
  'link_path' => 'og_membership/%/group',
  'router_path' => 'og_membership/%/group',
  'link_title' => 'Group',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '274',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '275',
  'plid' => '0',
  'link_path' => 'og_membership_type/%/group',
  'router_path' => 'og_membership_type/%/group',
  'link_title' => 'Group',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '275',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '276',
  'plid' => '0',
  'link_path' => 'taxonomy_term/%/group',
  'router_path' => 'taxonomy_term/%/group',
  'link_title' => 'Group',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '276',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '277',
  'plid' => '3',
  'link_path' => 'comment/%/group',
  'router_path' => 'comment/%/group',
  'link_title' => 'Group',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '3',
  'p2' => '277',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '278',
  'plid' => '5',
  'link_path' => 'node/%/group',
  'router_path' => 'node/%/group',
  'link_title' => 'Group',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '5',
  'p2' => '278',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '279',
  'plid' => '16',
  'link_path' => 'user/%/group',
  'router_path' => 'user/%/group',
  'link_title' => 'Group',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '16',
  'p2' => '279',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '280',
  'plid' => '8',
  'link_path' => 'admin/config/group',
  'router_path' => 'admin/config/group',
  'link_title' => 'Organic groups',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:47:"Administer the suite of Organic groups modules.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '281',
  'plid' => '184',
  'link_path' => 'admin/help/og',
  'router_path' => 'admin/help/og',
  'link_title' => 'og',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '184',
  'p3' => '281',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '282',
  'plid' => '280',
  'link_path' => 'admin/config/group/fields',
  'router_path' => 'admin/config/group/fields',
  'link_title' => 'Organic groups field settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Configure Organic groups fields in bundles.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '282',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '283',
  'plid' => '280',
  'link_path' => 'admin/config/group/permissions',
  'router_path' => 'admin/config/group/permissions',
  'link_title' => 'Organic groups global permissions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:44:"Configure Organic groups global permissions.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '283',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '284',
  'plid' => '280',
  'link_path' => 'admin/config/group/roles',
  'router_path' => 'admin/config/group/roles',
  'link_title' => 'Organic groups global roles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:38:"Configure Organic groups global roles.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '284',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '285',
  'plid' => '280',
  'link_path' => 'admin/config/group/group-membership',
  'router_path' => 'admin/config/group/group-membership',
  'link_title' => 'OG membership types',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:48:"Manage group memberships type, including fields.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '285',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '286',
  'plid' => '280',
  'link_path' => 'admin/config/group/settings',
  'router_path' => 'admin/config/group/settings',
  'link_title' => 'Organic groups settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:39:"Administer the Organic groups settings.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '286',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '287',
  'plid' => '0',
  'link_path' => 'group/%/%/admin/people',
  'router_path' => 'group/%/%/admin/people',
  'link_title' => '',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:30:"Find and manage group members.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-4',
  'depth' => '1',
  'customized' => '0',
  'p1' => '287',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '288',
  'plid' => '285',
  'link_path' => 'admin/config/group/group-membership/add',
  'router_path' => 'admin/config/group/group-membership/add',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '285',
  'p5' => '288',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '289',
  'plid' => '285',
  'link_path' => 'admin/config/group/group-membership/import',
  'router_path' => 'admin/config/group/group-membership/import',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '285',
  'p5' => '289',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '290',
  'plid' => '285',
  'link_path' => 'admin/config/group/group-membership/list',
  'router_path' => 'admin/config/group/group-membership/list',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '285',
  'p5' => '290',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '291',
  'plid' => '287',
  'link_path' => 'group/%/%/admin/people/permissions',
  'router_path' => 'group/%/%/admin/people/permissions',
  'link_title' => '',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:64:"Determine access to features by selecting permissions for roles.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-8',
  'depth' => '2',
  'customized' => '0',
  'p1' => '287',
  'p2' => '291',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '292',
  'plid' => '287',
  'link_path' => 'group/%/%/admin/people/add-user',
  'router_path' => 'group/%/%/admin/people/add-user',
  'link_title' => 'Add members',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '2',
  'customized' => '0',
  'p1' => '287',
  'p2' => '292',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '293',
  'plid' => '287',
  'link_path' => 'group/%/%/admin/people/roles',
  'router_path' => 'group/%/%/admin/people/roles',
  'link_title' => '',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:30:"List, edit, or add user roles.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-9',
  'depth' => '2',
  'customized' => '0',
  'p1' => '287',
  'p2' => '293',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '294',
  'plid' => '285',
  'link_path' => 'admin/config/group/group-membership/manage/%',
  'router_path' => 'admin/config/group/group-membership/manage/%',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '285',
  'p5' => '294',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '295',
  'plid' => '294',
  'link_path' => 'admin/config/group/group-membership/manage/%/display',
  'router_path' => 'admin/config/group/group-membership/manage/%/display',
  'link_title' => 'Manage display',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '285',
  'p5' => '294',
  'p6' => '295',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '296',
  'plid' => '294',
  'link_path' => 'admin/config/group/group-membership/manage/%/fields',
  'router_path' => 'admin/config/group/group-membership/manage/%/fields',
  'link_title' => 'Manage fields',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '285',
  'p5' => '294',
  'p6' => '296',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '297',
  'plid' => '294',
  'link_path' => 'admin/config/group/group-membership/manage/%/%',
  'router_path' => 'admin/config/group/group-membership/manage/%/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '285',
  'p5' => '294',
  'p6' => '297',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '298',
  'plid' => '294',
  'link_path' => 'admin/config/group/group-membership/manage/%/edit',
  'router_path' => 'admin/config/group/group-membership/manage/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '285',
  'p5' => '294',
  'p6' => '298',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '299',
  'plid' => '294',
  'link_path' => 'admin/config/group/group-membership/manage/%/clone',
  'router_path' => 'admin/config/group/group-membership/manage/%/clone',
  'link_title' => 'Clone',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '6',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '285',
  'p5' => '294',
  'p6' => '299',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '300',
  'plid' => '295',
  'link_path' => 'admin/config/group/group-membership/manage/%/display/default',
  'router_path' => 'admin/config/group/group-membership/manage/%/display/default',
  'link_title' => 'Default',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '285',
  'p5' => '294',
  'p6' => '295',
  'p7' => '300',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '301',
  'plid' => '296',
  'link_path' => 'admin/config/group/group-membership/manage/%/fields/%',
  'router_path' => 'admin/config/group/group-membership/manage/%/fields/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '7',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '285',
  'p5' => '294',
  'p6' => '296',
  'p7' => '301',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '302',
  'plid' => '282',
  'link_path' => 'admin/config/group/fields/%/%/%/delete',
  'router_path' => 'admin/config/group/fields/%/%/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Delete an Organic groups field from a bundle.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '5',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '282',
  'p5' => '302',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '303',
  'plid' => '301',
  'link_path' => 'admin/config/group/group-membership/manage/%/fields/%/delete',
  'router_path' => 'admin/config/group/group-membership/manage/%/fields/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '8',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '285',
  'p5' => '294',
  'p6' => '296',
  'p7' => '301',
  'p8' => '303',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '304',
  'plid' => '301',
  'link_path' => 'admin/config/group/group-membership/manage/%/fields/%/edit',
  'router_path' => 'admin/config/group/group-membership/manage/%/fields/%/edit',
  'link_title' => 'Edit',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '8',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '285',
  'p5' => '294',
  'p6' => '296',
  'p7' => '301',
  'p8' => '304',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '305',
  'plid' => '301',
  'link_path' => 'admin/config/group/group-membership/manage/%/fields/%/field-settings',
  'router_path' => 'admin/config/group/group-membership/manage/%/fields/%/field-settings',
  'link_title' => 'Field settings',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '8',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '285',
  'p5' => '294',
  'p6' => '296',
  'p7' => '301',
  'p8' => '305',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'management',
  'mlid' => '306',
  'plid' => '301',
  'link_path' => 'admin/config/group/group-membership/manage/%/fields/%/widget-type',
  'router_path' => 'admin/config/group/group-membership/manage/%/fields/%/widget-type',
  'link_title' => 'Widget type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '8',
  'customized' => '0',
  'p1' => '1',
  'p2' => '8',
  'p3' => '280',
  'p4' => '285',
  'p5' => '294',
  'p6' => '296',
  'p7' => '301',
  'p8' => '306',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '307',
  'plid' => '6',
  'link_path' => 'node/add/school',
  'router_path' => 'node/add/school',
  'link_title' => 'School',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '6',
  'p2' => '307',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '308',
  'plid' => '6',
  'link_path' => 'node/add/class',
  'router_path' => 'node/add/class',
  'link_title' => 'Class',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '6',
  'p2' => '308',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->execute();

db_create_table('menu_router', array(
  'fields' => array(
    'path' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'load_functions' => array(
      'type' => 'blob',
      'not null' => TRUE,
    ),
    'to_arg_functions' => array(
      'type' => 'blob',
      'not null' => TRUE,
    ),
    'access_callback' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'access_arguments' => array(
      'type' => 'blob',
      'not null' => FALSE,
    ),
    'page_callback' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'page_arguments' => array(
      'type' => 'blob',
      'not null' => FALSE,
    ),
    'delivery_callback' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'fit' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'number_parts' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'small',
    ),
    'context' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'tab_parent' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'tab_root' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'title_callback' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'title_arguments' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'theme_callback' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'theme_arguments' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'type' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
    ),
    'position' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'include_file' => array(
      'type' => 'text',
      'size' => 'medium',
    ),
  ),
  'indexes' => array(
    'fit' => array(
      'fit',
    ),
    'tab_parent' => array(
      array(
        'tab_parent',
        64,
      ),
      'weight',
      'title',
    ),
    'tab_root_weight_title' => array(
      array(
        'tab_root',
        64,
      ),
      'weight',
      'title',
    ),
  ),
  'primary key' => array(
    'path',
  ),
  'module' => 'system',
  'name' => 'menu_router',
));
db_insert('menu_router')->fields(array(
  'path',
  'load_functions',
  'to_arg_functions',
  'access_callback',
  'access_arguments',
  'page_callback',
  'page_arguments',
  'delivery_callback',
  'fit',
  'number_parts',
  'context',
  'tab_parent',
  'tab_root',
  'title',
  'title_callback',
  'title_arguments',
  'theme_callback',
  'theme_arguments',
  'type',
  'description',
  'position',
  'weight',
  'include_file',
))
->values(array(
  'path' => 'admin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin',
  'title' => 'Administration',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '9',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_themes_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance',
  'title' => 'Appearance',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Select and configure your themes.',
  'position' => 'left',
  'weight' => '-6',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/default',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_theme_default',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance/default',
  'title' => 'Set default theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/disable',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_theme_disable',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance/disable',
  'title' => 'Disable theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/enable',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_theme_enable',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/appearance/enable',
  'title' => 'Enable theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/install',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'update_manager_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"update_manager_install_form";i:1;s:5:"theme";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/appearance',
  'tab_root' => 'admin/appearance',
  'title' => 'Install new theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '25',
  'include_file' => 'modules/update/update.manager.inc',
))
->values(array(
  'path' => 'admin/appearance/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'system_themes_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/appearance',
  'tab_root' => 'admin/appearance',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Select and configure your theme',
  'position' => '',
  'weight' => '-1',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/appearance',
  'tab_root' => 'admin/appearance',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Configure default and theme specific settings.',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/bartik',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:25:"themes/bartik/bartik.info";s:4:"name";s:6:"bartik";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:16:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:20:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";s:14:"dashboard_main";s:16:"Dashboard (main)";s:17:"dashboard_sidebar";s:19:"Dashboard (sidebar)";s:18:"dashboard_inactive";s:20:"Dashboard (inactive)";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:15:"overlay_regions";a:5:{i:0;s:14:"dashboard_main";i:1;s:17:"dashboard_sidebar";i:2;s:18:"dashboard_inactive";i:3;s:7:"content";i:4;s:4:"help";}s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Bartik',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:16:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:6:"engine";s:11:"phptemplate";s:7:"regions";a:12:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:14:"dashboard_main";s:16:"Dashboard (main)";s:17:"dashboard_sidebar";s:19:"Dashboard (sidebar)";s:18:"dashboard_inactive";s:20:"Dashboard (inactive)";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:15:"overlay_regions";a:5:{i:0;s:14:"dashboard_main";i:1;s:17:"dashboard_sidebar";i:2;s:18:"dashboard_inactive";i:3;s:7:"content";i:4;s:4:"help";}s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:7:"garland";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/gizra',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:33:"sites/all/themes/gizra/gizra.info";s:4:"name";s:5:"gizra";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:5:"Gizra";s:11:"description";s:18:"Gizra custom theme";s:10:"screenshot";s:39:"sites/all/themes/gizra/images/gizra.png";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:22:"styles/sub_sasson.scss";s:45:"sites/all/themes/gizra/styles/sub_sasson.scss";}}s:7:"regions";a:15:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:11:"content_top";s:11:"Content top";s:7:"content";s:7:"Content";s:14:"content_bottom";s:14:"Content bottom";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:6:"footer";s:6:"Footer";s:14:"dashboard_main";s:16:"Dashboard (main)";s:17:"dashboard_sidebar";s:19:"Dashboard (sidebar)";s:18:"dashboard_inactive";s:20:"Dashboard (inactive)";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:15:"overlay_regions";a:5:{i:0;s:14:"dashboard_main";i:1;s:17:"dashboard_sidebar";i:2;s:18:"dashboard_inactive";i:3;s:7:"content";i:4;s:4:"help";}s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:22:"styles/sub_sasson.scss";s:45:"sites/all/themes/gizra/styles/sub_sasson.scss";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:5:"gizra";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Gizra',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/global',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer themes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Global settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-1',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/seven',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:23:"themes/seven/seven.info";s:4:"name";s:5:"seven";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:16:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:8:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";s:14:"dashboard_main";s:16:"Dashboard (main)";s:17:"dashboard_sidebar";s:19:"Dashboard (sidebar)";s:18:"dashboard_inactive";s:20:"Dashboard (inactive)";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:15:"overlay_regions";a:5:{i:0;s:14:"dashboard_main";i:1;s:17:"dashboard_sidebar";i:2;s:18:"dashboard_inactive";i:3;s:7:"content";i:4;s:4:"help";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:5:"seven";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Seven',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/settings/stark',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => "a:1:{i:0;O:8:\"stdClass\":11:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:15:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:8:\"7.15-dev\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:12:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:15:\"overlay_regions\";a:5:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";i:3;s:7:\"content\";i:4;s:4:\"help\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}",
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:5:"stark";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/appearance/settings',
  'tab_root' => 'admin/appearance',
  'title' => 'Stark',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/appearance/update',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'update_manager_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"update_manager_update_form";i:1;s:5:"theme";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/appearance',
  'tab_root' => 'admin/appearance',
  'title' => 'Update',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/update/update.manager.inc',
))
->values(array(
  'path' => 'admin/compact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_compact_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/compact',
  'title' => 'Compact mode',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_config_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config',
  'title' => 'Configuration',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Administer settings.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/content',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content',
  'title' => 'Content authoring',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Settings related to formatting and authoring content.',
  'position' => 'left',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"filter_admin_overview";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/formats',
  'title' => 'Text formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats/%',
  'load_functions' => 'a:1:{i:4;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/formats/%',
  'title' => '',
  'title_callback' => 'filter_admin_format_title',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats/%/disable',
  'load_functions' => 'a:1:{i:4;s:18:"filter_format_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_filter_disable_format_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"filter_admin_disable";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/content/formats/%/disable',
  'title' => 'Disable text format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'filter_admin_format_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/content/formats',
  'tab_root' => 'admin/config/content/formats',
  'title' => 'Add text format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/content/formats/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer filters";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"filter_admin_overview";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/content/formats',
  'tab_root' => 'admin/config/content/formats',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.admin.inc',
))
->values(array(
  'path' => 'admin/config/development',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development',
  'title' => 'Development',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Development tools.',
  'position' => 'right',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/development/logging',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:23:"system_logging_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development/logging',
  'title' => 'Logging and errors',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Settings for logging and alerts modules. Various modules can route Drupal's system events to different destinations, such as syslog, database, email, etc.",
  'position' => '',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/development/maintenance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:28:"system_site_maintenance_mode";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development/maintenance',
  'title' => 'Maintenance mode',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Take the site offline for maintenance or bring it back online.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/development/performance',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_performance_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/development/performance',
  'title' => 'Performance',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/group',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer group";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/group',
  'title' => 'Organic groups',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Administer the suite of Organic groups modules.',
  'position' => 'right',
  'weight' => '-5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/group/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer group";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"og_ui_field_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/group/fields',
  'title' => 'Organic groups field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure Organic groups fields in bundles.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/og/og_ui/og_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/group/fields/%/%/%/delete',
  'load_functions' => 'a:3:{i:4;N;i:5;N;i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;i:4;i:1;i:5;i:2;i:5;i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer group";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"og_ui_field_delete_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '241',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/config/group/fields',
  'tab_root' => 'admin/config/group/fields',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Delete an Organic groups field from a bundle.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/og/og_ui/og_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/group/group-membership',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'entity_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;s:18:"og_membership_type";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:32:"og_membership_type_overview_form";i:1;s:18:"og_membership_type";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/group/group-membership',
  'title' => 'OG membership types',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage group memberships type, including fields.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/entity/includes/entity.ui.inc',
))
->values(array(
  'path' => 'admin/config/group/group-membership/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'entity_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:18:"og_membership_type";}',
  'page_callback' => 'entity_ui_get_form',
  'page_arguments' => 'a:3:{i:0;s:18:"og_membership_type";i:1;N;i:2;s:3:"add";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/group/group-membership',
  'tab_root' => 'admin/config/group/group-membership',
  'title' => '',
  'title_callback' => 'entity_ui_get_action_title',
  'title_arguments' => 'a:2:{i:0;s:3:"add";i:1;s:18:"og_membership_type";}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/og/includes/og.admin.inc',
))
->values(array(
  'path' => 'admin/config/group/group-membership/import',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'entity_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:18:"og_membership_type";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:33:"og_membership_type_operation_form";i:1;s:18:"og_membership_type";i:2;N;i:3;s:6:"import";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/group/group-membership',
  'tab_root' => 'admin/config/group/group-membership',
  'title' => '',
  'title_callback' => 'entity_ui_get_action_title',
  'title_arguments' => 'a:2:{i:0;s:6:"import";i:1;s:18:"og_membership_type";}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/entity/includes/entity.ui.inc',
))
->values(array(
  'path' => 'admin/config/group/group-membership/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'entity_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;s:18:"og_membership_type";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:32:"og_membership_type_overview_form";i:1;s:18:"og_membership_type";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/group/group-membership',
  'tab_root' => 'admin/config/group/group-membership',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'sites/all/modules/entity/includes/entity.ui.inc',
))
->values(array(
  'path' => 'admin/config/group/group-membership/manage/%',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"entity_object_load";a:1:{i:0;s:18:"og_membership_type";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_access',
  'access_arguments' => 'a:3:{i:0;s:6:"update";i:1;s:18:"og_membership_type";i:2;i:5;}',
  'page_callback' => 'entity_ui_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"og_membership_type";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/group/group-membership/manage/%',
  'title' => 'Edit',
  'title_callback' => 'entity_label',
  'title_arguments' => 'a:2:{i:0;s:18:"og_membership_type";i:1;i:5;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/og/includes/og.admin.inc',
))
->values(array(
  'path' => 'admin/config/group/group-membership/manage/%/%',
  'load_functions' => 'a:2:{i:5;a:1:{s:18:"entity_object_load";a:1:{i:0;s:18:"og_membership_type";}}i:6;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_access',
  'access_arguments' => 'a:3:{i:0;s:6:"delete";i:1;s:18:"og_membership_type";i:2;i:5;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:33:"og_membership_type_operation_form";i:1;s:18:"og_membership_type";i:2;i:5;i:3;i:6;}',
  'delivery_callback' => '',
  'fit' => '124',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/group/group-membership/manage/%/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/entity/includes/entity.ui.inc',
))
->values(array(
  'path' => 'admin/config/group/group-membership/manage/%/clone',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"entity_object_load";a:1:{i:0;s:18:"og_membership_type";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:18:"og_membership_type";}',
  'page_callback' => 'entity_ui_get_form',
  'page_arguments' => 'a:3:{i:0;s:18:"og_membership_type";i:1;i:5;i:2;s:5:"clone";}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/group/group-membership/manage/%/clone',
  'title' => 'Clone',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/og/includes/og.admin.inc',
))
->values(array(
  'path' => 'admin/config/group/group-membership/manage/%/display',
  'load_functions' => 'a:1:{i:5;s:23:"og_membership_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer group";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:13:"og_membership";i:2;i:5;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/group/group-membership/manage/%',
  'tab_root' => 'admin/config/group/group-membership/manage/%',
  'title' => 'Manage display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/group/group-membership/manage/%/display/default',
  'load_functions' => 'a:1:{i:5;s:23:"og_membership_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:5:{i:0;s:13:"og_membership";i:1;i:5;i:2;s:7:"default";i:3;s:11:"user_access";i:4;s:16:"administer group";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:13:"og_membership";i:2;i:5;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '251',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/config/group/group-membership/manage/%/display',
  'tab_root' => 'admin/config/group/group-membership/manage/%',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/group/group-membership/manage/%/edit',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"entity_object_load";a:1:{i:0;s:18:"og_membership_type";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'entity_access',
  'access_arguments' => 'a:3:{i:0;s:6:"update";i:1;s:18:"og_membership_type";i:2;i:5;}',
  'page_callback' => 'entity_ui_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"og_membership_type";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/group/group-membership/manage/%',
  'tab_root' => 'admin/config/group/group-membership/manage/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/og/includes/og.admin.inc',
))
->values(array(
  'path' => 'admin/config/group/group-membership/manage/%/fields',
  'load_functions' => 'a:1:{i:5;s:23:"og_membership_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer group";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:13:"og_membership";i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/group/group-membership/manage/%',
  'tab_root' => 'admin/config/group/group-membership/manage/%',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/group/group-membership/manage/%/fields/%',
  'load_functions' => 'a:2:{i:5;a:1:{s:23:"og_membership_type_load";a:4:{i:0;s:13:"og_membership";i:1;i:5;i:2;s:1:"5";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"og_membership";i:1;i:5;i:2;s:1:"5";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer group";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '250',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/group/group-membership/manage/%/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:7;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/group/group-membership/manage/%/fields/%/delete',
  'load_functions' => 'a:2:{i:5;a:1:{s:23:"og_membership_type_load";a:4:{i:0;s:13:"og_membership";i:1;i:5;i:2;s:1:"5";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"og_membership";i:1;i:5;i:2;s:1:"5";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer group";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '501',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/config/group/group-membership/manage/%/fields/%',
  'tab_root' => 'admin/config/group/group-membership/manage/%/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/group/group-membership/manage/%/fields/%/edit',
  'load_functions' => 'a:2:{i:5;a:1:{s:23:"og_membership_type_load";a:4:{i:0;s:13:"og_membership";i:1;i:5;i:2;s:1:"5";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"og_membership";i:1;i:5;i:2;s:1:"5";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer group";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '501',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/config/group/group-membership/manage/%/fields/%',
  'tab_root' => 'admin/config/group/group-membership/manage/%/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/group/group-membership/manage/%/fields/%/field-settings',
  'load_functions' => 'a:2:{i:5;a:1:{s:23:"og_membership_type_load";a:4:{i:0;s:13:"og_membership";i:1;i:5;i:2;s:1:"5";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"og_membership";i:1;i:5;i:2;s:1:"5";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer group";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '501',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/config/group/group-membership/manage/%/fields/%',
  'tab_root' => 'admin/config/group/group-membership/manage/%/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/group/group-membership/manage/%/fields/%/widget-type',
  'load_functions' => 'a:2:{i:5;a:1:{s:23:"og_membership_type_load";a:4:{i:0;s:13:"og_membership";i:1;i:5;i:2;s:1:"5";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"og_membership";i:1;i:5;i:2;s:1:"5";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer group";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '501',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/config/group/group-membership/manage/%/fields/%',
  'tab_root' => 'admin/config/group/group-membership/manage/%/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/group/permissions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer group";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:35:"og_ui_user_admin_global_permissions";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/group/permissions',
  'title' => 'Organic groups global permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure Organic groups global permissions.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/og/og_ui/og_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/group/roles',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer group";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"og_ui_user_admin_new_role";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/group/roles',
  'title' => 'Organic groups global roles',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure Organic groups global roles.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/og/og_ui/og_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/group/roles/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer group";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:29:"og_ui_user_admin_global_roles";i:1;s:0:"";i:2;s:0:"";i:3;i:5;}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/group/roles/edit',
  'title' => 'Edit role',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/og/og_ui/og_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/group/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer group";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"og_ui_user_admin_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/group/settings',
  'title' => 'Organic groups settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Administer the Organic groups settings.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/og/og_ui/og_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/media',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media',
  'title' => 'Media',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Media tools.',
  'position' => 'left',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/file-system',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:27:"system_file_system_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/file-system',
  'title' => 'File system',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Tell Drupal where to store uploaded files and how they are accessed.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'image_style_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles',
  'title' => 'Image styles',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure styles that can be used for resizing or adjusting images on display.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"image_style_add_form";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/media/image-styles',
  'tab_root' => 'admin/config/media/image-styles',
  'title' => 'Add style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => 'Add a new image style.',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/delete/%',
  'load_functions' => 'a:1:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;N;i:1;s:1:"1";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"image_style_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/delete/%',
  'title' => 'Delete style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Delete an image style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/edit/%',
  'load_functions' => 'a:1:{i:5;s:16:"image_style_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:16:"image_style_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%',
  'title' => 'Edit style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure an image style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/edit/%/add/%',
  'load_functions' => 'a:2:{i:5;a:1:{s:16:"image_style_load";a:1:{i:0;i:5;}}i:7;a:1:{s:28:"image_effect_definition_load";a:1:{i:0;i:5;}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:17:"image_effect_form";i:1;i:5;i:2;i:7;}',
  'delivery_callback' => '',
  'fit' => '250',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%/add/%',
  'title' => 'Add image effect',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Add a new effect to a style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/edit/%/effects/%',
  'load_functions' => 'a:2:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;i:5;i:1;s:1:"3";}}i:7;a:1:{s:17:"image_effect_load";a:2:{i:0;i:5;i:1;s:1:"3";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:17:"image_effect_form";i:1;i:5;i:2;i:7;}',
  'delivery_callback' => '',
  'fit' => '250',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%/effects/%',
  'title' => 'Edit image effect',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Edit an existing effect within a style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'load_functions' => 'a:2:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;i:5;i:1;s:1:"3";}}i:7;a:1:{s:17:"image_effect_load";a:2:{i:0;i:5;i:1;s:1:"3";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:24:"image_effect_delete_form";i:1;i:5;i:2;i:7;}',
  'delivery_callback' => '',
  'fit' => '501',
  'number_parts' => '9',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/edit/%/effects/%/delete',
  'title' => 'Delete image effect',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Delete an existing effect from a style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'image_style_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/media/image-styles',
  'tab_root' => 'admin/config/media/image-styles',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'List the current image styles on the site.',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-styles/revert/%',
  'load_functions' => 'a:1:{i:5;a:1:{s:16:"image_style_load";a:2:{i:0;N;i:1;s:1:"2";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"administer image styles";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"image_style_revert_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-styles/revert/%',
  'title' => 'Revert style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Revert an image style.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/image/image.admin.inc',
))
->values(array(
  'path' => 'admin/config/media/image-toolkit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:29:"system_image_toolkit_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/media/image-toolkit',
  'title' => 'Image toolkit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Choose which image toolkit to use if you have installed optional toolkits.',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/people',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people',
  'title' => 'People',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure user accounts.',
  'position' => 'left',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"user_admin_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Account settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure default behavior of users, including registration requirements, e-mails, fields, and user pictures.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Manage display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/display/default',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:5:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:7:"default";i:3;s:11:"user_access";i:4;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/display',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/display/full',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:5:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:4:"full";i:3;s:11:"user_access";i:4;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"user";i:2;s:4:"user";i:3;s:4:"full";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/display',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'User account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:4:"user";i:2;s:4:"user";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:5;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%/delete',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%/edit',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%/field-settings',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/fields/%/widget-type',
  'load_functions' => 'a:1:{i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"user";i:1;s:4:"user";i:2;s:1:"0";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts/fields/%',
  'tab_root' => 'admin/config/people/accounts/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/accounts/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"user_admin_settings";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/people/accounts',
  'tab_root' => 'admin/config/people/accounts',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/ip-blocking',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"block IP addresses";}',
  'page_callback' => 'system_ip_blocking',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/ip-blocking',
  'title' => 'IP address blocking',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage blocked IP addresses.',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/people/ip-blocking/delete/%',
  'load_functions' => 'a:1:{i:5;s:15:"blocked_ip_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"block IP addresses";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"system_ip_blocking_delete";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/people/ip-blocking/delete/%',
  'title' => 'Delete IP address',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional',
  'title' => 'Regional and language',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Regional settings, localization and translation.',
  'position' => 'left',
  'weight' => '-5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_date_time_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Date and time',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure display formats for date and time.',
  'position' => '',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_date_time_formats',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Formats',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Configure display format strings for date and time.',
  'position' => '',
  'weight' => '-9',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats/%/delete',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:30:"system_date_delete_format_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/formats/%/delete',
  'title' => 'Delete date format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Allow users to delete a configured date format.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats/%/edit',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:34:"system_configure_date_formats_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/formats/%/edit',
  'title' => 'Edit date format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Allow users to edit a configured date format.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:34:"system_configure_date_formats_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time/formats',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Add format',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => 'Allow users to add additional date formats.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/formats/lookup',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_date_time_lookup',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/formats/lookup',
  'title' => 'Date and time lookup',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/types',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_date_time_settings";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Types',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Configure display formats for date and time.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/types/%/delete',
  'load_functions' => 'a:1:{i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:35:"system_delete_date_format_type_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/date-time/types/%/delete',
  'title' => 'Delete date type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Allow users to delete a configured date type.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/date-time/types/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"system_add_date_format_type_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/regional/date-time/types',
  'tab_root' => 'admin/config/regional/date-time',
  'title' => 'Add date type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => 'Add new date type.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/regional/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_regional_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/regional/settings',
  'title' => 'Regional settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Settings for the site's default time zone and country.",
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search',
  'title' => 'Search and metadata',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Local site search, metadata and SEO.',
  'position' => 'left',
  'weight' => '-10',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/clean-urls',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_clean_url_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/clean-urls',
  'title' => 'Clean URLs',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Enable or disable clean URLs for your site.',
  'position' => '',
  'weight' => '5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/clean-urls/check',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_json_output',
  'page_arguments' => 'a:1:{i:0;a:1:{s:6:"status";b:1;}}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/clean-urls/check',
  'title' => 'Clean URL check',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/path',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_overview',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/path',
  'title' => 'URL aliases',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Change your site's URL paths by aliasing them.",
  'position' => '',
  'weight' => '-5',
  'include_file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/path/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_edit',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/search/path',
  'tab_root' => 'admin/config/search/path',
  'title' => 'Add alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/path/delete/%',
  'load_functions' => 'a:1:{i:5;s:9:"path_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"path_admin_delete_confirm";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/path/delete/%',
  'title' => 'Delete alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/path/edit/%',
  'load_functions' => 'a:1:{i:5;s:9:"path_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_edit',
  'page_arguments' => 'a:1:{i:0;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/path/edit/%',
  'title' => 'Edit alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/path/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_overview',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/search/path',
  'tab_root' => 'admin/config/search/path',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer search";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"search_admin_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/settings',
  'title' => 'Search settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure relevance settings for search and other indexing options.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/search/search.admin.inc',
))
->values(array(
  'path' => 'admin/config/search/settings/reindex',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer search";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"search_reindex_confirm";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/search/settings/reindex',
  'title' => 'Clear index',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/search/search.admin.inc',
))
->values(array(
  'path' => 'admin/config/services',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/services',
  'title' => 'Web services',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Tools related to web services.',
  'position' => 'right',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/services/rss-publishing',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"system_rss_feeds_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/services/rss-publishing',
  'title' => 'RSS publishing',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Configure the site description, the number of items per feed and whether feeds should be titles/teasers/full-text.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system',
  'title' => 'System',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'General system related configuration.',
  'position' => 'right',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_manage',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions',
  'title' => 'Actions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage the actions defined for your site.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_actions_configure";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions/configure',
  'title' => 'Configure an advanced action',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions/delete/%',
  'load_functions' => 'a:1:{i:5;s:12:"actions_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"system_actions_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions/delete/%',
  'title' => 'Delete action',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Delete an action.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions/manage',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_manage',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/system/actions',
  'tab_root' => 'admin/config/system/actions',
  'title' => 'Manage actions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Manage the actions defined for your site.',
  'position' => '',
  'weight' => '-2',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/actions/orphan',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer actions";}',
  'page_callback' => 'system_actions_remove_orphans',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/actions/orphan',
  'title' => 'Remove orphans',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/cron',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"system_cron_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/cron',
  'title' => 'Cron',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage automatic site maintenance tasks.',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/system/site-information',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"system_site_information_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/system/site-information',
  'title' => 'Site information',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Change site name, e-mail address, slogan, default front page, and number of posts per page, error pages.',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface',
  'title' => 'User interface',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Tools that enhance the user interface.',
  'position' => 'right',
  'weight' => '-15',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface/shortcut',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer shortcuts";}',
  'page_callback' => 'shortcut_set_admin',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface/shortcut',
  'title' => 'Shortcuts',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Add and modify shortcut sets.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface/shortcut/%',
  'load_functions' => 'a:1:{i:4;s:17:"shortcut_set_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_edit_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:22:"shortcut_set_customize";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface/shortcut/%',
  'title' => 'Edit shortcuts',
  'title_callback' => 'shortcut_set_title',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface/shortcut/%/add-link',
  'load_functions' => 'a:1:{i:4;s:17:"shortcut_set_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_edit_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:17:"shortcut_link_add";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/user-interface/shortcut/%',
  'tab_root' => 'admin/config/user-interface/shortcut/%',
  'title' => 'Add shortcut',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface/shortcut/%/add-link-inline',
  'load_functions' => 'a:1:{i:4;s:17:"shortcut_set_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_edit_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'shortcut_link_add_inline',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface/shortcut/%/add-link-inline',
  'title' => 'Add shortcut',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface/shortcut/%/delete',
  'load_functions' => 'a:1:{i:4;s:17:"shortcut_set_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_delete_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"shortcut_set_delete_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface/shortcut/%/delete',
  'title' => 'Delete shortcut set',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface/shortcut/%/edit',
  'load_functions' => 'a:1:{i:4;s:17:"shortcut_set_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_edit_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:22:"shortcut_set_edit_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/user-interface/shortcut/%',
  'tab_root' => 'admin/config/user-interface/shortcut/%',
  'title' => 'Edit set name',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface/shortcut/%/links',
  'load_functions' => 'a:1:{i:4;s:17:"shortcut_set_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_edit_access',
  'access_arguments' => 'a:1:{i:0;i:4;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:22:"shortcut_set_customize";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/config/user-interface/shortcut/%',
  'tab_root' => 'admin/config/user-interface/shortcut/%',
  'title' => 'List links',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface/shortcut/add-set',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"administer shortcuts";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"shortcut_set_add_form";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/config/user-interface/shortcut',
  'tab_root' => 'admin/config/user-interface/shortcut',
  'title' => 'Add shortcut set',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface/shortcut/link/%',
  'load_functions' => 'a:1:{i:5;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_link_access',
  'access_arguments' => 'a:1:{i:0;i:5;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"shortcut_link_edit";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface/shortcut/link/%',
  'title' => 'Edit shortcut',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'admin/config/user-interface/shortcut/link/%/delete',
  'load_functions' => 'a:1:{i:5;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_link_access',
  'access_arguments' => 'a:1:{i:0;i:5;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"shortcut_link_delete";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '125',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/user-interface/shortcut/link/%/delete',
  'title' => 'Delete shortcut',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'admin/config/workflow',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/config/workflow',
  'title' => 'Workflow',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Content workflow, editorial workflow tools.',
  'position' => 'right',
  'weight' => '5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/content',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"access content overview";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/content',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Administer content and comments.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/content',
  'tab_root' => 'admin/content',
  'title' => 'Comments',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '134',
  'description' => 'List and edit site comments and the comment approval queue.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment/approval',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:1:{i:0;s:8:"approval";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/content/comment',
  'tab_root' => 'admin/content',
  'title' => 'Unapproved comments',
  'title_callback' => 'comment_count_unpublished',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment/new',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/content/comment',
  'tab_root' => 'admin/content',
  'title' => 'Published comments',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:23:"access content overview";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/content',
  'tab_root' => 'admin/content',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/dashboard',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"access dashboard";}',
  'page_callback' => 'dashboard_admin',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/dashboard',
  'title' => 'Dashboard',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'View and customize your dashboard.',
  'position' => '',
  'weight' => '-15',
  'include_file' => '',
))
->values(array(
  'path' => 'admin/dashboard/block-content/%/%',
  'load_functions' => 'a:2:{i:3;N;i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'dashboard_show_block_content',
  'page_arguments' => 'a:2:{i:0;i:3;i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '28',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/dashboard/block-content/%/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'admin/dashboard/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'dashboard_admin_blocks',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/dashboard/configure',
  'title' => 'Configure available dashboard blocks',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => 'Configure which blocks can be shown on the dashboard.',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'admin/dashboard/customize',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"access dashboard";}',
  'page_callback' => 'dashboard_admin',
  'page_arguments' => 'a:1:{i:0;b:1;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/dashboard/customize',
  'title' => 'Customize dashboard',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => 'Customize your dashboard.',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'admin/dashboard/drawer',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'dashboard_show_disabled',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/dashboard/drawer',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'admin/dashboard/update',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'dashboard_update',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/dashboard/update',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'admin/help',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_main',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help',
  'title' => 'Help',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Reference for usage, configuration, and modules.',
  'position' => '',
  'weight' => '9',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/block',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/block',
  'title' => 'block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/color',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/color',
  'title' => 'color',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/comment',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/comment',
  'title' => 'comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/contextual',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/contextual',
  'title' => 'contextual',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/dashboard',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/dashboard',
  'title' => 'dashboard',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/dblog',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/dblog',
  'title' => 'dblog',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/field',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/field',
  'title' => 'field',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/field_sql_storage',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/field_sql_storage',
  'title' => 'field_sql_storage',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/field_ui',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/field_ui',
  'title' => 'field_ui',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/file',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/file',
  'title' => 'file',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/filter',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/filter',
  'title' => 'filter',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/help',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/help',
  'title' => 'help',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/image',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/image',
  'title' => 'image',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/list',
  'title' => 'list',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/menu',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/menu',
  'title' => 'menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/node',
  'title' => 'node',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/number',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/number',
  'title' => 'number',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/og',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/og',
  'title' => 'og',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/options',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/options',
  'title' => 'options',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/overlay',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/overlay',
  'title' => 'overlay',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/path',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/path',
  'title' => 'path',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/rdf',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/rdf',
  'title' => 'rdf',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/search',
  'title' => 'search',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/shortcut',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/shortcut',
  'title' => 'shortcut',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/system',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/system',
  'title' => 'system',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/taxonomy',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/taxonomy',
  'title' => 'taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/text',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/text',
  'title' => 'text',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/toolbar',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/toolbar',
  'title' => 'toolbar',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/update',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/update',
  'title' => 'update',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/help/user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'help_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/help/user',
  'title' => 'user',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/help/help.admin.inc',
))
->values(array(
  'path' => 'admin/index',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_index',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'Index',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '-18',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/modules',
  'title' => 'Modules',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Extend site functionality.',
  'position' => '',
  'weight' => '-2',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/install',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'update_manager_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"update_manager_install_form";i:1;s:6:"module";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/modules',
  'tab_root' => 'admin/modules',
  'title' => 'Install new module',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '25',
  'include_file' => 'modules/update/update.manager.inc',
))
->values(array(
  'path' => 'admin/modules/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/modules',
  'tab_root' => 'admin/modules',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/list/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/modules/list/confirm',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/uninstall',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/modules',
  'tab_root' => 'admin/modules',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/uninstall/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:18:"administer modules";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/modules/uninstall/confirm',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '4',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/modules/update',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'update_manager_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"update_manager_update_form";i:1;s:6:"module";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/modules',
  'tab_root' => 'admin/modules',
  'title' => 'Update',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/update/update.manager.inc',
))
->values(array(
  'path' => 'admin/people',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:4:"list";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/people',
  'title' => 'People',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage user accounts, roles, and permissions.',
  'position' => 'left',
  'weight' => '-4',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/create',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:6:"create";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/people',
  'tab_root' => 'admin/people',
  'title' => 'Add user',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/people',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer users";}',
  'page_callback' => 'user_admin',
  'page_arguments' => 'a:1:{i:0;s:4:"list";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/people',
  'tab_root' => 'admin/people',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Find and manage people interacting with your site.',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"user_admin_permissions";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'admin/people',
  'tab_root' => 'admin/people',
  'title' => 'Permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'Determine access to features by selecting permissions for roles.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"user_admin_permissions";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/people/permissions',
  'tab_root' => 'admin/people',
  'title' => 'Permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => 'Determine access to features by selecting permissions for roles.',
  'position' => '',
  'weight' => '-8',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions/roles',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer permissions";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:16:"user_admin_roles";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/people/permissions',
  'tab_root' => 'admin/people',
  'title' => 'Roles',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => 'List, edit, or add user roles.',
  'position' => '',
  'weight' => '-5',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions/roles/delete/%',
  'load_functions' => 'a:1:{i:5;s:14:"user_role_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_role_edit_access',
  'access_arguments' => 'a:1:{i:0;i:5;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:30:"user_admin_role_delete_confirm";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/people/permissions/roles/delete/%',
  'title' => 'Delete role',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/people/permissions/roles/edit/%',
  'load_functions' => 'a:1:{i:5;s:14:"user_role_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_role_edit_access',
  'access_arguments' => 'a:1:{i:0;i:5;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:15:"user_admin_role";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '62',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/people/permissions/roles/edit/%',
  'title' => 'Edit role',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.admin.inc',
))
->values(array(
  'path' => 'admin/reports',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports',
  'title' => 'Reports',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'View reports, updates, and errors.',
  'position' => 'left',
  'weight' => '5',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/access-denied',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'dblog_top',
  'page_arguments' => 'a:1:{i:0;s:13:"access denied";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/access-denied',
  'title' => "Top 'access denied' errors",
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "View 'access denied' errors (403s).",
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/dblog/dblog.admin.inc',
))
->values(array(
  'path' => 'admin/reports/dblog',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'dblog_overview',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/dblog',
  'title' => 'Recent log messages',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'View events that have recently been logged.',
  'position' => '',
  'weight' => '-1',
  'include_file' => 'modules/dblog/dblog.admin.inc',
))
->values(array(
  'path' => 'admin/reports/event/%',
  'load_functions' => 'a:1:{i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'dblog_event',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'delivery_callback' => '',
  'fit' => '14',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/event/%',
  'title' => 'Details',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/dblog/dblog.admin.inc',
))
->values(array(
  'path' => 'admin/reports/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'field_ui_fields_list',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/fields',
  'title' => 'Field list',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Overview of fields on all entity types.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/reports/page-not-found',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'dblog_top',
  'page_arguments' => 'a:1:{i:0;s:14:"page not found";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/page-not-found',
  'title' => "Top 'page not found' errors",
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "View 'page not found' errors (404s).",
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/dblog/dblog.admin.inc',
))
->values(array(
  'path' => 'admin/reports/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"access site reports";}',
  'page_callback' => 'dblog_top',
  'page_arguments' => 'a:1:{i:0;s:6:"search";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/search',
  'title' => 'Top search phrases',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'View most popular search phrases.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/dblog/dblog.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_status',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status',
  'title' => 'Status report',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Get a status report about your site's operation and any detected problems.",
  'position' => '',
  'weight' => '-60',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/php',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_php',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/php',
  'title' => 'PHP',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/rebuild',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"node_configure_rebuild_confirm";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/rebuild',
  'title' => 'Rebuild permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/reports/status/run-cron',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'system_run_cron',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/status/run-cron',
  'title' => 'Run cron',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/reports/updates',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'update_status',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/updates',
  'title' => 'Available updates',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Get a status report about available updates for your installed modules and themes.',
  'position' => '',
  'weight' => '-50',
  'include_file' => 'modules/update/update.report.inc',
))
->values(array(
  'path' => 'admin/reports/updates/check',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'update_manual_status',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/reports/updates/check',
  'title' => 'Manual update check',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/update/update.fetch.inc',
))
->values(array(
  'path' => 'admin/reports/updates/install',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'update_manager_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"update_manager_install_form";i:1;s:6:"report";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/reports/updates',
  'tab_root' => 'admin/reports/updates',
  'title' => 'Install new module or theme',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '25',
  'include_file' => 'modules/update/update.manager.inc',
))
->values(array(
  'path' => 'admin/reports/updates/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'update_status',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/reports/updates',
  'tab_root' => 'admin/reports/updates',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/update/update.report.inc',
))
->values(array(
  'path' => 'admin/reports/updates/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:15:"update_settings";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/reports/updates',
  'tab_root' => 'admin/reports/updates',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '50',
  'include_file' => 'modules/update/update.settings.inc',
))
->values(array(
  'path' => 'admin/reports/updates/update',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'update_manager_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"update_manager_update_form";i:1;s:6:"report";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/reports/updates',
  'tab_root' => 'admin/reports/updates',
  'title' => 'Update',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/update/update.manager.inc',
))
->values(array(
  'path' => 'admin/structure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure',
  'title' => 'Structure',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Administer blocks, content types, menus, etc.',
  'position' => 'right',
  'weight' => '-8',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block',
  'title' => 'Blocks',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Configure what block content appears in your site's sidebars and other regions.",
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/bartik',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:25:"themes/bartik/bartik.info";s:4:"name";s:6:"bartik";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:16:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:20:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";s:14:"dashboard_main";s:16:"Dashboard (main)";s:17:"dashboard_sidebar";s:19:"Dashboard (sidebar)";s:18:"dashboard_inactive";s:20:"Dashboard (inactive)";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:15:"overlay_regions";a:5:{i:0;s:14:"dashboard_main";i:1;s:17:"dashboard_sidebar";i:2;s:18:"dashboard_inactive";i:3;s:7:"content";i:4;s:4:"help";}s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/bartik',
  'title' => 'Bartik',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:16:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:6:"engine";s:11:"phptemplate";s:7:"regions";a:12:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:14:"dashboard_main";s:16:"Dashboard (main)";s:17:"dashboard_sidebar";s:19:"Dashboard (sidebar)";s:18:"dashboard_inactive";s:20:"Dashboard (inactive)";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:15:"overlay_regions";a:5:{i:0;s:14:"dashboard_main";i:1;s:17:"dashboard_sidebar";i:2;s:18:"dashboard_inactive";i:3;s:7:"content";i:4;s:4:"help";}s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/garland',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/gizra',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:33:"sites/all/themes/gizra/gizra.info";s:4:"name";s:5:"gizra";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:5:"Gizra";s:11:"description";s:18:"Gizra custom theme";s:10:"screenshot";s:39:"sites/all/themes/gizra/images/gizra.png";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:22:"styles/sub_sasson.scss";s:45:"sites/all/themes/gizra/styles/sub_sasson.scss";}}s:7:"regions";a:15:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:11:"content_top";s:11:"Content top";s:7:"content";s:7:"Content";s:14:"content_bottom";s:14:"Content bottom";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:6:"footer";s:6:"Footer";s:14:"dashboard_main";s:16:"Dashboard (main)";s:17:"dashboard_sidebar";s:19:"Dashboard (sidebar)";s:18:"dashboard_inactive";s:20:"Dashboard (inactive)";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:15:"overlay_regions";a:5:{i:0;s:14:"dashboard_main";i:1;s:17:"dashboard_sidebar";i:2;s:18:"dashboard_inactive";i:3;s:7:"content";i:4;s:4:"help";}s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:22:"styles/sub_sasson.scss";s:45:"sites/all/themes/gizra/styles/sub_sasson.scss";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:5:"gizra";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/gizra',
  'title' => 'Gizra',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:5:"gizra";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/seven',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:23:"themes/seven/seven.info";s:4:"name";s:5:"seven";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:16:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:8:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";s:14:"dashboard_main";s:16:"Dashboard (main)";s:17:"dashboard_sidebar";s:19:"Dashboard (sidebar)";s:18:"dashboard_inactive";s:20:"Dashboard (inactive)";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:15:"overlay_regions";a:5:{i:0;s:14:"dashboard_main";i:1;s:17:"dashboard_sidebar";i:2;s:18:"dashboard_inactive";i:3;s:7:"content";i:4;s:4:"help";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:5:"seven";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/seven',
  'title' => 'Seven',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:5:"seven";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/demo/stark',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => "a:1:{i:0;O:8:\"stdClass\":11:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:15:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:8:\"7.15-dev\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:12:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:15:\"overlay_regions\";a:5:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";i:3;s:7:\"content\";i:4;s:4:\"help\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}",
  'page_callback' => 'block_admin_demo',
  'page_arguments' => 'a:1:{i:0;s:5:"stark";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/demo/stark',
  'title' => 'Stark',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_block_custom_theme',
  'theme_arguments' => 'a:1:{i:0;s:5:"stark";}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/bartik',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:25:"themes/bartik/bartik.info";s:4:"name";s:6:"bartik";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:16:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:20:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";s:14:"dashboard_main";s:16:"Dashboard (main)";s:17:"dashboard_sidebar";s:19:"Dashboard (sidebar)";s:18:"dashboard_inactive";s:20:"Dashboard (inactive)";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:15:"overlay_regions";a:5:{i:0;s:14:"dashboard_main";i:1;s:17:"dashboard_sidebar";i:2;s:18:"dashboard_inactive";i:3;s:7:"content";i:4;s:4:"help";}s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:6:"bartik";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Bartik',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:16:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:6:"engine";s:11:"phptemplate";s:7:"regions";a:12:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:14:"dashboard_main";s:16:"Dashboard (main)";s:17:"dashboard_sidebar";s:19:"Dashboard (sidebar)";s:18:"dashboard_inactive";s:20:"Dashboard (inactive)";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:15:"overlay_regions";a:5:{i:0;s:14:"dashboard_main";i:1;s:17:"dashboard_sidebar";i:2;s:18:"dashboard_inactive";i:3;s:7:"content";i:4;s:4:"help";}s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/garland/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block/list/garland',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/gizra',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:33:"sites/all/themes/gizra/gizra.info";s:4:"name";s:5:"gizra";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:5:"Gizra";s:11:"description";s:18:"Gizra custom theme";s:10:"screenshot";s:39:"sites/all/themes/gizra/images/gizra.png";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:22:"styles/sub_sasson.scss";s:45:"sites/all/themes/gizra/styles/sub_sasson.scss";}}s:7:"regions";a:15:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:11:"content_top";s:11:"Content top";s:7:"content";s:7:"Content";s:14:"content_bottom";s:14:"Content bottom";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:6:"footer";s:6:"Footer";s:14:"dashboard_main";s:16:"Dashboard (main)";s:17:"dashboard_sidebar";s:19:"Dashboard (sidebar)";s:18:"dashboard_inactive";s:20:"Dashboard (inactive)";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:15:"overlay_regions";a:5:{i:0;s:14:"dashboard_main";i:1;s:17:"dashboard_sidebar";i:2;s:18:"dashboard_inactive";i:3;s:7:"content";i:4;s:4:"help";}s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:22:"styles/sub_sasson.scss";s:45:"sites/all/themes/gizra/styles/sub_sasson.scss";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:5:"gizra";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Gizra',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/gizra/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block/list/gizra',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/seven',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:23:"themes/seven/seven.info";s:4:"name";s:5:"seven";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:16:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:8:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";s:14:"dashboard_main";s:16:"Dashboard (main)";s:17:"dashboard_sidebar";s:19:"Dashboard (sidebar)";s:18:"dashboard_inactive";s:20:"Dashboard (inactive)";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:15:"overlay_regions";a:5:{i:0;s:14:"dashboard_main";i:1;s:17:"dashboard_sidebar";i:2;s:18:"dashboard_inactive";i:3;s:7:"content";i:4;s:4:"help";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:5:"seven";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Seven',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/seven/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block/list/seven',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/stark',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => "a:1:{i:0;O:8:\"stdClass\":11:{s:8:\"filename\";s:23:\"themes/stark/stark.info\";s:4:\"name\";s:5:\"stark\";s:4:\"type\";s:5:\"theme\";s:5:\"owner\";s:45:\"themes/engines/phptemplate/phptemplate.engine\";s:6:\"status\";s:1:\"0\";s:9:\"bootstrap\";s:1:\"0\";s:14:\"schema_version\";s:2:\"-1\";s:6:\"weight\";s:1:\"0\";s:4:\"info\";a:15:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:8:\"7.15-dev\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:12:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:15:\"overlay_regions\";a:5:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";i:3;s:7:\"content\";i:4;s:4:\"help\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";}}",
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:5:"stark";}',
  'delivery_callback' => '',
  'fit' => '31',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/block',
  'tab_root' => 'admin/structure/block',
  'title' => 'Stark',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/list/stark/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'delivery_callback' => '',
  'fit' => '63',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/block/list/stark',
  'tab_root' => 'admin/structure/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/manage/%/%',
  'load_functions' => 'a:2:{i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:21:"block_admin_configure";i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '60',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/block/manage/%/%',
  'title' => 'Configure block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/manage/%/%/configure',
  'load_functions' => 'a:2:{i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:21:"block_admin_configure";i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '121',
  'number_parts' => '7',
  'context' => '2',
  'tab_parent' => 'admin/structure/block/manage/%/%',
  'tab_root' => 'admin/structure/block/manage/%/%',
  'title' => 'Configure block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/block/manage/%/%/delete',
  'load_functions' => 'a:2:{i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"block_custom_block_delete";i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '121',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => 'admin/structure/block/manage/%/%',
  'tab_root' => 'admin/structure/block/manage/%/%',
  'title' => 'Delete block',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_overview_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu',
  'title' => 'Menus',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Add new menus to your site, edit existing menus, and rename and reorganize menu links.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"menu_edit_menu";i:1;s:3:"add";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu',
  'tab_root' => 'admin/structure/menu',
  'title' => 'Add menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/item/%/delete',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_item_delete_page',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/item/%/delete',
  'title' => 'Delete menu link',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/item/%/edit',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:4:"edit";i:2;i:4;i:3;N;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/item/%/edit',
  'title' => 'Edit menu link',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/item/%/reset',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"menu_reset_item_confirm";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/item/%/reset',
  'title' => 'Reset menu link',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_overview_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu',
  'tab_root' => 'admin/structure/menu',
  'title' => 'List menus',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/manage/%',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"menu_overview_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/manage/%',
  'title' => 'Customize menu',
  'title_callback' => 'menu_overview_title',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/manage/%/add',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:3:"add";i:2;N;i:3;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu/manage/%',
  'tab_root' => 'admin/structure/menu/manage/%',
  'title' => 'Add link',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/manage/%/delete',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_delete_menu_page',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/manage/%/delete',
  'title' => 'Delete menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/manage/%/edit',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:14:"menu_edit_menu";i:1;s:4:"edit";i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '3',
  'tab_parent' => 'admin/structure/menu/manage/%',
  'tab_root' => 'admin/structure/menu/manage/%',
  'title' => 'Edit menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/manage/%/list',
  'load_functions' => 'a:1:{i:4;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"menu_overview_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '3',
  'tab_parent' => 'admin/structure/menu/manage/%',
  'tab_root' => 'admin/structure/menu/manage/%',
  'title' => 'List links',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/menu/parents',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;b:1;}',
  'page_callback' => 'menu_parent_options_js',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/menu/parents',
  'title' => 'Parent menu items',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'admin/structure/menu/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"menu_configure";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/menu',
  'tab_root' => 'admin/structure/menu',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'include_file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"taxonomy_overview_vocabularies";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/taxonomy',
  'title' => 'Taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage tagging, categorization, and classification of your content.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"taxonomy_overview_terms";i:1;i:3;}',
  'delivery_callback' => '',
  'fit' => '14',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => '',
  'title_callback' => 'taxonomy_admin_vocabulary_title_callback',
  'title_arguments' => 'a:1:{i:0;i:3;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/add',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:18:"taxonomy_form_term";i:1;a:0:{}i:2;i:3;}',
  'delivery_callback' => '',
  'fit' => '29',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Add term',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/display',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:13:"taxonomy_term";i:2;i:3;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '29',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Manage display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/display/default',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:5:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:7:"default";i:3;s:11:"user_access";i:4;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:13:"taxonomy_term";i:2;i:3;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '59',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/display',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/display/full',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:5:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:4:"full";i:3;s:11:"user_access";i:4;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:13:"taxonomy_term";i:2;i:3;i:3;s:4:"full";}',
  'delivery_callback' => '',
  'fit' => '59',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/display',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Taxonomy term page',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/edit',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"taxonomy_form_vocabulary";i:1;i:3;}',
  'delivery_callback' => '',
  'fit' => '29',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/fields',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:13:"taxonomy_term";i:2;i:3;}',
  'delivery_callback' => '',
  'fit' => '29',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/fields/%',
  'load_functions' => 'a:2:{i:3;a:1:{s:37:"taxonomy_vocabulary_machine_name_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '58',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/taxonomy/%/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:5;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/fields/%/delete',
  'load_functions' => 'a:2:{i:3;a:1:{s:37:"taxonomy_vocabulary_machine_name_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '117',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/fields/%',
  'tab_root' => 'admin/structure/taxonomy/%/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/fields/%/edit',
  'load_functions' => 'a:2:{i:3;a:1:{s:37:"taxonomy_vocabulary_machine_name_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '117',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/fields/%',
  'tab_root' => 'admin/structure/taxonomy/%/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/fields/%/field-settings',
  'load_functions' => 'a:2:{i:3;a:1:{s:37:"taxonomy_vocabulary_machine_name_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '117',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/fields/%',
  'tab_root' => 'admin/structure/taxonomy/%/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/fields/%/widget-type',
  'load_functions' => 'a:2:{i:3;a:1:{s:37:"taxonomy_vocabulary_machine_name_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}i:5;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:13:"taxonomy_term";i:1;i:3;i:2;s:1:"3";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:5;}',
  'delivery_callback' => '',
  'fit' => '117',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%/fields/%',
  'tab_root' => 'admin/structure/taxonomy/%/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/%/list',
  'load_functions' => 'a:1:{i:3;s:37:"taxonomy_vocabulary_machine_name_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"taxonomy_overview_terms";i:1;i:3;}',
  'delivery_callback' => '',
  'fit' => '29',
  'number_parts' => '5',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy/%',
  'tab_root' => 'admin/structure/taxonomy/%',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"taxonomy_form_vocabulary";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy',
  'tab_root' => 'admin/structure/taxonomy',
  'title' => 'Add vocabulary',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/taxonomy/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer taxonomy";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"taxonomy_overview_vocabularies";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/taxonomy',
  'tab_root' => 'admin/structure/taxonomy',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'node_overview_types',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types',
  'title' => 'Content types',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Manage content types, including default status, front page promotion, comment settings, etc.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"node_type_form";}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/types',
  'tab_root' => 'admin/structure/types',
  'title' => 'Add content type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '388',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'node_overview_types',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '15',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'admin/structure/types',
  'tab_root' => 'admin/structure/types',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Edit content type',
  'title_callback' => 'node_type_page_title',
  'title_arguments' => 'a:1:{i:0;i:4;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/display',
  'load_functions' => 'a:1:{i:4;s:22:"comment_node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:7:"comment";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Comment display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '4',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/display/default',
  'load_functions' => 'a:1:{i:4;s:22:"comment_node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:5:{i:0;s:7:"comment";i:1;i:4;i:2;s:7:"default";i:3;s:11:"user_access";i:4;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:7:"comment";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '247',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/display/full',
  'load_functions' => 'a:1:{i:4;s:22:"comment_node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:5:{i:0;s:7:"comment";i:1;i:4;i:2;s:4:"full";i:3;s:11:"user_access";i:4;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:7:"comment";i:2;i:4;i:3;s:4:"full";}',
  'delivery_callback' => '',
  'fit' => '247',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Full comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/fields',
  'load_functions' => 'a:1:{i:4;s:22:"comment_node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:7:"comment";i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Comment fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '3',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/fields/%',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '246',
  'number_parts' => '8',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:7;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/fields/%/delete',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '493',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/fields/%/edit',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '493',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/fields/%/field-settings',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '493',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/comment/fields/%/widget-type',
  'load_functions' => 'a:2:{i:4;a:1:{s:22:"comment_node_type_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:7;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:7:"comment";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:7;}',
  'delivery_callback' => '',
  'fit' => '493',
  'number_parts' => '9',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/comment/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/comment/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/delete',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Manage display',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/default',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:5:{i:0;s:4:"node";i:1;i:4;i:2;s:7:"default";i:3;s:11:"user_access";i:4;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:7:"default";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Default',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/full',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:5:{i:0;s:4:"node";i:1;i:4;i:2;s:4:"full";i:3;s:11:"user_access";i:4;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:4:"full";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Full content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/rss',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:5:{i:0;s:4:"node";i:1;i:4;i:2;s:3:"rss";i:3;s:11:"user_access";i:4;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:3:"rss";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/search_index',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:5:{i:0;s:4:"node";i:1;i:4;i:2;s:12:"search_index";i:3;s:11:"user_access";i:4;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:12:"search_index";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Search index',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '3',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/search_result',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:5:{i:0;s:4:"node";i:1;i:4;i:2;s:13:"search_result";i:3;s:11:"user_access";i:4;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:13:"search_result";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Search result',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '4',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/display/teaser',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_field_ui_view_mode_menu_access',
  'access_arguments' => 'a:5:{i:0;s:4:"node";i:1;i:4;i:2;s:6:"teaser";i:3;s:11:"user_access";i:4;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:30:"field_ui_display_overview_form";i:1;s:4:"node";i:2;i:4;i:3;s:6:"teaser";}',
  'delivery_callback' => '',
  'fit' => '123',
  'number_parts' => '7',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/display',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Teaser',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/edit',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields',
  'load_functions' => 'a:1:{i:4;s:14:"node_type_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"field_ui_field_overview_form";i:1;s:4:"node";i:2;i:4;}',
  'delivery_callback' => '',
  'fit' => '61',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%',
  'tab_root' => 'admin/structure/types/manage/%',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '122',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => '',
  'title_callback' => 'field_ui_menu_title',
  'title_arguments' => 'a:1:{i:0;i:6;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%/delete',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:26:"field_ui_field_delete_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%/edit',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"field_ui_field_edit_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%/field-settings',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"field_ui_field_settings_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Field settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/structure/types/manage/%/fields/%/widget-type',
  'load_functions' => 'a:2:{i:4;a:1:{s:14:"node_type_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}i:6;a:1:{s:18:"field_ui_menu_load";a:4:{i:0;s:4:"node";i:1;i:4;i:2;s:1:"4";i:3;s:4:"%map";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:25:"field_ui_widget_type_form";i:1;i:6;}',
  'delivery_callback' => '',
  'fit' => '245',
  'number_parts' => '8',
  'context' => '1',
  'tab_parent' => 'admin/structure/types/manage/%/fields/%',
  'tab_root' => 'admin/structure/types/manage/%/fields/%',
  'title' => 'Widget type',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/field_ui/field_ui.admin.inc',
))
->values(array(
  'path' => 'admin/tasks',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'Tasks',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-20',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/update/ready',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'update_manager_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:32:"update_manager_update_ready_form";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'admin/update/ready',
  'title' => 'Ready to update',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/update/update.manager.inc',
))
->values(array(
  'path' => 'batch',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'system_batch_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'batch',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '_system_batch_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'comment/%',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"access comments";}',
  'page_callback' => 'comment_permalink',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'comment/%',
  'title' => 'Comment permalink',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'comment/%/approve',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_approve',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'comment/%/approve',
  'title' => 'Approve',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/comment/comment.pages.inc',
))
->values(array(
  'path' => 'comment/%/delete',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_confirm_delete_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'comment/%',
  'tab_root' => 'comment/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'comment/%/edit',
  'load_functions' => 'a:1:{i:1;s:12:"comment_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'comment_access',
  'access_arguments' => 'a:2:{i:0;s:4:"edit";i:1;i:1;}',
  'page_callback' => 'comment_edit_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'comment/%',
  'tab_root' => 'comment/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'comment/%/group',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'og_user_access_by_entity',
  'access_arguments' => 'a:3:{i:0;s:27:"access administration pages";i:1;s:7:"comment";i:2;i:1;}',
  'page_callback' => 'og_ui_group_admin_overview',
  'page_arguments' => 'a:2:{i:0;s:7:"comment";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => 'comment/%',
  'tab_root' => 'comment/%',
  'title' => 'Group',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/og/og_ui/og_ui.admin.inc',
))
->values(array(
  'path' => 'comment/%/view',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"access comments";}',
  'page_callback' => 'comment_permalink',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'comment/%',
  'tab_root' => 'comment/%',
  'title' => 'View comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => '',
))
->values(array(
  'path' => 'comment/reply/%',
  'load_functions' => 'a:1:{i:2;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:2;}',
  'page_callback' => 'comment_reply',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'comment/reply/%',
  'title' => 'Add new comment',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/comment/comment.pages.inc',
))
->values(array(
  'path' => 'file/ajax',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'file_ajax_upload',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => 'ajax_deliver',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'file/ajax',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'file/progress',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'file_ajax_progress',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'file/progress',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'filter/tips',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'filter_tips_long',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'filter/tips',
  'title' => 'Compose tips',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '20',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/filter/filter.pages.inc',
))
->values(array(
  'path' => 'group/%/%/admin/people',
  'load_functions' => 'a:2:{i:1;N;i:2;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'og_user_access_by_entity',
  'access_arguments' => 'a:3:{i:0;s:29:"approve and deny subscription";i:1;i:1;i:2;i:2;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:24:"og_ui_user_admin_account";i:1;i:1;i:2;i:2;}',
  'delivery_callback' => '',
  'fit' => '19',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'group/%/%/admin/people',
  'title' => '',
  'title_callback' => 'og_ui_menu_title_callback',
  'title_arguments' => 'a:3:{i:0;s:22:"People in group @group";i:1;i:1;i:2;i:2;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Find and manage group members.',
  'position' => '',
  'weight' => '-4',
  'include_file' => 'sites/all/modules/og/og_ui/og_ui.admin.inc',
))
->values(array(
  'path' => 'group/%/%/admin/people/add-user',
  'load_functions' => 'a:2:{i:1;N;i:2;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'og_user_access_by_entity',
  'access_arguments' => 'a:3:{i:0;s:8:"add user";i:1;i:1;i:2;i:2;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:15:"og_ui_add_users";i:1;i:1;i:2;i:2;}',
  'delivery_callback' => '',
  'fit' => '39',
  'number_parts' => '6',
  'context' => '1',
  'tab_parent' => 'group/%/%/admin/people',
  'tab_root' => 'group/%/%/admin/people',
  'title' => 'Add members',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'include_file' => 'sites/all/modules/og/og_ui/og_ui.admin.inc',
))
->values(array(
  'path' => 'group/%/%/admin/people/permissions',
  'load_functions' => 'a:2:{i:1;N;i:2;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'og_user_access_by_entity',
  'access_arguments' => 'a:3:{i:0;s:16:"administer group";i:1;i:1;i:2;i:2;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:28:"og_ui_user_admin_permissions";i:1;i:1;i:2;i:2;}',
  'delivery_callback' => '',
  'fit' => '39',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'group/%/%/admin/people/permissions',
  'title' => '',
  'title_callback' => 'og_ui_menu_title_callback',
  'title_arguments' => 'a:3:{i:0;s:28:"Permissions for group @group";i:1;i:1;i:2;i:2;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Determine access to features by selecting permissions for roles.',
  'position' => '',
  'weight' => '-8',
  'include_file' => 'sites/all/modules/og/og_ui/og_ui.admin.inc',
))
->values(array(
  'path' => 'group/%/%/admin/people/roles',
  'load_functions' => 'a:2:{i:1;N;i:2;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'og_user_access_by_entity',
  'access_arguments' => 'a:3:{i:0;s:16:"administer group";i:1;i:1;i:2;i:2;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:25:"og_ui_user_admin_new_role";i:1;i:1;i:2;i:2;}',
  'delivery_callback' => '',
  'fit' => '39',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'group/%/%/admin/people/roles',
  'title' => '',
  'title_callback' => 'og_ui_menu_title_callback',
  'title_arguments' => 'a:3:{i:0;s:22:"Roles for group @group";i:1;i:1;i:2;i:2;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'List, edit, or add user roles.',
  'position' => '',
  'weight' => '-9',
  'include_file' => 'sites/all/modules/og/og_ui/og_ui.admin.inc',
))
->values(array(
  'path' => 'group/%/%/admin/people/roles/edit',
  'load_functions' => 'a:2:{i:1;N;i:2;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'og_user_access_by_entity',
  'access_arguments' => 'a:3:{i:0;s:16:"administer group";i:1;i:1;i:2;i:2;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:22:"og_ui_user_admin_roles";i:1;i:1;i:2;i:2;}',
  'delivery_callback' => '',
  'fit' => '79',
  'number_parts' => '7',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'group/%/%/admin/people/roles/edit',
  'title' => 'Edit role',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/og/og_ui/og_ui.admin.inc',
))
->values(array(
  'path' => 'group/%/%/subscribe',
  'load_functions' => 'a:2:{i:1;N;i:2;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_logged_in',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'og_ui_subscribe',
  'page_arguments' => 'a:2:{i:0;i:1;i:1;i:2;}',
  'delivery_callback' => '',
  'fit' => '9',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'group/%/%/subscribe',
  'title' => 'Join group',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/og/og_ui/og_ui.pages.inc',
))
->values(array(
  'path' => 'group/%/%/unsubscribe',
  'load_functions' => 'a:2:{i:1;N;i:2;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'og_user_access_by_entity',
  'access_arguments' => 'a:3:{i:0;s:11:"unsubscribe";i:1;i:1;i:2;i:2;}',
  'page_callback' => 'og_ui_unsubscribe',
  'page_arguments' => 'a:2:{i:0;i:1;i:1;i:2;}',
  'delivery_callback' => '',
  'fit' => '9',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'group/%/%/unsubscribe',
  'title' => 'Leave group',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/og/og_ui/og_ui.pages.inc',
))
->values(array(
  'path' => 'group/%/group',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'og_user_access_by_entity',
  'access_arguments' => 'a:3:{i:0;s:27:"access administration pages";i:1;s:5:"group";i:2;i:1;}',
  'page_callback' => 'og_ui_group_admin_overview',
  'page_arguments' => 'a:2:{i:0;s:5:"group";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => '',
  'tab_root' => 'group/%/group',
  'title' => 'Group',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/og/og_ui/og_ui.admin.inc',
))
->values(array(
  'path' => 'group/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'og_field_audience_autocomplete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'group/autocomplete',
  'title' => 'group autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'node_page_default',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'node/%',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'node_page_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%',
  'title' => '',
  'title_callback' => 'node_page_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'node/%/delete',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"delete";i:1;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:19:"node_delete_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '2',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/edit',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"update";i:1;i:1;}',
  'page_callback' => 'node_page_edit',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/group',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'og_user_access_by_entity',
  'access_arguments' => 'a:3:{i:0;s:27:"access administration pages";i:1;s:4:"node";i:2;i:1;}',
  'page_callback' => 'og_ui_group_admin_overview',
  'page_arguments' => 'a:2:{i:0;s:4:"node";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Group',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/og/og_ui/og_ui.admin.inc',
))
->values(array(
  'path' => 'node/%/revisions',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'node_revision_overview',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/delete',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:6:"delete";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"node_revision_delete_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/delete',
  'title' => 'Delete earlier revision',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/revert',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:2:{i:0;i:1;i:1;s:6:"update";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"node_revision_revert_confirm";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/revert',
  'title' => 'Revert to earlier revision',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/%/revisions/%/view',
  'load_functions' => 'a:2:{i:1;a:1:{s:9:"node_load";a:1:{i:0;i:3;}}i:3;N;}',
  'to_arg_functions' => '',
  'access_callback' => '_node_revision_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'node_show',
  'page_arguments' => 'a:2:{i:0;i:1;i:1;b:1;}',
  'delivery_callback' => '',
  'fit' => '21',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/%/revisions/%/view',
  'title' => 'Revisions',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'node/%/view',
  'load_functions' => 'a:1:{i:1;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:4:"view";i:1;i:1;}',
  'page_callback' => 'node_page_view',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'node/%',
  'tab_root' => 'node/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => '',
))
->values(array(
  'path' => 'node/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_node_add_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'node_add_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add',
  'title' => 'Add content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/article',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:7:"article";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:7:"article";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/article',
  'title' => 'Article',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => 'Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/class',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:5:"class";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:5:"class";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/class',
  'title' => 'Class',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/page',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:4:"page";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:4:"page";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/page',
  'title' => 'Basic page',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => "Use <em>basic pages</em> for your static content, such as an 'About us' page.",
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'node/add/school',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'node_access',
  'access_arguments' => 'a:2:{i:0;s:6:"create";i:1;s:6:"school";}',
  'page_callback' => 'node_add',
  'page_arguments' => 'a:1:{i:0;s:6:"school";}',
  'delivery_callback' => '',
  'fit' => '7',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'node/add/school',
  'title' => 'School',
  'title_callback' => 'check_plain',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/node/node.pages.inc',
))
->values(array(
  'path' => 'og_membership/%/group',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'og_user_access_by_entity',
  'access_arguments' => 'a:3:{i:0;s:27:"access administration pages";i:1;s:13:"og_membership";i:2;i:1;}',
  'page_callback' => 'og_ui_group_admin_overview',
  'page_arguments' => 'a:2:{i:0;s:13:"og_membership";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => '',
  'tab_root' => 'og_membership/%/group',
  'title' => 'Group',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/og/og_ui/og_ui.admin.inc',
))
->values(array(
  'path' => 'og_membership_type/%/group',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'og_user_access_by_entity',
  'access_arguments' => 'a:3:{i:0;s:27:"access administration pages";i:1;s:18:"og_membership_type";i:2;i:1;}',
  'page_callback' => 'og_ui_group_admin_overview',
  'page_arguments' => 'a:2:{i:0;s:18:"og_membership_type";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => '',
  'tab_root' => 'og_membership_type/%/group',
  'title' => 'Group',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/og/og_ui/og_ui.admin.inc',
))
->values(array(
  'path' => 'overlay-ajax/%',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access overlay";}',
  'page_callback' => 'overlay_ajax_render_region',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'overlay-ajax/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'overlay/dismiss-message',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access overlay";}',
  'page_callback' => 'overlay_user_dismiss_message',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'overlay/dismiss-message',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'rss.xml',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'node_feed',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'rss.xml',
  'title' => 'RSS feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'search_is_active',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'search_view',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'search',
  'title' => 'Search',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '20',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/search/search.pages.inc',
))
->values(array(
  'path' => 'search/node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_search_menu_access',
  'access_arguments' => 'a:1:{i:0;s:4:"node";}',
  'page_callback' => 'search_view',
  'page_arguments' => 'a:2:{i:0;s:4:"node";i:1;s:0:"";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'search',
  'tab_root' => 'search',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/search/search.pages.inc',
))
->values(array(
  'path' => 'search/node/%',
  'load_functions' => 'a:1:{i:2;a:1:{s:14:"menu_tail_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => 'a:1:{i:2;s:16:"menu_tail_to_arg";}',
  'access_callback' => '_search_menu_access',
  'access_arguments' => 'a:1:{i:0;s:4:"node";}',
  'page_callback' => 'search_view',
  'page_arguments' => 'a:2:{i:0;s:4:"node";i:1;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'search/node',
  'tab_root' => 'search/node/%',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/search/search.pages.inc',
))
->values(array(
  'path' => 'search/user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_search_menu_access',
  'access_arguments' => 'a:1:{i:0;s:4:"user";}',
  'page_callback' => 'search_view',
  'page_arguments' => 'a:2:{i:0;s:4:"user";i:1;s:0:"";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'search',
  'tab_root' => 'search',
  'title' => 'Users',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/search/search.pages.inc',
))
->values(array(
  'path' => 'search/user/%',
  'load_functions' => 'a:1:{i:2;a:1:{s:14:"menu_tail_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => 'a:1:{i:2;s:16:"menu_tail_to_arg";}',
  'access_callback' => '_search_menu_access',
  'access_arguments' => 'a:1:{i:0;s:4:"user";}',
  'page_callback' => 'search_view',
  'page_arguments' => 'a:2:{i:0;s:4:"user";i:1;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'search/node',
  'tab_root' => 'search/node/%',
  'title' => 'Users',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/search/search.pages.inc',
))
->values(array(
  'path' => 'sites/default/files/styles/%',
  'load_functions' => 'a:1:{i:4;s:16:"image_style_load";}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'image_style_deliver',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'delivery_callback' => '',
  'fit' => '30',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'sites/default/files/styles/%',
  'title' => 'Generate image style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'system/ajax',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'ajax_form_callback',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => 'ajax_deliver',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/ajax',
  'title' => 'AHAH callback',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => 'ajax_base_page_theme',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'includes/form.inc',
))
->values(array(
  'path' => 'system/files',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'file_download',
  'page_arguments' => 'a:1:{i:0;s:7:"private";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/files',
  'title' => 'File download',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'system/files/styles/%',
  'load_functions' => 'a:1:{i:3;s:16:"image_style_load";}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'image_style_deliver',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'delivery_callback' => '',
  'fit' => '14',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/files/styles/%',
  'title' => 'Generate image style',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'system/temporary',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'file_download',
  'page_arguments' => 'a:1:{i:0;s:9:"temporary";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/temporary',
  'title' => 'Temporary files',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'system/timezone',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'system_timezone',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'system/timezone',
  'title' => 'Time zone',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'taxonomy/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'taxonomy_autocomplete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/autocomplete',
  'title' => 'Autocomplete taxonomy',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.pages.inc',
))
->values(array(
  'path' => 'taxonomy/term/%',
  'load_functions' => 'a:1:{i:2;s:18:"taxonomy_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'taxonomy_term_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '6',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'Taxonomy term',
  'title_callback' => 'taxonomy_term_title',
  'title_arguments' => 'a:1:{i:0;i:2;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.pages.inc',
))
->values(array(
  'path' => 'taxonomy/term/%/edit',
  'load_functions' => 'a:1:{i:2;s:18:"taxonomy_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'taxonomy_term_edit_access',
  'access_arguments' => 'a:1:{i:0;i:2;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:18:"taxonomy_form_term";i:1;i:2;i:2;N;}',
  'delivery_callback' => '',
  'fit' => '13',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'taxonomy/term/%',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/taxonomy/taxonomy.admin.inc',
))
->values(array(
  'path' => 'taxonomy/term/%/feed',
  'load_functions' => 'a:1:{i:2;s:18:"taxonomy_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'taxonomy_term_feed',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '13',
  'number_parts' => '4',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'taxonomy/term/%/feed',
  'title' => 'Taxonomy term',
  'title_callback' => 'taxonomy_term_title',
  'title_arguments' => 'a:1:{i:0;i:2;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.pages.inc',
))
->values(array(
  'path' => 'taxonomy/term/%/view',
  'load_functions' => 'a:1:{i:2;s:18:"taxonomy_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access content";}',
  'page_callback' => 'taxonomy_term_page',
  'page_arguments' => 'a:1:{i:0;i:2;}',
  'delivery_callback' => '',
  'fit' => '13',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'taxonomy/term/%',
  'tab_root' => 'taxonomy/term/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/taxonomy/taxonomy.pages.inc',
))
->values(array(
  'path' => 'taxonomy_term/%/group',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'og_user_access_by_entity',
  'access_arguments' => 'a:3:{i:0;s:27:"access administration pages";i:1;s:13:"taxonomy_term";i:2;i:1;}',
  'page_callback' => 'og_ui_group_admin_overview',
  'page_arguments' => 'a:2:{i:0;s:13:"taxonomy_term";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => '',
  'tab_root' => 'taxonomy_term/%/group',
  'title' => 'Group',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/og/og_ui/og_ui.admin.inc',
))
->values(array(
  'path' => 'toolbar/toggle',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:14:"access toolbar";}',
  'page_callback' => 'toolbar_toggle_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'toolbar/toggle',
  'title' => 'Toggle drawer visibility',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'user',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '1',
  'number_parts' => '1',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user',
  'title' => 'User account',
  'title_callback' => 'user_menu_title',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_view_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_view_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '2',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/%',
  'title' => 'My account',
  'title_callback' => 'user_page_title',
  'title_arguments' => 'a:1:{i:0;i:1;}',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'user/%/cancel',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_cancel_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"user_cancel_confirm_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/%/cancel',
  'title' => 'Cancel account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/cancel/confirm/%/%',
  'load_functions' => 'a:3:{i:1;s:9:"user_load";i:4;N;i:5;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_cancel_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_cancel_confirm',
  'page_arguments' => 'a:3:{i:0;i:1;i:1;i:4;i:2;i:5;}',
  'delivery_callback' => '',
  'fit' => '44',
  'number_parts' => '6',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/%/cancel/confirm/%/%',
  'title' => 'Confirm account cancellation',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/edit',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_edit_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/edit/account',
  'load_functions' => 'a:1:{i:1;a:1:{s:18:"user_category_load";a:2:{i:0;s:4:"%map";i:1;s:6:"%index";}}}',
  'to_arg_functions' => '',
  'access_callback' => 'user_edit_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:17:"user_profile_form";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '11',
  'number_parts' => '4',
  'context' => '1',
  'tab_parent' => 'user/%/edit',
  'tab_root' => 'user/%',
  'title' => 'Account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/%/group',
  'load_functions' => 'a:1:{i:1;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'og_user_access_by_entity',
  'access_arguments' => 'a:3:{i:0;s:27:"access administration pages";i:1;s:4:"user";i:2;i:1;}',
  'page_callback' => 'og_ui_group_admin_overview',
  'page_arguments' => 'a:2:{i:0;s:4:"user";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '3',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Group',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'sites/all/modules/og/og_ui/og_ui.admin.inc',
))
->values(array(
  'path' => 'user/%/shortcuts',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'shortcut_set_switch_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:19:"shortcut_set_switch";i:1;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'Shortcuts',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/shortcut/shortcut.admin.inc',
))
->values(array(
  'path' => 'user/%/view',
  'load_functions' => 'a:1:{i:1;s:9:"user_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_view_access',
  'access_arguments' => 'a:1:{i:0;i:1;}',
  'page_callback' => 'user_view_page',
  'page_arguments' => 'a:1:{i:0;i:1;}',
  'delivery_callback' => '',
  'fit' => '5',
  'number_parts' => '3',
  'context' => '1',
  'tab_parent' => 'user/%',
  'tab_root' => 'user/%',
  'title' => 'View',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'include_file' => '',
))
->values(array(
  'path' => 'user/autocomplete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:20:"access user profiles";}',
  'page_callback' => 'user_autocomplete',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/autocomplete',
  'title' => 'User autocomplete',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/login',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_anonymous',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_page',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Log in',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '140',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/logout',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_is_logged_in',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'user_logout',
  'page_arguments' => 'a:0:{}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/logout',
  'title' => 'Log out',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '6',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/password',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:9:"user_pass";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Request new password',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->values(array(
  'path' => 'user/register',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_register_access',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"user_register_form";}',
  'delivery_callback' => '',
  'fit' => '3',
  'number_parts' => '2',
  'context' => '1',
  'tab_parent' => 'user',
  'tab_root' => 'user',
  'title' => 'Create new account',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '132',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => '',
))
->values(array(
  'path' => 'user/reset/%/%/%',
  'load_functions' => 'a:3:{i:2;N;i:3;N;i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => '1',
  'access_arguments' => 'a:0:{}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:15:"user_pass_reset";i:1;i:2;i:2;i:3;i:3;i:4;}',
  'delivery_callback' => '',
  'fit' => '24',
  'number_parts' => '5',
  'context' => '0',
  'tab_parent' => '',
  'tab_root' => 'user/reset/%/%/%',
  'title' => 'Reset password',
  'title_callback' => 't',
  'title_arguments' => '',
  'theme_callback' => '',
  'theme_arguments' => 'a:0:{}',
  'type' => '0',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'include_file' => 'modules/user/user.pages.inc',
))
->execute();

db_create_table('node', array(
  'fields' => array(
    'nid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => FALSE,
      'default' => NULL,
    ),
    'type' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 12,
      'not null' => TRUE,
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 1,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'changed' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'comment' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'promote' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'sticky' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'tnid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'translate' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'node_changed' => array(
      'changed',
    ),
    'node_created' => array(
      'created',
    ),
    'node_frontpage' => array(
      'promote',
      'status',
      'sticky',
      'created',
    ),
    'node_status_type' => array(
      'status',
      'type',
      'nid',
    ),
    'node_title_type' => array(
      'title',
      array(
        'type',
        4,
      ),
    ),
    'node_type' => array(
      array(
        'type',
        4,
      ),
    ),
    'uid' => array(
      'uid',
    ),
    'tnid' => array(
      'tnid',
    ),
    'translate' => array(
      'translate',
    ),
  ),
  'unique keys' => array(
    'vid' => array(
      'vid',
    ),
  ),
  'foreign keys' => array(
    'node_revision' => array(
      'table' => 'node_revision',
      'columns' => array(
        'vid' => 'vid',
      ),
    ),
    'node_author' => array(
      'table' => 'users',
      'columns' => array(
        'uid' => 'uid',
      ),
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'module' => 'node',
  'name' => 'node',
));
db_insert('node')->fields(array(
  'nid',
  'vid',
  'type',
  'language',
  'title',
  'uid',
  'status',
  'created',
  'changed',
  'comment',
  'promote',
  'sticky',
  'tnid',
  'translate',
))
->values(array(
  'nid' => '1',
  'vid' => '1',
  'type' => 'school',
  'language' => 'und',
  'title' => 'Regular group',
  'uid' => '11',
  'status' => '1',
  'created' => '1346694728',
  'changed' => '1346694806',
  'comment' => '2',
  'promote' => '1',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->values(array(
  'nid' => '2',
  'vid' => '2',
  'type' => 'school',
  'language' => 'und',
  'title' => 'Override roles and permissions',
  'uid' => '1',
  'status' => '1',
  'created' => '1346694858',
  'changed' => '1346694858',
  'comment' => '2',
  'promote' => '1',
  'sticky' => '0',
  'tnid' => '0',
  'translate' => '0',
))
->execute();

db_create_table('node_access', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'gid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'realm' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'grant_view' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'grant_update' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'grant_delete' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
  ),
  'primary key' => array(
    'nid',
    'gid',
    'realm',
  ),
  'foreign keys' => array(
    'affected_node' => array(
      'table' => 'node',
      'columns' => array(
        'nid' => 'nid',
      ),
    ),
  ),
  'module' => 'node',
  'name' => 'node_access',
));
db_insert('node_access')->fields(array(
  'nid',
  'gid',
  'realm',
  'grant_view',
  'grant_update',
  'grant_delete',
))
->values(array(
  'nid' => '0',
  'gid' => '0',
  'realm' => 'all',
  'grant_view' => '1',
  'grant_update' => '0',
  'grant_delete' => '0',
))
->execute();

db_create_table('node_comment_statistics', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'cid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'last_comment_timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'last_comment_name' => array(
      'type' => 'varchar',
      'length' => 60,
      'not null' => FALSE,
    ),
    'last_comment_uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'comment_count' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'indexes' => array(
    'node_comment_timestamp' => array(
      'last_comment_timestamp',
    ),
    'comment_count' => array(
      'comment_count',
    ),
    'last_comment_uid' => array(
      'last_comment_uid',
    ),
  ),
  'foreign keys' => array(
    'statistics_node' => array(
      'table' => 'node',
      'columns' => array(
        'nid' => 'nid',
      ),
    ),
    'last_comment_author' => array(
      'table' => 'users',
      'columns' => array(
        'last_comment_uid' => 'uid',
      ),
    ),
  ),
  'module' => 'comment',
  'name' => 'node_comment_statistics',
));
db_insert('node_comment_statistics')->fields(array(
  'nid',
  'cid',
  'last_comment_timestamp',
  'last_comment_name',
  'last_comment_uid',
  'comment_count',
))
->values(array(
  'nid' => '1',
  'cid' => '0',
  'last_comment_timestamp' => '1346694728',
  'last_comment_name' => NULL,
  'last_comment_uid' => '1',
  'comment_count' => '0',
))
->values(array(
  'nid' => '2',
  'cid' => '0',
  'last_comment_timestamp' => '1346694858',
  'last_comment_name' => NULL,
  'last_comment_uid' => '1',
  'comment_count' => '0',
))
->execute();

db_create_table('node_revision', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'vid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'title' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'log' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 1,
    ),
    'comment' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'promote' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'sticky' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
    'uid' => array(
      'uid',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'foreign keys' => array(
    'versioned_node' => array(
      'table' => 'node',
      'columns' => array(
        'nid' => 'nid',
      ),
    ),
    'version_author' => array(
      'table' => 'users',
      'columns' => array(
        'uid' => 'uid',
      ),
    ),
  ),
  'module' => 'node',
  'name' => 'node_revision',
));
db_insert('node_revision')->fields(array(
  'nid',
  'vid',
  'uid',
  'title',
  'log',
  'timestamp',
  'status',
  'comment',
  'promote',
  'sticky',
))
->values(array(
  'nid' => '1',
  'vid' => '1',
  'uid' => '1',
  'title' => 'Regular group',
  'log' => '',
  'timestamp' => '1346694806',
  'status' => '1',
  'comment' => '2',
  'promote' => '1',
  'sticky' => '0',
))
->values(array(
  'nid' => '2',
  'vid' => '2',
  'uid' => '1',
  'title' => 'Override roles and permissions',
  'log' => '',
  'timestamp' => '1346694858',
  'status' => '1',
  'comment' => '2',
  'promote' => '1',
  'sticky' => '0',
))
->execute();

db_create_table('node_type', array(
  'fields' => array(
    'type' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
      'translatable' => TRUE,
    ),
    'base' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
    ),
    'module' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'medium',
      'translatable' => TRUE,
    ),
    'help' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'medium',
      'translatable' => TRUE,
    ),
    'has_title' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'size' => 'tiny',
    ),
    'title_label' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
      'translatable' => TRUE,
    ),
    'custom' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'modified' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'disabled' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'orig_type' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
  ),
  'primary key' => array(
    'type',
  ),
  'module' => 'node',
  'name' => 'node_type',
));
db_insert('node_type')->fields(array(
  'type',
  'name',
  'base',
  'module',
  'description',
  'help',
  'has_title',
  'title_label',
  'custom',
  'modified',
  'locked',
  'disabled',
  'orig_type',
))
->values(array(
  'type' => 'article',
  'name' => 'Article',
  'base' => 'node_content',
  'module' => 'node',
  'description' => 'Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.',
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'disabled' => '0',
  'orig_type' => 'article',
))
->values(array(
  'type' => 'class',
  'name' => 'Class',
  'base' => 'node_content',
  'module' => 'node',
  'description' => '',
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'disabled' => '0',
  'orig_type' => 'class',
))
->values(array(
  'type' => 'page',
  'name' => 'Basic page',
  'base' => 'node_content',
  'module' => 'node',
  'description' => "Use <em>basic pages</em> for your static content, such as an 'About us' page.",
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'disabled' => '0',
  'orig_type' => 'page',
))
->values(array(
  'type' => 'school',
  'name' => 'School',
  'base' => 'node_content',
  'module' => 'node',
  'description' => '',
  'help' => '',
  'has_title' => '1',
  'title_label' => 'Title',
  'custom' => '1',
  'modified' => '1',
  'locked' => '0',
  'disabled' => '0',
  'orig_type' => 'school',
))
->execute();

db_create_table('og', array(
  'fields' => array(
    'gid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'etid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'entity_type' => array(
      'type' => 'varchar',
      'length' => '32',
      'not null' => TRUE,
      'default' => '',
    ),
    'label' => array(
      'type' => 'varchar',
      'length' => '255',
      'not null' => TRUE,
      'default' => '',
    ),
    'state' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 1,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'gid',
  ),
  'indexes' => array(
    'entity' => array(
      'etid',
      'entity_type',
    ),
  ),
  'module' => 'og',
  'name' => 'og',
));
db_insert('og')->fields(array(
  'gid',
  'etid',
  'entity_type',
  'label',
  'state',
  'created',
))
->values(array(
  'gid' => '1',
  'etid' => '1',
  'entity_type' => 'node',
  'label' => 'Regular group',
  'state' => '1',
  'created' => '1346694728',
))
->values(array(
  'gid' => '2',
  'etid' => '2',
  'entity_type' => 'node',
  'label' => 'Override roles and permissions',
  'state' => '1',
  'created' => '1346694858',
))
->execute();

db_create_table('og_membership', array(
  'fields' => array(
    'id' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'etid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'entity_type' => array(
      'type' => 'varchar',
      'length' => '32',
      'not null' => TRUE,
      'default' => '',
    ),
    'gid' => array(
      'type' => 'int',
      'size' => 'normal',
      'not null' => TRUE,
    ),
    'state' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => FALSE,
      'default' => '',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'id',
  ),
  'indexes' => array(
    'entity' => array(
      'etid',
      'entity_type',
    ),
    'gid' => array(
      'gid',
    ),
  ),
  'foreign keys' => array(
    'og_membership_type' => array(
      'table' => 'og_membership_type',
      'columns' => array(
        'name' => 'name',
      ),
    ),
    'group' => array(
      'table' => 'og',
      'columns' => array(
        'gid' => 'gid',
      ),
    ),
  ),
  'module' => 'og',
  'name' => 'og_membership',
));
db_insert('og_membership')->fields(array(
  'id',
  'type',
  'etid',
  'entity_type',
  'gid',
  'state',
  'created',
))
->values(array(
  'id' => '1',
  'type' => 'og_membership_type_default',
  'etid' => '1',
  'entity_type' => 'user',
  'gid' => '1',
  'state' => '1',
  'created' => '1346694728',
))
->values(array(
  'id' => '2',
  'type' => 'og_membership_type_default',
  'etid' => '2',
  'entity_type' => 'user',
  'gid' => '1',
  'state' => '1',
  'created' => '1346694751',
))
->values(array(
  'id' => '3',
  'type' => 'og_membership_type_default',
  'etid' => '3',
  'entity_type' => 'user',
  'gid' => '1',
  'state' => '1',
  'created' => '1346694751',
))
->values(array(
  'id' => '4',
  'type' => 'og_membership_type_default',
  'etid' => '4',
  'entity_type' => 'user',
  'gid' => '1',
  'state' => '1',
  'created' => '1346694751',
))
->values(array(
  'id' => '5',
  'type' => 'og_membership_type_default',
  'etid' => '5',
  'entity_type' => 'user',
  'gid' => '1',
  'state' => '1',
  'created' => '1346694751',
))
->values(array(
  'id' => '6',
  'type' => 'og_membership_type_default',
  'etid' => '6',
  'entity_type' => 'user',
  'gid' => '1',
  'state' => '1',
  'created' => '1346694751',
))
->values(array(
  'id' => '7',
  'type' => 'og_membership_type_default',
  'etid' => '7',
  'entity_type' => 'user',
  'gid' => '1',
  'state' => '1',
  'created' => '1346694751',
))
->values(array(
  'id' => '8',
  'type' => 'og_membership_type_default',
  'etid' => '8',
  'entity_type' => 'user',
  'gid' => '1',
  'state' => '1',
  'created' => '1346694752',
))
->values(array(
  'id' => '9',
  'type' => 'og_membership_type_default',
  'etid' => '9',
  'entity_type' => 'user',
  'gid' => '1',
  'state' => '1',
  'created' => '1346694752',
))
->values(array(
  'id' => '10',
  'type' => 'og_membership_type_default',
  'etid' => '10',
  'entity_type' => 'user',
  'gid' => '1',
  'state' => '1',
  'created' => '1346694752',
))
->values(array(
  'id' => '11',
  'type' => 'og_membership_type_default',
  'etid' => '11',
  'entity_type' => 'user',
  'gid' => '1',
  'state' => '1',
  'created' => '1346694752',
))
->values(array(
  'id' => '12',
  'type' => 'og_membership_type_default',
  'etid' => '1',
  'entity_type' => 'user',
  'gid' => '2',
  'state' => '1',
  'created' => '1346694858',
))
->values(array(
  'id' => '13',
  'type' => 'og_membership_type_default',
  'etid' => '11',
  'entity_type' => 'user',
  'gid' => '2',
  'state' => '2',
  'created' => '1346694912',
))
->values(array(
  'id' => '14',
  'type' => 'og_membership_type_default',
  'etid' => '7',
  'entity_type' => 'user',
  'gid' => '2',
  'state' => '1',
  'created' => '1346694933',
))
->execute();

db_create_table('og_membership_type', array(
  'fields' => array(
    'id' => array(
      'type' => 'serial',
      'not null' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'description' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 1,
      'size' => 'tiny',
    ),
    'module' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => FALSE,
    ),
  ),
  'primary key' => array(
    'id',
  ),
  'unique keys' => array(
    'name' => array(
      'name',
    ),
  ),
  'module' => 'og',
  'name' => 'og_membership_type',
));
db_insert('og_membership_type')->fields(array(
  'id',
  'name',
  'description',
  'status',
  'module',
))
->values(array(
  'id' => '1',
  'name' => 'og_membership_type_default',
  'description' => 'Default',
  'status' => '2',
  'module' => 'og',
))
->execute();

db_create_table('og_role', array(
  'fields' => array(
    'rid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'gid' => array(
      'type' => 'int',
      'size' => 'normal',
      'not null' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
    ),
  ),
  'primary key' => array(
    'rid',
  ),
  'module' => 'og',
  'name' => 'og_role',
));
db_insert('og_role')->fields(array(
  'rid',
  'gid',
  'name',
))
->values(array(
  'rid' => '1',
  'gid' => '0',
  'name' => 'non-member',
))
->values(array(
  'rid' => '2',
  'gid' => '0',
  'name' => 'member',
))
->values(array(
  'rid' => '3',
  'gid' => '0',
  'name' => 'administrator member',
))
->values(array(
  'rid' => '4',
  'gid' => '2',
  'name' => 'non-member',
))
->values(array(
  'rid' => '5',
  'gid' => '2',
  'name' => 'member',
))
->values(array(
  'rid' => '6',
  'gid' => '2',
  'name' => 'administrator member',
))
->values(array(
  'rid' => '7',
  'gid' => '2',
  'name' => 'new role',
))
->execute();

db_create_table('og_role_permission', array(
  'fields' => array(
    'rid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'permission' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
    ),
    'module' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
  ),
  'primary key' => array(
    'rid',
    'permission',
  ),
  'indexes' => array(
    'permission' => array(
      'permission',
    ),
  ),
  'foreign keys' => array(
    'og_role' => array(
      'table' => 'og_role',
      'columns' => array(
        'rid' => 'rid',
      ),
    ),
  ),
  'module' => 'og',
  'name' => 'og_role_permission',
));
db_insert('og_role_permission')->fields(array(
  'rid',
  'permission',
  'module',
))
->values(array(
  'rid' => '1',
  'permission' => 'subscribe',
  'module' => 'og_ui',
))
->values(array(
  'rid' => '2',
  'permission' => 'unsubscribe',
  'module' => 'og_ui',
))
->values(array(
  'rid' => '3',
  'permission' => 'access administration pages',
  'module' => 'og_ui',
))
->values(array(
  'rid' => '3',
  'permission' => 'add user',
  'module' => 'og_ui',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer group',
  'module' => 'og',
))
->values(array(
  'rid' => '3',
  'permission' => 'approve and deny subscription',
  'module' => 'og_ui',
))
->values(array(
  'rid' => '3',
  'permission' => 'update group',
  'module' => 'og',
))
->values(array(
  'rid' => '4',
  'permission' => 'subscribe',
  'module' => 'og_ui',
))
->values(array(
  'rid' => '5',
  'permission' => 'unsubscribe',
  'module' => 'og_ui',
))
->values(array(
  'rid' => '6',
  'permission' => 'access administration pages',
  'module' => 'og_ui',
))
->values(array(
  'rid' => '6',
  'permission' => 'add user',
  'module' => 'og_ui',
))
->values(array(
  'rid' => '6',
  'permission' => 'administer group',
  'module' => 'og',
))
->values(array(
  'rid' => '6',
  'permission' => 'approve and deny subscription',
  'module' => 'og_ui',
))
->values(array(
  'rid' => '6',
  'permission' => 'update group',
  'module' => 'og',
))
->values(array(
  'rid' => '7',
  'permission' => 'update group',
  'module' => 'og',
))
->execute();

db_create_table('og_users_roles', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'rid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'gid' => array(
      'type' => 'int',
      'size' => 'normal',
      'not null' => TRUE,
    ),
  ),
  'primary key' => array(
    'uid',
    'rid',
    'gid',
  ),
  'indexes' => array(
    'rid' => array(
      'rid',
    ),
  ),
  'foreign keys' => array(
    'user' => array(
      'table' => 'users',
      'columns' => array(
        'uid' => 'uid',
      ),
    ),
    'og_role' => array(
      'table' => 'og_role',
      'columns' => array(
        'rid' => 'rid',
      ),
    ),
  ),
  'module' => 'og',
  'name' => 'og_users_roles',
));
db_insert('og_users_roles')->fields(array(
  'uid',
  'rid',
  'gid',
))
->values(array(
  'uid' => '7',
  'rid' => '7',
  'gid' => '2',
))
->execute();

db_create_table('queue', array(
  'fields' => array(
    'item_id' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
      'serialize' => TRUE,
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'item_id',
  ),
  'indexes' => array(
    'name_created' => array(
      'name',
      'created',
    ),
    'expire' => array(
      'expire',
    ),
  ),
  'module' => 'system',
  'name' => 'queue',
));
db_insert('queue')->fields(array(
  'item_id',
  'name',
  'data',
  'expire',
  'created',
))
->values(array(
  'item_id' => '2',
  'name' => 'update_fetch_tasks',
  'data' => 'a:8:{s:4:"name";s:5:"devel";s:4:"info";a:6:{s:4:"name";s:5:"Devel";s:7:"package";s:11:"Development";s:7:"version";s:7:"7.x-1.3";s:7:"project";s:5:"devel";s:9:"datestamp";s:10:"1338940281";s:16:"_info_file_ctime";i:1340904172;}s:9:"datestamp";s:10:"1338940281";s:8:"includes";a:1:{s:5:"devel";s:5:"Devel";}s:12:"project_type";s:6:"module";s:14:"project_status";b:1;s:10:"sub_themes";a:0:{}s:11:"base_themes";a:0:{}}',
  'expire' => '0',
  'created' => '1346694764',
))
->execute();

db_create_table('rdf_mapping', array(
  'fields' => array(
    'type' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
    ),
    'bundle' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
    ),
    'mapping' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
      'serialize' => TRUE,
    ),
  ),
  'primary key' => array(
    'type',
    'bundle',
  ),
  'module' => 'rdf',
  'name' => 'rdf_mapping',
));
db_insert('rdf_mapping')->fields(array(
  'type',
  'bundle',
  'mapping',
))
->values(array(
  'type' => 'node',
  'bundle' => 'article',
  'mapping' => 'a:11:{s:11:"field_image";a:2:{s:10:"predicates";a:2:{i:0;s:8:"og:image";i:1;s:12:"rdfs:seeAlso";}s:4:"type";s:3:"rel";}s:10:"field_tags";a:2:{s:10:"predicates";a:1:{i:0;s:10:"dc:subject";}s:4:"type";s:3:"rel";}s:7:"rdftype";a:2:{i:0;s:9:"sioc:Item";i:1;s:13:"foaf:Document";}s:5:"title";a:1:{s:10:"predicates";a:1:{i:0;s:8:"dc:title";}}s:7:"created";a:3:{s:10:"predicates";a:2:{i:0;s:7:"dc:date";i:1;s:10:"dc:created";}s:8:"datatype";s:12:"xsd:dateTime";s:8:"callback";s:12:"date_iso8601";}s:7:"changed";a:3:{s:10:"predicates";a:1:{i:0;s:11:"dc:modified";}s:8:"datatype";s:12:"xsd:dateTime";s:8:"callback";s:12:"date_iso8601";}s:4:"body";a:1:{s:10:"predicates";a:1:{i:0;s:15:"content:encoded";}}s:3:"uid";a:2:{s:10:"predicates";a:1:{i:0;s:16:"sioc:has_creator";}s:4:"type";s:3:"rel";}s:4:"name";a:1:{s:10:"predicates";a:1:{i:0;s:9:"foaf:name";}}s:13:"comment_count";a:2:{s:10:"predicates";a:1:{i:0;s:16:"sioc:num_replies";}s:8:"datatype";s:11:"xsd:integer";}s:13:"last_activity";a:3:{s:10:"predicates";a:1:{i:0;s:23:"sioc:last_activity_date";}s:8:"datatype";s:12:"xsd:dateTime";s:8:"callback";s:12:"date_iso8601";}}',
))
->values(array(
  'type' => 'node',
  'bundle' => 'page',
  'mapping' => 'a:9:{s:7:"rdftype";a:1:{i:0;s:13:"foaf:Document";}s:5:"title";a:1:{s:10:"predicates";a:1:{i:0;s:8:"dc:title";}}s:7:"created";a:3:{s:10:"predicates";a:2:{i:0;s:7:"dc:date";i:1;s:10:"dc:created";}s:8:"datatype";s:12:"xsd:dateTime";s:8:"callback";s:12:"date_iso8601";}s:7:"changed";a:3:{s:10:"predicates";a:1:{i:0;s:11:"dc:modified";}s:8:"datatype";s:12:"xsd:dateTime";s:8:"callback";s:12:"date_iso8601";}s:4:"body";a:1:{s:10:"predicates";a:1:{i:0;s:15:"content:encoded";}}s:3:"uid";a:2:{s:10:"predicates";a:1:{i:0;s:16:"sioc:has_creator";}s:4:"type";s:3:"rel";}s:4:"name";a:1:{s:10:"predicates";a:1:{i:0;s:9:"foaf:name";}}s:13:"comment_count";a:2:{s:10:"predicates";a:1:{i:0;s:16:"sioc:num_replies";}s:8:"datatype";s:11:"xsd:integer";}s:13:"last_activity";a:3:{s:10:"predicates";a:1:{i:0;s:23:"sioc:last_activity_date";}s:8:"datatype";s:12:"xsd:dateTime";s:8:"callback";s:12:"date_iso8601";}}',
))
->execute();

db_create_table('registry', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'length' => 9,
      'not null' => TRUE,
      'default' => '',
    ),
    'filename' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
    ),
    'module' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'name',
    'type',
  ),
  'indexes' => array(
    'hook' => array(
      'type',
      'weight',
      'module',
    ),
  ),
  'module' => 'system',
  'name' => 'registry',
));
db_insert('registry')->fields(array(
  'name',
  'type',
  'filename',
  'module',
  'weight',
))
->values(array(
  'name' => 'AccessDeniedTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'AdminMetaTagTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ArchiverInterface',
  'type' => 'interface',
  'filename' => 'includes/archiver.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'ArchiverTar',
  'type' => 'class',
  'filename' => 'modules/system/system.archiver.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ArchiverZip',
  'type' => 'class',
  'filename' => 'modules/system/system.archiver.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'Archive_Tar',
  'type' => 'class',
  'filename' => 'modules/system/system.tar.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'BatchMemoryQueue',
  'type' => 'class',
  'filename' => 'includes/batch.queue.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'BatchQueue',
  'type' => 'class',
  'filename' => 'includes/batch.queue.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockAdminThemeTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockCacheTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockHiddenRegionTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockHTMLIdTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockInvalidRegionTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockTemplateSuggestionsUnitTest',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'BlockTestCase',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'ColorTestCase',
  'type' => 'class',
  'filename' => 'modules/color/color.test',
  'module' => 'color',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentActionsTestCase',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentAnonymous',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentApprovalTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentBlockFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentContentRebuild',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentController',
  'type' => 'class',
  'filename' => 'modules/comment/comment.module',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentFieldsTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentHelperCase',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentInterfaceTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentNodeAccessTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentNodeChangesTestCase',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentPagerTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentPreviewTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentRSSUnitTest',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentThreadingTestCase',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'CommentTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/comment/comment.test',
  'module' => 'comment',
  'weight' => '0',
))
->values(array(
  'name' => 'ContextualDynamicContextTestCase',
  'type' => 'class',
  'filename' => 'modules/contextual/contextual.test',
  'module' => 'contextual',
  'weight' => '0',
))
->values(array(
  'name' => 'CronRunTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DashboardBlocksTestCase',
  'type' => 'class',
  'filename' => 'modules/dashboard/dashboard.test',
  'module' => 'dashboard',
  'weight' => '0',
))
->values(array(
  'name' => 'Database',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseCondition',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnection',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnectionNotDefinedException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnection_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnection_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseConnection_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseDriverNotSpecifiedException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseLog',
  'type' => 'class',
  'filename' => 'includes/database/log.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchema',
  'type' => 'class',
  'filename' => 'includes/database/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchemaObjectDoesNotExistException',
  'type' => 'class',
  'filename' => 'includes/database/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchemaObjectExistsException',
  'type' => 'class',
  'filename' => 'includes/database/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchema_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchema_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseSchema_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/schema.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatementBase',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatementEmpty',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatementInterface',
  'type' => 'interface',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatementPrefetch',
  'type' => 'class',
  'filename' => 'includes/database/prefetch.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseStatement_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTaskException',
  'type' => 'class',
  'filename' => 'includes/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTasks',
  'type' => 'class',
  'filename' => 'includes/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTasks_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTasks_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTasks_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransaction',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionCommitFailedException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionExplicitCommitNotAllowedException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionNameNonUniqueException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionNoActiveException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DatabaseTransactionOutOfOrderException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DateTimeFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DBLogTestCase',
  'type' => 'class',
  'filename' => 'modules/dblog/dblog.test',
  'module' => 'dblog',
  'weight' => '0',
))
->values(array(
  'name' => 'DefaultMailSystem',
  'type' => 'class',
  'filename' => 'modules/system/system.mail.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DeleteQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DeleteQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DevelMailLog',
  'type' => 'class',
  'filename' => 'sites/all/modules/devel/devel.mail.inc',
  'module' => 'devel',
  'weight' => '0',
))
->values(array(
  'name' => 'DevelMailTest',
  'type' => 'class',
  'filename' => 'sites/all/modules/devel/devel.test',
  'module' => 'devel',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalCacheArray',
  'type' => 'class',
  'filename' => 'includes/bootstrap.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalCacheInterface',
  'type' => 'interface',
  'filename' => 'includes/cache.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalDatabaseCache',
  'type' => 'class',
  'filename' => 'includes/cache.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalDefaultEntityController',
  'type' => 'class',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalEntityControllerInterface',
  'type' => 'interface',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalFakeCache',
  'type' => 'class',
  'filename' => 'includes/cache-install.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalLocalStreamWrapper',
  'type' => 'class',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalPrivateStreamWrapper',
  'type' => 'class',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalPublicStreamWrapper',
  'type' => 'class',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalQueue',
  'type' => 'class',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalQueueInterface',
  'type' => 'interface',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalReliableQueueInterface',
  'type' => 'interface',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalStreamWrapperInterface',
  'type' => 'interface',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalTemporaryStreamWrapper',
  'type' => 'class',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalUpdateException',
  'type' => 'class',
  'filename' => 'includes/update.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'DrupalUpdaterInterface',
  'type' => 'interface',
  'filename' => 'includes/updater.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'EnableDisableTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'Entity',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPIController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.controller.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPIControllerExportable',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.controller.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPIControllerInterface',
  'type' => 'interface',
  'filename' => 'sites/all/modules/entity/includes/entity.controller.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPIi18nItegrationTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPIRulesIntegrationTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityAPITestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDB',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDBExtendable',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDefaultFeaturesController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.features.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDefaultI18nStringController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.i18n.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDefaultMetadataController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.info.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDefaultRulesController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.rules.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDefaultUIController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.ui.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDefaultViewsController',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/entity.views.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityDrupalWrapper',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityExtendable',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityFieldHandlerHelper',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_field_handler_helper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityFieldQuery',
  'type' => 'class',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityFieldQueryException',
  'type' => 'class',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityListWrapper',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMalformedException',
  'type' => 'class',
  'filename' => 'includes/entity.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataArrayObject',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataIntegrationTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataWrapper',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataWrapperException',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityMetadataWrapperIterator',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityPropertiesTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityStructureWrapper',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityTokenTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityValueWrapper',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'EntityWebTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/entity.test',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_area_entity',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_area_entity.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_boolean',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_boolean.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_date',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_date.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_duration',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_duration.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_entity',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_entity.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_field',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_field.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_numeric',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_numeric.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_options',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_options.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_text',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_text.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_field_uri',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_uri.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_relationship',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_relationship.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_handler_relationship_by_bundle',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_relationship_by_bundle.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'entity_views_plugin_row_entity_view',
  'type' => 'class',
  'filename' => 'sites/all/modules/entity/views/plugins/entity_views_plugin_row_entity_view.inc',
  'module' => 'entity',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldAttachOtherTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldAttachStorageTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldAttachTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldBulkDeleteTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldCrudTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldDisplayAPITestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldException',
  'type' => 'class',
  'filename' => 'modules/field/field.module',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldFormTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldInfoTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldInstanceCrudTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldsOverlapException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldSqlStorageTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/field_sql_storage/field_sql_storage.test',
  'module' => 'field_sql_storage',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldTranslationsTestCase',
  'type' => 'class',
  'filename' => 'modules/field/tests/field.test',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUIAlterTestCase',
  'type' => 'class',
  'filename' => 'modules/field_ui/field_ui.test',
  'module' => 'field_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUIManageDisplayTestCase',
  'type' => 'class',
  'filename' => 'modules/field_ui/field_ui.test',
  'module' => 'field_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUIManageFieldsTestCase',
  'type' => 'class',
  'filename' => 'modules/field_ui/field_ui.test',
  'module' => 'field_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUITestCase',
  'type' => 'class',
  'filename' => 'modules/field_ui/field_ui.test',
  'module' => 'field_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldUpdateForbiddenException',
  'type' => 'class',
  'filename' => 'modules/field/field.module',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FieldValidationException',
  'type' => 'class',
  'filename' => 'modules/field/field.attach.inc',
  'module' => 'field',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldDisplayTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldPathTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldRevisionTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldValidateTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileFieldWidgetTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileManagedFileElementTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FilePrivateTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/file/tests/file.test',
  'module' => 'file',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransfer',
  'type' => 'class',
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferChmodInterface',
  'type' => 'interface',
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferException',
  'type' => 'class',
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferFTP',
  'type' => 'class',
  'filename' => 'includes/filetransfer/ftp.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferFTPExtension',
  'type' => 'class',
  'filename' => 'includes/filetransfer/ftp.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferLocal',
  'type' => 'class',
  'filename' => 'includes/filetransfer/local.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FileTransferSSH',
  'type' => 'class',
  'filename' => 'includes/filetransfer/ssh.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterCRUDTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterDefaultFormatTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterFormatAccessTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterHooksTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterNoFormatTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterSecurityTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterSettingsTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FilterUnitTestCase',
  'type' => 'class',
  'filename' => 'modules/filter/filter.test',
  'module' => 'filter',
  'weight' => '0',
))
->values(array(
  'name' => 'FloodFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'FrontPageTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'HelpTestCase',
  'type' => 'class',
  'filename' => 'modules/help/help.test',
  'module' => 'help',
  'weight' => '0',
))
->values(array(
  'name' => 'HookRequirementsTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageAdminStylesUnitTest',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageDimensionsScaleTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageDimensionsTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageEffectsUnitTest',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageFieldDefaultImagesTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageFieldDisplayTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageFieldValidateTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'ImageStylesPathAndUrlTestCase',
  'type' => 'class',
  'filename' => 'modules/image/image.test',
  'module' => 'image',
  'weight' => '0',
))
->values(array(
  'name' => 'InfoFileParserTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'InsertQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InsertQuery_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InsertQuery_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InsertQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'InvalidMergeQueryException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'IPAddressBlockingTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ListDynamicValuesTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/list/tests/list.test',
  'module' => 'list',
  'weight' => '0',
))
->values(array(
  'name' => 'ListDynamicValuesValidationTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/list/tests/list.test',
  'module' => 'list',
  'weight' => '0',
))
->values(array(
  'name' => 'ListFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/list/tests/list.test',
  'module' => 'list',
  'weight' => '0',
))
->values(array(
  'name' => 'ListFieldUITestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/list/tests/list.test',
  'module' => 'list',
  'weight' => '0',
))
->values(array(
  'name' => 'MailSystemInterface',
  'type' => 'interface',
  'filename' => 'includes/mail.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'MemoryQueue',
  'type' => 'class',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'MenuNodeTestCase',
  'type' => 'class',
  'filename' => 'modules/menu/menu.test',
  'module' => 'menu',
  'weight' => '0',
))
->values(array(
  'name' => 'MenuTestCase',
  'type' => 'class',
  'filename' => 'modules/menu/menu.test',
  'module' => 'menu',
  'weight' => '0',
))
->values(array(
  'name' => 'MergeQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleDependencyTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleRequiredTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleUpdater',
  'type' => 'class',
  'filename' => 'modules/system/system.updater.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'ModuleVersionTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'MultiStepNodeFormBasicOptionsTest',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NewDefaultThemeBlocks',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessBaseTableTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessPagerTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessRebuildTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessRecordsTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAccessTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeBlockFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeBlockTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeBuildContent',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeController',
  'type' => 'class',
  'filename' => 'modules/node/node.module',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeCreationTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeEntityFieldQueryAlter',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeFeedTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeLoadHooksTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeLoadMultipleTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodePostSettingsTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeQueryAlter',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeRevisionPermissionsTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeRevisionsTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeRSSContentTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeSaveTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTitleTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTitleXSSTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTypePersistenceTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeTypeTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NodeWebTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'NoFieldsException',
  'type' => 'class',
  'filename' => 'includes/database/database.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'NoHelpTestCase',
  'type' => 'class',
  'filename' => 'modules/help/help.test',
  'module' => 'help',
  'weight' => '0',
))
->values(array(
  'name' => 'NonDefaultBlockAdmin',
  'type' => 'class',
  'filename' => 'modules/block/block.test',
  'module' => 'block',
  'weight' => '0',
))
->values(array(
  'name' => 'NumberFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/number/number.test',
  'module' => 'number',
  'weight' => '0',
))
->values(array(
  'name' => 'OgDefaultAccessFieldTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/og.test',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'OgException',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/og.module',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'OgGroup',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/og.module',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'OgGroupAndUngroup',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/og.test',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'OgGroupApi',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/og.test',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'OgGroupAudienceField',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/og.test',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'OgGroupMembership',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/og.test',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'OgMembership',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/og.module',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'OgMembershipMetadataController',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/includes/og.info.inc',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'OgMembershipType',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/og.module',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'OgMembershipTypeUIController',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/includes/og.admin.inc',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'OgMembershipViewsController',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/includes/og.views.inc',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'OgMetadataController',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/includes/og.info.inc',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'OgMigrateGroupMembershipTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/og.test',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'OgNodeAccess',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/og.test',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'OGRulesDataUIGroup',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/og.rules.inc',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'OgTranslationTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/og.test',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'OgUiManagePeopleTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/og_ui/og_ui.test',
  'module' => 'og_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'OgUiSubscribeTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/og_ui/og_ui.test',
  'module' => 'og_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'OgUiUpgradePathTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/og_ui/og_ui.test',
  'module' => 'og_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'OgUiUserPermissionsTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/og_ui/og_ui.test',
  'module' => 'og_ui',
  'weight' => '0',
))
->values(array(
  'name' => 'OgUnInstallTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/og.test',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'OgUserPermissionsTestCase',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/og.test',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'OgViewsController',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/includes/og.views.inc',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'og_handler_argument_group_audience_gid',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/includes/views/og_handler_argument_group_audience_gid.inc',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'og_handler_field_group_audience_state',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/includes/views/og_handler_field_group_audience_state.inc',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'og_handler_field_group_permissions',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/includes/views/og_handler_field_group_permissions.inc',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'og_handler_field_prerender_list',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/includes/views/og_handler_field_prerender_list.inc',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'og_handler_field_user_roles',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/includes/views/og_handler_field_user_roles.inc',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'og_handler_filter_group_audience_state',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/includes/views/og_handler_filter_group_audience_state.inc',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'og_handler_filter_group_roles',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/includes/views/og_handler_filter_group_roles.inc',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'og_handler_filter_group_state',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/includes/views/og_handler_filter_group_state.inc',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'og_handler_relationship',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/includes/views/og_handler_relationship.inc',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'og_plugin_argument_default_user_groups',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/includes/views/og_plugin_argument_default_user_groups.inc',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'og_plugin_argument_validate_group',
  'type' => 'class',
  'filename' => 'sites/all/modules/og/includes/views/og_plugin_argument_validate_group.inc',
  'module' => 'og',
  'weight' => '0',
))
->values(array(
  'name' => 'OptionsSelectDynamicValuesTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/options/options.test',
  'module' => 'options',
  'weight' => '0',
))
->values(array(
  'name' => 'OptionsWidgetsTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/options/options.test',
  'module' => 'options',
  'weight' => '0',
))
->values(array(
  'name' => 'PageEditTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'PageNotFoundTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'PagePreviewTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'PagerDefault',
  'type' => 'class',
  'filename' => 'includes/pager.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'PageTitleFiltering',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'PageViewTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'PathLanguageTestCase',
  'type' => 'class',
  'filename' => 'modules/path/path.test',
  'module' => 'path',
  'weight' => '0',
))
->values(array(
  'name' => 'PathLanguageUITestCase',
  'type' => 'class',
  'filename' => 'modules/path/path.test',
  'module' => 'path',
  'weight' => '0',
))
->values(array(
  'name' => 'PathMonolingualTestCase',
  'type' => 'class',
  'filename' => 'modules/path/path.test',
  'module' => 'path',
  'weight' => '0',
))
->values(array(
  'name' => 'PathTaxonomyTermTestCase',
  'type' => 'class',
  'filename' => 'modules/path/path.test',
  'module' => 'path',
  'weight' => '0',
))
->values(array(
  'name' => 'PathTestCase',
  'type' => 'class',
  'filename' => 'modules/path/path.test',
  'module' => 'path',
  'weight' => '0',
))
->values(array(
  'name' => 'Query',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueryAlterableInterface',
  'type' => 'interface',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueryConditionInterface',
  'type' => 'interface',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueryExtendableInterface',
  'type' => 'interface',
  'filename' => 'includes/database/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueryPlaceholderInterface',
  'type' => 'interface',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'QueueTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'RdfCommentAttributesTestCase',
  'type' => 'class',
  'filename' => 'modules/rdf/rdf.test',
  'module' => 'rdf',
  'weight' => '0',
))
->values(array(
  'name' => 'RdfCrudTestCase',
  'type' => 'class',
  'filename' => 'modules/rdf/rdf.test',
  'module' => 'rdf',
  'weight' => '0',
))
->values(array(
  'name' => 'RdfGetRdfNamespacesTestCase',
  'type' => 'class',
  'filename' => 'modules/rdf/rdf.test',
  'module' => 'rdf',
  'weight' => '0',
))
->values(array(
  'name' => 'RdfMappingDefinitionTestCase',
  'type' => 'class',
  'filename' => 'modules/rdf/rdf.test',
  'module' => 'rdf',
  'weight' => '0',
))
->values(array(
  'name' => 'RdfMappingHookTestCase',
  'type' => 'class',
  'filename' => 'modules/rdf/rdf.test',
  'module' => 'rdf',
  'weight' => '0',
))
->values(array(
  'name' => 'RdfRdfaMarkupTestCase',
  'type' => 'class',
  'filename' => 'modules/rdf/rdf.test',
  'module' => 'rdf',
  'weight' => '0',
))
->values(array(
  'name' => 'RdfTrackerAttributesTestCase',
  'type' => 'class',
  'filename' => 'modules/rdf/rdf.test',
  'module' => 'rdf',
  'weight' => '0',
))
->values(array(
  'name' => 'RetrieveFileTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SchemaCache',
  'type' => 'class',
  'filename' => 'includes/bootstrap.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchAdvancedSearchForm',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchBlockTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchCommentCountToggleTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchCommentTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchConfigSettingsForm',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchEmbedForm',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchExactTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchExcerptTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchExpressionInsertExtractTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchKeywordsConditions',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchLanguageTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchMatchTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchNodeAccessTest',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchNumberMatchingTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchNumbersTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchPageOverride',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchPageText',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchQuery',
  'type' => 'class',
  'filename' => 'modules/search/search.extender.inc',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchRankingTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchSimplifyTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SearchTokenizerTestCase',
  'type' => 'class',
  'filename' => 'modules/search/search.test',
  'module' => 'search',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQuery',
  'type' => 'class',
  'filename' => 'includes/database/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQueryExtender',
  'type' => 'class',
  'filename' => 'includes/database/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQueryInterface',
  'type' => 'interface',
  'filename' => 'includes/database/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQuery_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SelectQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/select.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'ShortcutLinksTestCase',
  'type' => 'class',
  'filename' => 'modules/shortcut/shortcut.test',
  'module' => 'shortcut',
  'weight' => '0',
))
->values(array(
  'name' => 'ShortcutSetsTestCase',
  'type' => 'class',
  'filename' => 'modules/shortcut/shortcut.test',
  'module' => 'shortcut',
  'weight' => '0',
))
->values(array(
  'name' => 'ShortcutTestCase',
  'type' => 'class',
  'filename' => 'modules/shortcut/shortcut.test',
  'module' => 'shortcut',
  'weight' => '0',
))
->values(array(
  'name' => 'ShutdownFunctionsTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SiteMaintenanceTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SkipDotsRecursiveDirectoryIterator',
  'type' => 'class',
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'StreamWrapperInterface',
  'type' => 'interface',
  'filename' => 'includes/stream_wrappers.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'SummaryLengthTestCase',
  'type' => 'class',
  'filename' => 'modules/node/node.test',
  'module' => 'node',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemAuthorizeCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemBlockTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemIndexPhpTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemInfoAlterTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemMainContentFallback',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemQueue',
  'type' => 'class',
  'filename' => 'modules/system/system.queue.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'SystemThemeFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TableSort',
  'type' => 'class',
  'filename' => 'includes/tablesort.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyEFQTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyHooksTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyLegacyTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyLoadMultipleTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyRSSTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTermController',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.module',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTermFieldMultipleVocabularyTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTermFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTermFunctionTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTermIndexTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTermTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyThemeTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyVocabularyController',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.module',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyVocabularyFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyVocabularyTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TaxonomyWebTestCase',
  'type' => 'class',
  'filename' => 'modules/taxonomy/taxonomy.test',
  'module' => 'taxonomy',
  'weight' => '0',
))
->values(array(
  'name' => 'TestingMailSystem',
  'type' => 'class',
  'filename' => 'modules/system/system.mail.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TextFieldTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/text/text.test',
  'module' => 'text',
  'weight' => '0',
))
->values(array(
  'name' => 'TextSummaryTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/text/text.test',
  'module' => 'text',
  'weight' => '0',
))
->values(array(
  'name' => 'TextTranslationTestCase',
  'type' => 'class',
  'filename' => 'modules/field/modules/text/text.test',
  'module' => 'text',
  'weight' => '0',
))
->values(array(
  'name' => 'ThemeRegistry',
  'type' => 'class',
  'filename' => 'includes/theme.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'ThemeUpdater',
  'type' => 'class',
  'filename' => 'modules/system/system.updater.inc',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'TruncateQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'TruncateQuery_mysql',
  'type' => 'class',
  'filename' => 'includes/database/mysql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'TruncateQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateCoreTestCase',
  'type' => 'class',
  'filename' => 'modules/update/update.test',
  'module' => 'update',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateCoreUnitTestCase',
  'type' => 'class',
  'filename' => 'modules/update/update.test',
  'module' => 'update',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateQuery',
  'type' => 'class',
  'filename' => 'includes/database/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateQuery_pgsql',
  'type' => 'class',
  'filename' => 'includes/database/pgsql/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateQuery_sqlite',
  'type' => 'class',
  'filename' => 'includes/database/sqlite/query.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'Updater',
  'type' => 'class',
  'filename' => 'includes/updater.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdaterException',
  'type' => 'class',
  'filename' => 'includes/updater.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdaterFileTransferException',
  'type' => 'class',
  'filename' => 'includes/updater.inc',
  'module' => '',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateScriptFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/system/system.test',
  'module' => 'system',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateTestContribCase',
  'type' => 'class',
  'filename' => 'modules/update/update.test',
  'module' => 'update',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateTestHelper',
  'type' => 'class',
  'filename' => 'modules/update/update.test',
  'module' => 'update',
  'weight' => '0',
))
->values(array(
  'name' => 'UpdateTestUploadCase',
  'type' => 'class',
  'filename' => 'modules/update/update.test',
  'module' => 'update',
  'weight' => '0',
))
->values(array(
  'name' => 'UserAccountLinksUnitTests',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserAuthmapAssignmentTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserAutocompleteTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserBlocksUnitTests',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserCancelTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserController',
  'type' => 'class',
  'filename' => 'modules/user/user.module',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserCreateTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserEditedOwnAccountTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserEditTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserLoginTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserPermissionsTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserPictureTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserRegistrationTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserRoleAdminTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserRolesAssignmentTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserSaveTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserSignatureTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserTimeZoneFunctionalTest',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserTokenReplaceTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserUserSearchTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserValidateCurrentPassCustomForm',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->values(array(
  'name' => 'UserValidationTestCase',
  'type' => 'class',
  'filename' => 'modules/user/user.test',
  'module' => 'user',
  'weight' => '0',
))
->execute();

db_create_table('registry_file', array(
  'fields' => array(
    'filename' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
    ),
    'hash' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
    ),
  ),
  'primary key' => array(
    'filename',
  ),
  'module' => 'system',
  'name' => 'registry_file',
));
db_insert('registry_file')->fields(array(
  'filename',
  'hash',
))
->values(array(
  'filename' => 'includes/actions.inc',
  'hash' => 'f36b066681463c7dfe189e0430cb1a89bf66f7e228cbb53cdfcd93987193f759',
))
->values(array(
  'filename' => 'includes/ajax.inc',
  'hash' => 'e9c0653a0df32a81577d64980d74ef4f2423573b15fc86e9d7aa65227b52f470',
))
->values(array(
  'filename' => 'includes/archiver.inc',
  'hash' => 'bdbb21b712a62f6b913590b609fd17cd9f3c3b77c0d21f68e71a78427ed2e3e9',
))
->values(array(
  'filename' => 'includes/authorize.inc',
  'hash' => 'a8f26e722ddba490cdc0fcf80238af45f0f88e977b2e0c90c0c21d9df3380748',
))
->values(array(
  'filename' => 'includes/batch.inc',
  'hash' => '059da9e36e1f3717f27840aae73f10dea7d6c8daf16f6520401cc1ca3b4c0388',
))
->values(array(
  'filename' => 'includes/batch.queue.inc',
  'hash' => '554b2e92e1dad0f7fd5a19cb8dff7e109f10fbe2441a5692d076338ec908de0f',
))
->values(array(
  'filename' => 'includes/bootstrap.inc',
  'hash' => 'd2e5412768632f58a24251a1729265ff74c2e9d962a67ef54001bdad87b379fd',
))
->values(array(
  'filename' => 'includes/cache-install.inc',
  'hash' => 'e7ed123c5805703c84ad2cce9c1ca46b3ce8caeeea0d8ef39a3024a4ab95fa0e',
))
->values(array(
  'filename' => 'includes/cache.inc',
  'hash' => '0a70a291f7ce423d1aab4816ef06a6eaf58b454a03a1f419ff309c1147c4765b',
))
->values(array(
  'filename' => 'includes/common.inc',
  'hash' => '4221d29865a72c7735baf6dbe860b2a6e6b721d62f7709ef807f4737f13a6824',
))
->values(array(
  'filename' => 'includes/database/database.inc',
  'hash' => '7f2fbb35ace24cf468a98eabfac33745bd1d610c07612b40fad6afc320cfa5a1',
))
->values(array(
  'filename' => 'includes/database/log.inc',
  'hash' => '4ecbdf9022d8c612310b41af575f10b0d4c041c0fbc41c6dc7e1f2ab6eacce6b',
))
->values(array(
  'filename' => 'includes/database/mysql/database.inc',
  'hash' => 'd4648a3212519b038654457b83466aabc1b928affdd56076c655ba3d8b79a54b',
))
->values(array(
  'filename' => 'includes/database/mysql/install.inc',
  'hash' => '6ae316941f771732fbbabed7e1d6b4cbb41b1f429dd097d04b3345aa15e461a0',
))
->values(array(
  'filename' => 'includes/database/mysql/query.inc',
  'hash' => '7d9ea18a7ff04b7aab6210abbd0313cb53325c19a47ff8ed6c0e591c6e7149c2',
))
->values(array(
  'filename' => 'includes/database/mysql/schema.inc',
  'hash' => 'd8d3904ea9c23a526c2f2a7acc8ba870b31c378aac2eb53e2e41a73c6209c5bd',
))
->values(array(
  'filename' => 'includes/database/pgsql/database.inc',
  'hash' => '3c981696486d3ec21f508b47516fa078ffc885703179e5ef1ca5b894c89b2fe4',
))
->values(array(
  'filename' => 'includes/database/pgsql/install.inc',
  'hash' => '585b80c5bbd6f134bff60d06397f15154657a577d4da8d1b181858905f09dea5',
))
->values(array(
  'filename' => 'includes/database/pgsql/query.inc',
  'hash' => 'cb4c84f8f1ffc73098ed71137248dcd078a505a7530e60d979d74b3a3cdaa658',
))
->values(array(
  'filename' => 'includes/database/pgsql/schema.inc',
  'hash' => '8fd647e4557522283caef63e528c6e403fc0751a46e94aac867a281af85eac27',
))
->values(array(
  'filename' => 'includes/database/pgsql/select.inc',
  'hash' => 'fd4bba7887c1dc6abc8f080fc3a76c01d92ea085434e355dc1ecb50d8743c22d',
))
->values(array(
  'filename' => 'includes/database/prefetch.inc',
  'hash' => 'b5b207a66a69ecb52ee4f4459af16a7b5eabedc87254245f37cc33bebb61c0fb',
))
->values(array(
  'filename' => 'includes/database/query.inc',
  'hash' => '128b5fdb90562d7f7a9e2662ff6f35251b1370ac215298e2c3297c87ebafd961',
))
->values(array(
  'filename' => 'includes/database/schema.inc',
  'hash' => '7eb7251f331109757173353263d1031493c1198ae17a165a6f5a03d3f14f93e7',
))
->values(array(
  'filename' => 'includes/database/select.inc',
  'hash' => '1c74fa55c7721a704f5ef3389032604bf7a60fced15c40d844aee3e1cead7dc6',
))
->values(array(
  'filename' => 'includes/database/sqlite/database.inc',
  'hash' => 'ed2b9981794239cdad2cd04cf4bcdc896ad4d6b66179a4fa487b0d1ec2150a10',
))
->values(array(
  'filename' => 'includes/database/sqlite/install.inc',
  'hash' => '381f3db8c59837d961978ba3097bb6443534ed1659fd713aa563963fa0c42cc5',
))
->values(array(
  'filename' => 'includes/database/sqlite/query.inc',
  'hash' => '523ff7c05aa2b2aca08cad3743b321868ec772856f2b1c7af908bb236c6919ad',
))
->values(array(
  'filename' => 'includes/database/sqlite/schema.inc',
  'hash' => '238414785aa96dd27f10f48c961783f4d1091392beee8d0e7ca8ae774e917da2',
))
->values(array(
  'filename' => 'includes/database/sqlite/select.inc',
  'hash' => '8d1c426dbd337733c206cce9f59a172546c6ed856d8ef3f1c7bef05a16f7bf68',
))
->values(array(
  'filename' => 'includes/date.inc',
  'hash' => '18c047be64f201e16d189f1cc47ed9dcf0a145151b1ee187e90511b24e5d2b36',
))
->values(array(
  'filename' => 'includes/entity.inc',
  'hash' => '26686167f5d515d17f607daef9eb1ab8858dc257cd0c807ec625681b3e3bf479',
))
->values(array(
  'filename' => 'includes/errors.inc',
  'hash' => 'b4adafbd9ccbc578bc42af78d14d7d3fa508fa10981555aacc9ff5e00a1fa1d8',
))
->values(array(
  'filename' => 'includes/file.inc',
  'hash' => '042fed00746880123a3e4d95f138a3d8bc169a77b9cbae98cd05c1840375297d',
))
->values(array(
  'filename' => 'includes/file.mimetypes.inc',
  'hash' => 'f88c967550576694b7a1ce2afd0f2f1bbc1a91d21cc2c20f86c44d39ff353867',
))
->values(array(
  'filename' => 'includes/filetransfer/filetransfer.inc',
  'hash' => '4391b7228bd952fb351c9431a7c226b4e8a23d9a7307b9ffa63e097c17b25467',
))
->values(array(
  'filename' => 'includes/filetransfer/ftp.inc',
  'hash' => '589ebf4b8bd4a2973aa56a156ac1fa83b6c73e703391361fb573167670e0d832',
))
->values(array(
  'filename' => 'includes/filetransfer/local.inc',
  'hash' => '7cbfdb46abbdf539640db27e66fb30e5265128f31002bd0dfc3af16ae01a9492',
))
->values(array(
  'filename' => 'includes/filetransfer/ssh.inc',
  'hash' => '002e24a24cac133d12728bd3843868ce378681237d7fad420761af84e6efe5ad',
))
->values(array(
  'filename' => 'includes/form.inc',
  'hash' => '40dd471065980072fc1bb174b72b485ab1a2adb5dd9ae1c7c54dac66eb96187e',
))
->values(array(
  'filename' => 'includes/graph.inc',
  'hash' => '8e0e313a8bb33488f371df11fc1b58d7cf80099b886cd1003871e2c896d1b536',
))
->values(array(
  'filename' => 'includes/image.inc',
  'hash' => '22c8ff48d46276b9bea1ad2cf4af9b65abcf69fb5ebca441259e774190fa5863',
))
->values(array(
  'filename' => 'includes/install.core.inc',
  'hash' => 'a56ff7412d5fb68221a9f3bdd9f710d9f331f2d2c4bbb62ed98cb3c79c6882d5',
))
->values(array(
  'filename' => 'includes/install.inc',
  'hash' => '23455f095ebd75c49ef8bf2a18145f77b6633670a5eb9eab860d907b0ba25f35',
))
->values(array(
  'filename' => 'includes/iso.inc',
  'hash' => 'f53653843c75e12aa0b05e7197c5aebdf794e2517b9902fc07994fb7cb8f3ed6',
))
->values(array(
  'filename' => 'includes/json-encode.inc',
  'hash' => '02a822a652d00151f79db9aa9e171c310b69b93a12f549bc2ce00533a8efa14e',
))
->values(array(
  'filename' => 'includes/language.inc',
  'hash' => '2660a308eefd99f1aec300d1f8e51365a4331ca8af2b9056e5df528cd5b03a89',
))
->values(array(
  'filename' => 'includes/locale.inc',
  'hash' => '2ec00f6167fda3eca53a031344070b1d16398951acba735c55fedd1a2f178321',
))
->values(array(
  'filename' => 'includes/lock.inc',
  'hash' => 'daa62e95528f6b986b85680b600a896452bf2ce6f38921242857dcc5a3460a1b',
))
->values(array(
  'filename' => 'includes/mail.inc',
  'hash' => 'bb50727f20717ffa17cbe11ddb27bd004bd814fc26115c3fca4b06f4cec179fa',
))
->values(array(
  'filename' => 'includes/menu.inc',
  'hash' => '1fa6f6b0ffc711e352b48ef7f78e399536ed91ba56ad7ed333e34ed7a93228c1',
))
->values(array(
  'filename' => 'includes/module.inc',
  'hash' => 'c12df1e05bb0c546722fe9c5221e3a1a91de504a66b5aeb6fe8ef8348a048d35',
))
->values(array(
  'filename' => 'includes/pager.inc',
  'hash' => '6f9494b85c07a2cc3be4e54aff2d2757485238c476a7da084d25bde1d88be6d8',
))
->values(array(
  'filename' => 'includes/password.inc',
  'hash' => 'aba5df25a237c14cc69335c4cf72d57da130144410ab04d10917d9da21cd606c',
))
->values(array(
  'filename' => 'includes/path.inc',
  'hash' => '1d939d6b59b07ef41e71c9d616c2e9a34712dd81f6110e1a1f280613b3228738',
))
->values(array(
  'filename' => 'includes/registry.inc',
  'hash' => '4ffb8c9c8c179c1417ff01790f339edf50b5f7cc0c8bb976eef6858cc71e9bc8',
))
->values(array(
  'filename' => 'includes/session.inc',
  'hash' => '8293e6cc9f081ecdc4e8cfcdec885a79df01b9007030fe6b467a85c87ebb5d82',
))
->values(array(
  'filename' => 'includes/stream_wrappers.inc',
  'hash' => '323e418fda2fdd29a44d8618f8855a92172c377eb745412d58ca55fdcaa8f2d1',
))
->values(array(
  'filename' => 'includes/tablesort.inc',
  'hash' => '3f3cb2820920f7edc0c3d046ffba4fc4e3b73a699a2492780371141cf501aa50',
))
->values(array(
  'filename' => 'includes/theme.inc',
  'hash' => '330f3fb0021891335e7094bdd129c68302d293579052f31594f01724a00f13d8',
))
->values(array(
  'filename' => 'includes/theme.maintenance.inc',
  'hash' => 'd110314b4d943c3e965fcefe452f6873b53cd6a8844154467dfcbb2b6142dc82',
))
->values(array(
  'filename' => 'includes/token.inc',
  'hash' => 'a975300558711bb49406a5c7f78294648baa2e5c912cb66f0c78bb2991c0f3c3',
))
->values(array(
  'filename' => 'includes/unicode.entities.inc',
  'hash' => '2b858138596d961fbaa4c6e3986e409921df7f76b6ee1b109c4af5970f1e0f54',
))
->values(array(
  'filename' => 'includes/unicode.inc',
  'hash' => '3d5a4756f7af1f9de84f7614b6cd87449af43f4bb1e2a77bb2c73589f5826f61',
))
->values(array(
  'filename' => 'includes/update.inc',
  'hash' => '132a2e54d9a7008ce3d71fdbcdcf3653a143b011508004b977f3493328488090',
))
->values(array(
  'filename' => 'includes/updater.inc',
  'hash' => 'd2da0e74ed86e93c209f16069f3d32e1a134ceb6c06a0044f78e841a1b54e380',
))
->values(array(
  'filename' => 'includes/utility.inc',
  'hash' => '9b834814fd3f5ef10ce1946be30ef1ddf3f283c749f1ef1a4ebf845ecd524d59',
))
->values(array(
  'filename' => 'includes/xmlrpc.inc',
  'hash' => 'c5b6ea78adeb135373d11aeaaea057d9fa8995faa4e8c0fec9b7c647f15cc4e0',
))
->values(array(
  'filename' => 'includes/xmlrpcs.inc',
  'hash' => '79dc6e9882f4c506123d7dd8e228a61e22c46979c3aab21a5b1afa315ef6639c',
))
->values(array(
  'filename' => 'modules/block/block.test',
  'hash' => 'b8fc64b16b03fc49d44f2fe4b3711736323effc5e0addbc3e74be91ec2bb3872',
))
->values(array(
  'filename' => 'modules/color/color.test',
  'hash' => '013806279bd47ceb2f82ca854b57f880ba21058f7a2592c422afae881a7f5d15',
))
->values(array(
  'filename' => 'modules/comment/comment.module',
  'hash' => 'cb7a5a94771d190895b13972e3914f567df5665b521fe082a89c3c3fb7f1634a',
))
->values(array(
  'filename' => 'modules/comment/comment.test',
  'hash' => '1f41eca8bc1f0dbcd262e87305f8a415ad9c2325ff71e971de99f5d7bb12018c',
))
->values(array(
  'filename' => 'modules/contextual/contextual.test',
  'hash' => '023dafa199bd325ecc55a17b2a3db46ac0a31e23059f701f789f3bc42427ba0b',
))
->values(array(
  'filename' => 'modules/dashboard/dashboard.test',
  'hash' => '270378b5c8ed0e7d0e00fbc62e617813c6dec1d79396229786942bf9fb738e16',
))
->values(array(
  'filename' => 'modules/dblog/dblog.test',
  'hash' => '702c6a6207a73d8a29c857d8ca298e9740a02f09072da2f5624e7090e8a92acf',
))
->values(array(
  'filename' => 'modules/field/field.attach.inc',
  'hash' => 'd1d0d7e63ccbe1e184bd137adfd0b17434f7a85ff97c579155bb88130fc1f3c5',
))
->values(array(
  'filename' => 'modules/field/field.module',
  'hash' => 'f0f595c348e8937da14062302bbffedb6fc45d39efac07622813804baab329b8',
))
->values(array(
  'filename' => 'modules/field/modules/field_sql_storage/field_sql_storage.test',
  'hash' => '8ede9843d771e307dfd3d7e7562976b07e0e0a9310a5cf409413581f199c897f',
))
->values(array(
  'filename' => 'modules/field/modules/list/tests/list.test',
  'hash' => '9f366469763beb3fe0571d66318bac6df293fd15f4eb5cfe4850b9fb9a509f38',
))
->values(array(
  'filename' => 'modules/field/modules/number/number.test',
  'hash' => 'cb55fbc3a1ceed154af673af727b4c5ee6ac2e7dc9d4e1cbc33f3f8e2269146c',
))
->values(array(
  'filename' => 'modules/field/modules/options/options.test',
  'hash' => '8c6dd464fdb5cca90b0260bcfa5f56941b4b28edd879b23a795f0442f5368d4c',
))
->values(array(
  'filename' => 'modules/field/modules/text/text.test',
  'hash' => '9d74c6d039f55dd7d6447a59186da8d48bf20617bfe58424612798f649797586',
))
->values(array(
  'filename' => 'modules/field/tests/field.test',
  'hash' => '326527d0976746570f11f1ebf197d81e62fa00a5d33ec01ee377ba4d9f2f2bd8',
))
->values(array(
  'filename' => 'modules/field_ui/field_ui.test',
  'hash' => 'c40ecf17d601036f92b419938617a51d64a92821cdb2171793b76f7abdd2c9ff',
))
->values(array(
  'filename' => 'modules/file/tests/file.test',
  'hash' => '802532f0032f1740592379d7bd9c93f8c453f68b93f11bf0143bd5de648659c8',
))
->values(array(
  'filename' => 'modules/filter/filter.test',
  'hash' => 'f439e0d529cae5089990c7f0c5059ece953ae14c56e8a753d6375acf0f873560',
))
->values(array(
  'filename' => 'modules/help/help.test',
  'hash' => 'c6f03ece30548a6a345afcfac920d85afc418596a19dc4cf43f994391c5050d9',
))
->values(array(
  'filename' => 'modules/image/image.test',
  'hash' => '4ff412f8946d1354971c950b0bff12179b8f95fe1585da0d46267ecb42109da6',
))
->values(array(
  'filename' => 'modules/menu/menu.test',
  'hash' => 'b8ee602184584fab464900a946090dc1f3d81c15b8176004ee62022814632430',
))
->values(array(
  'filename' => 'modules/node/node.module',
  'hash' => '0f133f5f67a3db6b5ec002efa267df4f86f3dbaa1b64064584f8f508c198eeb8',
))
->values(array(
  'filename' => 'modules/node/node.test',
  'hash' => '4954097e260c0a80381b9a88640d72ea66ed8bfc373b8500006abee1d69511a9',
))
->values(array(
  'filename' => 'modules/path/path.test',
  'hash' => 'c05b26db575e93a73f2e4c8eaa6091b4fe8fc805f59620c2f7e1276cc206ba9d',
))
->values(array(
  'filename' => 'modules/rdf/rdf.test',
  'hash' => '358e2ae2069a15c6ba828f3428ab979632ece7aa0ba33a6a5bdbc1d065961373',
))
->values(array(
  'filename' => 'modules/search/search.extender.inc',
  'hash' => 'fea036745113dca3fea52ba956af605c4789f4acfa2ab1650a5843c6e173d7fe',
))
->values(array(
  'filename' => 'modules/search/search.test',
  'hash' => '1fe9dfc982953f42f67d7eee9a855e7248373067ba55cfff001d8a750b83e695',
))
->values(array(
  'filename' => 'modules/shortcut/shortcut.test',
  'hash' => 'b506a253353066e1f995e7f0e3541dadb8ef3c3ff9cf795db96e26599a0b6b7a',
))
->values(array(
  'filename' => 'modules/system/system.archiver.inc',
  'hash' => 'faa849f3e646a910ab82fd6c8bbf0a4e6b8c60725d7ba81ec0556bd716616cd1',
))
->values(array(
  'filename' => 'modules/system/system.mail.inc',
  'hash' => '3c2c06b55bded609e72add89db41af3bb405d42b9553793acba5fe51be8861d8',
))
->values(array(
  'filename' => 'modules/system/system.queue.inc',
  'hash' => 'caf4feda51bdf7ad62cf782bc23274d367154e51897f2732f07bd06982d85ab1',
))
->values(array(
  'filename' => 'modules/system/system.tar.inc',
  'hash' => '8a31d91f7b3cd7eac25b3fa46e1ed9a8527c39718ba76c3f8c0bbbeaa3aa4086',
))
->values(array(
  'filename' => 'modules/system/system.test',
  'hash' => 'ca539539bea3d2c070552f79dbae279e2872ba9d48af386c89ab6c1fc95488da',
))
->values(array(
  'filename' => 'modules/system/system.updater.inc',
  'hash' => 'e2eeed65b833a6215f807b113f6fb4cc3cc487e93efcb1402ed87c536d2c9ea6',
))
->values(array(
  'filename' => 'modules/taxonomy/taxonomy.module',
  'hash' => 'c840d2fe89bdd2a093f431a344ce17bea5bfdeaa2eb9d384d02c512c4ecdf9d8',
))
->values(array(
  'filename' => 'modules/taxonomy/taxonomy.test',
  'hash' => 'da94236e57a1147f80b62bb92cc2f7770d1d75f797fed7fee3c6ced93adbc095',
))
->values(array(
  'filename' => 'modules/update/update.test',
  'hash' => '6775fc28b2a9f9f9b6536c5abecf3f4007fbe4c8ea29a08705be9d0579844137',
))
->values(array(
  'filename' => 'modules/user/user.module',
  'hash' => 'e85b89e1dd716dbd77c2f7152a0d9e3fe622ae73ac9ced242beba15999e2d280',
))
->values(array(
  'filename' => 'modules/user/user.test',
  'hash' => 'fb8f74f903f0e0f0270a53c11ea59f645e95f5803751bc78a905545b086568c6',
))
->values(array(
  'filename' => 'profiles/standard/standard.profile',
  'hash' => '7237f80e54061c9611c6dc4fcf6225951eedba0704694f4d801673693ba11a05',
))
->values(array(
  'filename' => 'sites/all/modules/devel/devel.mail.inc',
  'hash' => 'dbdc696b3e023a588359ec1207ac6997e1abe425ed301d1b1513f68a0abcf9c2',
))
->values(array(
  'filename' => 'sites/all/modules/devel/devel.test',
  'hash' => '7ee8668c46ce85c9307cf5f35ad2b18a0793dec8455114ee8c05eee36be76302',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity.features.inc',
  'hash' => 'b77e91ea988218fd939a4e5f283b2c745d53e39159af5ab770eda6b66fcb33cb',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity.i18n.inc',
  'hash' => '41e0e62af7e2774f62b162d597bb3244551c280296b692b29d039a2c243d7059',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity.info.inc',
  'hash' => '962cf92c630a2954c4e430164e1d04b8125eb1103dbefb7b954182b4382d072d',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity.rules.inc',
  'hash' => '774199059d1b3ebe6d3fe7a49dbb1550df489055a3d066b5de54edda8dd7ba84',
))
->values(array(
  'filename' => 'sites/all/modules/entity/entity.test',
  'hash' => '80139f908ab540b4a30300c027d33b87ab250bfcf4fb44ec18adae7844b1d635',
))
->values(array(
  'filename' => 'sites/all/modules/entity/includes/entity.controller.inc',
  'hash' => '26df053bd4866bf94f57d6ae57bf2d7e3230e74723956ad03fd606a05b41ecf5',
))
->values(array(
  'filename' => 'sites/all/modules/entity/includes/entity.inc',
  'hash' => '71161b01ef9e007fd3d8e40b5ae8652194da7cb208c9f9538b63f90d8f0e6ac7',
))
->values(array(
  'filename' => 'sites/all/modules/entity/includes/entity.ui.inc',
  'hash' => 'b2bdd28eb3af34cb7c2ff1e58e0cf679d26cfd68cd9414dc3abfbd297443874d',
))
->values(array(
  'filename' => 'sites/all/modules/entity/includes/entity.wrapper.inc',
  'hash' => 'fb771c3dc1ea5d0444bc97246b4cf0d8a4609fc66d24ed2b0de507dcc8fb776c',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/entity.views.inc',
  'hash' => 'c2949770db351bc894ab5d715a3e9c9c97c4477e0c42cd90347160ddd228bbfa',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_field_handler_helper.inc',
  'hash' => '69d5ac25d8686ee43be607d682795b2cae0278500392f5f7970ac9f45913ee84',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_area_entity.inc',
  'hash' => 'e86aceccf21cbbca4bef7d2c049dc93a8f5a01c6bc73e7b2f92f5659a9eedd03',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_boolean.inc',
  'hash' => 'b28b8eee8761ba7a6af35d97ab7aaee28406e6c227271f9769818560626c5791',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_date.inc',
  'hash' => 'b0f5be5b399de94934b24e84c8cf6053a043f6b00c60dcffa752daeafdd38778',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_duration.inc',
  'hash' => '6a7f83e4ce141428d3d782db0c71f3cf4b141eff4f551b826fef7e52ac728e01',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_entity.inc',
  'hash' => 'f0ea06a0d67b0f4f498414def4d0989aad56d97780107b2fbabdaafc807adbf2',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_field.inc',
  'hash' => '893121efbce2a7181e31147bade260c9cc657cbd33b0d254cb28b2650e57566d',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_numeric.inc',
  'hash' => 'f14e2b063930e8820af381b4f5e83c7278440e7804ab88cfde865b6c94e7c0f6',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_options.inc',
  'hash' => '16317359cf59afb290d78eb61228f93dda408081e8c2f88db2f90a60d68d31d6',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_text.inc',
  'hash' => 'ae26b8a9a86c36a166644a1f5a9bae0676f535345c092d882df0177ded305bdd',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_field_uri.inc',
  'hash' => '79ecaa3eb17dfdd0ca077351b75a2c0adf411ebc04720e7cc0e2397674225f24',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_relationship.inc',
  'hash' => 'b69bc538d1e1e0f91f8485ca54c3b6e2be025caa47619734c467377cf89041b9',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/handlers/entity_views_handler_relationship_by_bundle.inc',
  'hash' => '25aebf66cd2437bd5867fef8f0e0e25d4308b9ce491cc79801e9d3cbed68bcba',
))
->values(array(
  'filename' => 'sites/all/modules/entity/views/plugins/entity_views_plugin_row_entity_view.inc',
  'hash' => 'ba557790215f2658146424d933e0d17787a0b15180c5815f23428448ccf056a0',
))
->values(array(
  'filename' => 'sites/all/modules/og/includes/og.admin.inc',
  'hash' => '637b4cc48dd6dd98cb3da5b75a9eae408b709f531074297d03d316c61bbdd8a3',
))
->values(array(
  'filename' => 'sites/all/modules/og/includes/og.info.inc',
  'hash' => '0933fdd5c916534b16bce4550311d1911594127b5a5df0fa38881cd66bc9dde7',
))
->values(array(
  'filename' => 'sites/all/modules/og/includes/og.views.inc',
  'hash' => 'a0f0c3779928056d20eb212571a8fd606ac7b4bab76668542eda6c2da023dc21',
))
->values(array(
  'filename' => 'sites/all/modules/og/includes/views/og_handler_argument_group_audience_gid.inc',
  'hash' => '9d6a1e5b758bae485475ec143acfee0d969d44ff5e60ee7980ab10f723b2cb8b',
))
->values(array(
  'filename' => 'sites/all/modules/og/includes/views/og_handler_field_group_audience_state.inc',
  'hash' => 'ea1a719eb788592678ab86f7a2223279448156423b4bb6fe083ebb6914a3ebd2',
))
->values(array(
  'filename' => 'sites/all/modules/og/includes/views/og_handler_field_group_permissions.inc',
  'hash' => 'ff3a7dd8045810de66034417ca9808cffa25373f5fd4ee43f39747cf1c22232b',
))
->values(array(
  'filename' => 'sites/all/modules/og/includes/views/og_handler_field_prerender_list.inc',
  'hash' => '075a78255792ddf6af13ae126338eff6bead6ab8a8f987cb0bdb67aa10aef2c4',
))
->values(array(
  'filename' => 'sites/all/modules/og/includes/views/og_handler_field_user_roles.inc',
  'hash' => 'c159daafd601cc4105b22426e9e8450c4787ff00f27e57593fe843e33d6d6bf4',
))
->values(array(
  'filename' => 'sites/all/modules/og/includes/views/og_handler_filter_group_audience_state.inc',
  'hash' => 'ad4895c02f9967b1e1bc1610c3488ca257cebe0a615a9de1dfea88e4daf0e285',
))
->values(array(
  'filename' => 'sites/all/modules/og/includes/views/og_handler_filter_group_roles.inc',
  'hash' => 'c494cc9a08715449b52a271ae24aca069a9e2bd3ec7d2afcfe5c0dbb1c9e6923',
))
->values(array(
  'filename' => 'sites/all/modules/og/includes/views/og_handler_filter_group_state.inc',
  'hash' => '26982c64293ff72567b4545ac901f6c660205c82d275118a3ae28eb4bc3dfb8a',
))
->values(array(
  'filename' => 'sites/all/modules/og/includes/views/og_handler_relationship.inc',
  'hash' => 'bb2420f5dec5f6691a108e415ccbf2cccc49562089114b72ee3a5bc9b84ed0bd',
))
->values(array(
  'filename' => 'sites/all/modules/og/includes/views/og_plugin_argument_default_user_groups.inc',
  'hash' => '0652a5be2c3a4d4630200e76cac82af3dde4a49544747317e785be45b24427b5',
))
->values(array(
  'filename' => 'sites/all/modules/og/includes/views/og_plugin_argument_validate_group.inc',
  'hash' => '3be409c7f06a00481d60786fbb52efbbc36391b69cf439beecd60ce701f2d937',
))
->values(array(
  'filename' => 'sites/all/modules/og/og.module',
  'hash' => '038fd22c4309c9a340ebf29b3eb90c547a0187336478ca6928fe51704b9c41f4',
))
->values(array(
  'filename' => 'sites/all/modules/og/og.rules.inc',
  'hash' => '874e180f214defb4e6792306352b05f4ccdda788cfb0ab58526e1df9aa76be80',
))
->values(array(
  'filename' => 'sites/all/modules/og/og.test',
  'hash' => '0ae194ac83a8f79947b1914b519fbcb5d3862426f3918c1dad2036e4f823b3f2',
))
->values(array(
  'filename' => 'sites/all/modules/og/og_ui/og_ui.test',
  'hash' => '8fb31fbc9f6f66c0f83846aafee6d0ef418ae5c9e3215be556a052d8f759b8f3',
))
->execute();

db_create_table('role', array(
  'fields' => array(
    'rid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
      'translatable' => TRUE,
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'unique keys' => array(
    'name' => array(
      'name',
    ),
  ),
  'primary key' => array(
    'rid',
  ),
  'indexes' => array(
    'name_weight' => array(
      'name',
      'weight',
    ),
  ),
  'module' => 'user',
  'name' => 'role',
));
db_insert('role')->fields(array(
  'rid',
  'name',
  'weight',
))
->values(array(
  'rid' => '3',
  'name' => 'administrator',
  'weight' => '2',
))
->values(array(
  'rid' => '1',
  'name' => 'anonymous user',
  'weight' => '0',
))
->values(array(
  'rid' => '2',
  'name' => 'authenticated user',
  'weight' => '1',
))
->execute();

db_create_table('role_permission', array(
  'fields' => array(
    'rid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'permission' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'module' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
  ),
  'primary key' => array(
    'rid',
    'permission',
  ),
  'indexes' => array(
    'permission' => array(
      'permission',
    ),
  ),
  'foreign keys' => array(
    'role' => array(
      'table' => 'roles',
      'columns' => array(
        'rid' => 'rid',
      ),
    ),
  ),
  'module' => 'user',
  'name' => 'role_permission',
));
db_insert('role_permission')->fields(array(
  'rid',
  'permission',
  'module',
))
->values(array(
  'rid' => '1',
  'permission' => 'access comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '1',
  'permission' => 'access content',
  'module' => 'node',
))
->values(array(
  'rid' => '1',
  'permission' => 'use text format filtered_html',
  'module' => 'filter',
))
->values(array(
  'rid' => '2',
  'permission' => 'access comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '2',
  'permission' => 'access content',
  'module' => 'node',
))
->values(array(
  'rid' => '2',
  'permission' => 'post comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '2',
  'permission' => 'skip comment approval',
  'module' => 'comment',
))
->values(array(
  'rid' => '2',
  'permission' => 'use text format filtered_html',
  'module' => 'filter',
))
->values(array(
  'rid' => '3',
  'permission' => 'access administration pages',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'access comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '3',
  'permission' => 'access content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'access content overview',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'access contextual links',
  'module' => 'contextual',
))
->values(array(
  'rid' => '3',
  'permission' => 'access dashboard',
  'module' => 'dashboard',
))
->values(array(
  'rid' => '3',
  'permission' => 'access devel information',
  'module' => 'devel',
))
->values(array(
  'rid' => '3',
  'permission' => 'access overlay',
  'module' => 'overlay',
))
->values(array(
  'rid' => '3',
  'permission' => 'access site in maintenance mode',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'access site reports',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'access toolbar',
  'module' => 'toolbar',
))
->values(array(
  'rid' => '3',
  'permission' => 'access user profiles',
  'module' => 'user',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer actions',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer blocks',
  'module' => 'block',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer content types',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer filters',
  'module' => 'filter',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer group',
  'module' => 'og',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer image styles',
  'module' => 'image',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer menu',
  'module' => 'menu',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer modules',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer nodes',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer permissions',
  'module' => 'user',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer search',
  'module' => 'search',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer shortcuts',
  'module' => 'shortcut',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer site configuration',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer software updates',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer taxonomy',
  'module' => 'taxonomy',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer themes',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer url aliases',
  'module' => 'path',
))
->values(array(
  'rid' => '3',
  'permission' => 'administer users',
  'module' => 'user',
))
->values(array(
  'rid' => '3',
  'permission' => 'block IP addresses',
  'module' => 'system',
))
->values(array(
  'rid' => '3',
  'permission' => 'bypass node access',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'cancel account',
  'module' => 'user',
))
->values(array(
  'rid' => '3',
  'permission' => 'change own username',
  'module' => 'user',
))
->values(array(
  'rid' => '3',
  'permission' => 'create article content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'create page content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'create url aliases',
  'module' => 'path',
))
->values(array(
  'rid' => '3',
  'permission' => 'customize shortcut links',
  'module' => 'shortcut',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete any article content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete any page content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete own article content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete own page content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete revisions',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'delete terms in 1',
  'module' => 'taxonomy',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit any article content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit any page content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit own article content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit own comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit own page content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'edit terms in 1',
  'module' => 'taxonomy',
))
->values(array(
  'rid' => '3',
  'permission' => 'execute php code',
  'module' => 'devel',
))
->values(array(
  'rid' => '3',
  'permission' => 'post comments',
  'module' => 'comment',
))
->values(array(
  'rid' => '3',
  'permission' => 'revert revisions',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'search content',
  'module' => 'search',
))
->values(array(
  'rid' => '3',
  'permission' => 'select account cancellation method',
  'module' => 'user',
))
->values(array(
  'rid' => '3',
  'permission' => 'skip comment approval',
  'module' => 'comment',
))
->values(array(
  'rid' => '3',
  'permission' => 'switch shortcut sets',
  'module' => 'shortcut',
))
->values(array(
  'rid' => '3',
  'permission' => 'switch users',
  'module' => 'devel',
))
->values(array(
  'rid' => '3',
  'permission' => 'use advanced search',
  'module' => 'search',
))
->values(array(
  'rid' => '3',
  'permission' => 'use text format filtered_html',
  'module' => 'filter',
))
->values(array(
  'rid' => '3',
  'permission' => 'use text format full_html',
  'module' => 'filter',
))
->values(array(
  'rid' => '3',
  'permission' => 'view own unpublished content',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'view revisions',
  'module' => 'node',
))
->values(array(
  'rid' => '3',
  'permission' => 'view the administration theme',
  'module' => 'system',
))
->execute();

db_create_table('search_dataset', array(
  'fields' => array(
    'sid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'type' => array(
      'type' => 'varchar',
      'length' => 16,
      'not null' => TRUE,
    ),
    'data' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'reindex' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'sid',
    'type',
  ),
  'module' => 'search',
  'name' => 'search_dataset',
));

db_create_table('search_index', array(
  'fields' => array(
    'word' => array(
      'type' => 'varchar',
      'length' => 50,
      'not null' => TRUE,
      'default' => '',
    ),
    'sid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'type' => array(
      'type' => 'varchar',
      'length' => 16,
      'not null' => TRUE,
    ),
    'score' => array(
      'type' => 'float',
      'not null' => FALSE,
    ),
  ),
  'indexes' => array(
    'sid_type' => array(
      'sid',
      'type',
    ),
  ),
  'foreign keys' => array(
    'search_dataset' => array(
      'table' => 'search_dataset',
      'columns' => array(
        'sid' => 'sid',
        'type' => 'type',
      ),
    ),
  ),
  'primary key' => array(
    'word',
    'sid',
    'type',
  ),
  'module' => 'search',
  'name' => 'search_index',
));

db_create_table('search_node_links', array(
  'fields' => array(
    'sid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'type' => array(
      'type' => 'varchar',
      'length' => 16,
      'not null' => TRUE,
      'default' => '',
    ),
    'nid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'caption' => array(
      'type' => 'text',
      'size' => 'big',
      'not null' => FALSE,
    ),
  ),
  'primary key' => array(
    'sid',
    'type',
    'nid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
  ),
  'module' => 'search',
  'name' => 'search_node_links',
));

db_create_table('search_total', array(
  'fields' => array(
    'word' => array(
      'type' => 'varchar',
      'length' => 50,
      'not null' => TRUE,
      'default' => '',
    ),
    'count' => array(
      'type' => 'float',
      'not null' => FALSE,
    ),
  ),
  'primary key' => array(
    'word',
  ),
  'module' => 'search',
  'name' => 'search_total',
));

db_create_table('semaphore', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'value' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'expire' => array(
      'type' => 'float',
      'size' => 'big',
      'not null' => TRUE,
    ),
  ),
  'indexes' => array(
    'value' => array(
      'value',
    ),
    'expire' => array(
      'expire',
    ),
  ),
  'primary key' => array(
    'name',
  ),
  'module' => 'system',
  'name' => 'semaphore',
));

db_create_table('sequences', array(
  'fields' => array(
    'value' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
  ),
  'primary key' => array(
    'value',
  ),
  'module' => 'system',
  'name' => 'sequences',
));
db_insert('sequences')->fields(array(
  'value',
))
->values(array(
  'value' => '11',
))
->execute();

db_create_table('sessions', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'sid' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
    ),
    'ssid' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'session' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'sid',
    'ssid',
  ),
  'indexes' => array(
    'timestamp' => array(
      'timestamp',
    ),
    'uid' => array(
      'uid',
    ),
    'ssid' => array(
      'ssid',
    ),
  ),
  'foreign keys' => array(
    'session_user' => array(
      'table' => 'users',
      'columns' => array(
        'uid' => 'uid',
      ),
    ),
  ),
  'module' => 'system',
  'name' => 'sessions',
));

db_create_table('shortcut_set', array(
  'fields' => array(
    'set_name' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
  ),
  'primary key' => array(
    'set_name',
  ),
  'foreign keys' => array(
    'menu_name' => array(
      'table' => 'menu_links',
      'columns' => array(
        'set_name' => 'menu_name',
      ),
    ),
  ),
  'module' => 'shortcut',
  'name' => 'shortcut_set',
));
db_insert('shortcut_set')->fields(array(
  'set_name',
  'title',
))
->values(array(
  'set_name' => 'shortcut-set-1',
  'title' => 'Default',
))
->execute();

db_create_table('shortcut_set_users', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'set_name' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => TRUE,
      'default' => '',
    ),
  ),
  'primary key' => array(
    'uid',
  ),
  'indexes' => array(
    'set_name' => array(
      'set_name',
    ),
  ),
  'foreign keys' => array(
    'set_user' => array(
      'table' => 'users',
      'columns' => array(
        'uid' => 'uid',
      ),
    ),
    'set_name' => array(
      'table' => 'shortcut_set',
      'columns' => array(
        'set_name' => 'set_name',
      ),
    ),
  ),
  'module' => 'shortcut',
  'name' => 'shortcut_set_users',
));

db_create_table('system', array(
  'fields' => array(
    'filename' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'length' => 12,
      'not null' => TRUE,
      'default' => '',
    ),
    'owner' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'bootstrap' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'schema_version' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => -1,
      'size' => 'small',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'info' => array(
      'type' => 'blob',
      'not null' => FALSE,
    ),
  ),
  'primary key' => array(
    'filename',
  ),
  'indexes' => array(
    'system_list' => array(
      'status',
      'bootstrap',
      'type',
      'weight',
      'name',
    ),
    'type_name' => array(
      'type',
      'name',
    ),
  ),
  'module' => 'system',
  'name' => 'system',
));
db_insert('system')->fields(array(
  'filename',
  'name',
  'type',
  'owner',
  'status',
  'bootstrap',
  'schema_version',
  'weight',
  'info',
))
->values(array(
  'filename' => 'modules/aggregator/aggregator.module',
  'name' => 'aggregator',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:10:"Aggregator";s:11:"description";s:57:"Aggregates syndicated content (RSS, RDF, and Atom feeds).";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"aggregator.test";}s:9:"configure";s:41:"admin/config/services/aggregator/settings";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:14:"aggregator.css";s:33:"modules/aggregator/aggregator.css";}}s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/aggregator/tests/aggregator_test.module',
  'name' => 'aggregator_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:23:"Aggregator module tests";s:11:"description";s:46:"Support module for aggregator related testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/block/block.module',
  'name' => 'block',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7008',
  'weight' => '-5',
  'info' => 'a:10:{s:4:"name";s:5:"Block";s:11:"description";s:140:"Controls the visual building blocks a page is constructed with. Blocks are boxes of content rendered into an area, or region, of a web page.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"block.test";}s:9:"configure";s:21:"admin/structure/block";s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/blog/blog.module',
  'name' => 'blog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:4:"Blog";s:11:"description";s:25:"Enables multi-user blogs.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"blog.test";}s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/book/book.module',
  'name' => 'book',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:4:"Book";s:11:"description";s:66:"Allows users to create and organize related content in an outline.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"book.test";}s:9:"configure";s:27:"admin/content/book/settings";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"book.css";s:21:"modules/book/book.css";}}s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/color/color.module',
  'name' => 'color',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7001',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:5:"Color";s:11:"description";s:70:"Allows administrators to change the color scheme of compatible themes.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"color.test";}s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/comment/comment.module',
  'name' => 'comment',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7009',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:7:"Comment";s:11:"description";s:57:"Allows users to comment on and discuss published content.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:4:"text";}s:5:"files";a:2:{i:0;s:14:"comment.module";i:1;s:12:"comment.test";}s:9:"configure";s:21:"admin/content/comment";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:11:"comment.css";s:27:"modules/comment/comment.css";}}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/contact/contact.module',
  'name' => 'contact',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Contact";s:11:"description";s:61:"Enables the use of both personal and site-wide contact forms.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"contact.test";}s:9:"configure";s:23:"admin/structure/contact";s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/contextual/contextual.module',
  'name' => 'contextual',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:16:"Contextual links";s:11:"description";s:75:"Provides contextual links to perform actions related to elements on a page.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"contextual.test";}s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/dashboard/dashboard.module',
  'name' => 'dashboard',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:9:"Dashboard";s:11:"description";s:136:"Provides a dashboard page in the administrative interface for organizing administrative tasks and tracking information within your site.";s:4:"core";s:3:"7.x";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:5:"files";a:1:{i:0;s:14:"dashboard.test";}s:12:"dependencies";a:1:{i:0;s:5:"block";}s:9:"configure";s:25:"admin/dashboard/customize";s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/dblog/dblog.module',
  'name' => 'dblog',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '1',
  'schema_version' => '7001',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:16:"Database logging";s:11:"description";s:47:"Logs and records system events to the database.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"dblog.test";}s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/field.module',
  'name' => 'field',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7002',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:5:"Field";s:11:"description";s:57:"Field API to add fields to entities like nodes and users.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:3:{i:0;s:12:"field.module";i:1;s:16:"field.attach.inc";i:2;s:16:"tests/field.test";}s:12:"dependencies";a:1:{i:0;s:17:"field_sql_storage";}s:8:"required";b:1;s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:15:"theme/field.css";s:29:"modules/field/theme/field.css";}}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/field_sql_storage/field_sql_storage.module',
  'name' => 'field_sql_storage',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7002',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:17:"Field SQL storage";s:11:"description";s:37:"Stores field data in an SQL database.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:22:"field_sql_storage.test";}s:8:"required";b:1;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/list/list.module',
  'name' => 'list',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7002',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:4:"List";s:11:"description";s:69:"Defines list field types. Use with Options to create selection lists.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:12:"dependencies";a:2:{i:0;s:5:"field";i:1;s:7:"options";}s:5:"files";a:1:{i:0;s:15:"tests/list.test";}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:80:"Field type(s) in use - see <a href="/d7_dev/admin/reports/fields">Field list</a>";}',
))
->values(array(
  'filename' => 'modules/field/modules/list/tests/list_test.module',
  'name' => 'list_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:9:"List test";s:11:"description";s:41:"Support module for the List module tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/number/number.module',
  'name' => 'number',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:6:"Number";s:11:"description";s:28:"Defines numeric field types.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:11:"number.test";}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/options/options.module',
  'name' => 'options',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:7:"Options";s:11:"description";s:82:"Defines selection, check box and radio button widgets for text and numeric fields.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:12:"options.test";}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field/modules/text/text.module',
  'name' => 'text',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7000',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:4:"Text";s:11:"description";s:32:"Defines simple text field types.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:9:"text.test";}s:8:"required";b:1;s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:11:"explanation";s:80:"Field type(s) in use - see <a href="/d7_dev/admin/reports/fields">Field list</a>";}',
))
->values(array(
  'filename' => 'modules/field/tests/field_test.module',
  'name' => 'field_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:14:"Field API Test";s:11:"description";s:39:"Support module for the Field API tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:5:"files";a:1:{i:0;s:21:"field_test.entity.inc";}s:7:"version";s:8:"7.15-dev";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/field_ui/field_ui.module',
  'name' => 'field_ui',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:8:"Field UI";s:11:"description";s:33:"User interface for the Field API.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:13:"field_ui.test";}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/file/file.module',
  'name' => 'file',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:4:"File";s:11:"description";s:26:"Defines a file field type.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:5:"field";}s:5:"files";a:1:{i:0;s:15:"tests/file.test";}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/file/tests/file_module_test.module',
  'name' => 'file_module_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:9:"File test";s:11:"description";s:53:"Provides hooks for testing File module functionality.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/filter/filter.module',
  'name' => 'filter',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7010',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:6:"Filter";s:11:"description";s:43:"Filters content in preparation for display.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"filter.test";}s:8:"required";b:1;s:9:"configure";s:28:"admin/config/content/formats";s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/forum/forum.module',
  'name' => 'forum',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:5:"Forum";s:11:"description";s:27:"Provides discussion forums.";s:12:"dependencies";a:2:{i:0;s:8:"taxonomy";i:1;s:7:"comment";}s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:10:"forum.test";}s:9:"configure";s:21:"admin/structure/forum";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"forum.css";s:23:"modules/forum/forum.css";}}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/help/help.module',
  'name' => 'help',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:4:"Help";s:11:"description";s:35:"Manages the display of online help.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"help.test";}s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/image/image.module',
  'name' => 'image',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7004',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:5:"Image";s:11:"description";s:34:"Provides image manipulation tools.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:4:"file";}s:5:"files";a:1:{i:0;s:10:"image.test";}s:9:"configure";s:31:"admin/config/media/image-styles";s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:80:"Field type(s) in use - see <a href="/d7_dev/admin/reports/fields">Field list</a>";}',
))
->values(array(
  'filename' => 'modules/image/tests/image_module_test.module',
  'name' => 'image_module_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"Image test";s:11:"description";s:69:"Provides hook implementations for testing Image module functionality.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:24:"image_module_test.module";}s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/locale/locale.module',
  'name' => 'locale',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:6:"Locale";s:11:"description";s:119:"Adds language handling functionality and enables the translation of the user interface to languages other than English.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"locale.test";}s:9:"configure";s:30:"admin/config/regional/language";s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/locale/tests/locale_test.module',
  'name' => 'locale_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:11:"Locale Test";s:11:"description";s:42:"Support module for the locale layer tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/menu/menu.module',
  'name' => 'menu',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7003',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Menu";s:11:"description";s:60:"Allows administrators to customize the site navigation menu.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"menu.test";}s:9:"configure";s:20:"admin/structure/menu";s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/node/node.module',
  'name' => 'node',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7013',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:4:"Node";s:11:"description";s:66:"Allows content to be submitted to the site and displayed on pages.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:11:"node.module";i:1;s:9:"node.test";}s:8:"required";b:1;s:9:"configure";s:21:"admin/structure/types";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"node.css";s:21:"modules/node/node.css";}}s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/node/tests/node_access_test.module',
  'name' => 'node_access_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:24:"Node module access tests";s:11:"description";s:43:"Support module for node permission testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/node/tests/node_test.module',
  'name' => 'node_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:17:"Node module tests";s:11:"description";s:40:"Support module for node related testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/node/tests/node_test_exception.module',
  'name' => 'node_test_exception',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:27:"Node module exception tests";s:11:"description";s:50:"Support module for node related exception testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/openid/openid.module',
  'name' => 'openid',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:6:"OpenID";s:11:"description";s:48:"Allows users to log into your site using OpenID.";s:7:"version";s:8:"7.15-dev";s:7:"package";s:4:"Core";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"openid.test";}s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/openid/tests/openid_test.module',
  'name' => 'openid_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:21:"OpenID dummy provider";s:11:"description";s:33:"OpenID provider used for testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:6:"openid";}s:6:"hidden";b:1;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/overlay/overlay.module',
  'name' => 'overlay',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '1',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:7:"Overlay";s:11:"description";s:59:"Displays the Drupal administration interface in an overlay.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/path/path.module',
  'name' => 'path',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Path";s:11:"description";s:28:"Allows users to rename URLs.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"path.test";}s:9:"configure";s:24:"admin/config/search/path";s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/php/php.module',
  'name' => 'php',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:10:"PHP filter";s:11:"description";s:50:"Allows embedded PHP code/snippets to be evaluated.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:8:"php.test";}s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/poll/poll.module',
  'name' => 'poll',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:4:"Poll";s:11:"description";s:95:"Allows your site to capture votes on different topics in the form of multiple choice questions.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:9:"poll.test";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"poll.css";s:21:"modules/poll/poll.css";}}s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/profile/profile.module',
  'name' => 'profile',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:7:"Profile";s:11:"description";s:36:"Supports configurable user profiles.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"profile.test";}s:9:"configure";s:27:"admin/config/people/profile";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/rdf/rdf.module',
  'name' => 'rdf',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:3:"RDF";s:11:"description";s:148:"Enriches your content with metadata to let other applications (e.g. search engines, aggregators) better understand its relationships and attributes.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:8:"rdf.test";}s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/rdf/tests/rdf_test.module',
  'name' => 'rdf_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:16:"RDF module tests";s:11:"description";s:38:"Support module for RDF module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/search/search.module',
  'name' => 'search',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7000',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:6:"Search";s:11:"description";s:36:"Enables site-wide keyword searching.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:19:"search.extender.inc";i:1;s:11:"search.test";}s:9:"configure";s:28:"admin/config/search/settings";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:10:"search.css";s:25:"modules/search/search.css";}}s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/search/tests/search_embedded_form.module',
  'name' => 'search_embedded_form',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:20:"Search embedded form";s:11:"description";s:59:"Support module for search module testing of embedded forms.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/search/tests/search_extra_type.module',
  'name' => 'search_extra_type',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:16:"Test search type";s:11:"description";s:41:"Support module for search module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/shortcut/shortcut.module',
  'name' => 'shortcut',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:8:"Shortcut";s:11:"description";s:60:"Allows users to manage customizable lists of shortcut links.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:13:"shortcut.test";}s:9:"configure";s:36:"admin/config/user-interface/shortcut";s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/simpletest.module',
  'name' => 'simpletest',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Testing";s:11:"description";s:53:"Provides a framework for unit and functional testing.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:47:{i:0;s:15:"simpletest.test";i:1;s:24:"drupal_web_test_case.php";i:2;s:18:"tests/actions.test";i:3;s:15:"tests/ajax.test";i:4;s:16:"tests/batch.test";i:5;s:20:"tests/bootstrap.test";i:6;s:16:"tests/cache.test";i:7;s:17:"tests/common.test";i:8;s:24:"tests/database_test.test";i:9;s:32:"tests/entity_crud_hook_test.test";i:10;s:23:"tests/entity_query.test";i:11;s:16:"tests/error.test";i:12;s:15:"tests/file.test";i:13;s:23:"tests/filetransfer.test";i:14;s:15:"tests/form.test";i:15;s:16:"tests/graph.test";i:16;s:16:"tests/image.test";i:17;s:15:"tests/lock.test";i:18;s:15:"tests/mail.test";i:19;s:15:"tests/menu.test";i:20;s:17:"tests/module.test";i:21;s:16:"tests/pager.test";i:22;s:19:"tests/password.test";i:23;s:15:"tests/path.test";i:24;s:19:"tests/registry.test";i:25;s:17:"tests/schema.test";i:26;s:18:"tests/session.test";i:27;s:20:"tests/tablesort.test";i:28;s:16:"tests/theme.test";i:29;s:18:"tests/unicode.test";i:30;s:17:"tests/update.test";i:31;s:17:"tests/xmlrpc.test";i:32;s:26:"tests/upgrade/upgrade.test";i:33;s:34:"tests/upgrade/upgrade.comment.test";i:34;s:31:"tests/upgrade/update.field.test";i:35;s:33:"tests/upgrade/upgrade.filter.test";i:36;s:32:"tests/upgrade/upgrade.forum.test";i:37;s:33:"tests/upgrade/upgrade.locale.test";i:38;s:31:"tests/upgrade/upgrade.menu.test";i:39;s:31:"tests/upgrade/upgrade.node.test";i:40;s:35:"tests/upgrade/upgrade.taxonomy.test";i:41;s:34:"tests/upgrade/upgrade.trigger.test";i:42;s:39:"tests/upgrade/upgrade.translatable.test";i:43;s:33:"tests/upgrade/update.trigger.test";i:44;s:33:"tests/upgrade/upgrade.upload.test";i:45;s:30:"tests/upgrade/update.user.test";i:46;s:31:"tests/upgrade/upgrade.user.test";}s:9:"configure";s:41:"admin/config/development/testing/settings";s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/actions_loop_test.module',
  'name' => 'actions_loop_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:17:"Actions loop test";s:11:"description";s:39:"Support module for action loop testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/ajax_forms_test.module',
  'name' => 'ajax_forms_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:26:"AJAX form test mock module";s:11:"description";s:25:"Test for AJAX form calls.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/ajax_test.module',
  'name' => 'ajax_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:9:"AJAX Test";s:11:"description";s:40:"Support module for AJAX framework tests.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/batch_test.module',
  'name' => 'batch_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:14:"Batch API test";s:11:"description";s:35:"Support module for Batch API tests.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/common_test.module',
  'name' => 'common_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:11:"Common Test";s:11:"description";s:32:"Support module for Common tests.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:15:"common_test.css";s:40:"modules/simpletest/tests/common_test.css";}s:5:"print";a:1:{s:21:"common_test.print.css";s:46:"modules/simpletest/tests/common_test.print.css";}}s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/common_test_cron_helper.module',
  'name' => 'common_test_cron_helper',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:23:"Common Test Cron Helper";s:11:"description";s:56:"Helper module for CronRunTestCase::testCronExceptions().";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/database_test.module',
  'name' => 'database_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:13:"Database Test";s:11:"description";s:40:"Support module for Database layer tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/drupal_system_listing_compatible_test/drupal_system_listing_compatible_test.module',
  'name' => 'drupal_system_listing_compatible_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:37:"Drupal system listing compatible test";s:11:"description";s:62:"Support module for testing the drupal_system_listing function.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/drupal_system_listing_incompatible_test/drupal_system_listing_incompatible_test.module',
  'name' => 'drupal_system_listing_incompatible_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:39:"Drupal system listing incompatible test";s:11:"description";s:62:"Support module for testing the drupal_system_listing function.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/entity_cache_test.module',
  'name' => 'entity_cache_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:17:"Entity cache test";s:11:"description";s:40:"Support module for testing entity cache.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:28:"entity_cache_test_dependency";}s:6:"hidden";b:1;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/entity_cache_test_dependency.module',
  'name' => 'entity_cache_test_dependency',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:28:"Entity cache test dependency";s:11:"description";s:51:"Support dependency module for testing entity cache.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/entity_crud_hook_test.module',
  'name' => 'entity_crud_hook_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:22:"Entity CRUD Hooks Test";s:11:"description";s:35:"Support module for CRUD hook tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/error_test.module',
  'name' => 'error_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"Error test";s:11:"description";s:47:"Support module for error and exception testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/file_test.module',
  'name' => 'file_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:9:"File test";s:11:"description";s:39:"Support module for file handling tests.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:16:"file_test.module";}s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/filter_test.module',
  'name' => 'filter_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:18:"Filter test module";s:11:"description";s:33:"Tests filter hooks and functions.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/form_test.module',
  'name' => 'form_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:12:"FormAPI Test";s:11:"description";s:34:"Support module for Form API tests.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/image_test.module',
  'name' => 'image_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"Image test";s:11:"description";s:39:"Support module for image toolkit tests.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/menu_test.module',
  'name' => 'menu_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:15:"Hook menu tests";s:11:"description";s:37:"Support module for menu hook testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/module_test.module',
  'name' => 'module_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:11:"Module test";s:11:"description";s:41:"Support module for module system testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/path_test.module',
  'name' => 'path_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:15:"Hook path tests";s:11:"description";s:37:"Support module for path hook testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/requirements1_test.module',
  'name' => 'requirements1_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:10:{s:4:\"name\";s:19:\"Requirements 1 Test\";s:11:\"description\";s:80:\"Tests that a module is not installed when it fails hook_requirements('install').\";s:7:\"package\";s:7:\"Testing\";s:7:\"version\";s:8:\"7.15-dev\";s:4:\"core\";s:3:\"7.x\";s:6:\"hidden\";b:1;s:12:\"dependencies\";a:0:{}s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}",
))
->values(array(
  'filename' => 'modules/simpletest/tests/requirements2_test.module',
  'name' => 'requirements2_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:10:{s:4:\"name\";s:19:\"Requirements 2 Test\";s:11:\"description\";s:98:\"Tests that a module is not installed when the one it depends on fails hook_requirements('install).\";s:12:\"dependencies\";a:2:{i:0;s:18:\"requirements1_test\";i:1;s:7:\"comment\";}s:7:\"package\";s:7:\"Testing\";s:7:\"version\";s:8:\"7.15-dev\";s:4:\"core\";s:3:\"7.x\";s:6:\"hidden\";b:1;s:3:\"php\";s:5:\"5.2.4\";s:5:\"files\";a:0:{}s:9:\"bootstrap\";i:0;}",
))
->values(array(
  'filename' => 'modules/simpletest/tests/session_test.module',
  'name' => 'session_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:12:"Session test";s:11:"description";s:40:"Support module for session data testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_dependencies_test.module',
  'name' => 'system_dependencies_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:22:"System dependency test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:19:"_missing_dependency";}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_incompatible_core_version_dependencies_test.module',
  'name' => 'system_incompatible_core_version_dependencies_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:50:"System incompatible core version dependencies test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:37:"system_incompatible_core_version_test";}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_incompatible_core_version_test.module',
  'name' => 'system_incompatible_core_version_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:37:"System incompatible core version test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"5.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_incompatible_module_version_dependencies_test.module',
  'name' => 'system_incompatible_module_version_dependencies_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:52:"System incompatible module version dependencies test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:46:"system_incompatible_module_version_test (>2.0)";}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_incompatible_module_version_test.module',
  'name' => 'system_incompatible_module_version_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:39:"System incompatible module version test";s:11:"description";s:47:"Support module for testing system dependencies.";s:7:"package";s:7:"Testing";s:7:"version";s:3:"1.0";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/system_test.module',
  'name' => 'system_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:11:"System test";s:11:"description";s:34:"Support module for system testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:18:"system_test.module";}s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/taxonomy_test.module',
  'name' => 'taxonomy_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:20:"Taxonomy test module";s:11:"description";s:45:""Tests functions and hooks not used in core".";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:1:{i:0;s:8:"taxonomy";}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/theme_test.module',
  'name' => 'theme_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"Theme test";s:11:"description";s:40:"Support module for theme system testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/update_script_test.module',
  'name' => 'update_script_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:18:"Update script test";s:11:"description";s:41:"Support module for update script testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/update_test_1.module',
  'name' => 'update_test_1',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:11:"Update test";s:11:"description";s:34:"Support module for update testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/update_test_2.module',
  'name' => 'update_test_2',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:11:"Update test";s:11:"description";s:34:"Support module for update testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/update_test_3.module',
  'name' => 'update_test_3',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:11:"Update test";s:11:"description";s:34:"Support module for update testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/url_alter_test.module',
  'name' => 'url_alter_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:15:"Url_alter tests";s:11:"description";s:45:"A support modules for url_alter hook testing.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/simpletest/tests/xmlrpc_test.module',
  'name' => 'xmlrpc_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:12:"XML-RPC Test";s:11:"description";s:75:"Support module for XML-RPC tests according to the validator1 specification.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/statistics/statistics.module',
  'name' => 'statistics',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:10:"Statistics";s:11:"description";s:37:"Logs access statistics for your site.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:15:"statistics.test";}s:9:"configure";s:30:"admin/config/system/statistics";s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/syslog/syslog.module',
  'name' => 'syslog',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:6:"Syslog";s:11:"description";s:41:"Logs and records system events to syslog.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"syslog.test";}s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/system/system.module',
  'name' => 'system',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '1',
  'schema_version' => '7073',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:6:"System";s:11:"description";s:54:"Handles general site configuration for administrators.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:6:{i:0;s:19:"system.archiver.inc";i:1;s:15:"system.mail.inc";i:2;s:16:"system.queue.inc";i:3;s:14:"system.tar.inc";i:4;s:18:"system.updater.inc";i:5;s:11:"system.test";}s:8:"required";b:1;s:9:"configure";s:19:"admin/config/system";s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/taxonomy/taxonomy.module',
  'name' => 'taxonomy',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7010',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:8:"Taxonomy";s:11:"description";s:38:"Enables the categorization of content.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:12:"dependencies";a:1:{i:0;s:7:"options";}s:5:"files";a:2:{i:0;s:15:"taxonomy.module";i:1;s:13:"taxonomy.test";}s:9:"configure";s:24:"admin/structure/taxonomy";s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:80:"Field type(s) in use - see <a href="/d7_dev/admin/reports/fields">Field list</a>";}',
))
->values(array(
  'filename' => 'modules/toolbar/toolbar.module',
  'name' => 'toolbar',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:7:"Toolbar";s:11:"description";s:99:"Provides a toolbar that shows the top-level administration menu items and links from other modules.";s:4:"core";s:3:"7.x";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/tracker/tracker.module',
  'name' => 'tracker',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:7:"Tracker";s:11:"description";s:45:"Enables tracking of recent content for users.";s:12:"dependencies";a:1:{i:0;s:7:"comment";}s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"tracker.test";}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/translation/tests/translation_test.module',
  'name' => 'translation_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:24:"Content Translation Test";s:11:"description";s:49:"Support module for the content translation tests.";s:4:"core";s:3:"7.x";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/translation/translation.module',
  'name' => 'translation',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:9:{s:4:"name";s:19:"Content translation";s:11:"description";s:57:"Allows content to be translated into different languages.";s:12:"dependencies";a:1:{i:0;s:6:"locale";}s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:16:"translation.test";}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/trigger/tests/trigger_test.module',
  'name' => 'trigger_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:12:"Trigger Test";s:11:"description";s:33:"Support module for Trigger tests.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/trigger/trigger.module',
  'name' => 'trigger',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:7:"Trigger";s:11:"description";s:90:"Enables actions to be fired on certain system events, such as when new content is created.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:12:"trigger.test";}s:9:"configure";s:23:"admin/structure/trigger";s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/tests/aaa_update_test.module',
  'name' => 'aaa_update_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:15:"AAA Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/tests/bbb_update_test.module',
  'name' => 'bbb_update_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:15:"BBB Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/tests/ccc_update_test.module',
  'name' => 'ccc_update_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:15:"CCC Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:7:"version";N;s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/tests/update_test.module',
  'name' => 'update_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:11:"Update test";s:11:"description";s:41:"Support module for update module testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/update/update.module',
  'name' => 'update',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7001',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:14:"Update manager";s:11:"description";s:104:"Checks for available updates, and can securely install or update modules and themes via a web interface.";s:7:"version";s:8:"7.15-dev";s:7:"package";s:4:"Core";s:4:"core";s:3:"7.x";s:5:"files";a:1:{i:0;s:11:"update.test";}s:9:"configure";s:30:"admin/reports/updates/settings";s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/user/tests/user_form_test.module',
  'name' => 'user_form_test',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:10:{s:4:"name";s:22:"User module form tests";s:11:"description";s:37:"Support module for user form testing.";s:7:"package";s:7:"Testing";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:5:"files";a:0:{}s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'modules/user/user.module',
  'name' => 'user',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '7018',
  'weight' => '0',
  'info' => 'a:12:{s:4:"name";s:4:"User";s:11:"description";s:47:"Manages the user registration and login system.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:5:"files";a:2:{i:0;s:11:"user.module";i:1;s:9:"user.test";}s:8:"required";b:1;s:9:"configure";s:19:"admin/config/people";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:8:"user.css";s:21:"modules/user/user.css";}}s:12:"dependencies";a:0:{}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;}',
))
->values(array(
  'filename' => 'profiles/standard/standard.profile',
  'name' => 'standard',
  'type' => 'module',
  'owner' => '',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '0',
  'weight' => '1000',
  'info' => 'a:12:{s:4:"name";s:8:"Standard";s:11:"description";s:51:"Install with commonly used features pre-configured.";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:6:"hidden";b:1;s:12:"dependencies";a:21:{i:0;s:5:"block";i:1;s:5:"color";i:2;s:7:"comment";i:3;s:10:"contextual";i:4;s:9:"dashboard";i:5;s:4:"help";i:6;s:5:"image";i:7;s:4:"list";i:8;s:4:"menu";i:9;s:6:"number";i:10;s:7:"options";i:11;s:4:"path";i:12;s:8:"taxonomy";i:13;s:5:"dblog";i:14;s:6:"search";i:15;s:8:"shortcut";i:16;s:7:"toolbar";i:17;s:7:"overlay";i:18;s:8:"field_ui";i:19;s:4:"file";i:20;s:3:"rdf";}s:5:"files";a:1:{i:0;s:16:"standard.profile";}s:7:"package";s:5:"Other";s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:17:"distribution_name";s:6:"Drupal";}',
))
->values(array(
  'filename' => 'sites/all/modules/og/og.module',
  'name' => 'og',
  'type' => 'module',
  'owner' => '',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '7102',
  'weight' => '0',
  'info' => 'a:11:{s:4:"name";s:14:"Organic groups";s:11:"description";s:45:"API to allow associating content with groups.";s:7:"package";s:14:"Organic groups";s:12:"dependencies";a:4:{i:0;s:4:"text";i:1;s:6:"entity";i:2;s:4:"list";i:3;s:7:"options";}s:4:"core";s:3:"7.x";s:7:"version";s:8:"7.15-dev";s:5:"files";a:21:{i:0;s:9:"og.module";i:1;s:12:"og.admin.inc";i:2;s:21:"includes/og.views.inc";i:3;s:12:"og.rules.inc";i:4;s:7:"og.test";i:5;s:29:"tests/upgrade/og.upgrade.test";i:6;s:52:"includes/views/og_plugin_argument_validate_group.inc";i:7;s:57:"includes/views/og_plugin_argument_default_user_groups.inc";i:8;s:54:"includes/views/og_handler_field_group_member_count.inc";i:9;s:56:"includes/views/og_handler_field_group_audience_state.inc";i:10;s:50:"includes/views/og_handler_field_prerender_list.inc";i:11;s:46:"includes/views/og_handler_field_user_roles.inc";i:12;s:53:"includes/views/og_handler_field_group_permissions.inc";i:13;s:48:"includes/views/og_handler_filter_group_state.inc";i:14;s:57:"includes/views/og_handler_filter_group_audience_state.inc";i:15;s:48:"includes/views/og_handler_filter_group_roles.inc";i:16;s:42:"includes/views/og_handler_relationship.inc";i:17;s:57:"includes/views/og_handler_argument_group_audience_gid.inc";i:18;s:21:"includes/og.admin.inc";i:19;s:20:"includes/og.info.inc";i:20;s:21:"includes/og.views.inc";}s:3:"php";s:5:"5.2.4";s:9:"bootstrap";i:0;s:8:"required";b:1;s:11:"explanation";s:80:"Field type(s) in use - see <a href="/d7_dev/admin/reports/fields">Field list</a>";}',
))
->values(array(
  'filename' => 'themes/bartik/bartik.info',
  'name' => 'bartik',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:16:{s:4:"name";s:6:"Bartik";s:11:"description";s:48:"A flexible, recolorable theme with many regions.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:3:{s:14:"css/layout.css";s:28:"themes/bartik/css/layout.css";s:13:"css/style.css";s:27:"themes/bartik/css/style.css";s:14:"css/colors.css";s:28:"themes/bartik/css/colors.css";}s:5:"print";a:1:{s:13:"css/print.css";s:27:"themes/bartik/css/print.css";}}s:7:"regions";a:20:{s:6:"header";s:6:"Header";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:11:"highlighted";s:11:"Highlighted";s:8:"featured";s:8:"Featured";s:7:"content";s:7:"Content";s:13:"sidebar_first";s:13:"Sidebar first";s:14:"sidebar_second";s:14:"Sidebar second";s:14:"triptych_first";s:14:"Triptych first";s:15:"triptych_middle";s:15:"Triptych middle";s:13:"triptych_last";s:13:"Triptych last";s:18:"footer_firstcolumn";s:19:"Footer first column";s:19:"footer_secondcolumn";s:20:"Footer second column";s:18:"footer_thirdcolumn";s:19:"Footer third column";s:19:"footer_fourthcolumn";s:20:"Footer fourth column";s:6:"footer";s:6:"Footer";s:14:"dashboard_main";s:16:"Dashboard (main)";s:17:"dashboard_sidebar";s:19:"Dashboard (sidebar)";s:18:"dashboard_inactive";s:20:"Dashboard (inactive)";}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"0";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:28:"themes/bartik/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:15:"overlay_regions";a:5:{i:0;s:14:"dashboard_main";i:1;s:17:"dashboard_sidebar";i:2;s:18:"dashboard_inactive";i:3;s:7:"content";i:4;s:4:"help";}s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}',
))
->values(array(
  'filename' => 'themes/garland/garland.info',
  'name' => 'garland',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:16:{s:4:"name";s:7:"Garland";s:11:"description";s:111:"A multi-column theme which can be configured to modify colors and switch between fixed and fluid width layouts.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:8:"settings";a:1:{s:13:"garland_width";s:5:"fluid";}s:6:"engine";s:11:"phptemplate";s:7:"regions";a:12:{s:13:"sidebar_first";s:12:"Left sidebar";s:14:"sidebar_second";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";s:11:"highlighted";s:11:"Highlighted";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:14:"dashboard_main";s:16:"Dashboard (main)";s:17:"dashboard_sidebar";s:19:"Dashboard (sidebar)";s:18:"dashboard_inactive";s:20:"Dashboard (inactive)";}s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:15:"overlay_regions";a:5:{i:0;s:14:"dashboard_main";i:1;s:17:"dashboard_sidebar";i:2;s:18:"dashboard_inactive";i:3;s:7:"content";i:4;s:4:"help";}s:14:"regions_hidden";a:2:{i:0;s:8:"page_top";i:1;s:11:"page_bottom";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}',
))
->values(array(
  'filename' => 'themes/seven/seven.info',
  'name' => 'seven',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '1',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => 'a:16:{s:4:"name";s:5:"Seven";s:11:"description";s:65:"A simple one-column, tableless, fluid width administration theme.";s:7:"package";s:4:"Core";s:7:"version";s:8:"7.15-dev";s:4:"core";s:3:"7.x";s:11:"stylesheets";a:1:{s:6:"screen";a:2:{s:9:"reset.css";s:22:"themes/seven/reset.css";s:9:"style.css";s:22:"themes/seven/style.css";}}s:8:"settings";a:1:{s:20:"shortcut_module_link";s:1:"1";}s:7:"regions";a:8:{s:7:"content";s:7:"Content";s:4:"help";s:4:"Help";s:8:"page_top";s:8:"Page top";s:11:"page_bottom";s:11:"Page bottom";s:13:"sidebar_first";s:13:"First sidebar";s:14:"dashboard_main";s:16:"Dashboard (main)";s:17:"dashboard_sidebar";s:19:"Dashboard (sidebar)";s:18:"dashboard_inactive";s:20:"Dashboard (inactive)";}s:14:"regions_hidden";a:3:{i:0;s:13:"sidebar_first";i:1;s:8:"page_top";i:2;s:11:"page_bottom";}s:6:"engine";s:11:"phptemplate";s:8:"features";a:9:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";i:4;s:17:"node_user_picture";i:5;s:20:"comment_user_picture";i:6;s:25:"comment_user_verification";i:7;s:9:"main_menu";i:8;s:14:"secondary_menu";}s:10:"screenshot";s:27:"themes/seven/screenshot.png";s:3:"php";s:5:"5.2.4";s:7:"scripts";a:0:{}s:15:"overlay_regions";a:5:{i:0;s:14:"dashboard_main";i:1;s:17:"dashboard_sidebar";i:2;s:18:"dashboard_inactive";i:3;s:7:"content";i:4;s:4:"help";}s:28:"overlay_supplemental_regions";a:1:{i:0;s:8:"page_top";}}',
))
->values(array(
  'filename' => 'themes/stark/stark.info',
  'name' => 'stark',
  'type' => 'theme',
  'owner' => 'themes/engines/phptemplate/phptemplate.engine',
  'status' => '0',
  'bootstrap' => '0',
  'schema_version' => '-1',
  'weight' => '0',
  'info' => "a:15:{s:4:\"name\";s:5:\"Stark\";s:11:\"description\";s:208:\"This theme demonstrates Drupal's default HTML markup and CSS styles. To learn how to build your own theme and override Drupal's default code, see the <a href=\"http://drupal.org/theme-guide\">Theming Guide</a>.\";s:7:\"package\";s:4:\"Core\";s:7:\"version\";s:8:\"7.15-dev\";s:4:\"core\";s:3:\"7.x\";s:11:\"stylesheets\";a:1:{s:3:\"all\";a:1:{s:10:\"layout.css\";s:23:\"themes/stark/layout.css\";}}s:6:\"engine\";s:11:\"phptemplate\";s:7:\"regions\";a:12:{s:13:\"sidebar_first\";s:12:\"Left sidebar\";s:14:\"sidebar_second\";s:13:\"Right sidebar\";s:7:\"content\";s:7:\"Content\";s:6:\"header\";s:6:\"Header\";s:6:\"footer\";s:6:\"Footer\";s:11:\"highlighted\";s:11:\"Highlighted\";s:4:\"help\";s:4:\"Help\";s:8:\"page_top\";s:8:\"Page top\";s:11:\"page_bottom\";s:11:\"Page bottom\";s:14:\"dashboard_main\";s:16:\"Dashboard (main)\";s:17:\"dashboard_sidebar\";s:19:\"Dashboard (sidebar)\";s:18:\"dashboard_inactive\";s:20:\"Dashboard (inactive)\";}s:8:\"features\";a:9:{i:0;s:4:\"logo\";i:1;s:7:\"favicon\";i:2;s:4:\"name\";i:3;s:6:\"slogan\";i:4;s:17:\"node_user_picture\";i:5;s:20:\"comment_user_picture\";i:6;s:25:\"comment_user_verification\";i:7;s:9:\"main_menu\";i:8;s:14:\"secondary_menu\";}s:10:\"screenshot\";s:27:\"themes/stark/screenshot.png\";s:3:\"php\";s:5:\"5.2.4\";s:7:\"scripts\";a:0:{}s:15:\"overlay_regions\";a:5:{i:0;s:14:\"dashboard_main\";i:1;s:17:\"dashboard_sidebar\";i:2;s:18:\"dashboard_inactive\";i:3;s:7:\"content\";i:4;s:4:\"help\";}s:14:\"regions_hidden\";a:2:{i:0;s:8:\"page_top\";i:1;s:11:\"page_bottom\";}s:28:\"overlay_supplemental_regions\";a:1:{i:0;s:8:\"page_top\";}}",
))
->execute();

db_create_table('taxonomy_index', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'tid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'sticky' => array(
      'type' => 'int',
      'not null' => FALSE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'term_node' => array(
      'tid',
      'sticky',
      'created',
    ),
    'nid' => array(
      'nid',
    ),
  ),
  'foreign keys' => array(
    'tracked_node' => array(
      'table' => 'node',
      'columns' => array(
        'nid' => 'nid',
      ),
    ),
    'term' => array(
      'table' => 'taxonomy_term_data',
      'columns' => array(
        'tid' => 'tid',
      ),
    ),
  ),
  'module' => 'taxonomy',
  'name' => 'taxonomy_index',
));

db_create_table('taxonomy_term_data', array(
  'fields' => array(
    'tid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
      'translatable' => TRUE,
    ),
    'description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
      'translatable' => TRUE,
    ),
    'format' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => FALSE,
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'tid',
  ),
  'foreign keys' => array(
    'vocabulary' => array(
      'table' => 'taxonomy_vocabulary',
      'columns' => array(
        'vid' => 'vid',
      ),
    ),
  ),
  'indexes' => array(
    'taxonomy_tree' => array(
      'vid',
      'weight',
      'name',
    ),
    'vid_name' => array(
      'vid',
      'name',
    ),
    'name' => array(
      'name',
    ),
  ),
  'module' => 'taxonomy',
  'name' => 'taxonomy_term_data',
));

db_create_table('taxonomy_term_hierarchy', array(
  'fields' => array(
    'tid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'parent' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'indexes' => array(
    'parent' => array(
      'parent',
    ),
  ),
  'foreign keys' => array(
    'taxonomy_term_data' => array(
      'table' => 'taxonomy_term_data',
      'columns' => array(
        'tid' => 'tid',
      ),
    ),
  ),
  'primary key' => array(
    'tid',
    'parent',
  ),
  'module' => 'taxonomy',
  'name' => 'taxonomy_term_hierarchy',
));

db_create_table('taxonomy_vocabulary', array(
  'fields' => array(
    'vid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
      'translatable' => TRUE,
    ),
    'machine_name' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
      'translatable' => TRUE,
    ),
    'hierarchy' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'module' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'indexes' => array(
    'list' => array(
      'weight',
      'name',
    ),
  ),
  'unique keys' => array(
    'machine_name' => array(
      'machine_name',
    ),
  ),
  'module' => 'taxonomy',
  'name' => 'taxonomy_vocabulary',
));
db_insert('taxonomy_vocabulary')->fields(array(
  'vid',
  'name',
  'machine_name',
  'description',
  'hierarchy',
  'module',
  'weight',
))
->values(array(
  'vid' => '1',
  'name' => 'Tags',
  'machine_name' => 'tags',
  'description' => 'Use tags to group articles on similar topics into categories.',
  'hierarchy' => '0',
  'module' => 'taxonomy',
  'weight' => '0',
))
->execute();

db_create_table('url_alias', array(
  'fields' => array(
    'pid' => array(
      'type' => 'serial',
      'unsigned' => TRUE,
      'not null' => TRUE,
    ),
    'source' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'alias' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 12,
      'not null' => TRUE,
      'default' => '',
    ),
  ),
  'primary key' => array(
    'pid',
  ),
  'indexes' => array(
    'alias_language_pid' => array(
      'alias',
      'language',
      'pid',
    ),
    'source_language_pid' => array(
      'source',
      'language',
      'pid',
    ),
  ),
  'module' => 'system',
  'name' => 'url_alias',
));

db_create_table('users', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'name' => array(
      'type' => 'varchar',
      'length' => 60,
      'not null' => TRUE,
      'default' => '',
    ),
    'pass' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'mail' => array(
      'type' => 'varchar',
      'length' => 254,
      'not null' => FALSE,
      'default' => '',
    ),
    'theme' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'signature' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => TRUE,
      'default' => '',
    ),
    'signature_format' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => FALSE,
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'access' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'login' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'timezone' => array(
      'type' => 'varchar',
      'length' => 32,
      'not null' => FALSE,
    ),
    'language' => array(
      'type' => 'varchar',
      'length' => 12,
      'not null' => TRUE,
      'default' => '',
    ),
    'picture' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'init' => array(
      'type' => 'varchar',
      'length' => 254,
      'not null' => FALSE,
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
      'serialize' => TRUE,
    ),
  ),
  'indexes' => array(
    'access' => array(
      'access',
    ),
    'created' => array(
      'created',
    ),
    'mail' => array(
      'mail',
    ),
    'picture' => array(
      'picture',
    ),
  ),
  'unique keys' => array(
    'name' => array(
      'name',
    ),
  ),
  'primary key' => array(
    'uid',
  ),
  'foreign keys' => array(
    'signature_format' => array(
      'table' => 'filter_format',
      'columns' => array(
        'signature_format' => 'format',
      ),
    ),
  ),
  'module' => 'user',
  'name' => 'users',
));
db_insert('users')->fields(array(
  'uid',
  'name',
  'pass',
  'mail',
  'theme',
  'signature',
  'signature_format',
  'created',
  'access',
  'login',
  'status',
  'timezone',
  'language',
  'picture',
  'init',
  'data',
))
->values(array(
  'uid' => '0',
  'name' => '',
  'pass' => '',
  'mail' => '',
  'theme' => '',
  'signature' => '',
  'signature_format' => NULL,
  'created' => '0',
  'access' => '0',
  'login' => '0',
  'status' => '0',
  'timezone' => NULL,
  'language' => '',
  'picture' => '0',
  'init' => '',
  'data' => NULL,
))
->values(array(
  'uid' => '1',
  'name' => 'admin',
  'pass' => '$S$DkMu56xRA9WegYX4AGFnnh16cde6IPlKOnuOh3h6G8iBo1qYJKPp',
  'mail' => 'admin@example.com',
  'theme' => '',
  'signature' => '',
  'signature_format' => NULL,
  'created' => '1346694384',
  'access' => '1346694876',
  'login' => '1346694498',
  'status' => '1',
  'timezone' => 'Asia/Jerusalem',
  'language' => '',
  'picture' => '0',
  'init' => 'admin@example.com',
  'data' => 'b:0;',
))
->values(array(
  'uid' => '2',
  'name' => 'stivouodro',
  'pass' => '',
  'mail' => 'stivouodro@default',
  'theme' => '',
  'signature' => '',
  'signature_format' => NULL,
  'created' => '1346694751',
  'access' => '0',
  'login' => '0',
  'status' => '1',
  'timezone' => NULL,
  'language' => 'und',
  'picture' => '1',
  'init' => '',
  'data' => NULL,
))
->values(array(
  'uid' => '3',
  'name' => 'joshewro',
  'pass' => '',
  'mail' => 'joshewro@default',
  'theme' => '',
  'signature' => '',
  'signature_format' => NULL,
  'created' => '1346694751',
  'access' => '0',
  'login' => '0',
  'status' => '1',
  'timezone' => NULL,
  'language' => 'und',
  'picture' => '2',
  'init' => '',
  'data' => NULL,
))
->values(array(
  'uid' => '4',
  'name' => 'sikiuagenuvi',
  'pass' => '',
  'mail' => 'sikiuagenuvi@default',
  'theme' => '',
  'signature' => '',
  'signature_format' => NULL,
  'created' => '1346694751',
  'access' => '0',
  'login' => '0',
  'status' => '1',
  'timezone' => NULL,
  'language' => 'und',
  'picture' => '3',
  'init' => '',
  'data' => NULL,
))
->values(array(
  'uid' => '5',
  'name' => 'swemudru',
  'pass' => '',
  'mail' => 'swemudru@default',
  'theme' => '',
  'signature' => '',
  'signature_format' => NULL,
  'created' => '1346694751',
  'access' => '0',
  'login' => '0',
  'status' => '1',
  'timezone' => NULL,
  'language' => 'und',
  'picture' => '4',
  'init' => '',
  'data' => NULL,
))
->values(array(
  'uid' => '6',
  'name' => 'pheleloclapi',
  'pass' => '',
  'mail' => 'pheleloclapi@default',
  'theme' => '',
  'signature' => '',
  'signature_format' => NULL,
  'created' => '1346694751',
  'access' => '0',
  'login' => '0',
  'status' => '1',
  'timezone' => NULL,
  'language' => 'und',
  'picture' => '5',
  'init' => '',
  'data' => NULL,
))
->values(array(
  'uid' => '7',
  'name' => 'stushan',
  'pass' => '',
  'mail' => 'stushan@default',
  'theme' => '',
  'signature' => '',
  'signature_format' => NULL,
  'created' => '1346694751',
  'access' => '0',
  'login' => '0',
  'status' => '1',
  'timezone' => NULL,
  'language' => 'und',
  'picture' => '6',
  'init' => '',
  'data' => 'b:0;',
))
->values(array(
  'uid' => '8',
  'name' => 'kivothikus',
  'pass' => '',
  'mail' => 'kivothikus@default',
  'theme' => '',
  'signature' => '',
  'signature_format' => NULL,
  'created' => '1346694751',
  'access' => '0',
  'login' => '0',
  'status' => '1',
  'timezone' => NULL,
  'language' => 'und',
  'picture' => '7',
  'init' => '',
  'data' => NULL,
))
->values(array(
  'uid' => '9',
  'name' => 'prisothoke',
  'pass' => '',
  'mail' => 'prisothoke@default',
  'theme' => '',
  'signature' => '',
  'signature_format' => NULL,
  'created' => '1346694751',
  'access' => '0',
  'login' => '0',
  'status' => '1',
  'timezone' => NULL,
  'language' => 'und',
  'picture' => '8',
  'init' => '',
  'data' => NULL,
))
->values(array(
  'uid' => '10',
  'name' => 'nuweprosl',
  'pass' => '',
  'mail' => 'nuweprosl@default',
  'theme' => '',
  'signature' => '',
  'signature_format' => NULL,
  'created' => '1346694751',
  'access' => '0',
  'login' => '0',
  'status' => '1',
  'timezone' => NULL,
  'language' => 'und',
  'picture' => '9',
  'init' => '',
  'data' => NULL,
))
->values(array(
  'uid' => '11',
  'name' => 'fruswavo',
  'pass' => '',
  'mail' => 'fruswavo@default',
  'theme' => '',
  'signature' => '',
  'signature_format' => NULL,
  'created' => '1346694751',
  'access' => '0',
  'login' => '0',
  'status' => '1',
  'timezone' => NULL,
  'language' => 'und',
  'picture' => '10',
  'init' => '',
  'data' => 'b:0;',
))
->execute();

db_create_table('users_roles', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
    'rid' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'uid',
    'rid',
  ),
  'indexes' => array(
    'rid' => array(
      'rid',
    ),
  ),
  'foreign keys' => array(
    'user' => array(
      'table' => 'users',
      'columns' => array(
        'uid' => 'uid',
      ),
    ),
    'role' => array(
      'table' => 'roles',
      'columns' => array(
        'rid' => 'rid',
      ),
    ),
  ),
  'module' => 'user',
  'name' => 'users_roles',
));
db_insert('users_roles')->fields(array(
  'uid',
  'rid',
))
->values(array(
  'uid' => '1',
  'rid' => '3',
))
->execute();

db_create_table('variable', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'value' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'big',
      'translatable' => TRUE,
    ),
  ),
  'primary key' => array(
    'name',
  ),
  'module' => 'system',
  'name' => 'variable',
));
db_insert('variable')->fields(array(
  'name',
  'value',
))
->values(array(
  'name' => 'additional_settings__active_tab_class',
  'value' => 's:10:"edit-group";',
))
->values(array(
  'name' => 'additional_settings__active_tab_school',
  'value' => 's:10:"edit-group";',
))
->values(array(
  'name' => 'admin_theme',
  'value' => 's:5:"seven";',
))
->values(array(
  'name' => 'clean_url',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'comment_anonymous_class',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_anonymous_school',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_class',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'comment_default_mode_class',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_mode_school',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_default_per_page_class',
  'value' => 's:2:"50";',
))
->values(array(
  'name' => 'comment_default_per_page_school',
  'value' => 's:2:"50";',
))
->values(array(
  'name' => 'comment_form_location_class',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_form_location_school',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_page',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'comment_preview_class',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_preview_school',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'comment_school',
  'value' => 's:1:"2";',
))
->values(array(
  'name' => 'comment_subject_field_class',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'comment_subject_field_school',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'cron_key',
  'value' => 's:43:"x4K2IlCpXZA2g0LeV0QIp-1DLhs5gC31s1sStJwZKZs";',
))
->values(array(
  'name' => 'cron_last',
  'value' => 'i:1346694384;',
))
->values(array(
  'name' => 'css_js_query_string',
  'value' => 's:6:"m9sc1c";',
))
->values(array(
  'name' => 'date_default_timezone',
  'value' => 's:14:"Asia/Jerusalem";',
))
->values(array(
  'name' => 'drupal_http_request_fails',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'drupal_private_key',
  'value' => 's:43:"ezABgIWHpLCb30pQojPyU0b0NTykWutRXREhghnDR6M";',
))
->values(array(
  'name' => 'file_temporary_path',
  'value' => 's:26:"/Applications/MAMP/tmp/php";',
))
->values(array(
  'name' => 'filter_fallback_format',
  'value' => 's:10:"plain_text";',
))
->values(array(
  'name' => 'install_profile',
  'value' => 's:8:"standard";',
))
->values(array(
  'name' => 'install_task',
  'value' => 's:4:"done";',
))
->values(array(
  'name' => 'install_time',
  'value' => 'i:1346694384;',
))
->values(array(
  'name' => 'menu_expanded',
  'value' => 'a:0:{}',
))
->values(array(
  'name' => 'menu_masks',
  'value' => 'a:41:{i:0;i:501;i:1;i:493;i:2;i:251;i:3;i:250;i:4;i:247;i:5;i:246;i:6;i:245;i:7;i:241;i:8;i:125;i:9;i:124;i:10;i:123;i:11;i:122;i:12;i:121;i:13;i:117;i:14;i:79;i:15;i:63;i:16;i:62;i:17;i:61;i:18;i:60;i:19;i:59;i:20;i:58;i:21;i:44;i:22;i:39;i:23;i:31;i:24;i:30;i:25;i:29;i:26;i:28;i:27;i:24;i:28;i:21;i:29;i:19;i:30;i:15;i:31;i:14;i:32;i:13;i:33;i:11;i:34;i:9;i:35;i:7;i:36;i:6;i:37;i:5;i:38;i:3;i:39;i:2;i:40;i:1;}',
))
->values(array(
  'name' => 'menu_options_class',
  'value' => 'a:1:{i:0;s:9:"main-menu";}',
))
->values(array(
  'name' => 'menu_options_school',
  'value' => 'a:1:{i:0;s:9:"main-menu";}',
))
->values(array(
  'name' => 'menu_parent_class',
  'value' => 's:11:"main-menu:0";',
))
->values(array(
  'name' => 'menu_parent_school',
  'value' => 's:11:"main-menu:0";',
))
->values(array(
  'name' => 'node_admin_theme',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'node_options_class',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:7:"promote";}',
))
->values(array(
  'name' => 'node_options_page',
  'value' => 'a:1:{i:0;s:6:"status";}',
))
->values(array(
  'name' => 'node_options_school',
  'value' => 'a:2:{i:0;s:6:"status";i:1;s:7:"promote";}',
))
->values(array(
  'name' => 'node_preview_class',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'node_preview_school',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'node_submitted_class',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'node_submitted_page',
  'value' => 'b:0;',
))
->values(array(
  'name' => 'node_submitted_school',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'og_group_content_type_school',
  'value' => 's:7:"omitted";',
))
->values(array(
  'name' => 'og_group_type_class',
  'value' => 's:7:"omitted";',
))
->values(array(
  'name' => 'path_alias_whitelist',
  'value' => 'a:0:{}',
))
->values(array(
  'name' => 'save_continue_class',
  'value' => 's:19:"Save and add fields";',
))
->values(array(
  'name' => 'save_continue_school',
  'value' => 's:19:"Save and add fields";',
))
->values(array(
  'name' => 'site_default_country',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'site_mail',
  'value' => 's:17:"admin@example.com";',
))
->values(array(
  'name' => 'site_name',
  'value' => 's:12:"Site-Install";',
))
->values(array(
  'name' => 'theme_default',
  'value' => 's:6:"bartik";',
))
->values(array(
  'name' => 'update_last_check',
  'value' => 'i:1346694409;',
))
->values(array(
  'name' => 'update_notify_emails',
  'value' => 'a:1:{i:0;s:17:"admin@example.com";}',
))
->values(array(
  'name' => 'user_admin_role',
  'value' => 's:1:"3";',
))
->values(array(
  'name' => 'user_pictures',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'user_picture_dimensions',
  'value' => 's:9:"1024x1024";',
))
->values(array(
  'name' => 'user_picture_file_size',
  'value' => 's:3:"800";',
))
->values(array(
  'name' => 'user_picture_style',
  'value' => 's:9:"thumbnail";',
))
->values(array(
  'name' => 'user_register',
  'value' => 'i:2;',
))
->execute();

db_create_table('watchdog', array(
  'fields' => array(
    'wid' => array(
      'type' => 'serial',
      'not null' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
    'type' => array(
      'type' => 'varchar',
      'length' => 64,
      'not null' => TRUE,
      'default' => '',
    ),
    'message' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'variables' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'big',
    ),
    'severity' => array(
      'type' => 'int',
      'unsigned' => TRUE,
      'not null' => TRUE,
      'default' => 0,
      'size' => 'tiny',
    ),
    'link' => array(
      'type' => 'varchar',
      'length' => 255,
      'not null' => FALSE,
      'default' => '',
    ),
    'location' => array(
      'type' => 'text',
      'not null' => TRUE,
    ),
    'referer' => array(
      'type' => 'text',
      'not null' => FALSE,
    ),
    'hostname' => array(
      'type' => 'varchar',
      'length' => 128,
      'not null' => TRUE,
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'default' => 0,
    ),
  ),
  'primary key' => array(
    'wid',
  ),
  'indexes' => array(
    'type' => array(
      'type',
    ),
    'uid' => array(
      'uid',
    ),
  ),
  'module' => 'dblog',
  'name' => 'watchdog',
));

