# TLS-e IPA Server Configuration Roles

## Included Roles

This directory includes 3 playbooks (`ipa-server-*.yaml`) to be used for the TripleO TLS-e configuration of a FreeIPA server.  The playbooks need to be run in the order that follows, however certain playbooks only need to be run once per IPA server:

---
1. `ipa-sever-create-role.yaml` The purpose of this playbook is to create a role on the IPA server with the appropriate permissions and privileges to add and remove hosts, principals, services and dns entries.
> Currently this playbook is required to be executed on an IPA client host with an active Kerberos token.

> This playbook only needs to be run once per IPA server.
---
2. `ipa-server-register-undercloud.yaml` This playbook registers the undercloud host as an IPA client and provides a one time password(OTP) to the operator for use in the undercloud configuration.  An example of the final output of a successful run of this play will look like this:
```
TASK [provide OTP generated by IPA server] ****************************
ok: [localhost] => {
    "msg": [
        "The OTP provided by the IPA server is 9Ok~JEz!ul;&Sf:V<FOi-+",
        "Please add the following to your undercloud.conf:",
        "ipa_otp = 9Ok~JEz!ul;&Sf:V<FOi-+"
    ]
}
```
> This playbook does not require an active Kerberos token.

> This playbook needs to be run once per openstack deployment.
---
3. `ipa-server-create-principal.yaml` This playbook creates the nova user for the undercloud host created with `ipa-register-undercloud.yaml` and adds it to the Nova Host Manager IPA role created by `ipa-server-create-role.yaml`.
> This playbook does not require an active Kerberos token.

> This playbook needs to be run once per openstack deployment.
---
## Environment/Ansible variables
The playbooks currently require the following variables to be set.  These can either be environment variables or ansible variables passed either in a file or on the command line with the `-e` argument to the `ansible-playbook` command.

### `ENVIRONMENT/ansible` variable
* `tripleo_ipa_host` this is the host which ansible will connect to for playbook execution, this is the host that needs to be an IPA client.  Defaults to `localhost`.
* `IPA_PRINCIPAL/tripleo_ipa_principal` is the IPA username with appropriate permissions and privileges to add roles and privileges. This value is required and has no default.
* `IPA_PASSWORD/tripleo_ipa_password` is the password for the IPA_PRINCIPAL.  This value is required and has no default.
* `UNDERCLOUD_FQDN/tripleo_undercloud_fqdn` is the fully qualified domain name of the undercloud host.  This value is required and has no default.

#### Example environment variables
```bash
export IPA_PRINCIPAL=admin
export IPA_PASSWORD=password
export UNDERCLOUD_FQDN=undercloud.ooo.test
```

#### Example ansible variables file
```yaml
---
tripleo_ipa_principal: admin
tripleo_ipa_password: password
tripleo_undercloud_fqdn: undercloud.ooo.test
```
