# Copyright 2015 Mirantis, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from ironic.drivers import base
from ironic.drivers.modules import ipmitool
from ironic.drivers.modules import lib_virt
from ironic.drivers.modules import ssh

from ironic_fa_deploy.modules import fuel_agent


class FuelAndIPMIToolDriver(base.BaseDriver):
    """Fuel + IPMITool driver.

    This driver implements the `core` functionality, combining
    :class:`ironic.drivers.modules.ipmitool.IPMIPower` (for power on/off and
    reboot) with :class:`ironic.drivers.modules.fuel_agent.FuelAgentDeploy`
    (for image deployment).
    Implementations are in those respective classes; this class is merely the
    glue between them.
    """

    def __init__(self):
        self.power = ipmitool.IPMIPower()
        self.deploy = fuel_agent.FuelAgentDeploy()
        self.management = ipmitool.IPMIManagement()
        self.console = ipmitool.IPMIShellinaboxConsole()
        self.vendor = fuel_agent.FuelAgentVendor()


class FuelAndSSHDriver(base.BaseDriver):
    """Fuel + SSH driver.

    NOTE: This driver is meant only for testing environments.

    This driver implements the `core` functionality, combining
    :class:`ironic.drivers.modules.ssh.SSH` (for power on/off and reboot of
    virtual machines tunneled over SSH), with
    :class:`ironic.drivers.modules.fuel_agent.FuelAgentDeploy` (for image
    deployment). Implementations are in those respective classes; this class
    is merely the glue between them.
    """

    def __init__(self):
        self.power = ssh.SSHPower()
        self.deploy = fuel_agent.FuelAgentDeploy()
        self.management = ssh.SSHManagement()
        self.vendor = fuel_agent.FuelAgentVendor()


class FuelAndLibvirtDriver(base.BaseDriver):
    """Fuel + Libvirt driver.

    NOTE: This driver is meant only for testing environments.

    This driver implements the `core` functionality, combining
    :class:`ironic.drivers.modules.lib_virt.Libvirt` (for power on/off and reboot of
    virtual machines tunneled over Libvirt API, with
    :class:`ironic.drivers.modules.fuel_agent.FuelAgentDeploy` (for image
    deployment). Implementations are in those respective classes; this class
    is merely the glue between them.
    """

    def __init__(self):
        self.power = lib_virt.LibvirtPower()
        self.deploy = fuel_agent.FuelAgentDeploy()
        self.management = lib_virt.LibvirtManagement()
        self.vendor = fuel_agent.FuelAgentVendor()
