#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

# Server Specific Configurations
server = {
    'port': '8080',
    'host': '0.0.0.0'
}

# Pecan Application Configurations
app = {
    'root': 'root_controller.RootController',
    'modules': ['v1'],
    'debug': True,
    'errors': {
        404: '/error/404',
        '__force_dict__': True
    }
}

logging = {
    'root': {'level': 'INFO', 'handlers': ['console', 'logfile']},
    'loggers': {
        'pecanlog': {'level': 'INFO',
                     'handlers': ['console', 'logfile'],
                     'propagate': False},
        'pecan': {'level': 'INFO',
                  'handlers': ['console', 'logfile'],
                  'propagate': False},
        'py.warnings': {'handlers': ['console', 'logfile']},
        '__force_dict__': True
    },
    'handlers': {
        'console': {
            'level': 'INFO',
            'class': 'logging.StreamHandler',
            'formatter': 'color'
        },
        'logfile': {
            'class': 'logging.FileHandler',
            'filename': '/var/log/nfp/nfp_pecan.log',
            'level': 'INFO'
        }
    },
    'formatters': {
        'simple': {
            'format': ('%(asctime)s %(levelname)-5.5s [%(name)s]'
                       '[%(threadName)s] %(message)s')
        },
        'color': {
            '()': 'pecan.log.ColorFormatter',
            'format': ('%(asctime)s [%(padded_color_levelname)s] [%(name)s]'
                       '[%(threadName)s] %(message)s'),
            '__force_dict__': True
        }
    }
}

cloud_services = [
    {'service_name': 'configurator',
     'topic': 'configurator',  # configurator rpc topic
     'reporting_interval': '10',  # in seconds
     'apis': ['CONFIGURATION'],
     # notifications from configurator to UTC components
     'notifications': {'host': '127.0.0.1',
                       'queue': 'configurator-notifications'
                       }
     },
]
