# Copyright 2015 OpenStack Foundation
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.
#

"""create fortigate tables

Revision ID: 38462bfd9dc
Revises: None
Create Date: 2015-12-01 14:26:02.305436

"""

# revision identifiers, used by Alembic.
revision = '38462bfd9dc'
down_revision = None

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('fortinet_fw_rule_associations')
    op.drop_table('fortinet_firewall_vips')
    op.drop_table('fortinet_firewall_policies')
    op.drop_table('fortinet_ml2_subnets')
    op.drop_table('fortinet_firewall_ippools')
    op.drop_table('fortinet_static_routers')
    op.drop_table('fortinet_interface_subips')
    op.drop_table('fortinet_floatingip_allocations')
    op.drop_table('fortinet_vlink_ip_allocations')
    op.drop_table('fortinet_vlink_vlan_allocations')
    op.drop_table('fortinet_vdom_vlinks')
    op.drop_table('fortinet_ml2_namespaces')
    op.drop_table('fortinet_firewall_addresses')
    op.drop_table('fortinet_ml2_reservedips')
    op.drop_table('fortinet_interfaces')
    ### end Alembic commands ###


def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table('fortinet_interfaces',
        sa.Column('name', mysql.VARCHAR(length=36),
                  server_default=sa.text(u"''"), nullable=False),
        sa.Column('vdom', mysql.VARCHAR(length=11), nullable=True),
        sa.Column('vlanid', mysql.INTEGER(display_width=11),
                  autoincrement=False, nullable=True),
        sa.Column('interface', mysql.VARCHAR(length=11), nullable=True),
        sa.Column('type', mysql.VARCHAR(length=32),
                  server_default=sa.text(u"'vlan'"), nullable=True),
        sa.Column('ip', mysql.VARCHAR(length=32), nullable=True),
        sa.Column('secondary_ip', mysql.VARCHAR(length=11),
                  server_default=sa.text(u"'enable'"), nullable=True),
        sa.Column('alias', mysql.VARCHAR(length=32), nullable=True),
        sa.Column('network_id', mysql.VARCHAR(length=36), nullable=True),
        sa.PrimaryKeyConstraint('name')
    )
    op.create_table('fortinet_ml2_reservedips',
        sa.Column('port_id', mysql.VARCHAR(length=36), nullable=False),
        sa.Column('subnet_id', mysql.VARCHAR(length=36), nullable=False),
        sa.Column('mac', mysql.VARCHAR(length=32), nullable=False),
        sa.Column('ip', mysql.VARCHAR(length=32), nullable=False),
        sa.Column('vdom', mysql.VARCHAR(length=11), nullable=True),
        sa.Column('edit_id', mysql.INTEGER(display_width=11),
                  autoincrement=False, nullable=True),
        sa.PrimaryKeyConstraint('port_id')
    )
    op.create_table('fortinet_firewall_addresses',
        sa.Column('name', mysql.VARCHAR(length=40),
                  server_default=sa.text(u"''"), nullable=False),
        sa.Column('vdom', mysql.VARCHAR(length=11), nullable=True),
        sa.Column('subnet', mysql.VARCHAR(length=32), nullable=True),
        sa.Column('associated_interface', mysql.VARCHAR(length=11),
                  nullable=True),
        sa.Column('group', mysql.VARCHAR(length=32), nullable=True),
        sa.PrimaryKeyConstraint('name', 'vdom')
    )
    op.create_table('fortinet_ml2_namespaces',
        sa.Column('id', mysql.INTEGER(display_width=11), nullable=False,
                  autoincrement=True),
        sa.Column('tenant_id', mysql.VARCHAR(length=36), nullable=False),
        sa.Column('vdom', mysql.VARCHAR(length=11), nullable=True),
        sa.PrimaryKeyConstraint('id', 'tenant_id')
    )
    op.create_table('fortinet_vdom_vlinks',
        sa.Column('name', mysql.VARCHAR(length=11)),
        sa.Column('vdom', mysql.VARCHAR(length=11)),
        sa.PrimaryKeyConstraint('name', 'vdom')
    )
    op.create_table('fortinet_vlink_vlan_allocations',
        sa.Column('id', mysql.VARCHAR(length=36),
                  server_default=sa.text(u"''"), nullable=False),
        sa.Column('vdom', mysql.VARCHAR(length=11), nullable=True),
        sa.Column('inf_name_int_vdom', mysql.VARCHAR(length=11),
                  nullable=True),
        sa.Column('inf_name_ext_vdom', mysql.VARCHAR(length=11),
                  nullable=True),
        sa.Column('vlanid', mysql.INTEGER(display_width=11)),
        sa.Column('allocated', mysql.TINYINT(display_width=1),
                  autoincrement=False, nullable=True),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_table('fortinet_vlink_ip_allocations',
        sa.Column('vlink_ip_subnet', mysql.VARCHAR(length=32),
                  nullable=False),
        sa.Column('vdom', mysql.VARCHAR(length=11), nullable=True),
        sa.Column('vlink_id', mysql.VARCHAR(length=36), nullable=True),
        sa.Column('allocated', mysql.TINYINT(display_width=1),
                  autoincrement=False, nullable=True),
        sa.ForeignKeyConstraint(['vlink_id'],
                                ['fortinet_vlink_vlan_allocations.id'],
                                ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('vlink_ip_subnet')
    )
    op.create_table('fortinet_floatingip_allocations',
        sa.Column('ip_subnet', mysql.VARCHAR(length=32),
                  server_default=sa.text(u"''"), nullable=False),
        sa.Column('vdom', mysql.VARCHAR(length=11), nullable=True),
        sa.Column('floating_ip_address', mysql.VARCHAR(length=36),
                  nullable=True),
        sa.Column('vip_name', mysql.VARCHAR(length=50), nullable=True),
        sa.Column('allocated', mysql.TINYINT(display_width=1),
                  autoincrement=False, nullable=True),
        sa.PrimaryKeyConstraint('ip_subnet')
    )
    op.create_table('fortinet_interface_subips',
        sa.Column('ip', mysql.VARCHAR(length=32),
                  server_default=sa.text(u"''"), nullable=False),
        sa.Column('name', mysql.VARCHAR(length=11), nullable=True),
        sa.Column('vdom', mysql.VARCHAR(length=11), nullable=True),
        sa.PrimaryKeyConstraint('ip')
    )
    op.create_table('fortinet_static_routers',
        sa.Column('id', mysql.VARCHAR(length=36),
                  server_default=sa.text(u"''"), nullable=False),
        sa.Column('subnet_id', mysql.VARCHAR(length=36), nullable=True),
        sa.Column('vdom', mysql.VARCHAR(length=11), nullable=True),
        sa.Column('dst', mysql.VARCHAR(length=32), nullable=True),
        sa.Column('device', mysql.VARCHAR(length=32), nullable=True),
        sa.Column('gateway', mysql.VARCHAR(length=32), nullable=True),
        sa.Column('edit_id', mysql.INTEGER(display_width=11),
                  autoincrement=False, nullable=True),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_table('fortinet_firewall_ippools',
        sa.Column('name', mysql.VARCHAR(length=36),
                  server_default=sa.text(u"''"), nullable=False),
        sa.Column('vdom', mysql.VARCHAR(length=11), nullable=True),
        sa.Column('startip', mysql.VARCHAR(length=32), nullable=True),
        sa.Column('endip', mysql.VARCHAR(length=32), nullable=True),
        sa.Column('type', mysql.VARCHAR(length=32),
                  server_default=sa.text(u"'one-to-one'"), nullable=True),
        sa.Column('comments', mysql.VARCHAR(length=32), nullable=True),
        sa.PrimaryKeyConstraint('name')
    )
    op.create_table('fortinet_ml2_subnets',
        sa.Column('subnet_id', mysql.VARCHAR(length=36), nullable=False),
        sa.Column('vdom', mysql.VARCHAR(length=11), nullable=True),
        sa.Column('interface', mysql.VARCHAR(length=32), nullable=True),
        sa.Column('gateway', mysql.VARCHAR(length=32), nullable=True),
        sa.Column('netmask', mysql.VARCHAR(length=32), nullable=True),
        sa.Column('start_ip', mysql.VARCHAR(length=32), nullable=True),
        sa.Column('end_ip', mysql.VARCHAR(length=32), nullable=True),
        sa.Column('edit_id', mysql.INTEGER(display_width=11),
                  autoincrement=False, nullable=True),
        sa.PrimaryKeyConstraint('subnet_id')
    )
    op.create_table('fortinet_firewall_policies',
        sa.Column('id', mysql.VARCHAR(length=36),
                  server_default=sa.text(u"''"), nullable=False),
        sa.Column('vdom', mysql.VARCHAR(length=11), nullable=True),
        sa.Column('srcintf', mysql.VARCHAR(length=11), nullable=True),
        sa.Column('dstintf', mysql.VARCHAR(length=11), nullable=True),
        sa.Column('srcaddr', mysql.VARCHAR(length=40),
                  server_default=sa.text(u"'all'"), nullable=True),
        sa.Column('dstaddr', mysql.VARCHAR(length=40),
                  server_default=sa.text(u"'all'"), nullable=True),
        sa.Column('poolname', mysql.VARCHAR(length=32), nullable=True),
        sa.Column('nat', mysql.VARCHAR(length=7),
                  server_default=sa.text(u"'disable'"), nullable=True),
        sa.Column('action', mysql.VARCHAR(length=11),
                  server_default=sa.text(u"'accept'"), nullable=True),
        sa.Column('service', mysql.VARCHAR(length=36),
                  server_default=sa.text(u"'ALL'"), nullable=True),
        sa.Column('match_vip', mysql.VARCHAR(length=7),
                  server_default=sa.text(u"'disable'"), nullable=True),
        sa.Column('status', mysql.VARCHAR(length=7),
                  server_default=sa.text(u"'enable'"), nullable=True),
        sa.Column('av_profile', mysql.VARCHAR(length=35), nullable=True),
        sa.Column('webfilter_profile', mysql.VARCHAR(length=35),
                  nullable=True),
        sa.Column('ips_sensor', mysql.VARCHAR(length=35), nullable=True),
        sa.Column('application_list', mysql.VARCHAR(length=35), nullable=True),
        sa.Column('ssl_ssh_profile', mysql.VARCHAR(length=35), nullable=True),
        sa.Column('comments', mysql.VARCHAR(length=255), nullable=True),
        sa.Column('edit_id', mysql.INTEGER(display_width=11),
                  autoincrement=False, nullable=True),
        sa.PrimaryKeyConstraint('id')
    )
    op.create_table('fortinet_firewall_vips',
        sa.Column('name', mysql.VARCHAR(length=36), nullable=False),
        sa.Column('vdom', mysql.VARCHAR(length=32), nullable=False),
        sa.Column('extip', mysql.VARCHAR(length=32), nullable=False),
        sa.Column('extintf', mysql.VARCHAR(length=32), nullable=False),
        sa.Column('mappedip', mysql.VARCHAR(length=32), nullable=True),
        sa.PrimaryKeyConstraint('name', 'vdom')
    )
    op.create_table('fortinet_fw_rule_associations',
        sa.Column('fwr_id', mysql.VARCHAR(length=36),
                  server_default=sa.text(u"''"), nullable=False),
        sa.Column('fortinet_pid', mysql.VARCHAR(length=36),
                  server_default=sa.text(u"''"), nullable=False),
        sa.Column('type', mysql.VARCHAR(length=36),
                  server_default=sa.text(u"''"), nullable=False),
        sa.Column('floatingip_id', mysql.VARCHAR(length=36),
                  server_default=sa.text(u"''"), nullable=True),
        sa.ForeignKeyConstraint(['floatingip_id'], ['floatingips.id'],
            ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('fwr_id', 'fortinet_pid')
    )
    ### end Alembic commands ###
