# Copyright 2019 Intel, Inc.
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

event_subscription_req_schema = {
    "type": "object",
    "properties": {
        "Name": {"type": "string"},
        "Destination": {"type": "string"},
        "EventTypes": {
            "type": "array",
            "items": {
                "type": "string",
                "enum": [
                    "ResourceAdded",
                    "ResourceRemoved",
                    "StatusChange",
                    "ResourceUpdated",
                    "Alert",
                ],
            },
        },
        "Context": {"type": "string"},
        "Protocol": {"type": "string", "enum": ["Redfish"]},
        "OriginResources": {
            "type": "array",
            "items": {
                "type": "object",
                "properties": {"@odata.id": {"type": "string"}},
            },
        },
    },
    "additionalProperties": False,
}
